import type { Node } from 'estree';
import BaseJSNode from './nodes/BaseJSNode.js';
export type Listener = (node: Node, visitor: Visitor) => any;
export default class Visitor {
    #private;
    scope: Map<string, any>;
    listeners: {
        [key: string]: Listener;
    };
    ast: Node[];
    setAST(ast: Node[]): void;
    run(): any;
    /**
     * Visits a given node and executes it.
     */
    visitNode<T extends BaseJSNode>(node?: Node | null): ReturnType<T['run']> | null;
    /**
     * Gets the name of a node.
     * @param node - The target node.
     */
    getName(node: Node): string | undefined;
    /**
     * Listens for node calls. Can be used to override default behavior or add new functionality.
     * @param node_name - The node to listen for.
     * @param listener - The callback function.
     */
    on(node_name: string, listener: Listener): void;
}
