/* eslint-disable */
var __defProp = Object.defineProperty;
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
var __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj));
var __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateSet = (obj, member, value, setter) => (__accessCheck(obj, member, "write to private field"), setter ? setter.call(obj, value) : member.set(obj, value), value);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
var __privateWrapper = (obj, member, setter, getter) => ({
  set _(value) {
    __privateSet(obj, member, value, setter);
  },
  get _() {
    return __privateGet(obj, member, getter);
  }
});

// dist/src/utils/Utils.js
var Utils_exports = {};
__export(Utils_exports, {
  ChannelError: () => ChannelError,
  InnertubeError: () => InnertubeError,
  MissingParamError: () => MissingParamError,
  OAuth2Error: () => OAuth2Error,
  ParsingError: () => ParsingError,
  Platform: () => Platform,
  PlayerError: () => PlayerError,
  SessionError: () => SessionError,
  base64ToU8: () => base64ToU8,
  concatMemos: () => concatMemos,
  debugFetch: () => debugFetch,
  deepCompare: () => deepCompare,
  escapeStringRegexp: () => escapeStringRegexp,
  findFunction: () => findFunction,
  findVariable: () => findVariable,
  generateRandomString: () => generateRandomString,
  generateSidAuth: () => generateSidAuth,
  getCookie: () => getCookie,
  getRandomUserAgent: () => getRandomUserAgent,
  getStringBetweenStrings: () => getStringBetweenStrings,
  hasKeys: () => hasKeys,
  isTextRun: () => isTextRun,
  streamToIterable: () => streamToIterable,
  throwIfMissing: () => throwIfMissing,
  timeToSeconds: () => timeToSeconds,
  u8ToBase64: () => u8ToBase64
});

// node_modules/jintr/dist/nodes/index.js
var nodes_exports = {};
__export(nodes_exports, {
  ArrayExpression: () => ArrayExpression,
  ArrowFunctionExpression: () => ArrowFunctionExpression,
  AssignmentExpression: () => AssignmentExpression,
  BinaryExpression: () => BinaryExpression,
  BlockStatement: () => BlockStatement,
  BreakStatement: () => BreakStatement,
  CallExpression: () => CallExpression,
  ConditionalExpression: () => ConditionalExpression,
  ContinueStatement: () => ContinueStatement,
  EmptyStatement: () => EmptyStatement,
  ExpressionStatement: () => ExpressionStatement,
  ForOfStatement: () => ForOfStatement,
  ForStatement: () => ForStatement,
  FunctionDeclaration: () => FunctionDeclaration,
  FunctionExpression: () => FunctionExpression,
  Identifier: () => Identifier,
  IfStatement: () => IfStatement,
  Literal: () => Literal,
  LogicalExpression: () => LogicalExpression,
  MemberExpression: () => MemberExpression,
  NewExpression: () => NewExpression,
  ObjectExpression: () => ObjectExpression,
  Property: () => Property,
  ReturnStatement: () => ReturnStatement,
  SequenceExpression: () => SequenceExpression,
  SwitchCase: () => SwitchCase,
  SwitchStatement: () => SwitchStatement,
  TemplateLiteral: () => TemplateLiteral,
  ThisExpression: () => ThisExpression,
  ThrowStatement: () => ThrowStatement,
  TryStatement: () => TryStatement,
  UnaryExpression: () => UnaryExpression,
  UpdateExpression: () => UpdateExpression,
  VariableDeclaration: () => VariableDeclaration,
  WhileStatement: () => WhileStatement
});

// node_modules/jintr/dist/nodes/BaseJSNode.js
var _BaseJSNode = class _BaseJSNode {
  constructor(node, visitor) {
    this.node = node;
    this.visitor = visitor;
  }
  run() {
  }
};
__name(_BaseJSNode, "BaseJSNode");
var BaseJSNode = _BaseJSNode;

// node_modules/jintr/dist/nodes/ArrayExpression.js
var _ArrayExpression = class _ArrayExpression extends BaseJSNode {
  run() {
    return this.node.elements.map((el) => this.visitor.visitNode(el));
  }
};
__name(_ArrayExpression, "ArrayExpression");
var ArrayExpression = _ArrayExpression;

// node_modules/jintr/dist/utils/index.js
var namedFunction = /* @__PURE__ */ __name((name, fn) => Object.defineProperty(fn, "name", { value: name }), "namedFunction");
var _JinterError = class _JinterError extends Error {
  constructor(message, info2) {
    super(message);
    if (info2) {
      this.info = info2;
    }
  }
};
__name(_JinterError, "JinterError");
var JinterError = _JinterError;

// node_modules/jintr/dist/nodes/ArrowFunctionExpression.js
var _ArrowFunctionExpression = class _ArrowFunctionExpression extends BaseJSNode {
  run() {
    const { params, body } = this.node;
    const fn = namedFunction("anonymous function", (args) => {
      let index = 0;
      for (const param of params) {
        this.visitor.visitNode(param);
        if (param.type === "Identifier") {
          this.visitor.scope.set(param.name, args[index]);
        } else {
          console.warn("Unhandled param type", param.type);
        }
        index++;
      }
      return this.visitor.visitNode(body);
    });
    return fn;
  }
};
__name(_ArrowFunctionExpression, "ArrowFunctionExpression");
var ArrowFunctionExpression = _ArrowFunctionExpression;

// node_modules/jintr/dist/nodes/AssignmentExpression.js
var _AssignmentExpression = class _AssignmentExpression extends BaseJSNode {
  handleMemberExpression(leftNode, rightValue, operation) {
    const obj = this.visitor.visitNode(leftNode.object);
    const prop = this.visitor.visitNode(leftNode.property);
    const currentValue = obj[prop];
    const newValue = operation(currentValue, rightValue);
    return obj[prop] = newValue;
  }
  handleIdentifier(leftNode, rightValue, operation) {
    const currentValue = this.visitor.visitNode(leftNode);
    const newValue = operation(currentValue, rightValue);
    this.visitor.scope.set(leftNode.name, newValue);
    return this.visitor.scope.get(leftNode.name);
  }
  run() {
    const { operator, left, right } = this.node;
    const rightValue = this.visitor.visitNode(right);
    const operation = _AssignmentExpression.operatorMap[operator];
    if (!operation) {
      console.warn("Unhandled operator:", operator);
      return void 0;
    }
    if (left.type === "MemberExpression") {
      return this.handleMemberExpression(left, rightValue, operation);
    } else if (left.type === "Identifier") {
      return this.handleIdentifier(left, rightValue, operation);
    }
    console.warn("Unhandled left node type:", left.type);
    return void 0;
  }
};
__name(_AssignmentExpression, "AssignmentExpression");
var AssignmentExpression = _AssignmentExpression;
AssignmentExpression.operatorMap = {
  "=": /* @__PURE__ */ __name((_, right) => right, "="),
  "+=": /* @__PURE__ */ __name((left, right) => left + right, "+="),
  "-=": /* @__PURE__ */ __name((left, right) => left - right, "-="),
  "*=": /* @__PURE__ */ __name((left, right) => left * right, "*="),
  "/=": /* @__PURE__ */ __name((left, right) => left / right, "/="),
  "%=": /* @__PURE__ */ __name((left, right) => left % right, "%="),
  "**=": /* @__PURE__ */ __name((left, right) => left ** right, "**="),
  "<<=": /* @__PURE__ */ __name((left, right) => left << right, "<<="),
  ">>=": /* @__PURE__ */ __name((left, right) => left >> right, ">>="),
  ">>>=": /* @__PURE__ */ __name((left, right) => left >>> right, ">>>="),
  "&=": /* @__PURE__ */ __name((left, right) => left & right, "&="),
  "^=": /* @__PURE__ */ __name((left, right) => left ^ right, "^="),
  "|=": /* @__PURE__ */ __name((left, right) => left | right, "|=")
};

// node_modules/jintr/dist/nodes/BinaryExpression.js
var _BinaryExpression = class _BinaryExpression extends BaseJSNode {
  run() {
    const { operator, left, right } = this.node;
    const leftValue = this.visitor.visitNode(left);
    const rightValue = this.visitor.visitNode(right);
    const operation = _BinaryExpression.operatorMap[operator];
    if (!operation) {
      console.warn("Unhandled binary operator:", operator);
      return void 0;
    }
    return operation(leftValue, rightValue);
  }
};
__name(_BinaryExpression, "BinaryExpression");
var BinaryExpression = _BinaryExpression;
BinaryExpression.operatorMap = {
  // Comparison operators
  "!=": /* @__PURE__ */ __name((left, right) => left != right, "!="),
  "!==": /* @__PURE__ */ __name((left, right) => left !== right, "!=="),
  "==": /* @__PURE__ */ __name((left, right) => left == right, "=="),
  "===": /* @__PURE__ */ __name((left, right) => left === right, "==="),
  "<": /* @__PURE__ */ __name((left, right) => left < right, "<"),
  "<=": /* @__PURE__ */ __name((left, right) => left <= right, "<="),
  ">": /* @__PURE__ */ __name((left, right) => left > right, ">"),
  ">=": /* @__PURE__ */ __name((left, right) => left >= right, ">="),
  // Arithmetic operators
  "+": /* @__PURE__ */ __name((left, right) => left + right, "+"),
  "-": /* @__PURE__ */ __name((left, right) => left - right, "-"),
  "*": /* @__PURE__ */ __name((left, right) => left * right, "*"),
  "/": /* @__PURE__ */ __name((left, right) => left / right, "/"),
  "%": /* @__PURE__ */ __name((left, right) => left % right, "%"),
  "**": /* @__PURE__ */ __name((left, right) => left ** right, "**"),
  // Bitwise operators
  "&": /* @__PURE__ */ __name((left, right) => left & right, "&"),
  "|": /* @__PURE__ */ __name((left, right) => left | right, "|"),
  "^": /* @__PURE__ */ __name((left, right) => left ^ right, "^"),
  "<<": /* @__PURE__ */ __name((left, right) => left << right, "<<"),
  ">>": /* @__PURE__ */ __name((left, right) => left >> right, ">>"),
  ">>>": /* @__PURE__ */ __name((left, right) => left >>> right, ">>>"),
  // Type checking operators
  "in": /* @__PURE__ */ __name((left, right) => left in right, "in"),
  "instanceof": /* @__PURE__ */ __name((left, right) => left instanceof right, "instanceof")
};

// node_modules/jintr/dist/nodes/BlockStatement.js
var _BlockStatement = class _BlockStatement extends BaseJSNode {
  run() {
    for (const stmt of this.node.body) {
      const result = this.visitor.visitNode(stmt);
      if (stmt.type === "ReturnStatement")
        return result;
      if (result === "$jintr_break_" || result === "$jintr_continue_")
        return result;
      if ((stmt.type === "WhileStatement" || stmt.type === "IfStatement" || stmt.type === "ForStatement" || stmt.type === "TryStatement") && !!result) {
        return result;
      }
    }
  }
};
__name(_BlockStatement, "BlockStatement");
var BlockStatement = _BlockStatement;

// node_modules/jintr/dist/nodes/BreakStatement.js
var _BreakStatement = class _BreakStatement extends BaseJSNode {
  run() {
    return "$jintr_break_";
  }
};
__name(_BreakStatement, "BreakStatement");
var BreakStatement = _BreakStatement;

// node_modules/jintr/dist/nodes/CallExpression.js
var __classPrivateFieldGet = function(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _CallExpression_instances;
var _CallExpression_throwError;
var _CallExpression_getCalleeString;
var builtins = {
  // Override the forEach method so that the "this" arg is set correctly
  forEach: /* @__PURE__ */ __name((args, target, visitor) => {
    const arr = target;
    if (args.length > 1) {
      visitor.scope.set("_this", args.slice(-1)[0]);
    }
    let index = 0;
    for (const element of arr) {
      args[0]([element, index++, arr]);
    }
  }, "forEach"),
  // Also override the toString method so that it stringifies the correct object
  toString: /* @__PURE__ */ __name((_args, target) => {
    return target.toString();
  }, "toString")
};
var _CallExpression = class _CallExpression extends BaseJSNode {
  constructor() {
    super(...arguments);
    _CallExpression_instances.add(this);
  }
  run() {
    let exp_object;
    let exp_property;
    if (this.node.callee.type === "MemberExpression") {
      exp_object = this.visitor.getName(this.node.callee.object);
      exp_property = this.visitor.getName(this.node.callee.property);
    } else if (this.node.callee.type === "Identifier") {
      exp_property = this.node.callee.name;
    }
    if (exp_object && this.visitor.listeners[exp_object]) {
      const cb = this.visitor.listeners[exp_object](this.node, this.visitor);
      if (cb !== "__continue_exec") {
        return cb;
      }
    }
    if (exp_property && exp_property !== "toString" && this.visitor.listeners[exp_property]) {
      const cb = this.visitor.listeners[exp_property](this.node, this.visitor);
      if (cb !== "__continue_exec") {
        return cb;
      }
    }
    if (this.node.callee.type === "MemberExpression") {
      const obj = this.visitor.visitNode(this.node.callee.object);
      const prop = this.node.callee.computed ? this.visitor.visitNode(this.node.callee.property) : this.visitor.getName(this.node.callee.property);
      const args2 = this.node.arguments.map((arg) => this.visitor.visitNode(arg));
      if (prop in builtins) {
        return builtins[prop](args2, obj, this.visitor);
      }
      if (!obj)
        __classPrivateFieldGet(this, _CallExpression_instances, "m", _CallExpression_throwError).call(this);
      if (typeof obj[prop] !== "function")
        __classPrivateFieldGet(this, _CallExpression_instances, "m", _CallExpression_throwError).call(this);
      if (obj[prop].toString().includes("[native code]"))
        return obj[prop](...args2);
      return obj[prop](args2);
    }
    const fn = this.visitor.visitNode(this.node.callee);
    const args = this.node.arguments.map((arg) => this.visitor.visitNode(arg));
    if (typeof fn !== "function")
      __classPrivateFieldGet(this, _CallExpression_instances, "m", _CallExpression_throwError).call(this);
    return fn(args);
  }
};
__name(_CallExpression, "CallExpression");
var CallExpression = _CallExpression;
_CallExpression_instances = /* @__PURE__ */ new WeakSet(), _CallExpression_throwError = /* @__PURE__ */ __name(function _CallExpression_throwError2() {
  if (this.node.callee.type === "MemberExpression" || this.node.callee.type === "Identifier") {
    const callee_string = __classPrivateFieldGet(this, _CallExpression_instances, "m", _CallExpression_getCalleeString).call(this, this.node.callee);
    throw new JinterError(`${callee_string} is not a function`);
  } else if (this.node.callee.type === "SequenceExpression") {
    const call = [];
    const items = [];
    call.push("(");
    this.node.callee.expressions.forEach((expr) => {
      if (expr.type === "Literal") {
        items.push(expr.raw || "");
      } else if (expr.type === "Identifier") {
        items.push(expr.name);
      } else if (expr.type === "MemberExpression") {
        if (expr.computed) {
          items.push(`${this.visitor.getName(expr.object)}[${this.visitor.getName(expr.property) || "..."}]`);
        } else {
          items.push(`${this.visitor.getName(expr.object)}.${this.visitor.getName(expr.property)}`);
        }
      }
    });
    call.push(items.join(", "));
    call.push(")");
    throw new JinterError(`${call.join("")} is not a function`);
  }
}, "_CallExpression_throwError"), _CallExpression_getCalleeString = /* @__PURE__ */ __name(function _CallExpression_getCalleeString2(node) {
  if (node.type === "Identifier") {
    return node.name;
  } else if (node.type === "MemberExpression") {
    const object_string = __classPrivateFieldGet(this, _CallExpression_instances, "m", _CallExpression_getCalleeString2).call(this, node.object);
    const property_string = node.computed ? `[${this.visitor.getName(node.property) || "..."}]` : `.${this.visitor.getName(node.property)}`;
    return `${object_string}${property_string}`;
  }
  return "<unknown>";
}, "_CallExpression_getCalleeString");

// node_modules/jintr/dist/nodes/ConditionalExpression.js
var _ConditionalExpression = class _ConditionalExpression extends BaseJSNode {
  run() {
    const { test, consequent, alternate } = this.node;
    const check = this.visitor.visitNode(test);
    if (check) {
      return this.visitor.visitNode(consequent);
    }
    return this.visitor.visitNode(alternate);
  }
};
__name(_ConditionalExpression, "ConditionalExpression");
var ConditionalExpression = _ConditionalExpression;

// node_modules/jintr/dist/nodes/ContinueStatement.js
var _ContinueStatement = class _ContinueStatement extends BaseJSNode {
  run() {
    return "$jintr_continue_";
  }
};
__name(_ContinueStatement, "ContinueStatement");
var ContinueStatement = _ContinueStatement;

// node_modules/jintr/dist/nodes/EmptyStatement.js
var _EmptyStatement = class _EmptyStatement extends BaseJSNode {
  run() {
    return void 0;
  }
};
__name(_EmptyStatement, "EmptyStatement");
var EmptyStatement = _EmptyStatement;

// node_modules/jintr/dist/nodes/ExpressionStatement.js
var _ExpressionStatement = class _ExpressionStatement extends BaseJSNode {
  run() {
    return this.visitor.visitNode(this.node.expression);
  }
};
__name(_ExpressionStatement, "ExpressionStatement");
var ExpressionStatement = _ExpressionStatement;

// node_modules/jintr/dist/nodes/ForOfStatement.js
var _ForOfStatement = class _ForOfStatement extends BaseJSNode {
  run() {
    this.visitor.visitNode(this.node.left);
    const right_node = this.visitor.visitNode(this.node.right);
    for (const el of right_node) {
      if (this.node.left.type === "VariableDeclaration" && this.node.left.declarations[0].id.type === "Identifier") {
        this.visitor.scope.set(this.node.left.declarations[0].id.name, el);
      } else if (this.node.left.type === "VariableDeclaration" && this.node.left.declarations[0].id.type === "ObjectPattern") {
        for (const propert of this.node.left.declarations[0].id.properties) {
          if (propert.type === "Property" && (propert.value.type === "Identifier" && propert.key.type === "Identifier")) {
            this.visitor.scope.set(propert.value.name, el[propert.key.name]);
          }
        }
      }
      const body = this.visitor.visitNode(this.node.body);
      if (body === "$jintr_break_") {
        break;
      }
      if (body === "$jintr_continue_") {
        continue;
      }
      if (body && this.node.body.type !== "ExpressionStatement") {
        return body;
      }
    }
  }
};
__name(_ForOfStatement, "ForOfStatement");
var ForOfStatement = _ForOfStatement;

// node_modules/jintr/dist/nodes/ForStatement.js
var _ForStatement = class _ForStatement extends BaseJSNode {
  run() {
    if (this.node.init) {
      this.visitor.visitNode(this.node.init);
    }
    const test = /* @__PURE__ */ __name(() => {
      return this.node.test ? this.visitor.visitNode(this.node.test) : true;
    }, "test");
    for (; ; ) {
      const _test = test();
      if (!_test) {
        break;
      }
      const body = this.visitor.visitNode(this.node.body);
      if (body === "$jintr_continue_") {
        continue;
      }
      if (body === "$jintr_break_") {
        break;
      }
      if (this.node.update) {
        this.visitor.visitNode(this.node.update);
      }
      if (body && this.node.body.type !== "ExpressionStatement") {
        return body;
      }
    }
  }
};
__name(_ForStatement, "ForStatement");
var ForStatement = _ForStatement;

// node_modules/jintr/dist/nodes/FunctionDeclaration.js
var _FunctionDeclaration = class _FunctionDeclaration extends BaseJSNode {
  run() {
    const { params, body } = this.node;
    const id = this.visitor.visitNode(this.node.id);
    const fn = namedFunction(id, (args) => {
      let index = 0;
      for (const param of params) {
        this.visitor.visitNode(param);
        if (param.type === "Identifier") {
          this.visitor.scope.set(param.name, args[index]);
        } else {
          console.warn("Unhandled param type", param.type);
        }
        index++;
      }
      return this.visitor.visitNode(body);
    });
    this.visitor.scope.set(id, fn);
  }
};
__name(_FunctionDeclaration, "FunctionDeclaration");
var FunctionDeclaration = _FunctionDeclaration;

// node_modules/jintr/dist/nodes/FunctionExpression.js
var _FunctionExpression = class _FunctionExpression extends BaseJSNode {
  run() {
    const { params, body } = this.node;
    const fn = namedFunction("anonymous function", (args) => {
      let index = 0;
      for (const param of params) {
        this.visitor.visitNode(param);
        if (param.type === "Identifier") {
          this.visitor.scope.set(param.name, args[index]);
        } else {
          console.warn("Unhandled param type", param.type);
        }
        index++;
      }
      return this.visitor.visitNode(body);
    });
    return fn;
  }
};
__name(_FunctionExpression, "FunctionExpression");
var FunctionExpression = _FunctionExpression;

// node_modules/jintr/dist/nodes/Identifier.js
var _Identifier = class _Identifier extends BaseJSNode {
  run() {
    if (this.visitor.listeners[this.node.name]) {
      const cb = this.visitor.listeners[this.node.name](this.node, this.visitor);
      if (cb !== "__continue_exec") {
        return cb;
      }
    }
    if (this.visitor.scope.has(this.node.name))
      return this.visitor.scope.get(this.node.name);
    return this.node.name;
  }
};
__name(_Identifier, "Identifier");
var Identifier = _Identifier;

// node_modules/jintr/dist/nodes/IfStatement.js
var _IfStatement = class _IfStatement extends BaseJSNode {
  run() {
    const test = this.visitor.visitNode(this.node.test);
    if (test) {
      return this.visitor.visitNode(this.node.consequent);
    } else if (this.node.alternate) {
      return this.visitor.visitNode(this.node.alternate);
    }
  }
};
__name(_IfStatement, "IfStatement");
var IfStatement = _IfStatement;

// node_modules/jintr/dist/nodes/Literal.js
var _Literal = class _Literal extends BaseJSNode {
  run() {
    return this.node.value;
  }
};
__name(_Literal, "Literal");
var Literal = _Literal;

// node_modules/jintr/dist/nodes/LogicalExpression.js
var _LogicalExpression = class _LogicalExpression extends BaseJSNode {
  run() {
    const { operator, left, right } = this.node;
    const operation = _LogicalExpression.operatorMap[operator];
    if (!operation) {
      console.warn("Unhandled logical operator:", operator);
      return void 0;
    }
    return operation(this.visitor, left, right);
  }
};
__name(_LogicalExpression, "LogicalExpression");
var LogicalExpression = _LogicalExpression;
LogicalExpression.operatorMap = {
  "&&": /* @__PURE__ */ __name((visitor, leftNode, rightNode) => {
    const leftValue = visitor.visitNode(leftNode);
    return leftValue === true ? visitor.visitNode(rightNode) : leftValue;
  }, "&&"),
  "||": /* @__PURE__ */ __name((visitor, leftNode, rightNode) => {
    const leftValue = visitor.visitNode(leftNode);
    return leftValue || visitor.visitNode(rightNode);
  }, "||"),
  "??": /* @__PURE__ */ __name((visitor, leftNode, rightNode) => {
    const normalizeUndefined = /* @__PURE__ */ __name((value, isIdentifier) => isIdentifier && value === "undefined" ? void 0 : value, "normalizeUndefined");
    const leftValue = normalizeUndefined(visitor.visitNode(leftNode), leftNode.type === "Identifier");
    const rightValue = normalizeUndefined(visitor.visitNode(rightNode), rightNode.type === "Identifier");
    return leftValue ?? rightValue;
  }, "??")
};

// node_modules/jintr/dist/nodes/MemberExpression.js
var _MemberExpression = class _MemberExpression extends BaseJSNode {
  run() {
    const { object, property, computed } = this.node;
    const obj = this.visitor.visitNode(object);
    const prop = computed ? this.visitor.visitNode(property) : this.visitor.getName(property);
    if (prop !== void 0 || prop !== null) {
      if (this.visitor.listeners[prop]) {
        const cb = this.visitor.listeners[prop](this.node, this.visitor);
        if (cb !== "__continue_exec") {
          return cb;
        }
      }
      return obj?.[prop];
    }
  }
};
__name(_MemberExpression, "MemberExpression");
var MemberExpression = _MemberExpression;

// node_modules/jintr/dist/nodes/NewExpression.js
var _NewExpression = class _NewExpression extends BaseJSNode {
  run() {
    const callee = this.visitor.visitNode(this.node.callee);
    const args = this.node.arguments.map((arg) => this.visitor.visitNode(arg));
    return args.length ? new callee(args) : new callee();
  }
};
__name(_NewExpression, "NewExpression");
var NewExpression = _NewExpression;

// node_modules/jintr/dist/nodes/ObjectExpression.js
var _ObjectExpression = class _ObjectExpression extends BaseJSNode {
  run() {
    let result = {};
    for (const prop of this.node.properties) {
      if (prop.type === "Property") {
        result = { ...result, ...this.visitor.visitNode(prop) };
      } else {
        throw new Error(`Unhandled property type: ${prop.type}`);
      }
    }
    return result;
  }
};
__name(_ObjectExpression, "ObjectExpression");
var ObjectExpression = _ObjectExpression;

// node_modules/jintr/dist/nodes/Property.js
var __classPrivateFieldGet2 = function(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _Property_instances;
var _Property_init;
var _Property_get;
var _Property_set;
var _Property = class _Property extends BaseJSNode {
  constructor() {
    super(...arguments);
    _Property_instances.add(this);
  }
  run() {
    switch (this.node.kind) {
      case "init":
        return __classPrivateFieldGet2(this, _Property_instances, "m", _Property_init).call(this);
      case "get":
        return __classPrivateFieldGet2(this, _Property_instances, "m", _Property_get).call(this);
      case "set":
        return __classPrivateFieldGet2(this, _Property_instances, "m", _Property_set).call(this);
      default:
        throw new Error(`Unhandled property kind: ${this.node.kind}`);
    }
  }
};
__name(_Property, "Property");
var Property = _Property;
_Property_instances = /* @__PURE__ */ new WeakSet(), _Property_init = /* @__PURE__ */ __name(function _Property_init2() {
  const key = this.node.computed ? this.visitor.visitNode(this.node.key) : this.visitor.getName(this.node.key);
  const value = this.visitor.visitNode(this.node.value);
  if (key) {
    return { [key]: value };
  }
}, "_Property_init"), _Property_get = /* @__PURE__ */ __name(function _Property_get2() {
  throw new TypeError("Not implemented: Property.get");
}, "_Property_get"), _Property_set = /* @__PURE__ */ __name(function _Property_set2() {
  throw new TypeError("Not implemented: Property.set");
}, "_Property_set");

// node_modules/jintr/dist/nodes/ReturnStatement.js
var _ReturnStatement = class _ReturnStatement extends BaseJSNode {
  run() {
    if (this.node.argument) {
      return this.visitor.visitNode(this.node.argument);
    }
  }
};
__name(_ReturnStatement, "ReturnStatement");
var ReturnStatement = _ReturnStatement;

// node_modules/jintr/dist/nodes/SequenceExpression.js
var _SequenceExpression = class _SequenceExpression extends BaseJSNode {
  run() {
    let result;
    for (const expression of this.node.expressions) {
      result = this.visitor.visitNode(expression);
    }
    return result;
  }
};
__name(_SequenceExpression, "SequenceExpression");
var SequenceExpression = _SequenceExpression;

// node_modules/jintr/dist/nodes/SwitchCase.js
var _SwitchCase = class _SwitchCase extends BaseJSNode {
  run() {
    for (const stmt of this.node.consequent) {
      const result = this.visitor.visitNode(stmt);
      if (stmt.type === "ContinueStatement" || stmt.type === "BreakStatement") {
        return result;
      }
    }
  }
};
__name(_SwitchCase, "SwitchCase");
var SwitchCase = _SwitchCase;

// node_modules/jintr/dist/nodes/SwitchStatement.js
var _SwitchStatement = class _SwitchStatement extends BaseJSNode {
  run() {
    const discriminant = this.visitor.visitNode(this.node.discriminant);
    let matched = false;
    let default_case = -1;
    let index = 0;
    while (true) {
      const _case = this.node.cases[index];
      if (matched) {
        const result = this.visitor.visitNode(_case);
        if (result === "$jintr_break_") {
          break;
        }
        if (result === "$jintr_continue_") {
          return result;
        }
        ++index;
        if (index >= this.node.cases.length) {
          index = 0;
          break;
        } else {
          continue;
        }
      }
      matched = _case && discriminant === this.visitor.visitNode(_case.test);
      if (matched === void 0 && index > this.node.cases.length)
        break;
      if (_case && !matched && !_case.test) {
        default_case = index;
        index += 1;
        continue;
      }
      if (!_case && !matched && default_case !== -1) {
        matched = true;
        index = default_case;
        continue;
      }
      if (!matched) {
        ++index;
      }
    }
  }
};
__name(_SwitchStatement, "SwitchStatement");
var SwitchStatement = _SwitchStatement;

// node_modules/jintr/dist/nodes/TemplateLiteral.js
var _TemplateLiteral = class _TemplateLiteral extends BaseJSNode {
  run() {
    let result = "";
    for (let i = 0; i < this.node.quasis.length; ++i) {
      const quasi = this.node.quasis[i];
      if (quasi.type === "TemplateElement") {
        if (quasi.value.cooked === null) {
          throw new Error(`Invalid template literal: ${quasi.value.raw}`);
        }
        if (quasi.value.cooked !== void 0) {
          result += quasi.value.cooked;
        }
        if (!quasi.tail) {
          const expr = this.node.expressions[i];
          if (expr !== void 0) {
            result += this.visitor.visitNode(expr);
          } else {
            throw new Error(`Expected expression after: ${quasi.value}`);
          }
        }
      } else {
        throw new Error(`Unhandled quasi type: ${quasi.type}`);
      }
    }
    return result;
  }
};
__name(_TemplateLiteral, "TemplateLiteral");
var TemplateLiteral = _TemplateLiteral;

// node_modules/jintr/dist/nodes/ThisExpression.js
var _ThisExpression = class _ThisExpression extends BaseJSNode {
  run() {
    return this.visitor.scope.get("_this");
  }
};
__name(_ThisExpression, "ThisExpression");
var ThisExpression = _ThisExpression;

// node_modules/jintr/dist/nodes/ThrowStatement.js
var _ThrowStatement = class _ThrowStatement extends BaseJSNode {
  run() {
    const arg = this.visitor.visitNode(this.node.argument);
    throw arg;
  }
};
__name(_ThrowStatement, "ThrowStatement");
var ThrowStatement = _ThrowStatement;

// node_modules/jintr/dist/nodes/TryStatement.js
var _TryStatement = class _TryStatement extends BaseJSNode {
  run() {
    try {
      return this.visitor.visitNode(this.node.block);
    } catch (e) {
      if (this.node.handler) {
        if (this.node.handler.param && this.node.handler.param.type === "Identifier") {
          this.visitor.scope.set(this.node.handler.param.name, e);
        }
        return this.visitor.visitNode(this.node.handler.body);
      }
    } finally {
      this.visitor.visitNode(this.node.finalizer);
    }
  }
};
__name(_TryStatement, "TryStatement");
var TryStatement = _TryStatement;

// node_modules/jintr/dist/nodes/UnaryExpression.js
var _UnaryExpression = class _UnaryExpression extends BaseJSNode {
  static isValidOperator(operator) {
    return operator in _UnaryExpression.operatorMap;
  }
  run() {
    const { operator, argument } = this.node;
    if (!_UnaryExpression.isValidOperator(operator)) {
      console.warn("Unhandled unary operator:", operator);
      return void 0;
    }
    return _UnaryExpression.operatorMap[operator](this.visitor, argument);
  }
};
__name(_UnaryExpression, "UnaryExpression");
var UnaryExpression = _UnaryExpression;
UnaryExpression.operatorMap = {
  // Arithmetic operators
  "-": /* @__PURE__ */ __name((visitor, argument) => -visitor.visitNode(argument), "-"),
  "+": /* @__PURE__ */ __name((visitor, argument) => +visitor.visitNode(argument), "+"),
  // Logical/Bitwise operators
  "!": /* @__PURE__ */ __name((visitor, argument) => !visitor.visitNode(argument), "!"),
  "~": /* @__PURE__ */ __name((visitor, argument) => ~visitor.visitNode(argument), "~"),
  // Type/Value operators
  "void": /* @__PURE__ */ __name((visitor, argument) => {
    visitor.visitNode(argument);
    return void 0;
  }, "void"),
  "typeof": /* @__PURE__ */ __name((visitor, argument) => {
    const arg = visitor.visitNode(argument);
    if (argument.type === "Identifier" && arg === "undefined")
      return "undefined";
    return typeof visitor.visitNode(argument);
  }, "typeof"),
  // Property/Variable deletion
  "delete": /* @__PURE__ */ __name((visitor, argument) => {
    if (argument.type === "MemberExpression") {
      const obj = visitor.visitNode(argument.object);
      const prop = argument.computed ? visitor.visitNode(argument.property) : visitor.getName(argument.property);
      return delete obj[prop];
    }
    if (argument.type === "Identifier" && visitor.scope.has(argument.name)) {
      return visitor.scope.delete(argument.name);
    }
    return true;
  }, "delete")
};

// node_modules/jintr/dist/nodes/UpdateExpression.js
var _UpdateExpression = class _UpdateExpression extends BaseJSNode {
  run() {
    const operator = this.node.operator;
    switch (operator) {
      case "++":
        {
          if (this.node.argument.type === "MemberExpression") {
            const target_node = this.visitor.visitNode(this.node.argument.object);
            return target_node[this.visitor.visitNode(this.node.argument.property)]++;
          } else if (this.node.argument.type === "Identifier") {
            let target_node = this.visitor.visitNode(this.node.argument);
            this.visitor.scope.set(this.node.argument.name, target_node + 1);
            return this.node.prefix ? ++target_node : target_node;
          }
        }
        break;
      case "--":
        {
          if (this.node.argument.type === "MemberExpression") {
            const target_node = this.visitor.visitNode(this.node.argument.object);
            return target_node[this.visitor.visitNode(this.node.argument.property)]--;
          } else if (this.node.argument.type === "Identifier") {
            let target_node = this.visitor.visitNode(this.node.argument);
            this.visitor.scope.set(this.node.argument.name, target_node - 1);
            return this.node.prefix ? --target_node : target_node;
          }
        }
        break;
    }
  }
};
__name(_UpdateExpression, "UpdateExpression");
var UpdateExpression = _UpdateExpression;

// node_modules/jintr/dist/nodes/VariableDeclaration.js
var _VariableDeclaration = class _VariableDeclaration extends BaseJSNode {
  run() {
    this.node.declarations.forEach((declar) => {
      const { id, init } = declar;
      const key = this.visitor.getName(id);
      const value = init ? this.visitor.visitNode(init) : void 0;
      if (key)
        this.visitor.scope.set(key, value);
      if (typeof value === "object" && value !== null)
        this.visitor.scope.set("_this", value);
    });
  }
};
__name(_VariableDeclaration, "VariableDeclaration");
var VariableDeclaration = _VariableDeclaration;

// node_modules/jintr/dist/nodes/WhileStatement.js
var _WhileStatement = class _WhileStatement extends BaseJSNode {
  run() {
    while (this.visitor.visitNode(this.node.test)) {
      const body = this.visitor.visitNode(this.node.body);
      if (body === "$jintr_break_")
        break;
      if (body === "$jintr_continue_")
        continue;
      if (body)
        return body;
    }
  }
};
__name(_WhileStatement, "WhileStatement");
var WhileStatement = _WhileStatement;

// node_modules/jintr/dist/visitor.js
var __classPrivateFieldGet3 = function(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _Visitor_instances;
var _Visitor_getNode;
var _Visitor = class _Visitor {
  constructor() {
    _Visitor_instances.add(this);
    this.scope = /* @__PURE__ */ new Map();
    this.listeners = {};
    this.ast = [];
  }
  setAST(ast) {
    this.ast = ast;
  }
  run() {
    let result;
    for (const node of this.ast) {
      result = this.visitNode(node);
    }
    return result;
  }
  /**
   * Visits a given node and executes it.
   */
  visitNode(node) {
    if (!node)
      return null;
    const targetNode = __classPrivateFieldGet3(this, _Visitor_instances, "m", _Visitor_getNode).call(this, node.type);
    if (targetNode) {
      const instance = new targetNode(node, this);
      return instance.run();
    }
    return null;
  }
  /**
   * Gets the name of a node.
   * @param node - The target node.
   */
  getName(node) {
    if (node.type === "Identifier")
      return node.name;
    else if (node.type === "Literal")
      return node.value;
  }
  /**
   * Listens for node calls. Can be used to override default behavior or add new functionality.
   * @param node_name - The node to listen for.
   * @param listener - The callback function.
   */
  on(node_name, listener) {
    this.listeners[node_name] = listener;
  }
};
__name(_Visitor, "Visitor");
var Visitor = _Visitor;
_Visitor_instances = /* @__PURE__ */ new WeakSet(), _Visitor_getNode = /* @__PURE__ */ __name(function _Visitor_getNode2(type) {
  const node = nodes_exports[type];
  if (!node) {
    console.warn("[JINTER]:", `JavaScript node "${type}" not implemented!
If this is causing unexpected behavior, please report it at https://github.com/LuanRT/Jinter/issues/new`);
  }
  return node;
}, "_Visitor_getNode");

// node_modules/acorn/dist/acorn.mjs
var astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 81, 2, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4, 14, 9, 5351, 0, 7, 14, 13835, 9, 87, 9, 39, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4706, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 983, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];
var astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 68, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 4026, 582, 8634, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8936, 3, 2, 6, 2, 1, 2, 290, 16, 0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11, 6, 17, 0, 322, 29, 19, 43, 485, 27, 757, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4153, 7, 221, 3, 5761, 15, 7472, 16, 621, 2467, 541, 1507, 4938, 6, 4191];
var nonASCIIidentifierChars = "\u200C\u200D\xB7\u0300-\u036F\u0387\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7\u0610-\u061A\u064B-\u0669\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u06F0-\u06F9\u0711\u0730-\u074A\u07A6-\u07B0\u07C0-\u07C9\u07EB-\u07F3\u07FD\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u0898-\u089F\u08CA-\u08E1\u08E3-\u0903\u093A-\u093C\u093E-\u094F\u0951-\u0957\u0962\u0963\u0966-\u096F\u0981-\u0983\u09BC\u09BE-\u09C4\u09C7\u09C8\u09CB-\u09CD\u09D7\u09E2\u09E3\u09E6-\u09EF\u09FE\u0A01-\u0A03\u0A3C\u0A3E-\u0A42\u0A47\u0A48\u0A4B-\u0A4D\u0A51\u0A66-\u0A71\u0A75\u0A81-\u0A83\u0ABC\u0ABE-\u0AC5\u0AC7-\u0AC9\u0ACB-\u0ACD\u0AE2\u0AE3\u0AE6-\u0AEF\u0AFA-\u0AFF\u0B01-\u0B03\u0B3C\u0B3E-\u0B44\u0B47\u0B48\u0B4B-\u0B4D\u0B55-\u0B57\u0B62\u0B63\u0B66-\u0B6F\u0B82\u0BBE-\u0BC2\u0BC6-\u0BC8\u0BCA-\u0BCD\u0BD7\u0BE6-\u0BEF\u0C00-\u0C04\u0C3C\u0C3E-\u0C44\u0C46-\u0C48\u0C4A-\u0C4D\u0C55\u0C56\u0C62\u0C63\u0C66-\u0C6F\u0C81-\u0C83\u0CBC\u0CBE-\u0CC4\u0CC6-\u0CC8\u0CCA-\u0CCD\u0CD5\u0CD6\u0CE2\u0CE3\u0CE6-\u0CEF\u0CF3\u0D00-\u0D03\u0D3B\u0D3C\u0D3E-\u0D44\u0D46-\u0D48\u0D4A-\u0D4D\u0D57\u0D62\u0D63\u0D66-\u0D6F\u0D81-\u0D83\u0DCA\u0DCF-\u0DD4\u0DD6\u0DD8-\u0DDF\u0DE6-\u0DEF\u0DF2\u0DF3\u0E31\u0E34-\u0E3A\u0E47-\u0E4E\u0E50-\u0E59\u0EB1\u0EB4-\u0EBC\u0EC8-\u0ECE\u0ED0-\u0ED9\u0F18\u0F19\u0F20-\u0F29\u0F35\u0F37\u0F39\u0F3E\u0F3F\u0F71-\u0F84\u0F86\u0F87\u0F8D-\u0F97\u0F99-\u0FBC\u0FC6\u102B-\u103E\u1040-\u1049\u1056-\u1059\u105E-\u1060\u1062-\u1064\u1067-\u106D\u1071-\u1074\u1082-\u108D\u108F-\u109D\u135D-\u135F\u1369-\u1371\u1712-\u1715\u1732-\u1734\u1752\u1753\u1772\u1773\u17B4-\u17D3\u17DD\u17E0-\u17E9\u180B-\u180D\u180F-\u1819\u18A9\u1920-\u192B\u1930-\u193B\u1946-\u194F\u19D0-\u19DA\u1A17-\u1A1B\u1A55-\u1A5E\u1A60-\u1A7C\u1A7F-\u1A89\u1A90-\u1A99\u1AB0-\u1ABD\u1ABF-\u1ACE\u1B00-\u1B04\u1B34-\u1B44\u1B50-\u1B59\u1B6B-\u1B73\u1B80-\u1B82\u1BA1-\u1BAD\u1BB0-\u1BB9\u1BE6-\u1BF3\u1C24-\u1C37\u1C40-\u1C49\u1C50-\u1C59\u1CD0-\u1CD2\u1CD4-\u1CE8\u1CED\u1CF4\u1CF7-\u1CF9\u1DC0-\u1DFF\u200C\u200D\u203F\u2040\u2054\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\u30FB\uA620-\uA629\uA66F\uA674-\uA67D\uA69E\uA69F\uA6F0\uA6F1\uA802\uA806\uA80B\uA823-\uA827\uA82C\uA880\uA881\uA8B4-\uA8C5\uA8D0-\uA8D9\uA8E0-\uA8F1\uA8FF-\uA909\uA926-\uA92D\uA947-\uA953\uA980-\uA983\uA9B3-\uA9C0\uA9D0-\uA9D9\uA9E5\uA9F0-\uA9F9\uAA29-\uAA36\uAA43\uAA4C\uAA4D\uAA50-\uAA59\uAA7B-\uAA7D\uAAB0\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAEB-\uAAEF\uAAF5\uAAF6\uABE3-\uABEA\uABEC\uABED\uABF0-\uABF9\uFB1E\uFE00-\uFE0F\uFE20-\uFE2F\uFE33\uFE34\uFE4D-\uFE4F\uFF10-\uFF19\uFF3F\uFF65";
var nonASCIIidentifierStartChars = "\xAA\xB5\xBA\xC0-\xD6\xD8-\xF6\xF8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377\u037A-\u037D\u037F\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5\u03F7-\u0481\u048A-\u052F\u0531-\u0556\u0559\u0560-\u0588\u05D0-\u05EA\u05EF-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u0860-\u086A\u0870-\u0887\u0889-\u088E\u08A0-\u08C9\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u09FC\u0A05-\u0A0A\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0AF9\u0B05-\u0B0C\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C39\u0C3D\u0C58-\u0C5A\u0C5D\u0C60\u0C61\u0C80\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3\u0CB5-\u0CB9\u0CBD\u0CDD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D04-\u0D0C\u0D0E-\u0D10\u0D12-\u0D3A\u0D3D\u0D4E\u0D54-\u0D56\u0D5F-\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81\u0E82\u0E84\u0E86-\u0E8A\u0E8C-\u0EA3\u0EA5\u0EA7-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F5\u13F8-\u13FD\u1401-\u166C\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u16EE-\u16F8\u1700-\u1711\u171F-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7\u17DC\u1820-\u1878\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191E\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19B0-\u19C9\u1A00-\u1A16\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4C\u1B83-\u1BA0\u1BAE\u1BAF\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1C80-\u1C88\u1C90-\u1CBA\u1CBD-\u1CBF\u1CE9-\u1CEC\u1CEE-\u1CF3\u1CF5\u1CF6\u1CFA\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2118-\u211D\u2124\u2126\u2128\u212A-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2160-\u2188\u2C00-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE\u2DD0-\u2DD6\u2DD8-\u2DDE\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303C\u3041-\u3096\u309B-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312F\u3131-\u318E\u31A0-\u31BF\u31F0-\u31FF\u3400-\u4DBF\u4E00-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B\uA640-\uA66E\uA67F-\uA69D\uA6A0-\uA6EF\uA717-\uA71F\uA722-\uA788\uA78B-\uA7CA\uA7D0\uA7D1\uA7D3\uA7D5-\uA7D9\uA7F2-\uA801\uA803-\uA805\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB\uA8FD\uA8FE\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uA9E0-\uA9E4\uA9E6-\uA9EF\uA9FA-\uA9FE\uAA00-\uAA28\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA7E-\uAAAF\uAAB1\uAAB5\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E\uAB30-\uAB5A\uAB5C-\uAB69\uAB70-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC";
var reservedWords = {
  3: "abstract boolean byte char class double enum export extends final float goto implements import int interface long native package private protected public short static super synchronized throws transient volatile",
  5: "class enum extends super const export import",
  6: "enum",
  strict: "implements interface let package private protected public static yield",
  strictBind: "eval arguments"
};
var ecma5AndLessKeywords = "break case catch continue debugger default do else finally for function if return switch throw try var while with null true false instanceof typeof void delete new in this";
var keywords$1 = {
  5: ecma5AndLessKeywords,
  "5module": ecma5AndLessKeywords + " export import",
  6: ecma5AndLessKeywords + " const class extends export import super"
};
var keywordRelationalOperator = /^in(stanceof)?$/;
var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");
function isInAstralSet(code, set) {
  var pos = 65536;
  for (var i = 0; i < set.length; i += 2) {
    pos += set[i];
    if (pos > code) {
      return false;
    }
    pos += set[i + 1];
    if (pos >= code) {
      return true;
    }
  }
  return false;
}
__name(isInAstralSet, "isInAstralSet");
function isIdentifierStart(code, astral) {
  if (code < 65) {
    return code === 36;
  }
  if (code < 91) {
    return true;
  }
  if (code < 97) {
    return code === 95;
  }
  if (code < 123) {
    return true;
  }
  if (code <= 65535) {
    return code >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code));
  }
  if (astral === false) {
    return false;
  }
  return isInAstralSet(code, astralIdentifierStartCodes);
}
__name(isIdentifierStart, "isIdentifierStart");
function isIdentifierChar(code, astral) {
  if (code < 48) {
    return code === 36;
  }
  if (code < 58) {
    return true;
  }
  if (code < 65) {
    return false;
  }
  if (code < 91) {
    return true;
  }
  if (code < 97) {
    return code === 95;
  }
  if (code < 123) {
    return true;
  }
  if (code <= 65535) {
    return code >= 170 && nonASCIIidentifier.test(String.fromCharCode(code));
  }
  if (astral === false) {
    return false;
  }
  return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes);
}
__name(isIdentifierChar, "isIdentifierChar");
var TokenType = /* @__PURE__ */ __name(function TokenType2(label, conf) {
  if (conf === void 0) conf = {};
  this.label = label;
  this.keyword = conf.keyword;
  this.beforeExpr = !!conf.beforeExpr;
  this.startsExpr = !!conf.startsExpr;
  this.isLoop = !!conf.isLoop;
  this.isAssign = !!conf.isAssign;
  this.prefix = !!conf.prefix;
  this.postfix = !!conf.postfix;
  this.binop = conf.binop || null;
  this.updateContext = null;
}, "TokenType");
function binop(name, prec) {
  return new TokenType(name, { beforeExpr: true, binop: prec });
}
__name(binop, "binop");
var beforeExpr = { beforeExpr: true };
var startsExpr = { startsExpr: true };
var keywords = {};
function kw(name, options) {
  if (options === void 0) options = {};
  options.keyword = name;
  return keywords[name] = new TokenType(name, options);
}
__name(kw, "kw");
var types$1 = {
  num: new TokenType("num", startsExpr),
  regexp: new TokenType("regexp", startsExpr),
  string: new TokenType("string", startsExpr),
  name: new TokenType("name", startsExpr),
  privateId: new TokenType("privateId", startsExpr),
  eof: new TokenType("eof"),
  // Punctuation token types.
  bracketL: new TokenType("[", { beforeExpr: true, startsExpr: true }),
  bracketR: new TokenType("]"),
  braceL: new TokenType("{", { beforeExpr: true, startsExpr: true }),
  braceR: new TokenType("}"),
  parenL: new TokenType("(", { beforeExpr: true, startsExpr: true }),
  parenR: new TokenType(")"),
  comma: new TokenType(",", beforeExpr),
  semi: new TokenType(";", beforeExpr),
  colon: new TokenType(":", beforeExpr),
  dot: new TokenType("."),
  question: new TokenType("?", beforeExpr),
  questionDot: new TokenType("?."),
  arrow: new TokenType("=>", beforeExpr),
  template: new TokenType("template"),
  invalidTemplate: new TokenType("invalidTemplate"),
  ellipsis: new TokenType("...", beforeExpr),
  backQuote: new TokenType("`", startsExpr),
  dollarBraceL: new TokenType("${", { beforeExpr: true, startsExpr: true }),
  // Operators. These carry several kinds of properties to help the
  // parser use them properly (the presence of these properties is
  // what categorizes them as operators).
  //
  // `binop`, when present, specifies that this operator is a binary
  // operator, and will refer to its precedence.
  //
  // `prefix` and `postfix` mark the operator as a prefix or postfix
  // unary operator.
  //
  // `isAssign` marks all of `=`, `+=`, `-=` etcetera, which act as
  // binary operators with a very low precedence, that should result
  // in AssignmentExpression nodes.
  eq: new TokenType("=", { beforeExpr: true, isAssign: true }),
  assign: new TokenType("_=", { beforeExpr: true, isAssign: true }),
  incDec: new TokenType("++/--", { prefix: true, postfix: true, startsExpr: true }),
  prefix: new TokenType("!/~", { beforeExpr: true, prefix: true, startsExpr: true }),
  logicalOR: binop("||", 1),
  logicalAND: binop("&&", 2),
  bitwiseOR: binop("|", 3),
  bitwiseXOR: binop("^", 4),
  bitwiseAND: binop("&", 5),
  equality: binop("==/!=/===/!==", 6),
  relational: binop("</>/<=/>=", 7),
  bitShift: binop("<</>>/>>>", 8),
  plusMin: new TokenType("+/-", { beforeExpr: true, binop: 9, prefix: true, startsExpr: true }),
  modulo: binop("%", 10),
  star: binop("*", 10),
  slash: binop("/", 10),
  starstar: new TokenType("**", { beforeExpr: true }),
  coalesce: binop("??", 1),
  // Keyword token types.
  _break: kw("break"),
  _case: kw("case", beforeExpr),
  _catch: kw("catch"),
  _continue: kw("continue"),
  _debugger: kw("debugger"),
  _default: kw("default", beforeExpr),
  _do: kw("do", { isLoop: true, beforeExpr: true }),
  _else: kw("else", beforeExpr),
  _finally: kw("finally"),
  _for: kw("for", { isLoop: true }),
  _function: kw("function", startsExpr),
  _if: kw("if"),
  _return: kw("return", beforeExpr),
  _switch: kw("switch"),
  _throw: kw("throw", beforeExpr),
  _try: kw("try"),
  _var: kw("var"),
  _const: kw("const"),
  _while: kw("while", { isLoop: true }),
  _with: kw("with"),
  _new: kw("new", { beforeExpr: true, startsExpr: true }),
  _this: kw("this", startsExpr),
  _super: kw("super", startsExpr),
  _class: kw("class", startsExpr),
  _extends: kw("extends", beforeExpr),
  _export: kw("export"),
  _import: kw("import", startsExpr),
  _null: kw("null", startsExpr),
  _true: kw("true", startsExpr),
  _false: kw("false", startsExpr),
  _in: kw("in", { beforeExpr: true, binop: 7 }),
  _instanceof: kw("instanceof", { beforeExpr: true, binop: 7 }),
  _typeof: kw("typeof", { beforeExpr: true, prefix: true, startsExpr: true }),
  _void: kw("void", { beforeExpr: true, prefix: true, startsExpr: true }),
  _delete: kw("delete", { beforeExpr: true, prefix: true, startsExpr: true })
};
var lineBreak = /\r\n?|\n|\u2028|\u2029/;
var lineBreakG = new RegExp(lineBreak.source, "g");
function isNewLine(code) {
  return code === 10 || code === 13 || code === 8232 || code === 8233;
}
__name(isNewLine, "isNewLine");
function nextLineBreak(code, from, end) {
  if (end === void 0) end = code.length;
  for (var i = from; i < end; i++) {
    var next = code.charCodeAt(i);
    if (isNewLine(next)) {
      return i < end - 1 && next === 13 && code.charCodeAt(i + 1) === 10 ? i + 2 : i + 1;
    }
  }
  return -1;
}
__name(nextLineBreak, "nextLineBreak");
var nonASCIIwhitespace = /[\u1680\u2000-\u200a\u202f\u205f\u3000\ufeff]/;
var skipWhiteSpace = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g;
var ref = Object.prototype;
var hasOwnProperty = ref.hasOwnProperty;
var toString = ref.toString;
var hasOwn = Object.hasOwn || function(obj, propName) {
  return hasOwnProperty.call(obj, propName);
};
var isArray = Array.isArray || function(obj) {
  return toString.call(obj) === "[object Array]";
};
var regexpCache = /* @__PURE__ */ Object.create(null);
function wordsRegexp(words) {
  return regexpCache[words] || (regexpCache[words] = new RegExp("^(?:" + words.replace(/ /g, "|") + ")$"));
}
__name(wordsRegexp, "wordsRegexp");
function codePointToString(code) {
  if (code <= 65535) {
    return String.fromCharCode(code);
  }
  code -= 65536;
  return String.fromCharCode((code >> 10) + 55296, (code & 1023) + 56320);
}
__name(codePointToString, "codePointToString");
var loneSurrogate = /(?:[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])/;
var Position = /* @__PURE__ */ __name(function Position2(line, col) {
  this.line = line;
  this.column = col;
}, "Position");
Position.prototype.offset = /* @__PURE__ */ __name(function offset(n) {
  return new Position(this.line, this.column + n);
}, "offset");
var SourceLocation = /* @__PURE__ */ __name(function SourceLocation2(p, start, end) {
  this.start = start;
  this.end = end;
  if (p.sourceFile !== null) {
    this.source = p.sourceFile;
  }
}, "SourceLocation");
function getLineInfo(input, offset2) {
  for (var line = 1, cur = 0; ; ) {
    var nextBreak = nextLineBreak(input, cur, offset2);
    if (nextBreak < 0) {
      return new Position(line, offset2 - cur);
    }
    ++line;
    cur = nextBreak;
  }
}
__name(getLineInfo, "getLineInfo");
var defaultOptions = {
  // `ecmaVersion` indicates the ECMAScript version to parse. Must be
  // either 3, 5, 6 (or 2015), 7 (2016), 8 (2017), 9 (2018), 10
  // (2019), 11 (2020), 12 (2021), 13 (2022), 14 (2023), or `"latest"`
  // (the latest version the library supports). This influences
  // support for strict mode, the set of reserved words, and support
  // for new syntax features.
  ecmaVersion: null,
  // `sourceType` indicates the mode the code should be parsed in.
  // Can be either `"script"` or `"module"`. This influences global
  // strict mode and parsing of `import` and `export` declarations.
  sourceType: "script",
  // `onInsertedSemicolon` can be a callback that will be called when
  // a semicolon is automatically inserted. It will be passed the
  // position of the inserted semicolon as an offset, and if
  // `locations` is enabled, it is given the location as a `{line,
  // column}` object as second argument.
  onInsertedSemicolon: null,
  // `onTrailingComma` is similar to `onInsertedSemicolon`, but for
  // trailing commas.
  onTrailingComma: null,
  // By default, reserved words are only enforced if ecmaVersion >= 5.
  // Set `allowReserved` to a boolean value to explicitly turn this on
  // an off. When this option has the value "never", reserved words
  // and keywords can also not be used as property names.
  allowReserved: null,
  // When enabled, a return at the top level is not considered an
  // error.
  allowReturnOutsideFunction: false,
  // When enabled, import/export statements are not constrained to
  // appearing at the top of the program, and an import.meta expression
  // in a script isn't considered an error.
  allowImportExportEverywhere: false,
  // By default, await identifiers are allowed to appear at the top-level scope only if ecmaVersion >= 2022.
  // When enabled, await identifiers are allowed to appear at the top-level scope,
  // but they are still not allowed in non-async functions.
  allowAwaitOutsideFunction: null,
  // When enabled, super identifiers are not constrained to
  // appearing in methods and do not raise an error when they appear elsewhere.
  allowSuperOutsideMethod: null,
  // When enabled, hashbang directive in the beginning of file is
  // allowed and treated as a line comment. Enabled by default when
  // `ecmaVersion` >= 2023.
  allowHashBang: false,
  // By default, the parser will verify that private properties are
  // only used in places where they are valid and have been declared.
  // Set this to false to turn such checks off.
  checkPrivateFields: true,
  // When `locations` is on, `loc` properties holding objects with
  // `start` and `end` properties in `{line, column}` form (with
  // line being 1-based and column 0-based) will be attached to the
  // nodes.
  locations: false,
  // A function can be passed as `onToken` option, which will
  // cause Acorn to call that function with object in the same
  // format as tokens returned from `tokenizer().getToken()`. Note
  // that you are not allowed to call the parser from the
  // callback—that will corrupt its internal state.
  onToken: null,
  // A function can be passed as `onComment` option, which will
  // cause Acorn to call that function with `(block, text, start,
  // end)` parameters whenever a comment is skipped. `block` is a
  // boolean indicating whether this is a block (`/* */`) comment,
  // `text` is the content of the comment, and `start` and `end` are
  // character offsets that denote the start and end of the comment.
  // When the `locations` option is on, two more parameters are
  // passed, the full `{line, column}` locations of the start and
  // end of the comments. Note that you are not allowed to call the
  // parser from the callback—that will corrupt its internal state.
  // When this option has an array as value, objects representing the
  // comments are pushed to it.
  onComment: null,
  // Nodes have their start and end characters offsets recorded in
  // `start` and `end` properties (directly on the node, rather than
  // the `loc` object, which holds line/column data. To also add a
  // [semi-standardized][range] `range` property holding a `[start,
  // end]` array with the same numbers, set the `ranges` option to
  // `true`.
  //
  // [range]: https://bugzilla.mozilla.org/show_bug.cgi?id=745678
  ranges: false,
  // It is possible to parse multiple files into a single AST by
  // passing the tree produced by parsing the first file as
  // `program` option in subsequent parses. This will add the
  // toplevel forms of the parsed file to the `Program` (top) node
  // of an existing parse tree.
  program: null,
  // When `locations` is on, you can pass this to record the source
  // file in every node's `loc` object.
  sourceFile: null,
  // This value, if given, is stored in every node, whether
  // `locations` is on or off.
  directSourceFile: null,
  // When enabled, parenthesized expressions are represented by
  // (non-standard) ParenthesizedExpression nodes
  preserveParens: false
};
var warnedAboutEcmaVersion = false;
function getOptions(opts) {
  var options = {};
  for (var opt in defaultOptions) {
    options[opt] = opts && hasOwn(opts, opt) ? opts[opt] : defaultOptions[opt];
  }
  if (options.ecmaVersion === "latest") {
    options.ecmaVersion = 1e8;
  } else if (options.ecmaVersion == null) {
    if (!warnedAboutEcmaVersion && typeof console === "object" && console.warn) {
      warnedAboutEcmaVersion = true;
      console.warn("Since Acorn 8.0.0, options.ecmaVersion is required.\nDefaulting to 2020, but this will stop working in the future.");
    }
    options.ecmaVersion = 11;
  } else if (options.ecmaVersion >= 2015) {
    options.ecmaVersion -= 2009;
  }
  if (options.allowReserved == null) {
    options.allowReserved = options.ecmaVersion < 5;
  }
  if (!opts || opts.allowHashBang == null) {
    options.allowHashBang = options.ecmaVersion >= 14;
  }
  if (isArray(options.onToken)) {
    var tokens = options.onToken;
    options.onToken = function(token) {
      return tokens.push(token);
    };
  }
  if (isArray(options.onComment)) {
    options.onComment = pushComment(options, options.onComment);
  }
  return options;
}
__name(getOptions, "getOptions");
function pushComment(options, array) {
  return function(block, text, start, end, startLoc, endLoc) {
    var comment = {
      type: block ? "Block" : "Line",
      value: text,
      start,
      end
    };
    if (options.locations) {
      comment.loc = new SourceLocation(this, startLoc, endLoc);
    }
    if (options.ranges) {
      comment.range = [start, end];
    }
    array.push(comment);
  };
}
__name(pushComment, "pushComment");
var SCOPE_TOP = 1;
var SCOPE_FUNCTION = 2;
var SCOPE_ASYNC = 4;
var SCOPE_GENERATOR = 8;
var SCOPE_ARROW = 16;
var SCOPE_SIMPLE_CATCH = 32;
var SCOPE_SUPER = 64;
var SCOPE_DIRECT_SUPER = 128;
var SCOPE_CLASS_STATIC_BLOCK = 256;
var SCOPE_VAR = SCOPE_TOP | SCOPE_FUNCTION | SCOPE_CLASS_STATIC_BLOCK;
function functionFlags(async, generator) {
  return SCOPE_FUNCTION | (async ? SCOPE_ASYNC : 0) | (generator ? SCOPE_GENERATOR : 0);
}
__name(functionFlags, "functionFlags");
var BIND_NONE = 0;
var BIND_VAR = 1;
var BIND_LEXICAL = 2;
var BIND_FUNCTION = 3;
var BIND_SIMPLE_CATCH = 4;
var BIND_OUTSIDE = 5;
var Parser = /* @__PURE__ */ __name(function Parser2(options, input, startPos) {
  this.options = options = getOptions(options);
  this.sourceFile = options.sourceFile;
  this.keywords = wordsRegexp(keywords$1[options.ecmaVersion >= 6 ? 6 : options.sourceType === "module" ? "5module" : 5]);
  var reserved = "";
  if (options.allowReserved !== true) {
    reserved = reservedWords[options.ecmaVersion >= 6 ? 6 : options.ecmaVersion === 5 ? 5 : 3];
    if (options.sourceType === "module") {
      reserved += " await";
    }
  }
  this.reservedWords = wordsRegexp(reserved);
  var reservedStrict = (reserved ? reserved + " " : "") + reservedWords.strict;
  this.reservedWordsStrict = wordsRegexp(reservedStrict);
  this.reservedWordsStrictBind = wordsRegexp(reservedStrict + " " + reservedWords.strictBind);
  this.input = String(input);
  this.containsEsc = false;
  if (startPos) {
    this.pos = startPos;
    this.lineStart = this.input.lastIndexOf("\n", startPos - 1) + 1;
    this.curLine = this.input.slice(0, this.lineStart).split(lineBreak).length;
  } else {
    this.pos = this.lineStart = 0;
    this.curLine = 1;
  }
  this.type = types$1.eof;
  this.value = null;
  this.start = this.end = this.pos;
  this.startLoc = this.endLoc = this.curPosition();
  this.lastTokEndLoc = this.lastTokStartLoc = null;
  this.lastTokStart = this.lastTokEnd = this.pos;
  this.context = this.initialContext();
  this.exprAllowed = true;
  this.inModule = options.sourceType === "module";
  this.strict = this.inModule || this.strictDirective(this.pos);
  this.potentialArrowAt = -1;
  this.potentialArrowInForAwait = false;
  this.yieldPos = this.awaitPos = this.awaitIdentPos = 0;
  this.labels = [];
  this.undefinedExports = /* @__PURE__ */ Object.create(null);
  if (this.pos === 0 && options.allowHashBang && this.input.slice(0, 2) === "#!") {
    this.skipLineComment(2);
  }
  this.scopeStack = [];
  this.enterScope(SCOPE_TOP);
  this.regexpState = null;
  this.privateNameStack = [];
}, "Parser");
var prototypeAccessors = { inFunction: { configurable: true }, inGenerator: { configurable: true }, inAsync: { configurable: true }, canAwait: { configurable: true }, allowSuper: { configurable: true }, allowDirectSuper: { configurable: true }, treatFunctionsAsVar: { configurable: true }, allowNewDotTarget: { configurable: true }, inClassStaticBlock: { configurable: true } };
Parser.prototype.parse = /* @__PURE__ */ __name(function parse() {
  var node = this.options.program || this.startNode();
  this.nextToken();
  return this.parseTopLevel(node);
}, "parse");
prototypeAccessors.inFunction.get = function() {
  return (this.currentVarScope().flags & SCOPE_FUNCTION) > 0;
};
prototypeAccessors.inGenerator.get = function() {
  return (this.currentVarScope().flags & SCOPE_GENERATOR) > 0 && !this.currentVarScope().inClassFieldInit;
};
prototypeAccessors.inAsync.get = function() {
  return (this.currentVarScope().flags & SCOPE_ASYNC) > 0 && !this.currentVarScope().inClassFieldInit;
};
prototypeAccessors.canAwait.get = function() {
  for (var i = this.scopeStack.length - 1; i >= 0; i--) {
    var scope = this.scopeStack[i];
    if (scope.inClassFieldInit || scope.flags & SCOPE_CLASS_STATIC_BLOCK) {
      return false;
    }
    if (scope.flags & SCOPE_FUNCTION) {
      return (scope.flags & SCOPE_ASYNC) > 0;
    }
  }
  return this.inModule && this.options.ecmaVersion >= 13 || this.options.allowAwaitOutsideFunction;
};
prototypeAccessors.allowSuper.get = function() {
  var ref2 = this.currentThisScope();
  var flags = ref2.flags;
  var inClassFieldInit = ref2.inClassFieldInit;
  return (flags & SCOPE_SUPER) > 0 || inClassFieldInit || this.options.allowSuperOutsideMethod;
};
prototypeAccessors.allowDirectSuper.get = function() {
  return (this.currentThisScope().flags & SCOPE_DIRECT_SUPER) > 0;
};
prototypeAccessors.treatFunctionsAsVar.get = function() {
  return this.treatFunctionsAsVarInScope(this.currentScope());
};
prototypeAccessors.allowNewDotTarget.get = function() {
  var ref2 = this.currentThisScope();
  var flags = ref2.flags;
  var inClassFieldInit = ref2.inClassFieldInit;
  return (flags & (SCOPE_FUNCTION | SCOPE_CLASS_STATIC_BLOCK)) > 0 || inClassFieldInit;
};
prototypeAccessors.inClassStaticBlock.get = function() {
  return (this.currentVarScope().flags & SCOPE_CLASS_STATIC_BLOCK) > 0;
};
Parser.extend = /* @__PURE__ */ __name(function extend() {
  var plugins = [], len = arguments.length;
  while (len--) plugins[len] = arguments[len];
  var cls = this;
  for (var i = 0; i < plugins.length; i++) {
    cls = plugins[i](cls);
  }
  return cls;
}, "extend");
Parser.parse = /* @__PURE__ */ __name(function parse2(input, options) {
  return new this(options, input).parse();
}, "parse");
Parser.parseExpressionAt = /* @__PURE__ */ __name(function parseExpressionAt(input, pos, options) {
  var parser = new this(options, input, pos);
  parser.nextToken();
  return parser.parseExpression();
}, "parseExpressionAt");
Parser.tokenizer = /* @__PURE__ */ __name(function tokenizer(input, options) {
  return new this(options, input);
}, "tokenizer");
Object.defineProperties(Parser.prototype, prototypeAccessors);
var pp$9 = Parser.prototype;
var literal = /^(?:'((?:\\[^]|[^'\\])*?)'|"((?:\\[^]|[^"\\])*?)")/;
pp$9.strictDirective = function(start) {
  if (this.options.ecmaVersion < 5) {
    return false;
  }
  for (; ; ) {
    skipWhiteSpace.lastIndex = start;
    start += skipWhiteSpace.exec(this.input)[0].length;
    var match = literal.exec(this.input.slice(start));
    if (!match) {
      return false;
    }
    if ((match[1] || match[2]) === "use strict") {
      skipWhiteSpace.lastIndex = start + match[0].length;
      var spaceAfter = skipWhiteSpace.exec(this.input), end = spaceAfter.index + spaceAfter[0].length;
      var next = this.input.charAt(end);
      return next === ";" || next === "}" || lineBreak.test(spaceAfter[0]) && !(/[(`.[+\-/*%<>=,?^&]/.test(next) || next === "!" && this.input.charAt(end + 1) === "=");
    }
    start += match[0].length;
    skipWhiteSpace.lastIndex = start;
    start += skipWhiteSpace.exec(this.input)[0].length;
    if (this.input[start] === ";") {
      start++;
    }
  }
};
pp$9.eat = function(type) {
  if (this.type === type) {
    this.next();
    return true;
  } else {
    return false;
  }
};
pp$9.isContextual = function(name) {
  return this.type === types$1.name && this.value === name && !this.containsEsc;
};
pp$9.eatContextual = function(name) {
  if (!this.isContextual(name)) {
    return false;
  }
  this.next();
  return true;
};
pp$9.expectContextual = function(name) {
  if (!this.eatContextual(name)) {
    this.unexpected();
  }
};
pp$9.canInsertSemicolon = function() {
  return this.type === types$1.eof || this.type === types$1.braceR || lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
};
pp$9.insertSemicolon = function() {
  if (this.canInsertSemicolon()) {
    if (this.options.onInsertedSemicolon) {
      this.options.onInsertedSemicolon(this.lastTokEnd, this.lastTokEndLoc);
    }
    return true;
  }
};
pp$9.semicolon = function() {
  if (!this.eat(types$1.semi) && !this.insertSemicolon()) {
    this.unexpected();
  }
};
pp$9.afterTrailingComma = function(tokType, notNext) {
  if (this.type === tokType) {
    if (this.options.onTrailingComma) {
      this.options.onTrailingComma(this.lastTokStart, this.lastTokStartLoc);
    }
    if (!notNext) {
      this.next();
    }
    return true;
  }
};
pp$9.expect = function(type) {
  this.eat(type) || this.unexpected();
};
pp$9.unexpected = function(pos) {
  this.raise(pos != null ? pos : this.start, "Unexpected token");
};
var DestructuringErrors = /* @__PURE__ */ __name(function DestructuringErrors2() {
  this.shorthandAssign = this.trailingComma = this.parenthesizedAssign = this.parenthesizedBind = this.doubleProto = -1;
}, "DestructuringErrors");
pp$9.checkPatternErrors = function(refDestructuringErrors, isAssign) {
  if (!refDestructuringErrors) {
    return;
  }
  if (refDestructuringErrors.trailingComma > -1) {
    this.raiseRecoverable(refDestructuringErrors.trailingComma, "Comma is not permitted after the rest element");
  }
  var parens = isAssign ? refDestructuringErrors.parenthesizedAssign : refDestructuringErrors.parenthesizedBind;
  if (parens > -1) {
    this.raiseRecoverable(parens, isAssign ? "Assigning to rvalue" : "Parenthesized pattern");
  }
};
pp$9.checkExpressionErrors = function(refDestructuringErrors, andThrow) {
  if (!refDestructuringErrors) {
    return false;
  }
  var shorthandAssign = refDestructuringErrors.shorthandAssign;
  var doubleProto = refDestructuringErrors.doubleProto;
  if (!andThrow) {
    return shorthandAssign >= 0 || doubleProto >= 0;
  }
  if (shorthandAssign >= 0) {
    this.raise(shorthandAssign, "Shorthand property assignments are valid only in destructuring patterns");
  }
  if (doubleProto >= 0) {
    this.raiseRecoverable(doubleProto, "Redefinition of __proto__ property");
  }
};
pp$9.checkYieldAwaitInDefaultParams = function() {
  if (this.yieldPos && (!this.awaitPos || this.yieldPos < this.awaitPos)) {
    this.raise(this.yieldPos, "Yield expression cannot be a default value");
  }
  if (this.awaitPos) {
    this.raise(this.awaitPos, "Await expression cannot be a default value");
  }
};
pp$9.isSimpleAssignTarget = function(expr) {
  if (expr.type === "ParenthesizedExpression") {
    return this.isSimpleAssignTarget(expr.expression);
  }
  return expr.type === "Identifier" || expr.type === "MemberExpression";
};
var pp$8 = Parser.prototype;
pp$8.parseTopLevel = function(node) {
  var exports = /* @__PURE__ */ Object.create(null);
  if (!node.body) {
    node.body = [];
  }
  while (this.type !== types$1.eof) {
    var stmt = this.parseStatement(null, true, exports);
    node.body.push(stmt);
  }
  if (this.inModule) {
    for (var i = 0, list = Object.keys(this.undefinedExports); i < list.length; i += 1) {
      var name = list[i];
      this.raiseRecoverable(this.undefinedExports[name].start, "Export '" + name + "' is not defined");
    }
  }
  this.adaptDirectivePrologue(node.body);
  this.next();
  node.sourceType = this.options.sourceType;
  return this.finishNode(node, "Program");
};
var loopLabel = { kind: "loop" };
var switchLabel = { kind: "switch" };
pp$8.isLet = function(context) {
  if (this.options.ecmaVersion < 6 || !this.isContextual("let")) {
    return false;
  }
  skipWhiteSpace.lastIndex = this.pos;
  var skip = skipWhiteSpace.exec(this.input);
  var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
  if (nextCh === 91 || nextCh === 92) {
    return true;
  }
  if (context) {
    return false;
  }
  if (nextCh === 123 || nextCh > 55295 && nextCh < 56320) {
    return true;
  }
  if (isIdentifierStart(nextCh, true)) {
    var pos = next + 1;
    while (isIdentifierChar(nextCh = this.input.charCodeAt(pos), true)) {
      ++pos;
    }
    if (nextCh === 92 || nextCh > 55295 && nextCh < 56320) {
      return true;
    }
    var ident = this.input.slice(next, pos);
    if (!keywordRelationalOperator.test(ident)) {
      return true;
    }
  }
  return false;
};
pp$8.isAsyncFunction = function() {
  if (this.options.ecmaVersion < 8 || !this.isContextual("async")) {
    return false;
  }
  skipWhiteSpace.lastIndex = this.pos;
  var skip = skipWhiteSpace.exec(this.input);
  var next = this.pos + skip[0].length, after;
  return !lineBreak.test(this.input.slice(this.pos, next)) && this.input.slice(next, next + 8) === "function" && (next + 8 === this.input.length || !(isIdentifierChar(after = this.input.charCodeAt(next + 8)) || after > 55295 && after < 56320));
};
pp$8.parseStatement = function(context, topLevel, exports) {
  var starttype = this.type, node = this.startNode(), kind;
  if (this.isLet(context)) {
    starttype = types$1._var;
    kind = "let";
  }
  switch (starttype) {
    case types$1._break:
    case types$1._continue:
      return this.parseBreakContinueStatement(node, starttype.keyword);
    case types$1._debugger:
      return this.parseDebuggerStatement(node);
    case types$1._do:
      return this.parseDoStatement(node);
    case types$1._for:
      return this.parseForStatement(node);
    case types$1._function:
      if (context && (this.strict || context !== "if" && context !== "label") && this.options.ecmaVersion >= 6) {
        this.unexpected();
      }
      return this.parseFunctionStatement(node, false, !context);
    case types$1._class:
      if (context) {
        this.unexpected();
      }
      return this.parseClass(node, true);
    case types$1._if:
      return this.parseIfStatement(node);
    case types$1._return:
      return this.parseReturnStatement(node);
    case types$1._switch:
      return this.parseSwitchStatement(node);
    case types$1._throw:
      return this.parseThrowStatement(node);
    case types$1._try:
      return this.parseTryStatement(node);
    case types$1._const:
    case types$1._var:
      kind = kind || this.value;
      if (context && kind !== "var") {
        this.unexpected();
      }
      return this.parseVarStatement(node, kind);
    case types$1._while:
      return this.parseWhileStatement(node);
    case types$1._with:
      return this.parseWithStatement(node);
    case types$1.braceL:
      return this.parseBlock(true, node);
    case types$1.semi:
      return this.parseEmptyStatement(node);
    case types$1._export:
    case types$1._import:
      if (this.options.ecmaVersion > 10 && starttype === types$1._import) {
        skipWhiteSpace.lastIndex = this.pos;
        var skip = skipWhiteSpace.exec(this.input);
        var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
        if (nextCh === 40 || nextCh === 46) {
          return this.parseExpressionStatement(node, this.parseExpression());
        }
      }
      if (!this.options.allowImportExportEverywhere) {
        if (!topLevel) {
          this.raise(this.start, "'import' and 'export' may only appear at the top level");
        }
        if (!this.inModule) {
          this.raise(this.start, "'import' and 'export' may appear only with 'sourceType: module'");
        }
      }
      return starttype === types$1._import ? this.parseImport(node) : this.parseExport(node, exports);
    // If the statement does not start with a statement keyword or a
    // brace, it's an ExpressionStatement or LabeledStatement. We
    // simply start parsing an expression, and afterwards, if the
    // next token is a colon and the expression was a simple
    // Identifier node, we switch to interpreting it as a label.
    default:
      if (this.isAsyncFunction()) {
        if (context) {
          this.unexpected();
        }
        this.next();
        return this.parseFunctionStatement(node, true, !context);
      }
      var maybeName = this.value, expr = this.parseExpression();
      if (starttype === types$1.name && expr.type === "Identifier" && this.eat(types$1.colon)) {
        return this.parseLabeledStatement(node, maybeName, expr, context);
      } else {
        return this.parseExpressionStatement(node, expr);
      }
  }
};
pp$8.parseBreakContinueStatement = function(node, keyword) {
  var isBreak = keyword === "break";
  this.next();
  if (this.eat(types$1.semi) || this.insertSemicolon()) {
    node.label = null;
  } else if (this.type !== types$1.name) {
    this.unexpected();
  } else {
    node.label = this.parseIdent();
    this.semicolon();
  }
  var i = 0;
  for (; i < this.labels.length; ++i) {
    var lab = this.labels[i];
    if (node.label == null || lab.name === node.label.name) {
      if (lab.kind != null && (isBreak || lab.kind === "loop")) {
        break;
      }
      if (node.label && isBreak) {
        break;
      }
    }
  }
  if (i === this.labels.length) {
    this.raise(node.start, "Unsyntactic " + keyword);
  }
  return this.finishNode(node, isBreak ? "BreakStatement" : "ContinueStatement");
};
pp$8.parseDebuggerStatement = function(node) {
  this.next();
  this.semicolon();
  return this.finishNode(node, "DebuggerStatement");
};
pp$8.parseDoStatement = function(node) {
  this.next();
  this.labels.push(loopLabel);
  node.body = this.parseStatement("do");
  this.labels.pop();
  this.expect(types$1._while);
  node.test = this.parseParenExpression();
  if (this.options.ecmaVersion >= 6) {
    this.eat(types$1.semi);
  } else {
    this.semicolon();
  }
  return this.finishNode(node, "DoWhileStatement");
};
pp$8.parseForStatement = function(node) {
  this.next();
  var awaitAt = this.options.ecmaVersion >= 9 && this.canAwait && this.eatContextual("await") ? this.lastTokStart : -1;
  this.labels.push(loopLabel);
  this.enterScope(0);
  this.expect(types$1.parenL);
  if (this.type === types$1.semi) {
    if (awaitAt > -1) {
      this.unexpected(awaitAt);
    }
    return this.parseFor(node, null);
  }
  var isLet = this.isLet();
  if (this.type === types$1._var || this.type === types$1._const || isLet) {
    var init$1 = this.startNode(), kind = isLet ? "let" : this.value;
    this.next();
    this.parseVar(init$1, true, kind);
    this.finishNode(init$1, "VariableDeclaration");
    if ((this.type === types$1._in || this.options.ecmaVersion >= 6 && this.isContextual("of")) && init$1.declarations.length === 1) {
      if (this.options.ecmaVersion >= 9) {
        if (this.type === types$1._in) {
          if (awaitAt > -1) {
            this.unexpected(awaitAt);
          }
        } else {
          node.await = awaitAt > -1;
        }
      }
      return this.parseForIn(node, init$1);
    }
    if (awaitAt > -1) {
      this.unexpected(awaitAt);
    }
    return this.parseFor(node, init$1);
  }
  var startsWithLet = this.isContextual("let"), isForOf = false;
  var containsEsc = this.containsEsc;
  var refDestructuringErrors = new DestructuringErrors();
  var initPos = this.start;
  var init = awaitAt > -1 ? this.parseExprSubscripts(refDestructuringErrors, "await") : this.parseExpression(true, refDestructuringErrors);
  if (this.type === types$1._in || (isForOf = this.options.ecmaVersion >= 6 && this.isContextual("of"))) {
    if (awaitAt > -1) {
      if (this.type === types$1._in) {
        this.unexpected(awaitAt);
      }
      node.await = true;
    } else if (isForOf && this.options.ecmaVersion >= 8) {
      if (init.start === initPos && !containsEsc && init.type === "Identifier" && init.name === "async") {
        this.unexpected();
      } else if (this.options.ecmaVersion >= 9) {
        node.await = false;
      }
    }
    if (startsWithLet && isForOf) {
      this.raise(init.start, "The left-hand side of a for-of loop may not start with 'let'.");
    }
    this.toAssignable(init, false, refDestructuringErrors);
    this.checkLValPattern(init);
    return this.parseForIn(node, init);
  } else {
    this.checkExpressionErrors(refDestructuringErrors, true);
  }
  if (awaitAt > -1) {
    this.unexpected(awaitAt);
  }
  return this.parseFor(node, init);
};
pp$8.parseFunctionStatement = function(node, isAsync, declarationPosition) {
  this.next();
  return this.parseFunction(node, FUNC_STATEMENT | (declarationPosition ? 0 : FUNC_HANGING_STATEMENT), false, isAsync);
};
pp$8.parseIfStatement = function(node) {
  this.next();
  node.test = this.parseParenExpression();
  node.consequent = this.parseStatement("if");
  node.alternate = this.eat(types$1._else) ? this.parseStatement("if") : null;
  return this.finishNode(node, "IfStatement");
};
pp$8.parseReturnStatement = function(node) {
  if (!this.inFunction && !this.options.allowReturnOutsideFunction) {
    this.raise(this.start, "'return' outside of function");
  }
  this.next();
  if (this.eat(types$1.semi) || this.insertSemicolon()) {
    node.argument = null;
  } else {
    node.argument = this.parseExpression();
    this.semicolon();
  }
  return this.finishNode(node, "ReturnStatement");
};
pp$8.parseSwitchStatement = function(node) {
  this.next();
  node.discriminant = this.parseParenExpression();
  node.cases = [];
  this.expect(types$1.braceL);
  this.labels.push(switchLabel);
  this.enterScope(0);
  var cur;
  for (var sawDefault = false; this.type !== types$1.braceR; ) {
    if (this.type === types$1._case || this.type === types$1._default) {
      var isCase = this.type === types$1._case;
      if (cur) {
        this.finishNode(cur, "SwitchCase");
      }
      node.cases.push(cur = this.startNode());
      cur.consequent = [];
      this.next();
      if (isCase) {
        cur.test = this.parseExpression();
      } else {
        if (sawDefault) {
          this.raiseRecoverable(this.lastTokStart, "Multiple default clauses");
        }
        sawDefault = true;
        cur.test = null;
      }
      this.expect(types$1.colon);
    } else {
      if (!cur) {
        this.unexpected();
      }
      cur.consequent.push(this.parseStatement(null));
    }
  }
  this.exitScope();
  if (cur) {
    this.finishNode(cur, "SwitchCase");
  }
  this.next();
  this.labels.pop();
  return this.finishNode(node, "SwitchStatement");
};
pp$8.parseThrowStatement = function(node) {
  this.next();
  if (lineBreak.test(this.input.slice(this.lastTokEnd, this.start))) {
    this.raise(this.lastTokEnd, "Illegal newline after throw");
  }
  node.argument = this.parseExpression();
  this.semicolon();
  return this.finishNode(node, "ThrowStatement");
};
var empty$1 = [];
pp$8.parseCatchClauseParam = function() {
  var param = this.parseBindingAtom();
  var simple = param.type === "Identifier";
  this.enterScope(simple ? SCOPE_SIMPLE_CATCH : 0);
  this.checkLValPattern(param, simple ? BIND_SIMPLE_CATCH : BIND_LEXICAL);
  this.expect(types$1.parenR);
  return param;
};
pp$8.parseTryStatement = function(node) {
  this.next();
  node.block = this.parseBlock();
  node.handler = null;
  if (this.type === types$1._catch) {
    var clause = this.startNode();
    this.next();
    if (this.eat(types$1.parenL)) {
      clause.param = this.parseCatchClauseParam();
    } else {
      if (this.options.ecmaVersion < 10) {
        this.unexpected();
      }
      clause.param = null;
      this.enterScope(0);
    }
    clause.body = this.parseBlock(false);
    this.exitScope();
    node.handler = this.finishNode(clause, "CatchClause");
  }
  node.finalizer = this.eat(types$1._finally) ? this.parseBlock() : null;
  if (!node.handler && !node.finalizer) {
    this.raise(node.start, "Missing catch or finally clause");
  }
  return this.finishNode(node, "TryStatement");
};
pp$8.parseVarStatement = function(node, kind, allowMissingInitializer) {
  this.next();
  this.parseVar(node, false, kind, allowMissingInitializer);
  this.semicolon();
  return this.finishNode(node, "VariableDeclaration");
};
pp$8.parseWhileStatement = function(node) {
  this.next();
  node.test = this.parseParenExpression();
  this.labels.push(loopLabel);
  node.body = this.parseStatement("while");
  this.labels.pop();
  return this.finishNode(node, "WhileStatement");
};
pp$8.parseWithStatement = function(node) {
  if (this.strict) {
    this.raise(this.start, "'with' in strict mode");
  }
  this.next();
  node.object = this.parseParenExpression();
  node.body = this.parseStatement("with");
  return this.finishNode(node, "WithStatement");
};
pp$8.parseEmptyStatement = function(node) {
  this.next();
  return this.finishNode(node, "EmptyStatement");
};
pp$8.parseLabeledStatement = function(node, maybeName, expr, context) {
  for (var i$1 = 0, list = this.labels; i$1 < list.length; i$1 += 1) {
    var label = list[i$1];
    if (label.name === maybeName) {
      this.raise(expr.start, "Label '" + maybeName + "' is already declared");
    }
  }
  var kind = this.type.isLoop ? "loop" : this.type === types$1._switch ? "switch" : null;
  for (var i = this.labels.length - 1; i >= 0; i--) {
    var label$1 = this.labels[i];
    if (label$1.statementStart === node.start) {
      label$1.statementStart = this.start;
      label$1.kind = kind;
    } else {
      break;
    }
  }
  this.labels.push({ name: maybeName, kind, statementStart: this.start });
  node.body = this.parseStatement(context ? context.indexOf("label") === -1 ? context + "label" : context : "label");
  this.labels.pop();
  node.label = expr;
  return this.finishNode(node, "LabeledStatement");
};
pp$8.parseExpressionStatement = function(node, expr) {
  node.expression = expr;
  this.semicolon();
  return this.finishNode(node, "ExpressionStatement");
};
pp$8.parseBlock = function(createNewLexicalScope, node, exitStrict) {
  if (createNewLexicalScope === void 0) createNewLexicalScope = true;
  if (node === void 0) node = this.startNode();
  node.body = [];
  this.expect(types$1.braceL);
  if (createNewLexicalScope) {
    this.enterScope(0);
  }
  while (this.type !== types$1.braceR) {
    var stmt = this.parseStatement(null);
    node.body.push(stmt);
  }
  if (exitStrict) {
    this.strict = false;
  }
  this.next();
  if (createNewLexicalScope) {
    this.exitScope();
  }
  return this.finishNode(node, "BlockStatement");
};
pp$8.parseFor = function(node, init) {
  node.init = init;
  this.expect(types$1.semi);
  node.test = this.type === types$1.semi ? null : this.parseExpression();
  this.expect(types$1.semi);
  node.update = this.type === types$1.parenR ? null : this.parseExpression();
  this.expect(types$1.parenR);
  node.body = this.parseStatement("for");
  this.exitScope();
  this.labels.pop();
  return this.finishNode(node, "ForStatement");
};
pp$8.parseForIn = function(node, init) {
  var isForIn = this.type === types$1._in;
  this.next();
  if (init.type === "VariableDeclaration" && init.declarations[0].init != null && (!isForIn || this.options.ecmaVersion < 8 || this.strict || init.kind !== "var" || init.declarations[0].id.type !== "Identifier")) {
    this.raise(
      init.start,
      (isForIn ? "for-in" : "for-of") + " loop variable declaration may not have an initializer"
    );
  }
  node.left = init;
  node.right = isForIn ? this.parseExpression() : this.parseMaybeAssign();
  this.expect(types$1.parenR);
  node.body = this.parseStatement("for");
  this.exitScope();
  this.labels.pop();
  return this.finishNode(node, isForIn ? "ForInStatement" : "ForOfStatement");
};
pp$8.parseVar = function(node, isFor, kind, allowMissingInitializer) {
  node.declarations = [];
  node.kind = kind;
  for (; ; ) {
    var decl = this.startNode();
    this.parseVarId(decl, kind);
    if (this.eat(types$1.eq)) {
      decl.init = this.parseMaybeAssign(isFor);
    } else if (!allowMissingInitializer && kind === "const" && !(this.type === types$1._in || this.options.ecmaVersion >= 6 && this.isContextual("of"))) {
      this.unexpected();
    } else if (!allowMissingInitializer && decl.id.type !== "Identifier" && !(isFor && (this.type === types$1._in || this.isContextual("of")))) {
      this.raise(this.lastTokEnd, "Complex binding patterns require an initialization value");
    } else {
      decl.init = null;
    }
    node.declarations.push(this.finishNode(decl, "VariableDeclarator"));
    if (!this.eat(types$1.comma)) {
      break;
    }
  }
  return node;
};
pp$8.parseVarId = function(decl, kind) {
  decl.id = this.parseBindingAtom();
  this.checkLValPattern(decl.id, kind === "var" ? BIND_VAR : BIND_LEXICAL, false);
};
var FUNC_STATEMENT = 1;
var FUNC_HANGING_STATEMENT = 2;
var FUNC_NULLABLE_ID = 4;
pp$8.parseFunction = function(node, statement, allowExpressionBody, isAsync, forInit) {
  this.initFunction(node);
  if (this.options.ecmaVersion >= 9 || this.options.ecmaVersion >= 6 && !isAsync) {
    if (this.type === types$1.star && statement & FUNC_HANGING_STATEMENT) {
      this.unexpected();
    }
    node.generator = this.eat(types$1.star);
  }
  if (this.options.ecmaVersion >= 8) {
    node.async = !!isAsync;
  }
  if (statement & FUNC_STATEMENT) {
    node.id = statement & FUNC_NULLABLE_ID && this.type !== types$1.name ? null : this.parseIdent();
    if (node.id && !(statement & FUNC_HANGING_STATEMENT)) {
      this.checkLValSimple(node.id, this.strict || node.generator || node.async ? this.treatFunctionsAsVar ? BIND_VAR : BIND_LEXICAL : BIND_FUNCTION);
    }
  }
  var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
  this.yieldPos = 0;
  this.awaitPos = 0;
  this.awaitIdentPos = 0;
  this.enterScope(functionFlags(node.async, node.generator));
  if (!(statement & FUNC_STATEMENT)) {
    node.id = this.type === types$1.name ? this.parseIdent() : null;
  }
  this.parseFunctionParams(node);
  this.parseFunctionBody(node, allowExpressionBody, false, forInit);
  this.yieldPos = oldYieldPos;
  this.awaitPos = oldAwaitPos;
  this.awaitIdentPos = oldAwaitIdentPos;
  return this.finishNode(node, statement & FUNC_STATEMENT ? "FunctionDeclaration" : "FunctionExpression");
};
pp$8.parseFunctionParams = function(node) {
  this.expect(types$1.parenL);
  node.params = this.parseBindingList(types$1.parenR, false, this.options.ecmaVersion >= 8);
  this.checkYieldAwaitInDefaultParams();
};
pp$8.parseClass = function(node, isStatement) {
  this.next();
  var oldStrict = this.strict;
  this.strict = true;
  this.parseClassId(node, isStatement);
  this.parseClassSuper(node);
  var privateNameMap = this.enterClassBody();
  var classBody = this.startNode();
  var hadConstructor = false;
  classBody.body = [];
  this.expect(types$1.braceL);
  while (this.type !== types$1.braceR) {
    var element = this.parseClassElement(node.superClass !== null);
    if (element) {
      classBody.body.push(element);
      if (element.type === "MethodDefinition" && element.kind === "constructor") {
        if (hadConstructor) {
          this.raiseRecoverable(element.start, "Duplicate constructor in the same class");
        }
        hadConstructor = true;
      } else if (element.key && element.key.type === "PrivateIdentifier" && isPrivateNameConflicted(privateNameMap, element)) {
        this.raiseRecoverable(element.key.start, "Identifier '#" + element.key.name + "' has already been declared");
      }
    }
  }
  this.strict = oldStrict;
  this.next();
  node.body = this.finishNode(classBody, "ClassBody");
  this.exitClassBody();
  return this.finishNode(node, isStatement ? "ClassDeclaration" : "ClassExpression");
};
pp$8.parseClassElement = function(constructorAllowsSuper) {
  if (this.eat(types$1.semi)) {
    return null;
  }
  var ecmaVersion = this.options.ecmaVersion;
  var node = this.startNode();
  var keyName = "";
  var isGenerator = false;
  var isAsync = false;
  var kind = "method";
  var isStatic = false;
  if (this.eatContextual("static")) {
    if (ecmaVersion >= 13 && this.eat(types$1.braceL)) {
      this.parseClassStaticBlock(node);
      return node;
    }
    if (this.isClassElementNameStart() || this.type === types$1.star) {
      isStatic = true;
    } else {
      keyName = "static";
    }
  }
  node.static = isStatic;
  if (!keyName && ecmaVersion >= 8 && this.eatContextual("async")) {
    if ((this.isClassElementNameStart() || this.type === types$1.star) && !this.canInsertSemicolon()) {
      isAsync = true;
    } else {
      keyName = "async";
    }
  }
  if (!keyName && (ecmaVersion >= 9 || !isAsync) && this.eat(types$1.star)) {
    isGenerator = true;
  }
  if (!keyName && !isAsync && !isGenerator) {
    var lastValue = this.value;
    if (this.eatContextual("get") || this.eatContextual("set")) {
      if (this.isClassElementNameStart()) {
        kind = lastValue;
      } else {
        keyName = lastValue;
      }
    }
  }
  if (keyName) {
    node.computed = false;
    node.key = this.startNodeAt(this.lastTokStart, this.lastTokStartLoc);
    node.key.name = keyName;
    this.finishNode(node.key, "Identifier");
  } else {
    this.parseClassElementName(node);
  }
  if (ecmaVersion < 13 || this.type === types$1.parenL || kind !== "method" || isGenerator || isAsync) {
    var isConstructor = !node.static && checkKeyName(node, "constructor");
    var allowsDirectSuper = isConstructor && constructorAllowsSuper;
    if (isConstructor && kind !== "method") {
      this.raise(node.key.start, "Constructor can't have get/set modifier");
    }
    node.kind = isConstructor ? "constructor" : kind;
    this.parseClassMethod(node, isGenerator, isAsync, allowsDirectSuper);
  } else {
    this.parseClassField(node);
  }
  return node;
};
pp$8.isClassElementNameStart = function() {
  return this.type === types$1.name || this.type === types$1.privateId || this.type === types$1.num || this.type === types$1.string || this.type === types$1.bracketL || this.type.keyword;
};
pp$8.parseClassElementName = function(element) {
  if (this.type === types$1.privateId) {
    if (this.value === "constructor") {
      this.raise(this.start, "Classes can't have an element named '#constructor'");
    }
    element.computed = false;
    element.key = this.parsePrivateIdent();
  } else {
    this.parsePropertyName(element);
  }
};
pp$8.parseClassMethod = function(method, isGenerator, isAsync, allowsDirectSuper) {
  var key = method.key;
  if (method.kind === "constructor") {
    if (isGenerator) {
      this.raise(key.start, "Constructor can't be a generator");
    }
    if (isAsync) {
      this.raise(key.start, "Constructor can't be an async method");
    }
  } else if (method.static && checkKeyName(method, "prototype")) {
    this.raise(key.start, "Classes may not have a static property named prototype");
  }
  var value = method.value = this.parseMethod(isGenerator, isAsync, allowsDirectSuper);
  if (method.kind === "get" && value.params.length !== 0) {
    this.raiseRecoverable(value.start, "getter should have no params");
  }
  if (method.kind === "set" && value.params.length !== 1) {
    this.raiseRecoverable(value.start, "setter should have exactly one param");
  }
  if (method.kind === "set" && value.params[0].type === "RestElement") {
    this.raiseRecoverable(value.params[0].start, "Setter cannot use rest params");
  }
  return this.finishNode(method, "MethodDefinition");
};
pp$8.parseClassField = function(field) {
  if (checkKeyName(field, "constructor")) {
    this.raise(field.key.start, "Classes can't have a field named 'constructor'");
  } else if (field.static && checkKeyName(field, "prototype")) {
    this.raise(field.key.start, "Classes can't have a static field named 'prototype'");
  }
  if (this.eat(types$1.eq)) {
    var scope = this.currentThisScope();
    var inClassFieldInit = scope.inClassFieldInit;
    scope.inClassFieldInit = true;
    field.value = this.parseMaybeAssign();
    scope.inClassFieldInit = inClassFieldInit;
  } else {
    field.value = null;
  }
  this.semicolon();
  return this.finishNode(field, "PropertyDefinition");
};
pp$8.parseClassStaticBlock = function(node) {
  node.body = [];
  var oldLabels = this.labels;
  this.labels = [];
  this.enterScope(SCOPE_CLASS_STATIC_BLOCK | SCOPE_SUPER);
  while (this.type !== types$1.braceR) {
    var stmt = this.parseStatement(null);
    node.body.push(stmt);
  }
  this.next();
  this.exitScope();
  this.labels = oldLabels;
  return this.finishNode(node, "StaticBlock");
};
pp$8.parseClassId = function(node, isStatement) {
  if (this.type === types$1.name) {
    node.id = this.parseIdent();
    if (isStatement) {
      this.checkLValSimple(node.id, BIND_LEXICAL, false);
    }
  } else {
    if (isStatement === true) {
      this.unexpected();
    }
    node.id = null;
  }
};
pp$8.parseClassSuper = function(node) {
  node.superClass = this.eat(types$1._extends) ? this.parseExprSubscripts(null, false) : null;
};
pp$8.enterClassBody = function() {
  var element = { declared: /* @__PURE__ */ Object.create(null), used: [] };
  this.privateNameStack.push(element);
  return element.declared;
};
pp$8.exitClassBody = function() {
  var ref2 = this.privateNameStack.pop();
  var declared = ref2.declared;
  var used = ref2.used;
  if (!this.options.checkPrivateFields) {
    return;
  }
  var len = this.privateNameStack.length;
  var parent = len === 0 ? null : this.privateNameStack[len - 1];
  for (var i = 0; i < used.length; ++i) {
    var id = used[i];
    if (!hasOwn(declared, id.name)) {
      if (parent) {
        parent.used.push(id);
      } else {
        this.raiseRecoverable(id.start, "Private field '#" + id.name + "' must be declared in an enclosing class");
      }
    }
  }
};
function isPrivateNameConflicted(privateNameMap, element) {
  var name = element.key.name;
  var curr = privateNameMap[name];
  var next = "true";
  if (element.type === "MethodDefinition" && (element.kind === "get" || element.kind === "set")) {
    next = (element.static ? "s" : "i") + element.kind;
  }
  if (curr === "iget" && next === "iset" || curr === "iset" && next === "iget" || curr === "sget" && next === "sset" || curr === "sset" && next === "sget") {
    privateNameMap[name] = "true";
    return false;
  } else if (!curr) {
    privateNameMap[name] = next;
    return false;
  } else {
    return true;
  }
}
__name(isPrivateNameConflicted, "isPrivateNameConflicted");
function checkKeyName(node, name) {
  var computed = node.computed;
  var key = node.key;
  return !computed && (key.type === "Identifier" && key.name === name || key.type === "Literal" && key.value === name);
}
__name(checkKeyName, "checkKeyName");
pp$8.parseExportAllDeclaration = function(node, exports) {
  if (this.options.ecmaVersion >= 11) {
    if (this.eatContextual("as")) {
      node.exported = this.parseModuleExportName();
      this.checkExport(exports, node.exported, this.lastTokStart);
    } else {
      node.exported = null;
    }
  }
  this.expectContextual("from");
  if (this.type !== types$1.string) {
    this.unexpected();
  }
  node.source = this.parseExprAtom();
  this.semicolon();
  return this.finishNode(node, "ExportAllDeclaration");
};
pp$8.parseExport = function(node, exports) {
  this.next();
  if (this.eat(types$1.star)) {
    return this.parseExportAllDeclaration(node, exports);
  }
  if (this.eat(types$1._default)) {
    this.checkExport(exports, "default", this.lastTokStart);
    node.declaration = this.parseExportDefaultDeclaration();
    return this.finishNode(node, "ExportDefaultDeclaration");
  }
  if (this.shouldParseExportStatement()) {
    node.declaration = this.parseExportDeclaration(node);
    if (node.declaration.type === "VariableDeclaration") {
      this.checkVariableExport(exports, node.declaration.declarations);
    } else {
      this.checkExport(exports, node.declaration.id, node.declaration.id.start);
    }
    node.specifiers = [];
    node.source = null;
  } else {
    node.declaration = null;
    node.specifiers = this.parseExportSpecifiers(exports);
    if (this.eatContextual("from")) {
      if (this.type !== types$1.string) {
        this.unexpected();
      }
      node.source = this.parseExprAtom();
    } else {
      for (var i = 0, list = node.specifiers; i < list.length; i += 1) {
        var spec = list[i];
        this.checkUnreserved(spec.local);
        this.checkLocalExport(spec.local);
        if (spec.local.type === "Literal") {
          this.raise(spec.local.start, "A string literal cannot be used as an exported binding without `from`.");
        }
      }
      node.source = null;
    }
    this.semicolon();
  }
  return this.finishNode(node, "ExportNamedDeclaration");
};
pp$8.parseExportDeclaration = function(node) {
  return this.parseStatement(null);
};
pp$8.parseExportDefaultDeclaration = function() {
  var isAsync;
  if (this.type === types$1._function || (isAsync = this.isAsyncFunction())) {
    var fNode = this.startNode();
    this.next();
    if (isAsync) {
      this.next();
    }
    return this.parseFunction(fNode, FUNC_STATEMENT | FUNC_NULLABLE_ID, false, isAsync);
  } else if (this.type === types$1._class) {
    var cNode = this.startNode();
    return this.parseClass(cNode, "nullableID");
  } else {
    var declaration = this.parseMaybeAssign();
    this.semicolon();
    return declaration;
  }
};
pp$8.checkExport = function(exports, name, pos) {
  if (!exports) {
    return;
  }
  if (typeof name !== "string") {
    name = name.type === "Identifier" ? name.name : name.value;
  }
  if (hasOwn(exports, name)) {
    this.raiseRecoverable(pos, "Duplicate export '" + name + "'");
  }
  exports[name] = true;
};
pp$8.checkPatternExport = function(exports, pat) {
  var type = pat.type;
  if (type === "Identifier") {
    this.checkExport(exports, pat, pat.start);
  } else if (type === "ObjectPattern") {
    for (var i = 0, list = pat.properties; i < list.length; i += 1) {
      var prop = list[i];
      this.checkPatternExport(exports, prop);
    }
  } else if (type === "ArrayPattern") {
    for (var i$1 = 0, list$1 = pat.elements; i$1 < list$1.length; i$1 += 1) {
      var elt = list$1[i$1];
      if (elt) {
        this.checkPatternExport(exports, elt);
      }
    }
  } else if (type === "Property") {
    this.checkPatternExport(exports, pat.value);
  } else if (type === "AssignmentPattern") {
    this.checkPatternExport(exports, pat.left);
  } else if (type === "RestElement") {
    this.checkPatternExport(exports, pat.argument);
  }
};
pp$8.checkVariableExport = function(exports, decls) {
  if (!exports) {
    return;
  }
  for (var i = 0, list = decls; i < list.length; i += 1) {
    var decl = list[i];
    this.checkPatternExport(exports, decl.id);
  }
};
pp$8.shouldParseExportStatement = function() {
  return this.type.keyword === "var" || this.type.keyword === "const" || this.type.keyword === "class" || this.type.keyword === "function" || this.isLet() || this.isAsyncFunction();
};
pp$8.parseExportSpecifier = function(exports) {
  var node = this.startNode();
  node.local = this.parseModuleExportName();
  node.exported = this.eatContextual("as") ? this.parseModuleExportName() : node.local;
  this.checkExport(
    exports,
    node.exported,
    node.exported.start
  );
  return this.finishNode(node, "ExportSpecifier");
};
pp$8.parseExportSpecifiers = function(exports) {
  var nodes = [], first = true;
  this.expect(types$1.braceL);
  while (!this.eat(types$1.braceR)) {
    if (!first) {
      this.expect(types$1.comma);
      if (this.afterTrailingComma(types$1.braceR)) {
        break;
      }
    } else {
      first = false;
    }
    nodes.push(this.parseExportSpecifier(exports));
  }
  return nodes;
};
pp$8.parseImport = function(node) {
  this.next();
  if (this.type === types$1.string) {
    node.specifiers = empty$1;
    node.source = this.parseExprAtom();
  } else {
    node.specifiers = this.parseImportSpecifiers();
    this.expectContextual("from");
    node.source = this.type === types$1.string ? this.parseExprAtom() : this.unexpected();
  }
  this.semicolon();
  return this.finishNode(node, "ImportDeclaration");
};
pp$8.parseImportSpecifier = function() {
  var node = this.startNode();
  node.imported = this.parseModuleExportName();
  if (this.eatContextual("as")) {
    node.local = this.parseIdent();
  } else {
    this.checkUnreserved(node.imported);
    node.local = node.imported;
  }
  this.checkLValSimple(node.local, BIND_LEXICAL);
  return this.finishNode(node, "ImportSpecifier");
};
pp$8.parseImportDefaultSpecifier = function() {
  var node = this.startNode();
  node.local = this.parseIdent();
  this.checkLValSimple(node.local, BIND_LEXICAL);
  return this.finishNode(node, "ImportDefaultSpecifier");
};
pp$8.parseImportNamespaceSpecifier = function() {
  var node = this.startNode();
  this.next();
  this.expectContextual("as");
  node.local = this.parseIdent();
  this.checkLValSimple(node.local, BIND_LEXICAL);
  return this.finishNode(node, "ImportNamespaceSpecifier");
};
pp$8.parseImportSpecifiers = function() {
  var nodes = [], first = true;
  if (this.type === types$1.name) {
    nodes.push(this.parseImportDefaultSpecifier());
    if (!this.eat(types$1.comma)) {
      return nodes;
    }
  }
  if (this.type === types$1.star) {
    nodes.push(this.parseImportNamespaceSpecifier());
    return nodes;
  }
  this.expect(types$1.braceL);
  while (!this.eat(types$1.braceR)) {
    if (!first) {
      this.expect(types$1.comma);
      if (this.afterTrailingComma(types$1.braceR)) {
        break;
      }
    } else {
      first = false;
    }
    nodes.push(this.parseImportSpecifier());
  }
  return nodes;
};
pp$8.parseModuleExportName = function() {
  if (this.options.ecmaVersion >= 13 && this.type === types$1.string) {
    var stringLiteral = this.parseLiteral(this.value);
    if (loneSurrogate.test(stringLiteral.value)) {
      this.raise(stringLiteral.start, "An export name cannot include a lone surrogate.");
    }
    return stringLiteral;
  }
  return this.parseIdent(true);
};
pp$8.adaptDirectivePrologue = function(statements) {
  for (var i = 0; i < statements.length && this.isDirectiveCandidate(statements[i]); ++i) {
    statements[i].directive = statements[i].expression.raw.slice(1, -1);
  }
};
pp$8.isDirectiveCandidate = function(statement) {
  return this.options.ecmaVersion >= 5 && statement.type === "ExpressionStatement" && statement.expression.type === "Literal" && typeof statement.expression.value === "string" && // Reject parenthesized strings.
  (this.input[statement.start] === '"' || this.input[statement.start] === "'");
};
var pp$7 = Parser.prototype;
pp$7.toAssignable = function(node, isBinding, refDestructuringErrors) {
  if (this.options.ecmaVersion >= 6 && node) {
    switch (node.type) {
      case "Identifier":
        if (this.inAsync && node.name === "await") {
          this.raise(node.start, "Cannot use 'await' as identifier inside an async function");
        }
        break;
      case "ObjectPattern":
      case "ArrayPattern":
      case "AssignmentPattern":
      case "RestElement":
        break;
      case "ObjectExpression":
        node.type = "ObjectPattern";
        if (refDestructuringErrors) {
          this.checkPatternErrors(refDestructuringErrors, true);
        }
        for (var i = 0, list = node.properties; i < list.length; i += 1) {
          var prop = list[i];
          this.toAssignable(prop, isBinding);
          if (prop.type === "RestElement" && (prop.argument.type === "ArrayPattern" || prop.argument.type === "ObjectPattern")) {
            this.raise(prop.argument.start, "Unexpected token");
          }
        }
        break;
      case "Property":
        if (node.kind !== "init") {
          this.raise(node.key.start, "Object pattern can't contain getter or setter");
        }
        this.toAssignable(node.value, isBinding);
        break;
      case "ArrayExpression":
        node.type = "ArrayPattern";
        if (refDestructuringErrors) {
          this.checkPatternErrors(refDestructuringErrors, true);
        }
        this.toAssignableList(node.elements, isBinding);
        break;
      case "SpreadElement":
        node.type = "RestElement";
        this.toAssignable(node.argument, isBinding);
        if (node.argument.type === "AssignmentPattern") {
          this.raise(node.argument.start, "Rest elements cannot have a default value");
        }
        break;
      case "AssignmentExpression":
        if (node.operator !== "=") {
          this.raise(node.left.end, "Only '=' operator can be used for specifying default value.");
        }
        node.type = "AssignmentPattern";
        delete node.operator;
        this.toAssignable(node.left, isBinding);
        break;
      case "ParenthesizedExpression":
        this.toAssignable(node.expression, isBinding, refDestructuringErrors);
        break;
      case "ChainExpression":
        this.raiseRecoverable(node.start, "Optional chaining cannot appear in left-hand side");
        break;
      case "MemberExpression":
        if (!isBinding) {
          break;
        }
      default:
        this.raise(node.start, "Assigning to rvalue");
    }
  } else if (refDestructuringErrors) {
    this.checkPatternErrors(refDestructuringErrors, true);
  }
  return node;
};
pp$7.toAssignableList = function(exprList, isBinding) {
  var end = exprList.length;
  for (var i = 0; i < end; i++) {
    var elt = exprList[i];
    if (elt) {
      this.toAssignable(elt, isBinding);
    }
  }
  if (end) {
    var last = exprList[end - 1];
    if (this.options.ecmaVersion === 6 && isBinding && last && last.type === "RestElement" && last.argument.type !== "Identifier") {
      this.unexpected(last.argument.start);
    }
  }
  return exprList;
};
pp$7.parseSpread = function(refDestructuringErrors) {
  var node = this.startNode();
  this.next();
  node.argument = this.parseMaybeAssign(false, refDestructuringErrors);
  return this.finishNode(node, "SpreadElement");
};
pp$7.parseRestBinding = function() {
  var node = this.startNode();
  this.next();
  if (this.options.ecmaVersion === 6 && this.type !== types$1.name) {
    this.unexpected();
  }
  node.argument = this.parseBindingAtom();
  return this.finishNode(node, "RestElement");
};
pp$7.parseBindingAtom = function() {
  if (this.options.ecmaVersion >= 6) {
    switch (this.type) {
      case types$1.bracketL:
        var node = this.startNode();
        this.next();
        node.elements = this.parseBindingList(types$1.bracketR, true, true);
        return this.finishNode(node, "ArrayPattern");
      case types$1.braceL:
        return this.parseObj(true);
    }
  }
  return this.parseIdent();
};
pp$7.parseBindingList = function(close, allowEmpty, allowTrailingComma, allowModifiers) {
  var elts = [], first = true;
  while (!this.eat(close)) {
    if (first) {
      first = false;
    } else {
      this.expect(types$1.comma);
    }
    if (allowEmpty && this.type === types$1.comma) {
      elts.push(null);
    } else if (allowTrailingComma && this.afterTrailingComma(close)) {
      break;
    } else if (this.type === types$1.ellipsis) {
      var rest = this.parseRestBinding();
      this.parseBindingListItem(rest);
      elts.push(rest);
      if (this.type === types$1.comma) {
        this.raiseRecoverable(this.start, "Comma is not permitted after the rest element");
      }
      this.expect(close);
      break;
    } else {
      elts.push(this.parseAssignableListItem(allowModifiers));
    }
  }
  return elts;
};
pp$7.parseAssignableListItem = function(allowModifiers) {
  var elem = this.parseMaybeDefault(this.start, this.startLoc);
  this.parseBindingListItem(elem);
  return elem;
};
pp$7.parseBindingListItem = function(param) {
  return param;
};
pp$7.parseMaybeDefault = function(startPos, startLoc, left) {
  left = left || this.parseBindingAtom();
  if (this.options.ecmaVersion < 6 || !this.eat(types$1.eq)) {
    return left;
  }
  var node = this.startNodeAt(startPos, startLoc);
  node.left = left;
  node.right = this.parseMaybeAssign();
  return this.finishNode(node, "AssignmentPattern");
};
pp$7.checkLValSimple = function(expr, bindingType, checkClashes) {
  if (bindingType === void 0) bindingType = BIND_NONE;
  var isBind = bindingType !== BIND_NONE;
  switch (expr.type) {
    case "Identifier":
      if (this.strict && this.reservedWordsStrictBind.test(expr.name)) {
        this.raiseRecoverable(expr.start, (isBind ? "Binding " : "Assigning to ") + expr.name + " in strict mode");
      }
      if (isBind) {
        if (bindingType === BIND_LEXICAL && expr.name === "let") {
          this.raiseRecoverable(expr.start, "let is disallowed as a lexically bound name");
        }
        if (checkClashes) {
          if (hasOwn(checkClashes, expr.name)) {
            this.raiseRecoverable(expr.start, "Argument name clash");
          }
          checkClashes[expr.name] = true;
        }
        if (bindingType !== BIND_OUTSIDE) {
          this.declareName(expr.name, bindingType, expr.start);
        }
      }
      break;
    case "ChainExpression":
      this.raiseRecoverable(expr.start, "Optional chaining cannot appear in left-hand side");
      break;
    case "MemberExpression":
      if (isBind) {
        this.raiseRecoverable(expr.start, "Binding member expression");
      }
      break;
    case "ParenthesizedExpression":
      if (isBind) {
        this.raiseRecoverable(expr.start, "Binding parenthesized expression");
      }
      return this.checkLValSimple(expr.expression, bindingType, checkClashes);
    default:
      this.raise(expr.start, (isBind ? "Binding" : "Assigning to") + " rvalue");
  }
};
pp$7.checkLValPattern = function(expr, bindingType, checkClashes) {
  if (bindingType === void 0) bindingType = BIND_NONE;
  switch (expr.type) {
    case "ObjectPattern":
      for (var i = 0, list = expr.properties; i < list.length; i += 1) {
        var prop = list[i];
        this.checkLValInnerPattern(prop, bindingType, checkClashes);
      }
      break;
    case "ArrayPattern":
      for (var i$1 = 0, list$1 = expr.elements; i$1 < list$1.length; i$1 += 1) {
        var elem = list$1[i$1];
        if (elem) {
          this.checkLValInnerPattern(elem, bindingType, checkClashes);
        }
      }
      break;
    default:
      this.checkLValSimple(expr, bindingType, checkClashes);
  }
};
pp$7.checkLValInnerPattern = function(expr, bindingType, checkClashes) {
  if (bindingType === void 0) bindingType = BIND_NONE;
  switch (expr.type) {
    case "Property":
      this.checkLValInnerPattern(expr.value, bindingType, checkClashes);
      break;
    case "AssignmentPattern":
      this.checkLValPattern(expr.left, bindingType, checkClashes);
      break;
    case "RestElement":
      this.checkLValPattern(expr.argument, bindingType, checkClashes);
      break;
    default:
      this.checkLValPattern(expr, bindingType, checkClashes);
  }
};
var TokContext = /* @__PURE__ */ __name(function TokContext2(token, isExpr, preserveSpace, override, generator) {
  this.token = token;
  this.isExpr = !!isExpr;
  this.preserveSpace = !!preserveSpace;
  this.override = override;
  this.generator = !!generator;
}, "TokContext");
var types = {
  b_stat: new TokContext("{", false),
  b_expr: new TokContext("{", true),
  b_tmpl: new TokContext("${", false),
  p_stat: new TokContext("(", false),
  p_expr: new TokContext("(", true),
  q_tmpl: new TokContext("`", true, true, function(p) {
    return p.tryReadTemplateToken();
  }),
  f_stat: new TokContext("function", false),
  f_expr: new TokContext("function", true),
  f_expr_gen: new TokContext("function", true, false, null, true),
  f_gen: new TokContext("function", false, false, null, true)
};
var pp$6 = Parser.prototype;
pp$6.initialContext = function() {
  return [types.b_stat];
};
pp$6.curContext = function() {
  return this.context[this.context.length - 1];
};
pp$6.braceIsBlock = function(prevType) {
  var parent = this.curContext();
  if (parent === types.f_expr || parent === types.f_stat) {
    return true;
  }
  if (prevType === types$1.colon && (parent === types.b_stat || parent === types.b_expr)) {
    return !parent.isExpr;
  }
  if (prevType === types$1._return || prevType === types$1.name && this.exprAllowed) {
    return lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
  }
  if (prevType === types$1._else || prevType === types$1.semi || prevType === types$1.eof || prevType === types$1.parenR || prevType === types$1.arrow) {
    return true;
  }
  if (prevType === types$1.braceL) {
    return parent === types.b_stat;
  }
  if (prevType === types$1._var || prevType === types$1._const || prevType === types$1.name) {
    return false;
  }
  return !this.exprAllowed;
};
pp$6.inGeneratorContext = function() {
  for (var i = this.context.length - 1; i >= 1; i--) {
    var context = this.context[i];
    if (context.token === "function") {
      return context.generator;
    }
  }
  return false;
};
pp$6.updateContext = function(prevType) {
  var update, type = this.type;
  if (type.keyword && prevType === types$1.dot) {
    this.exprAllowed = false;
  } else if (update = type.updateContext) {
    update.call(this, prevType);
  } else {
    this.exprAllowed = type.beforeExpr;
  }
};
pp$6.overrideContext = function(tokenCtx) {
  if (this.curContext() !== tokenCtx) {
    this.context[this.context.length - 1] = tokenCtx;
  }
};
types$1.parenR.updateContext = types$1.braceR.updateContext = function() {
  if (this.context.length === 1) {
    this.exprAllowed = true;
    return;
  }
  var out = this.context.pop();
  if (out === types.b_stat && this.curContext().token === "function") {
    out = this.context.pop();
  }
  this.exprAllowed = !out.isExpr;
};
types$1.braceL.updateContext = function(prevType) {
  this.context.push(this.braceIsBlock(prevType) ? types.b_stat : types.b_expr);
  this.exprAllowed = true;
};
types$1.dollarBraceL.updateContext = function() {
  this.context.push(types.b_tmpl);
  this.exprAllowed = true;
};
types$1.parenL.updateContext = function(prevType) {
  var statementParens = prevType === types$1._if || prevType === types$1._for || prevType === types$1._with || prevType === types$1._while;
  this.context.push(statementParens ? types.p_stat : types.p_expr);
  this.exprAllowed = true;
};
types$1.incDec.updateContext = function() {
};
types$1._function.updateContext = types$1._class.updateContext = function(prevType) {
  if (prevType.beforeExpr && prevType !== types$1._else && !(prevType === types$1.semi && this.curContext() !== types.p_stat) && !(prevType === types$1._return && lineBreak.test(this.input.slice(this.lastTokEnd, this.start))) && !((prevType === types$1.colon || prevType === types$1.braceL) && this.curContext() === types.b_stat)) {
    this.context.push(types.f_expr);
  } else {
    this.context.push(types.f_stat);
  }
  this.exprAllowed = false;
};
types$1.colon.updateContext = function() {
  if (this.curContext().token === "function") {
    this.context.pop();
  }
  this.exprAllowed = true;
};
types$1.backQuote.updateContext = function() {
  if (this.curContext() === types.q_tmpl) {
    this.context.pop();
  } else {
    this.context.push(types.q_tmpl);
  }
  this.exprAllowed = false;
};
types$1.star.updateContext = function(prevType) {
  if (prevType === types$1._function) {
    var index = this.context.length - 1;
    if (this.context[index] === types.f_expr) {
      this.context[index] = types.f_expr_gen;
    } else {
      this.context[index] = types.f_gen;
    }
  }
  this.exprAllowed = true;
};
types$1.name.updateContext = function(prevType) {
  var allowed = false;
  if (this.options.ecmaVersion >= 6 && prevType !== types$1.dot) {
    if (this.value === "of" && !this.exprAllowed || this.value === "yield" && this.inGeneratorContext()) {
      allowed = true;
    }
  }
  this.exprAllowed = allowed;
};
var pp$5 = Parser.prototype;
pp$5.checkPropClash = function(prop, propHash, refDestructuringErrors) {
  if (this.options.ecmaVersion >= 9 && prop.type === "SpreadElement") {
    return;
  }
  if (this.options.ecmaVersion >= 6 && (prop.computed || prop.method || prop.shorthand)) {
    return;
  }
  var key = prop.key;
  var name;
  switch (key.type) {
    case "Identifier":
      name = key.name;
      break;
    case "Literal":
      name = String(key.value);
      break;
    default:
      return;
  }
  var kind = prop.kind;
  if (this.options.ecmaVersion >= 6) {
    if (name === "__proto__" && kind === "init") {
      if (propHash.proto) {
        if (refDestructuringErrors) {
          if (refDestructuringErrors.doubleProto < 0) {
            refDestructuringErrors.doubleProto = key.start;
          }
        } else {
          this.raiseRecoverable(key.start, "Redefinition of __proto__ property");
        }
      }
      propHash.proto = true;
    }
    return;
  }
  name = "$" + name;
  var other = propHash[name];
  if (other) {
    var redefinition;
    if (kind === "init") {
      redefinition = this.strict && other.init || other.get || other.set;
    } else {
      redefinition = other.init || other[kind];
    }
    if (redefinition) {
      this.raiseRecoverable(key.start, "Redefinition of property");
    }
  } else {
    other = propHash[name] = {
      init: false,
      get: false,
      set: false
    };
  }
  other[kind] = true;
};
pp$5.parseExpression = function(forInit, refDestructuringErrors) {
  var startPos = this.start, startLoc = this.startLoc;
  var expr = this.parseMaybeAssign(forInit, refDestructuringErrors);
  if (this.type === types$1.comma) {
    var node = this.startNodeAt(startPos, startLoc);
    node.expressions = [expr];
    while (this.eat(types$1.comma)) {
      node.expressions.push(this.parseMaybeAssign(forInit, refDestructuringErrors));
    }
    return this.finishNode(node, "SequenceExpression");
  }
  return expr;
};
pp$5.parseMaybeAssign = function(forInit, refDestructuringErrors, afterLeftParse) {
  if (this.isContextual("yield")) {
    if (this.inGenerator) {
      return this.parseYield(forInit);
    } else {
      this.exprAllowed = false;
    }
  }
  var ownDestructuringErrors = false, oldParenAssign = -1, oldTrailingComma = -1, oldDoubleProto = -1;
  if (refDestructuringErrors) {
    oldParenAssign = refDestructuringErrors.parenthesizedAssign;
    oldTrailingComma = refDestructuringErrors.trailingComma;
    oldDoubleProto = refDestructuringErrors.doubleProto;
    refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = -1;
  } else {
    refDestructuringErrors = new DestructuringErrors();
    ownDestructuringErrors = true;
  }
  var startPos = this.start, startLoc = this.startLoc;
  if (this.type === types$1.parenL || this.type === types$1.name) {
    this.potentialArrowAt = this.start;
    this.potentialArrowInForAwait = forInit === "await";
  }
  var left = this.parseMaybeConditional(forInit, refDestructuringErrors);
  if (afterLeftParse) {
    left = afterLeftParse.call(this, left, startPos, startLoc);
  }
  if (this.type.isAssign) {
    var node = this.startNodeAt(startPos, startLoc);
    node.operator = this.value;
    if (this.type === types$1.eq) {
      left = this.toAssignable(left, false, refDestructuringErrors);
    }
    if (!ownDestructuringErrors) {
      refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = refDestructuringErrors.doubleProto = -1;
    }
    if (refDestructuringErrors.shorthandAssign >= left.start) {
      refDestructuringErrors.shorthandAssign = -1;
    }
    if (this.type === types$1.eq) {
      this.checkLValPattern(left);
    } else {
      this.checkLValSimple(left);
    }
    node.left = left;
    this.next();
    node.right = this.parseMaybeAssign(forInit);
    if (oldDoubleProto > -1) {
      refDestructuringErrors.doubleProto = oldDoubleProto;
    }
    return this.finishNode(node, "AssignmentExpression");
  } else {
    if (ownDestructuringErrors) {
      this.checkExpressionErrors(refDestructuringErrors, true);
    }
  }
  if (oldParenAssign > -1) {
    refDestructuringErrors.parenthesizedAssign = oldParenAssign;
  }
  if (oldTrailingComma > -1) {
    refDestructuringErrors.trailingComma = oldTrailingComma;
  }
  return left;
};
pp$5.parseMaybeConditional = function(forInit, refDestructuringErrors) {
  var startPos = this.start, startLoc = this.startLoc;
  var expr = this.parseExprOps(forInit, refDestructuringErrors);
  if (this.checkExpressionErrors(refDestructuringErrors)) {
    return expr;
  }
  if (this.eat(types$1.question)) {
    var node = this.startNodeAt(startPos, startLoc);
    node.test = expr;
    node.consequent = this.parseMaybeAssign();
    this.expect(types$1.colon);
    node.alternate = this.parseMaybeAssign(forInit);
    return this.finishNode(node, "ConditionalExpression");
  }
  return expr;
};
pp$5.parseExprOps = function(forInit, refDestructuringErrors) {
  var startPos = this.start, startLoc = this.startLoc;
  var expr = this.parseMaybeUnary(refDestructuringErrors, false, false, forInit);
  if (this.checkExpressionErrors(refDestructuringErrors)) {
    return expr;
  }
  return expr.start === startPos && expr.type === "ArrowFunctionExpression" ? expr : this.parseExprOp(expr, startPos, startLoc, -1, forInit);
};
pp$5.parseExprOp = function(left, leftStartPos, leftStartLoc, minPrec, forInit) {
  var prec = this.type.binop;
  if (prec != null && (!forInit || this.type !== types$1._in)) {
    if (prec > minPrec) {
      var logical = this.type === types$1.logicalOR || this.type === types$1.logicalAND;
      var coalesce = this.type === types$1.coalesce;
      if (coalesce) {
        prec = types$1.logicalAND.binop;
      }
      var op = this.value;
      this.next();
      var startPos = this.start, startLoc = this.startLoc;
      var right = this.parseExprOp(this.parseMaybeUnary(null, false, false, forInit), startPos, startLoc, prec, forInit);
      var node = this.buildBinary(leftStartPos, leftStartLoc, left, right, op, logical || coalesce);
      if (logical && this.type === types$1.coalesce || coalesce && (this.type === types$1.logicalOR || this.type === types$1.logicalAND)) {
        this.raiseRecoverable(this.start, "Logical expressions and coalesce expressions cannot be mixed. Wrap either by parentheses");
      }
      return this.parseExprOp(node, leftStartPos, leftStartLoc, minPrec, forInit);
    }
  }
  return left;
};
pp$5.buildBinary = function(startPos, startLoc, left, right, op, logical) {
  if (right.type === "PrivateIdentifier") {
    this.raise(right.start, "Private identifier can only be left side of binary expression");
  }
  var node = this.startNodeAt(startPos, startLoc);
  node.left = left;
  node.operator = op;
  node.right = right;
  return this.finishNode(node, logical ? "LogicalExpression" : "BinaryExpression");
};
pp$5.parseMaybeUnary = function(refDestructuringErrors, sawUnary, incDec, forInit) {
  var startPos = this.start, startLoc = this.startLoc, expr;
  if (this.isContextual("await") && this.canAwait) {
    expr = this.parseAwait(forInit);
    sawUnary = true;
  } else if (this.type.prefix) {
    var node = this.startNode(), update = this.type === types$1.incDec;
    node.operator = this.value;
    node.prefix = true;
    this.next();
    node.argument = this.parseMaybeUnary(null, true, update, forInit);
    this.checkExpressionErrors(refDestructuringErrors, true);
    if (update) {
      this.checkLValSimple(node.argument);
    } else if (this.strict && node.operator === "delete" && isLocalVariableAccess(node.argument)) {
      this.raiseRecoverable(node.start, "Deleting local variable in strict mode");
    } else if (node.operator === "delete" && isPrivateFieldAccess(node.argument)) {
      this.raiseRecoverable(node.start, "Private fields can not be deleted");
    } else {
      sawUnary = true;
    }
    expr = this.finishNode(node, update ? "UpdateExpression" : "UnaryExpression");
  } else if (!sawUnary && this.type === types$1.privateId) {
    if ((forInit || this.privateNameStack.length === 0) && this.options.checkPrivateFields) {
      this.unexpected();
    }
    expr = this.parsePrivateIdent();
    if (this.type !== types$1._in) {
      this.unexpected();
    }
  } else {
    expr = this.parseExprSubscripts(refDestructuringErrors, forInit);
    if (this.checkExpressionErrors(refDestructuringErrors)) {
      return expr;
    }
    while (this.type.postfix && !this.canInsertSemicolon()) {
      var node$1 = this.startNodeAt(startPos, startLoc);
      node$1.operator = this.value;
      node$1.prefix = false;
      node$1.argument = expr;
      this.checkLValSimple(expr);
      this.next();
      expr = this.finishNode(node$1, "UpdateExpression");
    }
  }
  if (!incDec && this.eat(types$1.starstar)) {
    if (sawUnary) {
      this.unexpected(this.lastTokStart);
    } else {
      return this.buildBinary(startPos, startLoc, expr, this.parseMaybeUnary(null, false, false, forInit), "**", false);
    }
  } else {
    return expr;
  }
};
function isLocalVariableAccess(node) {
  return node.type === "Identifier" || node.type === "ParenthesizedExpression" && isLocalVariableAccess(node.expression);
}
__name(isLocalVariableAccess, "isLocalVariableAccess");
function isPrivateFieldAccess(node) {
  return node.type === "MemberExpression" && node.property.type === "PrivateIdentifier" || node.type === "ChainExpression" && isPrivateFieldAccess(node.expression) || node.type === "ParenthesizedExpression" && isPrivateFieldAccess(node.expression);
}
__name(isPrivateFieldAccess, "isPrivateFieldAccess");
pp$5.parseExprSubscripts = function(refDestructuringErrors, forInit) {
  var startPos = this.start, startLoc = this.startLoc;
  var expr = this.parseExprAtom(refDestructuringErrors, forInit);
  if (expr.type === "ArrowFunctionExpression" && this.input.slice(this.lastTokStart, this.lastTokEnd) !== ")") {
    return expr;
  }
  var result = this.parseSubscripts(expr, startPos, startLoc, false, forInit);
  if (refDestructuringErrors && result.type === "MemberExpression") {
    if (refDestructuringErrors.parenthesizedAssign >= result.start) {
      refDestructuringErrors.parenthesizedAssign = -1;
    }
    if (refDestructuringErrors.parenthesizedBind >= result.start) {
      refDestructuringErrors.parenthesizedBind = -1;
    }
    if (refDestructuringErrors.trailingComma >= result.start) {
      refDestructuringErrors.trailingComma = -1;
    }
  }
  return result;
};
pp$5.parseSubscripts = function(base, startPos, startLoc, noCalls, forInit) {
  var maybeAsyncArrow = this.options.ecmaVersion >= 8 && base.type === "Identifier" && base.name === "async" && this.lastTokEnd === base.end && !this.canInsertSemicolon() && base.end - base.start === 5 && this.potentialArrowAt === base.start;
  var optionalChained = false;
  while (true) {
    var element = this.parseSubscript(base, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained, forInit);
    if (element.optional) {
      optionalChained = true;
    }
    if (element === base || element.type === "ArrowFunctionExpression") {
      if (optionalChained) {
        var chainNode = this.startNodeAt(startPos, startLoc);
        chainNode.expression = element;
        element = this.finishNode(chainNode, "ChainExpression");
      }
      return element;
    }
    base = element;
  }
};
pp$5.shouldParseAsyncArrow = function() {
  return !this.canInsertSemicolon() && this.eat(types$1.arrow);
};
pp$5.parseSubscriptAsyncArrow = function(startPos, startLoc, exprList, forInit) {
  return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, true, forInit);
};
pp$5.parseSubscript = function(base, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained, forInit) {
  var optionalSupported = this.options.ecmaVersion >= 11;
  var optional = optionalSupported && this.eat(types$1.questionDot);
  if (noCalls && optional) {
    this.raise(this.lastTokStart, "Optional chaining cannot appear in the callee of new expressions");
  }
  var computed = this.eat(types$1.bracketL);
  if (computed || optional && this.type !== types$1.parenL && this.type !== types$1.backQuote || this.eat(types$1.dot)) {
    var node = this.startNodeAt(startPos, startLoc);
    node.object = base;
    if (computed) {
      node.property = this.parseExpression();
      this.expect(types$1.bracketR);
    } else if (this.type === types$1.privateId && base.type !== "Super") {
      node.property = this.parsePrivateIdent();
    } else {
      node.property = this.parseIdent(this.options.allowReserved !== "never");
    }
    node.computed = !!computed;
    if (optionalSupported) {
      node.optional = optional;
    }
    base = this.finishNode(node, "MemberExpression");
  } else if (!noCalls && this.eat(types$1.parenL)) {
    var refDestructuringErrors = new DestructuringErrors(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
    this.yieldPos = 0;
    this.awaitPos = 0;
    this.awaitIdentPos = 0;
    var exprList = this.parseExprList(types$1.parenR, this.options.ecmaVersion >= 8, false, refDestructuringErrors);
    if (maybeAsyncArrow && !optional && this.shouldParseAsyncArrow()) {
      this.checkPatternErrors(refDestructuringErrors, false);
      this.checkYieldAwaitInDefaultParams();
      if (this.awaitIdentPos > 0) {
        this.raise(this.awaitIdentPos, "Cannot use 'await' as identifier inside an async function");
      }
      this.yieldPos = oldYieldPos;
      this.awaitPos = oldAwaitPos;
      this.awaitIdentPos = oldAwaitIdentPos;
      return this.parseSubscriptAsyncArrow(startPos, startLoc, exprList, forInit);
    }
    this.checkExpressionErrors(refDestructuringErrors, true);
    this.yieldPos = oldYieldPos || this.yieldPos;
    this.awaitPos = oldAwaitPos || this.awaitPos;
    this.awaitIdentPos = oldAwaitIdentPos || this.awaitIdentPos;
    var node$1 = this.startNodeAt(startPos, startLoc);
    node$1.callee = base;
    node$1.arguments = exprList;
    if (optionalSupported) {
      node$1.optional = optional;
    }
    base = this.finishNode(node$1, "CallExpression");
  } else if (this.type === types$1.backQuote) {
    if (optional || optionalChained) {
      this.raise(this.start, "Optional chaining cannot appear in the tag of tagged template expressions");
    }
    var node$2 = this.startNodeAt(startPos, startLoc);
    node$2.tag = base;
    node$2.quasi = this.parseTemplate({ isTagged: true });
    base = this.finishNode(node$2, "TaggedTemplateExpression");
  }
  return base;
};
pp$5.parseExprAtom = function(refDestructuringErrors, forInit, forNew) {
  if (this.type === types$1.slash) {
    this.readRegexp();
  }
  var node, canBeArrow = this.potentialArrowAt === this.start;
  switch (this.type) {
    case types$1._super:
      if (!this.allowSuper) {
        this.raise(this.start, "'super' keyword outside a method");
      }
      node = this.startNode();
      this.next();
      if (this.type === types$1.parenL && !this.allowDirectSuper) {
        this.raise(node.start, "super() call outside constructor of a subclass");
      }
      if (this.type !== types$1.dot && this.type !== types$1.bracketL && this.type !== types$1.parenL) {
        this.unexpected();
      }
      return this.finishNode(node, "Super");
    case types$1._this:
      node = this.startNode();
      this.next();
      return this.finishNode(node, "ThisExpression");
    case types$1.name:
      var startPos = this.start, startLoc = this.startLoc, containsEsc = this.containsEsc;
      var id = this.parseIdent(false);
      if (this.options.ecmaVersion >= 8 && !containsEsc && id.name === "async" && !this.canInsertSemicolon() && this.eat(types$1._function)) {
        this.overrideContext(types.f_expr);
        return this.parseFunction(this.startNodeAt(startPos, startLoc), 0, false, true, forInit);
      }
      if (canBeArrow && !this.canInsertSemicolon()) {
        if (this.eat(types$1.arrow)) {
          return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], false, forInit);
        }
        if (this.options.ecmaVersion >= 8 && id.name === "async" && this.type === types$1.name && !containsEsc && (!this.potentialArrowInForAwait || this.value !== "of" || this.containsEsc)) {
          id = this.parseIdent(false);
          if (this.canInsertSemicolon() || !this.eat(types$1.arrow)) {
            this.unexpected();
          }
          return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], true, forInit);
        }
      }
      return id;
    case types$1.regexp:
      var value = this.value;
      node = this.parseLiteral(value.value);
      node.regex = { pattern: value.pattern, flags: value.flags };
      return node;
    case types$1.num:
    case types$1.string:
      return this.parseLiteral(this.value);
    case types$1._null:
    case types$1._true:
    case types$1._false:
      node = this.startNode();
      node.value = this.type === types$1._null ? null : this.type === types$1._true;
      node.raw = this.type.keyword;
      this.next();
      return this.finishNode(node, "Literal");
    case types$1.parenL:
      var start = this.start, expr = this.parseParenAndDistinguishExpression(canBeArrow, forInit);
      if (refDestructuringErrors) {
        if (refDestructuringErrors.parenthesizedAssign < 0 && !this.isSimpleAssignTarget(expr)) {
          refDestructuringErrors.parenthesizedAssign = start;
        }
        if (refDestructuringErrors.parenthesizedBind < 0) {
          refDestructuringErrors.parenthesizedBind = start;
        }
      }
      return expr;
    case types$1.bracketL:
      node = this.startNode();
      this.next();
      node.elements = this.parseExprList(types$1.bracketR, true, true, refDestructuringErrors);
      return this.finishNode(node, "ArrayExpression");
    case types$1.braceL:
      this.overrideContext(types.b_expr);
      return this.parseObj(false, refDestructuringErrors);
    case types$1._function:
      node = this.startNode();
      this.next();
      return this.parseFunction(node, 0);
    case types$1._class:
      return this.parseClass(this.startNode(), false);
    case types$1._new:
      return this.parseNew();
    case types$1.backQuote:
      return this.parseTemplate();
    case types$1._import:
      if (this.options.ecmaVersion >= 11) {
        return this.parseExprImport(forNew);
      } else {
        return this.unexpected();
      }
    default:
      return this.parseExprAtomDefault();
  }
};
pp$5.parseExprAtomDefault = function() {
  this.unexpected();
};
pp$5.parseExprImport = function(forNew) {
  var node = this.startNode();
  if (this.containsEsc) {
    this.raiseRecoverable(this.start, "Escape sequence in keyword import");
  }
  this.next();
  if (this.type === types$1.parenL && !forNew) {
    return this.parseDynamicImport(node);
  } else if (this.type === types$1.dot) {
    var meta = this.startNodeAt(node.start, node.loc && node.loc.start);
    meta.name = "import";
    node.meta = this.finishNode(meta, "Identifier");
    return this.parseImportMeta(node);
  } else {
    this.unexpected();
  }
};
pp$5.parseDynamicImport = function(node) {
  this.next();
  node.source = this.parseMaybeAssign();
  if (!this.eat(types$1.parenR)) {
    var errorPos = this.start;
    if (this.eat(types$1.comma) && this.eat(types$1.parenR)) {
      this.raiseRecoverable(errorPos, "Trailing comma is not allowed in import()");
    } else {
      this.unexpected(errorPos);
    }
  }
  return this.finishNode(node, "ImportExpression");
};
pp$5.parseImportMeta = function(node) {
  this.next();
  var containsEsc = this.containsEsc;
  node.property = this.parseIdent(true);
  if (node.property.name !== "meta") {
    this.raiseRecoverable(node.property.start, "The only valid meta property for import is 'import.meta'");
  }
  if (containsEsc) {
    this.raiseRecoverable(node.start, "'import.meta' must not contain escaped characters");
  }
  if (this.options.sourceType !== "module" && !this.options.allowImportExportEverywhere) {
    this.raiseRecoverable(node.start, "Cannot use 'import.meta' outside a module");
  }
  return this.finishNode(node, "MetaProperty");
};
pp$5.parseLiteral = function(value) {
  var node = this.startNode();
  node.value = value;
  node.raw = this.input.slice(this.start, this.end);
  if (node.raw.charCodeAt(node.raw.length - 1) === 110) {
    node.bigint = node.raw.slice(0, -1).replace(/_/g, "");
  }
  this.next();
  return this.finishNode(node, "Literal");
};
pp$5.parseParenExpression = function() {
  this.expect(types$1.parenL);
  var val = this.parseExpression();
  this.expect(types$1.parenR);
  return val;
};
pp$5.shouldParseArrow = function(exprList) {
  return !this.canInsertSemicolon();
};
pp$5.parseParenAndDistinguishExpression = function(canBeArrow, forInit) {
  var startPos = this.start, startLoc = this.startLoc, val, allowTrailingComma = this.options.ecmaVersion >= 8;
  if (this.options.ecmaVersion >= 6) {
    this.next();
    var innerStartPos = this.start, innerStartLoc = this.startLoc;
    var exprList = [], first = true, lastIsComma = false;
    var refDestructuringErrors = new DestructuringErrors(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, spreadStart;
    this.yieldPos = 0;
    this.awaitPos = 0;
    while (this.type !== types$1.parenR) {
      first ? first = false : this.expect(types$1.comma);
      if (allowTrailingComma && this.afterTrailingComma(types$1.parenR, true)) {
        lastIsComma = true;
        break;
      } else if (this.type === types$1.ellipsis) {
        spreadStart = this.start;
        exprList.push(this.parseParenItem(this.parseRestBinding()));
        if (this.type === types$1.comma) {
          this.raiseRecoverable(
            this.start,
            "Comma is not permitted after the rest element"
          );
        }
        break;
      } else {
        exprList.push(this.parseMaybeAssign(false, refDestructuringErrors, this.parseParenItem));
      }
    }
    var innerEndPos = this.lastTokEnd, innerEndLoc = this.lastTokEndLoc;
    this.expect(types$1.parenR);
    if (canBeArrow && this.shouldParseArrow(exprList) && this.eat(types$1.arrow)) {
      this.checkPatternErrors(refDestructuringErrors, false);
      this.checkYieldAwaitInDefaultParams();
      this.yieldPos = oldYieldPos;
      this.awaitPos = oldAwaitPos;
      return this.parseParenArrowList(startPos, startLoc, exprList, forInit);
    }
    if (!exprList.length || lastIsComma) {
      this.unexpected(this.lastTokStart);
    }
    if (spreadStart) {
      this.unexpected(spreadStart);
    }
    this.checkExpressionErrors(refDestructuringErrors, true);
    this.yieldPos = oldYieldPos || this.yieldPos;
    this.awaitPos = oldAwaitPos || this.awaitPos;
    if (exprList.length > 1) {
      val = this.startNodeAt(innerStartPos, innerStartLoc);
      val.expressions = exprList;
      this.finishNodeAt(val, "SequenceExpression", innerEndPos, innerEndLoc);
    } else {
      val = exprList[0];
    }
  } else {
    val = this.parseParenExpression();
  }
  if (this.options.preserveParens) {
    var par = this.startNodeAt(startPos, startLoc);
    par.expression = val;
    return this.finishNode(par, "ParenthesizedExpression");
  } else {
    return val;
  }
};
pp$5.parseParenItem = function(item) {
  return item;
};
pp$5.parseParenArrowList = function(startPos, startLoc, exprList, forInit) {
  return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, false, forInit);
};
var empty = [];
pp$5.parseNew = function() {
  if (this.containsEsc) {
    this.raiseRecoverable(this.start, "Escape sequence in keyword new");
  }
  var node = this.startNode();
  this.next();
  if (this.options.ecmaVersion >= 6 && this.type === types$1.dot) {
    var meta = this.startNodeAt(node.start, node.loc && node.loc.start);
    meta.name = "new";
    node.meta = this.finishNode(meta, "Identifier");
    this.next();
    var containsEsc = this.containsEsc;
    node.property = this.parseIdent(true);
    if (node.property.name !== "target") {
      this.raiseRecoverable(node.property.start, "The only valid meta property for new is 'new.target'");
    }
    if (containsEsc) {
      this.raiseRecoverable(node.start, "'new.target' must not contain escaped characters");
    }
    if (!this.allowNewDotTarget) {
      this.raiseRecoverable(node.start, "'new.target' can only be used in functions and class static block");
    }
    return this.finishNode(node, "MetaProperty");
  }
  var startPos = this.start, startLoc = this.startLoc;
  node.callee = this.parseSubscripts(this.parseExprAtom(null, false, true), startPos, startLoc, true, false);
  if (this.eat(types$1.parenL)) {
    node.arguments = this.parseExprList(types$1.parenR, this.options.ecmaVersion >= 8, false);
  } else {
    node.arguments = empty;
  }
  return this.finishNode(node, "NewExpression");
};
pp$5.parseTemplateElement = function(ref2) {
  var isTagged = ref2.isTagged;
  var elem = this.startNode();
  if (this.type === types$1.invalidTemplate) {
    if (!isTagged) {
      this.raiseRecoverable(this.start, "Bad escape sequence in untagged template literal");
    }
    elem.value = {
      raw: this.value.replace(/\r\n?/g, "\n"),
      cooked: null
    };
  } else {
    elem.value = {
      raw: this.input.slice(this.start, this.end).replace(/\r\n?/g, "\n"),
      cooked: this.value
    };
  }
  this.next();
  elem.tail = this.type === types$1.backQuote;
  return this.finishNode(elem, "TemplateElement");
};
pp$5.parseTemplate = function(ref2) {
  if (ref2 === void 0) ref2 = {};
  var isTagged = ref2.isTagged;
  if (isTagged === void 0) isTagged = false;
  var node = this.startNode();
  this.next();
  node.expressions = [];
  var curElt = this.parseTemplateElement({ isTagged });
  node.quasis = [curElt];
  while (!curElt.tail) {
    if (this.type === types$1.eof) {
      this.raise(this.pos, "Unterminated template literal");
    }
    this.expect(types$1.dollarBraceL);
    node.expressions.push(this.parseExpression());
    this.expect(types$1.braceR);
    node.quasis.push(curElt = this.parseTemplateElement({ isTagged }));
  }
  this.next();
  return this.finishNode(node, "TemplateLiteral");
};
pp$5.isAsyncProp = function(prop) {
  return !prop.computed && prop.key.type === "Identifier" && prop.key.name === "async" && (this.type === types$1.name || this.type === types$1.num || this.type === types$1.string || this.type === types$1.bracketL || this.type.keyword || this.options.ecmaVersion >= 9 && this.type === types$1.star) && !lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
};
pp$5.parseObj = function(isPattern, refDestructuringErrors) {
  var node = this.startNode(), first = true, propHash = {};
  node.properties = [];
  this.next();
  while (!this.eat(types$1.braceR)) {
    if (!first) {
      this.expect(types$1.comma);
      if (this.options.ecmaVersion >= 5 && this.afterTrailingComma(types$1.braceR)) {
        break;
      }
    } else {
      first = false;
    }
    var prop = this.parseProperty(isPattern, refDestructuringErrors);
    if (!isPattern) {
      this.checkPropClash(prop, propHash, refDestructuringErrors);
    }
    node.properties.push(prop);
  }
  return this.finishNode(node, isPattern ? "ObjectPattern" : "ObjectExpression");
};
pp$5.parseProperty = function(isPattern, refDestructuringErrors) {
  var prop = this.startNode(), isGenerator, isAsync, startPos, startLoc;
  if (this.options.ecmaVersion >= 9 && this.eat(types$1.ellipsis)) {
    if (isPattern) {
      prop.argument = this.parseIdent(false);
      if (this.type === types$1.comma) {
        this.raiseRecoverable(this.start, "Comma is not permitted after the rest element");
      }
      return this.finishNode(prop, "RestElement");
    }
    prop.argument = this.parseMaybeAssign(false, refDestructuringErrors);
    if (this.type === types$1.comma && refDestructuringErrors && refDestructuringErrors.trailingComma < 0) {
      refDestructuringErrors.trailingComma = this.start;
    }
    return this.finishNode(prop, "SpreadElement");
  }
  if (this.options.ecmaVersion >= 6) {
    prop.method = false;
    prop.shorthand = false;
    if (isPattern || refDestructuringErrors) {
      startPos = this.start;
      startLoc = this.startLoc;
    }
    if (!isPattern) {
      isGenerator = this.eat(types$1.star);
    }
  }
  var containsEsc = this.containsEsc;
  this.parsePropertyName(prop);
  if (!isPattern && !containsEsc && this.options.ecmaVersion >= 8 && !isGenerator && this.isAsyncProp(prop)) {
    isAsync = true;
    isGenerator = this.options.ecmaVersion >= 9 && this.eat(types$1.star);
    this.parsePropertyName(prop);
  } else {
    isAsync = false;
  }
  this.parsePropertyValue(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc);
  return this.finishNode(prop, "Property");
};
pp$5.parseGetterSetter = function(prop) {
  prop.kind = prop.key.name;
  this.parsePropertyName(prop);
  prop.value = this.parseMethod(false);
  var paramCount = prop.kind === "get" ? 0 : 1;
  if (prop.value.params.length !== paramCount) {
    var start = prop.value.start;
    if (prop.kind === "get") {
      this.raiseRecoverable(start, "getter should have no params");
    } else {
      this.raiseRecoverable(start, "setter should have exactly one param");
    }
  } else {
    if (prop.kind === "set" && prop.value.params[0].type === "RestElement") {
      this.raiseRecoverable(prop.value.params[0].start, "Setter cannot use rest params");
    }
  }
};
pp$5.parsePropertyValue = function(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc) {
  if ((isGenerator || isAsync) && this.type === types$1.colon) {
    this.unexpected();
  }
  if (this.eat(types$1.colon)) {
    prop.value = isPattern ? this.parseMaybeDefault(this.start, this.startLoc) : this.parseMaybeAssign(false, refDestructuringErrors);
    prop.kind = "init";
  } else if (this.options.ecmaVersion >= 6 && this.type === types$1.parenL) {
    if (isPattern) {
      this.unexpected();
    }
    prop.kind = "init";
    prop.method = true;
    prop.value = this.parseMethod(isGenerator, isAsync);
  } else if (!isPattern && !containsEsc && this.options.ecmaVersion >= 5 && !prop.computed && prop.key.type === "Identifier" && (prop.key.name === "get" || prop.key.name === "set") && (this.type !== types$1.comma && this.type !== types$1.braceR && this.type !== types$1.eq)) {
    if (isGenerator || isAsync) {
      this.unexpected();
    }
    this.parseGetterSetter(prop);
  } else if (this.options.ecmaVersion >= 6 && !prop.computed && prop.key.type === "Identifier") {
    if (isGenerator || isAsync) {
      this.unexpected();
    }
    this.checkUnreserved(prop.key);
    if (prop.key.name === "await" && !this.awaitIdentPos) {
      this.awaitIdentPos = startPos;
    }
    prop.kind = "init";
    if (isPattern) {
      prop.value = this.parseMaybeDefault(startPos, startLoc, this.copyNode(prop.key));
    } else if (this.type === types$1.eq && refDestructuringErrors) {
      if (refDestructuringErrors.shorthandAssign < 0) {
        refDestructuringErrors.shorthandAssign = this.start;
      }
      prop.value = this.parseMaybeDefault(startPos, startLoc, this.copyNode(prop.key));
    } else {
      prop.value = this.copyNode(prop.key);
    }
    prop.shorthand = true;
  } else {
    this.unexpected();
  }
};
pp$5.parsePropertyName = function(prop) {
  if (this.options.ecmaVersion >= 6) {
    if (this.eat(types$1.bracketL)) {
      prop.computed = true;
      prop.key = this.parseMaybeAssign();
      this.expect(types$1.bracketR);
      return prop.key;
    } else {
      prop.computed = false;
    }
  }
  return prop.key = this.type === types$1.num || this.type === types$1.string ? this.parseExprAtom() : this.parseIdent(this.options.allowReserved !== "never");
};
pp$5.initFunction = function(node) {
  node.id = null;
  if (this.options.ecmaVersion >= 6) {
    node.generator = node.expression = false;
  }
  if (this.options.ecmaVersion >= 8) {
    node.async = false;
  }
};
pp$5.parseMethod = function(isGenerator, isAsync, allowDirectSuper) {
  var node = this.startNode(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
  this.initFunction(node);
  if (this.options.ecmaVersion >= 6) {
    node.generator = isGenerator;
  }
  if (this.options.ecmaVersion >= 8) {
    node.async = !!isAsync;
  }
  this.yieldPos = 0;
  this.awaitPos = 0;
  this.awaitIdentPos = 0;
  this.enterScope(functionFlags(isAsync, node.generator) | SCOPE_SUPER | (allowDirectSuper ? SCOPE_DIRECT_SUPER : 0));
  this.expect(types$1.parenL);
  node.params = this.parseBindingList(types$1.parenR, false, this.options.ecmaVersion >= 8);
  this.checkYieldAwaitInDefaultParams();
  this.parseFunctionBody(node, false, true, false);
  this.yieldPos = oldYieldPos;
  this.awaitPos = oldAwaitPos;
  this.awaitIdentPos = oldAwaitIdentPos;
  return this.finishNode(node, "FunctionExpression");
};
pp$5.parseArrowExpression = function(node, params, isAsync, forInit) {
  var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
  this.enterScope(functionFlags(isAsync, false) | SCOPE_ARROW);
  this.initFunction(node);
  if (this.options.ecmaVersion >= 8) {
    node.async = !!isAsync;
  }
  this.yieldPos = 0;
  this.awaitPos = 0;
  this.awaitIdentPos = 0;
  node.params = this.toAssignableList(params, true);
  this.parseFunctionBody(node, true, false, forInit);
  this.yieldPos = oldYieldPos;
  this.awaitPos = oldAwaitPos;
  this.awaitIdentPos = oldAwaitIdentPos;
  return this.finishNode(node, "ArrowFunctionExpression");
};
pp$5.parseFunctionBody = function(node, isArrowFunction, isMethod, forInit) {
  var isExpression = isArrowFunction && this.type !== types$1.braceL;
  var oldStrict = this.strict, useStrict = false;
  if (isExpression) {
    node.body = this.parseMaybeAssign(forInit);
    node.expression = true;
    this.checkParams(node, false);
  } else {
    var nonSimple = this.options.ecmaVersion >= 7 && !this.isSimpleParamList(node.params);
    if (!oldStrict || nonSimple) {
      useStrict = this.strictDirective(this.end);
      if (useStrict && nonSimple) {
        this.raiseRecoverable(node.start, "Illegal 'use strict' directive in function with non-simple parameter list");
      }
    }
    var oldLabels = this.labels;
    this.labels = [];
    if (useStrict) {
      this.strict = true;
    }
    this.checkParams(node, !oldStrict && !useStrict && !isArrowFunction && !isMethod && this.isSimpleParamList(node.params));
    if (this.strict && node.id) {
      this.checkLValSimple(node.id, BIND_OUTSIDE);
    }
    node.body = this.parseBlock(false, void 0, useStrict && !oldStrict);
    node.expression = false;
    this.adaptDirectivePrologue(node.body.body);
    this.labels = oldLabels;
  }
  this.exitScope();
};
pp$5.isSimpleParamList = function(params) {
  for (var i = 0, list = params; i < list.length; i += 1) {
    var param = list[i];
    if (param.type !== "Identifier") {
      return false;
    }
  }
  return true;
};
pp$5.checkParams = function(node, allowDuplicates) {
  var nameHash = /* @__PURE__ */ Object.create(null);
  for (var i = 0, list = node.params; i < list.length; i += 1) {
    var param = list[i];
    this.checkLValInnerPattern(param, BIND_VAR, allowDuplicates ? null : nameHash);
  }
};
pp$5.parseExprList = function(close, allowTrailingComma, allowEmpty, refDestructuringErrors) {
  var elts = [], first = true;
  while (!this.eat(close)) {
    if (!first) {
      this.expect(types$1.comma);
      if (allowTrailingComma && this.afterTrailingComma(close)) {
        break;
      }
    } else {
      first = false;
    }
    var elt = void 0;
    if (allowEmpty && this.type === types$1.comma) {
      elt = null;
    } else if (this.type === types$1.ellipsis) {
      elt = this.parseSpread(refDestructuringErrors);
      if (refDestructuringErrors && this.type === types$1.comma && refDestructuringErrors.trailingComma < 0) {
        refDestructuringErrors.trailingComma = this.start;
      }
    } else {
      elt = this.parseMaybeAssign(false, refDestructuringErrors);
    }
    elts.push(elt);
  }
  return elts;
};
pp$5.checkUnreserved = function(ref2) {
  var start = ref2.start;
  var end = ref2.end;
  var name = ref2.name;
  if (this.inGenerator && name === "yield") {
    this.raiseRecoverable(start, "Cannot use 'yield' as identifier inside a generator");
  }
  if (this.inAsync && name === "await") {
    this.raiseRecoverable(start, "Cannot use 'await' as identifier inside an async function");
  }
  if (this.currentThisScope().inClassFieldInit && name === "arguments") {
    this.raiseRecoverable(start, "Cannot use 'arguments' in class field initializer");
  }
  if (this.inClassStaticBlock && (name === "arguments" || name === "await")) {
    this.raise(start, "Cannot use " + name + " in class static initialization block");
  }
  if (this.keywords.test(name)) {
    this.raise(start, "Unexpected keyword '" + name + "'");
  }
  if (this.options.ecmaVersion < 6 && this.input.slice(start, end).indexOf("\\") !== -1) {
    return;
  }
  var re = this.strict ? this.reservedWordsStrict : this.reservedWords;
  if (re.test(name)) {
    if (!this.inAsync && name === "await") {
      this.raiseRecoverable(start, "Cannot use keyword 'await' outside an async function");
    }
    this.raiseRecoverable(start, "The keyword '" + name + "' is reserved");
  }
};
pp$5.parseIdent = function(liberal) {
  var node = this.parseIdentNode();
  this.next(!!liberal);
  this.finishNode(node, "Identifier");
  if (!liberal) {
    this.checkUnreserved(node);
    if (node.name === "await" && !this.awaitIdentPos) {
      this.awaitIdentPos = node.start;
    }
  }
  return node;
};
pp$5.parseIdentNode = function() {
  var node = this.startNode();
  if (this.type === types$1.name) {
    node.name = this.value;
  } else if (this.type.keyword) {
    node.name = this.type.keyword;
    if ((node.name === "class" || node.name === "function") && (this.lastTokEnd !== this.lastTokStart + 1 || this.input.charCodeAt(this.lastTokStart) !== 46)) {
      this.context.pop();
    }
    this.type = types$1.name;
  } else {
    this.unexpected();
  }
  return node;
};
pp$5.parsePrivateIdent = function() {
  var node = this.startNode();
  if (this.type === types$1.privateId) {
    node.name = this.value;
  } else {
    this.unexpected();
  }
  this.next();
  this.finishNode(node, "PrivateIdentifier");
  if (this.options.checkPrivateFields) {
    if (this.privateNameStack.length === 0) {
      this.raise(node.start, "Private field '#" + node.name + "' must be declared in an enclosing class");
    } else {
      this.privateNameStack[this.privateNameStack.length - 1].used.push(node);
    }
  }
  return node;
};
pp$5.parseYield = function(forInit) {
  if (!this.yieldPos) {
    this.yieldPos = this.start;
  }
  var node = this.startNode();
  this.next();
  if (this.type === types$1.semi || this.canInsertSemicolon() || this.type !== types$1.star && !this.type.startsExpr) {
    node.delegate = false;
    node.argument = null;
  } else {
    node.delegate = this.eat(types$1.star);
    node.argument = this.parseMaybeAssign(forInit);
  }
  return this.finishNode(node, "YieldExpression");
};
pp$5.parseAwait = function(forInit) {
  if (!this.awaitPos) {
    this.awaitPos = this.start;
  }
  var node = this.startNode();
  this.next();
  node.argument = this.parseMaybeUnary(null, true, false, forInit);
  return this.finishNode(node, "AwaitExpression");
};
var pp$4 = Parser.prototype;
pp$4.raise = function(pos, message) {
  var loc = getLineInfo(this.input, pos);
  message += " (" + loc.line + ":" + loc.column + ")";
  var err = new SyntaxError(message);
  err.pos = pos;
  err.loc = loc;
  err.raisedAt = this.pos;
  throw err;
};
pp$4.raiseRecoverable = pp$4.raise;
pp$4.curPosition = function() {
  if (this.options.locations) {
    return new Position(this.curLine, this.pos - this.lineStart);
  }
};
var pp$3 = Parser.prototype;
var Scope = /* @__PURE__ */ __name(function Scope2(flags) {
  this.flags = flags;
  this.var = [];
  this.lexical = [];
  this.functions = [];
  this.inClassFieldInit = false;
}, "Scope");
pp$3.enterScope = function(flags) {
  this.scopeStack.push(new Scope(flags));
};
pp$3.exitScope = function() {
  this.scopeStack.pop();
};
pp$3.treatFunctionsAsVarInScope = function(scope) {
  return scope.flags & SCOPE_FUNCTION || !this.inModule && scope.flags & SCOPE_TOP;
};
pp$3.declareName = function(name, bindingType, pos) {
  var redeclared = false;
  if (bindingType === BIND_LEXICAL) {
    var scope = this.currentScope();
    redeclared = scope.lexical.indexOf(name) > -1 || scope.functions.indexOf(name) > -1 || scope.var.indexOf(name) > -1;
    scope.lexical.push(name);
    if (this.inModule && scope.flags & SCOPE_TOP) {
      delete this.undefinedExports[name];
    }
  } else if (bindingType === BIND_SIMPLE_CATCH) {
    var scope$1 = this.currentScope();
    scope$1.lexical.push(name);
  } else if (bindingType === BIND_FUNCTION) {
    var scope$2 = this.currentScope();
    if (this.treatFunctionsAsVar) {
      redeclared = scope$2.lexical.indexOf(name) > -1;
    } else {
      redeclared = scope$2.lexical.indexOf(name) > -1 || scope$2.var.indexOf(name) > -1;
    }
    scope$2.functions.push(name);
  } else {
    for (var i = this.scopeStack.length - 1; i >= 0; --i) {
      var scope$3 = this.scopeStack[i];
      if (scope$3.lexical.indexOf(name) > -1 && !(scope$3.flags & SCOPE_SIMPLE_CATCH && scope$3.lexical[0] === name) || !this.treatFunctionsAsVarInScope(scope$3) && scope$3.functions.indexOf(name) > -1) {
        redeclared = true;
        break;
      }
      scope$3.var.push(name);
      if (this.inModule && scope$3.flags & SCOPE_TOP) {
        delete this.undefinedExports[name];
      }
      if (scope$3.flags & SCOPE_VAR) {
        break;
      }
    }
  }
  if (redeclared) {
    this.raiseRecoverable(pos, "Identifier '" + name + "' has already been declared");
  }
};
pp$3.checkLocalExport = function(id) {
  if (this.scopeStack[0].lexical.indexOf(id.name) === -1 && this.scopeStack[0].var.indexOf(id.name) === -1) {
    this.undefinedExports[id.name] = id;
  }
};
pp$3.currentScope = function() {
  return this.scopeStack[this.scopeStack.length - 1];
};
pp$3.currentVarScope = function() {
  for (var i = this.scopeStack.length - 1; ; i--) {
    var scope = this.scopeStack[i];
    if (scope.flags & SCOPE_VAR) {
      return scope;
    }
  }
};
pp$3.currentThisScope = function() {
  for (var i = this.scopeStack.length - 1; ; i--) {
    var scope = this.scopeStack[i];
    if (scope.flags & SCOPE_VAR && !(scope.flags & SCOPE_ARROW)) {
      return scope;
    }
  }
};
var Node = /* @__PURE__ */ __name(function Node2(parser, pos, loc) {
  this.type = "";
  this.start = pos;
  this.end = 0;
  if (parser.options.locations) {
    this.loc = new SourceLocation(parser, loc);
  }
  if (parser.options.directSourceFile) {
    this.sourceFile = parser.options.directSourceFile;
  }
  if (parser.options.ranges) {
    this.range = [pos, 0];
  }
}, "Node");
var pp$2 = Parser.prototype;
pp$2.startNode = function() {
  return new Node(this, this.start, this.startLoc);
};
pp$2.startNodeAt = function(pos, loc) {
  return new Node(this, pos, loc);
};
function finishNodeAt(node, type, pos, loc) {
  node.type = type;
  node.end = pos;
  if (this.options.locations) {
    node.loc.end = loc;
  }
  if (this.options.ranges) {
    node.range[1] = pos;
  }
  return node;
}
__name(finishNodeAt, "finishNodeAt");
pp$2.finishNode = function(node, type) {
  return finishNodeAt.call(this, node, type, this.lastTokEnd, this.lastTokEndLoc);
};
pp$2.finishNodeAt = function(node, type, pos, loc) {
  return finishNodeAt.call(this, node, type, pos, loc);
};
pp$2.copyNode = function(node) {
  var newNode = new Node(this, node.start, this.startLoc);
  for (var prop in node) {
    newNode[prop] = node[prop];
  }
  return newNode;
};
var ecma9BinaryProperties = "ASCII ASCII_Hex_Digit AHex Alphabetic Alpha Any Assigned Bidi_Control Bidi_C Bidi_Mirrored Bidi_M Case_Ignorable CI Cased Changes_When_Casefolded CWCF Changes_When_Casemapped CWCM Changes_When_Lowercased CWL Changes_When_NFKC_Casefolded CWKCF Changes_When_Titlecased CWT Changes_When_Uppercased CWU Dash Default_Ignorable_Code_Point DI Deprecated Dep Diacritic Dia Emoji Emoji_Component Emoji_Modifier Emoji_Modifier_Base Emoji_Presentation Extender Ext Grapheme_Base Gr_Base Grapheme_Extend Gr_Ext Hex_Digit Hex IDS_Binary_Operator IDSB IDS_Trinary_Operator IDST ID_Continue IDC ID_Start IDS Ideographic Ideo Join_Control Join_C Logical_Order_Exception LOE Lowercase Lower Math Noncharacter_Code_Point NChar Pattern_Syntax Pat_Syn Pattern_White_Space Pat_WS Quotation_Mark QMark Radical Regional_Indicator RI Sentence_Terminal STerm Soft_Dotted SD Terminal_Punctuation Term Unified_Ideograph UIdeo Uppercase Upper Variation_Selector VS White_Space space XID_Continue XIDC XID_Start XIDS";
var ecma10BinaryProperties = ecma9BinaryProperties + " Extended_Pictographic";
var ecma11BinaryProperties = ecma10BinaryProperties;
var ecma12BinaryProperties = ecma11BinaryProperties + " EBase EComp EMod EPres ExtPict";
var ecma13BinaryProperties = ecma12BinaryProperties;
var ecma14BinaryProperties = ecma13BinaryProperties;
var unicodeBinaryProperties = {
  9: ecma9BinaryProperties,
  10: ecma10BinaryProperties,
  11: ecma11BinaryProperties,
  12: ecma12BinaryProperties,
  13: ecma13BinaryProperties,
  14: ecma14BinaryProperties
};
var ecma14BinaryPropertiesOfStrings = "Basic_Emoji Emoji_Keycap_Sequence RGI_Emoji_Modifier_Sequence RGI_Emoji_Flag_Sequence RGI_Emoji_Tag_Sequence RGI_Emoji_ZWJ_Sequence RGI_Emoji";
var unicodeBinaryPropertiesOfStrings = {
  9: "",
  10: "",
  11: "",
  12: "",
  13: "",
  14: ecma14BinaryPropertiesOfStrings
};
var unicodeGeneralCategoryValues = "Cased_Letter LC Close_Punctuation Pe Connector_Punctuation Pc Control Cc cntrl Currency_Symbol Sc Dash_Punctuation Pd Decimal_Number Nd digit Enclosing_Mark Me Final_Punctuation Pf Format Cf Initial_Punctuation Pi Letter L Letter_Number Nl Line_Separator Zl Lowercase_Letter Ll Mark M Combining_Mark Math_Symbol Sm Modifier_Letter Lm Modifier_Symbol Sk Nonspacing_Mark Mn Number N Open_Punctuation Ps Other C Other_Letter Lo Other_Number No Other_Punctuation Po Other_Symbol So Paragraph_Separator Zp Private_Use Co Punctuation P punct Separator Z Space_Separator Zs Spacing_Mark Mc Surrogate Cs Symbol S Titlecase_Letter Lt Unassigned Cn Uppercase_Letter Lu";
var ecma9ScriptValues = "Adlam Adlm Ahom Anatolian_Hieroglyphs Hluw Arabic Arab Armenian Armn Avestan Avst Balinese Bali Bamum Bamu Bassa_Vah Bass Batak Batk Bengali Beng Bhaiksuki Bhks Bopomofo Bopo Brahmi Brah Braille Brai Buginese Bugi Buhid Buhd Canadian_Aboriginal Cans Carian Cari Caucasian_Albanian Aghb Chakma Cakm Cham Cham Cherokee Cher Common Zyyy Coptic Copt Qaac Cuneiform Xsux Cypriot Cprt Cyrillic Cyrl Deseret Dsrt Devanagari Deva Duployan Dupl Egyptian_Hieroglyphs Egyp Elbasan Elba Ethiopic Ethi Georgian Geor Glagolitic Glag Gothic Goth Grantha Gran Greek Grek Gujarati Gujr Gurmukhi Guru Han Hani Hangul Hang Hanunoo Hano Hatran Hatr Hebrew Hebr Hiragana Hira Imperial_Aramaic Armi Inherited Zinh Qaai Inscriptional_Pahlavi Phli Inscriptional_Parthian Prti Javanese Java Kaithi Kthi Kannada Knda Katakana Kana Kayah_Li Kali Kharoshthi Khar Khmer Khmr Khojki Khoj Khudawadi Sind Lao Laoo Latin Latn Lepcha Lepc Limbu Limb Linear_A Lina Linear_B Linb Lisu Lisu Lycian Lyci Lydian Lydi Mahajani Mahj Malayalam Mlym Mandaic Mand Manichaean Mani Marchen Marc Masaram_Gondi Gonm Meetei_Mayek Mtei Mende_Kikakui Mend Meroitic_Cursive Merc Meroitic_Hieroglyphs Mero Miao Plrd Modi Mongolian Mong Mro Mroo Multani Mult Myanmar Mymr Nabataean Nbat New_Tai_Lue Talu Newa Newa Nko Nkoo Nushu Nshu Ogham Ogam Ol_Chiki Olck Old_Hungarian Hung Old_Italic Ital Old_North_Arabian Narb Old_Permic Perm Old_Persian Xpeo Old_South_Arabian Sarb Old_Turkic Orkh Oriya Orya Osage Osge Osmanya Osma Pahawh_Hmong Hmng Palmyrene Palm Pau_Cin_Hau Pauc Phags_Pa Phag Phoenician Phnx Psalter_Pahlavi Phlp Rejang Rjng Runic Runr Samaritan Samr Saurashtra Saur Sharada Shrd Shavian Shaw Siddham Sidd SignWriting Sgnw Sinhala Sinh Sora_Sompeng Sora Soyombo Soyo Sundanese Sund Syloti_Nagri Sylo Syriac Syrc Tagalog Tglg Tagbanwa Tagb Tai_Le Tale Tai_Tham Lana Tai_Viet Tavt Takri Takr Tamil Taml Tangut Tang Telugu Telu Thaana Thaa Thai Thai Tibetan Tibt Tifinagh Tfng Tirhuta Tirh Ugaritic Ugar Vai Vaii Warang_Citi Wara Yi Yiii Zanabazar_Square Zanb";
var ecma10ScriptValues = ecma9ScriptValues + " Dogra Dogr Gunjala_Gondi Gong Hanifi_Rohingya Rohg Makasar Maka Medefaidrin Medf Old_Sogdian Sogo Sogdian Sogd";
var ecma11ScriptValues = ecma10ScriptValues + " Elymaic Elym Nandinagari Nand Nyiakeng_Puachue_Hmong Hmnp Wancho Wcho";
var ecma12ScriptValues = ecma11ScriptValues + " Chorasmian Chrs Diak Dives_Akuru Khitan_Small_Script Kits Yezi Yezidi";
var ecma13ScriptValues = ecma12ScriptValues + " Cypro_Minoan Cpmn Old_Uyghur Ougr Tangsa Tnsa Toto Vithkuqi Vith";
var ecma14ScriptValues = ecma13ScriptValues + " Hrkt Katakana_Or_Hiragana Kawi Nag_Mundari Nagm Unknown Zzzz";
var unicodeScriptValues = {
  9: ecma9ScriptValues,
  10: ecma10ScriptValues,
  11: ecma11ScriptValues,
  12: ecma12ScriptValues,
  13: ecma13ScriptValues,
  14: ecma14ScriptValues
};
var data = {};
function buildUnicodeData(ecmaVersion) {
  var d = data[ecmaVersion] = {
    binary: wordsRegexp(unicodeBinaryProperties[ecmaVersion] + " " + unicodeGeneralCategoryValues),
    binaryOfStrings: wordsRegexp(unicodeBinaryPropertiesOfStrings[ecmaVersion]),
    nonBinary: {
      General_Category: wordsRegexp(unicodeGeneralCategoryValues),
      Script: wordsRegexp(unicodeScriptValues[ecmaVersion])
    }
  };
  d.nonBinary.Script_Extensions = d.nonBinary.Script;
  d.nonBinary.gc = d.nonBinary.General_Category;
  d.nonBinary.sc = d.nonBinary.Script;
  d.nonBinary.scx = d.nonBinary.Script_Extensions;
}
__name(buildUnicodeData, "buildUnicodeData");
for (i = 0, list = [9, 10, 11, 12, 13, 14]; i < list.length; i += 1) {
  ecmaVersion = list[i];
  buildUnicodeData(ecmaVersion);
}
var ecmaVersion;
var i;
var list;
var pp$1 = Parser.prototype;
var BranchID = /* @__PURE__ */ __name(function BranchID2(parent, base) {
  this.parent = parent;
  this.base = base || this;
}, "BranchID");
BranchID.prototype.separatedFrom = /* @__PURE__ */ __name(function separatedFrom(alt) {
  for (var self = this; self; self = self.parent) {
    for (var other = alt; other; other = other.parent) {
      if (self.base === other.base && self !== other) {
        return true;
      }
    }
  }
  return false;
}, "separatedFrom");
BranchID.prototype.sibling = /* @__PURE__ */ __name(function sibling() {
  return new BranchID(this.parent, this.base);
}, "sibling");
var RegExpValidationState = /* @__PURE__ */ __name(function RegExpValidationState2(parser) {
  this.parser = parser;
  this.validFlags = "gim" + (parser.options.ecmaVersion >= 6 ? "uy" : "") + (parser.options.ecmaVersion >= 9 ? "s" : "") + (parser.options.ecmaVersion >= 13 ? "d" : "") + (parser.options.ecmaVersion >= 15 ? "v" : "");
  this.unicodeProperties = data[parser.options.ecmaVersion >= 14 ? 14 : parser.options.ecmaVersion];
  this.source = "";
  this.flags = "";
  this.start = 0;
  this.switchU = false;
  this.switchV = false;
  this.switchN = false;
  this.pos = 0;
  this.lastIntValue = 0;
  this.lastStringValue = "";
  this.lastAssertionIsQuantifiable = false;
  this.numCapturingParens = 0;
  this.maxBackReference = 0;
  this.groupNames = /* @__PURE__ */ Object.create(null);
  this.backReferenceNames = [];
  this.branchID = null;
}, "RegExpValidationState");
RegExpValidationState.prototype.reset = /* @__PURE__ */ __name(function reset(start, pattern, flags) {
  var unicodeSets = flags.indexOf("v") !== -1;
  var unicode = flags.indexOf("u") !== -1;
  this.start = start | 0;
  this.source = pattern + "";
  this.flags = flags;
  if (unicodeSets && this.parser.options.ecmaVersion >= 15) {
    this.switchU = true;
    this.switchV = true;
    this.switchN = true;
  } else {
    this.switchU = unicode && this.parser.options.ecmaVersion >= 6;
    this.switchV = false;
    this.switchN = unicode && this.parser.options.ecmaVersion >= 9;
  }
}, "reset");
RegExpValidationState.prototype.raise = /* @__PURE__ */ __name(function raise(message) {
  this.parser.raiseRecoverable(this.start, "Invalid regular expression: /" + this.source + "/: " + message);
}, "raise");
RegExpValidationState.prototype.at = /* @__PURE__ */ __name(function at(i, forceU) {
  if (forceU === void 0) forceU = false;
  var s = this.source;
  var l = s.length;
  if (i >= l) {
    return -1;
  }
  var c = s.charCodeAt(i);
  if (!(forceU || this.switchU) || c <= 55295 || c >= 57344 || i + 1 >= l) {
    return c;
  }
  var next = s.charCodeAt(i + 1);
  return next >= 56320 && next <= 57343 ? (c << 10) + next - 56613888 : c;
}, "at");
RegExpValidationState.prototype.nextIndex = /* @__PURE__ */ __name(function nextIndex(i, forceU) {
  if (forceU === void 0) forceU = false;
  var s = this.source;
  var l = s.length;
  if (i >= l) {
    return l;
  }
  var c = s.charCodeAt(i), next;
  if (!(forceU || this.switchU) || c <= 55295 || c >= 57344 || i + 1 >= l || (next = s.charCodeAt(i + 1)) < 56320 || next > 57343) {
    return i + 1;
  }
  return i + 2;
}, "nextIndex");
RegExpValidationState.prototype.current = /* @__PURE__ */ __name(function current(forceU) {
  if (forceU === void 0) forceU = false;
  return this.at(this.pos, forceU);
}, "current");
RegExpValidationState.prototype.lookahead = /* @__PURE__ */ __name(function lookahead(forceU) {
  if (forceU === void 0) forceU = false;
  return this.at(this.nextIndex(this.pos, forceU), forceU);
}, "lookahead");
RegExpValidationState.prototype.advance = /* @__PURE__ */ __name(function advance(forceU) {
  if (forceU === void 0) forceU = false;
  this.pos = this.nextIndex(this.pos, forceU);
}, "advance");
RegExpValidationState.prototype.eat = /* @__PURE__ */ __name(function eat(ch, forceU) {
  if (forceU === void 0) forceU = false;
  if (this.current(forceU) === ch) {
    this.advance(forceU);
    return true;
  }
  return false;
}, "eat");
RegExpValidationState.prototype.eatChars = /* @__PURE__ */ __name(function eatChars(chs, forceU) {
  if (forceU === void 0) forceU = false;
  var pos = this.pos;
  for (var i = 0, list = chs; i < list.length; i += 1) {
    var ch = list[i];
    var current2 = this.at(pos, forceU);
    if (current2 === -1 || current2 !== ch) {
      return false;
    }
    pos = this.nextIndex(pos, forceU);
  }
  this.pos = pos;
  return true;
}, "eatChars");
pp$1.validateRegExpFlags = function(state) {
  var validFlags = state.validFlags;
  var flags = state.flags;
  var u = false;
  var v = false;
  for (var i = 0; i < flags.length; i++) {
    var flag = flags.charAt(i);
    if (validFlags.indexOf(flag) === -1) {
      this.raise(state.start, "Invalid regular expression flag");
    }
    if (flags.indexOf(flag, i + 1) > -1) {
      this.raise(state.start, "Duplicate regular expression flag");
    }
    if (flag === "u") {
      u = true;
    }
    if (flag === "v") {
      v = true;
    }
  }
  if (this.options.ecmaVersion >= 15 && u && v) {
    this.raise(state.start, "Invalid regular expression flag");
  }
};
function hasProp(obj) {
  for (var _ in obj) {
    return true;
  }
  return false;
}
__name(hasProp, "hasProp");
pp$1.validateRegExpPattern = function(state) {
  this.regexp_pattern(state);
  if (!state.switchN && this.options.ecmaVersion >= 9 && hasProp(state.groupNames)) {
    state.switchN = true;
    this.regexp_pattern(state);
  }
};
pp$1.regexp_pattern = function(state) {
  state.pos = 0;
  state.lastIntValue = 0;
  state.lastStringValue = "";
  state.lastAssertionIsQuantifiable = false;
  state.numCapturingParens = 0;
  state.maxBackReference = 0;
  state.groupNames = /* @__PURE__ */ Object.create(null);
  state.backReferenceNames.length = 0;
  state.branchID = null;
  this.regexp_disjunction(state);
  if (state.pos !== state.source.length) {
    if (state.eat(
      41
      /* ) */
    )) {
      state.raise("Unmatched ')'");
    }
    if (state.eat(
      93
      /* ] */
    ) || state.eat(
      125
      /* } */
    )) {
      state.raise("Lone quantifier brackets");
    }
  }
  if (state.maxBackReference > state.numCapturingParens) {
    state.raise("Invalid escape");
  }
  for (var i = 0, list = state.backReferenceNames; i < list.length; i += 1) {
    var name = list[i];
    if (!state.groupNames[name]) {
      state.raise("Invalid named capture referenced");
    }
  }
};
pp$1.regexp_disjunction = function(state) {
  var trackDisjunction = this.options.ecmaVersion >= 16;
  if (trackDisjunction) {
    state.branchID = new BranchID(state.branchID, null);
  }
  this.regexp_alternative(state);
  while (state.eat(
    124
    /* | */
  )) {
    if (trackDisjunction) {
      state.branchID = state.branchID.sibling();
    }
    this.regexp_alternative(state);
  }
  if (trackDisjunction) {
    state.branchID = state.branchID.parent;
  }
  if (this.regexp_eatQuantifier(state, true)) {
    state.raise("Nothing to repeat");
  }
  if (state.eat(
    123
    /* { */
  )) {
    state.raise("Lone quantifier brackets");
  }
};
pp$1.regexp_alternative = function(state) {
  while (state.pos < state.source.length && this.regexp_eatTerm(state)) {
  }
};
pp$1.regexp_eatTerm = function(state) {
  if (this.regexp_eatAssertion(state)) {
    if (state.lastAssertionIsQuantifiable && this.regexp_eatQuantifier(state)) {
      if (state.switchU) {
        state.raise("Invalid quantifier");
      }
    }
    return true;
  }
  if (state.switchU ? this.regexp_eatAtom(state) : this.regexp_eatExtendedAtom(state)) {
    this.regexp_eatQuantifier(state);
    return true;
  }
  return false;
};
pp$1.regexp_eatAssertion = function(state) {
  var start = state.pos;
  state.lastAssertionIsQuantifiable = false;
  if (state.eat(
    94
    /* ^ */
  ) || state.eat(
    36
    /* $ */
  )) {
    return true;
  }
  if (state.eat(
    92
    /* \ */
  )) {
    if (state.eat(
      66
      /* B */
    ) || state.eat(
      98
      /* b */
    )) {
      return true;
    }
    state.pos = start;
  }
  if (state.eat(
    40
    /* ( */
  ) && state.eat(
    63
    /* ? */
  )) {
    var lookbehind = false;
    if (this.options.ecmaVersion >= 9) {
      lookbehind = state.eat(
        60
        /* < */
      );
    }
    if (state.eat(
      61
      /* = */
    ) || state.eat(
      33
      /* ! */
    )) {
      this.regexp_disjunction(state);
      if (!state.eat(
        41
        /* ) */
      )) {
        state.raise("Unterminated group");
      }
      state.lastAssertionIsQuantifiable = !lookbehind;
      return true;
    }
  }
  state.pos = start;
  return false;
};
pp$1.regexp_eatQuantifier = function(state, noError) {
  if (noError === void 0) noError = false;
  if (this.regexp_eatQuantifierPrefix(state, noError)) {
    state.eat(
      63
      /* ? */
    );
    return true;
  }
  return false;
};
pp$1.regexp_eatQuantifierPrefix = function(state, noError) {
  return state.eat(
    42
    /* * */
  ) || state.eat(
    43
    /* + */
  ) || state.eat(
    63
    /* ? */
  ) || this.regexp_eatBracedQuantifier(state, noError);
};
pp$1.regexp_eatBracedQuantifier = function(state, noError) {
  var start = state.pos;
  if (state.eat(
    123
    /* { */
  )) {
    var min = 0, max = -1;
    if (this.regexp_eatDecimalDigits(state)) {
      min = state.lastIntValue;
      if (state.eat(
        44
        /* , */
      ) && this.regexp_eatDecimalDigits(state)) {
        max = state.lastIntValue;
      }
      if (state.eat(
        125
        /* } */
      )) {
        if (max !== -1 && max < min && !noError) {
          state.raise("numbers out of order in {} quantifier");
        }
        return true;
      }
    }
    if (state.switchU && !noError) {
      state.raise("Incomplete quantifier");
    }
    state.pos = start;
  }
  return false;
};
pp$1.regexp_eatAtom = function(state) {
  return this.regexp_eatPatternCharacters(state) || state.eat(
    46
    /* . */
  ) || this.regexp_eatReverseSolidusAtomEscape(state) || this.regexp_eatCharacterClass(state) || this.regexp_eatUncapturingGroup(state) || this.regexp_eatCapturingGroup(state);
};
pp$1.regexp_eatReverseSolidusAtomEscape = function(state) {
  var start = state.pos;
  if (state.eat(
    92
    /* \ */
  )) {
    if (this.regexp_eatAtomEscape(state)) {
      return true;
    }
    state.pos = start;
  }
  return false;
};
pp$1.regexp_eatUncapturingGroup = function(state) {
  var start = state.pos;
  if (state.eat(
    40
    /* ( */
  )) {
    if (state.eat(
      63
      /* ? */
    ) && state.eat(
      58
      /* : */
    )) {
      this.regexp_disjunction(state);
      if (state.eat(
        41
        /* ) */
      )) {
        return true;
      }
      state.raise("Unterminated group");
    }
    state.pos = start;
  }
  return false;
};
pp$1.regexp_eatCapturingGroup = function(state) {
  if (state.eat(
    40
    /* ( */
  )) {
    if (this.options.ecmaVersion >= 9) {
      this.regexp_groupSpecifier(state);
    } else if (state.current() === 63) {
      state.raise("Invalid group");
    }
    this.regexp_disjunction(state);
    if (state.eat(
      41
      /* ) */
    )) {
      state.numCapturingParens += 1;
      return true;
    }
    state.raise("Unterminated group");
  }
  return false;
};
pp$1.regexp_eatExtendedAtom = function(state) {
  return state.eat(
    46
    /* . */
  ) || this.regexp_eatReverseSolidusAtomEscape(state) || this.regexp_eatCharacterClass(state) || this.regexp_eatUncapturingGroup(state) || this.regexp_eatCapturingGroup(state) || this.regexp_eatInvalidBracedQuantifier(state) || this.regexp_eatExtendedPatternCharacter(state);
};
pp$1.regexp_eatInvalidBracedQuantifier = function(state) {
  if (this.regexp_eatBracedQuantifier(state, true)) {
    state.raise("Nothing to repeat");
  }
  return false;
};
pp$1.regexp_eatSyntaxCharacter = function(state) {
  var ch = state.current();
  if (isSyntaxCharacter(ch)) {
    state.lastIntValue = ch;
    state.advance();
    return true;
  }
  return false;
};
function isSyntaxCharacter(ch) {
  return ch === 36 || ch >= 40 && ch <= 43 || ch === 46 || ch === 63 || ch >= 91 && ch <= 94 || ch >= 123 && ch <= 125;
}
__name(isSyntaxCharacter, "isSyntaxCharacter");
pp$1.regexp_eatPatternCharacters = function(state) {
  var start = state.pos;
  var ch = 0;
  while ((ch = state.current()) !== -1 && !isSyntaxCharacter(ch)) {
    state.advance();
  }
  return state.pos !== start;
};
pp$1.regexp_eatExtendedPatternCharacter = function(state) {
  var ch = state.current();
  if (ch !== -1 && ch !== 36 && !(ch >= 40 && ch <= 43) && ch !== 46 && ch !== 63 && ch !== 91 && ch !== 94 && ch !== 124) {
    state.advance();
    return true;
  }
  return false;
};
pp$1.regexp_groupSpecifier = function(state) {
  if (state.eat(
    63
    /* ? */
  )) {
    if (!this.regexp_eatGroupName(state)) {
      state.raise("Invalid group");
    }
    var trackDisjunction = this.options.ecmaVersion >= 16;
    var known = state.groupNames[state.lastStringValue];
    if (known) {
      if (trackDisjunction) {
        for (var i = 0, list = known; i < list.length; i += 1) {
          var altID = list[i];
          if (!altID.separatedFrom(state.branchID)) {
            state.raise("Duplicate capture group name");
          }
        }
      } else {
        state.raise("Duplicate capture group name");
      }
    }
    if (trackDisjunction) {
      (known || (state.groupNames[state.lastStringValue] = [])).push(state.branchID);
    } else {
      state.groupNames[state.lastStringValue] = true;
    }
  }
};
pp$1.regexp_eatGroupName = function(state) {
  state.lastStringValue = "";
  if (state.eat(
    60
    /* < */
  )) {
    if (this.regexp_eatRegExpIdentifierName(state) && state.eat(
      62
      /* > */
    )) {
      return true;
    }
    state.raise("Invalid capture group name");
  }
  return false;
};
pp$1.regexp_eatRegExpIdentifierName = function(state) {
  state.lastStringValue = "";
  if (this.regexp_eatRegExpIdentifierStart(state)) {
    state.lastStringValue += codePointToString(state.lastIntValue);
    while (this.regexp_eatRegExpIdentifierPart(state)) {
      state.lastStringValue += codePointToString(state.lastIntValue);
    }
    return true;
  }
  return false;
};
pp$1.regexp_eatRegExpIdentifierStart = function(state) {
  var start = state.pos;
  var forceU = this.options.ecmaVersion >= 11;
  var ch = state.current(forceU);
  state.advance(forceU);
  if (ch === 92 && this.regexp_eatRegExpUnicodeEscapeSequence(state, forceU)) {
    ch = state.lastIntValue;
  }
  if (isRegExpIdentifierStart(ch)) {
    state.lastIntValue = ch;
    return true;
  }
  state.pos = start;
  return false;
};
function isRegExpIdentifierStart(ch) {
  return isIdentifierStart(ch, true) || ch === 36 || ch === 95;
}
__name(isRegExpIdentifierStart, "isRegExpIdentifierStart");
pp$1.regexp_eatRegExpIdentifierPart = function(state) {
  var start = state.pos;
  var forceU = this.options.ecmaVersion >= 11;
  var ch = state.current(forceU);
  state.advance(forceU);
  if (ch === 92 && this.regexp_eatRegExpUnicodeEscapeSequence(state, forceU)) {
    ch = state.lastIntValue;
  }
  if (isRegExpIdentifierPart(ch)) {
    state.lastIntValue = ch;
    return true;
  }
  state.pos = start;
  return false;
};
function isRegExpIdentifierPart(ch) {
  return isIdentifierChar(ch, true) || ch === 36 || ch === 95 || ch === 8204 || ch === 8205;
}
__name(isRegExpIdentifierPart, "isRegExpIdentifierPart");
pp$1.regexp_eatAtomEscape = function(state) {
  if (this.regexp_eatBackReference(state) || this.regexp_eatCharacterClassEscape(state) || this.regexp_eatCharacterEscape(state) || state.switchN && this.regexp_eatKGroupName(state)) {
    return true;
  }
  if (state.switchU) {
    if (state.current() === 99) {
      state.raise("Invalid unicode escape");
    }
    state.raise("Invalid escape");
  }
  return false;
};
pp$1.regexp_eatBackReference = function(state) {
  var start = state.pos;
  if (this.regexp_eatDecimalEscape(state)) {
    var n = state.lastIntValue;
    if (state.switchU) {
      if (n > state.maxBackReference) {
        state.maxBackReference = n;
      }
      return true;
    }
    if (n <= state.numCapturingParens) {
      return true;
    }
    state.pos = start;
  }
  return false;
};
pp$1.regexp_eatKGroupName = function(state) {
  if (state.eat(
    107
    /* k */
  )) {
    if (this.regexp_eatGroupName(state)) {
      state.backReferenceNames.push(state.lastStringValue);
      return true;
    }
    state.raise("Invalid named reference");
  }
  return false;
};
pp$1.regexp_eatCharacterEscape = function(state) {
  return this.regexp_eatControlEscape(state) || this.regexp_eatCControlLetter(state) || this.regexp_eatZero(state) || this.regexp_eatHexEscapeSequence(state) || this.regexp_eatRegExpUnicodeEscapeSequence(state, false) || !state.switchU && this.regexp_eatLegacyOctalEscapeSequence(state) || this.regexp_eatIdentityEscape(state);
};
pp$1.regexp_eatCControlLetter = function(state) {
  var start = state.pos;
  if (state.eat(
    99
    /* c */
  )) {
    if (this.regexp_eatControlLetter(state)) {
      return true;
    }
    state.pos = start;
  }
  return false;
};
pp$1.regexp_eatZero = function(state) {
  if (state.current() === 48 && !isDecimalDigit(state.lookahead())) {
    state.lastIntValue = 0;
    state.advance();
    return true;
  }
  return false;
};
pp$1.regexp_eatControlEscape = function(state) {
  var ch = state.current();
  if (ch === 116) {
    state.lastIntValue = 9;
    state.advance();
    return true;
  }
  if (ch === 110) {
    state.lastIntValue = 10;
    state.advance();
    return true;
  }
  if (ch === 118) {
    state.lastIntValue = 11;
    state.advance();
    return true;
  }
  if (ch === 102) {
    state.lastIntValue = 12;
    state.advance();
    return true;
  }
  if (ch === 114) {
    state.lastIntValue = 13;
    state.advance();
    return true;
  }
  return false;
};
pp$1.regexp_eatControlLetter = function(state) {
  var ch = state.current();
  if (isControlLetter(ch)) {
    state.lastIntValue = ch % 32;
    state.advance();
    return true;
  }
  return false;
};
function isControlLetter(ch) {
  return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122;
}
__name(isControlLetter, "isControlLetter");
pp$1.regexp_eatRegExpUnicodeEscapeSequence = function(state, forceU) {
  if (forceU === void 0) forceU = false;
  var start = state.pos;
  var switchU = forceU || state.switchU;
  if (state.eat(
    117
    /* u */
  )) {
    if (this.regexp_eatFixedHexDigits(state, 4)) {
      var lead = state.lastIntValue;
      if (switchU && lead >= 55296 && lead <= 56319) {
        var leadSurrogateEnd = state.pos;
        if (state.eat(
          92
          /* \ */
        ) && state.eat(
          117
          /* u */
        ) && this.regexp_eatFixedHexDigits(state, 4)) {
          var trail = state.lastIntValue;
          if (trail >= 56320 && trail <= 57343) {
            state.lastIntValue = (lead - 55296) * 1024 + (trail - 56320) + 65536;
            return true;
          }
        }
        state.pos = leadSurrogateEnd;
        state.lastIntValue = lead;
      }
      return true;
    }
    if (switchU && state.eat(
      123
      /* { */
    ) && this.regexp_eatHexDigits(state) && state.eat(
      125
      /* } */
    ) && isValidUnicode(state.lastIntValue)) {
      return true;
    }
    if (switchU) {
      state.raise("Invalid unicode escape");
    }
    state.pos = start;
  }
  return false;
};
function isValidUnicode(ch) {
  return ch >= 0 && ch <= 1114111;
}
__name(isValidUnicode, "isValidUnicode");
pp$1.regexp_eatIdentityEscape = function(state) {
  if (state.switchU) {
    if (this.regexp_eatSyntaxCharacter(state)) {
      return true;
    }
    if (state.eat(
      47
      /* / */
    )) {
      state.lastIntValue = 47;
      return true;
    }
    return false;
  }
  var ch = state.current();
  if (ch !== 99 && (!state.switchN || ch !== 107)) {
    state.lastIntValue = ch;
    state.advance();
    return true;
  }
  return false;
};
pp$1.regexp_eatDecimalEscape = function(state) {
  state.lastIntValue = 0;
  var ch = state.current();
  if (ch >= 49 && ch <= 57) {
    do {
      state.lastIntValue = 10 * state.lastIntValue + (ch - 48);
      state.advance();
    } while ((ch = state.current()) >= 48 && ch <= 57);
    return true;
  }
  return false;
};
var CharSetNone = 0;
var CharSetOk = 1;
var CharSetString = 2;
pp$1.regexp_eatCharacterClassEscape = function(state) {
  var ch = state.current();
  if (isCharacterClassEscape(ch)) {
    state.lastIntValue = -1;
    state.advance();
    return CharSetOk;
  }
  var negate2 = false;
  if (state.switchU && this.options.ecmaVersion >= 9 && ((negate2 = ch === 80) || ch === 112)) {
    state.lastIntValue = -1;
    state.advance();
    var result;
    if (state.eat(
      123
      /* { */
    ) && (result = this.regexp_eatUnicodePropertyValueExpression(state)) && state.eat(
      125
      /* } */
    )) {
      if (negate2 && result === CharSetString) {
        state.raise("Invalid property name");
      }
      return result;
    }
    state.raise("Invalid property name");
  }
  return CharSetNone;
};
function isCharacterClassEscape(ch) {
  return ch === 100 || ch === 68 || ch === 115 || ch === 83 || ch === 119 || ch === 87;
}
__name(isCharacterClassEscape, "isCharacterClassEscape");
pp$1.regexp_eatUnicodePropertyValueExpression = function(state) {
  var start = state.pos;
  if (this.regexp_eatUnicodePropertyName(state) && state.eat(
    61
    /* = */
  )) {
    var name = state.lastStringValue;
    if (this.regexp_eatUnicodePropertyValue(state)) {
      var value = state.lastStringValue;
      this.regexp_validateUnicodePropertyNameAndValue(state, name, value);
      return CharSetOk;
    }
  }
  state.pos = start;
  if (this.regexp_eatLoneUnicodePropertyNameOrValue(state)) {
    var nameOrValue = state.lastStringValue;
    return this.regexp_validateUnicodePropertyNameOrValue(state, nameOrValue);
  }
  return CharSetNone;
};
pp$1.regexp_validateUnicodePropertyNameAndValue = function(state, name, value) {
  if (!hasOwn(state.unicodeProperties.nonBinary, name)) {
    state.raise("Invalid property name");
  }
  if (!state.unicodeProperties.nonBinary[name].test(value)) {
    state.raise("Invalid property value");
  }
};
pp$1.regexp_validateUnicodePropertyNameOrValue = function(state, nameOrValue) {
  if (state.unicodeProperties.binary.test(nameOrValue)) {
    return CharSetOk;
  }
  if (state.switchV && state.unicodeProperties.binaryOfStrings.test(nameOrValue)) {
    return CharSetString;
  }
  state.raise("Invalid property name");
};
pp$1.regexp_eatUnicodePropertyName = function(state) {
  var ch = 0;
  state.lastStringValue = "";
  while (isUnicodePropertyNameCharacter(ch = state.current())) {
    state.lastStringValue += codePointToString(ch);
    state.advance();
  }
  return state.lastStringValue !== "";
};
function isUnicodePropertyNameCharacter(ch) {
  return isControlLetter(ch) || ch === 95;
}
__name(isUnicodePropertyNameCharacter, "isUnicodePropertyNameCharacter");
pp$1.regexp_eatUnicodePropertyValue = function(state) {
  var ch = 0;
  state.lastStringValue = "";
  while (isUnicodePropertyValueCharacter(ch = state.current())) {
    state.lastStringValue += codePointToString(ch);
    state.advance();
  }
  return state.lastStringValue !== "";
};
function isUnicodePropertyValueCharacter(ch) {
  return isUnicodePropertyNameCharacter(ch) || isDecimalDigit(ch);
}
__name(isUnicodePropertyValueCharacter, "isUnicodePropertyValueCharacter");
pp$1.regexp_eatLoneUnicodePropertyNameOrValue = function(state) {
  return this.regexp_eatUnicodePropertyValue(state);
};
pp$1.regexp_eatCharacterClass = function(state) {
  if (state.eat(
    91
    /* [ */
  )) {
    var negate2 = state.eat(
      94
      /* ^ */
    );
    var result = this.regexp_classContents(state);
    if (!state.eat(
      93
      /* ] */
    )) {
      state.raise("Unterminated character class");
    }
    if (negate2 && result === CharSetString) {
      state.raise("Negated character class may contain strings");
    }
    return true;
  }
  return false;
};
pp$1.regexp_classContents = function(state) {
  if (state.current() === 93) {
    return CharSetOk;
  }
  if (state.switchV) {
    return this.regexp_classSetExpression(state);
  }
  this.regexp_nonEmptyClassRanges(state);
  return CharSetOk;
};
pp$1.regexp_nonEmptyClassRanges = function(state) {
  while (this.regexp_eatClassAtom(state)) {
    var left = state.lastIntValue;
    if (state.eat(
      45
      /* - */
    ) && this.regexp_eatClassAtom(state)) {
      var right = state.lastIntValue;
      if (state.switchU && (left === -1 || right === -1)) {
        state.raise("Invalid character class");
      }
      if (left !== -1 && right !== -1 && left > right) {
        state.raise("Range out of order in character class");
      }
    }
  }
};
pp$1.regexp_eatClassAtom = function(state) {
  var start = state.pos;
  if (state.eat(
    92
    /* \ */
  )) {
    if (this.regexp_eatClassEscape(state)) {
      return true;
    }
    if (state.switchU) {
      var ch$1 = state.current();
      if (ch$1 === 99 || isOctalDigit(ch$1)) {
        state.raise("Invalid class escape");
      }
      state.raise("Invalid escape");
    }
    state.pos = start;
  }
  var ch = state.current();
  if (ch !== 93) {
    state.lastIntValue = ch;
    state.advance();
    return true;
  }
  return false;
};
pp$1.regexp_eatClassEscape = function(state) {
  var start = state.pos;
  if (state.eat(
    98
    /* b */
  )) {
    state.lastIntValue = 8;
    return true;
  }
  if (state.switchU && state.eat(
    45
    /* - */
  )) {
    state.lastIntValue = 45;
    return true;
  }
  if (!state.switchU && state.eat(
    99
    /* c */
  )) {
    if (this.regexp_eatClassControlLetter(state)) {
      return true;
    }
    state.pos = start;
  }
  return this.regexp_eatCharacterClassEscape(state) || this.regexp_eatCharacterEscape(state);
};
pp$1.regexp_classSetExpression = function(state) {
  var result = CharSetOk, subResult;
  if (this.regexp_eatClassSetRange(state)) ;
  else if (subResult = this.regexp_eatClassSetOperand(state)) {
    if (subResult === CharSetString) {
      result = CharSetString;
    }
    var start = state.pos;
    while (state.eatChars(
      [38, 38]
      /* && */
    )) {
      if (state.current() !== 38 && (subResult = this.regexp_eatClassSetOperand(state))) {
        if (subResult !== CharSetString) {
          result = CharSetOk;
        }
        continue;
      }
      state.raise("Invalid character in character class");
    }
    if (start !== state.pos) {
      return result;
    }
    while (state.eatChars(
      [45, 45]
      /* -- */
    )) {
      if (this.regexp_eatClassSetOperand(state)) {
        continue;
      }
      state.raise("Invalid character in character class");
    }
    if (start !== state.pos) {
      return result;
    }
  } else {
    state.raise("Invalid character in character class");
  }
  for (; ; ) {
    if (this.regexp_eatClassSetRange(state)) {
      continue;
    }
    subResult = this.regexp_eatClassSetOperand(state);
    if (!subResult) {
      return result;
    }
    if (subResult === CharSetString) {
      result = CharSetString;
    }
  }
};
pp$1.regexp_eatClassSetRange = function(state) {
  var start = state.pos;
  if (this.regexp_eatClassSetCharacter(state)) {
    var left = state.lastIntValue;
    if (state.eat(
      45
      /* - */
    ) && this.regexp_eatClassSetCharacter(state)) {
      var right = state.lastIntValue;
      if (left !== -1 && right !== -1 && left > right) {
        state.raise("Range out of order in character class");
      }
      return true;
    }
    state.pos = start;
  }
  return false;
};
pp$1.regexp_eatClassSetOperand = function(state) {
  if (this.regexp_eatClassSetCharacter(state)) {
    return CharSetOk;
  }
  return this.regexp_eatClassStringDisjunction(state) || this.regexp_eatNestedClass(state);
};
pp$1.regexp_eatNestedClass = function(state) {
  var start = state.pos;
  if (state.eat(
    91
    /* [ */
  )) {
    var negate2 = state.eat(
      94
      /* ^ */
    );
    var result = this.regexp_classContents(state);
    if (state.eat(
      93
      /* ] */
    )) {
      if (negate2 && result === CharSetString) {
        state.raise("Negated character class may contain strings");
      }
      return result;
    }
    state.pos = start;
  }
  if (state.eat(
    92
    /* \ */
  )) {
    var result$1 = this.regexp_eatCharacterClassEscape(state);
    if (result$1) {
      return result$1;
    }
    state.pos = start;
  }
  return null;
};
pp$1.regexp_eatClassStringDisjunction = function(state) {
  var start = state.pos;
  if (state.eatChars(
    [92, 113]
    /* \q */
  )) {
    if (state.eat(
      123
      /* { */
    )) {
      var result = this.regexp_classStringDisjunctionContents(state);
      if (state.eat(
        125
        /* } */
      )) {
        return result;
      }
    } else {
      state.raise("Invalid escape");
    }
    state.pos = start;
  }
  return null;
};
pp$1.regexp_classStringDisjunctionContents = function(state) {
  var result = this.regexp_classString(state);
  while (state.eat(
    124
    /* | */
  )) {
    if (this.regexp_classString(state) === CharSetString) {
      result = CharSetString;
    }
  }
  return result;
};
pp$1.regexp_classString = function(state) {
  var count = 0;
  while (this.regexp_eatClassSetCharacter(state)) {
    count++;
  }
  return count === 1 ? CharSetOk : CharSetString;
};
pp$1.regexp_eatClassSetCharacter = function(state) {
  var start = state.pos;
  if (state.eat(
    92
    /* \ */
  )) {
    if (this.regexp_eatCharacterEscape(state) || this.regexp_eatClassSetReservedPunctuator(state)) {
      return true;
    }
    if (state.eat(
      98
      /* b */
    )) {
      state.lastIntValue = 8;
      return true;
    }
    state.pos = start;
    return false;
  }
  var ch = state.current();
  if (ch < 0 || ch === state.lookahead() && isClassSetReservedDoublePunctuatorCharacter(ch)) {
    return false;
  }
  if (isClassSetSyntaxCharacter(ch)) {
    return false;
  }
  state.advance();
  state.lastIntValue = ch;
  return true;
};
function isClassSetReservedDoublePunctuatorCharacter(ch) {
  return ch === 33 || ch >= 35 && ch <= 38 || ch >= 42 && ch <= 44 || ch === 46 || ch >= 58 && ch <= 64 || ch === 94 || ch === 96 || ch === 126;
}
__name(isClassSetReservedDoublePunctuatorCharacter, "isClassSetReservedDoublePunctuatorCharacter");
function isClassSetSyntaxCharacter(ch) {
  return ch === 40 || ch === 41 || ch === 45 || ch === 47 || ch >= 91 && ch <= 93 || ch >= 123 && ch <= 125;
}
__name(isClassSetSyntaxCharacter, "isClassSetSyntaxCharacter");
pp$1.regexp_eatClassSetReservedPunctuator = function(state) {
  var ch = state.current();
  if (isClassSetReservedPunctuator(ch)) {
    state.lastIntValue = ch;
    state.advance();
    return true;
  }
  return false;
};
function isClassSetReservedPunctuator(ch) {
  return ch === 33 || ch === 35 || ch === 37 || ch === 38 || ch === 44 || ch === 45 || ch >= 58 && ch <= 62 || ch === 64 || ch === 96 || ch === 126;
}
__name(isClassSetReservedPunctuator, "isClassSetReservedPunctuator");
pp$1.regexp_eatClassControlLetter = function(state) {
  var ch = state.current();
  if (isDecimalDigit(ch) || ch === 95) {
    state.lastIntValue = ch % 32;
    state.advance();
    return true;
  }
  return false;
};
pp$1.regexp_eatHexEscapeSequence = function(state) {
  var start = state.pos;
  if (state.eat(
    120
    /* x */
  )) {
    if (this.regexp_eatFixedHexDigits(state, 2)) {
      return true;
    }
    if (state.switchU) {
      state.raise("Invalid escape");
    }
    state.pos = start;
  }
  return false;
};
pp$1.regexp_eatDecimalDigits = function(state) {
  var start = state.pos;
  var ch = 0;
  state.lastIntValue = 0;
  while (isDecimalDigit(ch = state.current())) {
    state.lastIntValue = 10 * state.lastIntValue + (ch - 48);
    state.advance();
  }
  return state.pos !== start;
};
function isDecimalDigit(ch) {
  return ch >= 48 && ch <= 57;
}
__name(isDecimalDigit, "isDecimalDigit");
pp$1.regexp_eatHexDigits = function(state) {
  var start = state.pos;
  var ch = 0;
  state.lastIntValue = 0;
  while (isHexDigit(ch = state.current())) {
    state.lastIntValue = 16 * state.lastIntValue + hexToInt(ch);
    state.advance();
  }
  return state.pos !== start;
};
function isHexDigit(ch) {
  return ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102;
}
__name(isHexDigit, "isHexDigit");
function hexToInt(ch) {
  if (ch >= 65 && ch <= 70) {
    return 10 + (ch - 65);
  }
  if (ch >= 97 && ch <= 102) {
    return 10 + (ch - 97);
  }
  return ch - 48;
}
__name(hexToInt, "hexToInt");
pp$1.regexp_eatLegacyOctalEscapeSequence = function(state) {
  if (this.regexp_eatOctalDigit(state)) {
    var n1 = state.lastIntValue;
    if (this.regexp_eatOctalDigit(state)) {
      var n2 = state.lastIntValue;
      if (n1 <= 3 && this.regexp_eatOctalDigit(state)) {
        state.lastIntValue = n1 * 64 + n2 * 8 + state.lastIntValue;
      } else {
        state.lastIntValue = n1 * 8 + n2;
      }
    } else {
      state.lastIntValue = n1;
    }
    return true;
  }
  return false;
};
pp$1.regexp_eatOctalDigit = function(state) {
  var ch = state.current();
  if (isOctalDigit(ch)) {
    state.lastIntValue = ch - 48;
    state.advance();
    return true;
  }
  state.lastIntValue = 0;
  return false;
};
function isOctalDigit(ch) {
  return ch >= 48 && ch <= 55;
}
__name(isOctalDigit, "isOctalDigit");
pp$1.regexp_eatFixedHexDigits = function(state, length) {
  var start = state.pos;
  state.lastIntValue = 0;
  for (var i = 0; i < length; ++i) {
    var ch = state.current();
    if (!isHexDigit(ch)) {
      state.pos = start;
      return false;
    }
    state.lastIntValue = 16 * state.lastIntValue + hexToInt(ch);
    state.advance();
  }
  return true;
};
var Token = /* @__PURE__ */ __name(function Token2(p) {
  this.type = p.type;
  this.value = p.value;
  this.start = p.start;
  this.end = p.end;
  if (p.options.locations) {
    this.loc = new SourceLocation(p, p.startLoc, p.endLoc);
  }
  if (p.options.ranges) {
    this.range = [p.start, p.end];
  }
}, "Token");
var pp = Parser.prototype;
pp.next = function(ignoreEscapeSequenceInKeyword) {
  if (!ignoreEscapeSequenceInKeyword && this.type.keyword && this.containsEsc) {
    this.raiseRecoverable(this.start, "Escape sequence in keyword " + this.type.keyword);
  }
  if (this.options.onToken) {
    this.options.onToken(new Token(this));
  }
  this.lastTokEnd = this.end;
  this.lastTokStart = this.start;
  this.lastTokEndLoc = this.endLoc;
  this.lastTokStartLoc = this.startLoc;
  this.nextToken();
};
pp.getToken = function() {
  this.next();
  return new Token(this);
};
if (typeof Symbol !== "undefined") {
  pp[Symbol.iterator] = function() {
    var this$1$1 = this;
    return {
      next: /* @__PURE__ */ __name(function() {
        var token = this$1$1.getToken();
        return {
          done: token.type === types$1.eof,
          value: token
        };
      }, "next")
    };
  };
}
pp.nextToken = function() {
  var curContext = this.curContext();
  if (!curContext || !curContext.preserveSpace) {
    this.skipSpace();
  }
  this.start = this.pos;
  if (this.options.locations) {
    this.startLoc = this.curPosition();
  }
  if (this.pos >= this.input.length) {
    return this.finishToken(types$1.eof);
  }
  if (curContext.override) {
    return curContext.override(this);
  } else {
    this.readToken(this.fullCharCodeAtPos());
  }
};
pp.readToken = function(code) {
  if (isIdentifierStart(code, this.options.ecmaVersion >= 6) || code === 92) {
    return this.readWord();
  }
  return this.getTokenFromCode(code);
};
pp.fullCharCodeAtPos = function() {
  var code = this.input.charCodeAt(this.pos);
  if (code <= 55295 || code >= 56320) {
    return code;
  }
  var next = this.input.charCodeAt(this.pos + 1);
  return next <= 56319 || next >= 57344 ? code : (code << 10) + next - 56613888;
};
pp.skipBlockComment = function() {
  var startLoc = this.options.onComment && this.curPosition();
  var start = this.pos, end = this.input.indexOf("*/", this.pos += 2);
  if (end === -1) {
    this.raise(this.pos - 2, "Unterminated comment");
  }
  this.pos = end + 2;
  if (this.options.locations) {
    for (var nextBreak = void 0, pos = start; (nextBreak = nextLineBreak(this.input, pos, this.pos)) > -1; ) {
      ++this.curLine;
      pos = this.lineStart = nextBreak;
    }
  }
  if (this.options.onComment) {
    this.options.onComment(
      true,
      this.input.slice(start + 2, end),
      start,
      this.pos,
      startLoc,
      this.curPosition()
    );
  }
};
pp.skipLineComment = function(startSkip) {
  var start = this.pos;
  var startLoc = this.options.onComment && this.curPosition();
  var ch = this.input.charCodeAt(this.pos += startSkip);
  while (this.pos < this.input.length && !isNewLine(ch)) {
    ch = this.input.charCodeAt(++this.pos);
  }
  if (this.options.onComment) {
    this.options.onComment(
      false,
      this.input.slice(start + startSkip, this.pos),
      start,
      this.pos,
      startLoc,
      this.curPosition()
    );
  }
};
pp.skipSpace = function() {
  loop: while (this.pos < this.input.length) {
    var ch = this.input.charCodeAt(this.pos);
    switch (ch) {
      case 32:
      case 160:
        ++this.pos;
        break;
      case 13:
        if (this.input.charCodeAt(this.pos + 1) === 10) {
          ++this.pos;
        }
      case 10:
      case 8232:
      case 8233:
        ++this.pos;
        if (this.options.locations) {
          ++this.curLine;
          this.lineStart = this.pos;
        }
        break;
      case 47:
        switch (this.input.charCodeAt(this.pos + 1)) {
          case 42:
            this.skipBlockComment();
            break;
          case 47:
            this.skipLineComment(2);
            break;
          default:
            break loop;
        }
        break;
      default:
        if (ch > 8 && ch < 14 || ch >= 5760 && nonASCIIwhitespace.test(String.fromCharCode(ch))) {
          ++this.pos;
        } else {
          break loop;
        }
    }
  }
};
pp.finishToken = function(type, val) {
  this.end = this.pos;
  if (this.options.locations) {
    this.endLoc = this.curPosition();
  }
  var prevType = this.type;
  this.type = type;
  this.value = val;
  this.updateContext(prevType);
};
pp.readToken_dot = function() {
  var next = this.input.charCodeAt(this.pos + 1);
  if (next >= 48 && next <= 57) {
    return this.readNumber(true);
  }
  var next2 = this.input.charCodeAt(this.pos + 2);
  if (this.options.ecmaVersion >= 6 && next === 46 && next2 === 46) {
    this.pos += 3;
    return this.finishToken(types$1.ellipsis);
  } else {
    ++this.pos;
    return this.finishToken(types$1.dot);
  }
};
pp.readToken_slash = function() {
  var next = this.input.charCodeAt(this.pos + 1);
  if (this.exprAllowed) {
    ++this.pos;
    return this.readRegexp();
  }
  if (next === 61) {
    return this.finishOp(types$1.assign, 2);
  }
  return this.finishOp(types$1.slash, 1);
};
pp.readToken_mult_modulo_exp = function(code) {
  var next = this.input.charCodeAt(this.pos + 1);
  var size = 1;
  var tokentype = code === 42 ? types$1.star : types$1.modulo;
  if (this.options.ecmaVersion >= 7 && code === 42 && next === 42) {
    ++size;
    tokentype = types$1.starstar;
    next = this.input.charCodeAt(this.pos + 2);
  }
  if (next === 61) {
    return this.finishOp(types$1.assign, size + 1);
  }
  return this.finishOp(tokentype, size);
};
pp.readToken_pipe_amp = function(code) {
  var next = this.input.charCodeAt(this.pos + 1);
  if (next === code) {
    if (this.options.ecmaVersion >= 12) {
      var next2 = this.input.charCodeAt(this.pos + 2);
      if (next2 === 61) {
        return this.finishOp(types$1.assign, 3);
      }
    }
    return this.finishOp(code === 124 ? types$1.logicalOR : types$1.logicalAND, 2);
  }
  if (next === 61) {
    return this.finishOp(types$1.assign, 2);
  }
  return this.finishOp(code === 124 ? types$1.bitwiseOR : types$1.bitwiseAND, 1);
};
pp.readToken_caret = function() {
  var next = this.input.charCodeAt(this.pos + 1);
  if (next === 61) {
    return this.finishOp(types$1.assign, 2);
  }
  return this.finishOp(types$1.bitwiseXOR, 1);
};
pp.readToken_plus_min = function(code) {
  var next = this.input.charCodeAt(this.pos + 1);
  if (next === code) {
    if (next === 45 && !this.inModule && this.input.charCodeAt(this.pos + 2) === 62 && (this.lastTokEnd === 0 || lineBreak.test(this.input.slice(this.lastTokEnd, this.pos)))) {
      this.skipLineComment(3);
      this.skipSpace();
      return this.nextToken();
    }
    return this.finishOp(types$1.incDec, 2);
  }
  if (next === 61) {
    return this.finishOp(types$1.assign, 2);
  }
  return this.finishOp(types$1.plusMin, 1);
};
pp.readToken_lt_gt = function(code) {
  var next = this.input.charCodeAt(this.pos + 1);
  var size = 1;
  if (next === code) {
    size = code === 62 && this.input.charCodeAt(this.pos + 2) === 62 ? 3 : 2;
    if (this.input.charCodeAt(this.pos + size) === 61) {
      return this.finishOp(types$1.assign, size + 1);
    }
    return this.finishOp(types$1.bitShift, size);
  }
  if (next === 33 && code === 60 && !this.inModule && this.input.charCodeAt(this.pos + 2) === 45 && this.input.charCodeAt(this.pos + 3) === 45) {
    this.skipLineComment(4);
    this.skipSpace();
    return this.nextToken();
  }
  if (next === 61) {
    size = 2;
  }
  return this.finishOp(types$1.relational, size);
};
pp.readToken_eq_excl = function(code) {
  var next = this.input.charCodeAt(this.pos + 1);
  if (next === 61) {
    return this.finishOp(types$1.equality, this.input.charCodeAt(this.pos + 2) === 61 ? 3 : 2);
  }
  if (code === 61 && next === 62 && this.options.ecmaVersion >= 6) {
    this.pos += 2;
    return this.finishToken(types$1.arrow);
  }
  return this.finishOp(code === 61 ? types$1.eq : types$1.prefix, 1);
};
pp.readToken_question = function() {
  var ecmaVersion = this.options.ecmaVersion;
  if (ecmaVersion >= 11) {
    var next = this.input.charCodeAt(this.pos + 1);
    if (next === 46) {
      var next2 = this.input.charCodeAt(this.pos + 2);
      if (next2 < 48 || next2 > 57) {
        return this.finishOp(types$1.questionDot, 2);
      }
    }
    if (next === 63) {
      if (ecmaVersion >= 12) {
        var next2$1 = this.input.charCodeAt(this.pos + 2);
        if (next2$1 === 61) {
          return this.finishOp(types$1.assign, 3);
        }
      }
      return this.finishOp(types$1.coalesce, 2);
    }
  }
  return this.finishOp(types$1.question, 1);
};
pp.readToken_numberSign = function() {
  var ecmaVersion = this.options.ecmaVersion;
  var code = 35;
  if (ecmaVersion >= 13) {
    ++this.pos;
    code = this.fullCharCodeAtPos();
    if (isIdentifierStart(code, true) || code === 92) {
      return this.finishToken(types$1.privateId, this.readWord1());
    }
  }
  this.raise(this.pos, "Unexpected character '" + codePointToString(code) + "'");
};
pp.getTokenFromCode = function(code) {
  switch (code) {
    // The interpretation of a dot depends on whether it is followed
    // by a digit or another two dots.
    case 46:
      return this.readToken_dot();
    // Punctuation tokens.
    case 40:
      ++this.pos;
      return this.finishToken(types$1.parenL);
    case 41:
      ++this.pos;
      return this.finishToken(types$1.parenR);
    case 59:
      ++this.pos;
      return this.finishToken(types$1.semi);
    case 44:
      ++this.pos;
      return this.finishToken(types$1.comma);
    case 91:
      ++this.pos;
      return this.finishToken(types$1.bracketL);
    case 93:
      ++this.pos;
      return this.finishToken(types$1.bracketR);
    case 123:
      ++this.pos;
      return this.finishToken(types$1.braceL);
    case 125:
      ++this.pos;
      return this.finishToken(types$1.braceR);
    case 58:
      ++this.pos;
      return this.finishToken(types$1.colon);
    case 96:
      if (this.options.ecmaVersion < 6) {
        break;
      }
      ++this.pos;
      return this.finishToken(types$1.backQuote);
    case 48:
      var next = this.input.charCodeAt(this.pos + 1);
      if (next === 120 || next === 88) {
        return this.readRadixNumber(16);
      }
      if (this.options.ecmaVersion >= 6) {
        if (next === 111 || next === 79) {
          return this.readRadixNumber(8);
        }
        if (next === 98 || next === 66) {
          return this.readRadixNumber(2);
        }
      }
    // Anything else beginning with a digit is an integer, octal
    // number, or float.
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
      return this.readNumber(false);
    // Quotes produce strings.
    case 34:
    case 39:
      return this.readString(code);
    // Operators are parsed inline in tiny state machines. '=' (61) is
    // often referred to. `finishOp` simply skips the amount of
    // characters it is given as second argument, and returns a token
    // of the type given by its first argument.
    case 47:
      return this.readToken_slash();
    case 37:
    case 42:
      return this.readToken_mult_modulo_exp(code);
    case 124:
    case 38:
      return this.readToken_pipe_amp(code);
    case 94:
      return this.readToken_caret();
    case 43:
    case 45:
      return this.readToken_plus_min(code);
    case 60:
    case 62:
      return this.readToken_lt_gt(code);
    case 61:
    case 33:
      return this.readToken_eq_excl(code);
    case 63:
      return this.readToken_question();
    case 126:
      return this.finishOp(types$1.prefix, 1);
    case 35:
      return this.readToken_numberSign();
  }
  this.raise(this.pos, "Unexpected character '" + codePointToString(code) + "'");
};
pp.finishOp = function(type, size) {
  var str = this.input.slice(this.pos, this.pos + size);
  this.pos += size;
  return this.finishToken(type, str);
};
pp.readRegexp = function() {
  var escaped, inClass, start = this.pos;
  for (; ; ) {
    if (this.pos >= this.input.length) {
      this.raise(start, "Unterminated regular expression");
    }
    var ch = this.input.charAt(this.pos);
    if (lineBreak.test(ch)) {
      this.raise(start, "Unterminated regular expression");
    }
    if (!escaped) {
      if (ch === "[") {
        inClass = true;
      } else if (ch === "]" && inClass) {
        inClass = false;
      } else if (ch === "/" && !inClass) {
        break;
      }
      escaped = ch === "\\";
    } else {
      escaped = false;
    }
    ++this.pos;
  }
  var pattern = this.input.slice(start, this.pos);
  ++this.pos;
  var flagsStart = this.pos;
  var flags = this.readWord1();
  if (this.containsEsc) {
    this.unexpected(flagsStart);
  }
  var state = this.regexpState || (this.regexpState = new RegExpValidationState(this));
  state.reset(start, pattern, flags);
  this.validateRegExpFlags(state);
  this.validateRegExpPattern(state);
  var value = null;
  try {
    value = new RegExp(pattern, flags);
  } catch (e) {
  }
  return this.finishToken(types$1.regexp, { pattern, flags, value });
};
pp.readInt = function(radix, len, maybeLegacyOctalNumericLiteral) {
  var allowSeparators = this.options.ecmaVersion >= 12 && len === void 0;
  var isLegacyOctalNumericLiteral = maybeLegacyOctalNumericLiteral && this.input.charCodeAt(this.pos) === 48;
  var start = this.pos, total = 0, lastCode = 0;
  for (var i = 0, e = len == null ? Infinity : len; i < e; ++i, ++this.pos) {
    var code = this.input.charCodeAt(this.pos), val = void 0;
    if (allowSeparators && code === 95) {
      if (isLegacyOctalNumericLiteral) {
        this.raiseRecoverable(this.pos, "Numeric separator is not allowed in legacy octal numeric literals");
      }
      if (lastCode === 95) {
        this.raiseRecoverable(this.pos, "Numeric separator must be exactly one underscore");
      }
      if (i === 0) {
        this.raiseRecoverable(this.pos, "Numeric separator is not allowed at the first of digits");
      }
      lastCode = code;
      continue;
    }
    if (code >= 97) {
      val = code - 97 + 10;
    } else if (code >= 65) {
      val = code - 65 + 10;
    } else if (code >= 48 && code <= 57) {
      val = code - 48;
    } else {
      val = Infinity;
    }
    if (val >= radix) {
      break;
    }
    lastCode = code;
    total = total * radix + val;
  }
  if (allowSeparators && lastCode === 95) {
    this.raiseRecoverable(this.pos - 1, "Numeric separator is not allowed at the last of digits");
  }
  if (this.pos === start || len != null && this.pos - start !== len) {
    return null;
  }
  return total;
};
function stringToNumber(str, isLegacyOctalNumericLiteral) {
  if (isLegacyOctalNumericLiteral) {
    return parseInt(str, 8);
  }
  return parseFloat(str.replace(/_/g, ""));
}
__name(stringToNumber, "stringToNumber");
function stringToBigInt(str) {
  if (typeof BigInt !== "function") {
    return null;
  }
  return BigInt(str.replace(/_/g, ""));
}
__name(stringToBigInt, "stringToBigInt");
pp.readRadixNumber = function(radix) {
  var start = this.pos;
  this.pos += 2;
  var val = this.readInt(radix);
  if (val == null) {
    this.raise(this.start + 2, "Expected number in radix " + radix);
  }
  if (this.options.ecmaVersion >= 11 && this.input.charCodeAt(this.pos) === 110) {
    val = stringToBigInt(this.input.slice(start, this.pos));
    ++this.pos;
  } else if (isIdentifierStart(this.fullCharCodeAtPos())) {
    this.raise(this.pos, "Identifier directly after number");
  }
  return this.finishToken(types$1.num, val);
};
pp.readNumber = function(startsWithDot) {
  var start = this.pos;
  if (!startsWithDot && this.readInt(10, void 0, true) === null) {
    this.raise(start, "Invalid number");
  }
  var octal = this.pos - start >= 2 && this.input.charCodeAt(start) === 48;
  if (octal && this.strict) {
    this.raise(start, "Invalid number");
  }
  var next = this.input.charCodeAt(this.pos);
  if (!octal && !startsWithDot && this.options.ecmaVersion >= 11 && next === 110) {
    var val$1 = stringToBigInt(this.input.slice(start, this.pos));
    ++this.pos;
    if (isIdentifierStart(this.fullCharCodeAtPos())) {
      this.raise(this.pos, "Identifier directly after number");
    }
    return this.finishToken(types$1.num, val$1);
  }
  if (octal && /[89]/.test(this.input.slice(start, this.pos))) {
    octal = false;
  }
  if (next === 46 && !octal) {
    ++this.pos;
    this.readInt(10);
    next = this.input.charCodeAt(this.pos);
  }
  if ((next === 69 || next === 101) && !octal) {
    next = this.input.charCodeAt(++this.pos);
    if (next === 43 || next === 45) {
      ++this.pos;
    }
    if (this.readInt(10) === null) {
      this.raise(start, "Invalid number");
    }
  }
  if (isIdentifierStart(this.fullCharCodeAtPos())) {
    this.raise(this.pos, "Identifier directly after number");
  }
  var val = stringToNumber(this.input.slice(start, this.pos), octal);
  return this.finishToken(types$1.num, val);
};
pp.readCodePoint = function() {
  var ch = this.input.charCodeAt(this.pos), code;
  if (ch === 123) {
    if (this.options.ecmaVersion < 6) {
      this.unexpected();
    }
    var codePos = ++this.pos;
    code = this.readHexChar(this.input.indexOf("}", this.pos) - this.pos);
    ++this.pos;
    if (code > 1114111) {
      this.invalidStringToken(codePos, "Code point out of bounds");
    }
  } else {
    code = this.readHexChar(4);
  }
  return code;
};
pp.readString = function(quote) {
  var out = "", chunkStart = ++this.pos;
  for (; ; ) {
    if (this.pos >= this.input.length) {
      this.raise(this.start, "Unterminated string constant");
    }
    var ch = this.input.charCodeAt(this.pos);
    if (ch === quote) {
      break;
    }
    if (ch === 92) {
      out += this.input.slice(chunkStart, this.pos);
      out += this.readEscapedChar(false);
      chunkStart = this.pos;
    } else if (ch === 8232 || ch === 8233) {
      if (this.options.ecmaVersion < 10) {
        this.raise(this.start, "Unterminated string constant");
      }
      ++this.pos;
      if (this.options.locations) {
        this.curLine++;
        this.lineStart = this.pos;
      }
    } else {
      if (isNewLine(ch)) {
        this.raise(this.start, "Unterminated string constant");
      }
      ++this.pos;
    }
  }
  out += this.input.slice(chunkStart, this.pos++);
  return this.finishToken(types$1.string, out);
};
var INVALID_TEMPLATE_ESCAPE_ERROR = {};
pp.tryReadTemplateToken = function() {
  this.inTemplateElement = true;
  try {
    this.readTmplToken();
  } catch (err) {
    if (err === INVALID_TEMPLATE_ESCAPE_ERROR) {
      this.readInvalidTemplateToken();
    } else {
      throw err;
    }
  }
  this.inTemplateElement = false;
};
pp.invalidStringToken = function(position, message) {
  if (this.inTemplateElement && this.options.ecmaVersion >= 9) {
    throw INVALID_TEMPLATE_ESCAPE_ERROR;
  } else {
    this.raise(position, message);
  }
};
pp.readTmplToken = function() {
  var out = "", chunkStart = this.pos;
  for (; ; ) {
    if (this.pos >= this.input.length) {
      this.raise(this.start, "Unterminated template");
    }
    var ch = this.input.charCodeAt(this.pos);
    if (ch === 96 || ch === 36 && this.input.charCodeAt(this.pos + 1) === 123) {
      if (this.pos === this.start && (this.type === types$1.template || this.type === types$1.invalidTemplate)) {
        if (ch === 36) {
          this.pos += 2;
          return this.finishToken(types$1.dollarBraceL);
        } else {
          ++this.pos;
          return this.finishToken(types$1.backQuote);
        }
      }
      out += this.input.slice(chunkStart, this.pos);
      return this.finishToken(types$1.template, out);
    }
    if (ch === 92) {
      out += this.input.slice(chunkStart, this.pos);
      out += this.readEscapedChar(true);
      chunkStart = this.pos;
    } else if (isNewLine(ch)) {
      out += this.input.slice(chunkStart, this.pos);
      ++this.pos;
      switch (ch) {
        case 13:
          if (this.input.charCodeAt(this.pos) === 10) {
            ++this.pos;
          }
        case 10:
          out += "\n";
          break;
        default:
          out += String.fromCharCode(ch);
          break;
      }
      if (this.options.locations) {
        ++this.curLine;
        this.lineStart = this.pos;
      }
      chunkStart = this.pos;
    } else {
      ++this.pos;
    }
  }
};
pp.readInvalidTemplateToken = function() {
  for (; this.pos < this.input.length; this.pos++) {
    switch (this.input[this.pos]) {
      case "\\":
        ++this.pos;
        break;
      case "$":
        if (this.input[this.pos + 1] !== "{") {
          break;
        }
      // fall through
      case "`":
        return this.finishToken(types$1.invalidTemplate, this.input.slice(this.start, this.pos));
      case "\r":
        if (this.input[this.pos + 1] === "\n") {
          ++this.pos;
        }
      // fall through
      case "\n":
      case "\u2028":
      case "\u2029":
        ++this.curLine;
        this.lineStart = this.pos + 1;
        break;
    }
  }
  this.raise(this.start, "Unterminated template");
};
pp.readEscapedChar = function(inTemplate) {
  var ch = this.input.charCodeAt(++this.pos);
  ++this.pos;
  switch (ch) {
    case 110:
      return "\n";
    // 'n' -> '\n'
    case 114:
      return "\r";
    // 'r' -> '\r'
    case 120:
      return String.fromCharCode(this.readHexChar(2));
    // 'x'
    case 117:
      return codePointToString(this.readCodePoint());
    // 'u'
    case 116:
      return "	";
    // 't' -> '\t'
    case 98:
      return "\b";
    // 'b' -> '\b'
    case 118:
      return "\v";
    // 'v' -> '\u000b'
    case 102:
      return "\f";
    // 'f' -> '\f'
    case 13:
      if (this.input.charCodeAt(this.pos) === 10) {
        ++this.pos;
      }
    // '\r\n'
    case 10:
      if (this.options.locations) {
        this.lineStart = this.pos;
        ++this.curLine;
      }
      return "";
    case 56:
    case 57:
      if (this.strict) {
        this.invalidStringToken(
          this.pos - 1,
          "Invalid escape sequence"
        );
      }
      if (inTemplate) {
        var codePos = this.pos - 1;
        this.invalidStringToken(
          codePos,
          "Invalid escape sequence in template string"
        );
      }
    default:
      if (ch >= 48 && ch <= 55) {
        var octalStr = this.input.substr(this.pos - 1, 3).match(/^[0-7]+/)[0];
        var octal = parseInt(octalStr, 8);
        if (octal > 255) {
          octalStr = octalStr.slice(0, -1);
          octal = parseInt(octalStr, 8);
        }
        this.pos += octalStr.length - 1;
        ch = this.input.charCodeAt(this.pos);
        if ((octalStr !== "0" || ch === 56 || ch === 57) && (this.strict || inTemplate)) {
          this.invalidStringToken(
            this.pos - 1 - octalStr.length,
            inTemplate ? "Octal literal in template string" : "Octal literal in strict mode"
          );
        }
        return String.fromCharCode(octal);
      }
      if (isNewLine(ch)) {
        if (this.options.locations) {
          this.lineStart = this.pos;
          ++this.curLine;
        }
        return "";
      }
      return String.fromCharCode(ch);
  }
};
pp.readHexChar = function(len) {
  var codePos = this.pos;
  var n = this.readInt(16, len);
  if (n === null) {
    this.invalidStringToken(codePos, "Bad character escape sequence");
  }
  return n;
};
pp.readWord1 = function() {
  this.containsEsc = false;
  var word = "", first = true, chunkStart = this.pos;
  var astral = this.options.ecmaVersion >= 6;
  while (this.pos < this.input.length) {
    var ch = this.fullCharCodeAtPos();
    if (isIdentifierChar(ch, astral)) {
      this.pos += ch <= 65535 ? 1 : 2;
    } else if (ch === 92) {
      this.containsEsc = true;
      word += this.input.slice(chunkStart, this.pos);
      var escStart = this.pos;
      if (this.input.charCodeAt(++this.pos) !== 117) {
        this.invalidStringToken(this.pos, "Expecting Unicode escape sequence \\uXXXX");
      }
      ++this.pos;
      var esc = this.readCodePoint();
      if (!(first ? isIdentifierStart : isIdentifierChar)(esc, astral)) {
        this.invalidStringToken(escStart, "Invalid Unicode escape");
      }
      word += codePointToString(esc);
      chunkStart = this.pos;
    } else {
      break;
    }
    first = false;
  }
  return word + this.input.slice(chunkStart, this.pos);
};
pp.readWord = function() {
  var word = this.readWord1();
  var type = types$1.name;
  if (this.keywords.test(word)) {
    type = keywords[word];
  }
  return this.finishToken(type, word);
};
var version = "8.12.1";
Parser.acorn = {
  Parser,
  version,
  defaultOptions,
  Position,
  SourceLocation,
  getLineInfo,
  Node,
  TokenType,
  tokTypes: types$1,
  keywordTypes: keywords,
  TokContext,
  tokContexts: types,
  isIdentifierChar,
  isIdentifierStart,
  Token,
  isNewLine,
  lineBreak,
  lineBreakG,
  nonASCIIwhitespace
};
function parse3(input, options) {
  return Parser.parse(input, options);
}
__name(parse3, "parse");

// node_modules/jintr/dist/main.js
var __classPrivateFieldSet = function(receiver, state, value, kind, f) {
  if (kind === "m") throw new TypeError("Private method is not writable");
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value), value;
};
var __classPrivateFieldGet4 = function(receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _Jinter_ast;
var _Jinter = class _Jinter {
  constructor() {
    _Jinter_ast.set(this, []);
    this.visitor = new Visitor();
    this.scope = this.visitor.scope;
    this.scope.set("print", (args) => console.log(...args));
    this.defineObject("console", console);
    this.defineObject("Math", Math);
    this.defineObject("String", String);
    this.defineObject("Number", Number);
    this.defineObject("Array", Array);
    this.defineObject("Date", Date);
  }
  defineObject(name, obj) {
    this.visitor.on(name, (node, visitor) => {
      if (node.type === "Identifier")
        return obj;
      if (node.type === "CallExpression" && node.callee.type === "MemberExpression") {
        const prop = visitor.visitNode(node.callee.property);
        const args = node.arguments.map((arg) => visitor.visitNode(arg));
        const callable = obj[prop];
        if (!callable)
          return "__continue_exec";
        return callable.apply(obj, args);
      }
      return "__continue_exec";
    });
  }
  /**
   * Evaluates the program.
   * @returns The result of the last statement in the program.
   */
  evaluate(input) {
    const program = _Jinter.parseScript(input);
    __classPrivateFieldSet(this, _Jinter_ast, program.body, "f");
    this.visitor.setAST(__classPrivateFieldGet4(this, _Jinter_ast, "f"));
    return this.visitor.run();
  }
  /**
   * Generates an AST from the input.
   */
  static parseScript(input, options) {
    try {
      return parse3(input, { ecmaVersion: 2020, ...options || {} });
    } catch (e) {
      const match = e.message.match(/\((\d+):(\d+)\)/);
      if (match) {
        const line = parseInt(match[1], 10);
        const column = parseInt(match[2], 10);
        const lines = input.split("\n");
        const errorLine = lines[line - 1];
        const snippet = errorLine ? errorLine.substring(Math.max(0, column - 10), column + 10) : "";
        throw new JinterError(`${e.message.replace(/\(.*\)/, "").trim()} at line ${line}, column ${column}: ${snippet}`, { errorLine });
      } else {
        throw new JinterError(e.message);
      }
    }
  }
};
__name(_Jinter, "Jinter");
var Jinter = _Jinter;
_Jinter_ast = /* @__PURE__ */ new WeakMap();

// dist/src/parser/helpers.js
var helpers_exports = {};
__export(helpers_exports, {
  Maybe: () => Maybe,
  Memo: () => Memo,
  SuperParsedResult: () => SuperParsedResult,
  YTNode: () => YTNode,
  observe: () => observe
});

// dist/src/utils/Log.js
var Log_exports = {};
__export(Log_exports, {
  Level: () => Level,
  debug: () => debug,
  error: () => error,
  info: () => info,
  setLevel: () => setLevel,
  warn: () => warn,
  warnOnce: () => warnOnce
});
var YTJS_TAG = "YOUTUBEJS";
var Level = {
  NONE: 0,
  ERROR: 1,
  WARNING: 2,
  INFO: 3,
  DEBUG: 4
};
var log_map = {
  [Level.ERROR]: (...args) => console.error(...args),
  [Level.WARNING]: (...args) => console.warn(...args),
  [Level.INFO]: (...args) => console.info(...args),
  [Level.DEBUG]: (...args) => console.debug(...args)
};
var log_level = [Level.WARNING];
var one_time_warnings_issued = /* @__PURE__ */ new Set();
function doLog(level, tag, args) {
  if (!log_map[level] || !log_level.includes(level))
    return;
  const tags = [`[${YTJS_TAG}]`];
  if (tag)
    tags.push(`[${tag}]`);
  log_map[level](`${tags.join("")}:`, ...args || []);
}
__name(doLog, "doLog");
var warnOnce = /* @__PURE__ */ __name((id, ...args) => {
  if (one_time_warnings_issued.has(id))
    return;
  doLog(Level.WARNING, id, args);
  one_time_warnings_issued.add(id);
}, "warnOnce");
var warn = /* @__PURE__ */ __name((tag, ...args) => doLog(Level.WARNING, tag, args), "warn");
var error = /* @__PURE__ */ __name((tag, ...args) => doLog(Level.ERROR, tag, args), "error");
var info = /* @__PURE__ */ __name((tag, ...args) => doLog(Level.INFO, tag, args), "info");
var debug = /* @__PURE__ */ __name((tag, ...args) => doLog(Level.DEBUG, tag, args), "debug");
function setLevel(...args) {
  log_level = args;
}
__name(setLevel, "setLevel");

// dist/src/parser/helpers.js
var isObserved = Symbol("ObservedArray.isObserved");
var _YTNode = class _YTNode {
  constructor() {
    __publicField(this, "type");
    this.type = this.constructor.type;
  }
  /**
   * Check if the node is of the given type.
   * @param types - The type to check
   * @returns whether the node is of the given type
   */
  is(...types2) {
    return types2.some((type) => this.type === type.type);
  }
  /**
   * Cast to one of the given types.
   * @param types - The types to cast to
   * @returns The node cast to one of the given types
   * @throws {ParsingError} If the node is not of the given type
   */
  as(...types2) {
    if (!this.is(...types2)) {
      throw new ParsingError(`Cannot cast ${this.type} to one of ${types2.map((t) => t.type).join(", ")}`);
    }
    return this;
  }
  /**
   * Check for a key without asserting the type.
   * @param key - The key to check
   * @returns Whether the node has the key
   */
  hasKey(key) {
    return Reflect.has(this, key);
  }
  /**
   * Assert that the node has the given key and return it.
   * @param key - The key to check
   * @returns The value of the key wrapped in a Maybe
   * @throws {ParsingError} If the node does not have the key
   */
  key(key) {
    if (!this.hasKey(key)) {
      throw new ParsingError(`Missing key ${key}`);
    }
    return new Maybe(this[key]);
  }
};
__name(_YTNode, "YTNode");
__publicField(_YTNode, "type", "YTNode");
var YTNode = _YTNode;
var MAYBE_TAG = "Maybe";
var _value, _Maybe_instances, checkPrimitive_fn, assertPrimitive_fn;
var _Maybe = class _Maybe {
  constructor(value) {
    __privateAdd(this, _Maybe_instances);
    __privateAdd(this, _value);
    __privateSet(this, _value, value);
  }
  get typeof() {
    return typeof __privateGet(this, _value);
  }
  string() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "string");
  }
  isString() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "string");
  }
  number() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "number");
  }
  isNumber() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "number");
  }
  bigint() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "bigint");
  }
  isBigint() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "bigint");
  }
  boolean() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "boolean");
  }
  isBoolean() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "boolean");
  }
  symbol() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "symbol");
  }
  isSymbol() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "symbol");
  }
  undefined() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "undefined");
  }
  isUndefined() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "undefined");
  }
  null() {
    if (__privateGet(this, _value) !== null)
      throw new TypeError(`Expected null, got ${typeof __privateGet(this, _value)}`);
    return __privateGet(this, _value);
  }
  isNull() {
    return __privateGet(this, _value) === null;
  }
  object() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "object");
  }
  isObject() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "object");
  }
  // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
  function() {
    return __privateMethod(this, _Maybe_instances, assertPrimitive_fn).call(this, "function");
  }
  isFunction() {
    return __privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, "function");
  }
  /**
   * Get the value as an array.
   * @returns the value as any[].
   * @throws If the value is not an array.
   */
  array() {
    if (!Array.isArray(__privateGet(this, _value))) {
      throw new TypeError(`Expected array, got ${typeof __privateGet(this, _value)}`);
    }
    return __privateGet(this, _value);
  }
  /**
   * More typesafe variant of {@link Maybe#array}.
   * @returns a proxied array which returns all the values as {@link Maybe}.
   * @throws {TypeError} If the value is not an array
   */
  arrayOfMaybe() {
    const arrayProps = [];
    return new Proxy(this.array(), {
      get(target, prop) {
        if (Reflect.has(arrayProps, prop)) {
          return Reflect.get(target, prop);
        }
        return new _Maybe(Reflect.get(target, prop));
      }
    });
  }
  /**
   * Check whether the value is an array.
   * @returns whether the value is an array.
   */
  isArray() {
    return Array.isArray(__privateGet(this, _value));
  }
  /**
   * Get the value as a YTNode.
   * @returns the value as a YTNode.
   * @throws If the value is not a YTNode.
   */
  node() {
    if (!(__privateGet(this, _value) instanceof YTNode)) {
      throw new TypeError(`Expected YTNode, got ${__privateGet(this, _value).constructor.name}`);
    }
    return __privateGet(this, _value);
  }
  /**
   * Check if the value is a YTNode.
   * @returns Whether the value is a YTNode.
   */
  isNode() {
    return __privateGet(this, _value) instanceof YTNode;
  }
  /**
   * Get the value as a YTNode of the given type.
   * @param types - The type(s) to cast to.
   * @returns The node cast to the given type.
   * @throws If the node is not of the given type.
   */
  nodeOfType(...types2) {
    return this.node().as(...types2);
  }
  /**
   * Check if the value is a YTNode of the given type.
   * @param types - the type(s) to check.
   * @returns Whether the value is a YTNode of the given type.
   */
  isNodeOfType(...types2) {
    return this.isNode() && this.node().is(...types2);
  }
  /**
   * Get the value as an ObservedArray.
   * @returns the value of the Maybe as a ObservedArray.
   */
  observed() {
    if (!this.isObserved()) {
      throw new TypeError(`Expected ObservedArray, got ${typeof __privateGet(this, _value)}`);
    }
    return __privateGet(this, _value);
  }
  /**
   * Check if the value is an ObservedArray.
   */
  isObserved() {
    return __privateGet(this, _value)?.[isObserved];
  }
  /**
   * Get the value of the Maybe as a SuperParsedResult.
   * @returns the value as a SuperParsedResult.
   * @throws If the value is not a SuperParsedResult.
   */
  parsed() {
    if (!(__privateGet(this, _value) instanceof SuperParsedResult)) {
      throw new TypeError(`Expected SuperParsedResult, got ${typeof __privateGet(this, _value)}`);
    }
    return __privateGet(this, _value);
  }
  /**
   * Is the result a SuperParsedResult?
   */
  isParsed() {
    return __privateGet(this, _value) instanceof SuperParsedResult;
  }
  /**
   * @deprecated
   * This call is not meant to be used outside of debugging. Please use the specific type getter instead.
   */
  any() {
    warn(MAYBE_TAG, "This call is not meant to be used outside of debugging. Please use the specific type getter instead.");
    return __privateGet(this, _value);
  }
  /**
   * Get the node as an instance of the given class.
   * @param type - The type to check.
   * @returns the value as the given type.
   * @throws If the node is not of the given type.
   */
  instanceof(type) {
    if (!this.isInstanceof(type)) {
      throw new TypeError(`Expected instance of ${type.name}, got ${__privateGet(this, _value).constructor.name}`);
    }
    return __privateGet(this, _value);
  }
  /**
   * Check if the node is an instance of the given class.
   * @param type - The type to check.
   * @returns Whether the node is an instance of the given type.
   */
  isInstanceof(type) {
    return __privateGet(this, _value) instanceof type;
  }
};
_value = new WeakMap();
_Maybe_instances = new WeakSet();
checkPrimitive_fn = /* @__PURE__ */ __name(function(type) {
  return typeof __privateGet(this, _value) === type;
}, "#checkPrimitive");
assertPrimitive_fn = /* @__PURE__ */ __name(function(type) {
  if (!__privateMethod(this, _Maybe_instances, checkPrimitive_fn).call(this, type)) {
    throw new TypeError(`Expected ${type}, got ${this.typeof}`);
  }
  return __privateGet(this, _value);
}, "#assertPrimitive");
__name(_Maybe, "Maybe");
var Maybe = _Maybe;
var _result;
var _SuperParsedResult = class _SuperParsedResult {
  constructor(result) {
    __privateAdd(this, _result);
    __privateSet(this, _result, result);
  }
  get is_null() {
    return __privateGet(this, _result) === null;
  }
  get is_array() {
    return !this.is_null && Array.isArray(__privateGet(this, _result));
  }
  get is_node() {
    return !this.is_array;
  }
  array() {
    if (!this.is_array) {
      throw new TypeError("Expected an array, got a node");
    }
    return __privateGet(this, _result);
  }
  item() {
    if (!this.is_node) {
      throw new TypeError("Expected a node, got an array");
    }
    return __privateGet(this, _result);
  }
};
_result = new WeakMap();
__name(_SuperParsedResult, "SuperParsedResult");
var SuperParsedResult = _SuperParsedResult;
function observe(obj) {
  return new Proxy(obj, {
    get(target, prop) {
      if (prop == "get") {
        return (rule, del_item) => target.find((obj2, index) => {
          const match = deepCompare(rule, obj2);
          if (match && del_item) {
            target.splice(index, 1);
          }
          return match;
        });
      }
      if (prop == isObserved) {
        return true;
      }
      if (prop == "getAll") {
        return (rule, del_items) => target.filter((obj2, index) => {
          const match = deepCompare(rule, obj2);
          if (match && del_items) {
            target.splice(index, 1);
          }
          return match;
        });
      }
      if (prop == "matchCondition") {
        return (condition) => target.find((obj2) => {
          return condition(obj2);
        });
      }
      if (prop == "filterType") {
        return (...types2) => {
          return observe(target.filter((node) => {
            return !!node.is(...types2);
          }));
        };
      }
      if (prop == "firstOfType") {
        return (...types2) => {
          return target.find((node) => {
            return !!node.is(...types2);
          });
        };
      }
      if (prop == "first") {
        return () => target[0];
      }
      if (prop == "as") {
        return (...types2) => {
          return observe(target.map((node) => {
            if (node.is(...types2))
              return node;
            throw new ParsingError(`Expected node of any type ${types2.map((type) => type.type).join(", ")}, got ${node.type}`);
          }));
        };
      }
      if (prop == "remove") {
        return (index) => target.splice(index, 1);
      }
      return Reflect.get(target, prop);
    }
  });
}
__name(observe, "observe");
var _Memo = class _Memo extends Map {
  getType(...types2) {
    types2 = types2.flat();
    return observe(types2.flatMap((type) => this.get(type.type) || []));
  }
};
__name(_Memo, "Memo");
var Memo = _Memo;

// dist/src/parser/misc.js
var misc_exports = {};
__export(misc_exports, {
  AccessibilityContext: () => AccessibilityContext,
  AccessibilityData: () => AccessibilityData,
  Author: () => Author,
  ChildElement: () => ChildElement,
  CommandContext: () => CommandContext,
  EmojiRun: () => EmojiRun,
  Format: () => Format,
  RendererContext: () => RendererContext,
  SubscriptionButton: () => SubscriptionButton,
  Text: () => Text2,
  TextRun: () => TextRun,
  Thumbnail: () => Thumbnail,
  VideoDetails: () => VideoDetails
});

// dist/src/parser/classes/misc/AccessibilityContext.js
var _AccessibilityContext = class _AccessibilityContext {
  constructor(data2) {
    __publicField(this, "label");
    this.label = data2.label;
  }
};
__name(_AccessibilityContext, "AccessibilityContext");
var AccessibilityContext = _AccessibilityContext;

// dist/src/parser/classes/misc/AccessibilityData.js
var _AccessibilityData = class _AccessibilityData {
  constructor(data2) {
    __publicField(this, "accessibility_identifier");
    __publicField(this, "identifier");
    __publicField(this, "label");
    if ("accessibilityIdentifier" in data2) {
      this.accessibility_identifier = data2.accessibilityIdentifier;
    }
    if ("identifier" in data2) {
      this.identifier = {
        accessibility_id_type: data2.identifier.accessibilityIdType
      };
    }
    if ("label" in data2) {
      this.label = data2.label;
    }
  }
};
__name(_AccessibilityData, "AccessibilityData");
var AccessibilityData = _AccessibilityData;

// dist/src/utils/Constants.js
var Constants_exports = {};
__export(Constants_exports, {
  CLIENTS: () => CLIENTS,
  CLIENT_NAME_IDS: () => CLIENT_NAME_IDS,
  INNERTUBE_HEADERS_BASE: () => INNERTUBE_HEADERS_BASE,
  OAUTH: () => OAUTH,
  STREAM_HEADERS: () => STREAM_HEADERS,
  SUPPORTED_CLIENTS: () => SUPPORTED_CLIENTS,
  URLS: () => URLS
});
var URLS = {
  YT_BASE: "https://www.youtube.com",
  YT_MUSIC_BASE: "https://music.youtube.com",
  YT_SUGGESTIONS: "https://suggestqueries-clients6.youtube.com",
  YT_UPLOAD: "https://upload.youtube.com/",
  API: {
    BASE: "https://youtubei.googleapis.com",
    PRODUCTION_1: "https://www.youtube.com/youtubei/",
    PRODUCTION_2: "https://youtubei.googleapis.com/youtubei/",
    STAGING: "https://green-youtubei.sandbox.googleapis.com/youtubei/",
    RELEASE: "https://release-youtubei.sandbox.googleapis.com/youtubei/",
    TEST: "https://test-youtubei.sandbox.googleapis.com/youtubei/",
    CAMI: "http://cami-youtubei.sandbox.googleapis.com/youtubei/",
    UYTFE: "https://uytfe.sandbox.google.com/youtubei/"
  },
  GOOGLE_SEARCH_BASE: "https://www.google.com/"
};
var OAUTH = {
  REGEX: {
    TV_SCRIPT: new RegExp('<script\\s+id="base-js"\\s+src="([^"]+)"[^>]*><\\/script>'),
    CLIENT_IDENTITY: new RegExp('clientId:"(?<client_id>[^"]+)",[^"]*?:"(?<client_secret>[^"]+)"')
  }
};
var CLIENTS = {
  IOS: {
    NAME: "iOS",
    VERSION: "20.11.6",
    USER_AGENT: "com.google.ios.youtube/20.11.6 (iPhone10,4; U; CPU iOS 16_7_7 like Mac OS X)",
    DEVICE_MODEL: "iPhone10,4",
    OS_NAME: "iOS",
    OS_VERSION: "16.7.7.20H330"
  },
  WEB: {
    NAME: "WEB",
    VERSION: "2.20250222.10.00",
    API_KEY: "AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8",
    API_VERSION: "v1",
    STATIC_VISITOR_ID: "6zpwvWUNAco",
    SUGG_EXP_ID: "ytzpb5_e2,ytpo.bo.lqp.elu=1,ytpo.bo.lqp.ecsc=1,ytpo.bo.lqp.mcsc=3,ytpo.bo.lqp.mec=1,ytpo.bo.lqp.rw=0.8,ytpo.bo.lqp.fw=0.2,ytpo.bo.lqp.szp=1,ytpo.bo.lqp.mz=3,ytpo.bo.lqp.al=en_us,ytpo.bo.lqp.zrm=1,ytpo.bo.lqp.er=1,ytpo.bo.ro.erl=1,ytpo.bo.ro.mlus=3,ytpo.bo.ro.erls=3,ytpo.bo.qfo.mlus=3,ytzprp.ppp.e=1,ytzprp.ppp.st=772,ytzprp.ppp.p=5"
  },
  MWEB: {
    NAME: "MWEB",
    VERSION: "2.20250224.01.00",
    API_VERSION: "v1"
  },
  WEB_KIDS: {
    NAME: "WEB_KIDS",
    VERSION: "2.20250221.11.00"
  },
  YTMUSIC: {
    NAME: "WEB_REMIX",
    VERSION: "1.20250219.01.00"
  },
  ANDROID: {
    NAME: "ANDROID",
    VERSION: "19.35.36",
    SDK_VERSION: 33,
    USER_AGENT: "com.google.android.youtube/19.35.36(Linux; U; Android 13; en_US; SM-S908E Build/TP1A.220624.014) gzip"
  },
  YTSTUDIO_ANDROID: {
    NAME: "ANDROID_CREATOR",
    VERSION: "22.43.101"
  },
  YTMUSIC_ANDROID: {
    NAME: "ANDROID_MUSIC",
    VERSION: "5.34.51"
  },
  TV: {
    NAME: "TVHTML5",
    VERSION: "7.20250219.14.00",
    USER_AGENT: "Mozilla/5.0 (ChromiumStylePlatform) Cobalt/Version"
  },
  TV_SIMPLY: {
    NAME: "TVHTML5_SIMPLY",
    VERSION: "1.0"
  },
  TV_EMBEDDED: {
    NAME: "TVHTML5_SIMPLY_EMBEDDED_PLAYER",
    VERSION: "2.0"
  },
  WEB_EMBEDDED: {
    NAME: "WEB_EMBEDDED_PLAYER",
    VERSION: "1.20250219.01.00",
    API_KEY: "AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8",
    API_VERSION: "v1",
    STATIC_VISITOR_ID: "6zpwvWUNAco"
  },
  WEB_CREATOR: {
    NAME: "WEB_CREATOR",
    VERSION: "1.20241203.01.00",
    API_KEY: "AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8",
    API_VERSION: "v1",
    STATIC_VISITOR_ID: "6zpwvWUNAco"
  }
};
var CLIENT_NAME_IDS = {
  iOS: "5",
  WEB: "1",
  MWEB: "2",
  WEB_KIDS: "76",
  WEB_REMIX: "67",
  ANDROID: "3",
  ANDROID_CREATOR: "14",
  ANDROID_MUSIC: "21",
  TVHTML5: "7",
  TVHTML5_SIMPLY: "74",
  TVHTML5_SIMPLY_EMBEDDED_PLAYER: "85",
  WEB_EMBEDDED_PLAYER: "56",
  WEB_CREATOR: "62"
};
var STREAM_HEADERS = {
  "accept": "*/*",
  "origin": "https://www.youtube.com",
  "referer": "https://www.youtube.com",
  "DNT": "?1"
};
var INNERTUBE_HEADERS_BASE = {
  "accept": "*/*",
  "accept-encoding": "gzip, deflate",
  "content-type": "application/json"
};
var SUPPORTED_CLIENTS = ["IOS", "WEB", "MWEB", "YTKIDS", "YTMUSIC", "ANDROID", "YTSTUDIO_ANDROID", "YTMUSIC_ANDROID", "TV", "TV_SIMPLY", "TV_EMBEDDED", "WEB_EMBEDDED", "WEB_CREATOR"];

// dist/src/parser/parser.js
var parser_exports = {};
__export(parser_exports, {
  addRuntimeParser: () => addRuntimeParser,
  applyCommentsMutations: () => applyCommentsMutations,
  applyMutations: () => applyMutations,
  getDynamicParsers: () => getDynamicParsers,
  getParserByName: () => getParserByName,
  hasParser: () => hasParser,
  parse: () => parse4,
  parseActions: () => parseActions,
  parseArray: () => parseArray,
  parseC: () => parseC,
  parseCommand: () => parseCommand,
  parseCommands: () => parseCommands,
  parseFormats: () => parseFormats,
  parseItem: () => parseItem,
  parseLC: () => parseLC,
  parseRR: () => parseRR,
  parseResponse: () => parseResponse,
  sanitizeClassName: () => sanitizeClassName,
  setParserErrorHandler: () => setParserErrorHandler,
  shouldIgnore: () => shouldIgnore
});

// dist/src/parser/nodes.js
var nodes_exports2 = {};
__export(nodes_exports2, {
  AboutChannel: () => AboutChannel,
  AboutChannelView: () => AboutChannelView,
  AccountChannel: () => AccountChannel,
  AccountItem: () => AccountItem,
  AccountItemSection: () => AccountItemSection,
  AccountItemSectionHeader: () => AccountItemSectionHeader,
  AccountSectionList: () => AccountSectionList,
  ActiveAccountHeader: () => ActiveAccountHeader,
  AddBannerToLiveChatCommand: () => AddBannerToLiveChatCommand,
  AddChatItemAction: () => AddChatItemAction,
  AddLiveChatTickerItemAction: () => AddLiveChatTickerItemAction,
  AddToPlaylist: () => AddToPlaylist,
  AddToPlaylistCommand: () => AddToPlaylistCommand,
  AddToPlaylistEndpoint: () => AddToPlaylistEndpoint,
  AddToPlaylistServiceEndpoint: () => AddToPlaylistServiceEndpoint,
  Alert: () => Alert,
  AlertWithButton: () => AlertWithButton,
  AnchoredSection: () => AnchoredSection,
  AnimatedThumbnailOverlayView: () => AnimatedThumbnailOverlayView,
  AppendContinuationItemsAction: () => AppendContinuationItemsAction,
  AttributionView: () => AttributionView,
  AudioOnlyPlayability: () => AudioOnlyPlayability,
  AuthorCommentBadge: () => AuthorCommentBadge,
  AutomixPreviewVideo: () => AutomixPreviewVideo,
  AvatarStackView: () => AvatarStackView,
  AvatarView: () => AvatarView,
  BackgroundPromo: () => BackgroundPromo,
  BackstageImage: () => BackstageImage,
  BackstagePost: () => BackstagePost,
  BackstagePostThread: () => BackstagePostThread,
  BadgeView: () => BadgeView,
  BrowseEndpoint: () => BrowseEndpoint,
  BrowseFeedActions: () => BrowseFeedActions,
  BrowserMediaSession: () => BrowserMediaSession,
  BumperUserEduContentView: () => BumperUserEduContentView,
  Button: () => Button,
  ButtonCardView: () => ButtonCardView,
  ButtonView: () => ButtonView,
  C4TabbedHeader: () => C4TabbedHeader,
  CallToActionButton: () => CallToActionButton,
  Card: () => Card,
  CardCollection: () => CardCollection,
  CarouselHeader: () => CarouselHeader,
  CarouselItem: () => CarouselItem,
  CarouselItemView: () => CarouselItemView,
  CarouselLockup: () => CarouselLockup,
  CarouselTitleView: () => CarouselTitleView,
  ChangeEngagementPanelVisibilityAction: () => ChangeEngagementPanelVisibilityAction,
  Channel: () => Channel,
  ChannelAboutFullMetadata: () => ChannelAboutFullMetadata,
  ChannelAgeGate: () => ChannelAgeGate,
  ChannelExternalLinkView: () => ChannelExternalLinkView,
  ChannelFeaturedContent: () => ChannelFeaturedContent,
  ChannelHeaderLinks: () => ChannelHeaderLinks,
  ChannelHeaderLinksView: () => ChannelHeaderLinksView,
  ChannelMetadata: () => ChannelMetadata,
  ChannelMobileHeader: () => ChannelMobileHeader,
  ChannelOptions: () => ChannelOptions,
  ChannelOwnerEmptyState: () => ChannelOwnerEmptyState,
  ChannelSubMenu: () => ChannelSubMenu,
  ChannelSwitcherHeader: () => ChannelSwitcherHeader,
  ChannelSwitcherPage: () => ChannelSwitcherPage,
  ChannelTagline: () => ChannelTagline,
  ChannelThumbnailWithLink: () => ChannelThumbnailWithLink,
  ChannelVideoPlayer: () => ChannelVideoPlayer,
  Chapter: () => Chapter,
  ChildVideo: () => ChildVideo,
  ChipBarView: () => ChipBarView,
  ChipCloud: () => ChipCloud,
  ChipCloudChip: () => ChipCloudChip,
  ChipView: () => ChipView,
  ClientSideToggleMenuItem: () => ClientSideToggleMenuItem,
  ClipAdState: () => ClipAdState,
  ClipCreation: () => ClipCreation,
  ClipCreationScrubber: () => ClipCreationScrubber,
  ClipCreationTextInput: () => ClipCreationTextInput,
  ClipSection: () => ClipSection,
  CollaboratorInfoCardContent: () => CollaboratorInfoCardContent,
  CollageHeroImage: () => CollageHeroImage,
  CollectionThumbnailView: () => CollectionThumbnailView,
  CommandExecutorCommand: () => CommandExecutorCommand,
  CommentActionButtons: () => CommentActionButtons,
  CommentDialog: () => CommentDialog,
  CommentReplies: () => CommentReplies,
  CommentReplyDialog: () => CommentReplyDialog,
  CommentSimplebox: () => CommentSimplebox,
  CommentThread: () => CommentThread,
  CommentView: () => CommentView,
  CommentsEntryPointHeader: () => CommentsEntryPointHeader,
  CommentsEntryPointTeaser: () => CommentsEntryPointTeaser,
  CommentsHeader: () => CommentsHeader,
  CommentsSimplebox: () => CommentsSimplebox,
  CompactChannel: () => CompactChannel,
  CompactLink: () => CompactLink,
  CompactMix: () => CompactMix,
  CompactMovie: () => CompactMovie,
  CompactPlaylist: () => CompactPlaylist_default,
  CompactStation: () => CompactStation,
  CompactVideo: () => CompactVideo,
  CompositeVideoPrimaryInfo: () => CompositeVideoPrimaryInfo,
  ConfirmDialog: () => ConfirmDialog,
  ContentMetadataView: () => ContentMetadataView,
  ContentPreviewImageView: () => ContentPreviewImageView,
  ContinuationCommand: () => ContinuationCommand,
  ContinuationItem: () => ContinuationItem,
  ConversationBar: () => ConversationBar,
  CopyLink: () => CopyLink,
  CreateCommentEndpoint: () => CreateCommentEndpoint,
  CreatePlaylistDialog: () => CreatePlaylistDialog,
  CreatePlaylistDialogFormView: () => CreatePlaylistDialogFormView,
  CreatePlaylistServiceEndpoint: () => CreatePlaylistServiceEndpoint,
  CreatorHeart: () => CreatorHeart,
  CreatorHeartView: () => CreatorHeartView,
  DecoratedAvatarView: () => DecoratedAvatarView,
  DecoratedPlayerBar: () => DecoratedPlayerBar,
  DefaultPromoPanel: () => DefaultPromoPanel,
  DeletePlaylistEndpoint: () => DeletePlaylistEndpoint,
  DescriptionPreviewView: () => DescriptionPreviewView,
  DialogHeaderView: () => DialogHeaderView,
  DialogView: () => DialogView,
  DidYouMean: () => DidYouMean,
  DimChatItemAction: () => DimChatItemAction,
  DislikeButtonView: () => DislikeButtonView,
  DismissableDialog: () => DismissableDialog,
  DismissableDialogContentSection: () => DismissableDialogContentSection,
  DownloadButton: () => DownloadButton,
  Dropdown: () => Dropdown,
  DropdownItem: () => DropdownItem,
  DropdownView: () => DropdownView,
  DynamicTextView: () => DynamicTextView,
  Element: () => Element,
  EmergencyOnebox: () => EmergencyOnebox,
  EmojiPicker: () => EmojiPicker,
  EmojiPickerCategory: () => EmojiPickerCategory,
  EmojiPickerCategoryButton: () => EmojiPickerCategoryButton,
  EmojiPickerUpsellCategory: () => EmojiPickerUpsellCategory,
  EndScreenPlaylist: () => EndScreenPlaylist,
  EndScreenVideo: () => EndScreenVideo,
  Endscreen: () => Endscreen,
  EndscreenElement: () => EndscreenElement,
  EngagementPanelSectionList: () => EngagementPanelSectionList,
  EngagementPanelTitleHeader: () => EngagementPanelTitleHeader,
  EomSettingsDisclaimer: () => EomSettingsDisclaimer,
  ExpandableMetadata: () => ExpandableMetadata,
  ExpandableTab: () => ExpandableTab,
  ExpandableVideoDescriptionBody: () => ExpandableVideoDescriptionBody,
  ExpandedShelfContents: () => ExpandedShelfContents,
  Factoid: () => Factoid,
  FancyDismissibleDialog: () => FancyDismissibleDialog,
  FeedFilterChipBar: () => FeedFilterChipBar,
  FeedNudge: () => FeedNudge,
  FeedTabbedHeader: () => FeedTabbedHeader,
  FeedbackEndpoint: () => FeedbackEndpoint,
  FlexibleActionsView: () => FlexibleActionsView,
  FormFooterView: () => FormFooterView,
  GameCard: () => GameCard,
  GameDetails: () => GameDetails,
  GetAccountsListInnertubeEndpoint: () => GetAccountsListInnertubeEndpoint,
  GetKidsBlocklistPickerCommand: () => GetKidsBlocklistPickerCommand,
  GetMultiPageMenuAction: () => GetMultiPageMenuAction,
  Grid: () => Grid,
  GridChannel: () => GridChannel,
  GridHeader: () => GridHeader,
  GridMix: () => GridMix,
  GridMovie: () => GridMovie,
  GridPlaylist: () => GridPlaylist,
  GridShelfView: () => GridShelfView,
  GridShow: () => GridShow,
  GridVideo: () => GridVideo,
  GuideCollapsibleEntry: () => GuideCollapsibleEntry,
  GuideCollapsibleSectionEntry: () => GuideCollapsibleSectionEntry,
  GuideDownloadsEntry: () => GuideDownloadsEntry,
  GuideEntry: () => GuideEntry,
  GuideSection: () => GuideSection,
  GuideSubscriptionsSection: () => GuideSubscriptionsSection,
  HashtagHeader: () => HashtagHeader,
  HashtagTile: () => HashtagTile,
  HeatMarker: () => HeatMarker,
  Heatmap: () => Heatmap,
  HeroPlaylistThumbnail: () => HeroPlaylistThumbnail,
  HideEngagementPanelEndpoint: () => HideEngagementPanelEndpoint,
  HighlightsCarousel: () => HighlightsCarousel,
  HistorySuggestion: () => HistorySuggestion,
  HorizontalCardList: () => HorizontalCardList,
  HorizontalList: () => HorizontalList,
  HorizontalMovieList: () => HorizontalMovieList,
  HowThisWasMadeSectionView: () => HowThisWasMadeSectionView,
  HypePointsFactoid: () => HypePointsFactoid,
  IconLink: () => IconLink,
  ImageBannerView: () => ImageBannerView,
  IncludingResultsFor: () => IncludingResultsFor,
  InfoPanelContainer: () => InfoPanelContainer,
  InfoPanelContent: () => InfoPanelContent,
  InfoRow: () => InfoRow,
  InteractiveTabbedHeader: () => InteractiveTabbedHeader,
  ItemSection: () => ItemSection,
  ItemSectionHeader: () => ItemSectionHeader,
  ItemSectionTab: () => ItemSectionTab,
  ItemSectionTabbedHeader: () => ItemSectionTabbedHeader,
  KidsBlocklistPicker: () => KidsBlocklistPicker,
  KidsBlocklistPickerItem: () => KidsBlocklistPickerItem,
  KidsCategoriesHeader: () => KidsCategoriesHeader,
  KidsCategoryTab: () => KidsCategoryTab,
  KidsHomeScreen: () => KidsHomeScreen,
  LikeButton: () => LikeButton,
  LikeButtonView: () => LikeButtonView,
  LikeEndpoint: () => LikeEndpoint,
  ListItemView: () => ListItemView,
  ListView: () => ListView,
  LiveChat: () => LiveChat,
  LiveChatActionPanel: () => LiveChatActionPanel,
  LiveChatAuthorBadge: () => LiveChatAuthorBadge,
  LiveChatAutoModMessage: () => LiveChatAutoModMessage,
  LiveChatBanner: () => LiveChatBanner,
  LiveChatBannerChatSummary: () => LiveChatBannerChatSummary,
  LiveChatBannerHeader: () => LiveChatBannerHeader,
  LiveChatBannerPoll: () => LiveChatBannerPoll,
  LiveChatBannerRedirect: () => LiveChatBannerRedirect,
  LiveChatDialog: () => LiveChatDialog,
  LiveChatHeader: () => LiveChatHeader,
  LiveChatItemBumperView: () => LiveChatItemBumperView,
  LiveChatItemContextMenuEndpoint: () => LiveChatItemContextMenuEndpoint,
  LiveChatItemList: () => LiveChatItemList,
  LiveChatMembershipItem: () => LiveChatMembershipItem,
  LiveChatMessageInput: () => LiveChatMessageInput,
  LiveChatModeChangeMessage: () => LiveChatModeChangeMessage,
  LiveChatPaidMessage: () => LiveChatPaidMessage,
  LiveChatPaidSticker: () => LiveChatPaidSticker,
  LiveChatParticipant: () => LiveChatParticipant,
  LiveChatParticipantsList: () => LiveChatParticipantsList,
  LiveChatPlaceholderItem: () => LiveChatPlaceholderItem,
  LiveChatProductItem: () => LiveChatProductItem,
  LiveChatRestrictedParticipation: () => LiveChatRestrictedParticipation,
  LiveChatSponsorshipsGiftPurchaseAnnouncement: () => LiveChatSponsorshipsGiftPurchaseAnnouncement,
  LiveChatSponsorshipsGiftRedemptionAnnouncement: () => LiveChatSponsorshipsGiftRedemptionAnnouncement,
  LiveChatSponsorshipsHeader: () => LiveChatSponsorshipsHeader,
  LiveChatTextMessage: () => LiveChatTextMessage,
  LiveChatTickerPaidMessageItem: () => LiveChatTickerPaidMessageItem,
  LiveChatTickerPaidStickerItem: () => LiveChatTickerPaidStickerItem,
  LiveChatTickerSponsorItem: () => LiveChatTickerSponsorItem,
  LiveChatViewerEngagementMessage: () => LiveChatViewerEngagementMessage,
  LockupMetadataView: () => LockupMetadataView,
  LockupView: () => LockupView,
  MacroMarkersInfoItem: () => MacroMarkersInfoItem,
  MacroMarkersList: () => MacroMarkersList,
  MacroMarkersListEntity: () => MacroMarkersListEntity,
  MacroMarkersListItem: () => MacroMarkersListItem,
  MarkChatItemAsDeletedAction: () => MarkChatItemAsDeletedAction,
  MarkChatItemsByAuthorAsDeletedAction: () => MarkChatItemsByAuthorAsDeletedAction,
  Menu: () => Menu,
  MenuFlexibleItem: () => MenuFlexibleItem,
  MenuNavigationItem: () => MenuNavigationItem,
  MenuPopup: () => MenuPopup,
  MenuServiceItem: () => MenuServiceItem,
  MenuServiceItemDownload: () => MenuServiceItemDownload,
  MenuTitle: () => MenuTitle,
  MerchandiseItem: () => MerchandiseItem,
  MerchandiseShelf: () => MerchandiseShelf,
  Message: () => Message,
  MetadataBadge: () => MetadataBadge,
  MetadataRow: () => MetadataRow,
  MetadataRowContainer: () => MetadataRowContainer,
  MetadataRowHeader: () => MetadataRowHeader,
  MetadataScreen: () => MetadataScreen,
  MicroformatData: () => MicroformatData,
  Mix: () => Mix,
  MobileTopbar: () => MobileTopbar,
  ModalWithTitleAndButton: () => ModalWithTitleAndButton,
  ModifyChannelNotificationPreferenceEndpoint: () => ModifyChannelNotificationPreferenceEndpoint,
  Movie: () => Movie,
  MovingThumbnail: () => MovingThumbnail,
  MultiMarkersPlayerBar: () => MultiMarkersPlayerBar,
  MultiPageMenu: () => MultiPageMenu,
  MultiPageMenuNotificationSection: () => MultiPageMenuNotificationSection,
  MultiPageMenuSection: () => MultiPageMenuSection,
  MusicCardShelf: () => MusicCardShelf,
  MusicCardShelfHeaderBasic: () => MusicCardShelfHeaderBasic,
  MusicCarouselShelf: () => MusicCarouselShelf,
  MusicCarouselShelfBasicHeader: () => MusicCarouselShelfBasicHeader,
  MusicDescriptionShelf: () => MusicDescriptionShelf,
  MusicDetailHeader: () => MusicDetailHeader,
  MusicDownloadStateBadge: () => MusicDownloadStateBadge,
  MusicEditablePlaylistDetailHeader: () => MusicEditablePlaylistDetailHeader,
  MusicElementHeader: () => MusicElementHeader,
  MusicHeader: () => MusicHeader,
  MusicImmersiveHeader: () => MusicImmersiveHeader,
  MusicInlineBadge: () => MusicInlineBadge,
  MusicItemThumbnailOverlay: () => MusicItemThumbnailOverlay,
  MusicLargeCardItemCarousel: () => MusicLargeCardItemCarousel,
  MusicMenuItemDivider: () => MusicMenuItemDivider,
  MusicMultiRowListItem: () => MusicMultiRowListItem,
  MusicMultiSelectMenu: () => MusicMultiSelectMenu,
  MusicMultiSelectMenuItem: () => MusicMultiSelectMenuItem,
  MusicNavigationButton: () => MusicNavigationButton,
  MusicPlayButton: () => MusicPlayButton,
  MusicPlaylistEditHeader: () => MusicPlaylistEditHeader,
  MusicPlaylistShelf: () => MusicPlaylistShelf,
  MusicQueue: () => MusicQueue,
  MusicResponsiveHeader: () => MusicResponsiveHeader,
  MusicResponsiveListItem: () => MusicResponsiveListItem,
  MusicResponsiveListItemFixedColumn: () => MusicResponsiveListItemFixedColumn,
  MusicResponsiveListItemFlexColumn: () => MusicResponsiveListItemFlexColumn,
  MusicShelf: () => MusicShelf,
  MusicSideAlignedItem: () => MusicSideAlignedItem,
  MusicSortFilterButton: () => MusicSortFilterButton,
  MusicTastebuilderShelf: () => MusicTasteBuilderShelf,
  MusicTastebuilderShelfThumbnail: () => MusicTastebuilderShelfThumbnail,
  MusicThumbnail: () => MusicThumbnail,
  MusicTwoRowItem: () => MusicTwoRowItem,
  MusicVisualHeader: () => MusicVisualHeader,
  NavigationEndpoint: () => NavigationEndpoint,
  Notification: () => Notification,
  NotificationAction: () => NotificationAction,
  OpenOnePickAddVideoModalCommand: () => OpenOnePickAddVideoModalCommand,
  OpenPopupAction: () => OpenPopupAction,
  PageHeader: () => PageHeader,
  PageHeaderView: () => PageHeaderView,
  PageIntroduction: () => PageIntroduction,
  PanelFooterView: () => PanelFooterView,
  PdgCommentChip: () => PdgCommentChip,
  PdgReplyButtonView: () => PdgReplyButtonView,
  PerformCommentActionEndpoint: () => PerformCommentActionEndpoint,
  PivotBar: () => PivotBar,
  PivotBarItem: () => PivotBarItem,
  PivotButton: () => PivotButton,
  PlayerAnnotationsExpanded: () => PlayerAnnotationsExpanded,
  PlayerCaptionsTracklist: () => PlayerCaptionsTracklist,
  PlayerControlsOverlay: () => PlayerControlsOverlay,
  PlayerErrorMessage: () => PlayerErrorMessage,
  PlayerLegacyDesktopYpcOffer: () => PlayerLegacyDesktopYpcOffer,
  PlayerLegacyDesktopYpcTrailer: () => PlayerLegacyDesktopYpcTrailer,
  PlayerLiveStoryboardSpec: () => PlayerLiveStoryboardSpec,
  PlayerMicroformat: () => PlayerMicroformat,
  PlayerOverflow: () => PlayerOverflow,
  PlayerOverlay: () => PlayerOverlay,
  PlayerOverlayAutoplay: () => PlayerOverlayAutoplay,
  PlayerOverlayVideoDetails: () => PlayerOverlayVideoDetails,
  PlayerStoryboardSpec: () => PlayerStoryboardSpec,
  Playlist: () => Playlist,
  PlaylistAddToOption: () => PlaylistAddToOption,
  PlaylistCustomThumbnail: () => PlaylistCustomThumbnail,
  PlaylistEditEndpoint: () => PlaylistEditEndpoint,
  PlaylistHeader: () => PlaylistHeader,
  PlaylistInfoCardContent: () => PlaylistInfoCardContent,
  PlaylistMetadata: () => PlaylistMetadata,
  PlaylistPanel: () => PlaylistPanel,
  PlaylistPanelVideo: () => PlaylistPanelVideo,
  PlaylistPanelVideoWrapper: () => PlaylistPanelVideoWrapper,
  PlaylistSidebar: () => PlaylistSidebar,
  PlaylistSidebarPrimaryInfo: () => PlaylistSidebarPrimaryInfo,
  PlaylistSidebarSecondaryInfo: () => PlaylistSidebarSecondaryInfo,
  PlaylistThumbnailOverlay: () => PlaylistThumbnailOverlay,
  PlaylistVideo: () => PlaylistVideo,
  PlaylistVideoList: () => PlaylistVideoList,
  PlaylistVideoThumbnail: () => PlaylistVideoThumbnail,
  Poll: () => Poll,
  PollHeader: () => PollHeader,
  Post: () => Post,
  PostMultiImage: () => PostMultiImage,
  PrefetchWatchCommand: () => PrefetchWatchCommand,
  PremiereTrailerBadge: () => PremiereTrailerBadge,
  ProductList: () => ProductList,
  ProductListHeader: () => ProductListHeader,
  ProductListItem: () => ProductListItem,
  ProfileColumn: () => ProfileColumn,
  ProfileColumnStats: () => ProfileColumnStats,
  ProfileColumnStatsEntry: () => ProfileColumnStatsEntry,
  ProfileColumnUserInfo: () => ProfileColumnUserInfo,
  Quiz: () => Quiz,
  RecognitionShelf: () => RecognitionShelf,
  ReelItem: () => ReelItem,
  ReelPlayerHeader: () => ReelPlayerHeader,
  ReelPlayerOverlay: () => ReelPlayerOverlay,
  ReelShelf: () => ReelShelf,
  ReelWatchEndpoint: () => ReelWatchEndpoint,
  RelatedChipCloud: () => RelatedChipCloud,
  RemoveBannerForLiveChatCommand: () => RemoveBannerForLiveChatCommand,
  RemoveChatItemAction: () => RemoveChatItemAction,
  RemoveChatItemByAuthorAction: () => RemoveChatItemByAuthorAction,
  ReplaceChatItemAction: () => ReplaceChatItemAction,
  ReplaceLiveChatAction: () => ReplaceLiveChatAction,
  ReplayChatItemAction: () => ReplayChatItemAction,
  RichGrid: () => RichGrid,
  RichItem: () => RichItem,
  RichListHeader: () => RichListHeader,
  RichMetadata: () => RichMetadata,
  RichMetadataRow: () => RichMetadataRow,
  RichSection: () => RichSection,
  RichShelf: () => RichShelf,
  RunAttestationCommand: () => RunAttestationCommand,
  SearchBox: () => SearchBox,
  SearchEndpoint: () => SearchEndpoint,
  SearchFilter: () => SearchFilter2,
  SearchFilterGroup: () => SearchFilterGroup,
  SearchFilterOptionsDialog: () => SearchFilterOptionsDialog,
  SearchHeader: () => SearchHeader,
  SearchRefinementCard: () => SearchRefinementCard,
  SearchSubMenu: () => SearchSubMenu,
  SearchSuggestion: () => SearchSuggestion,
  SearchSuggestionsSection: () => SearchSuggestionsSection,
  SecondarySearchContainer: () => SecondarySearchContainer,
  SectionHeaderView: () => SectionHeaderView,
  SectionList: () => SectionList,
  SegmentedLikeDislikeButton: () => SegmentedLikeDislikeButton,
  SegmentedLikeDislikeButtonView: () => SegmentedLikeDislikeButtonView,
  SendFeedbackAction: () => SendFeedbackAction,
  SettingBoolean: () => SettingBoolean,
  SettingsCheckbox: () => SettingsCheckbox,
  SettingsOptions: () => SettingsOptions,
  SettingsSidebar: () => SettingsSidebar,
  SettingsSwitch: () => SettingsSwitch,
  ShareEndpoint: () => ShareEndpoint,
  ShareEntityEndpoint: () => ShareEntityEndpoint,
  ShareEntityServiceEndpoint: () => ShareEntityServiceEndpoint,
  SharePanelHeader: () => SharePanelHeader,
  SharePanelTitleV15: () => SharePanelTitleV15,
  ShareTarget: () => ShareTarget,
  SharedPost: () => SharedPost,
  Shelf: () => Shelf,
  ShortsLockupView: () => ShortsLockupView,
  ShowCustomThumbnail: () => ShowCustomThumbnail,
  ShowDialogCommand: () => ShowDialogCommand,
  ShowEngagementPanelEndpoint: () => ShowEngagementPanelEndpoint,
  ShowLiveChatActionPanelAction: () => ShowLiveChatActionPanelAction,
  ShowLiveChatDialogAction: () => ShowLiveChatDialogAction,
  ShowLiveChatTooltipCommand: () => ShowLiveChatTooltipCommand,
  ShowingResultsFor: () => ShowingResultsFor,
  SignalAction: () => SignalAction,
  SignalServiceEndpoint: () => SignalServiceEndpoint,
  SimpleCardContent: () => SimpleCardContent,
  SimpleCardTeaser: () => SimpleCardTeaser,
  SimpleMenuHeader: () => SimpleMenuHeader,
  SimpleTextSection: () => SimpleTextSection,
  SingleActionEmergencySupport: () => SingleActionEmergencySupport,
  SingleColumnBrowseResults: () => SingleColumnBrowseResults,
  SingleColumnMusicWatchNextResults: () => SingleColumnMusicWatchNextResults,
  SingleHeroImage: () => SingleHeroImage,
  SlimOwner: () => SlimOwner,
  SlimVideoMetadata: () => SlimVideoMetadata,
  SortFilterHeader: () => SortFilterHeader,
  SortFilterSubMenu: () => SortFilterSubMenu,
  SponsorCommentBadge: () => SponsorCommentBadge,
  StartAt: () => StartAt,
  StructuredDescriptionContent: () => StructuredDescriptionContent,
  StructuredDescriptionPlaylistLockup: () => StructuredDescriptionPlaylistLockup,
  SubFeedOption: () => SubFeedOption,
  SubFeedSelector: () => SubFeedSelector,
  SubscribeButton: () => SubscribeButton,
  SubscribeButtonView: () => SubscribeButtonView,
  SubscribeEndpoint: () => SubscribeEndpoint,
  SubscriptionNotificationToggleButton: () => SubscriptionNotificationToggleButton,
  Tab: () => Tab,
  Tabbed: () => Tabbed,
  TabbedSearchResults: () => TabbedSearchResults,
  TextCarouselItemView: () => TextCarouselItemView,
  TextFieldView: () => TextFieldView,
  TextHeader: () => TextHeader,
  ThirdPartyShareTargetSection: () => ThirdPartyShareTargetSection,
  ThumbnailBadgeView: () => ThumbnailBadgeView,
  ThumbnailBottomOverlayView: () => ThumbnailBottomOverlayView,
  ThumbnailHoverOverlayToggleActionsView: () => ThumbnailHoverOverlayToggleActionsView,
  ThumbnailHoverOverlayView: () => ThumbnailHoverOverlayView,
  ThumbnailLandscapePortrait: () => ThumbnailLandscapePortrait,
  ThumbnailOverlayBadgeView: () => ThumbnailOverlayBadgeView,
  ThumbnailOverlayBottomPanel: () => ThumbnailOverlayBottomPanel,
  ThumbnailOverlayEndorsement: () => ThumbnailOverlayEndorsement,
  ThumbnailOverlayHoverText: () => ThumbnailOverlayHoverText,
  ThumbnailOverlayInlineUnplayable: () => ThumbnailOverlayInlineUnplayable,
  ThumbnailOverlayLoadingPreview: () => ThumbnailOverlayLoadingPreview,
  ThumbnailOverlayNowPlaying: () => ThumbnailOverlayNowPlaying,
  ThumbnailOverlayPinking: () => ThumbnailOverlayPinking,
  ThumbnailOverlayPlaybackStatus: () => ThumbnailOverlayPlaybackStatus,
  ThumbnailOverlayProgressBarView: () => ThumbnailOverlayProgressBarView,
  ThumbnailOverlayResumePlayback: () => ThumbnailOverlayResumePlayback,
  ThumbnailOverlaySidePanel: () => ThumbnailOverlaySidePanel,
  ThumbnailOverlayTimeStatus: () => ThumbnailOverlayTimeStatus,
  ThumbnailOverlayToggleButton: () => ThumbnailOverlayToggleButton,
  ThumbnailView: () => ThumbnailView,
  TimedMarkerDecoration: () => TimedMarkerDecoration,
  TitleAndButtonListHeader: () => TitleAndButtonListHeader,
  ToggleButton: () => ToggleButton,
  ToggleButtonView: () => ToggleButtonView,
  ToggleFormField: () => ToggleFormField,
  ToggleMenuServiceItem: () => ToggleMenuServiceItem,
  Tooltip: () => Tooltip,
  TopbarMenuButton: () => TopbarMenuButton,
  TopicChannelDetails: () => TopicChannelDetails,
  Transcript: () => Transcript,
  TranscriptFooter: () => TranscriptFooter,
  TranscriptSearchBox: () => TranscriptSearchBox,
  TranscriptSearchPanel: () => TranscriptSearchPanel,
  TranscriptSectionHeader: () => TranscriptSectionHeader,
  TranscriptSegment: () => TranscriptSegment,
  TranscriptSegmentList: () => TranscriptSegmentList,
  TwoColumnBrowseResults: () => TwoColumnBrowseResults,
  TwoColumnSearchResults: () => TwoColumnSearchResults,
  TwoColumnWatchNextResults: () => TwoColumnWatchNextResults,
  UnifiedSharePanel: () => UnifiedSharePanel,
  UniversalWatchCard: () => UniversalWatchCard,
  UnsubscribeEndpoint: () => UnsubscribeEndpoint,
  UpdateChannelSwitcherPageAction: () => UpdateChannelSwitcherPageAction,
  UpdateDateTextAction: () => UpdateDateTextAction,
  UpdateDescriptionAction: () => UpdateDescriptionAction,
  UpdateEngagementPanelAction: () => UpdateEngagementPanelAction,
  UpdateEngagementPanelContentCommand: () => UpdateEngagementPanelContentCommand,
  UpdateLiveChatPollAction: () => UpdateLiveChatPollAction,
  UpdateSubscribeButtonAction: () => UpdateSubscribeButtonAction,
  UpdateTitleAction: () => UpdateTitleAction,
  UpdateToggleButtonTextAction: () => UpdateToggleButtonTextAction,
  UpdateViewershipAction: () => UpdateViewershipAction,
  UploadTimeFactoid: () => UploadTimeFactoid,
  UpsellDialog: () => UpsellDialog,
  VerticalList: () => VerticalList,
  VerticalWatchCardList: () => VerticalWatchCardList,
  Video: () => Video,
  VideoAttributeView: () => VideoAttributeView,
  VideoAttributesSectionView: () => VideoAttributesSectionView,
  VideoCard: () => VideoCard,
  VideoDescriptionCourseSection: () => VideoDescriptionCourseSection,
  VideoDescriptionHeader: () => VideoDescriptionHeader,
  VideoDescriptionInfocardsSection: () => VideoDescriptionInfocardsSection,
  VideoDescriptionMusicSection: () => VideoDescriptionMusicSection,
  VideoDescriptionTranscriptSection: () => VideoDescriptionTranscriptSection,
  VideoInfoCardContent: () => VideoInfoCardContent,
  VideoMetadataCarouselView: () => VideoMetadataCarouselView,
  VideoOwner: () => VideoOwner,
  VideoPrimaryInfo: () => VideoPrimaryInfo,
  VideoSecondaryInfo: () => VideoSecondaryInfo,
  VideoViewCount: () => VideoViewCount,
  ViewCountFactoid: () => ViewCountFactoid,
  VoiceReplyContainerView: () => VoiceReplyContainerView,
  WatchCardCompactVideo: () => WatchCardCompactVideo,
  WatchCardHeroVideo: () => WatchCardHeroVideo,
  WatchCardRichHeader: () => WatchCardRichHeader,
  WatchCardSectionSequence: () => WatchCardSectionSequence,
  WatchEndpoint: () => WatchEndpoint,
  WatchNextEndScreen: () => WatchNextEndScreen,
  WatchNextEndpoint: () => WatchNextEndpoint,
  WatchNextTabbedResults: () => WatchNextTabbedResults,
  YpcTrailer: () => YpcTrailer
});

// dist/src/utils/Cache.js
var _cache;
var _UniversalCache = class _UniversalCache {
  constructor(persistent, persistent_directory) {
    __privateAdd(this, _cache);
    __privateSet(this, _cache, new Platform.shim.Cache(persistent, persistent_directory));
  }
  get cache_dir() {
    return __privateGet(this, _cache).cache_dir;
  }
  get(key) {
    return __privateGet(this, _cache).get(key);
  }
  set(key, value) {
    return __privateGet(this, _cache).set(key, value);
  }
  remove(key) {
    return __privateGet(this, _cache).remove(key);
  }
};
_cache = new WeakMap();
__name(_UniversalCache, "UniversalCache");
var UniversalCache = _UniversalCache;

// dist/src/utils/EventEmitterLike.js
var _legacy_listeners;
var _EventEmitterLike = class _EventEmitterLike extends EventTarget {
  constructor() {
    super();
    __privateAdd(this, _legacy_listeners, /* @__PURE__ */ new Map());
  }
  emit(type, ...args) {
    const event = new Platform.shim.CustomEvent(type, { detail: args });
    this.dispatchEvent(event);
  }
  on(type, listener) {
    const wrapper = /* @__PURE__ */ __name((ev) => {
      if (ev instanceof Platform.shim.CustomEvent) {
        listener(...ev.detail);
      } else {
        listener(ev);
      }
    }, "wrapper");
    __privateGet(this, _legacy_listeners).set(listener, wrapper);
    this.addEventListener(type, wrapper);
  }
  once(type, listener) {
    const wrapper = /* @__PURE__ */ __name((ev) => {
      if (ev instanceof Platform.shim.CustomEvent) {
        listener(...ev.detail);
      } else {
        listener(ev);
      }
      this.off(type, listener);
    }, "wrapper");
    __privateGet(this, _legacy_listeners).set(listener, wrapper);
    this.addEventListener(type, wrapper);
  }
  off(type, listener) {
    const wrapper = __privateGet(this, _legacy_listeners).get(listener);
    if (wrapper) {
      this.removeEventListener(type, wrapper);
      __privateGet(this, _legacy_listeners).delete(listener);
    }
  }
};
_legacy_listeners = new WeakMap();
__name(_EventEmitterLike, "EventEmitterLike");
var EventEmitterLike = _EventEmitterLike;

// dist/src/utils/FormatUtils.js
var FormatUtils_exports = {};
__export(FormatUtils_exports, {
  chooseFormat: () => chooseFormat,
  download: () => download,
  toDash: () => toDash
});

// dist/src/utils/DashUtils.js
var XML_CHARACTER_MAP = {
  "&": "&amp;",
  '"': "&quot;",
  "'": "&apos;",
  "<": "&lt;",
  ">": "&gt;"
};
function escapeXMLString(str) {
  return str.replace(/([&"<>'])/g, (_, item) => {
    return XML_CHARACTER_MAP[item];
  });
}
__name(escapeXMLString, "escapeXMLString");
function normalizeTag(tag) {
  return tag.charAt(0).toUpperCase() + tag.slice(1);
}
__name(normalizeTag, "normalizeTag");
function createElement(tagNameOrFunction, props, ...children) {
  const normalizedChildren = children.flat();
  if (typeof tagNameOrFunction === "function") {
    return tagNameOrFunction({ ...props, children: normalizedChildren });
  }
  return {
    type: normalizeTag(tagNameOrFunction),
    props: {
      ...props,
      children: normalizedChildren
    }
  };
}
__name(createElement, "createElement");
async function renderElementToString(element) {
  if (typeof element === "string")
    return escapeXMLString(element);
  let dom = `<${element.type}`;
  if (element.props) {
    for (const key of Object.keys(element.props)) {
      if (key !== "children" && element.props[key] !== void 0) {
        dom += ` ${key}="${escapeXMLString(`${element.props[key]}`)}"`;
      }
    }
  }
  if (element.props.children) {
    const children = await Promise.all((await Promise.all(element.props.children.flat())).flat().filter((child) => !!child).map((child) => renderElementToString(child)));
    if (children.length > 0) {
      dom += `>${children.join("")}</${element.type}>`;
      return dom;
    }
  }
  return `${dom}/>`;
}
__name(renderElementToString, "renderElementToString");
async function renderToString(root) {
  const dom = await renderElementToString(await root);
  return `<?xml version="1.0" encoding="utf-8"?>${dom}`;
}
__name(renderToString, "renderToString");
function Fragment(props) {
  return props.children;
}
__name(Fragment, "Fragment");

// dist/src/parser/classes/PlayerStoryboardSpec.js
var _PlayerStoryboardSpec = class _PlayerStoryboardSpec extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "boards");
    const parts = data2.spec.split("|");
    const url = new URL(parts.shift());
    this.boards = parts.map((part, i) => {
      const [thumbnail_width, thumbnail_height, thumbnail_count, columns, rows, interval, name, sigh] = part.split("#");
      url.searchParams.set("sigh", sigh);
      const storyboard_count = Math.ceil(parseInt(thumbnail_count, 10) / (parseInt(columns, 10) * parseInt(rows, 10)));
      return {
        type: "vod",
        template_url: url.toString().replace("$L", i).replace("$N", name),
        thumbnail_width: parseInt(thumbnail_width, 10),
        thumbnail_height: parseInt(thumbnail_height, 10),
        thumbnail_count: parseInt(thumbnail_count, 10),
        interval: parseInt(interval, 10),
        columns: parseInt(columns, 10),
        rows: parseInt(rows, 10),
        storyboard_count
      };
    });
  }
};
__name(_PlayerStoryboardSpec, "PlayerStoryboardSpec");
__publicField(_PlayerStoryboardSpec, "type", "PlayerStoryboardSpec");
var PlayerStoryboardSpec = _PlayerStoryboardSpec;

// dist/package.json
var package_default = {
  name: "youtubei.js",
  version: "15.1.1",
  description: "A JavaScript client for YouTube's private API, known as InnerTube.",
  type: "module",
  types: "./dist/src/platform/lib.d.ts",
  typesVersions: {
    "*": {
      agnostic: [
        "./dist/src/platform/lib.d.ts"
      ],
      web: [
        "./dist/src/platform/lib.d.ts"
      ],
      "react-native": [
        "./dist/src/platform/lib.d.ts"
      ],
      "web.bundle": [
        "./dist/src/platform/lib.d.ts"
      ],
      "web.bundle.min": [
        "./dist/src/platform/lib.d.ts"
      ],
      "cf-worker": [
        "./dist/src/platform/lib.d.ts"
      ]
    }
  },
  exports: {
    ".": {
      deno: "./dist/src/platform/deno.js",
      node: {
        import: "./dist/src/platform/node.js",
        default: "./dist/src/platform/node.js"
      },
      types: "./dist/src/platform/lib.d.ts",
      browser: "./dist/src/platform/web.js",
      "react-native": "./dist/src/platform/react-native.js",
      default: "./dist/src/platform/web.js"
    },
    "./package.json": "./package.json",
    "./agnostic": {
      types: "./dist/src/platform/lib.d.ts",
      default: "./dist/src/platform/lib.js"
    },
    "./web": {
      types: "./dist/src/platform/lib.d.ts",
      default: "./dist/src/platform/web.js"
    },
    "./react-native": {
      types: "./dist/src/platform/lib.d.ts",
      default: "./dist/src/platform/react-native.js"
    },
    "./web.bundle": {
      types: "./dist/src/platform/lib.d.ts",
      default: "./bundle/browser.js"
    },
    "./cf-worker": {
      types: "./dist/src/platform/lib.d.ts",
      default: "./dist/src/platform/cf-worker.js"
    }
  },
  author: "LuanRT <luan.lrt4@gmail.com> (https://github.com/LuanRT)",
  funding: [
    "https://github.com/sponsors/LuanRT"
  ],
  contributors: [
    "Wykerd (https://github.com/wykerd/)",
    "MasterOfBob777 (https://github.com/MasterOfBob777)",
    "patrickkfkan (https://github.com/patrickkfkan)",
    "akkadaska (https://github.com/akkadaska)",
    "Absidue (https://github.com/absidue)"
  ],
  scripts: {
    test: "vitest run --reporter verbose",
    lint: "eslint ./src",
    "lint:fix": "eslint --fix ./src",
    "clean:source-maps": "rimraf ./bundle/browser.js.map ./bundle/cf-worker.js.map ./bundle/react-native.js.map",
    "clean:build-output": "rimraf ./dist ./bundle/browser.js ./bundle/cf-worker.js ./bundle/react-native.js ./deno",
    build: "npm run clean:build-output && npm run clean:source-maps && npm run build:parser-map && npm run build:esm && npm run bundle:browser && npm run bundle:cf-worker && npm run bundle:react-native",
    "build:esm": "tspc",
    "build:deno": `cpy ./src ./deno && cpy ./protos ./deno && esbuild ./src/utils/DashManifest.tsx --keep-names --format=esm --platform=neutral --target=es2020 --outfile=./deno/src/utils/DashManifest.js && cpy ./package.json ./deno && replace ".js';" ".ts';" ./deno -r && replace '.js";' '.ts";' ./deno -r && replace "'./DashManifest.ts';" "'./DashManifest.js';" ./deno -r && replace "'jintr';" "'jsr:@luanrt/jintr';" ./deno -r && replace "@bufbuild/protobuf/wire" "https://esm.sh/@bufbuild/protobuf@2.0.0/wire" ./deno -r`,
    "build:proto": "rimraf ./protos/generated && node ./dev-scripts/generate-proto.mjs",
    "build:parser-map": "node ./dev-scripts/gen-parser-map.mjs",
    "bundle:browser": 'esbuild ./dist/src/platform/web.js --banner:js="/* eslint-disable */" --bundle --sourcemap --target=chrome70 --keep-names --format=esm --define:global=globalThis --conditions=module --outfile=./bundle/browser.js --platform=browser',
    "bundle:react-native": "esbuild ./dist/src/platform/react-native.js --bundle --sourcemap --target=es2020 --keep-names --format=esm --platform=neutral --define:global=globalThis --conditions=module --outfile=./bundle/react-native.js",
    "bundle:cf-worker": 'esbuild ./dist/src/platform/cf-worker.js --banner:js="/* eslint-disable */" --bundle --sourcemap --target=es2020 --keep-names --format=esm --define:global=globalThis --conditions=module --outfile=./bundle/cf-worker.js --platform=node',
    "build:docs": "typedoc",
    prepare: "npm run build",
    watch: "tspc --watch"
  },
  repository: {
    type: "git",
    url: "git+https://github.com/LuanRT/YouTube.js.git"
  },
  files: [
    "dist/",
    "bundle/",
    "package.json",
    "README.md",
    "LICENSE"
  ],
  license: "MIT",
  dependencies: {
    "@bufbuild/protobuf": "^2.0.0",
    jintr: "^3.3.1",
    undici: "^6.21.3"
  },
  overrides: {
    typescript: "^5.0.0"
  },
  devDependencies: {
    "@eslint/js": "^9.9.0",
    "@types/estree": "^1.0.6",
    "@types/glob": "^8.1.0",
    "@types/node": "^24.0.14",
    "cpy-cli": "^4.2.0",
    esbuild: "^0.25.6",
    eslint: "^9.9.0",
    glob: "^8.0.3",
    globals: "^15.9.0",
    replace: "^1.2.2",
    rimraf: "^6.0.1",
    "ts-patch": "^3.0.2",
    "ts-proto": "^2.2.0",
    typedoc: "^0.26.7",
    "typedoc-plugin-markdown": "^4.2.7",
    typescript: "^5.0.0",
    "typescript-eslint": "^8.2.0",
    vitest: "^3.2.4"
  },
  bugs: {
    url: "https://github.com/LuanRT/YouTube.js/issues"
  },
  homepage: "https://github.com/LuanRT/YouTube.js#readme",
  keywords: [
    "api",
    "youtube",
    "innertube",
    "livechat",
    "youtube-music",
    "ytdl",
    "youtube-studio",
    "downloader",
    "ytmusic"
  ]
};

// dist/src/utils/StreamingInfo.js
var TAG_ = "StreamingInfo";
function getFormatGroupings(formats, is_post_live_dvr) {
  const group_info = /* @__PURE__ */ new Map();
  const has_multiple_audio_tracks = formats.some((fmt) => !!fmt.audio_track);
  for (const format of formats) {
    if ((!format.index_range || !format.init_range) && !format.is_type_otf && !is_post_live_dvr) {
      continue;
    }
    const mime_type = format.mime_type.split(";")[0];
    const just_codec = getStringBetweenStrings(format.mime_type, 'codecs="', '"')?.split(".")[0];
    const color_info = format.color_info ? Object.values(format.color_info).join("-") : "";
    const audio_track_id = format.audio_track?.id || "";
    const drc = format.is_drc ? "drc" : "";
    const group_id = `${mime_type}-${just_codec}-${color_info}-${audio_track_id}-${drc}`;
    if (!group_info.has(group_id)) {
      group_info.set(group_id, []);
    }
    group_info.get(group_id)?.push(format);
  }
  return {
    groups: Array.from(group_info.values()),
    has_multiple_audio_tracks
  };
}
__name(getFormatGroupings, "getFormatGroupings");
function hoistCodecsIfPossible(formats, hoisted) {
  if (formats.length > 1 && new Set(formats.map((format) => getStringBetweenStrings(format.mime_type, 'codecs="', '"'))).size === 1) {
    hoisted.push("codecs");
    return getStringBetweenStrings(formats[0].mime_type, 'codecs="', '"');
  }
}
__name(hoistCodecsIfPossible, "hoistCodecsIfPossible");
function hoistNumberAttributeIfPossible(formats, property, hoisted) {
  if (formats.length > 1 && new Set(formats.map((format) => format.fps)).size === 1) {
    hoisted.push(property);
    return Number(formats[0][property]);
  }
}
__name(hoistNumberAttributeIfPossible, "hoistNumberAttributeIfPossible");
function hoistAudioChannelsIfPossible(formats, hoisted) {
  if (formats.length > 1 && new Set(formats.map((format) => format.audio_channels || 2)).size === 1) {
    hoisted.push("AudioChannelConfiguration");
    return formats[0].audio_channels;
  }
}
__name(hoistAudioChannelsIfPossible, "hoistAudioChannelsIfPossible");
async function getOTFSegmentTemplate(url, actions) {
  const response = await actions.session.http.fetch_function(`${url}&rn=0&sq=0`, {
    method: "GET",
    headers: STREAM_HEADERS,
    redirect: "follow"
  });
  const resolved_url = response.url.replace("&rn=0", "").replace("&sq=0", "");
  const response_text = await response.text();
  const segment_duration_strings = getStringBetweenStrings(response_text, "Segment-Durations-Ms:", "\r\n")?.split(",");
  if (!segment_duration_strings) {
    throw new InnertubeError("Failed to extract the segment durations from this OTF stream", { url });
  }
  const segment_durations = [];
  for (const segment_duration_string of segment_duration_strings) {
    const trimmed_segment_duration = segment_duration_string.trim();
    if (trimmed_segment_duration.length === 0) {
      continue;
    }
    let repeat_count;
    const repeat_count_string = getStringBetweenStrings(trimmed_segment_duration, "(r=", ")");
    if (repeat_count_string) {
      repeat_count = parseInt(repeat_count_string);
    }
    segment_durations.push({
      duration: parseInt(trimmed_segment_duration),
      repeat_count
    });
  }
  return {
    init_url: `${resolved_url}&sq=0`,
    media_url: `${resolved_url}&sq=$Number$`,
    timeline: segment_durations
  };
}
__name(getOTFSegmentTemplate, "getOTFSegmentTemplate");
async function getPostLiveDvrInfo(transformed_url, actions) {
  const response = await actions.session.http.fetch_function(`${transformed_url}&rn=0&sq=0`, {
    method: "HEAD",
    headers: STREAM_HEADERS,
    redirect: "follow"
  });
  const duration_ms = parseInt(response.headers.get("X-Head-Time-Millis") || "");
  const segment_count = parseInt(response.headers.get("X-Head-Seqnum") || "");
  if (isNaN(duration_ms) || isNaN(segment_count)) {
    throw new InnertubeError("Failed to extract the duration or segment count for this Post Live DVR video");
  }
  return {
    duration: duration_ms / 1e3,
    segment_count
  };
}
__name(getPostLiveDvrInfo, "getPostLiveDvrInfo");
async function getPostLiveDvrDuration(shared_post_live_dvr_info, format, url_transformer, actions, player, cpn) {
  if (!shared_post_live_dvr_info.item) {
    const url = new URL(format.decipher(player));
    url.searchParams.set("cpn", cpn || "");
    const transformed_url = url_transformer(url).toString();
    shared_post_live_dvr_info.item = await getPostLiveDvrInfo(transformed_url, actions);
  }
  return shared_post_live_dvr_info.item.duration;
}
__name(getPostLiveDvrDuration, "getPostLiveDvrDuration");
function getSegmentInfo(format, url_transformer, actions, player, cpn, shared_post_live_dvr_info, is_sabr) {
  let transformed_url = "";
  if (is_sabr) {
    const formatKey = `${format.itag || ""}:${format.xtags || ""}`;
    transformed_url = `sabr://${format.has_video ? "video" : "audio"}?key=${formatKey}`;
  } else {
    const url = new URL(format.decipher(player));
    url.searchParams.set("cpn", cpn || "");
    transformed_url = url_transformer(url).toString();
  }
  if (format.is_type_otf) {
    if (!actions)
      throw new InnertubeError("Unable to get segment durations for this OTF stream without an Actions instance", { format });
    const info3 = {
      is_oft: true,
      is_post_live_dvr: false,
      getSegmentTemplate() {
        return getOTFSegmentTemplate(transformed_url, actions);
      }
    };
    return info3;
  }
  if (shared_post_live_dvr_info) {
    if (!actions) {
      throw new InnertubeError("Unable to get segment count for this Post Live DVR video without an Actions instance", { format });
    }
    const target_duration_dec = format.target_duration_dec;
    if (typeof target_duration_dec !== "number") {
      throw new InnertubeError("Format is missing target_duration_dec", { format });
    }
    const info3 = {
      is_oft: false,
      is_post_live_dvr: true,
      async getSegmentTemplate() {
        if (!shared_post_live_dvr_info.item) {
          shared_post_live_dvr_info.item = await getPostLiveDvrInfo(transformed_url, actions);
        }
        return {
          media_url: `${transformed_url}&sq=$Number$`,
          timeline: [
            {
              duration: target_duration_dec * 1e3,
              repeat_count: shared_post_live_dvr_info.item.segment_count
            }
          ]
        };
      }
    };
    return info3;
  }
  if (!format.index_range || !format.init_range)
    throw new InnertubeError("Index and init ranges not available", { format });
  const info2 = {
    is_oft: false,
    is_post_live_dvr: false,
    base_url: transformed_url,
    index_range: format.index_range,
    init_range: format.init_range
  };
  return info2;
}
__name(getSegmentInfo, "getSegmentInfo");
function getAudioRepresentation(format, hoisted, url_transformer, actions, player, cpn, shared_post_live_dvr_info, is_sabr) {
  const uid_parts = [format.itag.toString()];
  if (format.audio_track) {
    uid_parts.push(format.audio_track.id);
  }
  if (format.is_drc) {
    uid_parts.push("drc");
  }
  const rep = {
    uid: uid_parts.join("-"),
    bitrate: format.bitrate,
    codecs: !hoisted.includes("codecs") ? getStringBetweenStrings(format.mime_type, 'codecs="', '"') : void 0,
    audio_sample_rate: !hoisted.includes("audio_sample_rate") ? format.audio_sample_rate : void 0,
    channels: !hoisted.includes("AudioChannelConfiguration") ? format.audio_channels || 2 : void 0,
    segment_info: getSegmentInfo(format, url_transformer, actions, player, cpn, shared_post_live_dvr_info, is_sabr)
  };
  return rep;
}
__name(getAudioRepresentation, "getAudioRepresentation");
function getTrackRoles(format, has_drc_streams) {
  if (!format.audio_track && !has_drc_streams) {
    return;
  }
  const roles = [
    format.is_original ? "main" : "alternate"
  ];
  if (format.is_dubbed || format.is_auto_dubbed)
    roles.push("dub");
  if (format.is_descriptive)
    roles.push("description");
  if (format.is_drc)
    roles.push("enhanced-audio-intelligibility");
  return roles;
}
__name(getTrackRoles, "getTrackRoles");
function getAudioSet(formats, url_transformer, actions, player, cpn, shared_post_live_dvr_info, drc_labels, is_sabr) {
  const first_format = formats[0];
  const { audio_track } = first_format;
  const hoisted = [];
  const has_drc_streams = !!drc_labels;
  let track_name;
  if (audio_track) {
    if (has_drc_streams && first_format.is_drc) {
      track_name = drc_labels.label_drc_multiple(audio_track.display_name);
    } else {
      track_name = audio_track.display_name;
    }
  } else if (has_drc_streams) {
    track_name = first_format.is_drc ? drc_labels.label_drc : drc_labels.label_original;
  }
  const set = {
    mime_type: first_format.mime_type.split(";")[0],
    language: first_format.language ?? void 0,
    codecs: hoistCodecsIfPossible(formats, hoisted),
    audio_sample_rate: hoistNumberAttributeIfPossible(formats, "audio_sample_rate", hoisted),
    track_name,
    track_roles: getTrackRoles(first_format, has_drc_streams),
    channels: hoistAudioChannelsIfPossible(formats, hoisted),
    drm_families: first_format.drm_families,
    drm_track_type: first_format.drm_track_type,
    representations: formats.map((format) => getAudioRepresentation(format, hoisted, url_transformer, actions, player, cpn, shared_post_live_dvr_info, is_sabr))
  };
  return set;
}
__name(getAudioSet, "getAudioSet");
var COLOR_PRIMARIES = {
  BT709: "1",
  BT2020: "9"
};
var COLOR_TRANSFER_CHARACTERISTICS = {
  BT709: "1",
  BT2020_10: "14",
  SMPTEST2084: "16",
  ARIB_STD_B67: "18"
};
var COLOR_MATRIX_COEFFICIENTS = {
  BT709: "1",
  BT2020_NCL: "14"
};
function getColorInfo(format) {
  const color_info = format.color_info;
  let primaries;
  let transfer_characteristics;
  let matrix_coefficients;
  if (color_info) {
    if (color_info.primaries) {
      primaries = COLOR_PRIMARIES[color_info.primaries];
    }
    if (color_info.transfer_characteristics) {
      transfer_characteristics = COLOR_TRANSFER_CHARACTERISTICS[color_info.transfer_characteristics];
    }
    if (color_info.matrix_coefficients) {
      matrix_coefficients = COLOR_MATRIX_COEFFICIENTS[color_info.matrix_coefficients];
      if (!matrix_coefficients) {
        const url = new URL(format.url);
        const anonymisedFormat = JSON.parse(JSON.stringify(format));
        anonymisedFormat.url = "REDACTED";
        anonymisedFormat.signature_cipher = "REDACTED";
        anonymisedFormat.cipher = "REDACTED";
        warn(TAG_, `Unknown matrix coefficients "${color_info.matrix_coefficients}". The DASH manifest is still usable without this.
Please report it at ${package_default.bugs.url} so we can add support for it.
InnerTube client: ${url.searchParams.get("c")}
format:`, anonymisedFormat);
      }
    }
  } else if (getStringBetweenStrings(format.mime_type, 'codecs="', '"')?.startsWith("avc1")) {
    transfer_characteristics = COLOR_TRANSFER_CHARACTERISTICS.BT709;
  }
  const info2 = {
    primaries,
    transfer_characteristics,
    matrix_coefficients
  };
  return info2;
}
__name(getColorInfo, "getColorInfo");
function getVideoRepresentation(format, url_transformer, hoisted, player, actions, cpn, shared_post_live_dvr_info, is_sabr) {
  const rep = {
    uid: format.itag.toString(),
    bitrate: format.bitrate,
    width: format.width,
    height: format.height,
    codecs: !hoisted.includes("codecs") ? getStringBetweenStrings(format.mime_type, 'codecs="', '"') : void 0,
    fps: !hoisted.includes("fps") ? format.fps : void 0,
    segment_info: getSegmentInfo(format, url_transformer, actions, player, cpn, shared_post_live_dvr_info, is_sabr)
  };
  return rep;
}
__name(getVideoRepresentation, "getVideoRepresentation");
function getVideoSet(formats, url_transformer, player, actions, cpn, shared_post_live_dvr_info, is_sabr) {
  const first_format = formats[0];
  const color_info = getColorInfo(first_format);
  const hoisted = [];
  const set = {
    mime_type: first_format.mime_type.split(";")[0],
    color_info,
    codecs: hoistCodecsIfPossible(formats, hoisted),
    fps: hoistNumberAttributeIfPossible(formats, "fps", hoisted),
    drm_families: first_format.drm_families,
    drm_track_type: first_format.drm_track_type,
    representations: formats.map((format) => getVideoRepresentation(format, url_transformer, hoisted, player, actions, cpn, shared_post_live_dvr_info, is_sabr))
  };
  return set;
}
__name(getVideoSet, "getVideoSet");
function getStoryboardInfo(storyboards) {
  const mime_info = /* @__PURE__ */ new Map();
  const boards = storyboards.is(PlayerStoryboardSpec) ? storyboards.boards : [storyboards.board];
  for (const storyboard of boards) {
    const extension = new URL(storyboard.template_url).pathname.split(".").pop();
    const mime_type = `image/${extension === "jpg" ? "jpeg" : extension}`;
    if (!mime_info.has(mime_type)) {
      mime_info.set(mime_type, []);
    }
    mime_info.get(mime_type)?.push(storyboard);
  }
  return mime_info;
}
__name(getStoryboardInfo, "getStoryboardInfo");
async function getStoryboardMimeType(actions, board, transform_url, probable_mime_type, shared_response) {
  const url = board.template_url;
  const req_url = transform_url(new URL(url.replace("$M", "0")));
  const res_promise = shared_response.response ? shared_response.response : actions.session.http.fetch_function(req_url, {
    method: "HEAD",
    headers: STREAM_HEADERS
  });
  shared_response.response = res_promise;
  const res = await res_promise;
  return res.headers.get("Content-Type") || probable_mime_type;
}
__name(getStoryboardMimeType, "getStoryboardMimeType");
async function getStoryboardBitrate(actions, board, shared_response) {
  const url = board.template_url;
  const response_promises = [];
  const request_limit = Math.min(board.type === "vod" ? board.storyboard_count : 5, 10);
  for (let i = 0; i < request_limit; i++) {
    const req_url = new URL(url.replace("$M", i.toString()));
    const response_promise = i === 0 && shared_response.response ? shared_response.response : actions.session.http.fetch_function(req_url, {
      method: "HEAD",
      headers: STREAM_HEADERS
    });
    if (i === 0)
      shared_response.response = response_promise;
    response_promises.push(response_promise);
  }
  const responses = await Promise.all(response_promises);
  const content_lengths = [];
  for (const response of responses) {
    content_lengths.push(parseInt(response.headers.get("Content-Length") || "0"));
  }
  return Math.ceil(Math.max(...content_lengths) / (board.rows * board.columns) * 8);
}
__name(getStoryboardBitrate, "getStoryboardBitrate");
function getImageRepresentation(duration, actions, board, transform_url, shared_response) {
  const url = board.template_url;
  const template_url = new URL(url.replace("$M", "$Number$"));
  let template_duration;
  if (board.type === "vod") {
    template_duration = duration / board.storyboard_count;
  } else {
    template_duration = duration * board.columns * board.rows;
  }
  const rep = {
    uid: `thumbnails_${board.thumbnail_width}x${board.thumbnail_height}`,
    getBitrate() {
      return getStoryboardBitrate(actions, board, shared_response);
    },
    sheet_width: board.thumbnail_width * board.columns,
    sheet_height: board.thumbnail_height * board.rows,
    thumbnail_height: board.thumbnail_height,
    thumbnail_width: board.thumbnail_width,
    rows: board.rows,
    columns: board.columns,
    template_duration: Math.round(template_duration),
    template_url: transform_url(template_url).toString(),
    getURL(n) {
      return template_url.toString().replace("$Number$", n.toString());
    }
  };
  return rep;
}
__name(getImageRepresentation, "getImageRepresentation");
function getImageSets(duration, actions, storyboards, transform_url) {
  const mime_info = getStoryboardInfo(storyboards);
  const shared_response = {};
  return Array.from(mime_info.entries()).map(([type, boards]) => ({
    probable_mime_type: type,
    getMimeType() {
      return getStoryboardMimeType(actions, boards[0], transform_url, type, shared_response);
    },
    representations: boards.map((board) => getImageRepresentation(duration, actions, board, transform_url, shared_response))
  }));
}
__name(getImageSets, "getImageSets");
function getTextSets(caption_tracks, format, transform_url) {
  const mime_type = format === "vtt" ? "text/vtt" : "application/ttml+xml";
  return caption_tracks.map((caption_track) => {
    const url = new URL(caption_track.base_url);
    url.searchParams.set("fmt", format);
    const track_roles = ["caption"];
    if (url.searchParams.has("tlang")) {
      track_roles.push("dub");
    }
    return {
      mime_type,
      language: caption_track.language_code,
      track_name: caption_track.name.toString(),
      track_roles,
      representation: {
        uid: `text-${caption_track.vss_id}`,
        base_url: transform_url(url).toString()
      }
    };
  });
}
__name(getTextSets, "getTextSets");
function getStreamingInfo(streaming_data, is_post_live_dvr = false, url_transformer = (url) => url, format_filter, cpn, player, actions, storyboards, caption_tracks, options) {
  if (!streaming_data)
    throw new InnertubeError("Streaming data not available");
  const formats = format_filter ? streaming_data.adaptive_formats.filter((fmt) => !format_filter(fmt)) : streaming_data.adaptive_formats;
  let getDuration;
  let shared_post_live_dvr_info;
  if (is_post_live_dvr) {
    shared_post_live_dvr_info = {};
    if (!actions) {
      throw new InnertubeError("Unable to get duration or segment count for this Post Live DVR video without an Actions instance");
    }
    getDuration = /* @__PURE__ */ __name(() => {
      if (!shared_post_live_dvr_info) {
        return Promise.resolve(0);
      }
      return getPostLiveDvrDuration(shared_post_live_dvr_info, formats[0], url_transformer, actions, player, cpn);
    }, "getDuration");
  } else {
    const duration = formats[0].approx_duration_ms / 1e3;
    getDuration = /* @__PURE__ */ __name(() => Promise.resolve(duration), "getDuration");
  }
  const { groups, has_multiple_audio_tracks } = getFormatGroupings(formats, is_post_live_dvr);
  const { video_groups, audio_groups } = groups.reduce((acc, formats2) => {
    if (formats2[0].has_audio) {
      if (has_multiple_audio_tracks && !formats2[0].audio_track)
        return acc;
      acc.audio_groups.push(formats2);
      return acc;
    }
    acc.video_groups.push(formats2);
    return acc;
  }, {
    video_groups: [],
    audio_groups: []
  });
  let drc_labels;
  if (audio_groups.flat().some((format) => format.is_drc)) {
    drc_labels = {
      label_original: options?.label_original || "Original",
      label_drc: options?.label_drc || "Stable Volume",
      label_drc_multiple: options?.label_drc_multiple || ((display_name) => `${display_name} (Stable Volume)`)
    };
  }
  const audio_sets = audio_groups.map((formats2) => getAudioSet(formats2, url_transformer, actions, player, cpn, shared_post_live_dvr_info, drc_labels, options?.is_sabr));
  const video_sets = video_groups.map((formats2) => getVideoSet(formats2, url_transformer, player, actions, cpn, shared_post_live_dvr_info, options?.is_sabr));
  let image_sets = [];
  if (storyboards && actions) {
    let duration;
    if (storyboards.is(PlayerStoryboardSpec)) {
      duration = formats[0].approx_duration_ms / 1e3;
    } else {
      const target_duration_dec = formats[0].target_duration_dec;
      if (target_duration_dec === void 0)
        throw new InnertubeError("Format is missing target_duration_dec", { format: formats[0] });
      duration = target_duration_dec;
    }
    image_sets = getImageSets(duration, actions, storyboards, url_transformer);
  }
  let text_sets = [];
  if (caption_tracks && options?.captions_format) {
    if (options.captions_format !== "vtt" && options.captions_format !== "ttml") {
      throw new InnertubeError("Invalid captions format", options.captions_format);
    }
    text_sets = getTextSets(caption_tracks, options.captions_format, url_transformer);
  }
  const info2 = {
    getDuration,
    audio_sets,
    video_sets,
    image_sets,
    text_sets
  };
  return info2;
}
__name(getStreamingInfo, "getStreamingInfo");

// dist/src/utils/DashManifest.js
async function OTFPostLiveDvrSegmentInfo({ info: info2 }) {
  if (!info2.is_oft && !info2.is_post_live_dvr)
    return null;
  const template = await info2.getSegmentTemplate();
  return createElement(
    "segmentTemplate",
    { startNumber: template.init_url ? "1" : "0", timescale: "1000", initialization: template.init_url, media: template.media_url },
    createElement("segmentTimeline", null, template.timeline.map((segment_duration) => createElement("s", { d: segment_duration.duration, r: segment_duration.repeat_count })))
  );
}
__name(OTFPostLiveDvrSegmentInfo, "OTFPostLiveDvrSegmentInfo");
function SegmentInfo({ info: info2 }) {
  if (info2.is_oft || info2.is_post_live_dvr) {
    return createElement(OTFPostLiveDvrSegmentInfo, { info: info2 });
  }
  return createElement(
    Fragment,
    null,
    createElement("baseURL", null, info2.base_url),
    createElement(
      "segmentBase",
      { indexRange: `${info2.index_range.start}-${info2.index_range.end}` },
      createElement("initialization", { range: `${info2.init_range.start}-${info2.init_range.end}` })
    )
  );
}
__name(SegmentInfo, "SegmentInfo");
function getDrmSystemId(drm_family) {
  switch (drm_family) {
    case "WIDEVINE":
      return "edef8ba9-79d6-4ace-a3c8-27dcd51d21ed";
    case "PLAYREADY":
      return "9a04f079-9840-4286-ab92-e65be0885f95";
    default:
      return null;
  }
}
__name(getDrmSystemId, "getDrmSystemId");
async function DashManifest({ streamingData, isPostLiveDvr, transformURL, rejectFormat, cpn, player, actions, storyboards, captionTracks, options }) {
  const { getDuration, audio_sets, video_sets, image_sets, text_sets } = getStreamingInfo(streamingData, isPostLiveDvr, transformURL, rejectFormat, cpn, player, actions, storyboards, captionTracks, options);
  return createElement(
    "mPD",
    { xmlns: "urn:mpeg:dash:schema:mpd:2011", minBufferTime: "PT1.500S", profiles: "urn:mpeg:dash:profile:isoff-main:2011", type: "static", mediaPresentationDuration: `PT${await getDuration()}S`, "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation": "urn:mpeg:dash:schema:mpd:2011 http://standards.iso.org/ittf/PubliclyAvailableStandards/MPEG-DASH_schema_files/DASH-MPD.xsd" },
    createElement(
      "period",
      null,
      audio_sets.map((set, index) => createElement(
        "adaptationSet",
        { id: index, mimeType: set.mime_type, startWithSAP: "1", subsegmentAlignment: "true", lang: set.language, codecs: set.codecs, audioSamplingRate: set.audio_sample_rate, contentType: "audio" },
        set.drm_families && set.drm_families.map((drm_family) => createElement("contentProtection", { schemeIdUri: `urn:uuid:${getDrmSystemId(drm_family)}` })),
        set.track_roles && set.track_roles.map((role) => createElement("role", { schemeIdUri: "urn:mpeg:dash:role:2011", value: role })),
        set.track_name && createElement("label", { id: index }, set.track_name),
        set.channels && createElement("audioChannelConfiguration", { schemeIdUri: "urn:mpeg:dash:23003:3:audio_channel_configuration:2011", value: set.channels }),
        set.representations.map((rep) => createElement(
          "representation",
          { id: rep.uid, bandwidth: rep.bitrate, codecs: rep.codecs, audioSamplingRate: rep.audio_sample_rate },
          rep.channels && createElement("audioChannelConfiguration", { schemeIdUri: "urn:mpeg:dash:23003:3:audio_channel_configuration:2011", value: rep.channels }),
          createElement(SegmentInfo, { info: rep.segment_info })
        ))
      )),
      video_sets.map((set, index) => createElement(
        "adaptationSet",
        { id: index + audio_sets.length, mimeType: set.mime_type, startWithSAP: "1", subsegmentAlignment: "true", codecs: set.codecs, maxPlayoutRate: "1", frameRate: set.fps, contentType: "video" },
        set.drm_families && set.drm_families.map((drm_family) => createElement("contentProtection", { schemeIdUri: `urn:uuid:${getDrmSystemId(drm_family)}` })),
        set.color_info.primaries && createElement("supplementalProperty", { schemeIdUri: "urn:mpeg:mpegB:cicp:ColourPrimaries", value: set.color_info.primaries }),
        set.color_info.transfer_characteristics && createElement("supplementalProperty", { schemeIdUri: "urn:mpeg:mpegB:cicp:TransferCharacteristics", value: set.color_info.transfer_characteristics }),
        set.color_info.matrix_coefficients && createElement("supplementalProperty", { schemeIdUri: "urn:mpeg:mpegB:cicp:MatrixCoefficients", value: set.color_info.matrix_coefficients }),
        set.representations.map((rep) => createElement(
          "representation",
          { id: rep.uid, bandwidth: rep.bitrate, width: rep.width, height: rep.height, codecs: rep.codecs, frameRate: rep.fps },
          createElement(SegmentInfo, { info: rep.segment_info })
        ))
      )),
      image_sets.map(async (set, index) => {
        return createElement("adaptationSet", { id: index + audio_sets.length + video_sets.length, mimeType: await set.getMimeType(), contentType: "image" }, set.representations.map(async (rep) => createElement(
          "representation",
          { id: `thumbnails_${rep.thumbnail_width}x${rep.thumbnail_height}`, bandwidth: await rep.getBitrate(), width: rep.sheet_width, height: rep.sheet_height },
          createElement("essentialProperty", { schemeIdUri: "http://dashif.org/thumbnail_tile", value: `${rep.columns}x${rep.rows}` }),
          createElement("segmentTemplate", { media: rep.template_url, duration: rep.template_duration, startNumber: "0" })
        )));
      }),
      text_sets.map((set, index) => {
        return createElement(
          "adaptationSet",
          { id: index + audio_sets.length + video_sets.length + image_sets.length, mimeType: set.mime_type, lang: set.language, contentType: "text" },
          set.track_roles.map((role) => createElement("role", { schemeIdUri: "urn:mpeg:dash:role:2011", value: role })),
          createElement("label", { id: index + audio_sets.length }, set.track_name),
          createElement(
            "representation",
            { id: set.representation.uid, bandwidth: "0" },
            createElement("baseURL", null, set.representation.base_url)
          )
        );
      })
    )
  );
}
__name(DashManifest, "DashManifest");
function toDash(streaming_data, is_post_live_dvr = false, url_transformer = (url) => url, format_filter, cpn, player, actions, storyboards, caption_tracks, options) {
  if (!streaming_data)
    throw new InnertubeError("Streaming data not available");
  return renderToString(createElement(DashManifest, { streamingData: streaming_data, isPostLiveDvr: is_post_live_dvr, transformURL: url_transformer, options, rejectFormat: format_filter, cpn, player, actions, storyboards, captionTracks: caption_tracks }));
}
__name(toDash, "toDash");

// dist/src/utils/FormatUtils.js
async function download(options, actions, playability_status, streaming_data, player, cpn) {
  if (playability_status?.status === "UNPLAYABLE")
    throw new InnertubeError("Video is unplayable", { error_type: "UNPLAYABLE" });
  if (playability_status?.status === "LOGIN_REQUIRED")
    throw new InnertubeError("Video is login required", { error_type: "LOGIN_REQUIRED" });
  if (!streaming_data)
    throw new InnertubeError("Streaming data not available.", { error_type: "NO_STREAMING_DATA" });
  const opts = {
    quality: "360p",
    type: "video+audio",
    format: "mp4",
    range: void 0,
    ...options
  };
  const format = chooseFormat(opts, streaming_data);
  const format_url = format.decipher(player);
  if (opts.type === "video+audio" && !options.range) {
    const response = await actions.session.http.fetch_function(`${format_url}&cpn=${cpn}`, {
      method: "GET",
      headers: STREAM_HEADERS,
      redirect: "follow"
    });
    if (!response.ok)
      throw new InnertubeError("The server responded with a non 2xx status code", { error_type: "FETCH_FAILED", response });
    const body = response.body;
    if (!body)
      throw new InnertubeError("Could not get ReadableStream from fetch Response.", { error_type: "FETCH_FAILED", response });
    return body;
  }
  const chunk_size = 1048576 * 10;
  let chunk_start = options.range ? options.range.start : 0;
  let chunk_end = options.range ? options.range.end : chunk_size;
  let must_end = false;
  let cancel;
  return new Platform.shim.ReadableStream({
    start() {
    },
    pull: /* @__PURE__ */ __name(async (controller) => {
      if (must_end) {
        controller.close();
        return;
      }
      if (chunk_end >= (format.content_length ? format.content_length : 0) || options.range) {
        must_end = true;
      }
      return new Promise(async (resolve, reject) => {
        try {
          cancel = new AbortController();
          const response = await actions.session.http.fetch_function(`${format_url}&cpn=${cpn}&range=${chunk_start}-${chunk_end || ""}`, {
            method: "GET",
            headers: {
              ...STREAM_HEADERS
              // XXX: use YouTube's range parameter instead of a Range header.
              // Range: `bytes=${chunk_start}-${chunk_end}`
            },
            signal: cancel.signal
          });
          if (!response.ok)
            throw new InnertubeError("The server responded with a non 2xx status code", {
              error_type: "FETCH_FAILED",
              response
            });
          const body = response.body;
          if (!body)
            throw new InnertubeError("Could not get ReadableStream from fetch Response.", {
              error_type: "FETCH_FAILED",
              response
            });
          for await (const chunk of streamToIterable(body)) {
            controller.enqueue(chunk);
          }
          chunk_start = chunk_end + 1;
          chunk_end += chunk_size;
          resolve();
        } catch (e) {
          reject(e);
        }
      });
    }, "pull"),
    async cancel(reason) {
      cancel.abort(reason);
    }
  }, {
    highWaterMark: 1,
    // TODO: better value?
    size(chunk) {
      return chunk.byteLength;
    }
  });
}
__name(download, "download");
function chooseFormat(options, streaming_data) {
  if (!streaming_data)
    throw new InnertubeError("Streaming data not available");
  const formats = [
    ...streaming_data.formats || [],
    ...streaming_data.adaptive_formats || []
  ];
  if (options.itag) {
    const candidates2 = formats.filter((format) => format.itag === options.itag);
    if (!candidates2.length)
      throw new InnertubeError("No matching formats found", { options });
    return candidates2[0];
  }
  const requires_audio = options.type ? options.type.includes("audio") : true;
  const requires_video = options.type ? options.type.includes("video") : true;
  const language = options.language || "original";
  const quality = options.quality || "best";
  let best_width = -1;
  const is_best = ["best", "bestefficiency"].includes(quality);
  const use_most_efficient = quality !== "best";
  let candidates = formats.filter((format) => {
    if (requires_audio && !format.has_audio)
      return false;
    if (requires_video && !format.has_video)
      return false;
    if (options.codec && !format.mime_type.includes(options.codec))
      return false;
    if (options.format !== "any" && !format.mime_type.includes(options.format || "mp4"))
      return false;
    if (!is_best && format.quality_label !== quality)
      return false;
    if (format.width && best_width < format.width)
      best_width = format.width;
    return true;
  });
  if (!candidates.length)
    throw new InnertubeError("No matching formats found", { options });
  if (is_best && requires_video)
    candidates = candidates.filter((format) => format.width === best_width);
  if (requires_audio && !requires_video) {
    const audio_only = candidates.filter((format) => {
      if (language !== "original") {
        return !format.has_video && !format.has_text && format.language === language;
      }
      return !format.has_video && !format.has_text && format.is_original;
    });
    if (audio_only.length > 0) {
      candidates = audio_only;
    }
  }
  if (use_most_efficient) {
    candidates.sort((a, b) => a.bitrate - b.bitrate);
  } else {
    candidates.sort((a, b) => b.bitrate - a.bitrate);
  }
  return candidates[0];
}
__name(chooseFormat, "chooseFormat");

// dist/src/utils/HTTPClient.js
var _session, _cookie, _fetch, _HTTPClient_instances, processJsonPayload_fn, setupCommonHeaders_fn, adjustContext_fn;
var _HTTPClient = class _HTTPClient {
  constructor(session, cookie, fetch2) {
    __privateAdd(this, _HTTPClient_instances);
    __privateAdd(this, _session);
    __privateAdd(this, _cookie);
    __privateAdd(this, _fetch);
    __privateSet(this, _session, session);
    __privateSet(this, _cookie, cookie);
    __privateSet(this, _fetch, fetch2 || Platform.shim.fetch);
  }
  get fetch_function() {
    return __privateGet(this, _fetch);
  }
  async fetch(input, init) {
    const session = __privateGet(this, _session);
    const innertube_url = URLS.API.PRODUCTION_1 + session.api_version;
    const baseURL = init?.baseURL || innertube_url;
    const request_url = typeof input === "string" ? new URL(`${baseURL}${baseURL.endsWith("/") || input.startsWith("/") ? "" : "/"}${input}`) : input instanceof URL ? input : new URL(input.url, baseURL);
    const headers = init?.headers || (input instanceof Platform.shim.Request ? input.headers : new Platform.shim.Headers()) || new Platform.shim.Headers();
    const body = init?.body || (input instanceof Platform.shim.Request ? input.body : void 0);
    const request_headers = new Platform.shim.Headers(headers);
    __privateMethod(this, _HTTPClient_instances, setupCommonHeaders_fn).call(this, request_headers, session, request_url);
    request_url.searchParams.set("prettyPrint", "false");
    request_url.searchParams.set("alt", "json");
    const content_type = request_headers.get("Content-Type");
    let request_body = body;
    let is_web_kids = false;
    const is_innertube_req = baseURL === innertube_url || baseURL === URLS.YT_UPLOAD;
    if (content_type === "application/json" && is_innertube_req && typeof body === "string") {
      const { newBody, isWebKids: processedIsWebKids, clientVersion: processedClientVersion, clientNameId: processedClientNameId, adjustedClientName } = __privateMethod(this, _HTTPClient_instances, processJsonPayload_fn).call(this, body, session);
      request_body = newBody;
      is_web_kids = processedIsWebKids;
      if (processedClientVersion) {
        request_headers.set("X-Youtube-Client-Version", processedClientVersion);
      }
      if (processedClientNameId) {
        request_headers.set("X-Youtube-Client-Name", processedClientNameId);
      }
      if (adjustedClientName === CLIENTS.ANDROID.NAME || adjustedClientName === CLIENTS.YTMUSIC_ANDROID.NAME) {
        request_headers.set("User-Agent", CLIENTS.ANDROID.USER_AGENT);
        request_headers.set("X-GOOG-API-FORMAT-VERSION", "2");
      } else if (adjustedClientName === CLIENTS.IOS.NAME) {
        request_headers.set("User-Agent", CLIENTS.IOS.USER_AGENT);
      }
    } else if (content_type === "application/x-protobuf") {
      if (Platform.shim.server) {
        request_headers.set("User-Agent", CLIENTS.ANDROID.USER_AGENT);
        request_headers.set("X-GOOG-API-FORMAT-VERSION", "2");
        request_headers.delete("X-Youtube-Client-Version");
      }
    }
    if (session.logged_in && is_innertube_req && !is_web_kids) {
      const oauth = session.oauth;
      if (oauth.oauth2_tokens) {
        if (oauth.shouldRefreshToken()) {
          await oauth.refreshAccessToken();
        }
        request_headers.set("Authorization", `Bearer ${oauth.oauth2_tokens.access_token}`);
      }
      const cookie = __privateGet(this, _cookie);
      if (cookie) {
        const sapisid = getCookie(cookie, "SAPISID");
        if (sapisid) {
          request_headers.set("Authorization", await generateSidAuth(sapisid));
          request_headers.set("X-Goog-Authuser", session.account_index.toString());
          if (session.context.user.onBehalfOfUser)
            request_headers.set("X-Goog-PageId", session.context.user.onBehalfOfUser);
        }
        request_headers.set("Cookie", cookie);
      }
    }
    const request = new Platform.shim.Request(request_url, input instanceof Platform.shim.Request ? input : init);
    const response = await __privateGet(this, _fetch).call(this, request, {
      body: request_body,
      headers: request_headers,
      redirect: input instanceof Platform.shim.Request ? input.redirect : init?.redirect || "follow",
      ...Platform.shim.runtime !== "cf-worker" ? { credentials: "include" } : {}
    });
    if (response.ok) {
      return response;
    }
    throw new InnertubeError(`Request to ${response.url} failed with status code ${response.status}`, await response.text());
  }
};
_session = new WeakMap();
_cookie = new WeakMap();
_fetch = new WeakMap();
_HTTPClient_instances = new WeakSet();
processJsonPayload_fn = /* @__PURE__ */ __name(function(json_body, session) {
  const parsed_payload = JSON.parse(json_body);
  const adjusted_context = JSON.parse(JSON.stringify(session.context));
  __privateMethod(this, _HTTPClient_instances, adjustContext_fn).call(this, adjusted_context, parsed_payload.client);
  const new_payload = {
    ...parsed_payload,
    context: adjusted_context
  };
  const clientVersion = new_payload.context.client.clientVersion;
  const clientNameFromAdjustedContext = new_payload.context.client.clientName;
  const clientNameId = CLIENT_NAME_IDS[clientNameFromAdjustedContext];
  delete new_payload.client;
  const isWebKids = new_payload.context.client.clientName === CLIENTS.WEB_KIDS.NAME;
  return {
    newBody: JSON.stringify(new_payload),
    isWebKids,
    clientVersion,
    clientNameId,
    adjustedClientName: new_payload.context.client.clientName
  };
}, "#processJsonPayload");
setupCommonHeaders_fn = /* @__PURE__ */ __name(function(request_headers, session, request_url) {
  request_headers.set("Accept", "*/*");
  request_headers.set("Accept-Language", "*");
  request_headers.set("X-Goog-Visitor-Id", session.context.client.visitorData || "");
  request_headers.set("X-Youtube-Client-Version", session.context.client.clientVersion || "");
  const client_name_id = CLIENT_NAME_IDS[session.context.client.clientName];
  if (client_name_id) {
    request_headers.set("X-Youtube-Client-Name", client_name_id);
  }
  if (Platform.shim.server) {
    request_headers.set("User-Agent", session.user_agent || "");
    request_headers.set("Origin", request_url.origin);
  }
}, "#setupCommonHeaders");
adjustContext_fn = /* @__PURE__ */ __name(function(ctx, client) {
  if (!client)
    return;
  const clientName = client.toUpperCase();
  if (!SUPPORTED_CLIENTS.includes(clientName)) {
    throw new InnertubeError(`Invalid client: ${client}`, {
      available_innertube_clients: SUPPORTED_CLIENTS
    });
  }
  if (clientName !== "WEB") {
    delete ctx.client.configInfo;
  }
  if (clientName === "ANDROID" || clientName === "YTMUSIC_ANDROID" || clientName === "YTSTUDIO_ANDROID") {
    ctx.client.androidSdkVersion = CLIENTS.ANDROID.SDK_VERSION;
    ctx.client.userAgent = CLIENTS.ANDROID.USER_AGENT;
    ctx.client.osName = "Android";
    ctx.client.osVersion = "13";
    ctx.client.platform = "MOBILE";
  }
  switch (clientName) {
    case "MWEB":
      ctx.client.clientVersion = CLIENTS.MWEB.VERSION;
      ctx.client.clientName = CLIENTS.MWEB.NAME;
      ctx.client.clientFormFactor = "SMALL_FORM_FACTOR";
      ctx.client.platform = "MOBILE";
      break;
    case "IOS":
      ctx.client.deviceMake = "Apple";
      ctx.client.deviceModel = CLIENTS.IOS.DEVICE_MODEL;
      ctx.client.clientVersion = CLIENTS.IOS.VERSION;
      ctx.client.clientName = CLIENTS.IOS.NAME;
      ctx.client.platform = "MOBILE";
      ctx.client.osName = CLIENTS.IOS.OS_NAME;
      ctx.client.osVersion = CLIENTS.IOS.OS_VERSION;
      delete ctx.client.browserName;
      delete ctx.client.browserVersion;
      break;
    case "YTMUSIC":
      ctx.client.clientVersion = CLIENTS.YTMUSIC.VERSION;
      ctx.client.clientName = CLIENTS.YTMUSIC.NAME;
      break;
    case "ANDROID":
      ctx.client.clientVersion = CLIENTS.ANDROID.VERSION;
      ctx.client.clientFormFactor = "SMALL_FORM_FACTOR";
      ctx.client.clientName = CLIENTS.ANDROID.NAME;
      break;
    case "YTMUSIC_ANDROID":
      ctx.client.clientVersion = CLIENTS.YTMUSIC_ANDROID.VERSION;
      ctx.client.clientFormFactor = "SMALL_FORM_FACTOR";
      ctx.client.clientName = CLIENTS.YTMUSIC_ANDROID.NAME;
      break;
    case "YTSTUDIO_ANDROID":
      ctx.client.clientVersion = CLIENTS.YTSTUDIO_ANDROID.VERSION;
      ctx.client.clientFormFactor = "SMALL_FORM_FACTOR";
      ctx.client.clientName = CLIENTS.YTSTUDIO_ANDROID.NAME;
      break;
    case "TV":
      ctx.client.clientVersion = CLIENTS.TV.VERSION;
      ctx.client.clientName = CLIENTS.TV.NAME;
      ctx.client.userAgent = CLIENTS.TV.USER_AGENT;
      break;
    case "TV_SIMPLY":
      ctx.client.clientVersion = CLIENTS.TV_SIMPLY.VERSION;
      ctx.client.clientName = CLIENTS.TV_SIMPLY.NAME;
      break;
    case "TV_EMBEDDED":
      ctx.client.clientName = CLIENTS.TV_EMBEDDED.NAME;
      ctx.client.clientVersion = CLIENTS.TV_EMBEDDED.VERSION;
      ctx.client.clientScreen = "EMBED";
      ctx.thirdParty = { embedUrl: URLS.YT_BASE };
      break;
    case "YTKIDS":
      ctx.client.clientVersion = CLIENTS.WEB_KIDS.VERSION;
      ctx.client.clientName = CLIENTS.WEB_KIDS.NAME;
      ctx.client.kidsAppInfo = {
        categorySettings: {
          enabledCategories: [
            "approved_for_you",
            "black_joy",
            "camp",
            "collections",
            "earth",
            "explore",
            "favorites",
            "gaming",
            "halloween",
            "hero",
            "learning",
            "move",
            "music",
            "reading",
            "shared_by_parents",
            "shows",
            "soccer",
            "sports",
            "spotlight",
            "winter"
          ]
        },
        contentSettings: {
          corpusPreference: "KIDS_CORPUS_PREFERENCE_YOUNGER",
          kidsNoSearchMode: "YT_KIDS_NO_SEARCH_MODE_OFF"
        }
      };
      break;
    case "WEB_EMBEDDED":
      ctx.client.clientName = CLIENTS.WEB_EMBEDDED.NAME;
      ctx.client.clientVersion = CLIENTS.WEB_EMBEDDED.VERSION;
      ctx.client.clientScreen = "EMBED";
      ctx.thirdParty = { embedUrl: URLS.GOOGLE_SEARCH_BASE };
      break;
    case "WEB_CREATOR":
      ctx.client.clientName = CLIENTS.WEB_CREATOR.NAME;
      ctx.client.clientVersion = CLIENTS.WEB_CREATOR.VERSION;
      break;
    default:
      break;
  }
}, "#adjustContext");
__name(_HTTPClient, "HTTPClient");
var HTTPClient = _HTTPClient;

// dist/src/utils/LZW.js
var LZW_exports = {};
__export(LZW_exports, {
  compress: () => compress,
  decompress: () => decompress
});
function compress(input) {
  const output = [];
  const dictionary = {};
  for (let i = 0; i < 256; i++) {
    dictionary[String.fromCharCode(i)] = i;
  }
  let current_string = "";
  let dictionary_size = 256;
  for (let i = 0; i < input.length; i++) {
    const current_char = input[i];
    const combined_string = current_string + current_char;
    if (dictionary.hasOwnProperty(combined_string)) {
      current_string = combined_string;
    } else {
      output.push(dictionary[current_string]);
      dictionary[combined_string] = dictionary_size++;
      current_string = current_char;
    }
  }
  if (current_string !== "") {
    output.push(dictionary[current_string]);
  }
  return output.map((code) => String.fromCharCode(code)).join("");
}
__name(compress, "compress");
function decompress(input) {
  const dictionary = {};
  const input_data = input.split("");
  const output = [input_data.shift()];
  const input_length = input_data.length >>> 0;
  let dictionary_code = 256;
  let current_char = output[0];
  let current_string = current_char;
  for (let i = 0; i < input_length; ++i) {
    const current_code = input_data[i].charCodeAt(0);
    const entry = current_code < 256 ? input_data[i] : dictionary[current_code] ? dictionary[current_code] : current_string + current_char;
    output.push(entry);
    current_char = entry.charAt(0);
    dictionary[dictionary_code++] = current_string + current_char;
    current_string = entry;
  }
  return output.join("");
}
__name(decompress, "decompress");

// dist/src/utils/BinarySerializer.js
var BinarySerializer_exports = {};
__export(BinarySerializer_exports, {
  MAGIC_HEADER: () => MAGIC_HEADER,
  VERSION: () => VERSION,
  deserialize: () => deserialize,
  serialize: () => serialize
});
var MAGIC_HEADER = 5849684;
var VERSION = 1;
function serialize(data2) {
  const json_str = JSON.stringify(data2);
  const compressed = compress(json_str);
  const compressed_bytes = new TextEncoder().encode(compressed);
  const buffer = new ArrayBuffer(12 + compressed_bytes.byteLength);
  const view = new DataView(buffer);
  view.setUint32(0, MAGIC_HEADER, true);
  view.setUint32(4, VERSION, true);
  view.setUint32(8, compressed_bytes.byteLength, true);
  new Uint8Array(buffer).set(compressed_bytes, 12);
  return new Uint8Array(buffer);
}
__name(serialize, "serialize");
function deserialize(buffer) {
  if (buffer.byteLength < 12)
    throw new Error("Invalid binary format: buffer too short");
  const view = new DataView(buffer.buffer, buffer.byteOffset);
  const magic = view.getUint32(0, true);
  if (magic !== MAGIC_HEADER) {
    throw new Error("Invalid binary format: magic header mismatch");
  }
  const version2 = view.getUint32(4, true);
  if (version2 !== VERSION) {
    throw new Error(`Unsupported binary format version: ${version2}`);
  }
  const data_length = view.getUint32(8, true);
  const compressed_data = buffer.slice(12, 12 + data_length);
  const compressed = new TextDecoder().decode(compressed_data);
  const json_str = decompress(compressed);
  return JSON.parse(json_str);
}
__name(deserialize, "deserialize");

// dist/src/utils/ProtoUtils.js
var ProtoUtils_exports = {};
__export(ProtoUtils_exports, {
  decodeVisitorData: () => decodeVisitorData,
  encodeCommentActionParams: () => encodeCommentActionParams,
  encodeNextParams: () => encodeNextParams,
  encodeVisitorData: () => encodeVisitorData
});

// node_modules/@bufbuild/protobuf/dist/esm/wire/varint.js
function varint64read() {
  let lowBits = 0;
  let highBits = 0;
  for (let shift = 0; shift < 28; shift += 7) {
    let b = this.buf[this.pos++];
    lowBits |= (b & 127) << shift;
    if ((b & 128) == 0) {
      this.assertBounds();
      return [lowBits, highBits];
    }
  }
  let middleByte = this.buf[this.pos++];
  lowBits |= (middleByte & 15) << 28;
  highBits = (middleByte & 112) >> 4;
  if ((middleByte & 128) == 0) {
    this.assertBounds();
    return [lowBits, highBits];
  }
  for (let shift = 3; shift <= 31; shift += 7) {
    let b = this.buf[this.pos++];
    highBits |= (b & 127) << shift;
    if ((b & 128) == 0) {
      this.assertBounds();
      return [lowBits, highBits];
    }
  }
  throw new Error("invalid varint");
}
__name(varint64read, "varint64read");
function varint64write(lo, hi, bytes) {
  for (let i = 0; i < 28; i = i + 7) {
    const shift = lo >>> i;
    const hasNext = !(shift >>> 7 == 0 && hi == 0);
    const byte = (hasNext ? shift | 128 : shift) & 255;
    bytes.push(byte);
    if (!hasNext) {
      return;
    }
  }
  const splitBits = lo >>> 28 & 15 | (hi & 7) << 4;
  const hasMoreBits = !(hi >> 3 == 0);
  bytes.push((hasMoreBits ? splitBits | 128 : splitBits) & 255);
  if (!hasMoreBits) {
    return;
  }
  for (let i = 3; i < 31; i = i + 7) {
    const shift = hi >>> i;
    const hasNext = !(shift >>> 7 == 0);
    const byte = (hasNext ? shift | 128 : shift) & 255;
    bytes.push(byte);
    if (!hasNext) {
      return;
    }
  }
  bytes.push(hi >>> 31 & 1);
}
__name(varint64write, "varint64write");
var TWO_PWR_32_DBL = 4294967296;
function int64FromString(dec) {
  const minus = dec[0] === "-";
  if (minus) {
    dec = dec.slice(1);
  }
  const base = 1e6;
  let lowBits = 0;
  let highBits = 0;
  function add1e6digit(begin, end) {
    const digit1e6 = Number(dec.slice(begin, end));
    highBits *= base;
    lowBits = lowBits * base + digit1e6;
    if (lowBits >= TWO_PWR_32_DBL) {
      highBits = highBits + (lowBits / TWO_PWR_32_DBL | 0);
      lowBits = lowBits % TWO_PWR_32_DBL;
    }
  }
  __name(add1e6digit, "add1e6digit");
  add1e6digit(-24, -18);
  add1e6digit(-18, -12);
  add1e6digit(-12, -6);
  add1e6digit(-6);
  return minus ? negate(lowBits, highBits) : newBits(lowBits, highBits);
}
__name(int64FromString, "int64FromString");
function int64ToString(lo, hi) {
  let bits = newBits(lo, hi);
  const negative = bits.hi & 2147483648;
  if (negative) {
    bits = negate(bits.lo, bits.hi);
  }
  const result = uInt64ToString(bits.lo, bits.hi);
  return negative ? "-" + result : result;
}
__name(int64ToString, "int64ToString");
function uInt64ToString(lo, hi) {
  ({ lo, hi } = toUnsigned(lo, hi));
  if (hi <= 2097151) {
    return String(TWO_PWR_32_DBL * hi + lo);
  }
  const low = lo & 16777215;
  const mid = (lo >>> 24 | hi << 8) & 16777215;
  const high = hi >> 16 & 65535;
  let digitA = low + mid * 6777216 + high * 6710656;
  let digitB = mid + high * 8147497;
  let digitC = high * 2;
  const base = 1e7;
  if (digitA >= base) {
    digitB += Math.floor(digitA / base);
    digitA %= base;
  }
  if (digitB >= base) {
    digitC += Math.floor(digitB / base);
    digitB %= base;
  }
  return digitC.toString() + decimalFrom1e7WithLeadingZeros(digitB) + decimalFrom1e7WithLeadingZeros(digitA);
}
__name(uInt64ToString, "uInt64ToString");
function toUnsigned(lo, hi) {
  return { lo: lo >>> 0, hi: hi >>> 0 };
}
__name(toUnsigned, "toUnsigned");
function newBits(lo, hi) {
  return { lo: lo | 0, hi: hi | 0 };
}
__name(newBits, "newBits");
function negate(lowBits, highBits) {
  highBits = ~highBits;
  if (lowBits) {
    lowBits = ~lowBits + 1;
  } else {
    highBits += 1;
  }
  return newBits(lowBits, highBits);
}
__name(negate, "negate");
var decimalFrom1e7WithLeadingZeros = /* @__PURE__ */ __name((digit1e7) => {
  const partial = String(digit1e7);
  return "0000000".slice(partial.length) + partial;
}, "decimalFrom1e7WithLeadingZeros");
function varint32write(value, bytes) {
  if (value >= 0) {
    while (value > 127) {
      bytes.push(value & 127 | 128);
      value = value >>> 7;
    }
    bytes.push(value);
  } else {
    for (let i = 0; i < 9; i++) {
      bytes.push(value & 127 | 128);
      value = value >> 7;
    }
    bytes.push(1);
  }
}
__name(varint32write, "varint32write");
function varint32read() {
  let b = this.buf[this.pos++];
  let result = b & 127;
  if ((b & 128) == 0) {
    this.assertBounds();
    return result;
  }
  b = this.buf[this.pos++];
  result |= (b & 127) << 7;
  if ((b & 128) == 0) {
    this.assertBounds();
    return result;
  }
  b = this.buf[this.pos++];
  result |= (b & 127) << 14;
  if ((b & 128) == 0) {
    this.assertBounds();
    return result;
  }
  b = this.buf[this.pos++];
  result |= (b & 127) << 21;
  if ((b & 128) == 0) {
    this.assertBounds();
    return result;
  }
  b = this.buf[this.pos++];
  result |= (b & 15) << 28;
  for (let readBytes = 5; (b & 128) !== 0 && readBytes < 10; readBytes++)
    b = this.buf[this.pos++];
  if ((b & 128) != 0)
    throw new Error("invalid varint");
  this.assertBounds();
  return result >>> 0;
}
__name(varint32read, "varint32read");

// node_modules/@bufbuild/protobuf/dist/esm/proto-int64.js
var protoInt64 = /* @__PURE__ */ makeInt64Support();
function makeInt64Support() {
  const dv = new DataView(new ArrayBuffer(8));
  const ok = typeof BigInt === "function" && typeof dv.getBigInt64 === "function" && typeof dv.getBigUint64 === "function" && typeof dv.setBigInt64 === "function" && typeof dv.setBigUint64 === "function" && (typeof process != "object" || typeof process.env != "object" || process.env.BUF_BIGINT_DISABLE !== "1");
  if (ok) {
    const MIN = BigInt("-9223372036854775808"), MAX = BigInt("9223372036854775807"), UMIN = BigInt("0"), UMAX = BigInt("18446744073709551615");
    return {
      zero: BigInt(0),
      supported: true,
      parse(value) {
        const bi = typeof value == "bigint" ? value : BigInt(value);
        if (bi > MAX || bi < MIN) {
          throw new Error(`invalid int64: ${value}`);
        }
        return bi;
      },
      uParse(value) {
        const bi = typeof value == "bigint" ? value : BigInt(value);
        if (bi > UMAX || bi < UMIN) {
          throw new Error(`invalid uint64: ${value}`);
        }
        return bi;
      },
      enc(value) {
        dv.setBigInt64(0, this.parse(value), true);
        return {
          lo: dv.getInt32(0, true),
          hi: dv.getInt32(4, true)
        };
      },
      uEnc(value) {
        dv.setBigInt64(0, this.uParse(value), true);
        return {
          lo: dv.getInt32(0, true),
          hi: dv.getInt32(4, true)
        };
      },
      dec(lo, hi) {
        dv.setInt32(0, lo, true);
        dv.setInt32(4, hi, true);
        return dv.getBigInt64(0, true);
      },
      uDec(lo, hi) {
        dv.setInt32(0, lo, true);
        dv.setInt32(4, hi, true);
        return dv.getBigUint64(0, true);
      }
    };
  }
  return {
    zero: "0",
    supported: false,
    parse(value) {
      if (typeof value != "string") {
        value = value.toString();
      }
      assertInt64String(value);
      return value;
    },
    uParse(value) {
      if (typeof value != "string") {
        value = value.toString();
      }
      assertUInt64String(value);
      return value;
    },
    enc(value) {
      if (typeof value != "string") {
        value = value.toString();
      }
      assertInt64String(value);
      return int64FromString(value);
    },
    uEnc(value) {
      if (typeof value != "string") {
        value = value.toString();
      }
      assertUInt64String(value);
      return int64FromString(value);
    },
    dec(lo, hi) {
      return int64ToString(lo, hi);
    },
    uDec(lo, hi) {
      return uInt64ToString(lo, hi);
    }
  };
}
__name(makeInt64Support, "makeInt64Support");
function assertInt64String(value) {
  if (!/^-?[0-9]+$/.test(value)) {
    throw new Error("invalid int64: " + value);
  }
}
__name(assertInt64String, "assertInt64String");
function assertUInt64String(value) {
  if (!/^[0-9]+$/.test(value)) {
    throw new Error("invalid uint64: " + value);
  }
}
__name(assertUInt64String, "assertUInt64String");

// node_modules/@bufbuild/protobuf/dist/esm/wire/text-encoding.js
var symbol = Symbol.for("@bufbuild/protobuf/text-encoding");
function getTextEncoding() {
  if (globalThis[symbol] == void 0) {
    const te = new globalThis.TextEncoder();
    const td = new globalThis.TextDecoder();
    globalThis[symbol] = {
      encodeUtf8(text) {
        return te.encode(text);
      },
      decodeUtf8(bytes) {
        return td.decode(bytes);
      },
      checkUtf8(text) {
        try {
          encodeURIComponent(text);
          return true;
        } catch (e) {
          return false;
        }
      }
    };
  }
  return globalThis[symbol];
}
__name(getTextEncoding, "getTextEncoding");

// node_modules/@bufbuild/protobuf/dist/esm/wire/binary-encoding.js
var WireType;
(function(WireType2) {
  WireType2[WireType2["Varint"] = 0] = "Varint";
  WireType2[WireType2["Bit64"] = 1] = "Bit64";
  WireType2[WireType2["LengthDelimited"] = 2] = "LengthDelimited";
  WireType2[WireType2["StartGroup"] = 3] = "StartGroup";
  WireType2[WireType2["EndGroup"] = 4] = "EndGroup";
  WireType2[WireType2["Bit32"] = 5] = "Bit32";
})(WireType || (WireType = {}));
var FLOAT32_MAX = 34028234663852886e22;
var FLOAT32_MIN = -34028234663852886e22;
var UINT32_MAX = 4294967295;
var INT32_MAX = 2147483647;
var INT32_MIN = -2147483648;
var _BinaryWriter = class _BinaryWriter {
  constructor(encodeUtf8 = getTextEncoding().encodeUtf8) {
    this.encodeUtf8 = encodeUtf8;
    this.stack = [];
    this.chunks = [];
    this.buf = [];
  }
  /**
   * Return all bytes written and reset this writer.
   */
  finish() {
    this.chunks.push(new Uint8Array(this.buf));
    let len = 0;
    for (let i = 0; i < this.chunks.length; i++)
      len += this.chunks[i].length;
    let bytes = new Uint8Array(len);
    let offset2 = 0;
    for (let i = 0; i < this.chunks.length; i++) {
      bytes.set(this.chunks[i], offset2);
      offset2 += this.chunks[i].length;
    }
    this.chunks = [];
    return bytes;
  }
  /**
   * Start a new fork for length-delimited data like a message
   * or a packed repeated field.
   *
   * Must be joined later with `join()`.
   */
  fork() {
    this.stack.push({ chunks: this.chunks, buf: this.buf });
    this.chunks = [];
    this.buf = [];
    return this;
  }
  /**
   * Join the last fork. Write its length and bytes, then
   * return to the previous state.
   */
  join() {
    let chunk = this.finish();
    let prev = this.stack.pop();
    if (!prev)
      throw new Error("invalid state, fork stack empty");
    this.chunks = prev.chunks;
    this.buf = prev.buf;
    this.uint32(chunk.byteLength);
    return this.raw(chunk);
  }
  /**
   * Writes a tag (field number and wire type).
   *
   * Equivalent to `uint32( (fieldNo << 3 | type) >>> 0 )`.
   *
   * Generated code should compute the tag ahead of time and call `uint32()`.
   */
  tag(fieldNo, type) {
    return this.uint32((fieldNo << 3 | type) >>> 0);
  }
  /**
   * Write a chunk of raw bytes.
   */
  raw(chunk) {
    if (this.buf.length) {
      this.chunks.push(new Uint8Array(this.buf));
      this.buf = [];
    }
    this.chunks.push(chunk);
    return this;
  }
  /**
   * Write a `uint32` value, an unsigned 32 bit varint.
   */
  uint32(value) {
    assertUInt32(value);
    while (value > 127) {
      this.buf.push(value & 127 | 128);
      value = value >>> 7;
    }
    this.buf.push(value);
    return this;
  }
  /**
   * Write a `int32` value, a signed 32 bit varint.
   */
  int32(value) {
    assertInt32(value);
    varint32write(value, this.buf);
    return this;
  }
  /**
   * Write a `bool` value, a variant.
   */
  bool(value) {
    this.buf.push(value ? 1 : 0);
    return this;
  }
  /**
   * Write a `bytes` value, length-delimited arbitrary data.
   */
  bytes(value) {
    this.uint32(value.byteLength);
    return this.raw(value);
  }
  /**
   * Write a `string` value, length-delimited data converted to UTF-8 text.
   */
  string(value) {
    let chunk = this.encodeUtf8(value);
    this.uint32(chunk.byteLength);
    return this.raw(chunk);
  }
  /**
   * Write a `float` value, 32-bit floating point number.
   */
  float(value) {
    assertFloat32(value);
    let chunk = new Uint8Array(4);
    new DataView(chunk.buffer).setFloat32(0, value, true);
    return this.raw(chunk);
  }
  /**
   * Write a `double` value, a 64-bit floating point number.
   */
  double(value) {
    let chunk = new Uint8Array(8);
    new DataView(chunk.buffer).setFloat64(0, value, true);
    return this.raw(chunk);
  }
  /**
   * Write a `fixed32` value, an unsigned, fixed-length 32-bit integer.
   */
  fixed32(value) {
    assertUInt32(value);
    let chunk = new Uint8Array(4);
    new DataView(chunk.buffer).setUint32(0, value, true);
    return this.raw(chunk);
  }
  /**
   * Write a `sfixed32` value, a signed, fixed-length 32-bit integer.
   */
  sfixed32(value) {
    assertInt32(value);
    let chunk = new Uint8Array(4);
    new DataView(chunk.buffer).setInt32(0, value, true);
    return this.raw(chunk);
  }
  /**
   * Write a `sint32` value, a signed, zigzag-encoded 32-bit varint.
   */
  sint32(value) {
    assertInt32(value);
    value = (value << 1 ^ value >> 31) >>> 0;
    varint32write(value, this.buf);
    return this;
  }
  /**
   * Write a `fixed64` value, a signed, fixed-length 64-bit integer.
   */
  sfixed64(value) {
    let chunk = new Uint8Array(8), view = new DataView(chunk.buffer), tc = protoInt64.enc(value);
    view.setInt32(0, tc.lo, true);
    view.setInt32(4, tc.hi, true);
    return this.raw(chunk);
  }
  /**
   * Write a `fixed64` value, an unsigned, fixed-length 64 bit integer.
   */
  fixed64(value) {
    let chunk = new Uint8Array(8), view = new DataView(chunk.buffer), tc = protoInt64.uEnc(value);
    view.setInt32(0, tc.lo, true);
    view.setInt32(4, tc.hi, true);
    return this.raw(chunk);
  }
  /**
   * Write a `int64` value, a signed 64-bit varint.
   */
  int64(value) {
    let tc = protoInt64.enc(value);
    varint64write(tc.lo, tc.hi, this.buf);
    return this;
  }
  /**
   * Write a `sint64` value, a signed, zig-zag-encoded 64-bit varint.
   */
  sint64(value) {
    let tc = protoInt64.enc(value), sign = tc.hi >> 31, lo = tc.lo << 1 ^ sign, hi = (tc.hi << 1 | tc.lo >>> 31) ^ sign;
    varint64write(lo, hi, this.buf);
    return this;
  }
  /**
   * Write a `uint64` value, an unsigned 64-bit varint.
   */
  uint64(value) {
    let tc = protoInt64.uEnc(value);
    varint64write(tc.lo, tc.hi, this.buf);
    return this;
  }
};
__name(_BinaryWriter, "BinaryWriter");
var BinaryWriter = _BinaryWriter;
var _BinaryReader = class _BinaryReader {
  constructor(buf, decodeUtf8 = getTextEncoding().decodeUtf8) {
    this.decodeUtf8 = decodeUtf8;
    this.varint64 = varint64read;
    this.uint32 = varint32read;
    this.buf = buf;
    this.len = buf.length;
    this.pos = 0;
    this.view = new DataView(buf.buffer, buf.byteOffset, buf.byteLength);
  }
  /**
   * Reads a tag - field number and wire type.
   */
  tag() {
    let tag = this.uint32(), fieldNo = tag >>> 3, wireType = tag & 7;
    if (fieldNo <= 0 || wireType < 0 || wireType > 5)
      throw new Error("illegal tag: field no " + fieldNo + " wire type " + wireType);
    return [fieldNo, wireType];
  }
  /**
   * Skip one element and return the skipped data.
   *
   * When skipping StartGroup, provide the tags field number to check for
   * matching field number in the EndGroup tag.
   */
  skip(wireType, fieldNo) {
    let start = this.pos;
    switch (wireType) {
      case WireType.Varint:
        while (this.buf[this.pos++] & 128) {
        }
        break;
      // eslint-disable-next-line
      // @ts-expect-error TS7029: Fallthrough case in switch
      case WireType.Bit64:
        this.pos += 4;
      // eslint-disable-next-line no-fallthrough
      case WireType.Bit32:
        this.pos += 4;
        break;
      case WireType.LengthDelimited:
        let len = this.uint32();
        this.pos += len;
        break;
      case WireType.StartGroup:
        for (; ; ) {
          const [fn, wt] = this.tag();
          if (wt === WireType.EndGroup) {
            if (fieldNo !== void 0 && fn !== fieldNo) {
              throw new Error("invalid end group tag");
            }
            break;
          }
          this.skip(wt, fn);
        }
        break;
      default:
        throw new Error("cant skip wire type " + wireType);
    }
    this.assertBounds();
    return this.buf.subarray(start, this.pos);
  }
  /**
   * Throws error if position in byte array is out of range.
   */
  assertBounds() {
    if (this.pos > this.len)
      throw new RangeError("premature EOF");
  }
  /**
   * Read a `int32` field, a signed 32 bit varint.
   */
  int32() {
    return this.uint32() | 0;
  }
  /**
   * Read a `sint32` field, a signed, zigzag-encoded 32-bit varint.
   */
  sint32() {
    let zze = this.uint32();
    return zze >>> 1 ^ -(zze & 1);
  }
  /**
   * Read a `int64` field, a signed 64-bit varint.
   */
  int64() {
    return protoInt64.dec(...this.varint64());
  }
  /**
   * Read a `uint64` field, an unsigned 64-bit varint.
   */
  uint64() {
    return protoInt64.uDec(...this.varint64());
  }
  /**
   * Read a `sint64` field, a signed, zig-zag-encoded 64-bit varint.
   */
  sint64() {
    let [lo, hi] = this.varint64();
    let s = -(lo & 1);
    lo = (lo >>> 1 | (hi & 1) << 31) ^ s;
    hi = hi >>> 1 ^ s;
    return protoInt64.dec(lo, hi);
  }
  /**
   * Read a `bool` field, a variant.
   */
  bool() {
    let [lo, hi] = this.varint64();
    return lo !== 0 || hi !== 0;
  }
  /**
   * Read a `fixed32` field, an unsigned, fixed-length 32-bit integer.
   */
  fixed32() {
    return this.view.getUint32((this.pos += 4) - 4, true);
  }
  /**
   * Read a `sfixed32` field, a signed, fixed-length 32-bit integer.
   */
  sfixed32() {
    return this.view.getInt32((this.pos += 4) - 4, true);
  }
  /**
   * Read a `fixed64` field, an unsigned, fixed-length 64 bit integer.
   */
  fixed64() {
    return protoInt64.uDec(this.sfixed32(), this.sfixed32());
  }
  /**
   * Read a `fixed64` field, a signed, fixed-length 64-bit integer.
   */
  sfixed64() {
    return protoInt64.dec(this.sfixed32(), this.sfixed32());
  }
  /**
   * Read a `float` field, 32-bit floating point number.
   */
  float() {
    return this.view.getFloat32((this.pos += 4) - 4, true);
  }
  /**
   * Read a `double` field, a 64-bit floating point number.
   */
  double() {
    return this.view.getFloat64((this.pos += 8) - 8, true);
  }
  /**
   * Read a `bytes` field, length-delimited arbitrary data.
   */
  bytes() {
    let len = this.uint32(), start = this.pos;
    this.pos += len;
    this.assertBounds();
    return this.buf.subarray(start, start + len);
  }
  /**
   * Read a `string` field, length-delimited data converted to UTF-8 text.
   */
  string() {
    return this.decodeUtf8(this.bytes());
  }
};
__name(_BinaryReader, "BinaryReader");
var BinaryReader = _BinaryReader;
function assertInt32(arg) {
  if (typeof arg == "string") {
    arg = Number(arg);
  } else if (typeof arg != "number") {
    throw new Error("invalid int32: " + typeof arg);
  }
  if (!Number.isInteger(arg) || arg > INT32_MAX || arg < INT32_MIN)
    throw new Error("invalid int32: " + arg);
}
__name(assertInt32, "assertInt32");
function assertUInt32(arg) {
  if (typeof arg == "string") {
    arg = Number(arg);
  } else if (typeof arg != "number") {
    throw new Error("invalid uint32: " + typeof arg);
  }
  if (!Number.isInteger(arg) || arg > UINT32_MAX || arg < 0)
    throw new Error("invalid uint32: " + arg);
}
__name(assertUInt32, "assertUInt32");
function assertFloat32(arg) {
  if (typeof arg == "string") {
    const o = arg;
    arg = Number(arg);
    if (isNaN(arg) && o !== "NaN") {
      throw new Error("invalid float32: " + o);
    }
  } else if (typeof arg != "number") {
    throw new Error("invalid float32: " + typeof arg);
  }
  if (Number.isFinite(arg) && (arg > FLOAT32_MAX || arg < FLOAT32_MIN))
    throw new Error("invalid float32: " + arg);
}
__name(assertFloat32, "assertFloat32");

// dist/protos/generated/misc/params.js
var SearchFilter_SortBy = {
  RELEVANCE: 0,
  0: "RELEVANCE",
  RATING: 1,
  1: "RATING",
  UPLOAD_DATE: 2,
  2: "UPLOAD_DATE",
  VIEW_COUNT: 3,
  3: "VIEW_COUNT",
  UNRECOGNIZED: -1,
  "-1": "UNRECOGNIZED"
};
var SearchFilter_Filters_UploadDate = {
  ANY_DATE: 0,
  0: "ANY_DATE",
  HOUR: 1,
  1: "HOUR",
  TODAY: 2,
  2: "TODAY",
  WEEK: 3,
  3: "WEEK",
  MONTH: 4,
  4: "MONTH",
  YEAR: 5,
  5: "YEAR",
  UNRECOGNIZED: -1,
  "-1": "UNRECOGNIZED"
};
var SearchFilter_Filters_SearchType = {
  ANY_TYPE: 0,
  0: "ANY_TYPE",
  VIDEO: 1,
  1: "VIDEO",
  CHANNEL: 2,
  2: "CHANNEL",
  PLAYLIST: 3,
  3: "PLAYLIST",
  MOVIE: 4,
  4: "MOVIE",
  UNRECOGNIZED: -1,
  "-1": "UNRECOGNIZED"
};
var SearchFilter_Filters_Duration = {
  ANY_DURATION: 0,
  0: "ANY_DURATION",
  SHORT: 1,
  1: "SHORT",
  LONG: 2,
  2: "LONG",
  MEDIUM: 3,
  3: "MEDIUM",
  UNRECOGNIZED: -1,
  "-1": "UNRECOGNIZED"
};
function createBaseVisitorData() {
  return { id: "", timestamp: 0 };
}
__name(createBaseVisitorData, "createBaseVisitorData");
var VisitorData = {
  encode(message, writer = new BinaryWriter()) {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    if (message.timestamp !== 0) {
      writer.uint32(40).int32(message.timestamp);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseVisitorData();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.id = reader.string();
          continue;
        case 5:
          if (tag !== 40) {
            break;
          }
          message.timestamp = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSearchFilter() {
  return { sortBy: void 0, filters: void 0 };
}
__name(createBaseSearchFilter, "createBaseSearchFilter");
var SearchFilter = {
  encode(message, writer = new BinaryWriter()) {
    if (message.sortBy !== void 0) {
      writer.uint32(8).int32(message.sortBy);
    }
    if (message.filters !== void 0) {
      SearchFilter_Filters.encode(message.filters, writer.uint32(18).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSearchFilter();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.sortBy = reader.int32();
          continue;
        case 2:
          if (tag !== 18) {
            break;
          }
          message.filters = SearchFilter_Filters.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSearchFilter_Filters() {
  return {
    uploadDate: void 0,
    type: void 0,
    duration: void 0,
    musicSearchType: void 0,
    featuresHd: void 0,
    featuresSubtitles: void 0,
    featuresCreativeCommons: void 0,
    features3d: void 0,
    featuresLive: void 0,
    featuresPurchased: void 0,
    features4k: void 0,
    features360: void 0,
    featuresLocation: void 0,
    featuresHdr: void 0,
    featuresVr180: void 0
  };
}
__name(createBaseSearchFilter_Filters, "createBaseSearchFilter_Filters");
var SearchFilter_Filters = {
  encode(message, writer = new BinaryWriter()) {
    if (message.uploadDate !== void 0) {
      writer.uint32(8).int32(message.uploadDate);
    }
    if (message.type !== void 0) {
      writer.uint32(16).int32(message.type);
    }
    if (message.duration !== void 0) {
      writer.uint32(24).int32(message.duration);
    }
    if (message.musicSearchType !== void 0) {
      SearchFilter_Filters_MusicSearchType.encode(message.musicSearchType, writer.uint32(138).fork()).join();
    }
    if (message.featuresHd !== void 0) {
      writer.uint32(32).bool(message.featuresHd);
    }
    if (message.featuresSubtitles !== void 0) {
      writer.uint32(40).bool(message.featuresSubtitles);
    }
    if (message.featuresCreativeCommons !== void 0) {
      writer.uint32(48).bool(message.featuresCreativeCommons);
    }
    if (message.features3d !== void 0) {
      writer.uint32(56).bool(message.features3d);
    }
    if (message.featuresLive !== void 0) {
      writer.uint32(64).bool(message.featuresLive);
    }
    if (message.featuresPurchased !== void 0) {
      writer.uint32(72).bool(message.featuresPurchased);
    }
    if (message.features4k !== void 0) {
      writer.uint32(112).bool(message.features4k);
    }
    if (message.features360 !== void 0) {
      writer.uint32(120).bool(message.features360);
    }
    if (message.featuresLocation !== void 0) {
      writer.uint32(184).bool(message.featuresLocation);
    }
    if (message.featuresHdr !== void 0) {
      writer.uint32(200).bool(message.featuresHdr);
    }
    if (message.featuresVr180 !== void 0) {
      writer.uint32(208).bool(message.featuresVr180);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSearchFilter_Filters();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.uploadDate = reader.int32();
          continue;
        case 2:
          if (tag !== 16) {
            break;
          }
          message.type = reader.int32();
          continue;
        case 3:
          if (tag !== 24) {
            break;
          }
          message.duration = reader.int32();
          continue;
        case 17:
          if (tag !== 138) {
            break;
          }
          message.musicSearchType = SearchFilter_Filters_MusicSearchType.decode(reader, reader.uint32());
          continue;
        case 4:
          if (tag !== 32) {
            break;
          }
          message.featuresHd = reader.bool();
          continue;
        case 5:
          if (tag !== 40) {
            break;
          }
          message.featuresSubtitles = reader.bool();
          continue;
        case 6:
          if (tag !== 48) {
            break;
          }
          message.featuresCreativeCommons = reader.bool();
          continue;
        case 7:
          if (tag !== 56) {
            break;
          }
          message.features3d = reader.bool();
          continue;
        case 8:
          if (tag !== 64) {
            break;
          }
          message.featuresLive = reader.bool();
          continue;
        case 9:
          if (tag !== 72) {
            break;
          }
          message.featuresPurchased = reader.bool();
          continue;
        case 14:
          if (tag !== 112) {
            break;
          }
          message.features4k = reader.bool();
          continue;
        case 15:
          if (tag !== 120) {
            break;
          }
          message.features360 = reader.bool();
          continue;
        case 23:
          if (tag !== 184) {
            break;
          }
          message.featuresLocation = reader.bool();
          continue;
        case 25:
          if (tag !== 200) {
            break;
          }
          message.featuresHdr = reader.bool();
          continue;
        case 26:
          if (tag !== 208) {
            break;
          }
          message.featuresVr180 = reader.bool();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseSearchFilter_Filters_MusicSearchType() {
  return { song: void 0, video: void 0, album: void 0, artist: void 0, playlist: void 0 };
}
__name(createBaseSearchFilter_Filters_MusicSearchType, "createBaseSearchFilter_Filters_MusicSearchType");
var SearchFilter_Filters_MusicSearchType = {
  encode(message, writer = new BinaryWriter()) {
    if (message.song !== void 0) {
      writer.uint32(8).bool(message.song);
    }
    if (message.video !== void 0) {
      writer.uint32(16).bool(message.video);
    }
    if (message.album !== void 0) {
      writer.uint32(24).bool(message.album);
    }
    if (message.artist !== void 0) {
      writer.uint32(32).bool(message.artist);
    }
    if (message.playlist !== void 0) {
      writer.uint32(40).bool(message.playlist);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseSearchFilter_Filters_MusicSearchType();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.song = reader.bool();
          continue;
        case 2:
          if (tag !== 16) {
            break;
          }
          message.video = reader.bool();
          continue;
        case 3:
          if (tag !== 24) {
            break;
          }
          message.album = reader.bool();
          continue;
        case 4:
          if (tag !== 32) {
            break;
          }
          message.artist = reader.bool();
          continue;
        case 5:
          if (tag !== 40) {
            break;
          }
          message.playlist = reader.bool();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseNotificationPreferences() {
  return { channelId: "", prefId: void 0, number0: void 0, number1: void 0 };
}
__name(createBaseNotificationPreferences, "createBaseNotificationPreferences");
var NotificationPreferences = {
  encode(message, writer = new BinaryWriter()) {
    if (message.channelId !== "") {
      writer.uint32(10).string(message.channelId);
    }
    if (message.prefId !== void 0) {
      NotificationPreferences_Preference.encode(message.prefId, writer.uint32(18).fork()).join();
    }
    if (message.number0 !== void 0) {
      writer.uint32(24).int32(message.number0);
    }
    if (message.number1 !== void 0) {
      writer.uint32(32).int32(message.number1);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseNotificationPreferences();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.channelId = reader.string();
          continue;
        case 2:
          if (tag !== 18) {
            break;
          }
          message.prefId = NotificationPreferences_Preference.decode(reader, reader.uint32());
          continue;
        case 3:
          if (tag !== 24) {
            break;
          }
          message.number0 = reader.int32();
          continue;
        case 4:
          if (tag !== 32) {
            break;
          }
          message.number1 = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseNotificationPreferences_Preference() {
  return { index: 0 };
}
__name(createBaseNotificationPreferences_Preference, "createBaseNotificationPreferences_Preference");
var NotificationPreferences_Preference = {
  encode(message, writer = new BinaryWriter()) {
    if (message.index !== 0) {
      writer.uint32(8).int32(message.index);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseNotificationPreferences_Preference();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.index = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseLiveMessageParams() {
  return { params: void 0, number0: void 0, number1: void 0 };
}
__name(createBaseLiveMessageParams, "createBaseLiveMessageParams");
var LiveMessageParams = {
  encode(message, writer = new BinaryWriter()) {
    if (message.params !== void 0) {
      LiveMessageParams_Params.encode(message.params, writer.uint32(10).fork()).join();
    }
    if (message.number0 !== void 0) {
      writer.uint32(16).int32(message.number0);
    }
    if (message.number1 !== void 0) {
      writer.uint32(24).int32(message.number1);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseLiveMessageParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.params = LiveMessageParams_Params.decode(reader, reader.uint32());
          continue;
        case 2:
          if (tag !== 16) {
            break;
          }
          message.number0 = reader.int32();
          continue;
        case 3:
          if (tag !== 24) {
            break;
          }
          message.number1 = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseLiveMessageParams_Params() {
  return { ids: void 0 };
}
__name(createBaseLiveMessageParams_Params, "createBaseLiveMessageParams_Params");
var LiveMessageParams_Params = {
  encode(message, writer = new BinaryWriter()) {
    if (message.ids !== void 0) {
      LiveMessageParams_Params_Ids.encode(message.ids, writer.uint32(42).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseLiveMessageParams_Params();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 5:
          if (tag !== 42) {
            break;
          }
          message.ids = LiveMessageParams_Params_Ids.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseLiveMessageParams_Params_Ids() {
  return { channelId: "", videoId: "" };
}
__name(createBaseLiveMessageParams_Params_Ids, "createBaseLiveMessageParams_Params_Ids");
var LiveMessageParams_Params_Ids = {
  encode(message, writer = new BinaryWriter()) {
    if (message.channelId !== "") {
      writer.uint32(10).string(message.channelId);
    }
    if (message.videoId !== "") {
      writer.uint32(18).string(message.videoId);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseLiveMessageParams_Params_Ids();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.channelId = reader.string();
          continue;
        case 2:
          if (tag !== 18) {
            break;
          }
          message.videoId = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetCommentsSectionParams() {
  return { ctx: void 0, unkParam: 0, params: void 0 };
}
__name(createBaseGetCommentsSectionParams, "createBaseGetCommentsSectionParams");
var GetCommentsSectionParams = {
  encode(message, writer = new BinaryWriter()) {
    if (message.ctx !== void 0) {
      GetCommentsSectionParams_Context.encode(message.ctx, writer.uint32(18).fork()).join();
    }
    if (message.unkParam !== 0) {
      writer.uint32(24).int32(message.unkParam);
    }
    if (message.params !== void 0) {
      GetCommentsSectionParams_Params.encode(message.params, writer.uint32(50).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetCommentsSectionParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.ctx = GetCommentsSectionParams_Context.decode(reader, reader.uint32());
          continue;
        case 3:
          if (tag !== 24) {
            break;
          }
          message.unkParam = reader.int32();
          continue;
        case 6:
          if (tag !== 50) {
            break;
          }
          message.params = GetCommentsSectionParams_Params.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetCommentsSectionParams_Context() {
  return { videoId: "" };
}
__name(createBaseGetCommentsSectionParams_Context, "createBaseGetCommentsSectionParams_Context");
var GetCommentsSectionParams_Context = {
  encode(message, writer = new BinaryWriter()) {
    if (message.videoId !== "") {
      writer.uint32(18).string(message.videoId);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetCommentsSectionParams_Context();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.videoId = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetCommentsSectionParams_Params() {
  return { unkToken: void 0, opts: void 0, repliesOpts: void 0, page: void 0, target: "" };
}
__name(createBaseGetCommentsSectionParams_Params, "createBaseGetCommentsSectionParams_Params");
var GetCommentsSectionParams_Params = {
  encode(message, writer = new BinaryWriter()) {
    if (message.unkToken !== void 0) {
      writer.uint32(10).string(message.unkToken);
    }
    if (message.opts !== void 0) {
      GetCommentsSectionParams_Params_Options.encode(message.opts, writer.uint32(34).fork()).join();
    }
    if (message.repliesOpts !== void 0) {
      GetCommentsSectionParams_Params_RepliesOptions.encode(message.repliesOpts, writer.uint32(26).fork()).join();
    }
    if (message.page !== void 0) {
      writer.uint32(40).int32(message.page);
    }
    if (message.target !== "") {
      writer.uint32(66).string(message.target);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetCommentsSectionParams_Params();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.unkToken = reader.string();
          continue;
        case 4:
          if (tag !== 34) {
            break;
          }
          message.opts = GetCommentsSectionParams_Params_Options.decode(reader, reader.uint32());
          continue;
        case 3:
          if (tag !== 26) {
            break;
          }
          message.repliesOpts = GetCommentsSectionParams_Params_RepliesOptions.decode(reader, reader.uint32());
          continue;
        case 5:
          if (tag !== 40) {
            break;
          }
          message.page = reader.int32();
          continue;
        case 8:
          if (tag !== 66) {
            break;
          }
          message.target = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetCommentsSectionParams_Params_Options() {
  return { videoId: "", sortBy: 0, type: 0, commentId: void 0 };
}
__name(createBaseGetCommentsSectionParams_Params_Options, "createBaseGetCommentsSectionParams_Params_Options");
var GetCommentsSectionParams_Params_Options = {
  encode(message, writer = new BinaryWriter()) {
    if (message.videoId !== "") {
      writer.uint32(34).string(message.videoId);
    }
    if (message.sortBy !== 0) {
      writer.uint32(48).int32(message.sortBy);
    }
    if (message.type !== 0) {
      writer.uint32(120).int32(message.type);
    }
    if (message.commentId !== void 0) {
      writer.uint32(130).string(message.commentId);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetCommentsSectionParams_Params_Options();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 4:
          if (tag !== 34) {
            break;
          }
          message.videoId = reader.string();
          continue;
        case 6:
          if (tag !== 48) {
            break;
          }
          message.sortBy = reader.int32();
          continue;
        case 15:
          if (tag !== 120) {
            break;
          }
          message.type = reader.int32();
          continue;
        case 16:
          if (tag !== 130) {
            break;
          }
          message.commentId = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetCommentsSectionParams_Params_RepliesOptions() {
  return { commentId: "", unkopts: void 0, channelId: void 0, videoId: "", unkParam1: 0, unkParam2: 0 };
}
__name(createBaseGetCommentsSectionParams_Params_RepliesOptions, "createBaseGetCommentsSectionParams_Params_RepliesOptions");
var GetCommentsSectionParams_Params_RepliesOptions = {
  encode(message, writer = new BinaryWriter()) {
    if (message.commentId !== "") {
      writer.uint32(18).string(message.commentId);
    }
    if (message.unkopts !== void 0) {
      GetCommentsSectionParams_Params_RepliesOptions_UnkOpts.encode(message.unkopts, writer.uint32(34).fork()).join();
    }
    if (message.channelId !== void 0) {
      writer.uint32(42).string(message.channelId);
    }
    if (message.videoId !== "") {
      writer.uint32(50).string(message.videoId);
    }
    if (message.unkParam1 !== 0) {
      writer.uint32(64).int32(message.unkParam1);
    }
    if (message.unkParam2 !== 0) {
      writer.uint32(72).int32(message.unkParam2);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetCommentsSectionParams_Params_RepliesOptions();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.commentId = reader.string();
          continue;
        case 4:
          if (tag !== 34) {
            break;
          }
          message.unkopts = GetCommentsSectionParams_Params_RepliesOptions_UnkOpts.decode(reader, reader.uint32());
          continue;
        case 5:
          if (tag !== 42) {
            break;
          }
          message.channelId = reader.string();
          continue;
        case 6:
          if (tag !== 50) {
            break;
          }
          message.videoId = reader.string();
          continue;
        case 8:
          if (tag !== 64) {
            break;
          }
          message.unkParam1 = reader.int32();
          continue;
        case 9:
          if (tag !== 72) {
            break;
          }
          message.unkParam2 = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseGetCommentsSectionParams_Params_RepliesOptions_UnkOpts() {
  return { unkParam: 0 };
}
__name(createBaseGetCommentsSectionParams_Params_RepliesOptions_UnkOpts, "createBaseGetCommentsSectionParams_Params_RepliesOptions_UnkOpts");
var GetCommentsSectionParams_Params_RepliesOptions_UnkOpts = {
  encode(message, writer = new BinaryWriter()) {
    if (message.unkParam !== 0) {
      writer.uint32(8).int32(message.unkParam);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseGetCommentsSectionParams_Params_RepliesOptions_UnkOpts();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.unkParam = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCreateCommentParams() {
  return { videoId: "", params: void 0, number: 0 };
}
__name(createBaseCreateCommentParams, "createBaseCreateCommentParams");
var CreateCommentParams = {
  encode(message, writer = new BinaryWriter()) {
    if (message.videoId !== "") {
      writer.uint32(18).string(message.videoId);
    }
    if (message.params !== void 0) {
      CreateCommentParams_Params.encode(message.params, writer.uint32(42).fork()).join();
    }
    if (message.number !== 0) {
      writer.uint32(80).int32(message.number);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCreateCommentParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.videoId = reader.string();
          continue;
        case 5:
          if (tag !== 42) {
            break;
          }
          message.params = CreateCommentParams_Params.decode(reader, reader.uint32());
          continue;
        case 10:
          if (tag !== 80) {
            break;
          }
          message.number = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCreateCommentParams_Params() {
  return { index: 0 };
}
__name(createBaseCreateCommentParams_Params, "createBaseCreateCommentParams_Params");
var CreateCommentParams_Params = {
  encode(message, writer = new BinaryWriter()) {
    if (message.index !== 0) {
      writer.uint32(8).int32(message.index);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCreateCommentParams_Params();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.index = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePeformCommentActionParams() {
  return {
    type: 0,
    commentId: "",
    videoId: "",
    unkNum: void 0,
    channelId: void 0,
    translateCommentParams: void 0
  };
}
__name(createBasePeformCommentActionParams, "createBasePeformCommentActionParams");
var PeformCommentActionParams = {
  encode(message, writer = new BinaryWriter()) {
    if (message.type !== 0) {
      writer.uint32(8).int32(message.type);
    }
    if (message.commentId !== "") {
      writer.uint32(26).string(message.commentId);
    }
    if (message.videoId !== "") {
      writer.uint32(42).string(message.videoId);
    }
    if (message.unkNum !== void 0) {
      writer.uint32(16).int32(message.unkNum);
    }
    if (message.channelId !== void 0) {
      writer.uint32(186).string(message.channelId);
    }
    if (message.translateCommentParams !== void 0) {
      PeformCommentActionParams_TranslateCommentParams.encode(message.translateCommentParams, writer.uint32(250).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePeformCommentActionParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 8) {
            break;
          }
          message.type = reader.int32();
          continue;
        case 3:
          if (tag !== 26) {
            break;
          }
          message.commentId = reader.string();
          continue;
        case 5:
          if (tag !== 42) {
            break;
          }
          message.videoId = reader.string();
          continue;
        case 2:
          if (tag !== 16) {
            break;
          }
          message.unkNum = reader.int32();
          continue;
        case 23:
          if (tag !== 186) {
            break;
          }
          message.channelId = reader.string();
          continue;
        case 31:
          if (tag !== 250) {
            break;
          }
          message.translateCommentParams = PeformCommentActionParams_TranslateCommentParams.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePeformCommentActionParams_TranslateCommentParams() {
  return { params: void 0, commentId: "", targetLanguage: "" };
}
__name(createBasePeformCommentActionParams_TranslateCommentParams, "createBasePeformCommentActionParams_TranslateCommentParams");
var PeformCommentActionParams_TranslateCommentParams = {
  encode(message, writer = new BinaryWriter()) {
    if (message.params !== void 0) {
      PeformCommentActionParams_TranslateCommentParams_Params.encode(message.params, writer.uint32(26).fork()).join();
    }
    if (message.commentId !== "") {
      writer.uint32(18).string(message.commentId);
    }
    if (message.targetLanguage !== "") {
      writer.uint32(34).string(message.targetLanguage);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePeformCommentActionParams_TranslateCommentParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 3:
          if (tag !== 26) {
            break;
          }
          message.params = PeformCommentActionParams_TranslateCommentParams_Params.decode(reader, reader.uint32());
          continue;
        case 2:
          if (tag !== 18) {
            break;
          }
          message.commentId = reader.string();
          continue;
        case 4:
          if (tag !== 34) {
            break;
          }
          message.targetLanguage = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePeformCommentActionParams_TranslateCommentParams_Params() {
  return { comment: void 0 };
}
__name(createBasePeformCommentActionParams_TranslateCommentParams_Params, "createBasePeformCommentActionParams_TranslateCommentParams_Params");
var PeformCommentActionParams_TranslateCommentParams_Params = {
  encode(message, writer = new BinaryWriter()) {
    if (message.comment !== void 0) {
      PeformCommentActionParams_TranslateCommentParams_Params_Comment.encode(message.comment, writer.uint32(10).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePeformCommentActionParams_TranslateCommentParams_Params();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.comment = PeformCommentActionParams_TranslateCommentParams_Params_Comment.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBasePeformCommentActionParams_TranslateCommentParams_Params_Comment() {
  return { text: "" };
}
__name(createBasePeformCommentActionParams_TranslateCommentParams_Params_Comment, "createBasePeformCommentActionParams_TranslateCommentParams_Params_Comment");
var PeformCommentActionParams_TranslateCommentParams_Params_Comment = {
  encode(message, writer = new BinaryWriter()) {
    if (message.text !== "") {
      writer.uint32(10).string(message.text);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBasePeformCommentActionParams_TranslateCommentParams_Params_Comment();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.text = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseHashtag() {
  return { params: void 0 };
}
__name(createBaseHashtag, "createBaseHashtag");
var Hashtag = {
  encode(message, writer = new BinaryWriter()) {
    if (message.params !== void 0) {
      Hashtag_Params.encode(message.params, writer.uint32(746).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseHashtag();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 93:
          if (tag !== 746) {
            break;
          }
          message.params = Hashtag_Params.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseHashtag_Params() {
  return { hashtag: "", type: 0 };
}
__name(createBaseHashtag_Params, "createBaseHashtag_Params");
var Hashtag_Params = {
  encode(message, writer = new BinaryWriter()) {
    if (message.hashtag !== "") {
      writer.uint32(10).string(message.hashtag);
    }
    if (message.type !== 0) {
      writer.uint32(24).int32(message.type);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseHashtag_Params();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.hashtag = reader.string();
          continue;
        case 3:
          if (tag !== 24) {
            break;
          }
          message.type = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseReelSequence() {
  return { shortId: "", params: void 0, feature2: 0, feature3: 0 };
}
__name(createBaseReelSequence, "createBaseReelSequence");
var ReelSequence = {
  encode(message, writer = new BinaryWriter()) {
    if (message.shortId !== "") {
      writer.uint32(10).string(message.shortId);
    }
    if (message.params !== void 0) {
      ReelSequence_Params.encode(message.params, writer.uint32(42).fork()).join();
    }
    if (message.feature2 !== 0) {
      writer.uint32(80).int32(message.feature2);
    }
    if (message.feature3 !== 0) {
      writer.uint32(104).int32(message.feature3);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseReelSequence();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.shortId = reader.string();
          continue;
        case 5:
          if (tag !== 42) {
            break;
          }
          message.params = ReelSequence_Params.decode(reader, reader.uint32());
          continue;
        case 10:
          if (tag !== 80) {
            break;
          }
          message.feature2 = reader.int32();
          continue;
        case 13:
          if (tag !== 104) {
            break;
          }
          message.feature3 = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseReelSequence_Params() {
  return { number: 0 };
}
__name(createBaseReelSequence_Params, "createBaseReelSequence_Params");
var ReelSequence_Params = {
  encode(message, writer = new BinaryWriter()) {
    if (message.number !== 0) {
      writer.uint32(24).int32(message.number);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseReelSequence_Params();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 3:
          if (tag !== 24) {
            break;
          }
          message.number = reader.int32();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseNextParams() {
  return { videoId: [] };
}
__name(createBaseNextParams, "createBaseNextParams");
var NextParams = {
  encode(message, writer = new BinaryWriter()) {
    for (const v of message.videoId) {
      writer.uint32(42).string(v);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseNextParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 5:
          if (tag !== 42) {
            break;
          }
          message.videoId.push(reader.string());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostParams() {
  return { f1: void 0 };
}
__name(createBaseCommunityPostParams, "createBaseCommunityPostParams");
var CommunityPostParams = {
  encode(message, writer = new BinaryWriter()) {
    if (message.f1 !== void 0) {
      CommunityPostParams_Field1.encode(message.f1, writer.uint32(450).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostParams();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 56:
          if (tag !== 450) {
            break;
          }
          message.f1 = CommunityPostParams_Field1.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostParams_Field1() {
  return { ucid1: "", postId: "", ucid2: "" };
}
__name(createBaseCommunityPostParams_Field1, "createBaseCommunityPostParams_Field1");
var CommunityPostParams_Field1 = {
  encode(message, writer = new BinaryWriter()) {
    if (message.ucid1 !== "") {
      writer.uint32(18).string(message.ucid1);
    }
    if (message.postId !== "") {
      writer.uint32(26).string(message.postId);
    }
    if (message.ucid2 !== "") {
      writer.uint32(90).string(message.ucid2);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostParams_Field1();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.ucid1 = reader.string();
          continue;
        case 3:
          if (tag !== 26) {
            break;
          }
          message.postId = reader.string();
          continue;
        case 11:
          if (tag !== 90) {
            break;
          }
          message.ucid2 = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostCommentsParamContainer() {
  return { f0: void 0 };
}
__name(createBaseCommunityPostCommentsParamContainer, "createBaseCommunityPostCommentsParamContainer");
var CommunityPostCommentsParamContainer = {
  encode(message, writer = new BinaryWriter()) {
    if (message.f0 !== void 0) {
      CommunityPostCommentsParamContainer_Container.encode(message.f0, writer.uint32(641815778).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostCommentsParamContainer();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 80226972:
          if (tag !== 641815778) {
            break;
          }
          message.f0 = CommunityPostCommentsParamContainer_Container.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostCommentsParamContainer_Container() {
  return { location: "", protoData: "" };
}
__name(createBaseCommunityPostCommentsParamContainer_Container, "createBaseCommunityPostCommentsParamContainer_Container");
var CommunityPostCommentsParamContainer_Container = {
  encode(message, writer = new BinaryWriter()) {
    if (message.location !== "") {
      writer.uint32(18).string(message.location);
    }
    if (message.protoData !== "") {
      writer.uint32(26).string(message.protoData);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostCommentsParamContainer_Container();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.location = reader.string();
          continue;
        case 3:
          if (tag !== 26) {
            break;
          }
          message.protoData = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostCommentsParam() {
  return { title: "", commentDataContainer: void 0 };
}
__name(createBaseCommunityPostCommentsParam, "createBaseCommunityPostCommentsParam");
var CommunityPostCommentsParam = {
  encode(message, writer = new BinaryWriter()) {
    if (message.title !== "") {
      writer.uint32(18).string(message.title);
    }
    if (message.commentDataContainer !== void 0) {
      CommunityPostCommentsParam_CommentDataContainer.encode(message.commentDataContainer, writer.uint32(426).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostCommentsParam();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 2:
          if (tag !== 18) {
            break;
          }
          message.title = reader.string();
          continue;
        case 53:
          if (tag !== 426) {
            break;
          }
          message.commentDataContainer = CommunityPostCommentsParam_CommentDataContainer.decode(reader, reader.uint32());
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostCommentsParam_CommentDataContainer() {
  return { commentData: void 0, f0: 0, title: "" };
}
__name(createBaseCommunityPostCommentsParam_CommentDataContainer, "createBaseCommunityPostCommentsParam_CommentDataContainer");
var CommunityPostCommentsParam_CommentDataContainer = {
  encode(message, writer = new BinaryWriter()) {
    if (message.commentData !== void 0) {
      CommunityPostCommentsParam_CommentDataContainer_CommentData.encode(message.commentData, writer.uint32(34).fork()).join();
    }
    if (message.f0 !== 0) {
      writer.uint32(56).int32(message.f0);
    }
    if (message.title !== "") {
      writer.uint32(66).string(message.title);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostCommentsParam_CommentDataContainer();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 4:
          if (tag !== 34) {
            break;
          }
          message.commentData = CommunityPostCommentsParam_CommentDataContainer_CommentData.decode(reader, reader.uint32());
          continue;
        case 7:
          if (tag !== 56) {
            break;
          }
          message.f0 = reader.int32();
          continue;
        case 8:
          if (tag !== 66) {
            break;
          }
          message.title = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseCommunityPostCommentsParam_CommentDataContainer_CommentData() {
  return { sortBy: 0, f0: 0, f1: 0, postId: "", channelId: "" };
}
__name(createBaseCommunityPostCommentsParam_CommentDataContainer_CommentData, "createBaseCommunityPostCommentsParam_CommentDataContainer_CommentData");
var CommunityPostCommentsParam_CommentDataContainer_CommentData = {
  encode(message, writer = new BinaryWriter()) {
    if (message.sortBy !== 0) {
      writer.uint32(48).int32(message.sortBy);
    }
    if (message.f0 !== 0) {
      writer.uint32(120).int32(message.f0);
    }
    if (message.f1 !== 0) {
      writer.uint32(200).int32(message.f1);
    }
    if (message.postId !== "") {
      writer.uint32(234).string(message.postId);
    }
    if (message.channelId !== "") {
      writer.uint32(242).string(message.channelId);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseCommunityPostCommentsParam_CommentDataContainer_CommentData();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 6:
          if (tag !== 48) {
            break;
          }
          message.sortBy = reader.int32();
          continue;
        case 15:
          if (tag !== 120) {
            break;
          }
          message.f0 = reader.int32();
          continue;
        case 25:
          if (tag !== 200) {
            break;
          }
          message.f1 = reader.int32();
          continue;
        case 29:
          if (tag !== 234) {
            break;
          }
          message.postId = reader.string();
          continue;
        case 30:
          if (tag !== 242) {
            break;
          }
          message.channelId = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};

// dist/src/utils/ProtoUtils.js
function encodeVisitorData(id, timestamp) {
  const writer = VisitorData.encode({ id, timestamp });
  return encodeURIComponent(u8ToBase64(writer.finish()).replace(/\+/g, "-").replace(/\//g, "_"));
}
__name(encodeVisitorData, "encodeVisitorData");
function decodeVisitorData(visitor_data) {
  return VisitorData.decode(base64ToU8(decodeURIComponent(visitor_data).replace(/-/g, "+").replace(/_/g, "/")));
}
__name(decodeVisitorData, "decodeVisitorData");
function encodeCommentActionParams(type, args = {}) {
  const data2 = {
    type,
    commentId: args.comment_id || " ",
    videoId: args.video_id || " ",
    channelId: " ",
    unkNum: 2
  };
  if (args.hasOwnProperty("text")) {
    if (typeof args.target_language !== "string")
      throw new Error("target_language must be a string");
    if (args.comment_id)
      delete data2.unkNum;
    data2.translateCommentParams = {
      params: {
        comment: {
          text: args.text
        }
      },
      commentId: args.comment_id || " ",
      targetLanguage: args.target_language
    };
  }
  const writer = PeformCommentActionParams.encode(data2);
  return encodeURIComponent(u8ToBase64(writer.finish()));
}
__name(encodeCommentActionParams, "encodeCommentActionParams");
function encodeNextParams(video_ids) {
  const writer = NextParams.encode({ videoId: video_ids });
  return encodeURIComponent(u8ToBase64(writer.finish()).replace(/\+/g, "-").replace(/\//g, "_"));
}
__name(encodeNextParams, "encodeNextParams");

// dist/src/parser/classes/actions/OpenPopupAction.js
var _OpenPopupAction = class _OpenPopupAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "popup");
    __publicField(this, "popup_type");
    this.popup = parser_exports.parseItem(data2.popup);
    this.popup_type = data2.popupType;
  }
};
__name(_OpenPopupAction, "OpenPopupAction");
__publicField(_OpenPopupAction, "type", "OpenPopupAction");
var OpenPopupAction = _OpenPopupAction;

// dist/src/parser/classes/Button.js
var _Button = class _Button extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "label");
    __publicField(this, "tooltip");
    __publicField(this, "style");
    __publicField(this, "size");
    __publicField(this, "icon_type");
    __publicField(this, "is_disabled");
    __publicField(this, "target_id");
    __publicField(this, "endpoint");
    __publicField(this, "accessibility");
    if (Reflect.has(data2, "text"))
      this.text = new Text2(data2.text).toString();
    if (Reflect.has(data2, "accessibility") && Reflect.has(data2.accessibility, "label")) {
      this.label = data2.accessibility.label;
    }
    if ("accessibilityData" in data2 && "accessibilityData" in data2.accessibilityData) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data2.accessibilityData.accessibilityData)
      };
    }
    if (Reflect.has(data2, "tooltip"))
      this.tooltip = data2.tooltip;
    if (Reflect.has(data2, "style"))
      this.style = data2.style;
    if (Reflect.has(data2, "size"))
      this.size = data2.size;
    if (Reflect.has(data2, "icon") && Reflect.has(data2.icon, "iconType"))
      this.icon_type = data2.icon.iconType;
    if (Reflect.has(data2, "isDisabled"))
      this.is_disabled = data2.isDisabled;
    if (Reflect.has(data2, "targetId"))
      this.target_id = data2.targetId;
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint || data2.serviceEndpoint || data2.command);
  }
};
__name(_Button, "Button");
__publicField(_Button, "type", "Button");
var Button = _Button;

// dist/src/parser/classes/DropdownItem.js
var _DropdownItem = class _DropdownItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "label");
    __publicField(this, "selected");
    __publicField(this, "value");
    __publicField(this, "icon_type");
    __publicField(this, "description");
    __publicField(this, "endpoint");
    this.label = new Text2(data2.label).toString();
    this.selected = !!data2.isSelected;
    if (Reflect.has(data2, "int32Value")) {
      this.value = data2.int32Value;
    } else if (data2.stringValue) {
      this.value = data2.stringValue;
    }
    if (Reflect.has(data2, "onSelectCommand")) {
      this.endpoint = new NavigationEndpoint(data2.onSelectCommand);
    }
    if (Reflect.has(data2, "icon")) {
      this.icon_type = data2.icon?.iconType;
    }
    if (Reflect.has(data2, "descriptionText")) {
      this.description = new Text2(data2.descriptionText);
    }
  }
};
__name(_DropdownItem, "DropdownItem");
__publicField(_DropdownItem, "type", "DropdownItem");
var DropdownItem = _DropdownItem;

// dist/src/parser/classes/Dropdown.js
var _Dropdown = class _Dropdown extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "label");
    __publicField(this, "entries");
    this.label = data2.label || "";
    this.entries = parser_exports.parseArray(data2.entries, DropdownItem);
  }
};
__name(_Dropdown, "Dropdown");
__publicField(_Dropdown, "type", "Dropdown");
var Dropdown = _Dropdown;

// dist/src/parser/classes/CreatePlaylistDialog.js
var _CreatePlaylistDialog = class _CreatePlaylistDialog extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "title_placeholder");
    __publicField(this, "privacy_option");
    __publicField(this, "cancel_button");
    __publicField(this, "create_button");
    this.title = new Text2(data2.dialogTitle).toString();
    this.title_placeholder = data2.titlePlaceholder || "";
    this.privacy_option = parser_exports.parseItem(data2.privacyOption, Dropdown);
    this.create_button = parser_exports.parseItem(data2.cancelButton, Button);
    this.cancel_button = parser_exports.parseItem(data2.cancelButton, Button);
  }
};
__name(_CreatePlaylistDialog, "CreatePlaylistDialog");
__publicField(_CreatePlaylistDialog, "type", "CreatePlaylistDialog");
var CreatePlaylistDialog = _CreatePlaylistDialog;

// dist/src/parser/classes/commands/CommandExecutorCommand.js
var _CommandExecutorCommand = class _CommandExecutorCommand extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "commands");
    this.commands = parser_exports.parseCommands(data2.commands);
  }
};
__name(_CommandExecutorCommand, "CommandExecutorCommand");
__publicField(_CommandExecutorCommand, "type", "CommandExecutorCommand");
var CommandExecutorCommand = _CommandExecutorCommand;

// dist/src/parser/classes/NavigationEndpoint.js
var _NavigationEndpoint = class _NavigationEndpoint extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "name");
    __publicField(this, "payload");
    __publicField(this, "dialog");
    __publicField(this, "modal");
    __publicField(this, "open_popup");
    __publicField(this, "next_endpoint");
    __publicField(this, "metadata");
    __publicField(this, "command");
    __publicField(this, "commands");
    if (data2) {
      if (data2.serialCommand || data2.parallelCommand) {
        const raw_command = data2.serialCommand || data2.parallelCommand;
        this.commands = raw_command.commands.map((command) => new _NavigationEndpoint(command));
      }
      if (data2.innertubeCommand || data2.command || data2.performOnceCommand) {
        data2 = data2.innertubeCommand || data2.command || data2.performOnceCommand;
      }
    }
    this.command = parser_exports.parseCommand(data2);
    if (Reflect.has(data2 || {}, "openPopupAction"))
      this.open_popup = new OpenPopupAction(data2.openPopupAction);
    this.name = Object.keys(data2 || {}).find((item) => item.endsWith("Endpoint") || item.endsWith("Command"));
    this.payload = this.name ? Reflect.get(data2, this.name) : {};
    if (Reflect.has(this.payload, "dialog") || Reflect.has(this.payload, "content")) {
      this.dialog = parser_exports.parseItem(this.payload.dialog || this.payload.content);
    }
    if (Reflect.has(this.payload, "modal")) {
      this.modal = parser_exports.parseItem(this.payload.modal);
    }
    if (Reflect.has(this.payload, "nextEndpoint")) {
      this.next_endpoint = new _NavigationEndpoint(this.payload.nextEndpoint);
    }
    if (data2?.serviceEndpoint) {
      data2 = data2.serviceEndpoint;
    }
    this.metadata = {};
    if (data2?.commandMetadata?.webCommandMetadata?.url) {
      this.metadata.url = data2.commandMetadata.webCommandMetadata.url;
    }
    if (data2?.commandMetadata?.webCommandMetadata?.webPageType) {
      this.metadata.page_type = data2.commandMetadata.webCommandMetadata.webPageType;
    }
    if (data2?.commandMetadata?.webCommandMetadata?.apiUrl) {
      this.metadata.api_url = data2.commandMetadata.webCommandMetadata.apiUrl.replace("/youtubei/v1/", "");
    } else if (this.name) {
      this.metadata.api_url = this.getPath(this.name);
    }
    if (data2?.commandMetadata?.webCommandMetadata?.sendPost) {
      this.metadata.send_post = data2.commandMetadata.webCommandMetadata.sendPost;
    }
    if (data2?.createPlaylistEndpoint) {
      if (data2?.createPlaylistEndpoint.createPlaylistDialog) {
        this.dialog = parser_exports.parseItem(data2?.createPlaylistEndpoint.createPlaylistDialog, CreatePlaylistDialog);
      }
    }
  }
  /**
   * Sometimes InnerTube does not return an API url, in that case the library should set it based on the name of the payload object.
   * @deprecated This should be removed in the future.
   */
  getPath(name) {
    switch (name) {
      case "browseEndpoint":
        return "/browse";
      case "watchEndpoint":
      case "reelWatchEndpoint":
        return "/player";
      case "searchEndpoint":
        return "/search";
      case "watchPlaylistEndpoint":
        return "/next";
      case "liveChatItemContextMenuEndpoint":
        return "/live_chat/get_item_context_menu";
    }
  }
  call(actions, args) {
    if (!actions)
      throw new Error("An API caller must be provided");
    if (this.command) {
      let command = this.command;
      if (command.is(CommandExecutorCommand)) {
        command = command.commands.at(-1);
      }
      return actions.execute(command.getApiPath(), { ...command.buildRequest(), ...args });
    }
    if (!this.metadata.api_url)
      throw new Error("Expected an api_url, but none was found.");
    return actions.execute(this.metadata.api_url, { ...this.payload, ...args });
  }
  toURL() {
    if (!this.metadata.url)
      return void 0;
    if (!this.metadata.page_type)
      return void 0;
    return this.metadata.page_type === "WEB_PAGE_TYPE_UNKNOWN" ? this.metadata.url : `https://www.youtube.com${this.metadata.url}`;
  }
};
__name(_NavigationEndpoint, "NavigationEndpoint");
__publicField(_NavigationEndpoint, "type", "NavigationEndpoint");
var NavigationEndpoint = _NavigationEndpoint;

// dist/src/parser/classes/misc/Thumbnail.js
var _Thumbnail = class _Thumbnail {
  constructor(data2) {
    __publicField(this, "url");
    __publicField(this, "width");
    __publicField(this, "height");
    this.url = data2.url;
    this.width = data2.width;
    this.height = data2.height;
  }
  /**
   * Get thumbnails from response object.
   */
  static fromResponse(data2) {
    if (!data2)
      return [];
    let thumbnail_data;
    if (data2.thumbnails) {
      thumbnail_data = data2.thumbnails;
    } else if (data2.sources) {
      thumbnail_data = data2.sources;
    }
    if (thumbnail_data) {
      return thumbnail_data.map((x) => new _Thumbnail(x)).sort((a, b) => b.width - a.width);
    }
    return [];
  }
};
__name(_Thumbnail, "Thumbnail");
var Thumbnail = _Thumbnail;

// dist/src/parser/classes/misc/EmojiRun.js
var _EmojiRun = class _EmojiRun {
  constructor(data2) {
    __publicField(this, "text");
    __publicField(this, "emoji");
    this.text = data2.emoji?.emojiId || data2.emoji?.shortcuts?.[0] || data2.text || "";
    this.emoji = {
      emoji_id: data2.emoji.emojiId,
      shortcuts: data2.emoji?.shortcuts || [],
      search_terms: data2.emoji?.searchTerms || [],
      image: Thumbnail.fromResponse(data2.emoji.image),
      is_custom: !!data2.emoji?.isCustomEmoji
    };
  }
  toString() {
    return this.text;
  }
  toHTML() {
    const escaped_text = escape(this.text);
    return `<img src="${this.emoji.image[0].url}" alt="${escaped_text}" title="${escaped_text}" style="display: inline-block; vertical-align: text-top; height: var(--yt-emoji-size, 1rem); width: var(--yt-emoji-size, 1rem);" loading="lazy" crossorigin="anonymous" />`;
  }
};
__name(_EmojiRun, "EmojiRun");
var EmojiRun = _EmojiRun;

// dist/src/parser/classes/misc/TextRun.js
var _TextRun = class _TextRun {
  constructor(data2) {
    __publicField(this, "text");
    __publicField(this, "text_color");
    __publicField(this, "endpoint");
    __publicField(this, "bold");
    __publicField(this, "bracket");
    __publicField(this, "dark_mode_text_color");
    __publicField(this, "deemphasize");
    __publicField(this, "italics");
    __publicField(this, "strikethrough");
    __publicField(this, "error_underline");
    __publicField(this, "underline");
    __publicField(this, "font_face");
    __publicField(this, "attachment");
    this.text = data2.text;
    this.bold = Boolean(data2.bold);
    this.bracket = Boolean(data2.bracket);
    this.italics = Boolean(data2.italics);
    this.strikethrough = Boolean(data2.strikethrough);
    this.error_underline = Boolean(data2.error_underline);
    this.underline = Boolean(data2.underline);
    this.deemphasize = Boolean(data2.deemphasize);
    if ("textColor" in data2) {
      this.text_color = data2.textColor;
    }
    if ("navigationEndpoint" in data2) {
      this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    }
    if ("darkModeTextColor" in data2) {
      this.dark_mode_text_color = data2.darkModeTextColor;
    }
    if ("fontFace" in data2) {
      this.font_face = data2.fontFace;
    }
    this.attachment = data2.attachment;
  }
  toString() {
    return this.text;
  }
  toHTML() {
    const tags = [];
    if (this.bold)
      tags.push("b");
    if (this.italics)
      tags.push("i");
    if (this.strikethrough)
      tags.push("s");
    if (this.deemphasize)
      tags.push("small");
    if (this.underline)
      tags.push("u");
    if (this.error_underline)
      tags.push("u");
    if (!this.text?.length)
      return "";
    const escaped_text = escape(this.text);
    const styled_text = tags.map((tag) => `<${tag}>`).join("") + escaped_text + tags.map((tag) => `</${tag}>`).join("");
    const wrapped_text = `<span style="white-space: pre-wrap;">${styled_text}</span>`;
    if (this.attachment) {
      if (this.attachment.element.type.imageType.image.sources.length) {
        if (this.endpoint) {
          const { url } = this.attachment.element.type.imageType.image.sources[0];
          let image_el = "";
          if (url) {
            image_el = `<img src="${url}" style="vertical-align: middle; height: ${this.attachment.element.properties.layoutProperties.height.value}px; width: ${this.attachment.element.properties.layoutProperties.width.value}px;" alt="">`;
          }
          const nav_url = this.endpoint.toURL();
          if (nav_url)
            return `<a href="${nav_url}" class="yt-ch-link">${image_el}${wrapped_text}</a>`;
        }
      }
    }
    if (this.endpoint) {
      const url = this.endpoint.toURL();
      if (url)
        return `<a href="${url}">${wrapped_text}</a>`;
    }
    return wrapped_text;
  }
};
__name(_TextRun, "TextRun");
var TextRun = _TextRun;

// dist/src/parser/classes/misc/Text.js
function escape(text) {
  return text.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&#039;");
}
__name(escape, "escape");
var TAG = "Text";
var _Text = class _Text {
  constructor(data2) {
    /**
     * The plain text content.
     */
    __publicField(this, "text");
    /**
     * Individual text segments with their formatting.
     */
    __publicField(this, "runs");
    /**
     * Navigation endpoint associated with this text.
     */
    __publicField(this, "endpoint");
    /**
     * Accessibility data associated with this text.
     */
    __publicField(this, "accessibility");
    /**
     * Indicates if the text is right-to-left.
     */
    __publicField(this, "rtl");
    if (this.isRunsData(data2)) {
      this.runs = data2.runs.map((run) => run.emoji ? new EmojiRun(run) : new TextRun(run));
      this.text = this.runs.map((run) => run.text).join("");
    } else {
      this.text = data2?.simpleText;
    }
    if (this.isObject(data2) && "accessibility" in data2 && "accessibilityData" in data2.accessibility) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data2.accessibility.accessibilityData)
      };
    }
    this.rtl = !!data2?.rtl;
    this.parseEndpoint(data2);
  }
  isRunsData(data2) {
    return this.isObject(data2) && Reflect.has(data2, "runs") && Array.isArray(data2.runs);
  }
  parseEndpoint(data2) {
    if (!this.isObject(data2))
      return;
    if ("navigationEndpoint" in data2) {
      this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    } else if ("titleNavigationEndpoint" in data2) {
      this.endpoint = new NavigationEndpoint(data2.titleNavigationEndpoint);
    } else if (this.runs?.[0]?.endpoint) {
      this.endpoint = (this.runs?.[0]).endpoint;
    }
  }
  isObject(data2) {
    return typeof data2 === "object" && data2 !== null;
  }
  static fromAttributed(data2) {
    const { content, commandRuns: command_runs, attachmentRuns: attachment_runs } = data2;
    const runs = [
      {
        text: content,
        startIndex: 0
      }
    ];
    const style_runs = data2.styleRuns?.map((run) => ({
      ...run,
      startIndex: run.startIndex ?? 0,
      length: run.length ?? content.length
    }));
    if (style_runs?.length)
      this.processStyleRuns(runs, style_runs, data2);
    if (command_runs?.length)
      this.processCommandRuns(runs, command_runs, data2);
    if (attachment_runs?.length)
      this.processAttachmentRuns(runs, attachment_runs, data2);
    return new _Text({ runs });
  }
  static processStyleRuns(runs, style_runs, data2) {
    for (const style_run of style_runs) {
      if (style_run.italic || style_run.strikethrough === "LINE_STYLE_SINGLE" || style_run.weightLabel === "FONT_WEIGHT_MEDIUM" || style_run.weightLabel === "FONT_WEIGHT_BOLD") {
        const matching_run = findMatchingRun(runs, style_run);
        if (!matching_run) {
          Log_exports.warn(TAG, "Unable to find matching run for style run. Skipping...", {
            style_run,
            input_data: data2,
            // For performance reasons, web browser consoles only expand an object, when the user clicks on it,
            // So if we log the original runs object, it might have changed by the time the user looks at it.
            // Deep clone, so that we log the exact state of the runs at this point.
            parsed_runs: JSON.parse(JSON.stringify(runs))
          });
          continue;
        }
        insertSubRun(runs, matching_run, style_run, {
          bold: style_run.weightLabel === "FONT_WEIGHT_MEDIUM" || style_run.weightLabel === "FONT_WEIGHT_BOLD",
          italics: style_run.italic,
          strikethrough: style_run.strikethrough === "LINE_STYLE_SINGLE"
        });
      } else {
        Log_exports.debug(TAG, "Skipping style run as it is doesn't have any information that we parse.", {
          style_run,
          input_data: data2
        });
      }
    }
  }
  static processCommandRuns(runs, command_runs, data2) {
    for (const command_run of command_runs) {
      if (command_run.onTap) {
        const matching_run = findMatchingRun(runs, command_run);
        if (!matching_run) {
          Log_exports.warn(TAG, "Unable to find matching run for command run. Skipping...", {
            command_run,
            input_data: data2,
            // For performance reasons, web browser consoles only expand an object, when the user clicks on it,
            // So if we log the original runs object, it might have changed by the time the user looks at it.
            // Deep clone, so that we log the exact state of the runs at this point.
            parsed_runs: JSON.parse(JSON.stringify(runs))
          });
          continue;
        }
        insertSubRun(runs, matching_run, command_run, {
          navigationEndpoint: command_run.onTap
        });
      } else {
        Log_exports.debug(TAG, 'Skipping command run as it is missing the "doTap" property.', {
          command_run,
          input_data: data2
        });
      }
    }
  }
  static processAttachmentRuns(runs, attachment_runs, data2) {
    for (const attachment_run of attachment_runs) {
      const matching_run = findMatchingRun(runs, attachment_run);
      if (!matching_run) {
        Log_exports.warn(TAG, "Unable to find matching run for attachment run. Skipping...", {
          attachment_run,
          input_data: data2,
          // For performance reasons, web browser consoles only expand an object, when the user clicks on it,
          // So if we log the original runs object, it might have changed by the time the user looks at it.
          // Deep clone, so that we log the exact state of the runs at this point.
          parsed_runs: JSON.parse(JSON.stringify(runs))
        });
        continue;
      }
      if (attachment_run.length === 0) {
        matching_run.attachment = attachment_run;
      } else {
        const offset_start_index = attachment_run.startIndex - matching_run.startIndex;
        const text = matching_run.text.substring(offset_start_index, offset_start_index + attachment_run.length);
        const is_custom_emoji = /^:[^:]+:$/.test(text);
        if (attachment_run.element?.type?.imageType?.image && (is_custom_emoji || /^(?:\p{Emoji}|\u200d)+$/u.test(text))) {
          const emoji = {
            image: attachment_run.element.type.imageType.image,
            isCustomEmoji: is_custom_emoji,
            shortcuts: is_custom_emoji ? [text] : void 0
          };
          insertSubRun(runs, matching_run, attachment_run, { emoji });
        } else {
          insertSubRun(runs, matching_run, attachment_run, {
            attachment: attachment_run
          });
        }
      }
    }
  }
  /**
   * Converts the text to HTML.
   * @returns The HTML.
   */
  toHTML() {
    return this.runs ? this.runs.map((run) => run.toHTML()).join("") : this.text;
  }
  /**
   * Checks if the text is empty.
   * @returns Whether the text is empty.
   */
  isEmpty() {
    return this.text === void 0;
  }
  /**
   * Converts the text to a string.
   * @returns The text.
   */
  toString() {
    return this.text || "N/A";
  }
};
__name(_Text, "Text");
var Text2 = _Text;
function findMatchingRun(runs, response_run) {
  return runs.find((run) => {
    return run.startIndex <= response_run.startIndex && response_run.startIndex + response_run.length <= run.startIndex + run.text.length;
  });
}
__name(findMatchingRun, "findMatchingRun");
function insertSubRun(runs, original_run, response_run, properties_to_add) {
  const replace_index = runs.indexOf(original_run);
  const replacement_runs = [];
  const offset_start_index = response_run.startIndex - original_run.startIndex;
  if (response_run.startIndex > original_run.startIndex) {
    replacement_runs.push({
      ...original_run,
      text: original_run.text.substring(0, offset_start_index)
    });
  }
  replacement_runs.push({
    ...original_run,
    text: original_run.text.substring(offset_start_index, offset_start_index + response_run.length),
    startIndex: response_run.startIndex,
    ...properties_to_add
  });
  if (response_run.startIndex + response_run.length < original_run.startIndex + original_run.text.length) {
    replacement_runs.push({
      ...original_run,
      text: original_run.text.substring(offset_start_index + response_run.length),
      startIndex: response_run.startIndex + response_run.length
    });
  }
  runs.splice(replace_index, 1, ...replacement_runs);
}
__name(insertSubRun, "insertSubRun");

// dist/src/parser/classes/ChannelExternalLinkView.js
var _ChannelExternalLinkView = class _ChannelExternalLinkView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "link");
    __publicField(this, "favicon");
    this.title = Text2.fromAttributed(data2.title);
    this.link = Text2.fromAttributed(data2.link);
    this.favicon = Thumbnail.fromResponse(data2.favicon);
  }
};
__name(_ChannelExternalLinkView, "ChannelExternalLinkView");
__publicField(_ChannelExternalLinkView, "type", "ChannelExternalLinkView");
var ChannelExternalLinkView = _ChannelExternalLinkView;

// dist/src/parser/classes/AboutChannelView.js
var _AboutChannelView = class _AboutChannelView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "description");
    __publicField(this, "description_label");
    __publicField(this, "country");
    __publicField(this, "custom_links_label");
    __publicField(this, "subscriber_count");
    __publicField(this, "view_count");
    __publicField(this, "joined_date");
    __publicField(this, "canonical_channel_url");
    __publicField(this, "channel_id");
    __publicField(this, "additional_info_label");
    __publicField(this, "custom_url_on_tap");
    __publicField(this, "video_count");
    __publicField(this, "sign_in_for_business_email");
    __publicField(this, "links");
    if (Reflect.has(data2, "description")) {
      this.description = data2.description;
    }
    if (Reflect.has(data2, "descriptionLabel")) {
      this.description_label = Text2.fromAttributed(data2.descriptionLabel);
    }
    if (Reflect.has(data2, "country")) {
      this.country = data2.country;
    }
    if (Reflect.has(data2, "customLinksLabel")) {
      this.custom_links_label = Text2.fromAttributed(data2.customLinksLabel);
    }
    if (Reflect.has(data2, "subscriberCountText")) {
      this.subscriber_count = data2.subscriberCountText;
    }
    if (Reflect.has(data2, "viewCountText")) {
      this.view_count = data2.viewCountText;
    }
    if (Reflect.has(data2, "joinedDateText")) {
      this.joined_date = Text2.fromAttributed(data2.joinedDateText);
    }
    if (Reflect.has(data2, "canonicalChannelUrl")) {
      this.canonical_channel_url = data2.canonicalChannelUrl;
    }
    if (Reflect.has(data2, "channelId")) {
      this.channel_id = data2.channelId;
    }
    if (Reflect.has(data2, "additionalInfoLabel")) {
      this.additional_info_label = Text2.fromAttributed(data2.additionalInfoLabel);
    }
    if (Reflect.has(data2, "customUrlOnTap")) {
      this.custom_url_on_tap = new NavigationEndpoint(data2.customUrlOnTap);
    }
    if (Reflect.has(data2, "videoCountText")) {
      this.video_count = data2.videoCountText;
    }
    if (Reflect.has(data2, "signInForBusinessEmail")) {
      this.sign_in_for_business_email = Text2.fromAttributed(data2.signInForBusinessEmail);
    }
    if (Reflect.has(data2, "links")) {
      this.links = parser_exports.parseArray(data2.links, ChannelExternalLinkView);
    } else {
      this.links = [];
    }
  }
};
__name(_AboutChannelView, "AboutChannelView");
__publicField(_AboutChannelView, "type", "AboutChannelView");
var AboutChannelView = _AboutChannelView;

// dist/src/parser/classes/AboutChannel.js
var _AboutChannel = class _AboutChannel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "metadata");
    __publicField(this, "share_channel");
    this.metadata = parser_exports.parseItem(data2.metadata, AboutChannelView);
    this.share_channel = parser_exports.parseItem(data2.shareChannel, Button);
  }
};
__name(_AboutChannel, "AboutChannel");
__publicField(_AboutChannel, "type", "AboutChannel");
var AboutChannel = _AboutChannel;

// dist/src/parser/classes/AccountChannel.js
var _AccountChannel = class _AccountChannel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "endpoint");
    this.title = new Text2(data2.title);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
  }
};
__name(_AccountChannel, "AccountChannel");
__publicField(_AccountChannel, "type", "AccountChannel");
var AccountChannel = _AccountChannel;

// dist/src/parser/classes/AccountItem.js
var _AccountItem = class _AccountItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "account_name");
    __publicField(this, "account_photo");
    __publicField(this, "is_selected");
    __publicField(this, "is_disabled");
    __publicField(this, "has_channel");
    __publicField(this, "endpoint");
    __publicField(this, "account_byline");
    __publicField(this, "channel_handle");
    this.account_name = new Text2(data2.accountName);
    this.account_photo = Thumbnail.fromResponse(data2.accountPhoto);
    this.is_selected = !!data2.isSelected;
    this.is_disabled = !!data2.isDisabled;
    this.has_channel = !!data2.hasChannel;
    this.endpoint = new NavigationEndpoint(data2.serviceEndpoint);
    this.account_byline = new Text2(data2.accountByline);
    this.channel_handle = new Text2(data2.channelHandle);
  }
};
__name(_AccountItem, "AccountItem");
__publicField(_AccountItem, "type", "AccountItem");
var AccountItem = _AccountItem;

// dist/src/parser/classes/AccountItemSectionHeader.js
var _AccountItemSectionHeader = class _AccountItemSectionHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data2.title);
  }
};
__name(_AccountItemSectionHeader, "AccountItemSectionHeader");
__publicField(_AccountItemSectionHeader, "type", "AccountItemSectionHeader");
var AccountItemSectionHeader = _AccountItemSectionHeader;

// dist/src/parser/classes/CompactLink.js
var _CompactLink = class _CompactLink extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "endpoint");
    __publicField(this, "style");
    __publicField(this, "icon_type");
    __publicField(this, "secondary_icon_type");
    this.title = new Text2(data2.title).toString();
    if ("subtitle" in data2)
      this.subtitle = new Text2(data2.subtitle);
    if ("icon" in data2 && "iconType" in data2.icon)
      this.icon_type = data2.icon.iconType;
    if ("secondaryIcon" in data2 && "iconType" in data2.secondaryIcon)
      this.secondary_icon_type = data2.secondaryIcon.iconType;
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint || data2.serviceEndpoint);
    this.style = data2.style;
  }
};
__name(_CompactLink, "CompactLink");
__publicField(_CompactLink, "type", "CompactLink");
var CompactLink = _CompactLink;

// dist/src/parser/classes/AccountItemSection.js
var _AccountItemSection = class _AccountItemSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    __publicField(this, "header");
    this.contents = parser_exports.parseArray(data2.contents, [AccountItem, CompactLink]);
    this.header = parser_exports.parseItem(data2.header, AccountItemSectionHeader);
  }
};
__name(_AccountItemSection, "AccountItemSection");
__publicField(_AccountItemSection, "type", "AccountItemSection");
var AccountItemSection = _AccountItemSection;

// dist/src/parser/classes/AccountSectionList.js
var _AccountSectionList = class _AccountSectionList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    __publicField(this, "footers");
    this.contents = parser_exports.parseArray(data2.contents, AccountItemSection);
    this.footers = parser_exports.parseArray(data2.footers, AccountChannel);
  }
};
__name(_AccountSectionList, "AccountSectionList");
__publicField(_AccountSectionList, "type", "AccountSectionList");
var AccountSectionList = _AccountSectionList;

// dist/src/parser/classes/actions/AppendContinuationItemsAction.js
var _AppendContinuationItemsAction = class _AppendContinuationItemsAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    __publicField(this, "target");
    this.contents = parser_exports.parseArray(data2.continuationItems);
    this.target = data2.target;
  }
};
__name(_AppendContinuationItemsAction, "AppendContinuationItemsAction");
__publicField(_AppendContinuationItemsAction, "type", "AppendContinuationItemsAction");
var AppendContinuationItemsAction = _AppendContinuationItemsAction;

// dist/src/parser/classes/actions/ChangeEngagementPanelVisibilityAction.js
var _ChangeEngagementPanelVisibilityAction = class _ChangeEngagementPanelVisibilityAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "target_id");
    __publicField(this, "visibility");
    this.target_id = data2.targetId;
    this.visibility = data2.visibility;
  }
};
__name(_ChangeEngagementPanelVisibilityAction, "ChangeEngagementPanelVisibilityAction");
__publicField(_ChangeEngagementPanelVisibilityAction, "type", "ChangeEngagementPanelVisibilityAction");
var ChangeEngagementPanelVisibilityAction = _ChangeEngagementPanelVisibilityAction;

// dist/src/parser/classes/menus/MultiPageMenu.js
var _MultiPageMenu = class _MultiPageMenu extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "sections");
    __publicField(this, "style");
    this.header = parser_exports.parseItem(data2.header);
    this.sections = parser_exports.parseArray(data2.sections);
    this.style = data2.style;
  }
};
__name(_MultiPageMenu, "MultiPageMenu");
__publicField(_MultiPageMenu, "type", "MultiPageMenu");
var MultiPageMenu = _MultiPageMenu;

// dist/src/parser/classes/actions/GetMultiPageMenuAction.js
var _GetMultiPageMenuAction = class _GetMultiPageMenuAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "menu");
    this.menu = parser_exports.parseItem(data2.menu, MultiPageMenu);
  }
};
__name(_GetMultiPageMenuAction, "GetMultiPageMenuAction");
__publicField(_GetMultiPageMenuAction, "type", "GetMultiPageMenuAction");
var GetMultiPageMenuAction = _GetMultiPageMenuAction;

// dist/src/parser/classes/actions/SendFeedbackAction.js
var _SendFeedbackAction = class _SendFeedbackAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "bucket");
    this.bucket = data2.bucket;
  }
};
__name(_SendFeedbackAction, "SendFeedbackAction");
__publicField(_SendFeedbackAction, "type", "SendFeedbackAction");
var SendFeedbackAction = _SendFeedbackAction;

// dist/src/parser/classes/actions/SignalAction.js
var _SignalAction = class _SignalAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "signal");
    this.signal = data2.signal;
  }
};
__name(_SignalAction, "SignalAction");
__publicField(_SignalAction, "type", "SignalAction");
var SignalAction = _SignalAction;

// dist/src/parser/classes/ChannelSwitcherPage.js
var _ChannelSwitcherPage = class _ChannelSwitcherPage extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "contents");
    this.header = parser_exports.parseItem(data2.header);
    this.contents = parser_exports.parse(data2.contents, true);
  }
};
__name(_ChannelSwitcherPage, "ChannelSwitcherPage");
__publicField(_ChannelSwitcherPage, "type", "ChannelSwitcherPage");
var ChannelSwitcherPage = _ChannelSwitcherPage;

// dist/src/parser/classes/actions/UpdateChannelSwitcherPageAction.js
var _UpdateChannelSwitcherPageAction = class _UpdateChannelSwitcherPageAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "contents");
    const page = parser_exports.parseItem(data2.page, ChannelSwitcherPage);
    if (page) {
      this.header = page.header;
      this.contents = page.contents;
    }
  }
};
__name(_UpdateChannelSwitcherPageAction, "UpdateChannelSwitcherPageAction");
__publicField(_UpdateChannelSwitcherPageAction, "type", "UpdateChannelSwitcherPageAction");
var UpdateChannelSwitcherPageAction = _UpdateChannelSwitcherPageAction;

// dist/src/parser/classes/SortFilterSubMenu.js
var _SortFilterSubMenu = class _SortFilterSubMenu extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "icon_type");
    __publicField(this, "tooltip");
    __publicField(this, "sub_menu_items");
    __publicField(this, "accessibility");
    if ("title" in data2) {
      this.title = data2.title;
    }
    if ("icon" in data2) {
      this.icon_type = data2.icon.iconType;
    }
    if ("tooltip" in data2) {
      this.tooltip = data2.tooltip;
    }
    if ("subMenuItems" in data2) {
      this.sub_menu_items = data2.subMenuItems.map((item) => ({
        title: item.title,
        selected: item.selected,
        continuation: item.continuation?.reloadContinuationData?.continuation,
        endpoint: new NavigationEndpoint(item.serviceEndpoint || item.navigationEndpoint),
        subtitle: item.subtitle || null
      }));
    }
    if ("accessibility" in data2 && "accessibilityData" in data2.accessibility) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data2.accessibility.accessibilityData)
      };
    }
  }
  get label() {
    return this.accessibility?.accessibility_data?.label;
  }
};
__name(_SortFilterSubMenu, "SortFilterSubMenu");
__publicField(_SortFilterSubMenu, "type", "SortFilterSubMenu");
var SortFilterSubMenu = _SortFilterSubMenu;

// dist/src/parser/classes/TranscriptFooter.js
var _TranscriptFooter = class _TranscriptFooter extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "language_menu");
    this.language_menu = parser_exports.parseItem(data2.languageMenu, SortFilterSubMenu);
  }
};
__name(_TranscriptFooter, "TranscriptFooter");
__publicField(_TranscriptFooter, "type", "TranscriptFooter");
var TranscriptFooter = _TranscriptFooter;

// dist/src/parser/classes/TranscriptSearchBox.js
var _TranscriptSearchBox = class _TranscriptSearchBox extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "formatted_placeholder");
    __publicField(this, "clear_button");
    __publicField(this, "endpoint");
    __publicField(this, "search_button");
    this.formatted_placeholder = new Text2(data2.formattedPlaceholder);
    this.clear_button = parser_exports.parseItem(data2.clearButton, Button);
    this.endpoint = new NavigationEndpoint(data2.onTextChangeCommand);
    this.search_button = parser_exports.parseItem(data2.searchButton, Button);
  }
};
__name(_TranscriptSearchBox, "TranscriptSearchBox");
__publicField(_TranscriptSearchBox, "type", "TranscriptSearchBox");
var TranscriptSearchBox = _TranscriptSearchBox;

// dist/src/parser/classes/TranscriptSectionHeader.js
var _TranscriptSectionHeader = class _TranscriptSectionHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "start_ms");
    __publicField(this, "end_ms");
    __publicField(this, "snippet");
    this.start_ms = data2.startMs;
    this.end_ms = data2.endMs;
    this.snippet = new Text2(data2.snippet);
  }
};
__name(_TranscriptSectionHeader, "TranscriptSectionHeader");
__publicField(_TranscriptSectionHeader, "type", "TranscriptSectionHeader");
var TranscriptSectionHeader = _TranscriptSectionHeader;

// dist/src/parser/classes/TranscriptSegment.js
var _TranscriptSegment = class _TranscriptSegment extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "start_ms");
    __publicField(this, "end_ms");
    __publicField(this, "snippet");
    __publicField(this, "start_time_text");
    __publicField(this, "target_id");
    this.start_ms = data2.startMs;
    this.end_ms = data2.endMs;
    this.snippet = new Text2(data2.snippet);
    this.start_time_text = new Text2(data2.startTimeText);
    this.target_id = data2.targetId;
  }
};
__name(_TranscriptSegment, "TranscriptSegment");
__publicField(_TranscriptSegment, "type", "TranscriptSegment");
var TranscriptSegment = _TranscriptSegment;

// dist/src/parser/classes/TranscriptSegmentList.js
var _TranscriptSegmentList = class _TranscriptSegmentList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "initial_segments");
    __publicField(this, "no_result_label");
    __publicField(this, "retry_label");
    __publicField(this, "touch_captions_enabled");
    this.initial_segments = parser_exports.parseArray(data2.initialSegments, [TranscriptSegment, TranscriptSectionHeader]);
    this.no_result_label = new Text2(data2.noResultLabel);
    this.retry_label = new Text2(data2.retryLabel);
    this.touch_captions_enabled = data2.touchCaptionsEnabled;
  }
};
__name(_TranscriptSegmentList, "TranscriptSegmentList");
__publicField(_TranscriptSegmentList, "type", "TranscriptSegmentList");
var TranscriptSegmentList = _TranscriptSegmentList;

// dist/src/parser/classes/TranscriptSearchPanel.js
var _TranscriptSearchPanel = class _TranscriptSearchPanel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "body");
    __publicField(this, "footer");
    __publicField(this, "target_id");
    this.header = parser_exports.parseItem(data2.header, TranscriptSearchBox);
    this.body = parser_exports.parseItem(data2.body, TranscriptSegmentList);
    this.footer = parser_exports.parseItem(data2.footer, TranscriptFooter);
    this.target_id = data2.targetId;
  }
};
__name(_TranscriptSearchPanel, "TranscriptSearchPanel");
__publicField(_TranscriptSearchPanel, "type", "TranscriptSearchPanel");
var TranscriptSearchPanel = _TranscriptSearchPanel;

// dist/src/parser/classes/Transcript.js
var _Transcript = class _Transcript extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "content");
    this.content = parser_exports.parseItem(data2.content, TranscriptSearchPanel);
  }
};
__name(_Transcript, "Transcript");
__publicField(_Transcript, "type", "Transcript");
var Transcript = _Transcript;

// dist/src/parser/classes/actions/UpdateEngagementPanelAction.js
var _UpdateEngagementPanelAction = class _UpdateEngagementPanelAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "target_id");
    __publicField(this, "content");
    this.target_id = data2.targetId;
    this.content = parser_exports.parseItem(data2.content, Transcript);
  }
};
__name(_UpdateEngagementPanelAction, "UpdateEngagementPanelAction");
__publicField(_UpdateEngagementPanelAction, "type", "UpdateEngagementPanelAction");
var UpdateEngagementPanelAction = _UpdateEngagementPanelAction;

// dist/src/parser/classes/actions/UpdateSubscribeButtonAction.js
var _UpdateSubscribeButtonAction = class _UpdateSubscribeButtonAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "channel_id");
    __publicField(this, "subscribed");
    this.channel_id = data2.channelId;
    this.subscribed = data2.subscribed;
  }
};
__name(_UpdateSubscribeButtonAction, "UpdateSubscribeButtonAction");
__publicField(_UpdateSubscribeButtonAction, "type", "UpdateSubscribeButtonAction");
var UpdateSubscribeButtonAction = _UpdateSubscribeButtonAction;

// dist/src/parser/classes/ActiveAccountHeader.js
var _ActiveAccountHeader = class _ActiveAccountHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "account_name");
    __publicField(this, "account_photo");
    __publicField(this, "endpoint");
    __publicField(this, "manage_account_title");
    __publicField(this, "channel_handle");
    this.account_name = new Text2(data2.accountName);
    this.account_photo = Thumbnail.fromResponse(data2.accountPhoto);
    this.endpoint = new NavigationEndpoint(data2.serviceEndpoint);
    this.manage_account_title = new Text2(data2.manageAccountTitle);
    this.channel_handle = new Text2(data2.channelHandle);
  }
};
__name(_ActiveAccountHeader, "ActiveAccountHeader");
__publicField(_ActiveAccountHeader, "type", "ActiveAccountHeader");
var ActiveAccountHeader = _ActiveAccountHeader;

// dist/src/parser/classes/MenuTitle.js
var _MenuTitle = class _MenuTitle extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data2.title);
  }
};
__name(_MenuTitle, "MenuTitle");
__publicField(_MenuTitle, "type", "MenuTitle");
var MenuTitle = _MenuTitle;

// dist/src/parser/classes/PlaylistAddToOption.js
var _PlaylistAddToOption = class _PlaylistAddToOption extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "add_to_playlist_service_endpoint");
    __publicField(this, "contains_selected_videos");
    __publicField(this, "playlist_id");
    __publicField(this, "privacy");
    __publicField(this, "privacy_icon");
    __publicField(this, "remove_from_playlist_service_endpoint");
    __publicField(this, "title");
    this.add_to_playlist_service_endpoint = new NavigationEndpoint(data2.addToPlaylistServiceEndpoint);
    this.contains_selected_videos = data2.containsSelectedVideos;
    this.playlist_id = data2.playlistId;
    this.privacy = data2.privacy;
    this.privacy_icon = { icon_type: data2.privacyIcon?.iconType || null };
    this.remove_from_playlist_service_endpoint = new NavigationEndpoint(data2.removeFromPlaylistServiceEndpoint);
    this.title = new Text2(data2.title);
  }
};
__name(_PlaylistAddToOption, "PlaylistAddToOption");
__publicField(_PlaylistAddToOption, "type", "PlaylistAddToOption");
var PlaylistAddToOption = _PlaylistAddToOption;

// dist/src/parser/classes/AddToPlaylist.js
var _AddToPlaylist = class _AddToPlaylist extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "actions");
    __publicField(this, "playlists");
    this.actions = parser_exports.parseArray(data2.actions, [MenuTitle, Button]);
    this.playlists = parser_exports.parseArray(data2.playlists, PlaylistAddToOption);
  }
};
__name(_AddToPlaylist, "AddToPlaylist");
__publicField(_AddToPlaylist, "type", "AddToPlaylist");
var AddToPlaylist = _AddToPlaylist;

// dist/src/parser/classes/Alert.js
var _Alert = class _Alert extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "alert_type");
    this.text = new Text2(data2.text);
    this.alert_type = data2.type;
  }
};
__name(_Alert, "Alert");
__publicField(_Alert, "type", "Alert");
var Alert = _Alert;

// dist/src/parser/classes/AlertWithButton.js
var _AlertWithButton = class _AlertWithButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "alert_type");
    __publicField(this, "dismiss_button");
    this.text = new Text2(data2.text);
    this.alert_type = data2.type;
    this.dismiss_button = parser_exports.parseItem(data2.dismissButton, Button);
  }
};
__name(_AlertWithButton, "AlertWithButton");
__publicField(_AlertWithButton, "type", "AlertWithButton");
var AlertWithButton = _AlertWithButton;

// dist/src/parser/classes/AnimatedThumbnailOverlayView.js
var _AnimatedThumbnailOverlayView = class _AnimatedThumbnailOverlayView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
  }
};
__name(_AnimatedThumbnailOverlayView, "AnimatedThumbnailOverlayView");
__publicField(_AnimatedThumbnailOverlayView, "type", "AnimatedThumbnailOverlayView");
var AnimatedThumbnailOverlayView = _AnimatedThumbnailOverlayView;

// dist/src/parser/classes/AttributionView.js
var _AttributionView = class _AttributionView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "suffix");
    this.text = Text2.fromAttributed(data2.text);
    this.suffix = Text2.fromAttributed(data2.suffix);
  }
};
__name(_AttributionView, "AttributionView");
__publicField(_AttributionView, "type", "AttributionView");
var AttributionView = _AttributionView;

// dist/src/parser/classes/AudioOnlyPlayability.js
var _AudioOnlyPlayability = class _AudioOnlyPlayability extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "audio_only_availability");
    this.audio_only_availability = data2.audioOnlyAvailability;
  }
};
__name(_AudioOnlyPlayability, "AudioOnlyPlayability");
__publicField(_AudioOnlyPlayability, "type", "AudioOnlyPlayability");
var AudioOnlyPlayability = _AudioOnlyPlayability;

// dist/src/parser/classes/AutomixPreviewVideo.js
var _AutomixPreviewVideo = class _AutomixPreviewVideo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "playlist_video");
    if (data2?.content?.automixPlaylistVideoRenderer?.navigationEndpoint) {
      this.playlist_video = {
        endpoint: new NavigationEndpoint(data2.content.automixPlaylistVideoRenderer.navigationEndpoint)
      };
    }
  }
};
__name(_AutomixPreviewVideo, "AutomixPreviewVideo");
__publicField(_AutomixPreviewVideo, "type", "AutomixPreviewVideo");
var AutomixPreviewVideo = _AutomixPreviewVideo;

// dist/src/parser/classes/AvatarView.js
var _AvatarView = class _AvatarView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "image");
    __publicField(this, "image_processor");
    __publicField(this, "avatar_image_size");
    this.image = Thumbnail.fromResponse(data2.image);
    this.avatar_image_size = data2.avatarImageSize;
    if (data2.image.processor) {
      this.image_processor = {
        border_image_processor: {
          circular: data2.image.processor.borderImageProcessor.circular
        }
      };
    }
  }
};
__name(_AvatarView, "AvatarView");
__publicField(_AvatarView, "type", "AvatarView");
var AvatarView = _AvatarView;

// dist/src/parser/classes/misc/CommandContext.js
var _CommandContext = class _CommandContext {
  constructor(data2) {
    __publicField(this, "on_focus");
    __publicField(this, "on_hidden");
    __publicField(this, "on_touch_end");
    __publicField(this, "on_touch_move");
    __publicField(this, "on_long_press");
    __publicField(this, "on_tap");
    __publicField(this, "on_touch_start");
    __publicField(this, "on_visible");
    __publicField(this, "on_first_visible");
    __publicField(this, "on_hover");
    if ("onFocus" in data2)
      this.on_focus = new NavigationEndpoint(data2.onFocus);
    if ("onHidden" in data2)
      this.on_hidden = new NavigationEndpoint(data2.onHidden);
    if ("onTouchEnd" in data2)
      this.on_touch_end = new NavigationEndpoint(data2.onTouchEnd);
    if ("onTouchMove" in data2)
      this.on_touch_move = new NavigationEndpoint(data2.onTouchMove);
    if ("onLongPress" in data2)
      this.on_long_press = new NavigationEndpoint(data2.onLongPress);
    if ("onTap" in data2)
      this.on_tap = new NavigationEndpoint(data2.onTap);
    if ("onTouchStart" in data2)
      this.on_touch_start = new NavigationEndpoint(data2.onTouchStart);
    if ("onVisible" in data2)
      this.on_visible = new NavigationEndpoint(data2.onVisible);
    if ("onFirstVisible" in data2)
      this.on_first_visible = new NavigationEndpoint(data2.onFirstVisible);
    if ("onHover" in data2)
      this.on_hover = new NavigationEndpoint(data2.onHover);
  }
};
__name(_CommandContext, "CommandContext");
var CommandContext = _CommandContext;

// dist/src/parser/classes/misc/RendererContext.js
var _RendererContext = class _RendererContext {
  constructor(data2) {
    __publicField(this, "command_context");
    __publicField(this, "accessibility_context");
    if (!data2)
      return;
    if ("commandContext" in data2) {
      this.command_context = new CommandContext(data2.commandContext);
    }
    if ("accessibilityContext" in data2) {
      this.accessibility_context = new AccessibilityContext(data2.accessibilityContext);
    }
  }
};
__name(_RendererContext, "RendererContext");
var RendererContext = _RendererContext;

// dist/src/parser/classes/AvatarStackView.js
var _AvatarStackView = class _AvatarStackView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "avatars");
    __publicField(this, "text");
    __publicField(this, "renderer_context");
    this.avatars = parser_exports.parseArray(data2.avatars, AvatarView);
    if (Reflect.has(data2, "text"))
      this.text = Text2.fromAttributed(data2.text);
    this.renderer_context = new RendererContext(data2.rendererContext);
  }
};
__name(_AvatarStackView, "AvatarStackView");
__publicField(_AvatarStackView, "type", "AvatarStackView");
var AvatarStackView = _AvatarStackView;

// dist/src/parser/classes/ButtonView.js
var _ButtonView = class _ButtonView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "secondary_icon_image");
    __publicField(this, "icon_name");
    __publicField(this, "enable_icon_button");
    __publicField(this, "tooltip");
    __publicField(this, "icon_image_flip_for_rtl");
    __publicField(this, "button_size");
    __publicField(this, "icon_position");
    __publicField(this, "is_full_width");
    __publicField(this, "state");
    __publicField(this, "on_disabled_tap");
    __publicField(this, "custom_border_color");
    __publicField(this, "on_tap");
    __publicField(this, "style");
    __publicField(this, "icon_image");
    __publicField(this, "custom_dark_theme_border_color");
    __publicField(this, "title");
    __publicField(this, "target_id");
    __publicField(this, "enable_full_width_margins");
    __publicField(this, "custom_font_color");
    __publicField(this, "button_type");
    __publicField(this, "enabled");
    __publicField(this, "accessibility_id");
    __publicField(this, "custom_background_color");
    __publicField(this, "on_long_press");
    __publicField(this, "title_formatted");
    __publicField(this, "on_visible");
    __publicField(this, "icon_trailing");
    __publicField(this, "accessibility_text");
    if ("secondaryIconImage" in data2)
      this.secondary_icon_image = Thumbnail.fromResponse(data2.secondaryIconImage);
    if ("iconName" in data2)
      this.icon_name = data2.iconName;
    if ("enableIconButton" in data2)
      this.enable_icon_button = data2.enableIconButton;
    if ("tooltip" in data2)
      this.tooltip = data2.tooltip;
    if ("iconImageFlipForRtl" in data2)
      this.icon_image_flip_for_rtl = data2.iconImageFlipForRtl;
    if ("buttonSize" in data2)
      this.button_size = data2.buttonSize;
    if ("iconPosition" in data2)
      this.icon_position = data2.iconPosition;
    if ("isFullWidth" in data2)
      this.is_full_width = data2.isFullWidth;
    if ("state" in data2)
      this.state = data2.state;
    if ("onDisabledTap" in data2)
      this.on_disabled_tap = new NavigationEndpoint(data2.onDisabledTap);
    if ("customBorderColor" in data2)
      this.custom_border_color = data2.customBorderColor;
    if ("onTap" in data2)
      this.on_tap = new NavigationEndpoint(data2.onTap);
    if ("style" in data2)
      this.style = data2.style;
    if ("iconImage" in data2)
      this.icon_image = data2.iconImage;
    if ("customDarkThemeBorderColor" in data2)
      this.custom_dark_theme_border_color = data2.customDarkThemeBorderColor;
    if ("title" in data2)
      this.title = data2.title;
    if ("targetId" in data2)
      this.target_id = data2.targetId;
    if ("enableFullWidthMargins" in data2)
      this.enable_full_width_margins = data2.enableFullWidthMargins;
    if ("customFontColor" in data2)
      this.custom_font_color = data2.customFontColor;
    if ("type" in data2)
      this.button_type = data2.type;
    if ("enabled" in data2)
      this.enabled = data2.enabled;
    if ("accessibilityId" in data2)
      this.accessibility_id = data2.accessibilityId;
    if ("customBackgroundColor" in data2)
      this.custom_background_color = data2.customBackgroundColor;
    if ("onLongPress" in data2)
      this.on_long_press = new NavigationEndpoint(data2.onLongPress);
    if ("titleFormatted" in data2)
      this.title_formatted = data2.titleFormatted;
    if ("onVisible" in data2)
      this.on_visible = data2.onVisible;
    if ("iconTrailing" in data2)
      this.icon_trailing = data2.iconTrailing;
    if ("accessibilityText" in data2)
      this.accessibility_text = data2.accessibilityText;
  }
};
__name(_ButtonView, "ButtonView");
__publicField(_ButtonView, "type", "ButtonView");
var ButtonView = _ButtonView;

// dist/src/parser/classes/BackgroundPromo.js
var _BackgroundPromo = class _BackgroundPromo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "body_text");
    __publicField(this, "cta_button");
    __publicField(this, "icon_type");
    __publicField(this, "title");
    this.body_text = new Text2(data2.bodyText);
    this.cta_button = parser_exports.parseItem(data2.ctaButton, [Button, ButtonView]);
    if (Reflect.has(data2, "icon"))
      this.icon_type = data2.icon.iconType;
    this.title = new Text2(data2.title);
  }
};
__name(_BackgroundPromo, "BackgroundPromo");
__publicField(_BackgroundPromo, "type", "BackgroundPromo");
var BackgroundPromo = _BackgroundPromo;

// dist/src/parser/classes/BackstageImage.js
var _BackstageImage = class _BackstageImage extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "image");
    __publicField(this, "endpoint");
    this.image = Thumbnail.fromResponse(data2.image);
    this.endpoint = new NavigationEndpoint(data2.command);
  }
};
__name(_BackstageImage, "BackstageImage");
__publicField(_BackstageImage, "type", "BackstageImage");
var BackstageImage = _BackstageImage;

// dist/src/parser/classes/ToggleButton.js
var _ToggleButton = class _ToggleButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "toggled_text");
    __publicField(this, "tooltip");
    __publicField(this, "toggled_tooltip");
    __publicField(this, "is_toggled");
    __publicField(this, "is_disabled");
    __publicField(this, "icon_type");
    __publicField(this, "like_count");
    __publicField(this, "short_like_count");
    __publicField(this, "endpoint");
    __publicField(this, "toggled_endpoint");
    __publicField(this, "button_id");
    __publicField(this, "target_id");
    this.text = new Text2(data2.defaultText);
    this.toggled_text = new Text2(data2.toggledText);
    this.tooltip = data2.defaultTooltip;
    this.toggled_tooltip = data2.toggledTooltip;
    this.is_toggled = data2.isToggled;
    this.is_disabled = data2.isDisabled;
    this.icon_type = data2.defaultIcon?.iconType;
    const acc_label = data2?.defaultText?.accessibility?.accessibilityData?.label || data2?.accessibilityData?.accessibilityData?.label || data2?.accessibility?.label;
    if (this.icon_type == "LIKE") {
      this.like_count = parseInt(acc_label.replace(/\D/g, ""));
      this.short_like_count = new Text2(data2.defaultText).toString();
    }
    this.endpoint = data2.defaultServiceEndpoint?.commandExecutorCommand?.commands ? new NavigationEndpoint(data2.defaultServiceEndpoint.commandExecutorCommand.commands.pop()) : new NavigationEndpoint(data2.defaultServiceEndpoint);
    this.toggled_endpoint = new NavigationEndpoint(data2.toggledServiceEndpoint);
    if (Reflect.has(data2, "toggleButtonSupportedData") && Reflect.has(data2.toggleButtonSupportedData, "toggleButtonIdData")) {
      this.button_id = data2.toggleButtonSupportedData.toggleButtonIdData.id;
    }
    if (Reflect.has(data2, "targetId")) {
      this.target_id = data2.targetId;
    }
  }
};
__name(_ToggleButton, "ToggleButton");
__publicField(_ToggleButton, "type", "ToggleButton");
var ToggleButton = _ToggleButton;

// dist/src/parser/classes/comments/CreatorHeart.js
var _CreatorHeart = class _CreatorHeart extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "creator_thumbnail");
    __publicField(this, "heart_icon_type");
    __publicField(this, "heart_color");
    __publicField(this, "hearted_tooltip");
    __publicField(this, "is_hearted");
    __publicField(this, "is_enabled");
    __publicField(this, "kennedy_heart_color_string");
    this.creator_thumbnail = Thumbnail.fromResponse(data2.creatorThumbnail);
    if (Reflect.has(data2, "heartIcon") && Reflect.has(data2.heartIcon, "iconType")) {
      this.heart_icon_type = data2.heartIcon.iconType;
    }
    this.heart_color = {
      basic_color_palette_data: {
        foreground_title_color: data2.heartColor?.basicColorPaletteData?.foregroundTitleColor
      }
    };
    this.hearted_tooltip = data2.heartedTooltip;
    this.is_hearted = data2.isHearted;
    this.is_enabled = data2.isEnabled;
    this.kennedy_heart_color_string = data2.kennedyHeartColorString;
  }
};
__name(_CreatorHeart, "CreatorHeart");
__publicField(_CreatorHeart, "type", "CreatorHeart");
var CreatorHeart = _CreatorHeart;

// dist/src/parser/classes/comments/CommentActionButtons.js
var _CommentActionButtons = class _CommentActionButtons extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "like_button");
    __publicField(this, "dislike_button");
    __publicField(this, "reply_button");
    __publicField(this, "creator_heart");
    this.like_button = parser_exports.parseItem(data2.likeButton, ToggleButton);
    this.dislike_button = parser_exports.parseItem(data2.dislikeButton, ToggleButton);
    this.reply_button = parser_exports.parseItem(data2.replyButton, Button);
    this.creator_heart = parser_exports.parseItem(data2.creatorHeart, CreatorHeart);
  }
};
__name(_CommentActionButtons, "CommentActionButtons");
__publicField(_CommentActionButtons, "type", "CommentActionButtons");
var CommentActionButtons = _CommentActionButtons;

// dist/src/parser/classes/ToggleButtonView.js
var _ToggleButtonView = class _ToggleButtonView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "default_button");
    __publicField(this, "toggled_button");
    __publicField(this, "is_toggling_disabled");
    __publicField(this, "identifier");
    __publicField(this, "is_toggled");
    this.default_button = parser_exports.parseItem(data2.defaultButtonViewModel, ButtonView);
    this.toggled_button = parser_exports.parseItem(data2.toggledButtonViewModel, ButtonView);
    this.is_toggling_disabled = data2.isTogglingDisabled;
    this.identifier = data2.identifier;
    if (Reflect.has(data2, "isToggled")) {
      this.is_toggled = data2.isToggled;
    }
  }
};
__name(_ToggleButtonView, "ToggleButtonView");
__publicField(_ToggleButtonView, "type", "ToggleButtonView");
var ToggleButtonView = _ToggleButtonView;

// dist/src/parser/classes/LikeButtonView.js
var _LikeButtonView = class _LikeButtonView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "toggle_button");
    __publicField(this, "like_status_entity_key");
    __publicField(this, "like_status_entity");
    this.toggle_button = parser_exports.parseItem(data2.toggleButtonViewModel, ToggleButtonView);
    this.like_status_entity_key = data2.likeStatusEntityKey;
    this.like_status_entity = {
      key: data2.likeStatusEntity.key,
      like_status: data2.likeStatusEntity.likeStatus
    };
  }
};
__name(_LikeButtonView, "LikeButtonView");
__publicField(_LikeButtonView, "type", "LikeButtonView");
var LikeButtonView = _LikeButtonView;

// dist/src/parser/classes/DislikeButtonView.js
var _DislikeButtonView = class _DislikeButtonView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "toggle_button");
    __publicField(this, "dislike_entity_key");
    this.toggle_button = parser_exports.parseItem(data2.toggleButtonViewModel, ToggleButtonView);
    this.dislike_entity_key = data2.dislikeEntityKey;
  }
};
__name(_DislikeButtonView, "DislikeButtonView");
__publicField(_DislikeButtonView, "type", "DislikeButtonView");
var DislikeButtonView = _DislikeButtonView;

// dist/src/parser/classes/SegmentedLikeDislikeButtonView.js
var _SegmentedLikeDislikeButtonView = class _SegmentedLikeDislikeButtonView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "like_button");
    __publicField(this, "dislike_button");
    __publicField(this, "icon_type");
    __publicField(this, "like_count_entity");
    __publicField(this, "dynamic_like_count_update_data");
    __publicField(this, "like_count");
    __publicField(this, "short_like_count");
    this.like_button = parser_exports.parseItem(data2.likeButtonViewModel, LikeButtonView);
    this.dislike_button = parser_exports.parseItem(data2.dislikeButtonViewModel, DislikeButtonView);
    this.icon_type = data2.iconType;
    if (this.like_button && this.like_button.toggle_button) {
      const toggle_button = this.like_button.toggle_button;
      if (toggle_button.default_button) {
        this.short_like_count = toggle_button.default_button.title;
        if (toggle_button.default_button.accessibility_text)
          this.like_count = parseInt(toggle_button.default_button.accessibility_text.replace(/\D/g, ""));
      } else if (toggle_button.toggled_button) {
        this.short_like_count = toggle_button.toggled_button.title;
        if (toggle_button.toggled_button.accessibility_text)
          this.like_count = parseInt(toggle_button.toggled_button.accessibility_text.replace(/\D/g, ""));
      }
    }
    this.like_count_entity = {
      key: data2.likeCountEntity.key
    };
    this.dynamic_like_count_update_data = {
      update_status_key: data2.dynamicLikeCountUpdateData.updateStatusKey,
      placeholder_like_count_values_key: data2.dynamicLikeCountUpdateData.placeholderLikeCountValuesKey,
      update_delay_loop_id: data2.dynamicLikeCountUpdateData.updateDelayLoopId,
      update_delay_sec: data2.dynamicLikeCountUpdateData.updateDelaySec
    };
  }
};
__name(_SegmentedLikeDislikeButtonView, "SegmentedLikeDislikeButtonView");
__publicField(_SegmentedLikeDislikeButtonView, "type", "SegmentedLikeDislikeButtonView");
var SegmentedLikeDislikeButtonView = _SegmentedLikeDislikeButtonView;

// dist/src/parser/classes/menus/MenuServiceItem.js
var _MenuServiceItem = class _MenuServiceItem extends Button {
  constructor(data2) {
    super(data2);
  }
};
__name(_MenuServiceItem, "MenuServiceItem");
__publicField(_MenuServiceItem, "type", "MenuServiceItem");
var MenuServiceItem = _MenuServiceItem;

// dist/src/parser/classes/DownloadButton.js
var _DownloadButton = class _DownloadButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "style");
    __publicField(this, "size");
    // TODO: check this
    __publicField(this, "endpoint");
    __publicField(this, "target_id");
    this.style = data2.style;
    this.size = data2.size;
    this.endpoint = new NavigationEndpoint(data2.command);
    this.target_id = data2.targetId;
  }
};
__name(_DownloadButton, "DownloadButton");
__publicField(_DownloadButton, "type", "DownloadButton");
var DownloadButton = _DownloadButton;

// dist/src/parser/classes/menus/MenuServiceItemDownload.js
var _MenuServiceItemDownload = class _MenuServiceItemDownload extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "has_separator");
    __publicField(this, "endpoint");
    this.has_separator = !!data2.hasSeparator;
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint || data2.serviceEndpoint);
  }
};
__name(_MenuServiceItemDownload, "MenuServiceItemDownload");
__publicField(_MenuServiceItemDownload, "type", "MenuServiceItemDownload");
var MenuServiceItemDownload = _MenuServiceItemDownload;

// dist/src/parser/classes/menus/MenuFlexibleItem.js
var _MenuFlexibleItem = class _MenuFlexibleItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "menu_item");
    __publicField(this, "top_level_button");
    this.menu_item = parser_exports.parseItem(data2.menuItem, [MenuServiceItem, MenuServiceItemDownload]);
    this.top_level_button = parser_exports.parseItem(data2.topLevelButton, [DownloadButton, ButtonView, Button]);
  }
};
__name(_MenuFlexibleItem, "MenuFlexibleItem");
__publicField(_MenuFlexibleItem, "type", "MenuFlexibleItem");
var MenuFlexibleItem = _MenuFlexibleItem;

// dist/src/parser/classes/LikeButton.js
var _LikeButton = class _LikeButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "target");
    __publicField(this, "like_status");
    __publicField(this, "likes_allowed");
    __publicField(this, "endpoints");
    this.target = {
      video_id: data2.target.videoId
    };
    this.like_status = data2.likeStatus;
    this.likes_allowed = data2.likesAllowed;
    if (Reflect.has(data2, "serviceEndpoints")) {
      this.endpoints = data2.serviceEndpoints.map((endpoint) => new NavigationEndpoint(endpoint));
    }
  }
};
__name(_LikeButton, "LikeButton");
__publicField(_LikeButton, "type", "LikeButton");
var LikeButton = _LikeButton;

// dist/src/parser/classes/FlexibleActionsView.js
var _FlexibleActionsView = class _FlexibleActionsView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "actions_rows");
    __publicField(this, "style");
    this.actions_rows = data2.actionsRows.map((row) => ({
      actions: parser_exports.parseArray(row.actions, [ButtonView, ToggleButtonView])
    }));
    this.style = data2.style;
  }
};
__name(_FlexibleActionsView, "FlexibleActionsView");
__publicField(_FlexibleActionsView, "type", "FlexibleActionsView");
var FlexibleActionsView = _FlexibleActionsView;

// dist/src/parser/classes/menus/Menu.js
var _Menu = class _Menu extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    __publicField(this, "flexible_items");
    __publicField(this, "top_level_buttons");
    __publicField(this, "accessibility");
    this.items = parser_exports.parseArray(data2.items);
    this.flexible_items = parser_exports.parseArray(data2.flexibleItems, MenuFlexibleItem);
    this.top_level_buttons = parser_exports.parseArray(data2.topLevelButtons, [ToggleButton, LikeButton, Button, ButtonView, SegmentedLikeDislikeButtonView, FlexibleActionsView]);
    if ("accessibility" in data2 && "accessibilityData" in data2.accessibility) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data2.accessibility.accessibilityData)
      };
    }
  }
  get label() {
    return this.accessibility?.accessibility_data?.label;
  }
  // XXX: alias for consistency
  get contents() {
    return this.items;
  }
};
__name(_Menu, "Menu");
__publicField(_Menu, "type", "Menu");
var Menu = _Menu;

// dist/src/parser/classes/BackstagePost.js
var _BackstagePost = class _BackstagePost extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "author");
    __publicField(this, "content");
    __publicField(this, "published");
    __publicField(this, "poll_status");
    __publicField(this, "vote_status");
    __publicField(this, "vote_count");
    __publicField(this, "menu");
    __publicField(this, "action_buttons");
    __publicField(this, "vote_button");
    __publicField(this, "surface");
    __publicField(this, "endpoint");
    __publicField(this, "attachment");
    this.id = data2.postId;
    this.author = new Author({
      ...data2.authorText,
      navigationEndpoint: data2.authorEndpoint
    }, null, data2.authorThumbnail);
    this.content = new Text2(data2.contentText);
    this.published = new Text2(data2.publishedTimeText);
    if (Reflect.has(data2, "pollStatus")) {
      this.poll_status = data2.pollStatus;
    }
    if (Reflect.has(data2, "voteStatus")) {
      this.vote_status = data2.voteStatus;
    }
    if (Reflect.has(data2, "voteCount")) {
      this.vote_count = new Text2(data2.voteCount);
    }
    if (Reflect.has(data2, "actionMenu")) {
      this.menu = parser_exports.parseItem(data2.actionMenu, Menu);
    }
    if (Reflect.has(data2, "actionButtons")) {
      this.action_buttons = parser_exports.parseItem(data2.actionButtons, CommentActionButtons);
    }
    if (Reflect.has(data2, "voteButton")) {
      this.vote_button = parser_exports.parseItem(data2.voteButton, Button);
    }
    if (Reflect.has(data2, "navigationEndpoint")) {
      this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    }
    if (Reflect.has(data2, "backstageAttachment")) {
      this.attachment = parser_exports.parseItem(data2.backstageAttachment);
    }
    this.surface = data2.surface;
  }
};
__name(_BackstagePost, "BackstagePost");
__publicField(_BackstagePost, "type", "BackstagePost");
var BackstagePost = _BackstagePost;

// dist/src/parser/classes/BackstagePostThread.js
var _BackstagePostThread = class _BackstagePostThread extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "post");
    this.post = parser_exports.parseItem(data2.post);
  }
};
__name(_BackstagePostThread, "BackstagePostThread");
__publicField(_BackstagePostThread, "type", "BackstagePostThread");
var BackstagePostThread = _BackstagePostThread;

// dist/src/parser/classes/BadgeView.js
var _BadgeView = class _BadgeView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "style");
    __publicField(this, "accessibility_label");
    this.text = data2.badgeText;
    this.style = data2.badgeStyle;
    this.accessibility_label = data2.accessibilityLabel;
  }
};
__name(_BadgeView, "BadgeView");
var BadgeView = _BadgeView;

// dist/src/parser/classes/SubFeedOption.js
var _SubFeedOption = class _SubFeedOption extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "name");
    __publicField(this, "is_selected");
    __publicField(this, "endpoint");
    this.name = new Text2(data2.name);
    this.is_selected = data2.isSelected;
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
  }
};
__name(_SubFeedOption, "SubFeedOption");
__publicField(_SubFeedOption, "type", "SubFeedOption");
var SubFeedOption = _SubFeedOption;

// dist/src/parser/classes/SubFeedSelector.js
var _SubFeedSelector = class _SubFeedSelector extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "options");
    this.title = new Text2(data2.title);
    this.options = parser_exports.parseArray(data2.options, SubFeedOption);
  }
};
__name(_SubFeedSelector, "SubFeedSelector");
__publicField(_SubFeedSelector, "type", "SubFeedSelector");
var SubFeedSelector = _SubFeedSelector;

// dist/src/parser/classes/EomSettingsDisclaimer.js
var _EomSettingsDisclaimer = class _EomSettingsDisclaimer extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "disclaimer");
    __publicField(this, "info_icon");
    __publicField(this, "usage_scenario");
    this.disclaimer = new Text2(data2.disclaimer);
    this.info_icon = {
      icon_type: data2.infoIcon.iconType
    };
    this.usage_scenario = data2.usageScenario;
  }
};
__name(_EomSettingsDisclaimer, "EomSettingsDisclaimer");
__publicField(_EomSettingsDisclaimer, "type", "EomSettingsDisclaimer");
var EomSettingsDisclaimer = _EomSettingsDisclaimer;

// dist/src/parser/classes/SearchBox.js
var _SearchBox = class _SearchBox extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "endpoint");
    __publicField(this, "search_button");
    __publicField(this, "clear_button");
    __publicField(this, "placeholder_text");
    this.endpoint = new NavigationEndpoint(data2.endpoint);
    this.search_button = parser_exports.parseItem(data2.searchButton, Button);
    this.clear_button = parser_exports.parseItem(data2.clearButton, Button);
    this.placeholder_text = new Text2(data2.placeholderText);
  }
};
__name(_SearchBox, "SearchBox");
__publicField(_SearchBox, "type", "SearchBox");
var SearchBox = _SearchBox;

// dist/src/parser/classes/BrowseFeedActions.js
var _BrowseFeedActions = class _BrowseFeedActions extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data2.contents, [SubFeedSelector, EomSettingsDisclaimer, ToggleButton, CompactLink, SearchBox, Button]);
  }
};
__name(_BrowseFeedActions, "BrowseFeedActions");
__publicField(_BrowseFeedActions, "type", "BrowseFeedActions");
var BrowseFeedActions = _BrowseFeedActions;

// dist/src/parser/classes/BrowserMediaSession.js
var _BrowserMediaSession = class _BrowserMediaSession extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "album");
    __publicField(this, "thumbnails");
    this.album = new Text2(data2.album);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnailDetails);
  }
};
__name(_BrowserMediaSession, "BrowserMediaSession");
__publicField(_BrowserMediaSession, "type", "BrowserMediaSession");
var BrowserMediaSession = _BrowserMediaSession;

// dist/src/parser/classes/ButtonCardView.js
var _ButtonCardView = class _ButtonCardView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "icon_name");
    __publicField(this, "renderer_context");
    this.title = data2.title;
    this.icon_name = data2.image.sources[0].clientResource.imageName;
    this.renderer_context = new RendererContext(data2.rendererContext);
  }
};
__name(_ButtonCardView, "ButtonCardView");
__publicField(_ButtonCardView, "type", "ButtonCardView");
var ButtonCardView = _ButtonCardView;

// dist/src/parser/classes/ChannelHeaderLinks.js
var _HeaderLink = class _HeaderLink extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "endpoint");
    __publicField(this, "icon");
    __publicField(this, "title");
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.icon = Thumbnail.fromResponse(data2.icon);
    this.title = new Text2(data2.title);
  }
};
__name(_HeaderLink, "HeaderLink");
__publicField(_HeaderLink, "type", "HeaderLink");
var HeaderLink = _HeaderLink;
var _ChannelHeaderLinks = class _ChannelHeaderLinks extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "primary");
    __publicField(this, "secondary");
    this.primary = observe(data2.primaryLinks?.map((link) => new HeaderLink(link)) || []);
    this.secondary = observe(data2.secondaryLinks?.map((link) => new HeaderLink(link)) || []);
  }
};
__name(_ChannelHeaderLinks, "ChannelHeaderLinks");
__publicField(_ChannelHeaderLinks, "type", "ChannelHeaderLinks");
var ChannelHeaderLinks = _ChannelHeaderLinks;

// dist/src/parser/classes/ChannelHeaderLinksView.js
var _ChannelHeaderLinksView = class _ChannelHeaderLinksView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "first_link");
    __publicField(this, "more");
    if (Reflect.has(data2, "firstLink")) {
      this.first_link = Text2.fromAttributed(data2.firstLink);
    }
    if (Reflect.has(data2, "more")) {
      this.more = Text2.fromAttributed(data2.more);
    }
  }
};
__name(_ChannelHeaderLinksView, "ChannelHeaderLinksView");
__publicField(_ChannelHeaderLinksView, "type", "ChannelHeaderLinksView");
var ChannelHeaderLinksView = _ChannelHeaderLinksView;

// dist/src/parser/classes/ClipCreationTextInput.js
var _ClipCreationTextInput = class _ClipCreationTextInput extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "placeholder_text");
    __publicField(this, "max_character_limit");
    this.placeholder_text = new Text2(data2.placeholderText);
    this.max_character_limit = data2.maxCharacterLimit;
  }
};
__name(_ClipCreationTextInput, "ClipCreationTextInput");
__publicField(_ClipCreationTextInput, "type", "ClipCreationTextInput");
var ClipCreationTextInput = _ClipCreationTextInput;

// dist/src/parser/classes/ClipCreationScrubber.js
var _ClipCreationScrubber = class _ClipCreationScrubber extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "length_template");
    __publicField(this, "max_length_ms");
    __publicField(this, "min_length_ms");
    __publicField(this, "default_length_ms");
    __publicField(this, "window_size_ms");
    __publicField(this, "start_label");
    __publicField(this, "end_label");
    __publicField(this, "duration_label");
    this.length_template = data2.lengthTemplate;
    this.max_length_ms = data2.maxLengthMs;
    this.min_length_ms = data2.minLengthMs;
    this.default_length_ms = data2.defaultLengthMs;
    this.window_size_ms = data2.windowSizeMs;
    this.start_label = data2.startAccessibility?.accessibilityData?.label;
    this.end_label = data2.endAccessibility?.accessibilityData?.label;
    this.duration_label = data2.durationAccessibility?.accessibilityData?.label;
  }
};
__name(_ClipCreationScrubber, "ClipCreationScrubber");
__publicField(_ClipCreationScrubber, "type", "ClipCreationScrubber");
var ClipCreationScrubber = _ClipCreationScrubber;

// dist/src/parser/classes/ClipAdState.js
var _ClipAdState = class _ClipAdState extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "body");
    this.title = new Text2(data2.title);
    this.body = new Text2(data2.body);
  }
};
__name(_ClipAdState, "ClipAdState");
__publicField(_ClipAdState, "type", "ClipAdState");
var ClipAdState = _ClipAdState;

// dist/src/parser/classes/ClipCreation.js
var _ClipCreation = class _ClipCreation extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "user_avatar");
    __publicField(this, "title_input");
    __publicField(this, "scrubber");
    __publicField(this, "save_button");
    __publicField(this, "display_name");
    __publicField(this, "publicity_label");
    __publicField(this, "cancel_button");
    __publicField(this, "ad_state_overlay");
    __publicField(this, "external_video_id");
    __publicField(this, "publicity_label_icon");
    this.user_avatar = Thumbnail.fromResponse(data2.userAvatar);
    this.title_input = parser_exports.parseItem(data2.titleInput, [ClipCreationTextInput]);
    this.scrubber = parser_exports.parseItem(data2.scrubber, [ClipCreationScrubber]);
    this.save_button = parser_exports.parseItem(data2.saveButton, [Button]);
    this.display_name = new Text2(data2.displayName);
    this.publicity_label = data2.publicityLabel;
    this.cancel_button = parser_exports.parseItem(data2.cancelButton, [Button]);
    this.ad_state_overlay = parser_exports.parseItem(data2.adStateOverlay, [ClipAdState]);
    this.external_video_id = data2.externalVideoId;
    this.publicity_label_icon = data2.publicityLabelIcon;
  }
};
__name(_ClipCreation, "ClipCreation");
__publicField(_ClipCreation, "type", "ClipCreation");
var ClipCreation = _ClipCreation;

// dist/src/parser/classes/ClipSection.js
var _ClipSection = class _ClipSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parse(data2.contents, true, [ClipCreation]);
  }
};
__name(_ClipSection, "ClipSection");
__publicField(_ClipSection, "type", "ClipSection");
var ClipSection = _ClipSection;

// dist/src/parser/classes/ContinuationItem.js
var _ContinuationItem = class _ContinuationItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "trigger");
    __publicField(this, "button");
    __publicField(this, "endpoint");
    this.trigger = data2.trigger;
    if (Reflect.has(data2, "button")) {
      this.button = parser_exports.parseItem(data2.button, Button);
    }
    this.endpoint = new NavigationEndpoint(data2.continuationEndpoint);
  }
};
__name(_ContinuationItem, "ContinuationItem");
__publicField(_ContinuationItem, "type", "ContinuationItem");
var ContinuationItem = _ContinuationItem;

// dist/src/parser/classes/EngagementPanelTitleHeader.js
var _EngagementPanelTitleHeader = class _EngagementPanelTitleHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "visibility_button");
    __publicField(this, "contextual_info");
    __publicField(this, "menu");
    this.title = new Text2(data2.title);
    this.contextual_info = data2.contextualInfo ? new Text2(data2.contextualInfo) : void 0;
    this.visibility_button = parser_exports.parseItem(data2.visibilityButton, Button);
    this.menu = parser_exports.parseItem(data2.menu);
  }
};
__name(_EngagementPanelTitleHeader, "EngagementPanelTitleHeader");
__publicField(_EngagementPanelTitleHeader, "type", "EngagementPanelTitleHeader");
var EngagementPanelTitleHeader = _EngagementPanelTitleHeader;

// dist/src/parser/classes/MacroMarkersInfoItem.js
var _MacroMarkersInfoItem = class _MacroMarkersInfoItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "info_text");
    __publicField(this, "menu");
    this.info_text = new Text2(data2.infoText);
    this.menu = parser_exports.parseItem(data2.menu, Menu);
  }
};
__name(_MacroMarkersInfoItem, "MacroMarkersInfoItem");
__publicField(_MacroMarkersInfoItem, "type", "MacroMarkersInfoItem");
var MacroMarkersInfoItem = _MacroMarkersInfoItem;

// dist/src/parser/classes/MacroMarkersListItem.js
var _MacroMarkersListItem = class _MacroMarkersListItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "time_description");
    __publicField(this, "thumbnail");
    __publicField(this, "on_tap_endpoint");
    __publicField(this, "layout");
    __publicField(this, "is_highlighted");
    this.title = new Text2(data2.title);
    this.time_description = new Text2(data2.timeDescription);
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.on_tap_endpoint = new NavigationEndpoint(data2.onTap);
    this.layout = data2.layout;
    this.is_highlighted = !!data2.isHighlighted;
  }
};
__name(_MacroMarkersListItem, "MacroMarkersListItem");
__publicField(_MacroMarkersListItem, "type", "MacroMarkersListItem");
var MacroMarkersListItem = _MacroMarkersListItem;

// dist/src/parser/classes/MacroMarkersList.js
var _MacroMarkersList = class _MacroMarkersList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    __publicField(this, "sync_button_label");
    this.contents = parser_exports.parseArray(data2.contents, [MacroMarkersInfoItem, MacroMarkersListItem]);
    this.sync_button_label = new Text2(data2.syncButtonLabel);
  }
};
__name(_MacroMarkersList, "MacroMarkersList");
__publicField(_MacroMarkersList, "type", "MacroMarkersList");
var MacroMarkersList = _MacroMarkersList;

// dist/src/parser/classes/ProductList.js
var _ProductList = class _ProductList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data2.contents);
  }
};
__name(_ProductList, "ProductList");
__publicField(_ProductList, "type", "ProductList");
var ProductList = _ProductList;

// dist/src/parser/classes/SectionList.js
var _SectionList = class _SectionList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    __publicField(this, "target_id");
    __publicField(this, "continuation");
    __publicField(this, "header");
    __publicField(this, "sub_menu");
    this.contents = parser_exports.parseArray(data2.contents);
    if (Reflect.has(data2, "targetId")) {
      this.target_id = data2.targetId;
    }
    if (Reflect.has(data2, "continuations")) {
      if (Reflect.has(data2.continuations[0], "nextContinuationData")) {
        this.continuation = data2.continuations[0].nextContinuationData.continuation;
      } else if (Reflect.has(data2.continuations[0], "reloadContinuationData")) {
        this.continuation = data2.continuations[0].reloadContinuationData.continuation;
      }
    }
    if (Reflect.has(data2, "header")) {
      this.header = parser_exports.parseItem(data2.header);
    }
    if (Reflect.has(data2, "subMenu")) {
      this.sub_menu = parser_exports.parseItem(data2.subMenu);
    }
  }
};
__name(_SectionList, "SectionList");
__publicField(_SectionList, "type", "SectionList");
var SectionList = _SectionList;

// dist/src/parser/classes/ExpandableVideoDescriptionBody.js
var _ExpandableVideoDescriptionBody = class _ExpandableVideoDescriptionBody extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "show_more_text");
    __publicField(this, "show_less_text");
    __publicField(this, "attributed_description_body_text");
    this.show_more_text = new Text2(data2.showMoreText);
    this.show_less_text = new Text2(data2.showLessText);
    if (Reflect.has(data2, "attributedDescriptionBodyText")) {
      this.attributed_description_body_text = Text2.fromAttributed(data2.attributedDescriptionBodyText);
    }
  }
};
__name(_ExpandableVideoDescriptionBody, "ExpandableVideoDescriptionBody");
__publicField(_ExpandableVideoDescriptionBody, "type", "ExpandableVideoDescriptionBody");
var ExpandableVideoDescriptionBody = _ExpandableVideoDescriptionBody;

// dist/src/parser/classes/SearchRefinementCard.js
var _SearchRefinementCard = class _SearchRefinementCard extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnails");
    __publicField(this, "endpoint");
    __publicField(this, "query");
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.endpoint = new NavigationEndpoint(data2.searchEndpoint);
    this.query = new Text2(data2.query).toString();
  }
};
__name(_SearchRefinementCard, "SearchRefinementCard");
__publicField(_SearchRefinementCard, "type", "SearchRefinementCard");
var SearchRefinementCard = _SearchRefinementCard;

// dist/src/parser/classes/GameCard.js
var _GameCard = class _GameCard extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "game");
    this.game = parser_exports.parseItem(data2.game);
  }
};
__name(_GameCard, "GameCard");
__publicField(_GameCard, "type", "GameCard");
var GameCard = _GameCard;

// dist/src/parser/classes/HorizontalList.js
var _HorizontalList = class _HorizontalList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "visible_item_count");
    __publicField(this, "items");
    this.visible_item_count = data2.visibleItemCount;
    this.items = parser_exports.parseArray(data2.items);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_HorizontalList, "HorizontalList");
__publicField(_HorizontalList, "type", "HorizontalList");
var HorizontalList = _HorizontalList;

// dist/src/parser/classes/ExpandableMetadata.js
var _ExpandableMetadata = class _ExpandableMetadata extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "expanded_content");
    __publicField(this, "expand_button");
    __publicField(this, "collapse_button");
    if (Reflect.has(data2, "header")) {
      this.header = {
        collapsed_title: new Text2(data2.header.collapsedTitle),
        collapsed_thumbnail: Thumbnail.fromResponse(data2.header.collapsedThumbnail),
        collapsed_label: new Text2(data2.header.collapsedLabel),
        expanded_title: new Text2(data2.header.expandedTitle)
      };
    }
    this.expanded_content = parser_exports.parseItem(data2.expandedContent, [HorizontalCardList, HorizontalList]);
    this.expand_button = parser_exports.parseItem(data2.expandButton, Button);
    this.collapse_button = parser_exports.parseItem(data2.collapseButton, Button);
  }
};
__name(_ExpandableMetadata, "ExpandableMetadata");
__publicField(_ExpandableMetadata, "type", "ExpandableMetadata");
var ExpandableMetadata = _ExpandableMetadata;

// dist/src/parser/classes/MetadataBadge.js
var _MetadataBadge = class _MetadataBadge extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "icon_type");
    __publicField(this, "style");
    __publicField(this, "label");
    __publicField(this, "tooltip");
    if (Reflect.has(data2, "icon")) {
      this.icon_type = data2.icon.iconType;
    }
    if (Reflect.has(data2, "style")) {
      this.style = data2.style;
    }
    if (Reflect.has(data2, "label")) {
      this.label = data2.label;
    }
    if (Reflect.has(data2, "tooltip") || Reflect.has(data2, "iconTooltip")) {
      this.tooltip = data2.tooltip || data2.iconTooltip;
    }
  }
};
__name(_MetadataBadge, "MetadataBadge");
__publicField(_MetadataBadge, "type", "MetadataBadge");
var MetadataBadge = _MetadataBadge;

// dist/src/parser/classes/ThumbnailOverlayTimeStatus.js
var _ThumbnailOverlayTimeStatus = class _ThumbnailOverlayTimeStatus extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "style");
    this.text = new Text2(data2.text).toString();
    this.style = data2.style;
  }
};
__name(_ThumbnailOverlayTimeStatus, "ThumbnailOverlayTimeStatus");
__publicField(_ThumbnailOverlayTimeStatus, "type", "ThumbnailOverlayTimeStatus");
var ThumbnailOverlayTimeStatus = _ThumbnailOverlayTimeStatus;

// dist/src/parser/classes/Video.js
var _Video = class _Video extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "video_id");
    __publicField(this, "title");
    __publicField(this, "untranslated_title");
    __publicField(this, "description_snippet");
    __publicField(this, "snippets");
    __publicField(this, "expandable_metadata");
    __publicField(this, "additional_metadatas");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "rich_thumbnail");
    __publicField(this, "author");
    __publicField(this, "badges");
    __publicField(this, "endpoint");
    __publicField(this, "published");
    __publicField(this, "view_count");
    __publicField(this, "short_view_count");
    __publicField(this, "upcoming");
    __publicField(this, "length_text");
    __publicField(this, "show_action_menu");
    __publicField(this, "is_watched");
    __publicField(this, "menu");
    __publicField(this, "byline_text");
    __publicField(this, "search_video_result_entity_key");
    __publicField(this, "service_endpoints");
    __publicField(this, "service_endpoint");
    __publicField(this, "style");
    this.title = new Text2(data2.title);
    this.video_id = data2.videoId;
    this.expandable_metadata = parser_exports.parseItem(data2.expandableMetadata, ExpandableMetadata);
    if ("untranslatedTitle" in data2)
      this.untranslated_title = new Text2(data2.untranslatedTitle);
    if ("descriptionSnippet" in data2)
      this.description_snippet = new Text2(data2.descriptionSnippet);
    if ("detailedMetadataSnippets" in data2) {
      this.snippets = data2.detailedMetadataSnippets.map((snippet) => ({
        text: new Text2(snippet.snippetText),
        hover_text: new Text2(snippet.snippetHoverText)
      }));
    }
    if ("additionalMetadatas" in data2)
      this.additional_metadatas = data2.additionalMetadatas.map((meta) => new Text2(meta));
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.thumbnail_overlays = parser_exports.parseArray(data2.thumbnailOverlays);
    if ("richThumbnail" in data2)
      this.rich_thumbnail = parser_exports.parseItem(data2.richThumbnail);
    this.author = new Author(data2.ownerText, data2.ownerBadges, data2.channelThumbnailSupportedRenderers?.channelThumbnailWithLinkRenderer?.thumbnail);
    this.badges = parser_exports.parseArray(data2.badges, MetadataBadge);
    if ("navigationEndpoint" in data2)
      this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    if ("publishedTimeText" in data2)
      this.published = new Text2(data2.publishedTimeText);
    if ("viewCountText" in data2)
      this.view_count = new Text2(data2.viewCountText);
    if ("shortViewCountText" in data2)
      this.short_view_count = new Text2(data2.shortViewCountText);
    if ("upcomingEventData" in data2)
      this.upcoming = new Date(Number(`${data2.upcomingEventData.startTime}000`));
    this.show_action_menu = !!data2.showActionMenu;
    this.is_watched = !!data2.isWatched;
    this.menu = parser_exports.parseItem(data2.menu, Menu);
    if ("searchVideoResultEntityKey" in data2)
      this.search_video_result_entity_key = data2.searchVideoResultEntityKey;
    if ("bylineText" in data2)
      this.byline_text = new Text2(data2.bylineText);
    if ("lengthText" in data2)
      this.length_text = new Text2(data2.lengthText);
    if ("serviceEndpoints" in data2)
      this.service_endpoints = data2.serviceEndpoints.map((endpoint) => new NavigationEndpoint(endpoint));
    if ("serviceEndpoint" in data2)
      this.service_endpoint = new NavigationEndpoint(data2.serviceEndpoint);
    if ("style" in data2)
      this.style = data2.style;
  }
  /**
   * @deprecated Use {@linkcode video_id} instead.
   */
  get id() {
    return this.video_id;
  }
  get description() {
    if (this.snippets)
      return this.snippets.map((snip) => snip.text.toString()).join("");
    return this.description_snippet?.toString() || "";
  }
  get is_live() {
    return this.badges.some((badge) => {
      if (badge.style === "BADGE_STYLE_TYPE_LIVE_NOW" || badge.label === "LIVE")
        return true;
    }) || this.thumbnail_overlays.firstOfType(ThumbnailOverlayTimeStatus)?.style === "LIVE";
  }
  get is_upcoming() {
    return this.upcoming && this.upcoming > /* @__PURE__ */ new Date();
  }
  get is_premiere() {
    return this.badges.some((badge) => badge.label === "PREMIERE");
  }
  get is_4k() {
    return this.badges.some((badge) => badge.label === "4K");
  }
  get has_captions() {
    return this.badges.some((badge) => badge.label === "CC");
  }
  get best_thumbnail() {
    return this.thumbnails[0];
  }
  get duration() {
    const overlay_time_status = this.thumbnail_overlays.firstOfType(ThumbnailOverlayTimeStatus);
    const length_text = this.length_text?.toString() || overlay_time_status?.text.toString();
    return {
      text: length_text,
      seconds: length_text ? timeToSeconds(length_text) : 0
    };
  }
};
__name(_Video, "Video");
__publicField(_Video, "type", "Video");
var Video = _Video;

// dist/src/parser/classes/VideoCard.js
var _VideoCard = class _VideoCard extends Video {
  constructor(data2) {
    super(data2);
    __publicField(this, "metadata_text");
    if (Reflect.has(data2, "metadataText")) {
      this.metadata_text = new Text2(data2.metadataText);
      if (this.metadata_text.text) {
        this.short_view_count = new Text2({ simpleText: this.metadata_text.text.split("\xB7")[0]?.trim() });
        this.published = new Text2({ simpleText: this.metadata_text.text.split("\xB7")[1]?.trim() });
      }
    }
    if (Reflect.has(data2, "bylineText")) {
      this.author = new Author(data2.bylineText, data2.ownerBadges, data2.channelThumbnailSupportedRenderers?.channelThumbnailWithLinkRenderer?.thumbnail);
    }
  }
};
__name(_VideoCard, "VideoCard");
__publicField(_VideoCard, "type", "VideoCard");
var VideoCard = _VideoCard;

// dist/src/parser/classes/ContentPreviewImageView.js
var _ContentPreviewImageView = class _ContentPreviewImageView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "image");
    __publicField(this, "style");
    this.image = Thumbnail.fromResponse(data2.image);
    this.style = data2.style;
  }
};
__name(_ContentPreviewImageView, "ContentPreviewImageView");
__publicField(_ContentPreviewImageView, "type", "ContentPreviewImageView");
var ContentPreviewImageView = _ContentPreviewImageView;

// dist/src/parser/classes/VideoAttributeView.js
var _VideoAttributeView = class _VideoAttributeView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "image");
    __publicField(this, "image_style");
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "secondary_subtitle");
    __publicField(this, "orientation");
    __publicField(this, "sizing_rule");
    __publicField(this, "overflow_menu_on_tap");
    __publicField(this, "overflow_menu_a11y_label");
    if (data2.image?.sources) {
      this.image = Thumbnail.fromResponse(data2.image);
    } else {
      this.image = parser_exports.parseItem(data2.image, ContentPreviewImageView);
    }
    this.image_style = data2.imageStyle;
    this.title = data2.title;
    this.subtitle = data2.subtitle;
    if (Reflect.has(data2, "secondarySubtitle")) {
      this.secondary_subtitle = {
        content: data2.secondarySubtitle.content
      };
    }
    this.orientation = data2.orientation;
    this.sizing_rule = data2.sizingRule;
    this.overflow_menu_on_tap = new NavigationEndpoint(data2.overflowMenuOnTap);
    this.overflow_menu_a11y_label = data2.overflowMenuA11yLabel;
  }
};
__name(_VideoAttributeView, "VideoAttributeView");
__publicField(_VideoAttributeView, "type", "VideoAttributeView");
var VideoAttributeView = _VideoAttributeView;

// dist/src/parser/classes/HorizontalCardList.js
var _HorizontalCardList = class _HorizontalCardList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "cards");
    __publicField(this, "header");
    __publicField(this, "previous_button");
    __publicField(this, "next_button");
    this.cards = parser_exports.parseArray(data2.cards, [VideoAttributeView, SearchRefinementCard, MacroMarkersListItem, GameCard, VideoCard]);
    this.header = parser_exports.parseItem(data2.header);
    this.previous_button = parser_exports.parseItem(data2.previousButton, Button);
    this.next_button = parser_exports.parseItem(data2.nextButton, Button);
  }
};
__name(_HorizontalCardList, "HorizontalCardList");
__publicField(_HorizontalCardList, "type", "HorizontalCardList");
var HorizontalCardList = _HorizontalCardList;

// dist/src/parser/classes/Factoid.js
var _Factoid = class _Factoid extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "label");
    __publicField(this, "value");
    __publicField(this, "accessibility_text");
    this.label = new Text2(data2.label);
    this.value = new Text2(data2.value);
    this.accessibility_text = data2.accessibilityText;
  }
};
__name(_Factoid, "Factoid");
__publicField(_Factoid, "type", "Factoid");
var Factoid = _Factoid;

// dist/src/parser/classes/UploadTimeFactoid.js
var _UploadTimeFactoid = class _UploadTimeFactoid extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "factoid");
    this.factoid = parser_exports.parseItem(data2.factoid, Factoid);
  }
};
__name(_UploadTimeFactoid, "UploadTimeFactoid");
__publicField(_UploadTimeFactoid, "type", "UploadTimeFactoid");
var UploadTimeFactoid = _UploadTimeFactoid;

// dist/src/parser/classes/ViewCountFactoid.js
var _ViewCountFactoid = class _ViewCountFactoid extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "view_count_entity_key");
    __publicField(this, "factoid");
    __publicField(this, "view_count_type");
    this.view_count_entity_key = data2.viewCountEntityKey;
    this.factoid = parser_exports.parseItem(data2.factoid, [Factoid]);
    this.view_count_type = data2.viewCountType;
  }
};
__name(_ViewCountFactoid, "ViewCountFactoid");
__publicField(_ViewCountFactoid, "type", "ViewCountFactoid");
var ViewCountFactoid = _ViewCountFactoid;

// dist/src/parser/classes/HypePointsFactoid.js
var _HypePointsFactoid = class _HypePointsFactoid extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "factoid");
    this.factoid = parser_exports.parseItem(data2.factoid, Factoid);
  }
};
__name(_HypePointsFactoid, "HypePointsFactoid");
__publicField(_HypePointsFactoid, "type", "HypePointsFactoid");
var HypePointsFactoid = _HypePointsFactoid;

// dist/src/parser/classes/VideoDescriptionHeader.js
var _VideoDescriptionHeader = class _VideoDescriptionHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "channel");
    __publicField(this, "channel_navigation_endpoint");
    __publicField(this, "channel_thumbnail");
    __publicField(this, "factoids");
    __publicField(this, "publish_date");
    __publicField(this, "title");
    __publicField(this, "views");
    this.title = new Text2(data2.title);
    this.channel = new Text2(data2.channel);
    this.channel_navigation_endpoint = new NavigationEndpoint(data2.channelNavigationEndpoint);
    this.channel_thumbnail = Thumbnail.fromResponse(data2.channelThumbnail);
    this.publish_date = new Text2(data2.publishDate);
    this.views = new Text2(data2.views);
    this.factoids = parser_exports.parseArray(data2.factoid, [Factoid, HypePointsFactoid, ViewCountFactoid, UploadTimeFactoid]);
  }
};
__name(_VideoDescriptionHeader, "VideoDescriptionHeader");
__publicField(_VideoDescriptionHeader, "type", "VideoDescriptionHeader");
var VideoDescriptionHeader = _VideoDescriptionHeader;

// dist/src/parser/classes/VideoDescriptionInfocardsSection.js
var _VideoDescriptionInfocardsSection = class _VideoDescriptionInfocardsSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "section_title");
    __publicField(this, "creator_videos_button");
    __publicField(this, "creator_about_button");
    __publicField(this, "section_subtitle");
    __publicField(this, "channel_avatar");
    __publicField(this, "channel_endpoint");
    this.section_title = new Text2(data2.sectionTitle);
    this.creator_videos_button = parser_exports.parseItem(data2.creatorVideosButton, Button);
    this.creator_about_button = parser_exports.parseItem(data2.creatorAboutButton, Button);
    this.section_subtitle = new Text2(data2.sectionSubtitle);
    this.channel_avatar = Thumbnail.fromResponse(data2.channelAvatar);
    this.channel_endpoint = new NavigationEndpoint(data2.channelEndpoint);
  }
};
__name(_VideoDescriptionInfocardsSection, "VideoDescriptionInfocardsSection");
__publicField(_VideoDescriptionInfocardsSection, "type", "VideoDescriptionInfocardsSection");
var VideoDescriptionInfocardsSection = _VideoDescriptionInfocardsSection;

// dist/src/parser/classes/InfoRow.js
var _InfoRow = class _InfoRow extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "default_metadata");
    __publicField(this, "expanded_metadata");
    __publicField(this, "info_row_expand_status_key");
    this.title = new Text2(data2.title);
    if (Reflect.has(data2, "defaultMetadata")) {
      this.default_metadata = new Text2(data2.defaultMetadata);
    }
    if (Reflect.has(data2, "expandedMetadata")) {
      this.expanded_metadata = new Text2(data2.expandedMetadata);
    }
    if (Reflect.has(data2, "infoRowExpandStatusKey")) {
      this.info_row_expand_status_key = data2.infoRowExpandStatusKey;
    }
  }
};
__name(_InfoRow, "InfoRow");
__publicField(_InfoRow, "type", "InfoRow");
var InfoRow = _InfoRow;

// dist/src/parser/classes/CompactVideo.js
var _CompactVideo = class _CompactVideo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "video_id");
    __publicField(this, "thumbnails");
    __publicField(this, "rich_thumbnail");
    __publicField(this, "title");
    __publicField(this, "author");
    __publicField(this, "view_count");
    __publicField(this, "short_view_count");
    __publicField(this, "short_byline_text");
    __publicField(this, "long_byline_text");
    __publicField(this, "published");
    __publicField(this, "badges");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "endpoint");
    __publicField(this, "menu");
    __publicField(this, "length_text");
    __publicField(this, "is_watched");
    __publicField(this, "service_endpoints");
    __publicField(this, "service_endpoint");
    __publicField(this, "style");
    this.video_id = data2.videoId;
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.title = new Text2(data2.title);
    this.author = new Author(data2.longBylineText, data2.ownerBadges, data2.channelThumbnail);
    this.is_watched = !!data2.isWatched;
    this.thumbnail_overlays = parser_exports.parseArray(data2.thumbnailOverlays);
    this.menu = parser_exports.parseItem(data2.menu, Menu);
    this.badges = parser_exports.parseArray(data2.badges, MetadataBadge);
    if ("publishedTimeText" in data2)
      this.published = new Text2(data2.publishedTimeText);
    if ("shortBylineText" in data2)
      this.view_count = new Text2(data2.viewCountText);
    if ("shortViewCountText" in data2)
      this.short_view_count = new Text2(data2.shortViewCountText);
    if ("richThumbnail" in data2)
      this.rich_thumbnail = parser_exports.parseItem(data2.richThumbnail);
    if ("shortBylineText" in data2)
      this.short_byline_text = new Text2(data2.shortBylineText);
    if ("longBylineText" in data2)
      this.long_byline_text = new Text2(data2.longBylineText);
    if ("lengthText" in data2)
      this.length_text = new Text2(data2.lengthText);
    if ("serviceEndpoints" in data2)
      this.service_endpoints = data2.serviceEndpoints.map((endpoint) => new NavigationEndpoint(endpoint));
    if ("serviceEndpoint" in data2)
      this.service_endpoint = new NavigationEndpoint(data2.serviceEndpoint);
    if ("navigationEndpoint" in data2)
      this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    if ("style" in data2)
      this.style = data2.style;
  }
  /**
   * @deprecated Use {@linkcode video_id} instead.
   */
  get id() {
    return this.video_id;
  }
  get duration() {
    const overlay_time_status = this.thumbnail_overlays.firstOfType(ThumbnailOverlayTimeStatus);
    const length_text = this.length_text?.toString() || overlay_time_status?.text.toString();
    return {
      text: length_text,
      seconds: length_text ? timeToSeconds(length_text) : 0
    };
  }
  get best_thumbnail() {
    return this.thumbnails[0];
  }
  get is_fundraiser() {
    return this.badges.some((badge) => badge.label === "Fundraiser");
  }
  get is_live() {
    return this.badges.some((badge) => {
      if (badge.style === "BADGE_STYLE_TYPE_LIVE_NOW" || badge.label === "LIVE")
        return true;
    });
  }
  get is_new() {
    return this.badges.some((badge) => badge.label === "New");
  }
  get is_premiere() {
    return this.badges.some((badge) => badge.style === "PREMIERE");
  }
};
__name(_CompactVideo, "CompactVideo");
__publicField(_CompactVideo, "type", "CompactVideo");
var CompactVideo = _CompactVideo;

// dist/src/parser/classes/CarouselLockup.js
var _CarouselLockup = class _CarouselLockup extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "info_rows");
    __publicField(this, "video_lockup");
    this.info_rows = parser_exports.parseArray(data2.infoRows, InfoRow);
    this.video_lockup = parser_exports.parseItem(data2.videoLockup, CompactVideo);
  }
};
__name(_CarouselLockup, "CarouselLockup");
__publicField(_CarouselLockup, "type", "CarouselLockup");
var CarouselLockup = _CarouselLockup;

// dist/src/parser/classes/VideoDescriptionMusicSection.js
var _VideoDescriptionMusicSection = class _VideoDescriptionMusicSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "carousel_lockups");
    __publicField(this, "section_title");
    this.carousel_lockups = parser_exports.parseArray(data2.carouselLockups, CarouselLockup);
    this.section_title = new Text2(data2.sectionTitle);
  }
};
__name(_VideoDescriptionMusicSection, "VideoDescriptionMusicSection");
__publicField(_VideoDescriptionMusicSection, "type", "VideoDescriptionMusicSection");
var VideoDescriptionMusicSection = _VideoDescriptionMusicSection;

// dist/src/parser/classes/VideoDescriptionTranscriptSection.js
var _VideoDescriptionTranscriptSection = class _VideoDescriptionTranscriptSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "section_title");
    __publicField(this, "sub_header_text");
    __publicField(this, "primary_button");
    this.section_title = new Text2(data2.sectionTitle);
    this.sub_header_text = new Text2(data2.subHeaderText);
    this.primary_button = parser_exports.parseItem(data2.primaryButton, Button);
  }
};
__name(_VideoDescriptionTranscriptSection, "VideoDescriptionTranscriptSection");
__publicField(_VideoDescriptionTranscriptSection, "type", "VideoDescriptionTranscriptSection");
var VideoDescriptionTranscriptSection = _VideoDescriptionTranscriptSection;

// dist/src/parser/classes/StructuredDescriptionPlaylistLockup.js
var _StructuredDescriptionPlaylistLockup = class _StructuredDescriptionPlaylistLockup extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "title");
    __publicField(this, "short_byline_text");
    __publicField(this, "video_count_short_text");
    __publicField(this, "endpoint");
    __publicField(this, "thumbnail_width");
    __publicField(this, "aspect_ratio");
    __publicField(this, "max_lines_title");
    __publicField(this, "max_lines_short_byline_text");
    __publicField(this, "overlay_position");
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.title = new Text2(data2.title);
    this.short_byline_text = new Text2(data2.shortBylineText);
    this.video_count_short_text = new Text2(data2.videoCountShortText);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.thumbnail_width = data2.thumbnailWidth;
    this.aspect_ratio = data2.aspectRatio;
    this.max_lines_title = data2.maxLinesTitle;
    this.max_lines_short_byline_text = data2.maxLinesShortBylineText;
    this.overlay_position = data2.overlayPosition;
  }
};
__name(_StructuredDescriptionPlaylistLockup, "StructuredDescriptionPlaylistLockup");
__publicField(_StructuredDescriptionPlaylistLockup, "type", "StructuredDescriptionPlaylistLockup");
var StructuredDescriptionPlaylistLockup = _StructuredDescriptionPlaylistLockup;

// dist/src/parser/classes/VideoDescriptionCourseSection.js
var _VideoDescriptionCourseSection = class _VideoDescriptionCourseSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "section_title");
    __publicField(this, "media_lockups");
    this.section_title = new Text2(data2.sectionTitle);
    this.media_lockups = parser_exports.parseArray(data2.mediaLockups, [StructuredDescriptionPlaylistLockup]);
  }
};
__name(_VideoDescriptionCourseSection, "VideoDescriptionCourseSection");
__publicField(_VideoDescriptionCourseSection, "type", "VideoDescriptionCourseSection");
var VideoDescriptionCourseSection = _VideoDescriptionCourseSection;

// dist/src/parser/classes/VideoAttributesSectionView.js
var _VideoAttributesSectionView = class _VideoAttributesSectionView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header_title");
    __publicField(this, "header_subtitle");
    __publicField(this, "video_attributes");
    __publicField(this, "previous_button");
    __publicField(this, "next_button");
    this.header_title = data2.headerTitle;
    this.header_subtitle = data2.headerSubtitle;
    this.video_attributes = parser_exports.parseArray(data2.videoAttributeViewModels, VideoAttributeView);
    this.previous_button = parser_exports.parseItem(data2.previousButton, ButtonView);
    this.next_button = parser_exports.parseItem(data2.nextButton, ButtonView);
  }
};
__name(_VideoAttributesSectionView, "VideoAttributesSectionView");
__publicField(_VideoAttributesSectionView, "type", "VideoAttributesSectionView");
var VideoAttributesSectionView = _VideoAttributesSectionView;

// dist/src/parser/classes/HowThisWasMadeSectionView.js
var _HowThisWasMadeSectionView = class _HowThisWasMadeSectionView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "section_title");
    __publicField(this, "body_text");
    __publicField(this, "body_header");
    if (Reflect.has(data2, "sectionText"))
      this.section_title = Text2.fromAttributed(data2.sectionText);
    if (Reflect.has(data2, "bodyText"))
      this.body_text = Text2.fromAttributed(data2.bodyText);
    if (Reflect.has(data2, "bodyHeader"))
      this.body_header = Text2.fromAttributed(data2.bodyHeader);
  }
};
__name(_HowThisWasMadeSectionView, "HowThisWasMadeSectionView");
__publicField(_HowThisWasMadeSectionView, "type", "HowThisWasMadeSectionView");
var HowThisWasMadeSectionView = _HowThisWasMadeSectionView;

// dist/src/parser/classes/ReelShelf.js
var _ReelShelf = class _ReelShelf extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "items");
    __publicField(this, "endpoint");
    this.title = new Text2(data2.title);
    this.items = parser_exports.parseArray(data2.items);
    if (Reflect.has(data2, "endpoint")) {
      this.endpoint = new NavigationEndpoint(data2.endpoint);
    }
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_ReelShelf, "ReelShelf");
__publicField(_ReelShelf, "type", "ReelShelf");
var ReelShelf = _ReelShelf;

// dist/src/parser/classes/StructuredDescriptionContent.js
var _StructuredDescriptionContent = class _StructuredDescriptionContent extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data2.items, [
      VideoDescriptionHeader,
      ExpandableVideoDescriptionBody,
      VideoDescriptionMusicSection,
      VideoDescriptionInfocardsSection,
      VideoDescriptionCourseSection,
      VideoDescriptionTranscriptSection,
      VideoDescriptionTranscriptSection,
      HorizontalCardList,
      ReelShelf,
      VideoAttributesSectionView,
      HowThisWasMadeSectionView
    ]);
  }
};
__name(_StructuredDescriptionContent, "StructuredDescriptionContent");
__publicField(_StructuredDescriptionContent, "type", "StructuredDescriptionContent");
var StructuredDescriptionContent = _StructuredDescriptionContent;

// dist/src/parser/classes/EngagementPanelSectionList.js
var _EngagementPanelSectionList = class _EngagementPanelSectionList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "content");
    __publicField(this, "target_id");
    __publicField(this, "panel_identifier");
    __publicField(this, "identifier");
    __publicField(this, "visibility");
    this.header = parser_exports.parseItem(data2.header, EngagementPanelTitleHeader);
    this.content = parser_exports.parseItem(data2.content, [VideoAttributeView, SectionList, ContinuationItem, ClipSection, StructuredDescriptionContent, MacroMarkersList, ProductList]);
    this.panel_identifier = data2.panelIdentifier;
    this.identifier = data2.identifier ? {
      surface: data2.identifier.surface,
      tag: data2.identifier.tag
    } : void 0;
    this.target_id = data2.targetId;
    this.visibility = data2.visibility;
  }
};
__name(_EngagementPanelSectionList, "EngagementPanelSectionList");
__publicField(_EngagementPanelSectionList, "type", "EngagementPanelSectionList");
var EngagementPanelSectionList = _EngagementPanelSectionList;

// dist/src/parser/classes/ChannelTagline.js
var _ChannelTagline = class _ChannelTagline extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "content");
    __publicField(this, "max_lines");
    __publicField(this, "more_endpoint");
    __publicField(this, "more_icon_type");
    __publicField(this, "more_label");
    __publicField(this, "target_id");
    this.content = data2.content;
    this.max_lines = data2.maxLines;
    this.more_endpoint = data2.moreEndpoint.showEngagementPanelEndpoint ? {
      show_engagement_panel_endpoint: {
        engagement_panel: parser_exports.parseItem(data2.moreEndpoint.showEngagementPanelEndpoint.engagementPanel, EngagementPanelSectionList),
        engagement_panel_popup_type: data2.moreEndpoint.showEngagementPanelEndpoint.engagementPanelPresentationConfigs.engagementPanelPopupPresentationConfig.popupType,
        identifier: {
          surface: data2.moreEndpoint.showEngagementPanelEndpoint.identifier.surface,
          tag: data2.moreEndpoint.showEngagementPanelEndpoint.identifier.tag
        }
      }
    } : new NavigationEndpoint(data2.moreEndpoint);
    this.more_icon_type = data2.moreIcon.iconType;
    this.more_label = data2.moreLabel;
    this.target_id = data2.targetId;
  }
};
__name(_ChannelTagline, "ChannelTagline");
__publicField(_ChannelTagline, "type", "ChannelTagline");
var ChannelTagline = _ChannelTagline;

// dist/src/parser/classes/SubscriptionNotificationToggleButton.js
var _SubscriptionNotificationToggleButton = class _SubscriptionNotificationToggleButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "states");
    __publicField(this, "current_state_id");
    __publicField(this, "target_id");
    this.states = data2.states.map((data3) => ({
      id: data3.stateId,
      next_id: data3.nextStateId,
      state: parser_exports.parse(data3.state)
    }));
    this.current_state_id = data2.currentStateId;
    this.target_id = data2.targetId;
  }
};
__name(_SubscriptionNotificationToggleButton, "SubscriptionNotificationToggleButton");
__publicField(_SubscriptionNotificationToggleButton, "type", "SubscriptionNotificationToggleButton");
var SubscriptionNotificationToggleButton = _SubscriptionNotificationToggleButton;

// dist/src/parser/classes/SubscribeButton.js
var _SubscribeButton = class _SubscribeButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "button_text");
    __publicField(this, "subscribed");
    __publicField(this, "enabled");
    __publicField(this, "item_type");
    __publicField(this, "channel_id");
    __publicField(this, "show_preferences");
    __publicField(this, "subscribed_text");
    __publicField(this, "unsubscribed_text");
    __publicField(this, "unsubscribe_text");
    __publicField(this, "notification_preference_button");
    __publicField(this, "service_endpoints");
    __publicField(this, "on_subscribe_endpoints");
    __publicField(this, "on_unsubscribe_endpoints");
    __publicField(this, "subscribed_entity_key");
    __publicField(this, "target_id");
    __publicField(this, "subscribe_accessibility_label");
    __publicField(this, "unsubscribe_accessibility_label");
    this.button_text = new Text2(data2.buttonText);
    this.subscribed = data2.subscribed;
    this.enabled = data2.enabled;
    this.item_type = data2.type;
    this.channel_id = data2.channelId;
    this.show_preferences = data2.showPreferences;
    if (Reflect.has(data2, "subscribedButtonText"))
      this.subscribed_text = new Text2(data2.subscribedButtonText);
    if (Reflect.has(data2, "unsubscribedButtonText"))
      this.unsubscribed_text = new Text2(data2.unsubscribedButtonText);
    if (Reflect.has(data2, "unsubscribeButtonText"))
      this.unsubscribe_text = new Text2(data2.unsubscribeButtonText);
    this.notification_preference_button = parser_exports.parseItem(data2.notificationPreferenceButton, SubscriptionNotificationToggleButton);
    if (Reflect.has(data2, "serviceEndpoints"))
      this.service_endpoints = data2.serviceEndpoints.map((endpoint) => new NavigationEndpoint(endpoint));
    if (Reflect.has(data2, "onSubscribeEndpoints"))
      this.on_subscribe_endpoints = data2.onSubscribeEndpoints.map((endpoint) => new NavigationEndpoint(endpoint));
    if (Reflect.has(data2, "onUnsubscribeEndpoints"))
      this.on_unsubscribe_endpoints = data2.onUnsubscribeEndpoints.map((endpoint) => new NavigationEndpoint(endpoint));
    if (Reflect.has(data2, "subscribedEntityKey"))
      this.subscribed_entity_key = data2.subscribedEntityKey;
    if (Reflect.has(data2, "targetId"))
      this.target_id = data2.targetId;
    if (Reflect.has(data2, "subscribeAccessibility"))
      this.subscribe_accessibility_label = data2.subscribeAccessibility.accessibilityData?.label;
    if (Reflect.has(data2, "unsubscribeAccessibility"))
      this.unsubscribe_accessibility_label = data2.unsubscribeAccessibility.accessibilityData?.label;
  }
};
__name(_SubscribeButton, "SubscribeButton");
__publicField(_SubscribeButton, "type", "SubscribeButton");
var SubscribeButton = _SubscribeButton;

// dist/src/parser/classes/C4TabbedHeader.js
var _C4TabbedHeader = class _C4TabbedHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "author");
    __publicField(this, "banner");
    __publicField(this, "tv_banner");
    __publicField(this, "mobile_banner");
    __publicField(this, "subscribers");
    __publicField(this, "videos_count");
    __publicField(this, "sponsor_button");
    __publicField(this, "subscribe_button");
    __publicField(this, "header_links");
    __publicField(this, "channel_handle");
    __publicField(this, "channel_id");
    __publicField(this, "tagline");
    this.author = new Author({
      simpleText: data2.title,
      navigationEndpoint: data2.navigationEndpoint
    }, data2.badges, data2.avatar);
    if (Reflect.has(data2, "banner")) {
      this.banner = Thumbnail.fromResponse(data2.banner);
    }
    if (Reflect.has(data2, "tv_banner")) {
      this.tv_banner = Thumbnail.fromResponse(data2.tvBanner);
    }
    if (Reflect.has(data2, "mobile_banner")) {
      this.mobile_banner = Thumbnail.fromResponse(data2.mobileBanner);
    }
    if (Reflect.has(data2, "subscriberCountText")) {
      this.subscribers = new Text2(data2.subscriberCountText);
    }
    if (Reflect.has(data2, "videosCountText")) {
      this.videos_count = new Text2(data2.videosCountText);
    }
    if (Reflect.has(data2, "sponsorButton")) {
      this.sponsor_button = parser_exports.parseItem(data2.sponsorButton, Button);
    }
    if (Reflect.has(data2, "subscribeButton")) {
      this.subscribe_button = parser_exports.parseItem(data2.subscribeButton, [SubscribeButton, Button]);
    }
    if (Reflect.has(data2, "headerLinks")) {
      this.header_links = parser_exports.parseItem(data2.headerLinks, [ChannelHeaderLinks, ChannelHeaderLinksView]);
    }
    if (Reflect.has(data2, "channelHandleText")) {
      this.channel_handle = new Text2(data2.channelHandleText);
    }
    if (Reflect.has(data2, "channelId")) {
      this.channel_id = data2.channelId;
    }
    if (Reflect.has(data2, "tagline")) {
      this.tagline = parser_exports.parseItem(data2.tagline, ChannelTagline);
    }
  }
};
__name(_C4TabbedHeader, "C4TabbedHeader");
__publicField(_C4TabbedHeader, "type", "C4TabbedHeader");
var C4TabbedHeader = _C4TabbedHeader;

// dist/src/parser/classes/CallToActionButton.js
var _CallToActionButton = class _CallToActionButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "label");
    __publicField(this, "icon_type");
    __publicField(this, "style");
    this.label = new Text2(data2.label);
    this.icon_type = data2.icon.iconType;
    this.style = data2.style;
  }
};
__name(_CallToActionButton, "CallToActionButton");
__publicField(_CallToActionButton, "type", "CallToActionButton");
var CallToActionButton = _CallToActionButton;

// dist/src/parser/classes/Card.js
var _Card = class _Card extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "teaser");
    __publicField(this, "content");
    __publicField(this, "card_id");
    __publicField(this, "feature");
    __publicField(this, "cue_ranges");
    this.teaser = parser_exports.parseItem(data2.teaser);
    this.content = parser_exports.parseItem(data2.content);
    if (Reflect.has(data2, "cardId")) {
      this.card_id = data2.cardId;
    }
    if (Reflect.has(data2, "feature")) {
      this.feature = data2.feature;
    }
    this.cue_ranges = data2.cueRanges.map((cr) => ({
      start_card_active_ms: cr.startCardActiveMs,
      end_card_active_ms: cr.endCardActiveMs,
      teaser_duration_ms: cr.teaserDurationMs,
      icon_after_teaser_ms: cr.iconAfterTeaserMs
    }));
  }
};
__name(_Card, "Card");
__publicField(_Card, "type", "Card");
var Card = _Card;

// dist/src/parser/classes/CardCollection.js
var _CardCollection = class _CardCollection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "cards");
    __publicField(this, "header");
    __publicField(this, "allow_teaser_dismiss");
    this.cards = parser_exports.parseArray(data2.cards);
    this.header = new Text2(data2.headerText);
    this.allow_teaser_dismiss = data2.allowTeaserDismiss;
  }
};
__name(_CardCollection, "CardCollection");
__publicField(_CardCollection, "type", "CardCollection");
var CardCollection = _CardCollection;

// dist/src/parser/classes/CarouselHeader.js
var _CarouselHeader = class _CarouselHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data2.contents);
  }
};
__name(_CarouselHeader, "CarouselHeader");
__publicField(_CarouselHeader, "type", "CarouselHeader");
var CarouselHeader = _CarouselHeader;

// dist/src/parser/classes/CarouselItem.js
var _CarouselItem = class _CarouselItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    __publicField(this, "background_color");
    __publicField(this, "layout_style");
    __publicField(this, "pagination_thumbnails");
    __publicField(this, "paginator_alignment");
    this.items = parser_exports.parseArray(data2.carouselItems);
    this.background_color = data2.backgroundColor;
    this.layout_style = data2.layoutStyle;
    this.pagination_thumbnails = Thumbnail.fromResponse(data2.paginationThumbnails);
    this.paginator_alignment = data2.paginatorAlignment;
  }
  // XXX: For consistency.
  get contents() {
    return this.items;
  }
};
__name(_CarouselItem, "CarouselItem");
__publicField(_CarouselItem, "type", "CarouselItem");
var CarouselItem = _CarouselItem;

// dist/src/parser/classes/TextCarouselItemView.js
var _TextCarouselItemView = class _TextCarouselItemView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "icon_name");
    __publicField(this, "text");
    __publicField(this, "on_tap_endpoint");
    __publicField(this, "button");
    this.icon_name = data2.iconName;
    this.text = Text2.fromAttributed(data2.text);
    this.on_tap_endpoint = new NavigationEndpoint(data2.onTap);
    this.button = parser_exports.parseItem(data2.button, ButtonView);
  }
};
__name(_TextCarouselItemView, "TextCarouselItemView");
__publicField(_TextCarouselItemView, "type", "TextCarouselItemView");
var TextCarouselItemView = _TextCarouselItemView;

// dist/src/parser/classes/CarouselItemView.js
var _CarouselItemView = class _CarouselItemView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "item_type");
    __publicField(this, "carousel_item");
    this.item_type = data2.itemType;
    this.carousel_item = parser_exports.parseItem(data2.carouselItem, TextCarouselItemView);
  }
};
__name(_CarouselItemView, "CarouselItemView");
__publicField(_CarouselItemView, "type", "CarouselItemView");
var CarouselItemView = _CarouselItemView;

// dist/src/parser/classes/CarouselTitleView.js
var _CarouselTitleView = class _CarouselTitleView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "previous_button");
    __publicField(this, "next_button");
    this.title = data2.title;
    this.previous_button = parser_exports.parseItem(data2.previousButton, ButtonView);
    this.next_button = parser_exports.parseItem(data2.nextButton, ButtonView);
  }
};
__name(_CarouselTitleView, "CarouselTitleView");
__publicField(_CarouselTitleView, "type", "CarouselTitleView");
var CarouselTitleView = _CarouselTitleView;

// dist/src/parser/classes/Channel.js
var _Channel = class _Channel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "author");
    __publicField(this, "subscriber_count");
    __publicField(this, "video_count");
    __publicField(this, "long_byline");
    __publicField(this, "short_byline");
    __publicField(this, "endpoint");
    __publicField(this, "subscribe_button");
    __publicField(this, "description_snippet");
    this.id = data2.channelId;
    this.author = new Author({
      ...data2.title,
      navigationEndpoint: data2.navigationEndpoint
    }, data2.ownerBadges, data2.thumbnail);
    this.subscriber_count = new Text2(data2.subscriberCountText);
    this.video_count = new Text2(data2.videoCountText);
    this.long_byline = new Text2(data2.longBylineText);
    this.short_byline = new Text2(data2.shortBylineText);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.subscribe_button = parser_exports.parseItem(data2.subscribeButton, [SubscribeButton, Button]);
    this.description_snippet = new Text2(data2.descriptionSnippet);
  }
};
__name(_Channel, "Channel");
__publicField(_Channel, "type", "Channel");
var Channel = _Channel;

// dist/src/parser/classes/ChannelAboutFullMetadata.js
var _ChannelAboutFullMetadata = class _ChannelAboutFullMetadata extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "name");
    __publicField(this, "avatar");
    __publicField(this, "canonical_channel_url");
    __publicField(this, "primary_links");
    __publicField(this, "view_count");
    __publicField(this, "joined_date");
    __publicField(this, "description");
    __publicField(this, "email_reveal");
    __publicField(this, "can_reveal_email");
    __publicField(this, "country");
    __publicField(this, "buttons");
    this.id = data2.channelId;
    this.name = new Text2(data2.title);
    this.avatar = Thumbnail.fromResponse(data2.avatar);
    this.canonical_channel_url = data2.canonicalChannelUrl;
    this.primary_links = data2.primaryLinks?.map((link) => ({
      endpoint: new NavigationEndpoint(link.navigationEndpoint),
      icon: Thumbnail.fromResponse(link.icon),
      title: new Text2(link.title)
    })) ?? [];
    this.view_count = new Text2(data2.viewCountText);
    this.joined_date = new Text2(data2.joinedDateText);
    this.description = new Text2(data2.description);
    this.email_reveal = new NavigationEndpoint(data2.onBusinessEmailRevealClickCommand);
    this.can_reveal_email = !data2.signInForBusinessEmail;
    this.country = new Text2(data2.country);
    this.buttons = parser_exports.parseArray(data2.actionButtons, Button);
  }
};
__name(_ChannelAboutFullMetadata, "ChannelAboutFullMetadata");
__publicField(_ChannelAboutFullMetadata, "type", "ChannelAboutFullMetadata");
var ChannelAboutFullMetadata = _ChannelAboutFullMetadata;

// dist/src/parser/classes/ChannelAgeGate.js
var _ChannelAgeGate = class _ChannelAgeGate extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "channel_title");
    __publicField(this, "avatar");
    __publicField(this, "header");
    __publicField(this, "main_text");
    __publicField(this, "sign_in_button");
    __publicField(this, "secondary_text");
    this.channel_title = data2.channelTitle;
    this.avatar = Thumbnail.fromResponse(data2.avatar);
    this.header = new Text2(data2.header);
    this.main_text = new Text2(data2.mainText);
    this.sign_in_button = parser_exports.parseItem(data2.signInButton, Button);
    this.secondary_text = new Text2(data2.secondaryText);
  }
};
__name(_ChannelAgeGate, "ChannelAgeGate");
__publicField(_ChannelAgeGate, "type", "ChannelAgeGate");
var ChannelAgeGate = _ChannelAgeGate;

// dist/src/parser/classes/ChannelFeaturedContent.js
var _ChannelFeaturedContent = class _ChannelFeaturedContent extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "items");
    this.title = new Text2(data2.title);
    this.items = parser_exports.parseArray(data2.items);
  }
};
__name(_ChannelFeaturedContent, "ChannelFeaturedContent");
__publicField(_ChannelFeaturedContent, "type", "ChannelFeaturedContent");
var ChannelFeaturedContent = _ChannelFeaturedContent;

// dist/src/parser/classes/ChannelMetadata.js
var _ChannelMetadata = class _ChannelMetadata extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "url");
    __publicField(this, "rss_url");
    __publicField(this, "vanity_channel_url");
    __publicField(this, "external_id");
    __publicField(this, "is_family_safe");
    __publicField(this, "keywords");
    __publicField(this, "avatar");
    __publicField(this, "music_artist_name");
    __publicField(this, "available_countries");
    __publicField(this, "android_deep_link");
    __publicField(this, "android_appindexing_link");
    __publicField(this, "ios_appindexing_link");
    this.title = data2.title;
    this.description = data2.description;
    this.url = data2.channelUrl;
    this.rss_url = data2.rssUrl;
    this.vanity_channel_url = data2.vanityChannelUrl;
    this.external_id = data2.externalId;
    this.is_family_safe = data2.isFamilySafe;
    this.keywords = data2.keywords;
    this.avatar = Thumbnail.fromResponse(data2.avatar);
    this.music_artist_name = typeof data2.musicArtistName === "string" && data2.musicArtistName.length > 0 ? data2.musicArtistName : void 0;
    this.available_countries = data2.availableCountryCodes;
    this.android_deep_link = data2.androidDeepLink;
    this.android_appindexing_link = data2.androidAppindexingLink;
    this.ios_appindexing_link = data2.iosAppindexingLink;
  }
};
__name(_ChannelMetadata, "ChannelMetadata");
__publicField(_ChannelMetadata, "type", "ChannelMetadata");
var ChannelMetadata = _ChannelMetadata;

// dist/src/parser/classes/ChannelMobileHeader.js
var _ChannelMobileHeader = class _ChannelMobileHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data2.title);
  }
};
__name(_ChannelMobileHeader, "ChannelMobileHeader");
__publicField(_ChannelMobileHeader, "type", "ChannelMobileHeader");
var ChannelMobileHeader = _ChannelMobileHeader;

// dist/src/parser/classes/ChannelOptions.js
var _ChannelOptions = class _ChannelOptions extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "avatar");
    __publicField(this, "endpoint");
    __publicField(this, "name");
    __publicField(this, "links");
    this.avatar = Thumbnail.fromResponse(data2.avatar);
    this.endpoint = new NavigationEndpoint(data2.avatarEndpoint);
    this.name = data2.name;
    this.links = data2.links.map((link) => new Text2(link));
  }
};
__name(_ChannelOptions, "ChannelOptions");
__publicField(_ChannelOptions, "type", "ChannelOptions");
var ChannelOptions = _ChannelOptions;

// dist/src/parser/classes/ChannelOwnerEmptyState.js
var _ChannelOwnerEmptyState = class _ChannelOwnerEmptyState extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "illustration");
    __publicField(this, "description");
    this.illustration = Thumbnail.fromResponse(data2.illustration);
    this.description = new Text2(data2.description);
  }
};
__name(_ChannelOwnerEmptyState, "ChannelOwnerEmptyState");
__publicField(_ChannelOwnerEmptyState, "type", "ChannelOwnerEmptyState");
var ChannelOwnerEmptyState = _ChannelOwnerEmptyState;

// dist/src/parser/classes/ChannelSubMenu.js
var _ChannelSubMenu = class _ChannelSubMenu extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "content_type_sub_menu_items");
    __publicField(this, "sort_setting");
    this.content_type_sub_menu_items = data2.contentTypeSubMenuItems.map((item) => ({
      endpoint: new NavigationEndpoint(item.navigationEndpoint || item.endpoint),
      selected: item.selected,
      title: item.title
    }));
    this.sort_setting = parser_exports.parseItem(data2.sortSetting);
  }
};
__name(_ChannelSubMenu, "ChannelSubMenu");
__publicField(_ChannelSubMenu, "type", "ChannelSubMenu");
var ChannelSubMenu = _ChannelSubMenu;

// dist/src/parser/classes/ChannelSwitcherHeader.js
var _ChannelSwitcherHeader = class _ChannelSwitcherHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "button");
    this.title = new Text2(data2.title).toString();
    if (Reflect.has(data2, "button")) {
      this.button = parser_exports.parseItem(data2.button, Button);
    }
  }
};
__name(_ChannelSwitcherHeader, "ChannelSwitcherHeader");
__publicField(_ChannelSwitcherHeader, "type", "ChannelSwitcherHeader");
var ChannelSwitcherHeader = _ChannelSwitcherHeader;

// dist/src/parser/classes/ChannelThumbnailWithLink.js
var _ChannelThumbnailWithLink = class _ChannelThumbnailWithLink extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnails");
    __publicField(this, "endpoint");
    __publicField(this, "accessibility");
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    if ("accessibility" in data2 && "accessibilityData" in data2.accessibility) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data2.accessibility.accessibilityData)
      };
    }
  }
  get label() {
    return this.accessibility?.accessibility_data?.label;
  }
};
__name(_ChannelThumbnailWithLink, "ChannelThumbnailWithLink");
__publicField(_ChannelThumbnailWithLink, "type", "ChannelThumbnailWithLink");
var ChannelThumbnailWithLink = _ChannelThumbnailWithLink;

// dist/src/parser/classes/ChannelVideoPlayer.js
var _ChannelVideoPlayer = class _ChannelVideoPlayer extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "view_count");
    __publicField(this, "published_time");
    this.id = data2.videoId;
    this.title = new Text2(data2.title);
    this.description = new Text2(data2.description);
    this.view_count = new Text2(data2.viewCountText);
    this.published_time = new Text2(data2.publishedTimeText);
  }
};
__name(_ChannelVideoPlayer, "ChannelVideoPlayer");
__publicField(_ChannelVideoPlayer, "type", "ChannelVideoPlayer");
var ChannelVideoPlayer = _ChannelVideoPlayer;

// dist/src/parser/classes/Chapter.js
var _Chapter = class _Chapter extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "time_range_start_millis");
    __publicField(this, "thumbnail");
    this.title = new Text2(data2.title);
    this.time_range_start_millis = data2.timeRangeStartMillis;
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
  }
};
__name(_Chapter, "Chapter");
__publicField(_Chapter, "type", "Chapter");
var Chapter = _Chapter;

// dist/src/parser/classes/ChildVideo.js
var _ChildVideo = class _ChildVideo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "duration");
    __publicField(this, "endpoint");
    this.id = data2.videoId;
    this.title = new Text2(data2.title);
    this.duration = {
      text: data2.lengthText.simpleText,
      seconds: timeToSeconds(data2.lengthText.simpleText)
    };
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
  }
};
__name(_ChildVideo, "ChildVideo");
__publicField(_ChildVideo, "type", "ChildVideo");
var ChildVideo = _ChildVideo;

// dist/src/parser/classes/ChipView.js
var _ChipView = class _ChipView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "display_type");
    __publicField(this, "endpoint");
    __publicField(this, "chip_entity_key");
    this.text = data2.text;
    this.display_type = data2.displayType;
    this.endpoint = new NavigationEndpoint(data2.tapCommand);
    this.chip_entity_key = data2.chipEntityKey;
  }
};
__name(_ChipView, "ChipView");
__publicField(_ChipView, "type", "ChipView");
var ChipView = _ChipView;

// dist/src/parser/classes/ChipBarView.js
var _ChipBarView = class _ChipBarView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "chips");
    this.chips = parser_exports.parseArray(data2.chips, ChipView);
  }
};
__name(_ChipBarView, "ChipBarView");
__publicField(_ChipBarView, "type", "ChipBarView");
var ChipBarView = _ChipBarView;

// dist/src/parser/classes/ChipCloudChip.js
var _ChipCloudChip = class _ChipCloudChip extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "is_selected");
    __publicField(this, "endpoint");
    __publicField(this, "text");
    this.is_selected = data2.isSelected;
    if (Reflect.has(data2, "navigationEndpoint")) {
      this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    }
    this.text = new Text2(data2.text).toString();
  }
};
__name(_ChipCloudChip, "ChipCloudChip");
__publicField(_ChipCloudChip, "type", "ChipCloudChip");
var ChipCloudChip = _ChipCloudChip;

// dist/src/parser/classes/ChipCloud.js
var _ChipCloud = class _ChipCloud extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "chips");
    __publicField(this, "next_button");
    __publicField(this, "previous_button");
    __publicField(this, "horizontal_scrollable");
    this.chips = parser_exports.parseArray(data2.chips, ChipCloudChip);
    this.next_button = parser_exports.parseItem(data2.nextButton, Button);
    this.previous_button = parser_exports.parseItem(data2.previousButton, Button);
    this.horizontal_scrollable = data2.horizontalScrollable;
  }
};
__name(_ChipCloud, "ChipCloud");
__publicField(_ChipCloud, "type", "ChipCloud");
var ChipCloud = _ChipCloud;

// dist/src/parser/classes/ClientSideToggleMenuItem.js
var _ClientSideToggleMenuItem = class _ClientSideToggleMenuItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "icon_type");
    __publicField(this, "toggled_text");
    __publicField(this, "toggled_icon_type");
    __publicField(this, "is_toggled");
    __publicField(this, "menu_item_identifier");
    __publicField(this, "endpoint");
    __publicField(this, "logging_directives");
    this.text = new Text2(data2.defaultText);
    this.icon_type = data2.defaultIcon.iconType;
    this.toggled_text = new Text2(data2.toggledText);
    this.toggled_icon_type = data2.toggledIcon.iconType;
    if (Reflect.has(data2, "isToggled")) {
      this.is_toggled = data2.isToggled;
    }
    this.menu_item_identifier = data2.menuItemIdentifier;
    this.endpoint = new NavigationEndpoint(data2.command);
    if (Reflect.has(data2, "loggingDirectives")) {
      this.logging_directives = {
        visibility: {
          types: data2.loggingDirectives.visibility.types
        },
        enable_displaylogger_experiment: data2.loggingDirectives.enableDisplayloggerExperiment
      };
    }
  }
};
__name(_ClientSideToggleMenuItem, "ClientSideToggleMenuItem");
__publicField(_ClientSideToggleMenuItem, "type", "ClientSideToggleMenuItem");
var ClientSideToggleMenuItem = _ClientSideToggleMenuItem;

// dist/src/parser/classes/CollaboratorInfoCardContent.js
var _CollaboratorInfoCardContent = class _CollaboratorInfoCardContent extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "channel_avatar");
    __publicField(this, "custom_text");
    __publicField(this, "channel_name");
    __publicField(this, "subscriber_count");
    __publicField(this, "endpoint");
    this.channel_avatar = Thumbnail.fromResponse(data2.channelAvatar);
    this.custom_text = new Text2(data2.customText);
    this.channel_name = new Text2(data2.channelName);
    this.subscriber_count = new Text2(data2.subscriberCountText);
    this.endpoint = new NavigationEndpoint(data2.endpoint);
  }
};
__name(_CollaboratorInfoCardContent, "CollaboratorInfoCardContent");
__publicField(_CollaboratorInfoCardContent, "type", "CollaboratorInfoCardContent");
var CollaboratorInfoCardContent = _CollaboratorInfoCardContent;

// dist/src/parser/classes/CollageHeroImage.js
var _CollageHeroImage = class _CollageHeroImage extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "left");
    __publicField(this, "top_right");
    __publicField(this, "bottom_right");
    __publicField(this, "endpoint");
    this.left = Thumbnail.fromResponse(data2.leftThumbnail);
    this.top_right = Thumbnail.fromResponse(data2.topRightThumbnail);
    this.bottom_right = Thumbnail.fromResponse(data2.bottomRightThumbnail);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
  }
};
__name(_CollageHeroImage, "CollageHeroImage");
__publicField(_CollageHeroImage, "type", "CollageHeroImage");
var CollageHeroImage = _CollageHeroImage;

// dist/src/parser/classes/ThumbnailHoverOverlayView.js
var _ThumbnailHoverOverlayView = class _ThumbnailHoverOverlayView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "icon_name");
    __publicField(this, "text");
    __publicField(this, "style");
    this.icon_name = data2.icon.sources[0].clientResource.imageName;
    this.text = Text2.fromAttributed(data2.text);
    this.style = data2.style;
  }
};
__name(_ThumbnailHoverOverlayView, "ThumbnailHoverOverlayView");
__publicField(_ThumbnailHoverOverlayView, "type", "ThumbnailHoverOverlayView");
var ThumbnailHoverOverlayView = _ThumbnailHoverOverlayView;

// dist/src/parser/classes/ThumbnailBadgeView.js
var _ThumbnailBadgeView = class _ThumbnailBadgeView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "icon_name");
    __publicField(this, "text");
    __publicField(this, "badge_style");
    __publicField(this, "background_color");
    this.text = data2.text;
    this.badge_style = data2.badgeStyle;
    if (data2.backgroundColor) {
      this.background_color = {
        light_theme: data2.backgroundColor.lightTheme,
        dark_theme: data2.backgroundColor.darkTheme
      };
    }
    if (data2.iconName) {
      this.icon_name = data2.icon.sources[0].clientResource.imageName;
    }
  }
};
__name(_ThumbnailBadgeView, "ThumbnailBadgeView");
__publicField(_ThumbnailBadgeView, "type", "ThumbnailBadgeView");
var ThumbnailBadgeView = _ThumbnailBadgeView;

// dist/src/parser/classes/ThumbnailOverlayBadgeView.js
var _ThumbnailOverlayBadgeView = class _ThumbnailOverlayBadgeView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "badges");
    __publicField(this, "position");
    this.badges = parser_exports.parseArray(data2.thumbnailBadges, ThumbnailBadgeView);
    this.position = data2.position;
  }
};
__name(_ThumbnailOverlayBadgeView, "ThumbnailOverlayBadgeView");
__publicField(_ThumbnailOverlayBadgeView, "type", "ThumbnailOverlayBadgeView");
var ThumbnailOverlayBadgeView = _ThumbnailOverlayBadgeView;

// dist/src/parser/classes/ThumbnailHoverOverlayToggleActionsView.js
var _ThumbnailHoverOverlayToggleActionsView = class _ThumbnailHoverOverlayToggleActionsView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "buttons");
    this.buttons = parser_exports.parseArray(data2.buttons, ToggleButtonView);
  }
};
__name(_ThumbnailHoverOverlayToggleActionsView, "ThumbnailHoverOverlayToggleActionsView");
__publicField(_ThumbnailHoverOverlayToggleActionsView, "type", "ThumbnailHoverOverlayToggleActionsView");
var ThumbnailHoverOverlayToggleActionsView = _ThumbnailHoverOverlayToggleActionsView;

// dist/src/parser/classes/ThumbnailOverlayProgressBarView.js
var _ThumbnailOverlayProgressBarView = class _ThumbnailOverlayProgressBarView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "start_percent");
    this.start_percent = data2.startPercent;
  }
};
__name(_ThumbnailOverlayProgressBarView, "ThumbnailOverlayProgressBarView");
__publicField(_ThumbnailOverlayProgressBarView, "type", "ThumbnailOverlayProgressBarView");
var ThumbnailOverlayProgressBarView = _ThumbnailOverlayProgressBarView;

// dist/src/parser/classes/ThumbnailBottomOverlayView.js
var _ThumbnailBottomOverlayView = class _ThumbnailBottomOverlayView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "progress_bar");
    __publicField(this, "badges");
    this.progress_bar = parser_exports.parseItem(data2.progressBar, ThumbnailOverlayProgressBarView);
    this.badges = parser_exports.parseArray(data2.badges, ThumbnailBadgeView);
  }
};
__name(_ThumbnailBottomOverlayView, "ThumbnailBottomOverlayView");
__publicField(_ThumbnailBottomOverlayView, "type", "ThumbnailBottomOverlayView");
var ThumbnailBottomOverlayView = _ThumbnailBottomOverlayView;

// dist/src/parser/classes/ThumbnailView.js
var _ThumbnailView = class _ThumbnailView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "image");
    __publicField(this, "overlays");
    __publicField(this, "background_color");
    this.image = Thumbnail.fromResponse(data2.image);
    this.overlays = parser_exports.parseArray(data2.overlays, [
      ThumbnailHoverOverlayToggleActionsView,
      ThumbnailBottomOverlayView,
      ThumbnailOverlayBadgeView,
      ThumbnailHoverOverlayView,
      AnimatedThumbnailOverlayView
    ]);
    if ("backgroundColor" in data2) {
      this.background_color = {
        light_theme: data2.backgroundColor.lightTheme,
        dark_theme: data2.backgroundColor.darkTheme
      };
    }
  }
};
__name(_ThumbnailView, "ThumbnailView");
__publicField(_ThumbnailView, "type", "ThumbnailView");
var ThumbnailView = _ThumbnailView;

// dist/src/parser/classes/CollectionThumbnailView.js
var _CollectionThumbnailView = class _CollectionThumbnailView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "primary_thumbnail");
    __publicField(this, "stack_color");
    this.primary_thumbnail = parser_exports.parseItem(data2.primaryThumbnail, ThumbnailView);
    if (data2.stackColor) {
      this.stack_color = {
        light_theme: data2.stackColor.lightTheme,
        dark_theme: data2.stackColor.darkTheme
      };
    }
  }
};
__name(_CollectionThumbnailView, "CollectionThumbnailView");
__publicField(_CollectionThumbnailView, "type", "CollectionThumbnailView");
var CollectionThumbnailView = _CollectionThumbnailView;

// dist/src/parser/classes/commands/AddToPlaylistCommand.js
var _AddToPlaylistCommand = class _AddToPlaylistCommand extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "open_miniplayer");
    __publicField(this, "video_id");
    __publicField(this, "list_type");
    __publicField(this, "endpoint");
    __publicField(this, "video_ids");
    this.open_miniplayer = data2.openMiniplayer;
    this.video_id = data2.videoId;
    this.list_type = data2.listType;
    this.endpoint = new NavigationEndpoint(data2.onCreateListCommand);
    this.video_ids = data2.videoIds;
  }
};
__name(_AddToPlaylistCommand, "AddToPlaylistCommand");
__publicField(_AddToPlaylistCommand, "type", "AddToPlaylistCommand");
var AddToPlaylistCommand = _AddToPlaylistCommand;

// dist/src/parser/classes/commands/ContinuationCommand.js
var _data;
var _ContinuationCommand = class _ContinuationCommand extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data);
    __privateSet(this, _data, data2);
  }
  getApiPath() {
    switch (__privateGet(this, _data).request) {
      case "CONTINUATION_REQUEST_TYPE_WATCH_NEXT":
        return "next";
      case "CONTINUATION_REQUEST_TYPE_BROWSE":
        return "browse";
      case "CONTINUATION_REQUEST_TYPE_SEARCH":
        return "search";
      case "CONTINUATION_REQUEST_TYPE_ACCOUNTS_LIST":
        return "account/accounts_list";
      case "CONTINUATION_REQUEST_TYPE_COMMENTS_NOTIFICATION_MENU":
        return "notification/get_notification_menu";
      case "CONTINUATION_REQUEST_TYPE_COMMENT_REPLIES":
        return "comment/get_comment_replies";
      case "CONTINUATION_REQUEST_TYPE_REEL_WATCH_SEQUENCE":
        return "reel/reel_watch_sequence";
      case "CONTINUATION_REQUEST_TYPE_GET_PANEL":
        return "get_panel";
      default:
        return "";
    }
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data).formData)
      request.formData = __privateGet(this, _data).formData;
    if (__privateGet(this, _data).token)
      request.continuation = __privateGet(this, _data).token;
    if (__privateGet(this, _data).request === "CONTINUATION_REQUEST_TYPE_COMMENTS_NOTIFICATION_MENU") {
      request.notificationsMenuRequestType = "NOTIFICATIONS_MENU_REQUEST_TYPE_COMMENTS";
      if (__privateGet(this, _data).token) {
        request.fetchCommentsParams = {
          continuation: __privateGet(this, _data).token
        };
        delete request.continuation;
      }
    }
    return request;
  }
};
_data = new WeakMap();
__name(_ContinuationCommand, "ContinuationCommand");
__publicField(_ContinuationCommand, "type", "ContinuationCommand");
var ContinuationCommand = _ContinuationCommand;

// dist/src/parser/classes/commands/GetKidsBlocklistPickerCommand.js
var API_PATH = "kids/get_kids_blocklist_picker";
var _data2;
var _GetKidsBlocklistPickerCommand = class _GetKidsBlocklistPickerCommand extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data2);
    __privateSet(this, _data2, data2);
  }
  getApiPath() {
    return API_PATH;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data2).blockedForKidsContent)
      request.blockedForKidsContent = __privateGet(this, _data2).blockedForKidsContent;
    return request;
  }
};
_data2 = new WeakMap();
__name(_GetKidsBlocklistPickerCommand, "GetKidsBlocklistPickerCommand");
__publicField(_GetKidsBlocklistPickerCommand, "type", "GetKidsBlocklistPickerCommand");
var GetKidsBlocklistPickerCommand = _GetKidsBlocklistPickerCommand;

// dist/src/parser/classes/commands/RunAttestationCommand.js
var _RunAttestationCommand = class _RunAttestationCommand extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "engagement_type");
    __publicField(this, "ids");
    this.engagement_type = data2.engagementType;
    if (Reflect.has(data2, "ids")) {
      this.ids = data2.ids.map((id) => ({
        encrypted_video_id: id.encryptedVideoId,
        external_channel_id: id.externalChannelId,
        comment_id: id.commentId,
        external_owner_id: id.externalOwnerId,
        artist_id: id.artistId,
        playlist_id: id.playlistId,
        external_post_id: id.externalPostId,
        share_id: id.shareId
      }));
    }
  }
};
__name(_RunAttestationCommand, "RunAttestationCommand");
__publicField(_RunAttestationCommand, "type", "RunAttestationCommand");
var RunAttestationCommand = _RunAttestationCommand;

// dist/src/parser/classes/commands/ShowDialogCommand.js
var _ShowDialogCommand = class _ShowDialogCommand extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "inline_content");
    __publicField(this, "remove_default_padding");
    this.inline_content = parser_exports.parseItem(data2.panelLoadingStrategy?.inlineContent);
    this.remove_default_padding = !!data2.removeDefaultPadding;
  }
};
__name(_ShowDialogCommand, "ShowDialogCommand");
__publicField(_ShowDialogCommand, "type", "ShowDialogCommand");
var ShowDialogCommand = _ShowDialogCommand;

// dist/src/parser/classes/commands/UpdateEngagementPanelContentCommand.js
var _UpdateEngagementPanelContentCommand = class _UpdateEngagementPanelContentCommand extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "content_source_panel_identifier");
    __publicField(this, "target_panel_identifier");
    this.content_source_panel_identifier = data2.contentSourcePanelIdentifier;
    this.target_panel_identifier = data2.targetPanelIdentifier;
  }
};
__name(_UpdateEngagementPanelContentCommand, "UpdateEngagementPanelContentCommand");
__publicField(_UpdateEngagementPanelContentCommand, "type", "UpdateEngagementPanelContentCommand");
var UpdateEngagementPanelContentCommand = _UpdateEngagementPanelContentCommand;

// dist/src/parser/classes/comments/AuthorCommentBadge.js
var _data3;
var _AuthorCommentBadge = class _AuthorCommentBadge extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data3);
    __publicField(this, "icon_type");
    __publicField(this, "tooltip");
    __publicField(this, "style");
    if (Reflect.has(data2, "icon") && Reflect.has(data2.icon, "iconType")) {
      this.icon_type = data2.icon.iconType;
    }
    this.tooltip = data2.iconTooltip;
    if (this.tooltip === "Verified") {
      this.style = "BADGE_STYLE_TYPE_VERIFIED";
      data2.style = "BADGE_STYLE_TYPE_VERIFIED";
    }
    __privateSet(this, _data3, data2);
  }
  get orig_badge() {
    return __privateGet(this, _data3);
  }
};
_data3 = new WeakMap();
__name(_AuthorCommentBadge, "AuthorCommentBadge");
__publicField(_AuthorCommentBadge, "type", "AuthorCommentBadge");
var AuthorCommentBadge = _AuthorCommentBadge;

// dist/src/parser/classes/comments/EmojiPicker.js
var _EmojiPicker = class _EmojiPicker extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "categories");
    __publicField(this, "category_buttons");
    __publicField(this, "search_placeholder");
    __publicField(this, "search_no_results");
    __publicField(this, "pick_skin_tone");
    __publicField(this, "clear_search_label");
    __publicField(this, "skin_tone_generic_label");
    __publicField(this, "skin_tone_light_label");
    __publicField(this, "skin_tone_medium_light_label");
    __publicField(this, "skin_tone_medium_label");
    __publicField(this, "skin_tone_medium_dark_label");
    __publicField(this, "skin_tone_dark_label");
    this.id = data2.id;
    this.categories = parser_exports.parseArray(data2.categories);
    this.category_buttons = parser_exports.parseArray(data2.categoryButtons);
    this.search_placeholder = new Text2(data2.searchPlaceholderText);
    this.search_no_results = new Text2(data2.searchNoResultsText);
    this.pick_skin_tone = new Text2(data2.pickSkinToneText);
    this.clear_search_label = data2.clearSearchLabel;
    this.skin_tone_generic_label = data2.skinToneGenericLabel;
    this.skin_tone_light_label = data2.skinToneLightLabel;
    this.skin_tone_medium_light_label = data2.skinToneMediumLightLabel;
    this.skin_tone_medium_label = data2.skinToneMediumLabel;
    this.skin_tone_medium_dark_label = data2.skinToneMediumDarkLabel;
    this.skin_tone_dark_label = data2.skinToneDarkLabel;
  }
};
__name(_EmojiPicker, "EmojiPicker");
__publicField(_EmojiPicker, "type", "EmojiPicker");
var EmojiPicker = _EmojiPicker;

// dist/src/parser/classes/comments/CommentDialog.js
var _CommentDialog = class _CommentDialog extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "editable_text");
    __publicField(this, "author_thumbnail");
    __publicField(this, "submit_button");
    __publicField(this, "cancel_button");
    __publicField(this, "placeholder");
    __publicField(this, "emoji_button");
    __publicField(this, "emoji_picker");
    this.editable_text = new Text2(data2.editableText);
    this.author_thumbnail = Thumbnail.fromResponse(data2.authorThumbnail);
    this.submit_button = parser_exports.parseItem(data2.submitButton, Button);
    this.cancel_button = parser_exports.parseItem(data2.cancelButton, Button);
    this.placeholder = new Text2(data2.placeholderText);
    this.emoji_button = parser_exports.parseItem(data2.emojiButton, Button);
    this.emoji_picker = parser_exports.parseItem(data2.emojiPicker, EmojiPicker);
  }
};
__name(_CommentDialog, "CommentDialog");
__publicField(_CommentDialog, "type", "CommentDialog");
var CommentDialog = _CommentDialog;

// dist/src/parser/classes/comments/CommentReplies.js
var _CommentReplies = class _CommentReplies extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    __publicField(this, "view_replies");
    __publicField(this, "hide_replies");
    __publicField(this, "view_replies_creator_thumbnail");
    __publicField(this, "has_channel_owner_replied");
    this.contents = parser_exports.parseArray(data2.contents);
    this.view_replies = parser_exports.parseItem(data2.viewReplies, Button);
    this.hide_replies = parser_exports.parseItem(data2.hideReplies, Button);
    this.view_replies_creator_thumbnail = Thumbnail.fromResponse(data2.viewRepliesCreatorThumbnail);
    this.has_channel_owner_replied = !!data2.viewRepliesCreatorThumbnail;
  }
};
__name(_CommentReplies, "CommentReplies");
__publicField(_CommentReplies, "type", "CommentReplies");
var CommentReplies = _CommentReplies;

// dist/src/parser/classes/comments/CommentReplyDialog.js
var _CommentReplyDialog = class _CommentReplyDialog extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "reply_button");
    __publicField(this, "cancel_button");
    __publicField(this, "author_thumbnail");
    __publicField(this, "placeholder");
    __publicField(this, "error_message");
    this.reply_button = parser_exports.parseItem(data2.replyButton, Button);
    this.cancel_button = parser_exports.parseItem(data2.cancelButton, Button);
    this.author_thumbnail = Thumbnail.fromResponse(data2.authorThumbnail);
    this.placeholder = new Text2(data2.placeholderText);
    this.error_message = new Text2(data2.errorMessage);
  }
};
__name(_CommentReplyDialog, "CommentReplyDialog");
__publicField(_CommentReplyDialog, "type", "CommentReplyDialog");
var CommentReplyDialog = _CommentReplyDialog;

// dist/src/parser/classes/comments/CommentsSimplebox.js
var _CommentsSimplebox = class _CommentsSimplebox extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "simplebox_avatar");
    __publicField(this, "simplebox_placeholder");
    this.simplebox_avatar = Thumbnail.fromResponse(data2.simpleboxAvatar);
    this.simplebox_placeholder = new Text2(data2.simpleboxPlaceholder);
  }
};
__name(_CommentsSimplebox, "CommentsSimplebox");
__publicField(_CommentsSimplebox, "type", "CommentsSimplebox");
var CommentsSimplebox = _CommentsSimplebox;

// dist/src/parser/classes/comments/CommentsEntryPointTeaser.js
var _CommentsEntryPointTeaser = class _CommentsEntryPointTeaser extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "teaser_avatar");
    __publicField(this, "teaser_content");
    if (Reflect.has(data2, "teaserAvatar")) {
      this.teaser_avatar = Thumbnail.fromResponse(data2.teaserAvatar);
    }
    if (Reflect.has(data2, "teaserContent")) {
      this.teaser_content = new Text2(data2.teaserContent);
    }
  }
};
__name(_CommentsEntryPointTeaser, "CommentsEntryPointTeaser");
__publicField(_CommentsEntryPointTeaser, "type", "CommentsEntryPointTeaser");
var CommentsEntryPointTeaser = _CommentsEntryPointTeaser;

// dist/src/parser/classes/comments/CommentsEntryPointHeader.js
var _CommentsEntryPointHeader = class _CommentsEntryPointHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "comment_count");
    __publicField(this, "teaser_avatar");
    __publicField(this, "teaser_content");
    __publicField(this, "content_renderer");
    __publicField(this, "simplebox_placeholder");
    if (Reflect.has(data2, "headerText")) {
      this.header = new Text2(data2.headerText);
    }
    if (Reflect.has(data2, "commentCount")) {
      this.comment_count = new Text2(data2.commentCount);
    }
    if (Reflect.has(data2, "teaserAvatar") || Reflect.has(data2, "simpleboxAvatar")) {
      this.teaser_avatar = Thumbnail.fromResponse(data2.teaserAvatar || data2.simpleboxAvatar);
    }
    if (Reflect.has(data2, "teaserContent")) {
      this.teaser_content = new Text2(data2.teaserContent);
    }
    if (Reflect.has(data2, "contentRenderer")) {
      this.content_renderer = parser_exports.parseItem(data2.contentRenderer, [CommentsEntryPointTeaser, CommentsSimplebox]);
    }
    if (Reflect.has(data2, "simpleboxPlaceholder")) {
      this.simplebox_placeholder = new Text2(data2.simpleboxPlaceholder);
    }
  }
};
__name(_CommentsEntryPointHeader, "CommentsEntryPointHeader");
__publicField(_CommentsEntryPointHeader, "type", "CommentsEntryPointHeader");
var CommentsEntryPointHeader = _CommentsEntryPointHeader;

// dist/src/parser/classes/comments/CommentsHeader.js
var _CommentsHeader = class _CommentsHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "count");
    __publicField(this, "comments_count");
    __publicField(this, "create_renderer");
    __publicField(this, "sort_menu");
    __publicField(this, "custom_emojis");
    this.title = new Text2(data2.titleText);
    this.count = new Text2(data2.countText);
    this.comments_count = new Text2(data2.commentsCount);
    this.create_renderer = parser_exports.parseItem(data2.createRenderer);
    this.sort_menu = parser_exports.parseItem(data2.sortMenu, SortFilterSubMenu);
    if (Reflect.has(data2, "customEmojis")) {
      this.custom_emojis = data2.customEmojis.map((emoji) => ({
        emoji_id: emoji.emojiId,
        shortcuts: emoji.shortcuts,
        search_terms: emoji.searchTerms,
        image: Thumbnail.fromResponse(emoji.image),
        is_custom_emoji: emoji.isCustomEmoji
      }));
    }
  }
};
__name(_CommentsHeader, "CommentsHeader");
__publicField(_CommentsHeader, "type", "CommentsHeader");
var CommentsHeader = _CommentsHeader;

// dist/src/parser/classes/comments/CommentSimplebox.js
var _CommentSimplebox = class _CommentSimplebox extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "submit_button");
    __publicField(this, "cancel_button");
    __publicField(this, "author_thumbnail");
    __publicField(this, "placeholder");
    __publicField(this, "avatar_size");
    this.submit_button = parser_exports.parseItem(data2.submitButton, Button);
    this.cancel_button = parser_exports.parseItem(data2.cancelButton, Button);
    this.author_thumbnail = Thumbnail.fromResponse(data2.authorThumbnail);
    this.placeholder = new Text2(data2.placeholderText);
    this.avatar_size = data2.avatarSize;
  }
};
__name(_CommentSimplebox, "CommentSimplebox");
__publicField(_CommentSimplebox, "type", "CommentSimplebox");
var CommentSimplebox = _CommentSimplebox;

// dist/src/parser/classes/comments/VoiceReplyContainerView.js
var _VoiceReplyContainerView = class _VoiceReplyContainerView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "voice_reply_unavailable_text");
    __publicField(this, "transcript_text");
    this.voice_reply_unavailable_text = Text2.fromAttributed(data2.voiceReplyUnavailableText);
    this.transcript_text = Text2.fromAttributed(data2.transcriptText);
  }
};
__name(_VoiceReplyContainerView, "VoiceReplyContainerView");
__publicField(_VoiceReplyContainerView, "type", "VoiceReplyContainerView");
var VoiceReplyContainerView = _VoiceReplyContainerView;

// dist/src/parser/classes/comments/CommentView.js
var _actions;
var _CommentView = class _CommentView extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _actions);
    __publicField(this, "like_command");
    __publicField(this, "dislike_command");
    __publicField(this, "unlike_command");
    __publicField(this, "undislike_command");
    __publicField(this, "reply_command");
    __publicField(this, "prepare_account_command");
    __publicField(this, "comment_id");
    __publicField(this, "is_pinned");
    __publicField(this, "keys");
    __publicField(this, "content");
    __publicField(this, "published_time");
    __publicField(this, "author_is_channel_owner");
    __publicField(this, "creator_thumbnail_url");
    __publicField(this, "like_button_a11y");
    __publicField(this, "like_count");
    __publicField(this, "like_count_liked");
    __publicField(this, "like_count_a11y");
    __publicField(this, "like_active_tooltip");
    __publicField(this, "like_inactive_tooltip");
    __publicField(this, "dislike_active_tooltip");
    __publicField(this, "dislike_inactive_tooltip");
    __publicField(this, "heart_active_tooltip");
    __publicField(this, "reply_count");
    __publicField(this, "reply_count_a11y");
    __publicField(this, "is_member");
    __publicField(this, "member_badge");
    __publicField(this, "author");
    __publicField(this, "is_liked");
    __publicField(this, "is_disliked");
    __publicField(this, "is_hearted");
    __publicField(this, "voice_reply_container");
    this.comment_id = data2.commentId;
    this.is_pinned = !!data2.pinnedText;
    this.keys = {
      comment: data2.commentKey,
      comment_surface: data2.commentSurfaceKey,
      toolbar_state: data2.toolbarStateKey,
      toolbar_surface: data2.toolbarSurfaceKey,
      shared: data2.sharedKey
    };
  }
  applyMutations(comment, toolbar_state, toolbar_surface, comment_surface) {
    if (comment) {
      this.content = Text2.fromAttributed(comment.properties.content);
      this.published_time = comment.properties.publishedTime;
      this.author_is_channel_owner = !!comment.author.isCreator;
      this.creator_thumbnail_url = comment.toolbar.creatorThumbnailUrl;
      this.like_count = comment.toolbar.likeCountNotliked ? comment.toolbar.likeCountNotliked : "0";
      this.like_count_liked = comment.toolbar.likeCountLiked ? comment.toolbar.likeCountLiked : "0";
      this.like_count_a11y = comment.toolbar.likeCountA11y;
      this.like_active_tooltip = comment.toolbar.likeActiveTooltip;
      this.like_inactive_tooltip = comment.toolbar.likeInactiveTooltip;
      this.dislike_active_tooltip = comment.toolbar.dislikeActiveTooltip;
      this.dislike_inactive_tooltip = comment.toolbar.dislikeInactiveTooltip;
      this.like_button_a11y = comment.toolbar.likeButtonA11y;
      this.heart_active_tooltip = comment.toolbar.heartActiveTooltip;
      this.reply_count_a11y = comment.toolbar.replyCountA11y;
      this.reply_count = comment.toolbar.replyCount ? comment.toolbar.replyCount : "0";
      this.is_member = !!comment.author.sponsorBadgeUrl;
      if (Reflect.has(comment.author, "sponsorBadgeUrl")) {
        this.member_badge = {
          url: comment.author.sponsorBadgeUrl,
          a11y: comment.author.A11y
        };
      }
      this.author = new Author({
        simpleText: comment.author.displayName,
        navigationEndpoint: comment.avatar.endpoint
      }, comment.author, comment.avatar.image, comment.author.channelId);
    }
    if (toolbar_state) {
      this.is_hearted = toolbar_state.heartState === "TOOLBAR_HEART_STATE_HEARTED";
      this.is_liked = toolbar_state.likeState === "TOOLBAR_LIKE_STATE_LIKED";
      this.is_disliked = toolbar_state.likeState === "TOOLBAR_LIKE_STATE_DISLIKED";
    }
    if (toolbar_surface) {
      if ("prepareAccountCommand" in toolbar_surface) {
        this.prepare_account_command = new NavigationEndpoint(toolbar_surface.prepareAccountCommand);
      } else {
        this.like_command = new NavigationEndpoint(toolbar_surface.likeCommand);
        this.dislike_command = new NavigationEndpoint(toolbar_surface.dislikeCommand);
        this.unlike_command = new NavigationEndpoint(toolbar_surface.unlikeCommand);
        this.undislike_command = new NavigationEndpoint(toolbar_surface.undislikeCommand);
        this.reply_command = new NavigationEndpoint(toolbar_surface.replyCommand);
      }
    }
    if (comment_surface) {
      if ("voiceReplyContainerViewModel" in comment_surface) {
        this.voice_reply_container = parser_exports.parseItem(comment_surface.voiceReplyContainerViewModel, VoiceReplyContainerView);
      }
    }
  }
  /**
   * Likes the comment.
   * @returns A promise that resolves to the API response.
   * @throws If the Actions instance is not set for this comment or if the like command is not found.
   */
  async like() {
    if (!__privateGet(this, _actions))
      throw new InnertubeError("Actions instance not set for this comment.");
    if (!this.like_command)
      throw new InnertubeError("Like command not found.");
    if (this.is_liked)
      throw new InnertubeError("This comment is already liked.", { comment_id: this.comment_id });
    return this.like_command.call(__privateGet(this, _actions));
  }
  /**
   * Dislikes the comment.
   * @returns A promise that resolves to the API response.
   * @throws If the Actions instance is not set for this comment or if the dislike command is not found.
   */
  async dislike() {
    if (!__privateGet(this, _actions))
      throw new InnertubeError("Actions instance not set for this comment.");
    if (!this.dislike_command)
      throw new InnertubeError("Dislike command not found.");
    if (this.is_disliked)
      throw new InnertubeError("This comment is already disliked.", { comment_id: this.comment_id });
    return this.dislike_command.call(__privateGet(this, _actions));
  }
  /**
   * Unlikes the comment.
   * @returns A promise that resolves to the API response.
   * @throws If the Actions instance is not set for this comment or if the unlike command is not found.
   */
  async unlike() {
    if (!__privateGet(this, _actions))
      throw new InnertubeError("Actions instance not set for this comment.");
    if (!this.unlike_command)
      throw new InnertubeError("Unlike command not found.");
    if (!this.is_liked)
      throw new InnertubeError("This comment is not liked.", { comment_id: this.comment_id });
    return this.unlike_command.call(__privateGet(this, _actions));
  }
  /**
   * Undislikes the comment.
   * @returns A promise that resolves to the API response.
   * @throws If the Actions instance is not set for this comment or if the undislike command is not found.
   */
  async undislike() {
    if (!__privateGet(this, _actions))
      throw new InnertubeError("Actions instance not set for this comment.");
    if (!this.undislike_command)
      throw new InnertubeError("Undislike command not found.");
    if (!this.is_disliked)
      throw new InnertubeError("This comment is not disliked.", { comment_id: this.comment_id });
    return this.undislike_command.call(__privateGet(this, _actions));
  }
  /**
   * Replies to the comment.
   * @param comment_text - The text of the reply.
   * @returns A promise that resolves to the API response.
   * @throws If the Actions instance is not set for this comment or if the reply command is not found.
   */
  async reply(comment_text) {
    if (!__privateGet(this, _actions))
      throw new InnertubeError("Actions instance not set for this comment.");
    if (!this.reply_command)
      throw new InnertubeError("Reply command not found.");
    const dialog = this.reply_command.dialog?.as(CommentReplyDialog);
    if (!dialog)
      throw new InnertubeError("Reply dialog not found.");
    const reply_button = dialog.reply_button;
    if (!reply_button)
      throw new InnertubeError("Reply button not found in the dialog.");
    if (!reply_button.endpoint)
      throw new InnertubeError("Reply button endpoint not found.");
    return reply_button.endpoint.call(__privateGet(this, _actions), { commentText: comment_text });
  }
  /**
   * Translates the comment to the specified target language.
   * @param target_language - The target language to translate the comment to, e.g. 'en', 'ja'.
   * @returns Resolves to an ApiResponse object with the translated content, if available.
   * @throws if the Actions instance is not set for this comment or if the comment content is not found.
   */
  async translate(target_language) {
    if (!__privateGet(this, _actions))
      throw new InnertubeError("Actions instance not set for this comment.");
    if (!this.content)
      throw new InnertubeError("Comment content not found.", { comment_id: this.comment_id });
    const text = this.content.toString().replace(/[^\p{L}\p{N}\p{P}\p{Z}]/gu, "");
    const payload = { text, target_language };
    const action = encodeCommentActionParams(22, payload);
    const response = await __privateGet(this, _actions).execute("comment/perform_comment_action", { action });
    const mutations = response.data.frameworkUpdates?.entityBatchUpdate?.mutations;
    const content = mutations?.[0]?.payload?.commentEntityPayload?.translatedContent?.content;
    return { ...response, content };
  }
  setActions(actions) {
    __privateSet(this, _actions, actions);
  }
};
_actions = new WeakMap();
__name(_CommentView, "CommentView");
__publicField(_CommentView, "type", "CommentView");
var CommentView = _CommentView;

// dist/src/parser/classes/comments/CommentThread.js
var _actions2, _continuation, _CommentThread_instances, getPatchedReplies_fn;
var _CommentThread = class _CommentThread extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _CommentThread_instances);
    __publicField(this, "comment");
    __publicField(this, "replies");
    __publicField(this, "comment_replies_data");
    __publicField(this, "is_moderated_elq_comment");
    __publicField(this, "has_replies");
    __privateAdd(this, _actions2);
    __privateAdd(this, _continuation);
    this.comment = parser_exports.parseItem(data2.commentViewModel, CommentView);
    this.comment_replies_data = parser_exports.parseItem(data2.replies, CommentReplies);
    this.is_moderated_elq_comment = data2.isModeratedElqComment;
    this.has_replies = !!this.comment_replies_data;
  }
  get has_continuation() {
    if (!this.replies)
      throw new InnertubeError("Cannot determine if there is a continuation because this thread's replies have not been loaded.");
    return !!__privateGet(this, _continuation);
  }
  /**
   * Retrieves replies to this comment thread.
   */
  async getReplies() {
    if (!__privateGet(this, _actions2))
      throw new InnertubeError("Actions instance not set for this thread.");
    if (!this.comment_replies_data)
      throw new InnertubeError("This comment has no replies.", this);
    const continuation = this.comment_replies_data.contents?.firstOfType(ContinuationItem);
    if (!continuation)
      throw new InnertubeError("Replies continuation not found.");
    const response = await continuation.endpoint.call(__privateGet(this, _actions2), { parse: true });
    if (!response.on_response_received_endpoints_memo)
      throw new InnertubeError("Unexpected response.", response);
    this.replies = __privateMethod(this, _CommentThread_instances, getPatchedReplies_fn).call(this, response.on_response_received_endpoints_memo);
    __privateSet(this, _continuation, response.on_response_received_endpoints_memo.getType(ContinuationItem)[0]);
    return this;
  }
  /**
   * Retrieves next batch of replies.
   */
  async getContinuation() {
    if (!this.replies)
      throw new InnertubeError("Cannot retrieve continuation because this thread's replies have not been loaded.");
    if (!__privateGet(this, _continuation))
      throw new InnertubeError("Continuation not found.");
    if (!__privateGet(this, _actions2))
      throw new InnertubeError("Actions instance not set for this thread.");
    const load_more_button = __privateGet(this, _continuation).button?.as(Button);
    if (!load_more_button)
      throw new InnertubeError('"Load more" button not found.');
    const response = await load_more_button.endpoint.call(__privateGet(this, _actions2), { parse: true });
    if (!response.on_response_received_endpoints_memo)
      throw new InnertubeError("Unexpected response.", response);
    this.replies = __privateMethod(this, _CommentThread_instances, getPatchedReplies_fn).call(this, response.on_response_received_endpoints_memo);
    __privateSet(this, _continuation, response.on_response_received_endpoints_memo.getType(ContinuationItem)[0]);
    return this;
  }
  setActions(actions) {
    __privateSet(this, _actions2, actions);
  }
};
_actions2 = new WeakMap();
_continuation = new WeakMap();
_CommentThread_instances = new WeakSet();
getPatchedReplies_fn = /* @__PURE__ */ __name(function(data2) {
  return observe(data2.getType(CommentView).map((comment) => {
    comment.setActions(__privateGet(this, _actions2));
    return comment;
  }));
}, "#getPatchedReplies");
__name(_CommentThread, "CommentThread");
__publicField(_CommentThread, "type", "CommentThread");
var CommentThread = _CommentThread;

// dist/src/parser/classes/comments/PdgCommentChip.js
var _PdgCommentChip = class _PdgCommentChip extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "color_pallette");
    __publicField(this, "icon_type");
    this.text = new Text2(data2.chipText);
    this.color_pallette = {
      background_color: data2.chipColorPalette?.backgroundColor,
      foreground_title_color: data2.chipColorPalette?.foregroundTitleColor
    };
    if (Reflect.has(data2, "chipIcon") && Reflect.has(data2.chipIcon, "iconType")) {
      this.icon_type = data2.chipIcon.iconType;
    }
  }
};
__name(_PdgCommentChip, "PdgCommentChip");
__publicField(_PdgCommentChip, "type", "PdgCommentChip");
var PdgCommentChip = _PdgCommentChip;

// dist/src/parser/classes/comments/SponsorCommentBadge.js
var _SponsorCommentBadge = class _SponsorCommentBadge extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "custom_badge");
    __publicField(this, "tooltip");
    this.custom_badge = Thumbnail.fromResponse(data2.customBadge);
    this.tooltip = data2.tooltip;
  }
};
__name(_SponsorCommentBadge, "SponsorCommentBadge");
__publicField(_SponsorCommentBadge, "type", "SponsorCommentBadge");
var SponsorCommentBadge = _SponsorCommentBadge;

// dist/src/parser/classes/CompactChannel.js
var _CompactChannel = class _CompactChannel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "channel_id");
    __publicField(this, "thumbnail");
    __publicField(this, "display_name");
    __publicField(this, "video_count");
    __publicField(this, "subscriber_count");
    __publicField(this, "endpoint");
    __publicField(this, "tv_banner");
    __publicField(this, "menu");
    this.title = new Text2(data2.title);
    this.channel_id = data2.channelId;
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.display_name = new Text2(data2.displayName);
    this.video_count = new Text2(data2.videoCountText);
    this.subscriber_count = new Text2(data2.subscriberCountText);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.tv_banner = Thumbnail.fromResponse(data2.tvBanner);
    this.menu = parser_exports.parseItem(data2.menu, Menu);
  }
};
__name(_CompactChannel, "CompactChannel");
__publicField(_CompactChannel, "type", "CompactChannel");
var CompactChannel = _CompactChannel;

// dist/src/parser/classes/PlaylistCustomThumbnail.js
var _PlaylistCustomThumbnail = class _PlaylistCustomThumbnail extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
  }
};
__name(_PlaylistCustomThumbnail, "PlaylistCustomThumbnail");
__publicField(_PlaylistCustomThumbnail, "type", "PlaylistCustomThumbnail");
var PlaylistCustomThumbnail = _PlaylistCustomThumbnail;

// dist/src/parser/classes/PlaylistVideoThumbnail.js
var _PlaylistVideoThumbnail = class _PlaylistVideoThumbnail extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
  }
};
__name(_PlaylistVideoThumbnail, "PlaylistVideoThumbnail");
__publicField(_PlaylistVideoThumbnail, "type", "PlaylistVideoThumbnail");
var PlaylistVideoThumbnail = _PlaylistVideoThumbnail;

// dist/src/parser/classes/Playlist.js
var _Playlist = class _Playlist extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "author");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_renderer");
    __publicField(this, "video_count");
    __publicField(this, "video_count_short");
    __publicField(this, "first_videos");
    __publicField(this, "share_url");
    __publicField(this, "menu");
    __publicField(this, "badges");
    __publicField(this, "endpoint");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "view_playlist");
    this.id = data2.playlistId;
    this.title = new Text2(data2.title);
    this.author = data2.shortBylineText?.simpleText ? new Text2(data2.shortBylineText) : new Author(data2.longBylineText, data2.ownerBadges, null);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail || { thumbnails: data2.thumbnails.map((th) => th.thumbnails).flat(1) });
    this.video_count = new Text2(data2.thumbnailText);
    this.video_count_short = new Text2(data2.videoCountShortText);
    this.first_videos = parser_exports.parseArray(data2.videos);
    this.share_url = data2.shareUrl || null;
    this.menu = parser_exports.parseItem(data2.menu);
    this.badges = parser_exports.parseArray(data2.ownerBadges);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.thumbnail_overlays = parser_exports.parseArray(data2.thumbnailOverlays);
    if (Reflect.has(data2, "thumbnailRenderer")) {
      this.thumbnail_renderer = parser_exports.parseItem(data2.thumbnailRenderer, [PlaylistVideoThumbnail, PlaylistCustomThumbnail]) || void 0;
    }
    if (Reflect.has(data2, "viewPlaylistText")) {
      this.view_playlist = new Text2(data2.viewPlaylistText);
    }
  }
};
__name(_Playlist, "Playlist");
__publicField(_Playlist, "type", "Playlist");
var Playlist = _Playlist;

// dist/src/parser/classes/CompactMix.js
var _CompactMix = class _CompactMix extends Playlist {
  constructor(data2) {
    super(data2);
  }
};
__name(_CompactMix, "CompactMix");
__publicField(_CompactMix, "type", "CompactMix");
var CompactMix = _CompactMix;

// dist/src/parser/classes/CompactMovie.js
var _CompactMovie = class _CompactMovie extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "top_metadata_items");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "author");
    __publicField(this, "duration");
    __publicField(this, "endpoint");
    __publicField(this, "badges");
    __publicField(this, "use_vertical_poster");
    __publicField(this, "menu");
    const overlay_time_status = data2.thumbnailOverlays.find((overlay) => overlay.thumbnailOverlayTimeStatusRenderer)?.thumbnailOverlayTimeStatusRenderer.text || "N/A";
    this.id = data2.videoId;
    this.title = new Text2(data2.title);
    this.top_metadata_items = new Text2(data2.topMetadataItems);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.thumbnail_overlays = parser_exports.parseArray(data2.thumbnailOverlays);
    this.author = new Author(data2.shortBylineText);
    const durationText = data2.lengthText ? new Text2(data2.lengthText).toString() : new Text2(overlay_time_status).toString();
    this.duration = {
      text: durationText,
      seconds: timeToSeconds(durationText)
    };
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.badges = parser_exports.parseArray(data2.badges);
    this.use_vertical_poster = data2.useVerticalPoster;
    this.menu = parser_exports.parseItem(data2.menu, Menu);
  }
};
__name(_CompactMovie, "CompactMovie");
__publicField(_CompactMovie, "type", "CompactMovie");
var CompactMovie = _CompactMovie;

// dist/src/parser/classes/CompactPlaylist.js
var _CompactPlaylist = class _CompactPlaylist extends Playlist {
  constructor(data2) {
    super(data2);
  }
};
__name(_CompactPlaylist, "CompactPlaylist");
__publicField(_CompactPlaylist, "type", "CompactPlaylist");
var CompactPlaylist = _CompactPlaylist;
var CompactPlaylist_default = CompactPlaylist;

// dist/src/parser/classes/CompactStation.js
var _CompactStation = class _CompactStation extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "video_count");
    __publicField(this, "endpoint");
    __publicField(this, "thumbnail");
    this.title = new Text2(data2.title);
    this.description = new Text2(data2.description);
    this.video_count = new Text2(data2.videoCountText);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
  }
};
__name(_CompactStation, "CompactStation");
__publicField(_CompactStation, "type", "CompactStation");
var CompactStation = _CompactStation;

// dist/src/parser/classes/CompositeVideoPrimaryInfo.js
var _CompositeVideoPrimaryInfo = class _CompositeVideoPrimaryInfo extends YTNode {
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  constructor(data2) {
    super();
  }
};
__name(_CompositeVideoPrimaryInfo, "CompositeVideoPrimaryInfo");
__publicField(_CompositeVideoPrimaryInfo, "type", "CompositeVideoPrimaryInfo");
var CompositeVideoPrimaryInfo = _CompositeVideoPrimaryInfo;

// dist/src/parser/classes/ConfirmDialog.js
var _ConfirmDialog = class _ConfirmDialog extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "confirm_button");
    __publicField(this, "cancel_button");
    __publicField(this, "dialog_messages");
    this.title = new Text2(data2.title);
    this.confirm_button = parser_exports.parseItem(data2.confirmButton, Button);
    this.cancel_button = parser_exports.parseItem(data2.cancelButton, Button);
    this.dialog_messages = data2.dialogMessages.map((txt) => new Text2(txt));
  }
};
__name(_ConfirmDialog, "ConfirmDialog");
__publicField(_ConfirmDialog, "type", "ConfirmDialog");
var ConfirmDialog = _ConfirmDialog;

// dist/src/parser/classes/ContentMetadataView.js
var _ContentMetadataView = class _ContentMetadataView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "metadata_rows");
    __publicField(this, "delimiter");
    this.metadata_rows = data2.metadataRows.map((row) => ({
      metadata_parts: row.metadataParts?.map((part) => ({
        text: part.text ? Text2.fromAttributed(part.text) : null,
        avatar_stack: parser_exports.parseItem(part.avatarStack, AvatarStackView),
        enable_truncation: data2.enableTruncation
      })),
      badges: parser_exports.parseArray(row.badges, BadgeView)
    }));
    this.delimiter = data2.delimiter;
  }
};
__name(_ContentMetadataView, "ContentMetadataView");
__publicField(_ContentMetadataView, "type", "ContentMetadataView");
var ContentMetadataView = _ContentMetadataView;

// dist/src/parser/classes/Message.js
var _Message = class _Message extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    this.text = new Text2(data2.text);
  }
};
__name(_Message, "Message");
__publicField(_Message, "type", "Message");
var Message = _Message;

// dist/src/parser/classes/ConversationBar.js
var _ConversationBar = class _ConversationBar extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "availability_message");
    this.availability_message = parser_exports.parseItem(data2.availabilityMessage, Message);
  }
};
__name(_ConversationBar, "ConversationBar");
__publicField(_ConversationBar, "type", "ConversationBar");
var ConversationBar = _ConversationBar;

// dist/src/parser/classes/CopyLink.js
var _CopyLink = class _CopyLink extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "copy_button");
    __publicField(this, "short_url");
    __publicField(this, "style");
    this.copy_button = parser_exports.parseItem(data2.copyButton, Button);
    this.short_url = data2.shortUrl;
    this.style = data2.style;
  }
};
__name(_CopyLink, "CopyLink");
__publicField(_CopyLink, "type", "CopyLink");
var CopyLink = _CopyLink;

// dist/src/parser/classes/DropdownView.js
var _DropdownView = class _DropdownView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "label");
    __publicField(this, "placeholder_text");
    __publicField(this, "disabled");
    __publicField(this, "options");
    __publicField(this, "dropdown_type");
    __publicField(this, "id");
    this.label = new Text2(data2.label);
    this.placeholder_text = new Text2(data2.placeholderText);
    this.disabled = !!data2.disabled;
    this.dropdown_type = data2.type;
    this.id = data2.id;
    if (Reflect.has(data2, "options")) {
      this.options = data2.options.map((option) => ({
        title: new Text2(option.title),
        subtitle: new Text2(option.subtitle),
        leading_image: Thumbnail.fromResponse(option.leadingImage),
        value: { privacy_status_value: option.value?.privacyStatusValue },
        on_tap: new NavigationEndpoint(option.onTap),
        is_selected: !!option.isSelected
      }));
    }
  }
};
__name(_DropdownView, "DropdownView");
__publicField(_DropdownView, "type", "DropdownView");
var DropdownView = _DropdownView;

// dist/src/parser/classes/TextFieldView.js
var _TextFieldView = class _TextFieldView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "display_properties");
    __publicField(this, "content_properties");
    __publicField(this, "initial_state");
    __publicField(this, "form_field_metadata");
    if (Reflect.has(data2, "displayProperties")) {
      this.display_properties = {
        isMultiline: !!data2.displayProperties.isMultiline,
        disableNewLines: !!data2.displayProperties.disableNewLines
      };
    }
    if (Reflect.has(data2, "contentProperties")) {
      this.content_properties = {
        labelText: data2.contentProperties.labelText,
        placeholderText: data2.contentProperties.placeholderText,
        maxCharacterCount: data2.contentProperties.maxCharacterCount
      };
    }
    if (Reflect.has(data2, "initialState")) {
      this.initial_state = {
        isFocused: !!data2.initialState.isFocused
      };
    }
    if (Reflect.has(data2, "formFieldMetadata")) {
      this.form_field_metadata = {
        formId: data2.formFieldMetadata.formId,
        fieldId: data2.formFieldMetadata.fieldId
      };
    }
  }
};
__name(_TextFieldView, "TextFieldView");
__publicField(_TextFieldView, "type", "TextFieldView");
var TextFieldView = _TextFieldView;

// dist/src/parser/classes/CreatePlaylistDialogFormView.js
var _CreatePlaylistDialogFormView = class _CreatePlaylistDialogFormView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "playlist_title");
    __publicField(this, "playlist_visibility");
    __publicField(this, "disable_playlist_collaborate");
    __publicField(this, "create_playlist_params_collaboration_enabled");
    __publicField(this, "create_playlist_params_collaboration_disabled");
    __publicField(this, "video_ids");
    this.playlist_title = parser_exports.parseItem(data2.playlistTitle, TextFieldView);
    this.playlist_visibility = parser_exports.parseItem(data2.playlistVisibility, DropdownView);
    this.disable_playlist_collaborate = !!data2.disablePlaylistCollaborate;
    this.create_playlist_params_collaboration_enabled = data2.createPlaylistParamsCollaborationEnabled;
    this.create_playlist_params_collaboration_disabled = data2.createPlaylistParamsCollaborationDisabled;
    this.video_ids = data2.videoIds;
  }
};
__name(_CreatePlaylistDialogFormView, "CreatePlaylistDialogFormView");
__publicField(_CreatePlaylistDialogFormView, "type", "CreatePlaylistDialogFormView");
var CreatePlaylistDialogFormView = _CreatePlaylistDialogFormView;

// dist/src/parser/classes/DecoratedAvatarView.js
var _DecoratedAvatarView = class _DecoratedAvatarView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "avatar");
    __publicField(this, "a11y_label");
    __publicField(this, "renderer_context");
    this.avatar = parser_exports.parseItem(data2.avatar, AvatarView);
    this.a11y_label = data2.a11yLabel;
    this.renderer_context = new RendererContext(data2.rendererContext);
  }
};
__name(_DecoratedAvatarView, "DecoratedAvatarView");
__publicField(_DecoratedAvatarView, "type", "DecoratedAvatarView");
var DecoratedAvatarView = _DecoratedAvatarView;

// dist/src/parser/classes/HeatMarker.js
var _HeatMarker = class _HeatMarker extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "time_range_start_millis");
    __publicField(this, "marker_duration_millis");
    __publicField(this, "heat_marker_intensity_score_normalized");
    this.time_range_start_millis = Number.parseInt(data2.startMillis, 10);
    this.marker_duration_millis = Number.parseInt(data2.durationMillis, 10);
    this.heat_marker_intensity_score_normalized = data2.intensityScoreNormalized;
  }
};
__name(_HeatMarker, "HeatMarker");
__publicField(_HeatMarker, "type", "HeatMarker");
var HeatMarker = _HeatMarker;

// dist/src/parser/classes/TimedMarkerDecoration.js
var _TimedMarkerDecoration = class _TimedMarkerDecoration extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "visible_time_range_start_millis");
    __publicField(this, "visible_time_range_end_millis");
    __publicField(this, "decoration_time_millis");
    __publicField(this, "label");
    __publicField(this, "icon");
    this.visible_time_range_start_millis = data2.visibleTimeRangeStartMillis;
    this.visible_time_range_end_millis = data2.visibleTimeRangeEndMillis;
    this.decoration_time_millis = data2.decorationTimeMillis;
    this.label = new Text2(data2.label);
    this.icon = data2.icon;
  }
};
__name(_TimedMarkerDecoration, "TimedMarkerDecoration");
__publicField(_TimedMarkerDecoration, "type", "TimedMarkerDecoration");
var TimedMarkerDecoration = _TimedMarkerDecoration;

// dist/src/parser/classes/Heatmap.js
var _Heatmap = class _Heatmap extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "max_height_dp");
    __publicField(this, "min_height_dp");
    __publicField(this, "show_hide_animation_duration_millis");
    __publicField(this, "heat_markers");
    __publicField(this, "heat_markers_decorations");
    this.max_height_dp = data2.maxHeightDp;
    this.min_height_dp = data2.minHeightDp;
    this.show_hide_animation_duration_millis = data2.showHideAnimationDurationMillis;
    this.heat_markers = parser_exports.parseArray(data2.heatMarkers, HeatMarker);
    this.heat_markers_decorations = parser_exports.parseArray(data2.heatMarkersDecorations, TimedMarkerDecoration);
  }
};
__name(_Heatmap, "Heatmap");
__publicField(_Heatmap, "type", "Heatmap");
var Heatmap = _Heatmap;

// dist/src/parser/classes/MultiMarkersPlayerBar.js
var _Marker = class _Marker extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "marker_key");
    __publicField(this, "value");
    this.marker_key = data2.key;
    this.value = {};
    if (Reflect.has(data2, "value")) {
      if (Reflect.has(data2.value, "heatmap")) {
        this.value.heatmap = parser_exports.parseItem(data2.value.heatmap, Heatmap);
      }
      if (Reflect.has(data2.value, "chapters")) {
        this.value.chapters = parser_exports.parseArray(data2.value.chapters, Chapter);
      }
    }
  }
};
__name(_Marker, "Marker");
__publicField(_Marker, "type", "Marker");
var Marker = _Marker;
var _MultiMarkersPlayerBar = class _MultiMarkersPlayerBar extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "markers_map");
    this.markers_map = observe(data2.markersMap?.map((marker) => new Marker(marker)) || []);
  }
};
__name(_MultiMarkersPlayerBar, "MultiMarkersPlayerBar");
__publicField(_MultiMarkersPlayerBar, "type", "MultiMarkersPlayerBar");
var MultiMarkersPlayerBar = _MultiMarkersPlayerBar;

// dist/src/parser/classes/DecoratedPlayerBar.js
var _DecoratedPlayerBar = class _DecoratedPlayerBar extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "player_bar");
    __publicField(this, "player_bar_action_button");
    this.player_bar = parser_exports.parseItem(data2.playerBar, MultiMarkersPlayerBar);
    this.player_bar_action_button = parser_exports.parseItem(data2.playerBarActionButton, Button);
  }
};
__name(_DecoratedPlayerBar, "DecoratedPlayerBar");
__publicField(_DecoratedPlayerBar, "type", "DecoratedPlayerBar");
var DecoratedPlayerBar = _DecoratedPlayerBar;

// dist/src/parser/classes/DefaultPromoPanel.js
var _DefaultPromoPanel = class _DefaultPromoPanel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "endpoint");
    __publicField(this, "large_form_factor_background_thumbnail");
    __publicField(this, "small_form_factor_background_thumbnail");
    __publicField(this, "scrim_color_values");
    __publicField(this, "min_panel_display_duration_ms");
    __publicField(this, "min_video_play_duration_ms");
    __publicField(this, "scrim_duration");
    __publicField(this, "metadata_order");
    __publicField(this, "panel_layout");
    this.title = new Text2(data2.title);
    this.description = new Text2(data2.description);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.large_form_factor_background_thumbnail = parser_exports.parseItem(data2.largeFormFactorBackgroundThumbnail);
    this.small_form_factor_background_thumbnail = parser_exports.parseItem(data2.smallFormFactorBackgroundThumbnail);
    this.scrim_color_values = data2.scrimColorValues;
    this.min_panel_display_duration_ms = data2.minPanelDisplayDurationMs;
    this.min_video_play_duration_ms = data2.minVideoPlayDurationMs;
    this.scrim_duration = data2.scrimDuration;
    this.metadata_order = data2.metadataOrder;
    this.panel_layout = data2.panelLayout;
  }
};
__name(_DefaultPromoPanel, "DefaultPromoPanel");
__publicField(_DefaultPromoPanel, "type", "DefaultPromoPanel");
var DefaultPromoPanel = _DefaultPromoPanel;

// dist/src/parser/classes/DescriptionPreviewView.js
var _DescriptionPreviewView = class _DescriptionPreviewView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "description");
    __publicField(this, "max_lines");
    __publicField(this, "truncation_text");
    __publicField(this, "always_show_truncation_text");
    __publicField(this, "more_endpoint");
    __publicField(this, "renderer_context");
    if (Reflect.has(data2, "description"))
      this.description = Text2.fromAttributed(data2.description);
    if (Reflect.has(data2, "maxLines"))
      this.max_lines = parseInt(data2.maxLines);
    if (Reflect.has(data2, "truncationText"))
      this.truncation_text = Text2.fromAttributed(data2.truncationText);
    this.always_show_truncation_text = !!data2.alwaysShowTruncationText;
    if (data2.rendererContext.commandContext?.onTap?.innertubeCommand?.showEngagementPanelEndpoint) {
      const endpoint = data2.rendererContext.commandContext?.onTap?.innertubeCommand?.showEngagementPanelEndpoint;
      this.more_endpoint = {
        show_engagement_panel_endpoint: {
          engagement_panel: parser_exports.parseItem(endpoint.engagementPanel, EngagementPanelSectionList),
          engagement_panel_popup_type: endpoint.engagementPanelPresentationConfigs.engagementPanelPopupPresentationConfig.popupType,
          identifier: {
            surface: endpoint.identifier.surface,
            tag: endpoint.identifier.tag
          }
        }
      };
    }
    this.renderer_context = new RendererContext(data2.rendererContext);
  }
};
__name(_DescriptionPreviewView, "DescriptionPreviewView");
__publicField(_DescriptionPreviewView, "type", "DescriptionPreviewView");
var DescriptionPreviewView = _DescriptionPreviewView;

// dist/src/parser/classes/DialogHeaderView.js
var _DialogHeaderView = class _DialogHeaderView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "headline");
    this.headline = Text2.fromAttributed(data2.headline);
  }
};
__name(_DialogHeaderView, "DialogHeaderView");
__publicField(_DialogHeaderView, "type", "DialogHeaderView");
var DialogHeaderView = _DialogHeaderView;

// dist/src/parser/classes/PanelFooterView.js
var _PanelFooterView = class _PanelFooterView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "primary_button");
    __publicField(this, "secondary_button");
    __publicField(this, "should_hide_divider");
    this.primary_button = parser_exports.parseItem(data2.primaryButton, ButtonView);
    this.secondary_button = parser_exports.parseItem(data2.secondaryButton, ButtonView);
    this.should_hide_divider = !!data2.shouldHideDivider;
  }
};
__name(_PanelFooterView, "PanelFooterView");
__publicField(_PanelFooterView, "type", "PanelFooterView");
var PanelFooterView = _PanelFooterView;

// dist/src/parser/classes/FormFooterView.js
var _FormFooterView = class _FormFooterView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "panel_footer");
    __publicField(this, "form_id");
    __publicField(this, "container_type");
    this.panel_footer = parser_exports.parseItem(data2.panelFooter, PanelFooterView);
    this.form_id = data2.formId;
    this.container_type = data2.containerType;
  }
};
__name(_FormFooterView, "FormFooterView");
__publicField(_FormFooterView, "type", "FormFooterView");
var FormFooterView = _FormFooterView;

// dist/src/parser/classes/SubscribeButtonView.js
var _SubscribeButtonView_instances, parseButtonContent_fn;
var _SubscribeButtonView = class _SubscribeButtonView extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _SubscribeButtonView_instances);
    __publicField(this, "subscribe_button_content");
    __publicField(this, "unsubscribe_button_content");
    __publicField(this, "disable_notification_bell");
    __publicField(this, "button_style");
    __publicField(this, "is_signed_out");
    __publicField(this, "background_style");
    __publicField(this, "disable_subscribe_button");
    __publicField(this, "on_show_subscription_options");
    __publicField(this, "channel_id");
    __publicField(this, "enable_subscribe_button_post_click_animation");
    __publicField(this, "bell_accessiblity_data");
    this.subscribe_button_content = __privateMethod(this, _SubscribeButtonView_instances, parseButtonContent_fn).call(this, data2.subscribeButtonContent);
    this.unsubscribe_button_content = __privateMethod(this, _SubscribeButtonView_instances, parseButtonContent_fn).call(this, data2.unsubscribeButtonContent);
    this.disable_notification_bell = data2.disableNotificationBell;
    this.button_style = {
      unsubscribed_state_style: data2.buttonStyle.unsubscribedStateStyle,
      subscribed_state_style: data2.buttonStyle.subscribedStateStyle
    };
    this.is_signed_out = data2.isSignedOut;
    this.background_style = data2.backgroundStyle;
    this.disable_subscribe_button = data2.disableSubscribeButton;
    this.on_show_subscription_options = new NavigationEndpoint(data2.onShowSubscriptionOptions);
    this.channel_id = data2.channelId;
    this.enable_subscribe_button_post_click_animation = data2.enableSubscribeButtonPostClickAnimation;
    this.bell_accessiblity_data = {
      off_label: data2.bellAccessibilityData.offLabel,
      all_label: data2.bellAccessibilityData.allLabel,
      occasional_label: data2.bellAccessibilityData.occasionalLabel,
      disabled_label: data2.bellAccessibilityData.disabledLabel
    };
  }
};
_SubscribeButtonView_instances = new WeakSet();
parseButtonContent_fn = /* @__PURE__ */ __name(function(data2) {
  return {
    button_text: data2.buttonText,
    accessibility_text: data2.accessibilityText,
    image_name: data2.imageName,
    subscribe_state_subscribed: data2.subscribeState.subscribed,
    endpoint: new NavigationEndpoint(data2.onTapCommand)
  };
}, "#parseButtonContent");
__name(_SubscribeButtonView, "SubscribeButtonView");
__publicField(_SubscribeButtonView, "type", "SubscribeButtonView");
var SubscribeButtonView = _SubscribeButtonView;

// dist/src/parser/classes/ListItemView.js
var _ListItemView = class _ListItemView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "leading_accessory");
    __publicField(this, "renderer_context");
    __publicField(this, "trailing_buttons");
    this.title = Text2.fromAttributed(data2.title);
    this.subtitle = Text2.fromAttributed(data2.subtitle);
    this.leading_accessory = parser_exports.parseItem(data2.leadingAccessory, AvatarView);
    this.renderer_context = new RendererContext(data2.rendererContext);
    if ("trailingButtons" in data2) {
      this.trailing_buttons = parser_exports.parseArray(data2.trailingButtons.buttons, SubscribeButtonView);
    }
  }
};
__name(_ListItemView, "ListItemView");
__publicField(_ListItemView, "type", "ListItemView");
var ListItemView = _ListItemView;

// dist/src/parser/classes/ListView.js
var _ListView = class _ListView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data2.listItems, ListItemView);
  }
};
__name(_ListView, "ListView");
__publicField(_ListView, "type", "ListView");
var ListView = _ListView;

// dist/src/parser/classes/DialogView.js
var _DialogView = class _DialogView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "footer");
    __publicField(this, "custom_content");
    this.header = parser_exports.parseItem(data2.header, DialogHeaderView);
    this.footer = parser_exports.parseItem(data2.footer, [FormFooterView, PanelFooterView]);
    this.custom_content = parser_exports.parseItem(data2.customContent, [CreatePlaylistDialogFormView, ListView]);
  }
};
__name(_DialogView, "DialogView");
__publicField(_DialogView, "type", "DialogView");
var DialogView = _DialogView;

// dist/src/parser/classes/DidYouMean.js
var _DidYouMean = class _DidYouMean extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "corrected_query");
    __publicField(this, "endpoint");
    this.text = new Text2(data2.didYouMean).toString();
    this.corrected_query = new Text2(data2.correctedQuery);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint || data2.correctedQueryEndpoint);
  }
};
__name(_DidYouMean, "DidYouMean");
__publicField(_DidYouMean, "type", "DidYouMean");
var DidYouMean = _DidYouMean;

// dist/src/parser/classes/DismissableDialogContentSection.js
var _DismissableDialogContentSection = class _DismissableDialogContentSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    this.title = new Text2(data2.title);
    this.subtitle = new Text2(data2.subtitle);
  }
};
__name(_DismissableDialogContentSection, "DismissableDialogContentSection");
__publicField(_DismissableDialogContentSection, "type", "DismissableDialogContentSection");
var DismissableDialogContentSection = _DismissableDialogContentSection;

// dist/src/parser/classes/DismissableDialog.js
var _DismissableDialog = class _DismissableDialog extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "sections");
    __publicField(this, "metadata");
    __publicField(this, "display_style");
    this.title = data2.title;
    this.sections = parser_exports.parseArray(data2.sections, DismissableDialogContentSection);
    this.metadata = parser_exports.parseItem(data2.metadata);
    this.display_style = data2.displayStyle;
  }
};
__name(_DismissableDialog, "DismissableDialog");
__publicField(_DismissableDialog, "type", "DismissableDialog");
var DismissableDialog = _DismissableDialog;

// dist/src/parser/classes/DynamicTextView.js
var _DynamicTextView = class _DynamicTextView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "max_lines");
    this.text = Text2.fromAttributed(data2.text);
    this.max_lines = parseInt(data2.maxLines);
  }
};
__name(_DynamicTextView, "DynamicTextView");
__publicField(_DynamicTextView, "type", "DynamicTextView");
var DynamicTextView = _DynamicTextView;

// dist/src/parser/classes/misc/ChildElement.js
var _ChildElement = class _ChildElement extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "properties");
    __publicField(this, "child_elements");
    if (Reflect.has(data2, "type") && Reflect.has(data2.type, "textType")) {
      this.text = data2.type.textType.text?.content;
    }
    this.properties = data2.properties;
    if (Reflect.has(data2, "childElements")) {
      this.child_elements = data2.childElements.map((el) => new _ChildElement(el));
    }
  }
};
__name(_ChildElement, "ChildElement");
__publicField(_ChildElement, "type", "ChildElement");
var ChildElement = _ChildElement;

// dist/src/parser/classes/Element.js
var _Element = class _Element extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "model");
    __publicField(this, "child_elements");
    if (Reflect.has(data2, "elementRenderer")) {
      return parser_exports.parseItem(data2, _Element);
    }
    const type = data2.newElement.type.componentType;
    this.model = parser_exports.parseItem(type?.model);
    if (Reflect.has(data2, "newElement") && Reflect.has(data2.newElement, "childElements")) {
      this.child_elements = observe(data2.newElement.childElements?.map((el) => new ChildElement(el)) || []);
    }
  }
};
__name(_Element, "Element");
__publicField(_Element, "type", "Element");
var Element = _Element;

// dist/src/parser/classes/EmergencyOnebox.js
var _EmergencyOnebox = class _EmergencyOnebox extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "first_option");
    __publicField(this, "menu");
    this.title = new Text2(data2.title);
    this.first_option = parser_exports.parseItem(data2.firstOption);
    this.menu = parser_exports.parseItem(data2.menu, Menu);
  }
};
__name(_EmergencyOnebox, "EmergencyOnebox");
__publicField(_EmergencyOnebox, "type", "EmergencyOnebox");
var EmergencyOnebox = _EmergencyOnebox;

// dist/src/parser/classes/EmojiPickerCategory.js
var _EmojiPickerCategory = class _EmojiPickerCategory extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "category_id");
    __publicField(this, "title");
    __publicField(this, "emoji_ids");
    __publicField(this, "image_loading_lazy");
    __publicField(this, "category_type");
    this.category_id = data2.categoryId;
    this.title = new Text2(data2.title);
    this.emoji_ids = data2.emojiIds;
    this.image_loading_lazy = !!data2.imageLoadingLazy;
    this.category_type = data2.categoryType;
  }
};
__name(_EmojiPickerCategory, "EmojiPickerCategory");
__publicField(_EmojiPickerCategory, "type", "EmojiPickerCategory");
var EmojiPickerCategory = _EmojiPickerCategory;

// dist/src/parser/classes/EmojiPickerCategoryButton.js
var _EmojiPickerCategoryButton = class _EmojiPickerCategoryButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "category_id");
    __publicField(this, "icon_type");
    __publicField(this, "tooltip");
    this.category_id = data2.categoryId;
    if (Reflect.has(data2, "icon")) {
      this.icon_type = data2.icon?.iconType;
    }
    this.tooltip = data2.tooltip;
  }
};
__name(_EmojiPickerCategoryButton, "EmojiPickerCategoryButton");
__publicField(_EmojiPickerCategoryButton, "type", "EmojiPickerCategoryButton");
var EmojiPickerCategoryButton = _EmojiPickerCategoryButton;

// dist/src/parser/classes/EmojiPickerUpsellCategory.js
var _EmojiPickerUpsellCategory = class _EmojiPickerUpsellCategory extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "category_id");
    __publicField(this, "title");
    __publicField(this, "upsell");
    __publicField(this, "emoji_tooltip");
    __publicField(this, "endpoint");
    __publicField(this, "emoji_ids");
    this.category_id = data2.categoryId;
    this.title = new Text2(data2.title);
    this.upsell = new Text2(data2.upsell);
    this.emoji_tooltip = data2.emojiTooltip;
    this.endpoint = new NavigationEndpoint(data2.command);
    this.emoji_ids = data2.emojiIds;
  }
};
__name(_EmojiPickerUpsellCategory, "EmojiPickerUpsellCategory");
__publicField(_EmojiPickerUpsellCategory, "type", "EmojiPickerUpsellCategory");
var EmojiPickerUpsellCategory = _EmojiPickerUpsellCategory;

// dist/src/parser/classes/endpoints/AddToPlaylistServiceEndpoint.js
var API_PATH2 = "playlist/get_add_to_playlist";
var _data4;
var _AddToPlaylistServiceEndpoint = class _AddToPlaylistServiceEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data4);
    __privateSet(this, _data4, data2);
  }
  getApiPath() {
    return API_PATH2;
  }
  buildRequest() {
    const request = {};
    request.videoIds = __privateGet(this, _data4).videoIds ? __privateGet(this, _data4).videoIds : [__privateGet(this, _data4).videoId];
    if (__privateGet(this, _data4).playlistId)
      request.playlistId = __privateGet(this, _data4).playlistId;
    if (__privateGet(this, _data4).params)
      request.params = __privateGet(this, _data4).params;
    request.excludeWatchLater = !!__privateGet(this, _data4).excludeWatchLater;
    return request;
  }
};
_data4 = new WeakMap();
__name(_AddToPlaylistServiceEndpoint, "AddToPlaylistServiceEndpoint");
__publicField(_AddToPlaylistServiceEndpoint, "type", "AddToPlaylistServiceEndpoint");
var AddToPlaylistServiceEndpoint = _AddToPlaylistServiceEndpoint;

// dist/src/parser/classes/endpoints/AddToPlaylistEndpoint.js
var _AddToPlaylistEndpoint = class _AddToPlaylistEndpoint extends AddToPlaylistServiceEndpoint {
  constructor(data2) {
    super(data2);
  }
};
__name(_AddToPlaylistEndpoint, "AddToPlaylistEndpoint");
__publicField(_AddToPlaylistEndpoint, "type", "AddToPlaylistEndpoint");
var AddToPlaylistEndpoint = _AddToPlaylistEndpoint;

// dist/src/parser/classes/endpoints/BrowseEndpoint.js
var API_PATH3 = "browse";
var _data5;
var _BrowseEndpoint = class _BrowseEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data5);
    __privateSet(this, _data5, data2);
  }
  getApiPath() {
    return API_PATH3;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data5).browseId)
      request.browseId = __privateGet(this, _data5).browseId;
    if (__privateGet(this, _data5).params)
      request.params = __privateGet(this, _data5).params;
    if (__privateGet(this, _data5).query)
      request.query = __privateGet(this, _data5).query;
    if (__privateGet(this, _data5).browseId === "FEsubscriptions") {
      request.subscriptionSettingsState = __privateGet(this, _data5).subscriptionSettingsState || "MY_SUBS_SETTINGS_STATE_LAYOUT_FORMAT_LIST";
    }
    if (__privateGet(this, _data5).browseId === "SPaccount_playback") {
      request.formData = __privateGet(this, _data5).formData || {
        accountSettingsFormData: {
          flagCaptionsDefaultOff: false,
          flagAutoCaptionsDefaultOn: false,
          flagDisableInlinePreview: false,
          flagAudioDescriptionDefaultOn: false
        }
      };
    }
    if (__privateGet(this, _data5).browseId === "FEwhat_to_watch") {
      if (__privateGet(this, _data5).browseRequestSupportedMetadata)
        request.browseRequestSupportedMetadata = __privateGet(this, _data5).browseRequestSupportedMetadata;
      if (__privateGet(this, _data5).inlineSettingStatus)
        request.inlineSettingStatus = __privateGet(this, _data5).inlineSettingStatus;
    }
    return request;
  }
};
_data5 = new WeakMap();
__name(_BrowseEndpoint, "BrowseEndpoint");
__publicField(_BrowseEndpoint, "type", "BrowseEndpoint");
var BrowseEndpoint = _BrowseEndpoint;

// dist/src/parser/classes/endpoints/CreateCommentEndpoint.js
var API_PATH4 = "comment/create_comment";
var _data6;
var _CreateCommentEndpoint = class _CreateCommentEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data6);
    __privateSet(this, _data6, data2);
  }
  getApiPath() {
    return API_PATH4;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data6).createCommentParams)
      request.createCommentParams = __privateGet(this, _data6).createCommentParams;
    if (__privateGet(this, _data6).commentText)
      request.commentText = __privateGet(this, _data6).commentText;
    if (__privateGet(this, _data6).attachedVideoId)
      request.videoAttachment = { videoId: __privateGet(this, _data6).attachedVideoId };
    else if (__privateGet(this, _data6).pollOptions)
      request.pollAttachment = { choices: __privateGet(this, _data6).pollOptions };
    else if (__privateGet(this, _data6).imageBlobId)
      request.imageAttachment = { encryptedBlobId: __privateGet(this, _data6).imageBlobId };
    else if (__privateGet(this, _data6).sharedPostId)
      request.sharedPostAttachment = { postId: __privateGet(this, _data6).sharedPostId };
    if (__privateGet(this, _data6).accessRestrictions && typeof __privateGet(this, _data6).accessRestrictions === "number") {
      const restriction = __privateGet(this, _data6).accessRestrictions === 1 ? "RESTRICTION_TYPE_EVERYONE" : "RESTRICTION_TYPE_SPONSORS_ONLY";
      request.accessRestrictions = { restriction };
    }
    if (__privateGet(this, _data6).botguardResponse)
      request.botguardResponse = __privateGet(this, _data6).botguardResponse;
    return request;
  }
};
_data6 = new WeakMap();
__name(_CreateCommentEndpoint, "CreateCommentEndpoint");
__publicField(_CreateCommentEndpoint, "type", "CreateCommentEndpoint");
var CreateCommentEndpoint = _CreateCommentEndpoint;

// dist/src/parser/classes/endpoints/CreatePlaylistServiceEndpoint.js
var API_PATH5 = "playlist/create";
var _data7;
var _CreatePlaylistServiceEndpoint = class _CreatePlaylistServiceEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data7);
    __privateSet(this, _data7, data2);
  }
  getApiPath() {
    return API_PATH5;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data7).title)
      request.title = __privateGet(this, _data7).title;
    if (__privateGet(this, _data7).privacyStatus)
      request.privacyStatus = __privateGet(this, _data7).privacyStatus;
    if (__privateGet(this, _data7).description)
      request.description = __privateGet(this, _data7).description;
    if (__privateGet(this, _data7).videoIds)
      request.videoIds = __privateGet(this, _data7).videoIds;
    if (__privateGet(this, _data7).params)
      request.params = __privateGet(this, _data7).params;
    if (__privateGet(this, _data7).sourcePlaylistId)
      request.sourcePlaylistId = __privateGet(this, _data7).sourcePlaylistId;
    return request;
  }
};
_data7 = new WeakMap();
__name(_CreatePlaylistServiceEndpoint, "CreatePlaylistServiceEndpoint");
__publicField(_CreatePlaylistServiceEndpoint, "type", "CreatePlaylistServiceEndpoint");
var CreatePlaylistServiceEndpoint = _CreatePlaylistServiceEndpoint;

// dist/src/parser/classes/endpoints/DeletePlaylistEndpoint.js
var API_PATH6 = "playlist/delete";
var _data8;
var _DeletePlaylistEndpoint = class _DeletePlaylistEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data8);
    __privateSet(this, _data8, data2);
  }
  getApiPath() {
    return API_PATH6;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data8).playlistId)
      request.playlistId = __privateGet(this, _data8).sourcePlaylistId;
    return request;
  }
};
_data8 = new WeakMap();
__name(_DeletePlaylistEndpoint, "DeletePlaylistEndpoint");
__publicField(_DeletePlaylistEndpoint, "type", "DeletePlaylistEndpoint");
var DeletePlaylistEndpoint = _DeletePlaylistEndpoint;

// dist/src/parser/classes/endpoints/FeedbackEndpoint.js
var API_PATH7 = "feedback";
var _data9;
var _FeedbackEndpoint = class _FeedbackEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data9);
    __privateSet(this, _data9, data2);
  }
  getApiPath() {
    return API_PATH7;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data9).feedbackToken)
      request.feedbackTokens = [__privateGet(this, _data9).feedbackToken];
    if (__privateGet(this, _data9).cpn)
      request.feedbackContext = { cpn: __privateGet(this, _data9).cpn };
    request.isFeedbackTokenUnencrypted = !!__privateGet(this, _data9).isFeedbackTokenUnencrypted;
    request.shouldMerge = !!__privateGet(this, _data9).shouldMerge;
    return request;
  }
};
_data9 = new WeakMap();
__name(_FeedbackEndpoint, "FeedbackEndpoint");
__publicField(_FeedbackEndpoint, "type", "FeedbackEndpoint");
var FeedbackEndpoint = _FeedbackEndpoint;

// dist/src/parser/classes/endpoints/GetAccountsListInnertubeEndpoint.js
var API_PATH8 = "account/accounts_list";
var _data10;
var _GetAccountsListInnertubeEndpoint = class _GetAccountsListInnertubeEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data10);
    __privateSet(this, _data10, data2);
  }
  getApiPath() {
    return API_PATH8;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data10).requestType) {
      request.requestType = __privateGet(this, _data10).requestType;
      if (__privateGet(this, _data10).requestType === "ACCOUNTS_LIST_REQUEST_TYPE_CHANNEL_SWITCHER" || __privateGet(this, _data10).requestType === "ACCOUNTS_LIST_REQUEST_TYPE_IDENTITY_PROMPT") {
        if (__privateGet(this, _data10).nextUrl)
          request.nextNavendpoint = {
            urlEndpoint: {
              url: __privateGet(this, _data10).nextUrl
            }
          };
      }
    }
    if (__privateGet(this, _data10).channelSwitcherQuery)
      request.channelSwitcherQuery = __privateGet(this, _data10).channelSwitcherQuery;
    if (__privateGet(this, _data10).triggerChannelCreation)
      request.triggerChannelCreation = __privateGet(this, _data10).triggerChannelCreation;
    if (__privateGet(this, _data10).contentOwnerConfig && __privateGet(this, _data10).contentOwnerConfig.externalContentOwnerId)
      request.contentOwnerConfig = __privateGet(this, _data10).contentOwnerConfig;
    if (__privateGet(this, _data10).obfuscatedSelectedGaiaId)
      request.obfuscatedSelectedGaiaId = __privateGet(this, _data10).obfuscatedSelectedGaiaId;
    if (__privateGet(this, _data10).selectedSerializedDelegationContext)
      request.selectedSerializedDelegationContext = __privateGet(this, _data10).selectedSerializedDelegationContext;
    if (__privateGet(this, _data10).callCircumstance)
      request.callCircumstance = __privateGet(this, _data10).callCircumstance;
    return request;
  }
};
_data10 = new WeakMap();
__name(_GetAccountsListInnertubeEndpoint, "GetAccountsListInnertubeEndpoint");
__publicField(_GetAccountsListInnertubeEndpoint, "type", "GetAccountsListInnertubeEndpoint");
var GetAccountsListInnertubeEndpoint = _GetAccountsListInnertubeEndpoint;

// dist/src/parser/classes/endpoints/HideEngagementPanelEndpoint.js
var _HideEngagementPanelEndpoint = class _HideEngagementPanelEndpoint extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "panel_identifier");
    this.panel_identifier = data2.panelIdentifier;
  }
};
__name(_HideEngagementPanelEndpoint, "HideEngagementPanelEndpoint");
__publicField(_HideEngagementPanelEndpoint, "type", "HideEngagementPanelEndpoint");
var HideEngagementPanelEndpoint = _HideEngagementPanelEndpoint;

// dist/src/parser/classes/endpoints/LikeEndpoint.js
var LIKE_API_PATH = "like/like";
var DISLIKE_API_PATH = "like/dislike";
var REMOVE_LIKE_API_PATH = "like/removelike";
var _data11;
var _LikeEndpoint = class _LikeEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data11);
    __privateSet(this, _data11, data2);
  }
  getApiPath() {
    return __privateGet(this, _data11).status === "DISLIKE" ? DISLIKE_API_PATH : __privateGet(this, _data11).status === "INDIFFERENT" ? REMOVE_LIKE_API_PATH : LIKE_API_PATH;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data11).target)
      request.target = __privateGet(this, _data11).target;
    const params = this.getParams();
    if (params)
      request.params = params;
    return request;
  }
  getParams() {
    switch (__privateGet(this, _data11).status) {
      case "LIKE":
        return __privateGet(this, _data11).likeParams;
      case "DISLIKE":
        return __privateGet(this, _data11).dislikeParams;
      case "INDIFFERENT":
        return __privateGet(this, _data11).removeLikeParams;
      default:
        return void 0;
    }
  }
};
_data11 = new WeakMap();
__name(_LikeEndpoint, "LikeEndpoint");
__publicField(_LikeEndpoint, "type", "LikeEndpoint");
var LikeEndpoint = _LikeEndpoint;

// dist/src/parser/classes/endpoints/LiveChatItemContextMenuEndpoint.js
var API_PATH9 = "live_chat/get_item_context_menu";
var _data12;
var _LiveChatItemContextMenuEndpoint = class _LiveChatItemContextMenuEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data12);
    __privateSet(this, _data12, data2);
  }
  getApiPath() {
    return API_PATH9;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data12).params)
      request.params = __privateGet(this, _data12).params;
    return request;
  }
};
_data12 = new WeakMap();
__name(_LiveChatItemContextMenuEndpoint, "LiveChatItemContextMenuEndpoint");
__publicField(_LiveChatItemContextMenuEndpoint, "type", "LiveChatItemContextMenuEndpoint");
var LiveChatItemContextMenuEndpoint = _LiveChatItemContextMenuEndpoint;

// dist/src/parser/classes/endpoints/ModifyChannelNotificationPreferenceEndpoint.js
var API_PATH10 = "notification/modify_channel_preference";
var _data13;
var _ModifyChannelNotificationPreferenceEndpoint = class _ModifyChannelNotificationPreferenceEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data13);
    __privateSet(this, _data13, data2);
  }
  getApiPath() {
    return API_PATH10;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data13).params)
      request.params = __privateGet(this, _data13).params;
    if (__privateGet(this, _data13).secondaryParams)
      request.secondaryParams = __privateGet(this, _data13).secondaryParams;
    return request;
  }
};
_data13 = new WeakMap();
__name(_ModifyChannelNotificationPreferenceEndpoint, "ModifyChannelNotificationPreferenceEndpoint");
__publicField(_ModifyChannelNotificationPreferenceEndpoint, "type", "ModifyChannelNotificationPreferenceEndpoint");
var ModifyChannelNotificationPreferenceEndpoint = _ModifyChannelNotificationPreferenceEndpoint;

// dist/src/parser/classes/endpoints/PerformCommentActionEndpoint.js
var API_PATH11 = "comment/perform_comment_action";
var _data14;
var _PerformCommentActionEndpoint = class _PerformCommentActionEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data14);
    __privateSet(this, _data14, data2);
  }
  getApiPath() {
    return API_PATH11;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data14).actions)
      request.actions = __privateGet(this, _data14).actions;
    if (__privateGet(this, _data14).action)
      request.actions = [__privateGet(this, _data14).action];
    return request;
  }
};
_data14 = new WeakMap();
__name(_PerformCommentActionEndpoint, "PerformCommentActionEndpoint");
__publicField(_PerformCommentActionEndpoint, "type", "PerformCommentActionEndpoint");
var PerformCommentActionEndpoint = _PerformCommentActionEndpoint;

// dist/src/parser/classes/endpoints/PlaylistEditEndpoint.js
var API_PATH12 = "browse/edit_playlist";
var _data15;
var _PlaylistEditEndpoint = class _PlaylistEditEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data15);
    __privateSet(this, _data15, data2);
  }
  getApiPath() {
    return API_PATH12;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data15).actions)
      request.actions = __privateGet(this, _data15).actions;
    if (__privateGet(this, _data15).playlistId)
      request.playlistId = __privateGet(this, _data15).playlistId;
    if (__privateGet(this, _data15).params)
      request.params = __privateGet(this, _data15).params;
    return request;
  }
};
_data15 = new WeakMap();
__name(_PlaylistEditEndpoint, "PlaylistEditEndpoint");
__publicField(_PlaylistEditEndpoint, "type", "PlaylistEditEndpoint");
var PlaylistEditEndpoint = _PlaylistEditEndpoint;

// dist/src/parser/classes/endpoints/WatchEndpoint.js
var API_PATH13 = "player";
var _data16;
var _WatchEndpoint = class _WatchEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data16);
    __privateSet(this, _data16, data2);
  }
  getApiPath() {
    return API_PATH13;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data16).videoId)
      request.videoId = __privateGet(this, _data16).videoId;
    if (__privateGet(this, _data16).playlistId)
      request.playlistId = __privateGet(this, _data16).playlistId;
    if (__privateGet(this, _data16).index !== void 0 || __privateGet(this, _data16).playlistIndex !== void 0)
      request.playlistIndex = __privateGet(this, _data16).index || __privateGet(this, _data16).playlistIndex;
    if (__privateGet(this, _data16).playerParams || __privateGet(this, _data16).params)
      request.params = __privateGet(this, _data16).playerParams || __privateGet(this, _data16).params;
    if (__privateGet(this, _data16).startTimeSeconds)
      request.startTimeSecs = __privateGet(this, _data16).startTimeSeconds;
    if (__privateGet(this, _data16).overrideMutedAtStart)
      request.overrideMutedAtStart = __privateGet(this, _data16).overrideMutedAtStart;
    request.racyCheckOk = !!__privateGet(this, _data16).racyCheckOk;
    request.contentCheckOk = !!__privateGet(this, _data16).contentCheckOk;
    return request;
  }
};
_data16 = new WeakMap();
__name(_WatchEndpoint, "WatchEndpoint");
__publicField(_WatchEndpoint, "type", "WatchEndpoint");
var WatchEndpoint = _WatchEndpoint;

// dist/src/parser/classes/endpoints/PrefetchWatchCommand.js
var _PrefetchWatchCommand = class _PrefetchWatchCommand extends WatchEndpoint {
  constructor(data2) {
    super(data2);
  }
};
__name(_PrefetchWatchCommand, "PrefetchWatchCommand");
__publicField(_PrefetchWatchCommand, "type", "PrefetchWatchCommand");
var PrefetchWatchCommand = _PrefetchWatchCommand;

// dist/src/parser/classes/endpoints/ReelWatchEndpoint.js
var API_PATH14 = "reel/reel_item_watch";
var _data17;
var _ReelWatchEndpoint = class _ReelWatchEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data17);
    __privateSet(this, _data17, data2);
  }
  getApiPath() {
    return API_PATH14;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data17).videoId) {
      request.playerRequest = {
        videoId: __privateGet(this, _data17).videoId
      };
    }
    if (request.playerRequest) {
      if (__privateGet(this, _data17).playerParams)
        request.playerRequest.params = __privateGet(this, _data17).playerParams;
      if (__privateGet(this, _data17).racyCheckOk)
        request.playerRequest.racyCheckOk = !!__privateGet(this, _data17).racyCheckOk;
      if (__privateGet(this, _data17).contentCheckOk)
        request.playerRequest.contentCheckOk = !!__privateGet(this, _data17).contentCheckOk;
    }
    if (__privateGet(this, _data17).params)
      request.params = __privateGet(this, _data17).params;
    if (__privateGet(this, _data17).inputType)
      request.inputType = __privateGet(this, _data17).inputType;
    request.disablePlayerResponse = !!__privateGet(this, _data17).disablePlayerResponse;
    return request;
  }
};
_data17 = new WeakMap();
__name(_ReelWatchEndpoint, "ReelWatchEndpoint");
__publicField(_ReelWatchEndpoint, "type", "ReelWatchEndpoint");
var ReelWatchEndpoint = _ReelWatchEndpoint;

// dist/src/parser/classes/endpoints/SearchEndpoint.js
var API_PATH15 = "search";
var _data18;
var _SearchEndpoint = class _SearchEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data18);
    __privateSet(this, _data18, data2);
  }
  getApiPath() {
    return API_PATH15;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data18).query)
      request.query = __privateGet(this, _data18).query;
    if (__privateGet(this, _data18).params)
      request.params = __privateGet(this, _data18).params;
    if (__privateGet(this, _data18).webSearchboxStatsUrl)
      request.webSearchboxStatsUrl = __privateGet(this, _data18).webSearchboxStatsUrl;
    if (__privateGet(this, _data18).suggestStats)
      request.suggestStats = __privateGet(this, _data18).suggestStats;
    return request;
  }
};
_data18 = new WeakMap();
__name(_SearchEndpoint, "SearchEndpoint");
__publicField(_SearchEndpoint, "type", "SearchEndpoint");
var SearchEndpoint = _SearchEndpoint;

// dist/src/parser/classes/endpoints/ShareEntityServiceEndpoint.js
var API_PATH16 = "share/get_share_panel";
var _data19;
var _ShareEntityServiceEndpoint = class _ShareEntityServiceEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data19);
    __privateSet(this, _data19, data2);
  }
  getApiPath() {
    return API_PATH16;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data19).serializedShareEntity)
      request.serializedSharedEntity = __privateGet(this, _data19).serializedShareEntity;
    if (__privateGet(this, _data19).clientParams)
      request.clientParams = __privateGet(this, _data19).clientParams;
    return request;
  }
};
_data19 = new WeakMap();
__name(_ShareEntityServiceEndpoint, "ShareEntityServiceEndpoint");
__publicField(_ShareEntityServiceEndpoint, "type", "ShareEntityServiceEndpoint");
var ShareEntityServiceEndpoint = _ShareEntityServiceEndpoint;

// dist/src/parser/classes/endpoints/ShareEndpoint.js
var _ShareEndpoint = class _ShareEndpoint extends ShareEntityServiceEndpoint {
  constructor(data2) {
    super(data2);
  }
};
__name(_ShareEndpoint, "ShareEndpoint");
__publicField(_ShareEndpoint, "type", "ShareEndpoint");
var ShareEndpoint = _ShareEndpoint;

// dist/src/parser/classes/endpoints/ShareEntityEndpoint.js
var _ShareEntityEndpoint = class _ShareEntityEndpoint extends ShareEntityServiceEndpoint {
  constructor(data2) {
    super(data2);
  }
};
__name(_ShareEntityEndpoint, "ShareEntityEndpoint");
__publicField(_ShareEntityEndpoint, "type", "ShareEntityEndpoint");
var ShareEntityEndpoint = _ShareEntityEndpoint;

// dist/src/parser/classes/endpoints/ShowEngagementPanelEndpoint.js
var _ShowEngagementPanelEndpoint = class _ShowEngagementPanelEndpoint extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "panel_identifier");
    __publicField(this, "source_panel_identifier");
    this.panel_identifier = data2.panelIdentifier;
    this.source_panel_identifier = data2.sourcePanelIdentifier;
  }
};
__name(_ShowEngagementPanelEndpoint, "ShowEngagementPanelEndpoint");
__publicField(_ShowEngagementPanelEndpoint, "type", "ShowEngagementPanelEndpoint");
var ShowEngagementPanelEndpoint = _ShowEngagementPanelEndpoint;

// dist/src/parser/classes/endpoints/SignalServiceEndpoint.js
var _SignalServiceEndpoint = class _SignalServiceEndpoint extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "actions");
    __publicField(this, "signal");
    if (Array.isArray(data2.actions)) {
      this.actions = parser_exports.parseArray(data2.actions.map((action) => {
        delete action.clickTrackingParams;
        return action;
      }));
    }
    this.signal = data2.signal;
  }
};
__name(_SignalServiceEndpoint, "SignalServiceEndpoint");
__publicField(_SignalServiceEndpoint, "type", "SignalServiceEndpoint");
var SignalServiceEndpoint = _SignalServiceEndpoint;

// dist/src/parser/classes/endpoints/SubscribeEndpoint.js
var API_PATH17 = "subscription/subscribe";
var _data20;
var _SubscribeEndpoint = class _SubscribeEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data20);
    __privateSet(this, _data20, data2);
  }
  getApiPath() {
    return API_PATH17;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data20).channelIds)
      request.channelIds = __privateGet(this, _data20).channelIds;
    if (__privateGet(this, _data20).siloName)
      request.siloName = __privateGet(this, _data20).siloName;
    if (__privateGet(this, _data20).params)
      request.params = __privateGet(this, _data20).params;
    if (__privateGet(this, _data20).botguardResponse)
      request.botguardResponse = __privateGet(this, _data20).botguardResponse;
    if (__privateGet(this, _data20).feature)
      request.clientFeature = __privateGet(this, _data20).feature;
    return request;
  }
};
_data20 = new WeakMap();
__name(_SubscribeEndpoint, "SubscribeEndpoint");
__publicField(_SubscribeEndpoint, "type", "SubscribeEndpoint");
var SubscribeEndpoint = _SubscribeEndpoint;

// dist/src/parser/classes/endpoints/UnsubscribeEndpoint.js
var API_PATH18 = "subscription/unsubscribe";
var _data21;
var _UnsubscribeEndpoint = class _UnsubscribeEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data21);
    __privateSet(this, _data21, data2);
  }
  getApiPath() {
    return API_PATH18;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data21).channelIds)
      request.channelIds = __privateGet(this, _data21).channelIds;
    if (__privateGet(this, _data21).siloName)
      request.siloName = __privateGet(this, _data21).siloName;
    if (__privateGet(this, _data21).params)
      request.params = __privateGet(this, _data21).params;
    return request;
  }
};
_data21 = new WeakMap();
__name(_UnsubscribeEndpoint, "UnsubscribeEndpoint");
__publicField(_UnsubscribeEndpoint, "type", "UnsubscribeEndpoint");
var UnsubscribeEndpoint = _UnsubscribeEndpoint;

// dist/src/parser/classes/endpoints/WatchNextEndpoint.js
var API_PATH19 = "next";
var _data22;
var _WatchNextEndpoint = class _WatchNextEndpoint extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _data22);
    __privateSet(this, _data22, data2);
  }
  getApiPath() {
    return API_PATH19;
  }
  buildRequest() {
    const request = {};
    if (__privateGet(this, _data22).videoId)
      request.videoId = __privateGet(this, _data22).videoId;
    if (__privateGet(this, _data22).playlistId)
      request.playlistId = __privateGet(this, _data22).playlistId;
    if (__privateGet(this, _data22).index !== void 0 || __privateGet(this, _data22).playlistIndex !== void 0)
      request.playlistIndex = __privateGet(this, _data22).index || __privateGet(this, _data22).playlistIndex;
    if (__privateGet(this, _data22).playerParams || __privateGet(this, _data22).params)
      request.params = __privateGet(this, _data22).playerParams || __privateGet(this, _data22).params;
    request.racyCheckOk = !!__privateGet(this, _data22).racyCheckOk;
    request.contentCheckOk = !!__privateGet(this, _data22).contentCheckOk;
    return request;
  }
};
_data22 = new WeakMap();
__name(_WatchNextEndpoint, "WatchNextEndpoint");
__publicField(_WatchNextEndpoint, "type", "WatchNextEndpoint");
var WatchNextEndpoint = _WatchNextEndpoint;

// dist/src/parser/classes/Endscreen.js
var _Endscreen = class _Endscreen extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "elements");
    __publicField(this, "start_ms");
    this.elements = parser_exports.parseArray(data2.elements);
    this.start_ms = data2.startMs;
  }
};
__name(_Endscreen, "Endscreen");
__publicField(_Endscreen, "type", "Endscreen");
var Endscreen = _Endscreen;

// dist/src/parser/classes/EndscreenElement.js
var _EndscreenElement = class _EndscreenElement extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "style");
    __publicField(this, "title");
    __publicField(this, "endpoint");
    __publicField(this, "image");
    __publicField(this, "icon");
    __publicField(this, "metadata");
    __publicField(this, "call_to_action");
    __publicField(this, "hovercard_button");
    __publicField(this, "is_subscribe");
    __publicField(this, "playlist_length");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "left");
    __publicField(this, "top");
    __publicField(this, "width");
    __publicField(this, "aspect_ratio");
    __publicField(this, "start_ms");
    __publicField(this, "end_ms");
    __publicField(this, "id");
    this.style = data2.style;
    this.title = new Text2(data2.title);
    this.endpoint = new NavigationEndpoint(data2.endpoint);
    if (Reflect.has(data2, "image")) {
      this.image = Thumbnail.fromResponse(data2.image);
    }
    if (Reflect.has(data2, "icon")) {
      this.icon = Thumbnail.fromResponse(data2.icon);
    }
    if (Reflect.has(data2, "metadata")) {
      this.metadata = new Text2(data2.metadata);
    }
    if (Reflect.has(data2, "callToAction")) {
      this.call_to_action = new Text2(data2.callToAction);
    }
    if (Reflect.has(data2, "hovercardButton")) {
      this.hovercard_button = parser_exports.parseItem(data2.hovercardButton);
    }
    if (Reflect.has(data2, "isSubscribe")) {
      this.is_subscribe = !!data2.isSubscribe;
    }
    if (Reflect.has(data2, "playlistLength")) {
      this.playlist_length = new Text2(data2.playlistLength);
    }
    if (Reflect.has(data2, "thumbnailOverlays")) {
      this.thumbnail_overlays = parser_exports.parseArray(data2.thumbnailOverlays);
    }
    this.left = parseFloat(data2.left);
    this.width = parseFloat(data2.width);
    this.top = parseFloat(data2.top);
    this.aspect_ratio = parseFloat(data2.aspectRatio);
    this.start_ms = parseFloat(data2.startMs);
    this.end_ms = parseFloat(data2.endMs);
    this.id = data2.id;
  }
};
__name(_EndscreenElement, "EndscreenElement");
__publicField(_EndscreenElement, "type", "EndscreenElement");
var EndscreenElement = _EndscreenElement;

// dist/src/parser/classes/EndScreenPlaylist.js
var _EndScreenPlaylist = class _EndScreenPlaylist extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "author");
    __publicField(this, "endpoint");
    __publicField(this, "thumbnails");
    __publicField(this, "video_count");
    this.id = data2.playlistId;
    this.title = new Text2(data2.title);
    this.author = new Text2(data2.longBylineText);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.video_count = new Text2(data2.videoCountText);
  }
};
__name(_EndScreenPlaylist, "EndScreenPlaylist");
__publicField(_EndScreenPlaylist, "type", "EndScreenPlaylist");
var EndScreenPlaylist = _EndScreenPlaylist;

// dist/src/parser/classes/EndScreenVideo.js
var _EndScreenVideo = class _EndScreenVideo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "author");
    __publicField(this, "endpoint");
    __publicField(this, "short_view_count");
    __publicField(this, "badges");
    __publicField(this, "duration");
    this.id = data2.videoId;
    this.title = new Text2(data2.title);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.thumbnail_overlays = parser_exports.parseArray(data2.thumbnailOverlays);
    this.author = new Author(data2.shortBylineText, data2.ownerBadges);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.short_view_count = new Text2(data2.shortViewCountText);
    this.badges = parser_exports.parseArray(data2.badges);
    this.duration = {
      text: new Text2(data2.lengthText).toString(),
      seconds: data2.lengthInSeconds
    };
  }
};
__name(_EndScreenVideo, "EndScreenVideo");
__publicField(_EndScreenVideo, "type", "EndScreenVideo");
var EndScreenVideo = _EndScreenVideo;

// dist/src/parser/classes/ExpandableTab.js
var _ExpandableTab = class _ExpandableTab extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "endpoint");
    __publicField(this, "selected");
    __publicField(this, "content");
    this.title = data2.title;
    this.endpoint = new NavigationEndpoint(data2.endpoint);
    this.selected = data2.selected;
    this.content = parser_exports.parseItem(data2.content);
  }
};
__name(_ExpandableTab, "ExpandableTab");
__publicField(_ExpandableTab, "type", "ExpandableTab");
var ExpandableTab = _ExpandableTab;

// dist/src/parser/classes/ExpandedShelfContents.js
var _ExpandedShelfContents = class _ExpandedShelfContents extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data2.items);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_ExpandedShelfContents, "ExpandedShelfContents");
__publicField(_ExpandedShelfContents, "type", "ExpandedShelfContents");
var ExpandedShelfContents = _ExpandedShelfContents;

// dist/src/parser/classes/FancyDismissibleDialog.js
var _FancyDismissibleDialog = class _FancyDismissibleDialog extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "dialog_message");
    __publicField(this, "confirm_label");
    this.dialog_message = new Text2(data2.dialogMessage);
    this.confirm_label = new Text2(data2.confirmLabel);
  }
};
__name(_FancyDismissibleDialog, "FancyDismissibleDialog");
__publicField(_FancyDismissibleDialog, "type", "FancyDismissibleDialog");
var FancyDismissibleDialog = _FancyDismissibleDialog;

// dist/src/parser/classes/FeedFilterChipBar.js
var _FeedFilterChipBar = class _FeedFilterChipBar extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data2.contents, ChipCloudChip);
  }
};
__name(_FeedFilterChipBar, "FeedFilterChipBar");
__publicField(_FeedFilterChipBar, "type", "FeedFilterChipBar");
var FeedFilterChipBar = _FeedFilterChipBar;

// dist/src/parser/classes/FeedNudge.js
var _FeedNudge = class _FeedNudge extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "endpoint");
    __publicField(this, "apply_modernized_style");
    __publicField(this, "trim_style");
    __publicField(this, "background_style");
    this.title = new Text2(data2.title);
    this.subtitle = new Text2(data2.subtitle);
    this.endpoint = new NavigationEndpoint(data2.impressionEndpoint);
    this.apply_modernized_style = data2.applyModernizedStyle;
    this.trim_style = data2.trimStyle;
    this.background_style = data2.backgroundStyle;
  }
};
__name(_FeedNudge, "FeedNudge");
__publicField(_FeedNudge, "type", "FeedNudge");
var FeedNudge = _FeedNudge;

// dist/src/parser/classes/FeedTabbedHeader.js
var _FeedTabbedHeader = class _FeedTabbedHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data2.title);
  }
};
__name(_FeedTabbedHeader, "FeedTabbedHeader");
__publicField(_FeedTabbedHeader, "type", "FeedTabbedHeader");
var FeedTabbedHeader = _FeedTabbedHeader;

// dist/src/parser/classes/GameDetails.js
var _GameDetails = class _GameDetails extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "box_art");
    __publicField(this, "box_art_overlay_text");
    __publicField(this, "endpoint");
    __publicField(this, "is_official_box_art");
    this.title = new Text2(data2.title);
    this.box_art = Thumbnail.fromResponse(data2.boxArt);
    this.box_art_overlay_text = new Text2(data2.boxArtOverlayText);
    this.endpoint = new NavigationEndpoint(data2.endpoint);
    this.is_official_box_art = !!data2.isOfficialBoxArt;
  }
};
__name(_GameDetails, "GameDetails");
__publicField(_GameDetails, "type", "GameDetails");
var GameDetails = _GameDetails;

// dist/src/parser/classes/Grid.js
var _Grid = class _Grid extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    __publicField(this, "is_collapsible");
    __publicField(this, "visible_row_count");
    __publicField(this, "target_id");
    __publicField(this, "continuation");
    __publicField(this, "header");
    this.items = parser_exports.parseArray(data2.items);
    if (Reflect.has(data2, "header")) {
      this.header = parser_exports.parseItem(data2.header);
    }
    if (Reflect.has(data2, "isCollapsible")) {
      this.is_collapsible = data2.isCollapsible;
    }
    if (Reflect.has(data2, "visibleRowCount")) {
      this.visible_row_count = data2.visibleRowCount;
    }
    if (Reflect.has(data2, "targetId")) {
      this.target_id = data2.targetId;
    }
    this.continuation = data2.continuations?.[0]?.nextContinuationData?.continuation || null;
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_Grid, "Grid");
__publicField(_Grid, "type", "Grid");
var Grid = _Grid;

// dist/src/parser/classes/GridChannel.js
var _GridChannel = class _GridChannel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "author");
    __publicField(this, "subscribers");
    __publicField(this, "video_count");
    __publicField(this, "endpoint");
    __publicField(this, "subscribe_button");
    this.id = data2.channelId;
    this.author = new Author({
      ...data2.title,
      navigationEndpoint: data2.navigationEndpoint
    }, data2.ownerBadges, data2.thumbnail);
    this.subscribers = new Text2(data2.subscriberCountText);
    this.video_count = new Text2(data2.videoCountText);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.subscribe_button = parser_exports.parseItem(data2.subscribeButton);
  }
};
__name(_GridChannel, "GridChannel");
__publicField(_GridChannel, "type", "GridChannel");
var GridChannel = _GridChannel;

// dist/src/parser/classes/GridHeader.js
var _GridHeader = class _GridHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data2.title);
  }
};
__name(_GridHeader, "GridHeader");
__publicField(_GridHeader, "type", "GridHeader");
var GridHeader = _GridHeader;

// dist/src/parser/classes/GridMix.js
var _GridMix = class _GridMix extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "author");
    __publicField(this, "thumbnails");
    __publicField(this, "video_count");
    __publicField(this, "video_count_short");
    __publicField(this, "endpoint");
    __publicField(this, "secondary_endpoint");
    __publicField(this, "thumbnail_overlays");
    this.id = data2.playlistId;
    this.title = new Text2(data2.title);
    this.author = data2.shortBylineText?.simpleText ? new Text2(data2.shortBylineText) : data2.longBylineText?.simpleText ? new Text2(data2.longBylineText) : null;
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.video_count = new Text2(data2.videoCountText);
    this.video_count_short = new Text2(data2.videoCountShortText);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.secondary_endpoint = new NavigationEndpoint(data2.secondaryNavigationEndpoint);
    this.thumbnail_overlays = parser_exports.parseArray(data2.thumbnailOverlays);
  }
};
__name(_GridMix, "GridMix");
__publicField(_GridMix, "type", "GridMix");
var GridMix = _GridMix;

// dist/src/parser/classes/GridMovie.js
var _GridMovie = class _GridMovie extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "thumbnails");
    __publicField(this, "duration");
    __publicField(this, "endpoint");
    __publicField(this, "badges");
    __publicField(this, "metadata");
    __publicField(this, "thumbnail_overlays");
    const length_alt = data2.thumbnailOverlays.find((overlay) => overlay.hasOwnProperty("thumbnailOverlayTimeStatusRenderer"))?.thumbnailOverlayTimeStatusRenderer;
    this.id = data2.videoId;
    this.title = new Text2(data2.title);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.duration = data2.lengthText ? new Text2(data2.lengthText) : length_alt?.text ? new Text2(length_alt.text) : null;
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.badges = parser_exports.parseArray(data2.badges, MetadataBadge);
    this.metadata = new Text2(data2.metadata);
    this.thumbnail_overlays = parser_exports.parseArray(data2.thumbnailOverlays);
  }
};
__name(_GridMovie, "GridMovie");
__publicField(_GridMovie, "type", "GridMovie");
var GridMovie = _GridMovie;

// dist/src/parser/classes/GridPlaylist.js
var _GridPlaylist = class _GridPlaylist extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "author");
    __publicField(this, "badges");
    __publicField(this, "endpoint");
    __publicField(this, "view_playlist");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_renderer");
    __publicField(this, "sidebar_thumbnails");
    __publicField(this, "video_count");
    __publicField(this, "video_count_short");
    this.id = data2.playlistId;
    this.title = new Text2(data2.title);
    if (Reflect.has(data2, "shortBylineText")) {
      this.author = new Author(data2.shortBylineText, data2.ownerBadges);
    }
    this.badges = parser_exports.parseArray(data2.ownerBadges);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.view_playlist = new Text2(data2.viewPlaylistText);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.thumbnail_renderer = parser_exports.parseItem(data2.thumbnailRenderer);
    this.sidebar_thumbnails = [].concat(...data2.sidebarThumbnails?.map((thumbnail) => Thumbnail.fromResponse(thumbnail)) || []) || null;
    this.video_count = new Text2(data2.thumbnailText);
    this.video_count_short = new Text2(data2.videoCountShortText);
  }
};
__name(_GridPlaylist, "GridPlaylist");
__publicField(_GridPlaylist, "type", "GridPlaylist");
var GridPlaylist = _GridPlaylist;

// dist/src/parser/classes/GridShelfView.js
var _GridShelfView = class _GridShelfView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    __publicField(this, "header");
    __publicField(this, "content_aspect_ratio");
    __publicField(this, "enable_vertical_expansion");
    __publicField(this, "show_more_button");
    __publicField(this, "show_less_button");
    __publicField(this, "min_collapsed_item_count");
    this.contents = parser_exports.parseArray(data2.contents);
    this.header = parser_exports.parseItem(data2.header);
    this.content_aspect_ratio = data2.contentAspectRatio;
    this.enable_vertical_expansion = data2.enableVerticalExpansion;
    this.show_more_button = parser_exports.parseItem(data2.showMoreButton, ButtonView);
    this.show_less_button = parser_exports.parseItem(data2.showLessButton, ButtonView);
    this.min_collapsed_item_count = data2.minCollapsedItemCount;
  }
};
__name(_GridShelfView, "GridShelfView");
__publicField(_GridShelfView, "type", "GridShelfView");
var GridShelfView = _GridShelfView;

// dist/src/parser/classes/ShowCustomThumbnail.js
var _ShowCustomThumbnail = class _ShowCustomThumbnail extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
  }
};
__name(_ShowCustomThumbnail, "ShowCustomThumbnail");
__publicField(_ShowCustomThumbnail, "type", "ShowCustomThumbnail");
var ShowCustomThumbnail = _ShowCustomThumbnail;

// dist/src/parser/classes/ThumbnailOverlayBottomPanel.js
var _ThumbnailOverlayBottomPanel = class _ThumbnailOverlayBottomPanel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "icon_type");
    if (Reflect.has(data2, "text")) {
      this.text = new Text2(data2.text);
    }
    if (Reflect.has(data2, "icon") && Reflect.has(data2.icon, "iconType")) {
      this.icon_type = data2.icon.iconType;
    }
  }
};
__name(_ThumbnailOverlayBottomPanel, "ThumbnailOverlayBottomPanel");
__publicField(_ThumbnailOverlayBottomPanel, "type", "ThumbnailOverlayBottomPanel");
var ThumbnailOverlayBottomPanel = _ThumbnailOverlayBottomPanel;

// dist/src/parser/classes/GridShow.js
var _GridShow = class _GridShow extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "thumbnail_renderer");
    __publicField(this, "endpoint");
    __publicField(this, "long_byline_text");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "author");
    this.title = new Text2(data2.title);
    this.thumbnail_renderer = parseItem(data2.thumbnailRenderer, ShowCustomThumbnail);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.long_byline_text = new Text2(data2.longBylineText);
    this.thumbnail_overlays = parseArray(data2.thumbnailOverlays, ThumbnailOverlayBottomPanel);
    this.author = new Author(data2.shortBylineText, void 0);
  }
};
__name(_GridShow, "GridShow");
__publicField(_GridShow, "type", "GridShow");
var GridShow = _GridShow;

// dist/src/parser/classes/GridVideo.js
var _GridVideo = class _GridVideo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "video_id");
    __publicField(this, "title");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "rich_thumbnail");
    __publicField(this, "published");
    __publicField(this, "duration");
    __publicField(this, "author");
    __publicField(this, "views");
    __publicField(this, "short_view_count");
    __publicField(this, "endpoint");
    __publicField(this, "menu");
    __publicField(this, "buttons");
    __publicField(this, "upcoming");
    __publicField(this, "upcoming_text");
    __publicField(this, "is_reminder_set");
    const length_alt = data2.thumbnailOverlays.find((overlay) => overlay.hasOwnProperty("thumbnailOverlayTimeStatusRenderer"))?.thumbnailOverlayTimeStatusRenderer;
    this.video_id = data2.videoId;
    this.title = new Text2(data2.title);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.thumbnail_overlays = parser_exports.parseArray(data2.thumbnailOverlays);
    this.rich_thumbnail = parser_exports.parseItem(data2.richThumbnail);
    this.published = new Text2(data2.publishedTimeText);
    this.duration = data2.lengthText ? new Text2(data2.lengthText) : length_alt?.text ? new Text2(length_alt.text) : null;
    this.author = data2.shortBylineText && new Author(data2.shortBylineText, data2.ownerBadges);
    this.views = new Text2(data2.viewCountText);
    this.short_view_count = new Text2(data2.shortViewCountText);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.menu = parser_exports.parseItem(data2.menu, Menu);
    if (Reflect.has(data2, "buttons")) {
      this.buttons = parser_exports.parseArray(data2.buttons);
    }
    if (Reflect.has(data2, "upcomingEventData")) {
      this.upcoming = new Date(Number(`${data2.upcomingEventData.startTime}000`));
      this.upcoming_text = new Text2(data2.upcomingEventData.upcomingEventText);
      this.is_reminder_set = !!data2.upcomingEventData?.isReminderSet;
    }
  }
  /**
   * @deprecated Use {@linkcode video_id} instead.
   */
  get id() {
    return this.video_id;
  }
  get is_upcoming() {
    return Boolean(this.upcoming && this.upcoming > /* @__PURE__ */ new Date());
  }
};
__name(_GridVideo, "GridVideo");
__publicField(_GridVideo, "type", "GridVideo");
var GridVideo = _GridVideo;

// dist/src/parser/classes/GuideEntry.js
var _GuideEntry = class _GuideEntry extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "endpoint");
    __publicField(this, "icon_type");
    __publicField(this, "thumbnails");
    __publicField(this, "badges");
    __publicField(this, "is_primary");
    this.title = new Text2(data2.formattedTitle);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint || data2.serviceEndpoint);
    if (Reflect.has(data2, "icon") && Reflect.has(data2.icon, "iconType")) {
      this.icon_type = data2.icon.iconType;
    }
    if (Reflect.has(data2, "thumbnail")) {
      this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    }
    if (Reflect.has(data2, "badges")) {
      this.badges = data2.badges;
    }
    this.is_primary = !!data2.isPrimary;
  }
};
__name(_GuideEntry, "GuideEntry");
__publicField(_GuideEntry, "type", "GuideEntry");
var GuideEntry = _GuideEntry;

// dist/src/parser/classes/GuideCollapsibleEntry.js
var _GuideCollapsibleEntry = class _GuideCollapsibleEntry extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "expander_item");
    __publicField(this, "collapser_item");
    __publicField(this, "expandable_items");
    this.expander_item = parseItem(data2.expanderItem, GuideEntry);
    this.collapser_item = parseItem(data2.collapserItem, GuideEntry);
    this.expandable_items = parseArray(data2.expandableItems);
  }
};
__name(_GuideCollapsibleEntry, "GuideCollapsibleEntry");
__publicField(_GuideCollapsibleEntry, "type", "GuideCollapsibleEntry");
var GuideCollapsibleEntry = _GuideCollapsibleEntry;

// dist/src/parser/classes/GuideCollapsibleSectionEntry.js
var _GuideCollapsibleSectionEntry = class _GuideCollapsibleSectionEntry extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header_entry");
    __publicField(this, "expander_icon");
    __publicField(this, "collapser_icon");
    __publicField(this, "section_items");
    this.header_entry = parseItem(data2.headerEntry);
    this.expander_icon = data2.expanderIcon.iconType;
    this.collapser_icon = data2.collapserIcon.iconType;
    this.section_items = parseArray(data2.sectionItems);
  }
};
__name(_GuideCollapsibleSectionEntry, "GuideCollapsibleSectionEntry");
__publicField(_GuideCollapsibleSectionEntry, "type", "GuideCollapsibleSectionEntry");
var GuideCollapsibleSectionEntry = _GuideCollapsibleSectionEntry;

// dist/src/parser/classes/GuideDownloadsEntry.js
var _GuideDownloadsEntry = class _GuideDownloadsEntry extends GuideEntry {
  constructor(data2) {
    super(data2.entryRenderer.guideEntryRenderer);
    __publicField(this, "always_show");
    this.always_show = !!data2.alwaysShow;
  }
};
__name(_GuideDownloadsEntry, "GuideDownloadsEntry");
__publicField(_GuideDownloadsEntry, "type", "GuideDownloadsEntry");
var GuideDownloadsEntry = _GuideDownloadsEntry;

// dist/src/parser/classes/GuideSection.js
var _GuideSection = class _GuideSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "items");
    if (Reflect.has(data2, "formattedTitle")) {
      this.title = new Text2(data2.formattedTitle);
    }
    this.items = parseArray(data2.items);
  }
};
__name(_GuideSection, "GuideSection");
__publicField(_GuideSection, "type", "GuideSection");
var GuideSection = _GuideSection;

// dist/src/parser/classes/GuideSubscriptionsSection.js
var _GuideSubscriptionsSection = class _GuideSubscriptionsSection extends GuideSection {
};
__name(_GuideSubscriptionsSection, "GuideSubscriptionsSection");
__publicField(_GuideSubscriptionsSection, "type", "GuideSubscriptionsSection");
var GuideSubscriptionsSection = _GuideSubscriptionsSection;

// dist/src/parser/classes/HashtagHeader.js
var _HashtagHeader = class _HashtagHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "hashtag");
    __publicField(this, "hashtag_info");
    this.hashtag = new Text2(data2.hashtag);
    this.hashtag_info = new Text2(data2.hashtagInfoText);
  }
};
__name(_HashtagHeader, "HashtagHeader");
__publicField(_HashtagHeader, "type", "HashtagHeader");
var HashtagHeader = _HashtagHeader;

// dist/src/parser/classes/HashtagTile.js
var _HashtagTile = class _HashtagTile extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "hashtag");
    __publicField(this, "hashtag_info_text");
    __publicField(this, "hashtag_thumbnail");
    __publicField(this, "endpoint");
    __publicField(this, "hashtag_background_color");
    __publicField(this, "hashtag_video_count");
    __publicField(this, "hashtag_channel_count");
    this.hashtag = new Text2(data2.hashtag);
    this.hashtag_info_text = new Text2(data2.hashtagInfoText);
    this.hashtag_thumbnail = Thumbnail.fromResponse(data2.hashtagThumbnail);
    this.endpoint = new NavigationEndpoint(data2.onTapCommand);
    this.hashtag_background_color = data2.hashtagBackgroundColor;
    this.hashtag_video_count = new Text2(data2.hashtagVideoCount);
    this.hashtag_channel_count = new Text2(data2.hashtagChannelCount);
  }
};
__name(_HashtagTile, "HashtagTile");
__publicField(_HashtagTile, "type", "HashtagTile");
var HashtagTile = _HashtagTile;

// dist/src/parser/classes/HeroPlaylistThumbnail.js
var _HeroPlaylistThumbnail = class _HeroPlaylistThumbnail extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnails");
    __publicField(this, "on_tap_endpoint");
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.on_tap_endpoint = new NavigationEndpoint(data2.onTap);
  }
};
__name(_HeroPlaylistThumbnail, "HeroPlaylistThumbnail");
__publicField(_HeroPlaylistThumbnail, "type", "HeroPlaylistThumbnail");
var HeroPlaylistThumbnail = _HeroPlaylistThumbnail;

// dist/src/parser/classes/HighlightsCarousel.js
var _Panel = class _Panel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "background_image");
    __publicField(this, "strapline");
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "text_on_tap_endpoint");
    __publicField(this, "cta");
    if (data2.thumbnail) {
      this.thumbnail = {
        image: Thumbnail.fromResponse(data2.thumbnail.image),
        endpoint: new NavigationEndpoint(data2.thumbnail.onTap),
        on_long_press_endpoint: new NavigationEndpoint(data2.thumbnail.onLongPress),
        content_mode: data2.thumbnail.contentMode,
        crop_options: data2.thumbnail.cropOptions
      };
    }
    this.background_image = {
      image: Thumbnail.fromResponse(data2.backgroundImage.image),
      gradient_image: Thumbnail.fromResponse(data2.backgroundImage.gradientImage)
    };
    this.strapline = data2.strapline;
    this.title = data2.title;
    this.description = data2.description;
    this.cta = {
      icon_name: data2.cta.iconName,
      title: data2.cta.title,
      endpoint: new NavigationEndpoint(data2.cta.onTap),
      accessibility_text: data2.cta.accessibilityText,
      state: data2.cta.state
    };
    this.text_on_tap_endpoint = new NavigationEndpoint(data2.textOnTap);
  }
};
__name(_Panel, "Panel");
__publicField(_Panel, "type", "Panel");
var Panel = _Panel;
var _HighlightsCarousel = class _HighlightsCarousel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "panels");
    this.panels = observe(data2.highlightsCarousel.panels.map((el) => new Panel(el)));
  }
};
__name(_HighlightsCarousel, "HighlightsCarousel");
__publicField(_HighlightsCarousel, "type", "HighlightsCarousel");
var HighlightsCarousel = _HighlightsCarousel;

// dist/src/parser/classes/SearchSuggestion.js
var _SearchSuggestion = class _SearchSuggestion extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "suggestion");
    __publicField(this, "endpoint");
    __publicField(this, "icon_type");
    __publicField(this, "service_endpoint");
    this.suggestion = new Text2(data2.suggestion);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    if (Reflect.has(data2, "icon")) {
      this.icon_type = data2.icon.iconType;
    }
    if (Reflect.has(data2, "serviceEndpoint")) {
      this.service_endpoint = new NavigationEndpoint(data2.serviceEndpoint);
    }
  }
};
__name(_SearchSuggestion, "SearchSuggestion");
__publicField(_SearchSuggestion, "type", "SearchSuggestion");
var SearchSuggestion = _SearchSuggestion;

// dist/src/parser/classes/HistorySuggestion.js
var _HistorySuggestion = class _HistorySuggestion extends SearchSuggestion {
  constructor(data2) {
    super(data2);
  }
};
__name(_HistorySuggestion, "HistorySuggestion");
__publicField(_HistorySuggestion, "type", "HistorySuggestion");
var HistorySuggestion = _HistorySuggestion;

// dist/src/parser/classes/HorizontalMovieList.js
var _HorizontalMovieList = class _HorizontalMovieList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    __publicField(this, "previous_button");
    __publicField(this, "next_button");
    this.items = parser_exports.parseArray(data2.items);
    this.previous_button = parser_exports.parseItem(data2.previousButton, Button);
    this.next_button = parser_exports.parseItem(data2.nextButton, Button);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_HorizontalMovieList, "HorizontalMovieList");
__publicField(_HorizontalMovieList, "type", "HorizontalMovieList");
var HorizontalMovieList = _HorizontalMovieList;

// dist/src/parser/classes/IconLink.js
var _IconLink = class _IconLink extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "icon_type");
    __publicField(this, "tooltip");
    __publicField(this, "endpoint");
    this.icon_type = data2.icon?.iconType;
    if (Reflect.has(data2, "tooltip")) {
      this.tooltip = new Text2(data2.tooltip).toString();
    }
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
  }
};
__name(_IconLink, "IconLink");
__publicField(_IconLink, "type", "IconLink");
var IconLink = _IconLink;

// dist/src/parser/classes/ImageBannerView.js
var _ImageBannerView = class _ImageBannerView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "image");
    __publicField(this, "style");
    this.image = Thumbnail.fromResponse(data2.image);
    this.style = data2.style;
  }
};
__name(_ImageBannerView, "ImageBannerView");
__publicField(_ImageBannerView, "type", "ImageBannerView");
var ImageBannerView = _ImageBannerView;

// dist/src/parser/classes/IncludingResultsFor.js
var _IncludingResultsFor = class _IncludingResultsFor extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "including_results_for");
    __publicField(this, "corrected_query");
    __publicField(this, "corrected_query_endpoint");
    __publicField(this, "search_only_for");
    __publicField(this, "original_query");
    __publicField(this, "original_query_endpoint");
    this.including_results_for = new Text2(data2.includingResultsFor);
    this.corrected_query = new Text2(data2.correctedQuery);
    this.corrected_query_endpoint = new NavigationEndpoint(data2.correctedQueryEndpoint);
    this.search_only_for = Reflect.has(data2, "searchOnlyFor") ? new Text2(data2.searchOnlyFor) : void 0;
    this.original_query = Reflect.has(data2, "originalQuery") ? new Text2(data2.originalQuery) : void 0;
    this.original_query_endpoint = Reflect.has(data2, "originalQueryEndpoint") ? new NavigationEndpoint(data2.originalQueryEndpoint) : void 0;
  }
};
__name(_IncludingResultsFor, "IncludingResultsFor");
__publicField(_IncludingResultsFor, "type", "IncludingResultsFor");
var IncludingResultsFor = _IncludingResultsFor;

// dist/src/parser/classes/InfoPanelContent.js
var _InfoPanelContent = class _InfoPanelContent extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "source");
    __publicField(this, "paragraphs");
    __publicField(this, "attributed_paragraphs");
    __publicField(this, "thumbnail");
    __publicField(this, "source_endpoint");
    __publicField(this, "truncate_paragraphs");
    __publicField(this, "background");
    __publicField(this, "inline_link_icon_type");
    this.title = new Text2(data2.title);
    this.source = new Text2(data2.source);
    if (Reflect.has(data2, "paragraphs"))
      this.paragraphs = data2.paragraphs.map((p) => new Text2(p));
    if (Reflect.has(data2, "attributedParagraphs"))
      this.attributed_paragraphs = data2.attributedParagraphs.map((p) => Text2.fromAttributed(p));
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.source_endpoint = new NavigationEndpoint(data2.sourceEndpoint);
    this.truncate_paragraphs = !!data2.truncateParagraphs;
    this.background = data2.background;
    if (Reflect.has(data2, "inlineLinkIcon") && Reflect.has(data2.inlineLinkIcon, "iconType")) {
      this.inline_link_icon_type = data2.inlineLinkIcon.iconType;
    }
  }
};
__name(_InfoPanelContent, "InfoPanelContent");
__publicField(_InfoPanelContent, "type", "InfoPanelContent");
var InfoPanelContent = _InfoPanelContent;

// dist/src/parser/classes/InfoPanelContainer.js
var _InfoPanelContainer = class _InfoPanelContainer extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "menu");
    __publicField(this, "content");
    __publicField(this, "header_endpoint");
    __publicField(this, "background");
    __publicField(this, "title_style");
    __publicField(this, "icon_type");
    this.title = new Text2(data2.title);
    this.menu = parser_exports.parseItem(data2.menu, Menu);
    this.content = parser_exports.parseItem(data2.content, InfoPanelContent);
    if (data2.headerEndpoint)
      this.header_endpoint = new NavigationEndpoint(data2.headerEndpoint);
    this.background = data2.background;
    this.title_style = data2.titleStyle;
    if (Reflect.has(data2, "icon")) {
      this.icon_type = data2.icon?.iconType;
    }
  }
};
__name(_InfoPanelContainer, "InfoPanelContainer");
__publicField(_InfoPanelContainer, "type", "InfoPanelContainer");
var InfoPanelContainer = _InfoPanelContainer;

// dist/src/parser/classes/InteractiveTabbedHeader.js
var _InteractiveTabbedHeader = class _InteractiveTabbedHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header_type");
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "metadata");
    __publicField(this, "badges");
    __publicField(this, "box_art");
    __publicField(this, "banner");
    __publicField(this, "buttons");
    __publicField(this, "auto_generated");
    this.header_type = data2.type;
    this.title = new Text2(data2.title);
    this.description = new Text2(data2.description);
    this.metadata = new Text2(data2.metadata);
    this.badges = parser_exports.parseArray(data2.badges, MetadataBadge);
    this.box_art = Thumbnail.fromResponse(data2.boxArt);
    this.banner = Thumbnail.fromResponse(data2.banner);
    this.buttons = parser_exports.parseArray(data2.buttons, [SubscribeButton, Button]);
    this.auto_generated = new Text2(data2.autoGenerated);
  }
};
__name(_InteractiveTabbedHeader, "InteractiveTabbedHeader");
__publicField(_InteractiveTabbedHeader, "type", "InteractiveTabbedHeader");
var InteractiveTabbedHeader = _InteractiveTabbedHeader;

// dist/src/parser/classes/ItemSectionHeader.js
var _ItemSectionHeader = class _ItemSectionHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data2.title);
  }
};
__name(_ItemSectionHeader, "ItemSectionHeader");
__publicField(_ItemSectionHeader, "type", "ItemSectionHeader");
var ItemSectionHeader = _ItemSectionHeader;

// dist/src/parser/classes/ItemSectionTab.js
var _ItemSectionTab = class _ItemSectionTab extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "selected");
    __publicField(this, "endpoint");
    this.title = new Text2(data2.title);
    this.selected = !!data2.selected;
    this.endpoint = new NavigationEndpoint(data2.endpoint);
  }
};
__name(_ItemSectionTab, "ItemSectionTab");
__publicField(_ItemSectionTab, "type", "Tab");
var ItemSectionTab = _ItemSectionTab;

// dist/src/parser/classes/ItemSectionTabbedHeader.js
var _ItemSectionTabbedHeader = class _ItemSectionTabbedHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "tabs");
    __publicField(this, "end_items");
    this.title = new Text2(data2.title);
    this.tabs = parser_exports.parseArray(data2.tabs, ItemSectionTab);
    if (Reflect.has(data2, "endItems")) {
      this.end_items = parser_exports.parseArray(data2.endItems);
    }
  }
};
__name(_ItemSectionTabbedHeader, "ItemSectionTabbedHeader");
__publicField(_ItemSectionTabbedHeader, "type", "ItemSectionTabbedHeader");
var ItemSectionTabbedHeader = _ItemSectionTabbedHeader;

// dist/src/parser/classes/SortFilterHeader.js
var _SortFilterHeader = class _SortFilterHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "filter_menu");
    this.filter_menu = parser_exports.parseItem(data2.filterMenu, nodes_exports2.SortFilterSubMenu);
  }
};
__name(_SortFilterHeader, "SortFilterHeader");
__publicField(_SortFilterHeader, "type", "SortFilterHeader");
var SortFilterHeader = _SortFilterHeader;

// dist/src/parser/classes/ItemSection.js
var _ItemSection = class _ItemSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "contents");
    __publicField(this, "target_id");
    __publicField(this, "continuation");
    this.header = parser_exports.parseItem(data2.header, [CommentsHeader, ItemSectionHeader, ItemSectionTabbedHeader, SortFilterHeader, FeedFilterChipBar]);
    this.contents = parser_exports.parseArray(data2.contents);
    if (data2.targetId || data2.sectionIdentifier) {
      this.target_id = data2.targetId || data2.sectionIdentifier;
    }
    if (data2.continuations) {
      this.continuation = data2.continuations?.at(0)?.nextContinuationData?.continuation;
    }
  }
};
__name(_ItemSection, "ItemSection");
__publicField(_ItemSection, "type", "ItemSection");
var ItemSection = _ItemSection;

// dist/src/parser/classes/LiveChat.js
var _LiveChat = class _LiveChat extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "initial_display_state");
    __publicField(this, "continuation");
    __publicField(this, "client_messages");
    __publicField(this, "is_replay");
    this.header = parser_exports.parseItem(data2.header);
    this.initial_display_state = data2.initialDisplayState;
    this.continuation = data2.continuations[0]?.reloadContinuationData?.continuation;
    this.client_messages = {
      reconnect_message: new Text2(data2.clientMessages.reconnectMessage),
      unable_to_reconnect_message: new Text2(data2.clientMessages.unableToReconnectMessage),
      fatal_error: new Text2(data2.clientMessages.fatalError),
      reconnected_message: new Text2(data2.clientMessages.reconnectedMessage),
      generic_error: new Text2(data2.clientMessages.genericError)
    };
    this.is_replay = !!data2.isReplay;
  }
};
__name(_LiveChat, "LiveChat");
__publicField(_LiveChat, "type", "LiveChat");
var LiveChat = _LiveChat;

// dist/src/parser/classes/livechat/items/LiveChatBannerHeader.js
var _LiveChatBannerHeader = class _LiveChatBannerHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "icon_type");
    __publicField(this, "context_menu_button");
    this.text = new Text2(data2.text);
    if (Reflect.has(data2, "icon") && Reflect.has(data2.icon, "iconType")) {
      this.icon_type = data2.icon.iconType;
    }
    this.context_menu_button = parser_exports.parseItem(data2.contextMenuButton, Button);
  }
};
__name(_LiveChatBannerHeader, "LiveChatBannerHeader");
__publicField(_LiveChatBannerHeader, "type", "LiveChatBannerHeader");
var LiveChatBannerHeader = _LiveChatBannerHeader;

// dist/src/parser/classes/livechat/items/LiveChatBanner.js
var _LiveChatBanner = class _LiveChatBanner extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "contents");
    __publicField(this, "action_id");
    __publicField(this, "viewer_is_creator");
    __publicField(this, "target_id");
    __publicField(this, "is_stackable");
    __publicField(this, "background_type");
    __publicField(this, "banner_type");
    __publicField(this, "banner_properties_is_ephemeral");
    __publicField(this, "banner_properties_auto_collapse_delay_seconds");
    this.header = parser_exports.parseItem(data2.header, LiveChatBannerHeader);
    this.contents = parser_exports.parseItem(data2.contents);
    this.action_id = data2.actionId;
    if (Reflect.has(data2, "viewerIsCreator")) {
      this.viewer_is_creator = data2.viewerIsCreator;
    }
    this.target_id = data2.targetId;
    this.is_stackable = data2.isStackable;
    if (Reflect.has(data2, "backgroundType")) {
      this.background_type = data2.backgroundType;
    }
    this.banner_type = data2.bannerType;
    if (Reflect.has(data2, "bannerProperties") && Reflect.has(data2.bannerProperties, "isEphemeral")) {
      this.banner_properties_is_ephemeral = Boolean(data2.bannerProperties.isEphemeral);
    }
    if (Reflect.has(data2, "bannerProperties") && Reflect.has(data2.bannerProperties, "autoCollapseDelay") && Reflect.has(data2.bannerProperties.autoCollapseDelay, "seconds")) {
      this.banner_properties_auto_collapse_delay_seconds = data2.bannerProperties.autoCollapseDelay.seconds;
    }
  }
};
__name(_LiveChatBanner, "LiveChatBanner");
__publicField(_LiveChatBanner, "type", "LiveChatBanner");
var LiveChatBanner = _LiveChatBanner;

// dist/src/parser/classes/livechat/AddBannerToLiveChatCommand.js
var _AddBannerToLiveChatCommand = class _AddBannerToLiveChatCommand extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "banner");
    this.banner = parser_exports.parseItem(data2.bannerRenderer, LiveChatBanner);
  }
};
__name(_AddBannerToLiveChatCommand, "AddBannerToLiveChatCommand");
__publicField(_AddBannerToLiveChatCommand, "type", "AddBannerToLiveChatCommand");
var AddBannerToLiveChatCommand = _AddBannerToLiveChatCommand;

// dist/src/parser/classes/livechat/AddChatItemAction.js
var _AddChatItemAction = class _AddChatItemAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "item");
    __publicField(this, "client_id");
    this.item = parser_exports.parseItem(data2.item);
    if (Reflect.has(data2, "clientId")) {
      this.client_id = data2.clientId;
    }
  }
};
__name(_AddChatItemAction, "AddChatItemAction");
__publicField(_AddChatItemAction, "type", "AddChatItemAction");
var AddChatItemAction = _AddChatItemAction;

// dist/src/parser/classes/livechat/AddLiveChatTickerItemAction.js
var _AddLiveChatTickerItemAction = class _AddLiveChatTickerItemAction extends YTNode {
  // TODO: check this assumption.
  constructor(data2) {
    super();
    __publicField(this, "item");
    __publicField(this, "duration_sec");
    this.item = parser_exports.parseItem(data2.item);
    this.duration_sec = data2.durationSec;
  }
};
__name(_AddLiveChatTickerItemAction, "AddLiveChatTickerItemAction");
__publicField(_AddLiveChatTickerItemAction, "type", "AddLiveChatTickerItemAction");
var AddLiveChatTickerItemAction = _AddLiveChatTickerItemAction;

// dist/src/parser/classes/livechat/DimChatItemAction.js
var _DimChatItemAction = class _DimChatItemAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "client_assigned_id");
    this.client_assigned_id = data2.clientAssignedId;
  }
};
__name(_DimChatItemAction, "DimChatItemAction");
__publicField(_DimChatItemAction, "type", "DimChatItemAction");
var DimChatItemAction = _DimChatItemAction;

// dist/src/parser/classes/livechat/items/BumperUserEduContentView.js
var _BumperUserEduContentView = class _BumperUserEduContentView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "image_name");
    __publicField(this, "image_color");
    this.text = Text2.fromAttributed(data2.text);
    this.image_name = data2.image.sources[0].clientResource.imageName;
    this.image_color = data2.image.sources[0].clientResource.imageColor;
  }
};
__name(_BumperUserEduContentView, "BumperUserEduContentView");
__publicField(_BumperUserEduContentView, "type", "BumperUserEduContentView");
var BumperUserEduContentView = _BumperUserEduContentView;

// dist/src/parser/classes/livechat/items/CreatorHeartView.js
var _CreatorHeartView = class _CreatorHeartView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "creator_thumbnail");
    __publicField(this, "hearted_icon_name");
    __publicField(this, "unhearted_icon_name");
    __publicField(this, "unhearted_icon_processor");
    __publicField(this, "hearted_hover_text");
    __publicField(this, "hearted_accessibility_label");
    __publicField(this, "unhearted_accessibility_label");
    __publicField(this, "engagement_state_key");
    this.creator_thumbnail = Thumbnail.fromResponse(data2.creatorThumbnail);
    this.hearted_icon_name = data2.heartedIcon.sources[0].clientResource.imageName;
    this.unhearted_icon_name = data2.unheartedIcon.sources[0].clientResource.imageName;
    this.unhearted_icon_processor = {
      border_image_processor: {
        image_tint: {
          color: data2.unheartedIcon.processor.borderImageProcessor.imageTint.color
        }
      }
    };
    this.hearted_hover_text = data2.heartedHoverText;
    this.hearted_accessibility_label = data2.heartedAccessibilityLabel;
    this.unhearted_accessibility_label = data2.unheartedAccessibilityLabel;
    this.engagement_state_key = data2.engagementStateKey;
  }
};
__name(_CreatorHeartView, "CreatorHeartView");
__publicField(_CreatorHeartView, "type", "CreatorHeartView");
var CreatorHeartView = _CreatorHeartView;

// dist/src/parser/classes/livechat/items/LiveChatAutoModMessage.js
var _LiveChatAutoModMessage = class _LiveChatAutoModMessage extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "menu_endpoint");
    __publicField(this, "moderation_buttons");
    __publicField(this, "auto_moderated_item");
    __publicField(this, "header_text");
    __publicField(this, "timestamp");
    __publicField(this, "id");
    this.menu_endpoint = new NavigationEndpoint(data2.contextMenuEndpoint);
    this.moderation_buttons = parser_exports.parseArray(data2.moderationButtons, Button);
    this.auto_moderated_item = parser_exports.parseItem(data2.autoModeratedItem);
    this.header_text = new Text2(data2.headerText);
    this.timestamp = Math.floor(parseInt(data2.timestampUsec) / 1e3);
    this.id = data2.id;
  }
};
__name(_LiveChatAutoModMessage, "LiveChatAutoModMessage");
__publicField(_LiveChatAutoModMessage, "type", "LiveChatAutoModMessage");
var LiveChatAutoModMessage = _LiveChatAutoModMessage;

// dist/src/parser/classes/livechat/items/LiveChatBannerChatSummary.js
var _LiveChatBannerChatSummary = class _LiveChatBannerChatSummary extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "chat_summary");
    __publicField(this, "icon_type");
    __publicField(this, "like_feedback_button");
    __publicField(this, "dislike_feedback_button");
    this.id = data2.liveChatSummaryId;
    this.chat_summary = new Text2(data2.chatSummary);
    this.icon_type = data2.icon.iconType;
    this.like_feedback_button = parser_exports.parseItem(data2.likeFeedbackButton, ToggleButtonView);
    this.dislike_feedback_button = parser_exports.parseItem(data2.dislikeFeedbackButton, ToggleButtonView);
  }
};
__name(_LiveChatBannerChatSummary, "LiveChatBannerChatSummary");
__publicField(_LiveChatBannerChatSummary, "type", "LiveChatBannerChatSummary");
var LiveChatBannerChatSummary = _LiveChatBannerChatSummary;

// dist/src/parser/classes/livechat/items/LiveChatBannerPoll.js
var _LiveChatBannerPoll = class _LiveChatBannerPoll extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "poll_question");
    __publicField(this, "author_photo");
    __publicField(this, "choices");
    __publicField(this, "collapsed_state_entity_key");
    __publicField(this, "live_chat_poll_state_entity_key");
    __publicField(this, "context_menu_button");
    this.poll_question = new Text2(data2.pollQuestion);
    this.author_photo = Thumbnail.fromResponse(data2.authorPhoto);
    this.choices = data2.pollChoices.map((choice) => ({
      option_id: choice.pollOptionId,
      text: new Text2(choice.text).toString()
      // XXX: This toString should probably not be used here.
    }));
    this.collapsed_state_entity_key = data2.collapsedStateEntityKey;
    this.live_chat_poll_state_entity_key = data2.liveChatPollStateEntityKey;
    this.context_menu_button = parser_exports.parseItem(data2.contextMenuButton, Button);
  }
};
__name(_LiveChatBannerPoll, "LiveChatBannerPoll");
__publicField(_LiveChatBannerPoll, "type", "LiveChatBannerPoll");
var LiveChatBannerPoll = _LiveChatBannerPoll;

// dist/src/parser/classes/livechat/items/LiveChatBannerRedirect.js
var _LiveChatBannerRedirect = class _LiveChatBannerRedirect extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "banner_message");
    __publicField(this, "author_photo");
    __publicField(this, "inline_action_button");
    __publicField(this, "context_menu_button");
    this.banner_message = new Text2(data2.bannerMessage);
    this.author_photo = Thumbnail.fromResponse(data2.authorPhoto);
    this.inline_action_button = parser_exports.parseItem(data2.inlineActionButton, Button);
    this.context_menu_button = parser_exports.parseItem(data2.contextMenuButton, Button);
  }
};
__name(_LiveChatBannerRedirect, "LiveChatBannerRedirect");
__publicField(_LiveChatBannerRedirect, "type", "LiveChatBannerRedirect");
var LiveChatBannerRedirect = _LiveChatBannerRedirect;

// dist/src/parser/classes/livechat/items/LiveChatItemBumperView.js
var _LiveChatItemBumperView = class _LiveChatItemBumperView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "content");
    this.content = parser_exports.parseItem(data2.content, BumperUserEduContentView);
  }
};
__name(_LiveChatItemBumperView, "LiveChatItemBumperView");
__publicField(_LiveChatItemBumperView, "type", "LiveChatItemBumperView");
var LiveChatItemBumperView = _LiveChatItemBumperView;

// dist/src/parser/classes/livechat/items/LiveChatMembershipItem.js
var _LiveChatMembershipItem = class _LiveChatMembershipItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "timestamp");
    __publicField(this, "timestamp_usec");
    __publicField(this, "timestamp_text");
    __publicField(this, "header_primary_text");
    __publicField(this, "header_subtext");
    __publicField(this, "message");
    __publicField(this, "author");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu_accessibility_label");
    this.id = data2.id;
    this.timestamp = Math.floor(parseInt(data2.timestampUsec) / 1e3);
    this.timestamp_usec = data2.timestampUsec;
    if (Reflect.has(data2, "timestampText")) {
      this.timestamp_text = new Text2(data2.timestampText);
    }
    if (Reflect.has(data2, "headerPrimaryText")) {
      this.header_primary_text = new Text2(data2.headerPrimaryText);
    }
    this.header_subtext = new Text2(data2.headerSubtext);
    if (Reflect.has(data2, "message")) {
      this.message = new Text2(data2.message);
    }
    this.author = new Author(data2.authorName, data2.authorBadges, data2.authorPhoto, data2.authorExternalChannelId);
    this.menu_endpoint = new NavigationEndpoint(data2.contextMenuEndpoint);
    this.context_menu_accessibility_label = data2.contextMenuAccessibility.accessibilityData.label;
  }
};
__name(_LiveChatMembershipItem, "LiveChatMembershipItem");
__publicField(_LiveChatMembershipItem, "type", "LiveChatMembershipItem");
var LiveChatMembershipItem = _LiveChatMembershipItem;

// dist/src/parser/classes/livechat/items/LiveChatModeChangeMessage.js
var _LiveChatModeChangeMessage = class _LiveChatModeChangeMessage extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "icon_type");
    __publicField(this, "text");
    __publicField(this, "subtext");
    __publicField(this, "timestamp");
    __publicField(this, "timestamp_usec");
    __publicField(this, "timestamp_text");
    this.id = data2.id;
    this.icon_type = data2.icon.iconType;
    this.text = new Text2(data2.text);
    this.subtext = new Text2(data2.subtext);
    this.timestamp = Math.floor(parseInt(data2.timestampUsec) / 1e3);
    this.timestamp_usec = data2.timestampUsec;
    this.timestamp_text = new Text2(data2.timestampText);
  }
};
__name(_LiveChatModeChangeMessage, "LiveChatModeChangeMessage");
__publicField(_LiveChatModeChangeMessage, "type", "LiveChatModeChangeMessage");
var LiveChatModeChangeMessage = _LiveChatModeChangeMessage;

// dist/src/parser/classes/livechat/items/PdgReplyButtonView.js
var _PdgReplyButtonView = class _PdgReplyButtonView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "reply_button");
    __publicField(this, "reply_count_entity_key");
    __publicField(this, "reply_count_placeholder");
    this.reply_button = parser_exports.parseItem(data2.replyButton, ButtonView);
    this.reply_count_entity_key = data2.replyCountEntityKey;
    this.reply_count_placeholder = Text2.fromAttributed(data2.replyCountPlaceholder);
  }
};
__name(_PdgReplyButtonView, "PdgReplyButtonView");
__publicField(_PdgReplyButtonView, "type", "PdgReplyButtonView");
var PdgReplyButtonView = _PdgReplyButtonView;

// dist/src/parser/classes/livechat/items/LiveChatPaidMessage.js
var _LiveChatPaidMessage = class _LiveChatPaidMessage extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "message");
    __publicField(this, "author");
    __publicField(this, "author_name_text_color");
    __publicField(this, "header_background_color");
    __publicField(this, "header_text_color");
    __publicField(this, "body_background_color");
    __publicField(this, "body_text_color");
    __publicField(this, "purchase_amount");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu_accessibility_label");
    __publicField(this, "timestamp");
    __publicField(this, "timestamp_usec");
    __publicField(this, "timestamp_text");
    __publicField(this, "timestamp_color");
    __publicField(this, "header_overlay_image");
    __publicField(this, "text_input_background_color");
    __publicField(this, "lower_bumper");
    __publicField(this, "creator_heart_button");
    __publicField(this, "is_v2_style");
    __publicField(this, "reply_button");
    this.id = data2.id;
    this.message = new Text2(data2.message);
    this.author = new Author(data2.authorName, data2.authorBadges, data2.authorPhoto, data2.authorExternalChannelId);
    this.author_name_text_color = data2.authorNameTextColor;
    this.header_background_color = data2.headerBackgroundColor;
    this.header_text_color = data2.headerTextColor;
    this.body_background_color = data2.bodyBackgroundColor;
    this.body_text_color = data2.bodyTextColor;
    this.purchase_amount = new Text2(data2.purchaseAmountText).toString();
    this.menu_endpoint = new NavigationEndpoint(data2.contextMenuEndpoint);
    this.context_menu_accessibility_label = data2.contextMenuAccessibility.accessibilityData.label;
    this.timestamp = Math.floor(parseInt(data2.timestampUsec) / 1e3);
    this.timestamp_usec = data2.timestampUsec;
    if (Reflect.has(data2, "timestampText")) {
      this.timestamp_text = new Text2(data2.timestampText).toString();
    }
    this.timestamp_color = data2.timestampColor;
    if (Reflect.has(data2, "headerOverlayImage")) {
      this.header_overlay_image = Thumbnail.fromResponse(data2.headerOverlayImage);
    }
    this.text_input_background_color = data2.textInputBackgroundColor;
    this.lower_bumper = parser_exports.parseItem(data2.lowerBumper, LiveChatItemBumperView);
    this.creator_heart_button = parser_exports.parseItem(data2.creatorHeartButton, CreatorHeartView);
    this.is_v2_style = data2.isV2Style;
    this.reply_button = parser_exports.parseItem(data2.replyButton, PdgReplyButtonView);
  }
};
__name(_LiveChatPaidMessage, "LiveChatPaidMessage");
__publicField(_LiveChatPaidMessage, "type", "LiveChatPaidMessage");
var LiveChatPaidMessage = _LiveChatPaidMessage;

// dist/src/parser/classes/livechat/items/LiveChatPaidSticker.js
var _LiveChatPaidSticker = class _LiveChatPaidSticker extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "author");
    __publicField(this, "money_chip_background_color");
    __publicField(this, "money_chip_text_color");
    __publicField(this, "background_color");
    __publicField(this, "author_name_text_color");
    __publicField(this, "sticker");
    __publicField(this, "sticker_accessibility_label");
    __publicField(this, "sticker_display_width");
    __publicField(this, "sticker_display_height");
    __publicField(this, "purchase_amount");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu");
    __publicField(this, "context_menu_accessibility_label");
    __publicField(this, "timestamp");
    __publicField(this, "timestamp_usec");
    __publicField(this, "is_v2_style");
    this.id = data2.id;
    this.author = new Author(data2.authorName, data2.authorBadges, data2.authorPhoto, data2.authorExternalChannelId);
    this.money_chip_background_color = data2.moneyChipBackgroundColor;
    this.money_chip_text_color = data2.moneyChipTextColor;
    this.background_color = data2.backgroundColor;
    this.author_name_text_color = data2.authorNameTextColor;
    this.sticker = Thumbnail.fromResponse(data2.sticker);
    this.sticker_accessibility_label = data2.sticker.accessibility.accessibilityData.label;
    this.sticker_display_width = data2.stickerDisplayWidth;
    this.sticker_display_height = data2.stickerDisplayHeight;
    this.purchase_amount = new Text2(data2.purchaseAmountText).toString();
    this.menu_endpoint = new NavigationEndpoint(data2.contextMenuEndpoint);
    this.context_menu = this.menu_endpoint;
    this.context_menu_accessibility_label = data2.contextMenuAccessibility.accessibilityData.label;
    this.timestamp = Math.floor(parseInt(data2.timestampUsec) / 1e3);
    this.timestamp_usec = data2.timestampUsec;
    this.is_v2_style = data2.isV2Style;
  }
};
__name(_LiveChatPaidSticker, "LiveChatPaidSticker");
__publicField(_LiveChatPaidSticker, "type", "LiveChatPaidSticker");
var LiveChatPaidSticker = _LiveChatPaidSticker;

// dist/src/parser/classes/livechat/items/LiveChatPlaceholderItem.js
var _LiveChatPlaceholderItem = class _LiveChatPlaceholderItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "timestamp");
    this.id = data2.id;
    this.timestamp = Math.floor(parseInt(data2.timestampUsec) / 1e3);
  }
};
__name(_LiveChatPlaceholderItem, "LiveChatPlaceholderItem");
__publicField(_LiveChatPlaceholderItem, "type", "LiveChatPlaceholderItem");
var LiveChatPlaceholderItem = _LiveChatPlaceholderItem;

// dist/src/parser/classes/livechat/items/LiveChatProductItem.js
var _LiveChatProductItem = class _LiveChatProductItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "accessibility_title");
    __publicField(this, "thumbnail");
    __publicField(this, "price");
    __publicField(this, "vendor_name");
    __publicField(this, "from_vendor_text");
    __publicField(this, "information_button");
    __publicField(this, "endpoint");
    __publicField(this, "creator_message");
    __publicField(this, "creator_name");
    __publicField(this, "author_photo");
    __publicField(this, "information_dialog");
    __publicField(this, "is_verified");
    __publicField(this, "creator_custom_message");
    this.title = data2.title;
    this.accessibility_title = data2.accessibilityTitle;
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.price = data2.price;
    this.vendor_name = data2.vendorName;
    this.from_vendor_text = data2.fromVendorText;
    this.information_button = parser_exports.parseItem(data2.informationButton);
    this.endpoint = new NavigationEndpoint(data2.onClickCommand);
    this.creator_message = data2.creatorMessage;
    this.creator_name = data2.creatorName;
    this.author_photo = Thumbnail.fromResponse(data2.authorPhoto);
    this.information_dialog = parser_exports.parseItem(data2.informationDialog);
    this.is_verified = data2.isVerified;
    this.creator_custom_message = new Text2(data2.creatorCustomMessage);
  }
};
__name(_LiveChatProductItem, "LiveChatProductItem");
__publicField(_LiveChatProductItem, "type", "LiveChatProductItem");
var LiveChatProductItem = _LiveChatProductItem;

// dist/src/parser/classes/livechat/items/LiveChatRestrictedParticipation.js
var _LiveChatRestrictedParticipation = class _LiveChatRestrictedParticipation extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "message");
    __publicField(this, "icon_type");
    this.message = new Text2(data2.message);
    if (Reflect.has(data2, "icon") && Reflect.has(data2.icon, "iconType")) {
      this.icon_type = data2.icon.iconType;
    }
  }
};
__name(_LiveChatRestrictedParticipation, "LiveChatRestrictedParticipation");
__publicField(_LiveChatRestrictedParticipation, "type", "LiveChatRestrictedParticipation");
var LiveChatRestrictedParticipation = _LiveChatRestrictedParticipation;

// dist/src/parser/classes/LiveChatAuthorBadge.js
var _LiveChatAuthorBadge = class _LiveChatAuthorBadge extends MetadataBadge {
  constructor(data2) {
    super(data2);
    __publicField(this, "custom_thumbnail");
    this.custom_thumbnail = Thumbnail.fromResponse(data2.customThumbnail);
  }
};
__name(_LiveChatAuthorBadge, "LiveChatAuthorBadge");
__publicField(_LiveChatAuthorBadge, "type", "LiveChatAuthorBadge");
var LiveChatAuthorBadge = _LiveChatAuthorBadge;

// dist/src/parser/classes/livechat/items/LiveChatSponsorshipsHeader.js
var _LiveChatSponsorshipsHeader = class _LiveChatSponsorshipsHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "author_name");
    __publicField(this, "author_photo");
    __publicField(this, "author_badges");
    __publicField(this, "primary_text");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu_accessibility_label");
    __publicField(this, "image");
    this.author_name = new Text2(data2.authorName);
    this.author_photo = Thumbnail.fromResponse(data2.authorPhoto);
    this.author_badges = parser_exports.parseArray(data2.authorBadges, LiveChatAuthorBadge);
    this.primary_text = new Text2(data2.primaryText);
    this.menu_endpoint = new NavigationEndpoint(data2.contextMenuEndpoint);
    this.context_menu_accessibility_label = data2.contextMenuAccessibility.accessibilityData.label;
    this.image = Thumbnail.fromResponse(data2.image);
  }
};
__name(_LiveChatSponsorshipsHeader, "LiveChatSponsorshipsHeader");
__publicField(_LiveChatSponsorshipsHeader, "type", "LiveChatSponsorshipsHeader");
var LiveChatSponsorshipsHeader = _LiveChatSponsorshipsHeader;

// dist/src/parser/classes/livechat/items/LiveChatSponsorshipsGiftPurchaseAnnouncement.js
var _LiveChatSponsorshipsGiftPurchaseAnnouncement = class _LiveChatSponsorshipsGiftPurchaseAnnouncement extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "timestamp_usec");
    __publicField(this, "author_external_channel_id");
    __publicField(this, "header");
    this.id = data2.id;
    this.timestamp_usec = data2.timestampUsec;
    this.author_external_channel_id = data2.authorExternalChannelId;
    this.header = parser_exports.parseItem(data2.header, LiveChatSponsorshipsHeader);
  }
};
__name(_LiveChatSponsorshipsGiftPurchaseAnnouncement, "LiveChatSponsorshipsGiftPurchaseAnnouncement");
__publicField(_LiveChatSponsorshipsGiftPurchaseAnnouncement, "type", "LiveChatSponsorshipsGiftPurchaseAnnouncement");
var LiveChatSponsorshipsGiftPurchaseAnnouncement = _LiveChatSponsorshipsGiftPurchaseAnnouncement;

// dist/src/parser/classes/livechat/items/LiveChatSponsorshipsGiftRedemptionAnnouncement.js
var _LiveChatSponsorshipsGiftRedemptionAnnouncement = class _LiveChatSponsorshipsGiftRedemptionAnnouncement extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "timestamp_usec");
    __publicField(this, "timestamp_text");
    __publicField(this, "author");
    __publicField(this, "message");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu_accessibility_label");
    this.id = data2.id;
    this.timestamp_usec = data2.timestampUsec;
    this.timestamp_text = new Text2(data2.timestampText);
    this.author = new Author(data2.authorName, data2.authorBadges, data2.authorPhoto, data2.authorExternalChannelId);
    this.message = new Text2(data2.message);
    this.menu_endpoint = new NavigationEndpoint(data2.contextMenuEndpoint);
    this.context_menu_accessibility_label = data2.contextMenuAccessibility.accessibilityData.label;
  }
};
__name(_LiveChatSponsorshipsGiftRedemptionAnnouncement, "LiveChatSponsorshipsGiftRedemptionAnnouncement");
__publicField(_LiveChatSponsorshipsGiftRedemptionAnnouncement, "type", "LiveChatSponsorshipsGiftRedemptionAnnouncement");
var LiveChatSponsorshipsGiftRedemptionAnnouncement = _LiveChatSponsorshipsGiftRedemptionAnnouncement;

// dist/src/parser/classes/livechat/items/LiveChatTextMessage.js
var _LiveChatTextMessage = class _LiveChatTextMessage extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "message");
    __publicField(this, "inline_action_buttons");
    __publicField(this, "timestamp");
    __publicField(this, "timestamp_usec");
    __publicField(this, "timestamp_text");
    __publicField(this, "author");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu_accessibility_label");
    __publicField(this, "before_content_buttons");
    this.id = data2.id;
    this.message = new Text2(data2.message);
    this.inline_action_buttons = parser_exports.parseArray(data2.inlineActionButtons, Button);
    this.timestamp = Math.floor(parseInt(data2.timestampUsec) / 1e3);
    this.timestamp_usec = data2.timestampUsec;
    if (Reflect.has(data2, "timestampText")) {
      this.timestamp_text = new Text2(data2.timestampText).toString();
    }
    this.author = new Author(data2.authorName, data2.authorBadges, data2.authorPhoto, data2.authorExternalChannelId);
    if (Reflect.has(data2, "contextMenuEndpoint")) {
      this.menu_endpoint = new NavigationEndpoint(data2.contextMenuEndpoint);
    }
    if (Reflect.has(data2, "contextMenuAccessibility") && Reflect.has(data2.contextMenuAccessibility, "accessibilityData") && Reflect.has(data2.contextMenuAccessibility.accessibilityData, "label")) {
      this.context_menu_accessibility_label = data2.contextMenuAccessibility.accessibilityData.label;
    }
    this.before_content_buttons = parser_exports.parseArray(data2.beforeContentButtons, ButtonView);
  }
};
__name(_LiveChatTextMessage, "LiveChatTextMessage");
__publicField(_LiveChatTextMessage, "type", "LiveChatTextMessage");
var LiveChatTextMessage = _LiveChatTextMessage;

// dist/src/parser/classes/livechat/items/LiveChatTickerPaidMessageItem.js
var _LiveChatTickerPaidMessageItem = class _LiveChatTickerPaidMessageItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "author");
    __publicField(this, "amount");
    __publicField(this, "amount_text_color");
    __publicField(this, "start_background_color");
    __publicField(this, "end_background_color");
    __publicField(this, "duration_sec");
    __publicField(this, "full_duration_sec");
    __publicField(this, "show_item");
    __publicField(this, "show_item_endpoint");
    __publicField(this, "animation_origin");
    __publicField(this, "open_engagement_panel_command");
    this.id = data2.id;
    this.author = new Author(data2.authorName || data2.authorUsername, data2.authorBadges, data2.authorPhoto, data2.authorExternalChannelId);
    if (Reflect.has(data2, "amount")) {
      this.amount = new Text2(data2.amount);
    }
    this.amount_text_color = data2.amountTextColor;
    this.start_background_color = data2.startBackgroundColor;
    this.end_background_color = data2.endBackgroundColor;
    this.duration_sec = data2.durationSec;
    this.full_duration_sec = data2.fullDurationSec;
    this.show_item = parser_exports.parseItem(data2.showItemEndpoint?.showLiveChatItemEndpoint?.renderer);
    this.show_item_endpoint = new NavigationEndpoint(data2.showItemEndpoint);
    this.animation_origin = data2.animationOrigin;
    this.open_engagement_panel_command = new NavigationEndpoint(data2.openEngagementPanelCommand);
  }
};
__name(_LiveChatTickerPaidMessageItem, "LiveChatTickerPaidMessageItem");
__publicField(_LiveChatTickerPaidMessageItem, "type", "LiveChatTickerPaidMessageItem");
var LiveChatTickerPaidMessageItem = _LiveChatTickerPaidMessageItem;

// dist/src/parser/classes/livechat/items/LiveChatTickerPaidStickerItem.js
var _LiveChatTickerPaidStickerItem = class _LiveChatTickerPaidStickerItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "author_external_channel_id");
    __publicField(this, "author_photo");
    __publicField(this, "start_background_color");
    __publicField(this, "end_background_color");
    __publicField(this, "duration_sec");
    __publicField(this, "full_duration_sec");
    __publicField(this, "show_item");
    __publicField(this, "show_item_endpoint");
    __publicField(this, "ticker_thumbnails");
    this.id = data2.id;
    this.author_external_channel_id = data2.authorExternalChannelId;
    this.author_photo = Thumbnail.fromResponse(data2.authorPhoto);
    this.start_background_color = data2.startBackgroundColor;
    this.end_background_color = data2.endBackgroundColor;
    this.duration_sec = data2.durationSec;
    this.full_duration_sec = data2.fullDurationSec;
    this.show_item = parser_exports.parseItem(data2.showItemEndpoint?.showLiveChatItemEndpoint?.renderer);
    this.show_item_endpoint = new NavigationEndpoint(data2.showItemEndpoint);
    this.ticker_thumbnails = data2.tickerThumbnails.map((item) => ({
      thumbnails: Thumbnail.fromResponse(item),
      label: item?.accessibility?.accessibilityData?.label
    }));
  }
};
__name(_LiveChatTickerPaidStickerItem, "LiveChatTickerPaidStickerItem");
__publicField(_LiveChatTickerPaidStickerItem, "type", "LiveChatTickerPaidStickerItem");
var LiveChatTickerPaidStickerItem = _LiveChatTickerPaidStickerItem;

// dist/src/parser/classes/livechat/items/LiveChatTickerSponsorItem.js
var _LiveChatTickerSponsorItem = class _LiveChatTickerSponsorItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "detail");
    __publicField(this, "author");
    __publicField(this, "duration_sec");
    this.id = data2.id;
    this.detail = new Text2(data2.detailText);
    this.author = new Author(data2.authorName, data2.authorBadges, data2.sponsorPhoto, data2.authorExternalChannelId);
    this.duration_sec = data2.durationSec;
  }
};
__name(_LiveChatTickerSponsorItem, "LiveChatTickerSponsorItem");
__publicField(_LiveChatTickerSponsorItem, "type", "LiveChatTickerSponsorItem");
var LiveChatTickerSponsorItem = _LiveChatTickerSponsorItem;

// dist/src/parser/classes/livechat/items/LiveChatViewerEngagementMessage.js
var _LiveChatViewerEngagementMessage = class _LiveChatViewerEngagementMessage extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "timestamp");
    __publicField(this, "timestamp_usec");
    __publicField(this, "icon_type");
    __publicField(this, "message");
    __publicField(this, "action_button");
    __publicField(this, "menu_endpoint");
    __publicField(this, "context_menu_accessibility_label");
    this.id = data2.id;
    if (Reflect.has(data2, "timestampUsec")) {
      this.timestamp = Math.floor(parseInt(data2.timestampUsec) / 1e3);
      this.timestamp_usec = data2.timestampUsec;
    }
    if (Reflect.has(data2, "icon") && Reflect.has(data2.icon, "iconType")) {
      this.icon_type = data2.icon.iconType;
    }
    this.message = new Text2(data2.message);
    this.action_button = parser_exports.parseItem(data2.actionButton);
    if (Reflect.has(data2, "contextMenuEndpoint")) {
      this.menu_endpoint = new NavigationEndpoint(data2.contextMenuEndpoint);
    }
    if (Reflect.has(data2, "contextMenuAccessibility") && Reflect.has(data2.contextMenuAccessibility, "accessibilityData") && Reflect.has(data2.contextMenuAccessibility.accessibilityData, "label")) {
      this.context_menu_accessibility_label = data2.contextMenuAccessibility.accessibilityData.label;
    }
  }
};
__name(_LiveChatViewerEngagementMessage, "LiveChatViewerEngagementMessage");
__publicField(_LiveChatViewerEngagementMessage, "type", "LiveChatViewerEngagementMessage");
var LiveChatViewerEngagementMessage = _LiveChatViewerEngagementMessage;

// dist/src/parser/classes/livechat/items/PollHeader.js
var _PollHeader = class _PollHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "poll_question");
    __publicField(this, "thumbnails");
    __publicField(this, "metadata");
    __publicField(this, "live_chat_poll_type");
    __publicField(this, "context_menu_button");
    this.poll_question = new Text2(data2.pollQuestion);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.metadata = new Text2(data2.metadataText);
    this.live_chat_poll_type = data2.liveChatPollType;
    this.context_menu_button = parser_exports.parseItem(data2.contextMenuButton, Button);
  }
};
__name(_PollHeader, "PollHeader");
__publicField(_PollHeader, "type", "PollHeader");
var PollHeader = _PollHeader;

// dist/src/parser/classes/livechat/LiveChatActionPanel.js
var _LiveChatActionPanel = class _LiveChatActionPanel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "contents");
    __publicField(this, "target_id");
    this.id = data2.id;
    this.contents = parser_exports.parse(data2.contents);
    this.target_id = data2.targetId;
  }
};
__name(_LiveChatActionPanel, "LiveChatActionPanel");
__publicField(_LiveChatActionPanel, "type", "LiveChatActionPanel");
var LiveChatActionPanel = _LiveChatActionPanel;

// dist/src/parser/classes/livechat/MarkChatItemAsDeletedAction.js
var _MarkChatItemAsDeletedAction = class _MarkChatItemAsDeletedAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "deleted_state_message");
    __publicField(this, "target_item_id");
    this.deleted_state_message = new Text2(data2.deletedStateMessage);
    this.target_item_id = data2.targetItemId;
  }
};
__name(_MarkChatItemAsDeletedAction, "MarkChatItemAsDeletedAction");
__publicField(_MarkChatItemAsDeletedAction, "type", "MarkChatItemAsDeletedAction");
var MarkChatItemAsDeletedAction = _MarkChatItemAsDeletedAction;

// dist/src/parser/classes/livechat/MarkChatItemsByAuthorAsDeletedAction.js
var _MarkChatItemsByAuthorAsDeletedAction = class _MarkChatItemsByAuthorAsDeletedAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "deleted_state_message");
    __publicField(this, "external_channel_id");
    this.deleted_state_message = new Text2(data2.deletedStateMessage);
    this.external_channel_id = data2.externalChannelId;
  }
};
__name(_MarkChatItemsByAuthorAsDeletedAction, "MarkChatItemsByAuthorAsDeletedAction");
__publicField(_MarkChatItemsByAuthorAsDeletedAction, "type", "MarkChatItemsByAuthorAsDeletedAction");
var MarkChatItemsByAuthorAsDeletedAction = _MarkChatItemsByAuthorAsDeletedAction;

// dist/src/parser/classes/livechat/RemoveBannerForLiveChatCommand.js
var _RemoveBannerForLiveChatCommand = class _RemoveBannerForLiveChatCommand extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "target_action_id");
    this.target_action_id = data2.targetActionId;
  }
};
__name(_RemoveBannerForLiveChatCommand, "RemoveBannerForLiveChatCommand");
__publicField(_RemoveBannerForLiveChatCommand, "type", "RemoveBannerForLiveChatCommand");
var RemoveBannerForLiveChatCommand = _RemoveBannerForLiveChatCommand;

// dist/src/parser/classes/livechat/RemoveChatItemAction.js
var _RemoveChatItemAction = class _RemoveChatItemAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "target_item_id");
    this.target_item_id = data2.targetItemId;
  }
};
__name(_RemoveChatItemAction, "RemoveChatItemAction");
__publicField(_RemoveChatItemAction, "type", "RemoveChatItemAction");
var RemoveChatItemAction = _RemoveChatItemAction;

// dist/src/parser/classes/livechat/RemoveChatItemByAuthorAction.js
var _RemoveChatItemByAuthorAction = class _RemoveChatItemByAuthorAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "external_channel_id");
    this.external_channel_id = data2.externalChannelId;
  }
};
__name(_RemoveChatItemByAuthorAction, "RemoveChatItemByAuthorAction");
__publicField(_RemoveChatItemByAuthorAction, "type", "RemoveChatItemByAuthorAction");
var RemoveChatItemByAuthorAction = _RemoveChatItemByAuthorAction;

// dist/src/parser/classes/livechat/ReplaceChatItemAction.js
var _ReplaceChatItemAction = class _ReplaceChatItemAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "target_item_id");
    __publicField(this, "replacement_item");
    this.target_item_id = data2.targetItemId;
    this.replacement_item = parser_exports.parseItem(data2.replacementItem);
  }
};
__name(_ReplaceChatItemAction, "ReplaceChatItemAction");
__publicField(_ReplaceChatItemAction, "type", "ReplaceChatItemAction");
var ReplaceChatItemAction = _ReplaceChatItemAction;

// dist/src/parser/classes/livechat/ReplaceLiveChatAction.js
var _ReplaceLiveChatAction = class _ReplaceLiveChatAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "to_replace");
    __publicField(this, "replacement");
    this.to_replace = data2.toReplace;
    this.replacement = parser_exports.parseItem(data2.replacement);
  }
};
__name(_ReplaceLiveChatAction, "ReplaceLiveChatAction");
__publicField(_ReplaceLiveChatAction, "type", "ReplaceLiveChatAction");
var ReplaceLiveChatAction = _ReplaceLiveChatAction;

// dist/src/parser/classes/livechat/ReplayChatItemAction.js
var _ReplayChatItemAction = class _ReplayChatItemAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "actions");
    __publicField(this, "video_offset_time_msec");
    this.actions = parser_exports.parseArray(data2.actions?.map((action) => {
      delete action.clickTrackingParams;
      return action;
    }));
    this.video_offset_time_msec = data2.videoOffsetTimeMsec;
  }
};
__name(_ReplayChatItemAction, "ReplayChatItemAction");
__publicField(_ReplayChatItemAction, "type", "ReplayChatItemAction");
var ReplayChatItemAction = _ReplayChatItemAction;

// dist/src/parser/classes/livechat/ShowLiveChatActionPanelAction.js
var _ShowLiveChatActionPanelAction = class _ShowLiveChatActionPanelAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "panel_to_show");
    this.panel_to_show = parser_exports.parseItem(data2.panelToShow, LiveChatActionPanel);
  }
};
__name(_ShowLiveChatActionPanelAction, "ShowLiveChatActionPanelAction");
__publicField(_ShowLiveChatActionPanelAction, "type", "ShowLiveChatActionPanelAction");
var ShowLiveChatActionPanelAction = _ShowLiveChatActionPanelAction;

// dist/src/parser/classes/livechat/ShowLiveChatDialogAction.js
var _ShowLiveChatDialogAction = class _ShowLiveChatDialogAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "dialog");
    this.dialog = parser_exports.parseItem(data2.dialog);
  }
};
__name(_ShowLiveChatDialogAction, "ShowLiveChatDialogAction");
__publicField(_ShowLiveChatDialogAction, "type", "ShowLiveChatDialogAction");
var ShowLiveChatDialogAction = _ShowLiveChatDialogAction;

// dist/src/parser/classes/livechat/ShowLiveChatTooltipCommand.js
var _ShowLiveChatTooltipCommand = class _ShowLiveChatTooltipCommand extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "tooltip");
    this.tooltip = parser_exports.parseItem(data2.tooltip);
  }
};
__name(_ShowLiveChatTooltipCommand, "ShowLiveChatTooltipCommand");
__publicField(_ShowLiveChatTooltipCommand, "type", "ShowLiveChatTooltipCommand");
var ShowLiveChatTooltipCommand = _ShowLiveChatTooltipCommand;

// dist/src/parser/classes/livechat/UpdateDateTextAction.js
var _UpdateDateTextAction = class _UpdateDateTextAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "date_text");
    this.date_text = new Text2(data2.dateText).toString();
  }
};
__name(_UpdateDateTextAction, "UpdateDateTextAction");
__publicField(_UpdateDateTextAction, "type", "UpdateDateTextAction");
var UpdateDateTextAction = _UpdateDateTextAction;

// dist/src/parser/classes/livechat/UpdateDescriptionAction.js
var _UpdateDescriptionAction = class _UpdateDescriptionAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "description");
    this.description = new Text2(data2.description);
  }
};
__name(_UpdateDescriptionAction, "UpdateDescriptionAction");
__publicField(_UpdateDescriptionAction, "type", "UpdateDescriptionAction");
var UpdateDescriptionAction = _UpdateDescriptionAction;

// dist/src/parser/classes/livechat/UpdateLiveChatPollAction.js
var _UpdateLiveChatPollAction = class _UpdateLiveChatPollAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "poll_to_update");
    this.poll_to_update = parser_exports.parseItem(data2.pollToUpdate);
  }
};
__name(_UpdateLiveChatPollAction, "UpdateLiveChatPollAction");
__publicField(_UpdateLiveChatPollAction, "type", "UpdateLiveChatPollAction");
var UpdateLiveChatPollAction = _UpdateLiveChatPollAction;

// dist/src/parser/classes/livechat/UpdateTitleAction.js
var _UpdateTitleAction = class _UpdateTitleAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data2.title);
  }
};
__name(_UpdateTitleAction, "UpdateTitleAction");
__publicField(_UpdateTitleAction, "type", "UpdateTitleAction");
var UpdateTitleAction = _UpdateTitleAction;

// dist/src/parser/classes/livechat/UpdateToggleButtonTextAction.js
var _UpdateToggleButtonTextAction = class _UpdateToggleButtonTextAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "default_text");
    __publicField(this, "toggled_text");
    __publicField(this, "button_id");
    this.default_text = new Text2(data2.defaultText).toString();
    this.toggled_text = new Text2(data2.toggledText).toString();
    this.button_id = data2.buttonId;
  }
};
__name(_UpdateToggleButtonTextAction, "UpdateToggleButtonTextAction");
__publicField(_UpdateToggleButtonTextAction, "type", "UpdateToggleButtonTextAction");
var UpdateToggleButtonTextAction = _UpdateToggleButtonTextAction;

// dist/src/parser/classes/livechat/UpdateViewershipAction.js
var _UpdateViewershipAction = class _UpdateViewershipAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "view_count");
    __publicField(this, "extra_short_view_count");
    __publicField(this, "original_view_count");
    __publicField(this, "unlabeled_view_count_value");
    __publicField(this, "is_live");
    const view_count_renderer = data2.viewCount.videoViewCountRenderer;
    this.view_count = new Text2(view_count_renderer.viewCount);
    this.extra_short_view_count = new Text2(view_count_renderer.extraShortViewCount);
    this.original_view_count = parseInt(view_count_renderer.originalViewCount);
    this.unlabeled_view_count_value = new Text2(view_count_renderer.unlabeledViewCountValue);
    this.is_live = view_count_renderer.isLive;
  }
};
__name(_UpdateViewershipAction, "UpdateViewershipAction");
__publicField(_UpdateViewershipAction, "type", "UpdateViewershipAction");
var UpdateViewershipAction = _UpdateViewershipAction;

// dist/src/parser/classes/LiveChatDialog.js
var _LiveChatDialog = class _LiveChatDialog extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "confirm_button");
    __publicField(this, "dialog_messages");
    this.confirm_button = parser_exports.parseItem(data2.confirmButton, Button);
    this.dialog_messages = data2.dialogMessages.map((el) => new Text2(el));
  }
};
__name(_LiveChatDialog, "LiveChatDialog");
__publicField(_LiveChatDialog, "type", "LiveChatDialog");
var LiveChatDialog = _LiveChatDialog;

// dist/src/parser/classes/LiveChatHeader.js
var _LiveChatHeader = class _LiveChatHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "overflow_menu");
    __publicField(this, "collapse_button");
    __publicField(this, "view_selector");
    this.overflow_menu = parser_exports.parseItem(data2.overflowMenu, Menu);
    this.collapse_button = parser_exports.parseItem(data2.collapseButton, Button);
    this.view_selector = parser_exports.parseItem(data2.viewSelector, SortFilterSubMenu);
  }
};
__name(_LiveChatHeader, "LiveChatHeader");
__publicField(_LiveChatHeader, "type", "LiveChatHeader");
var LiveChatHeader = _LiveChatHeader;

// dist/src/parser/classes/LiveChatItemList.js
var _LiveChatItemList = class _LiveChatItemList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "max_items_to_display");
    __publicField(this, "more_comments_below_button");
    this.max_items_to_display = data2.maxItemsToDisplay;
    this.more_comments_below_button = parser_exports.parseItem(data2.moreCommentsBelowButton, Button);
  }
};
__name(_LiveChatItemList, "LiveChatItemList");
__publicField(_LiveChatItemList, "type", "LiveChatItemList");
var LiveChatItemList = _LiveChatItemList;

// dist/src/parser/classes/LiveChatMessageInput.js
var _LiveChatMessageInput = class _LiveChatMessageInput extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "author_name");
    __publicField(this, "author_photo");
    __publicField(this, "send_button");
    __publicField(this, "target_id");
    this.author_name = new Text2(data2.authorName);
    this.author_photo = Thumbnail.fromResponse(data2.authorPhoto);
    this.send_button = parser_exports.parseItem(data2.sendButton, Button);
    this.target_id = data2.targetId;
  }
};
__name(_LiveChatMessageInput, "LiveChatMessageInput");
__publicField(_LiveChatMessageInput, "type", "LiveChatMessageInput");
var LiveChatMessageInput = _LiveChatMessageInput;

// dist/src/parser/classes/LiveChatParticipant.js
var _LiveChatParticipant = class _LiveChatParticipant extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "name");
    __publicField(this, "photo");
    __publicField(this, "badges");
    this.name = new Text2(data2.authorName);
    this.photo = Thumbnail.fromResponse(data2.authorPhoto);
    this.badges = parser_exports.parseArray(data2.authorBadges);
  }
};
__name(_LiveChatParticipant, "LiveChatParticipant");
__publicField(_LiveChatParticipant, "type", "LiveChatParticipant");
var LiveChatParticipant = _LiveChatParticipant;

// dist/src/parser/classes/LiveChatParticipantsList.js
var _LiveChatParticipantsList = class _LiveChatParticipantsList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "participants");
    this.title = new Text2(data2.title);
    this.participants = parser_exports.parseArray(data2.participants, LiveChatParticipant);
  }
};
__name(_LiveChatParticipantsList, "LiveChatParticipantsList");
__publicField(_LiveChatParticipantsList, "type", "LiveChatParticipantsList");
var LiveChatParticipantsList = _LiveChatParticipantsList;

// dist/src/parser/classes/LockupMetadataView.js
var _LockupMetadataView = class _LockupMetadataView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "metadata");
    __publicField(this, "image");
    __publicField(this, "menu_button");
    this.title = Text2.fromAttributed(data2.title);
    this.metadata = parser_exports.parseItem(data2.metadata, ContentMetadataView);
    this.image = parser_exports.parseItem(data2.image, [DecoratedAvatarView, AvatarStackView]);
    this.menu_button = parser_exports.parseItem(data2.menuButton, ButtonView);
  }
};
__name(_LockupMetadataView, "LockupMetadataView");
__publicField(_LockupMetadataView, "type", "LockupMetadataView");
var LockupMetadataView = _LockupMetadataView;

// dist/src/parser/classes/LockupView.js
var _LockupView = class _LockupView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "content_image");
    __publicField(this, "metadata");
    __publicField(this, "content_id");
    __publicField(this, "content_type");
    __publicField(this, "renderer_context");
    this.content_image = parser_exports.parseItem(data2.contentImage, [CollectionThumbnailView, ThumbnailView]);
    this.metadata = parser_exports.parseItem(data2.metadata, LockupMetadataView);
    this.content_id = data2.contentId;
    this.content_type = data2.contentType.replace("LOCKUP_CONTENT_TYPE_", "");
    this.renderer_context = new RendererContext(data2.rendererContext);
  }
};
__name(_LockupView, "LockupView");
__publicField(_LockupView, "type", "LockupView");
var LockupView = _LockupView;

// dist/src/parser/classes/MacroMarkersListEntity.js
var _MacroMarkersListEntity = class _MacroMarkersListEntity extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "marker_entity_key");
    __publicField(this, "external_video_id");
    /** The type of markers in this entity (e.g., 'MARKER_TYPE_HEATMAP') */
    __publicField(this, "marker_type");
    __publicField(this, "markers");
    __publicField(this, "max_height_dp");
    __publicField(this, "min_height_dp");
    __publicField(this, "show_hide_animation_duration_millis");
    __publicField(this, "timed_marker_decorations");
    // Store raw API data for use in toHeatmap
    __publicField(this, "raw_api_markers");
    __publicField(this, "raw_api_decorations");
    this.marker_entity_key = data2.key;
    this.external_video_id = data2.externalVideoId;
    this.marker_type = data2.markersList?.markerType || "";
    this.raw_api_markers = data2.markersList?.markers || [];
    this.raw_api_decorations = data2.markersList?.markersDecoration?.timedMarkerDecorations || [];
    this.markers = observe(this.raw_api_markers.map((marker) => new HeatMarker(marker)));
    const heatmapMetadata = data2.markersList?.markersMetadata?.heatmapMetadata;
    this.max_height_dp = heatmapMetadata?.maxHeightDp || 40;
    this.min_height_dp = heatmapMetadata?.minHeightDp || 4;
    this.show_hide_animation_duration_millis = heatmapMetadata?.showHideAnimationDurationMillis || 200;
    this.timed_marker_decorations = observe(this.raw_api_decorations.map((decoration) => new TimedMarkerDecoration(decoration)));
  }
  /**
  * Checks if this MacroMarkersListEntity represents heatmap data.
  * Only heatmap markers can be converted to Heatmap objects.
  */
  isHeatmap() {
    return this.marker_type === "MARKER_TYPE_HEATMAP";
  }
  /**
  * Converts this MacroMarkersListEntity to a Heatmap object
  * for compatibility with existing code. Only works for heatmap markers.
  * @returns Heatmap object if this entity contains heatmap data, null otherwise
  */
  toHeatmap() {
    if (!this.isHeatmap()) {
      return null;
    }
    const wrappedHeatMarkers = this.raw_api_markers.map((marker) => ({ HeatMarker: marker }));
    const wrappedDecorations = this.raw_api_decorations.map((decoration) => ({ TimedMarkerDecoration: decoration }));
    const heatmapRawPayload = {
      maxHeightDp: this.max_height_dp,
      minHeightDp: this.min_height_dp,
      showHideAnimationDurationMillis: this.show_hide_animation_duration_millis,
      heatMarkers: wrappedHeatMarkers,
      heatMarkersDecorations: wrappedDecorations
    };
    return parseItem({ Heatmap: heatmapRawPayload }, Heatmap);
  }
};
__name(_MacroMarkersListEntity, "MacroMarkersListEntity");
__publicField(_MacroMarkersListEntity, "type", "MacroMarkersListEntity");
var MacroMarkersListEntity = _MacroMarkersListEntity;

// dist/src/parser/classes/menus/MenuNavigationItem.js
var _MenuNavigationItem = class _MenuNavigationItem extends Button {
  constructor(data2) {
    super(data2);
  }
};
__name(_MenuNavigationItem, "MenuNavigationItem");
__publicField(_MenuNavigationItem, "type", "MenuNavigationItem");
var MenuNavigationItem = _MenuNavigationItem;

// dist/src/parser/classes/menus/MenuPopup.js
var _MenuPopup = class _MenuPopup extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data2.items, [MenuNavigationItem, MenuServiceItem]);
  }
};
__name(_MenuPopup, "MenuPopup");
__publicField(_MenuPopup, "type", "MenuPopup");
var MenuPopup = _MenuPopup;

// dist/src/parser/classes/Notification.js
var _Notification = class _Notification extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnails");
    __publicField(this, "video_thumbnails");
    __publicField(this, "short_message");
    __publicField(this, "sent_time");
    __publicField(this, "notification_id");
    __publicField(this, "endpoint");
    __publicField(this, "record_click_endpoint");
    __publicField(this, "menu");
    __publicField(this, "read");
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.video_thumbnails = Thumbnail.fromResponse(data2.videoThumbnail);
    this.short_message = new Text2(data2.shortMessage);
    this.sent_time = new Text2(data2.sentTimeText);
    this.notification_id = data2.notificationId;
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.record_click_endpoint = new NavigationEndpoint(data2.recordClickEndpoint);
    this.menu = parser_exports.parseItem(data2.contextualMenu);
    this.read = data2.read;
  }
};
__name(_Notification, "Notification");
__publicField(_Notification, "type", "Notification");
var Notification = _Notification;

// dist/src/parser/classes/menus/MultiPageMenuNotificationSection.js
var _MultiPageMenuNotificationSection = class _MultiPageMenuNotificationSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "notification_section_title");
    __publicField(this, "items");
    if ("notificationSectionTitle" in data2) {
      this.notification_section_title = new Text2(data2.notificationSectionTitle);
    }
    this.items = parser_exports.parseArray(data2.items, [Notification, Message, ContinuationItem]);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_MultiPageMenuNotificationSection, "MultiPageMenuNotificationSection");
__publicField(_MultiPageMenuNotificationSection, "type", "MultiPageMenuNotificationSection");
var MultiPageMenuNotificationSection = _MultiPageMenuNotificationSection;

// dist/src/parser/classes/menus/MusicMenuItemDivider.js
var _MusicMenuItemDivider = class _MusicMenuItemDivider extends YTNode {
  // eslint-disable-next-line
  constructor(_data23) {
    super();
  }
};
__name(_MusicMenuItemDivider, "MusicMenuItemDivider");
__publicField(_MusicMenuItemDivider, "type", "MusicMenuItemDivider");
var MusicMenuItemDivider = _MusicMenuItemDivider;

// dist/src/parser/classes/menus/MusicMultiSelectMenuItem.js
var _MusicMultiSelectMenuItem = class _MusicMultiSelectMenuItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "form_item_entity_key");
    __publicField(this, "selected_icon_type");
    __publicField(this, "endpoint");
    __publicField(this, "selected");
    this.title = new Text2(data2.title).toString();
    this.form_item_entity_key = data2.formItemEntityKey;
    if (Reflect.has(data2, "selectedIcon")) {
      this.selected_icon_type = data2.selectedIcon.iconType;
    }
    if (Reflect.has(data2, "selectedCommand")) {
      this.endpoint = new NavigationEndpoint(data2.selectedCommand);
    }
    this.selected = !!this.endpoint;
  }
};
__name(_MusicMultiSelectMenuItem, "MusicMultiSelectMenuItem");
__publicField(_MusicMultiSelectMenuItem, "type", "MusicMultiSelectMenuItem");
var MusicMultiSelectMenuItem = _MusicMultiSelectMenuItem;

// dist/src/parser/classes/menus/MusicMultiSelectMenu.js
var _MusicMultiSelectMenu = class _MusicMultiSelectMenu extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "options");
    if (Reflect.has(data2, "title") && Reflect.has(data2.title, "musicMenuTitleRenderer")) {
      this.title = new Text2(data2.title.musicMenuTitleRenderer?.primaryText);
    }
    this.options = parser_exports.parseArray(data2.options, [MusicMultiSelectMenuItem, MusicMenuItemDivider]);
  }
};
__name(_MusicMultiSelectMenu, "MusicMultiSelectMenu");
__publicField(_MusicMultiSelectMenu, "type", "MusicMultiSelectMenu");
var MusicMultiSelectMenu = _MusicMultiSelectMenu;

// dist/src/parser/classes/menus/SimpleMenuHeader.js
var _SimpleMenuHeader = class _SimpleMenuHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "buttons");
    this.title = new Text2(data2.title);
    this.buttons = parser_exports.parseArray(data2.buttons, Button);
  }
};
__name(_SimpleMenuHeader, "SimpleMenuHeader");
__publicField(_SimpleMenuHeader, "type", "SimpleMenuHeader");
var SimpleMenuHeader = _SimpleMenuHeader;

// dist/src/parser/classes/MerchandiseItem.js
var _MerchandiseItem = class _MerchandiseItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "thumbnails");
    __publicField(this, "price");
    __publicField(this, "vendor_name");
    __publicField(this, "button_text");
    __publicField(this, "button_accessibility_text");
    __publicField(this, "from_vendor_text");
    __publicField(this, "additional_fees_text");
    __publicField(this, "region_format");
    __publicField(this, "endpoint");
    this.title = data2.title;
    this.description = data2.description;
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.price = data2.price;
    this.vendor_name = data2.vendorName;
    this.button_text = data2.buttonText;
    this.button_accessibility_text = data2.buttonAccessibilityText;
    this.from_vendor_text = data2.fromVendorText;
    this.additional_fees_text = data2.additionalFeesText;
    this.region_format = data2.regionFormat;
    this.endpoint = new NavigationEndpoint(data2.buttonCommand);
  }
};
__name(_MerchandiseItem, "MerchandiseItem");
__publicField(_MerchandiseItem, "type", "MerchandiseItem");
var MerchandiseItem = _MerchandiseItem;

// dist/src/parser/classes/MerchandiseShelf.js
var _MerchandiseShelf = class _MerchandiseShelf extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "menu");
    __publicField(this, "items");
    this.title = data2.title;
    this.menu = parser_exports.parseItem(data2.actionButton);
    this.items = parser_exports.parseArray(data2.items);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_MerchandiseShelf, "MerchandiseShelf");
__publicField(_MerchandiseShelf, "type", "MerchandiseShelf");
var MerchandiseShelf = _MerchandiseShelf;

// dist/src/parser/classes/MetadataRow.js
var _MetadataRow = class _MetadataRow extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "contents");
    this.title = new Text2(data2.title);
    this.contents = data2.contents.map((content) => new Text2(content));
  }
};
__name(_MetadataRow, "MetadataRow");
__publicField(_MetadataRow, "type", "MetadataRow");
var MetadataRow = _MetadataRow;

// dist/src/parser/classes/MetadataRowContainer.js
var _MetadataRowContainer = class _MetadataRowContainer extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "rows");
    __publicField(this, "collapsed_item_count");
    this.rows = parser_exports.parseArray(data2.rows);
    this.collapsed_item_count = data2.collapsedItemCount;
  }
};
__name(_MetadataRowContainer, "MetadataRowContainer");
__publicField(_MetadataRowContainer, "type", "MetadataRowContainer");
var MetadataRowContainer = _MetadataRowContainer;

// dist/src/parser/classes/MetadataRowHeader.js
var _MetadataRowHeader = class _MetadataRowHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "content");
    __publicField(this, "has_divider_line");
    this.content = new Text2(data2.content);
    this.has_divider_line = data2.hasDividerLine;
  }
};
__name(_MetadataRowHeader, "MetadataRowHeader");
__publicField(_MetadataRowHeader, "type", "MetadataRowHeader");
var MetadataRowHeader = _MetadataRowHeader;

// dist/src/parser/classes/MetadataScreen.js
var _MetadataScreen = class _MetadataScreen extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "section_list");
    this.section_list = parser_exports.parseItem(data2);
  }
};
__name(_MetadataScreen, "MetadataScreen");
__publicField(_MetadataScreen, "type", "MetadataScreen");
var MetadataScreen = _MetadataScreen;

// dist/src/parser/classes/MicroformatData.js
var _MicroformatData = class _MicroformatData extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "url_canonical");
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "thumbnail");
    __publicField(this, "site_name");
    __publicField(this, "app_name");
    __publicField(this, "android_package");
    __publicField(this, "ios_app_store_id");
    __publicField(this, "ios_app_arguments");
    __publicField(this, "og_type");
    __publicField(this, "url_applinks_web");
    __publicField(this, "url_applinks_ios");
    __publicField(this, "url_applinks_android");
    __publicField(this, "url_twitter_ios");
    __publicField(this, "url_twitter_android");
    __publicField(this, "twitter_card_type");
    __publicField(this, "twitter_site_handle");
    __publicField(this, "schema_dot_org_type");
    __publicField(this, "noindex");
    __publicField(this, "is_unlisted");
    __publicField(this, "is_family_safe");
    __publicField(this, "tags");
    __publicField(this, "available_countries");
    this.url_canonical = data2.urlCanonical;
    this.title = data2.title;
    this.description = data2.description;
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.site_name = data2.siteName;
    this.app_name = data2.appName;
    this.android_package = data2.androidPackage;
    this.ios_app_store_id = data2.iosAppStoreId;
    this.ios_app_arguments = data2.iosAppArguments;
    this.og_type = data2.ogType;
    this.url_applinks_web = data2.urlApplinksWeb;
    this.url_applinks_ios = data2.urlApplinksIos;
    this.url_applinks_android = data2.urlApplinksAndroid;
    this.url_twitter_ios = data2.urlTwitterIos;
    this.url_twitter_android = data2.urlTwitterAndroid;
    this.twitter_card_type = data2.twitterCardType;
    this.twitter_site_handle = data2.twitterSiteHandle;
    this.schema_dot_org_type = data2.schemaDotOrgType;
    this.noindex = data2.noindex;
    this.is_unlisted = data2.unlisted;
    this.is_family_safe = data2.familySafe;
    this.tags = data2.tags;
    this.available_countries = data2.availableCountries;
  }
};
__name(_MicroformatData, "MicroformatData");
__publicField(_MicroformatData, "type", "MicroformatData");
var MicroformatData = _MicroformatData;

// dist/src/parser/classes/Mix.js
var _Mix = class _Mix extends Playlist {
  constructor(data2) {
    super(data2);
  }
};
__name(_Mix, "Mix");
__publicField(_Mix, "type", "Mix");
var Mix = _Mix;

// dist/src/parser/classes/ModalWithTitleAndButton.js
var _ModalWithTitleAndButton = class _ModalWithTitleAndButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "content");
    __publicField(this, "button");
    this.title = new Text2(data2.title);
    this.content = new Text2(data2.content);
    this.button = parser_exports.parseItem(data2.button, Button);
  }
};
__name(_ModalWithTitleAndButton, "ModalWithTitleAndButton");
__publicField(_ModalWithTitleAndButton, "type", "ModalWithTitleAndButton");
var ModalWithTitleAndButton = _ModalWithTitleAndButton;

// dist/src/parser/classes/Movie.js
var _Movie = class _Movie extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "description_snippet");
    __publicField(this, "top_metadata_items");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "author");
    __publicField(this, "duration");
    __publicField(this, "endpoint");
    __publicField(this, "badges");
    __publicField(this, "use_vertical_poster");
    __publicField(this, "show_action_menu");
    __publicField(this, "menu");
    const overlay_time_status = data2.thumbnailOverlays.find((overlay) => overlay.thumbnailOverlayTimeStatusRenderer)?.thumbnailOverlayTimeStatusRenderer.text || "N/A";
    this.id = data2.videoId;
    this.title = new Text2(data2.title);
    if (Reflect.has(data2, "descriptionSnippet")) {
      this.description_snippet = new Text2(data2.descriptionSnippet);
    }
    this.top_metadata_items = new Text2(data2.topMetadataItems);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.thumbnail_overlays = parser_exports.parseArray(data2.thumbnailOverlays);
    this.author = new Author(data2.longBylineText, data2.ownerBadges, data2.channelThumbnailSupportedRenderers?.channelThumbnailWithLinkRenderer?.thumbnail);
    this.duration = {
      text: data2.lengthText ? new Text2(data2.lengthText).toString() : new Text2(overlay_time_status).toString(),
      seconds: timeToSeconds(data2.lengthText ? new Text2(data2.lengthText).toString() : new Text2(overlay_time_status).toString())
    };
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.badges = parser_exports.parseArray(data2.badges);
    this.use_vertical_poster = data2.useVerticalPoster;
    this.show_action_menu = data2.showActionMenu;
    this.menu = parser_exports.parseItem(data2.menu, Menu);
  }
};
__name(_Movie, "Movie");
__publicField(_Movie, "type", "Movie");
var Movie = _Movie;

// dist/src/parser/classes/MovingThumbnail.js
var _MovingThumbnail = class _MovingThumbnail extends YTNode {
  constructor(data2) {
    super();
    return data2.movingThumbnailDetails?.thumbnails.map((thumbnail) => new Thumbnail(thumbnail)).sort((a, b) => b.width - a.width);
  }
};
__name(_MovingThumbnail, "MovingThumbnail");
__publicField(_MovingThumbnail, "type", "MovingThumbnail");
var MovingThumbnail = _MovingThumbnail;

// dist/src/parser/classes/MusicCardShelfHeaderBasic.js
var _MusicCardShelfHeaderBasic = class _MusicCardShelfHeaderBasic extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data2.title);
  }
};
__name(_MusicCardShelfHeaderBasic, "MusicCardShelfHeaderBasic");
__publicField(_MusicCardShelfHeaderBasic, "type", "MusicCardShelfHeaderBasic");
var MusicCardShelfHeaderBasic = _MusicCardShelfHeaderBasic;

// dist/src/parser/classes/MusicInlineBadge.js
var _MusicInlineBadge = class _MusicInlineBadge extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "icon_type");
    __publicField(this, "accessibility");
    this.icon_type = data2.icon.iconType;
    if ("accessibilityData" in data2 && "accessibilityData" in data2.accessibilityData) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data2.accessibilityData.accessibilityData)
      };
    }
  }
  get label() {
    return this.accessibility?.accessibility_data?.label;
  }
};
__name(_MusicInlineBadge, "MusicInlineBadge");
__publicField(_MusicInlineBadge, "type", "MusicInlineBadge");
var MusicInlineBadge = _MusicInlineBadge;

// dist/src/parser/classes/MusicPlayButton.js
var _MusicPlayButton = class _MusicPlayButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "endpoint");
    __publicField(this, "play_icon_type");
    __publicField(this, "pause_icon_type");
    __publicField(this, "icon_color");
    __publicField(this, "accessibility_play_data");
    __publicField(this, "accessibility_pause_data");
    this.endpoint = new NavigationEndpoint(data2.playNavigationEndpoint);
    this.play_icon_type = data2.playIcon.iconType;
    this.pause_icon_type = data2.pauseIcon.iconType;
    if ("accessibilityPlayData" in data2 && "accessibilityData" in data2.accessibilityPlayData) {
      this.accessibility_play_data = {
        accessibility_data: new AccessibilityData(data2.accessibilityPlayData.accessibilityData)
      };
    }
    if ("accessibilityPauseData" in data2 && "accessibilityData" in data2.accessibilityPauseData) {
      this.accessibility_pause_data = {
        accessibility_data: new AccessibilityData(data2.accessibilityPauseData.accessibilityData)
      };
    }
    this.icon_color = data2.iconColor;
  }
  get play_label() {
    return this.accessibility_play_data?.accessibility_data?.label;
  }
  get pause_label() {
    return this.accessibility_pause_data?.accessibility_data?.label;
  }
};
__name(_MusicPlayButton, "MusicPlayButton");
__publicField(_MusicPlayButton, "type", "MusicPlayButton");
var MusicPlayButton = _MusicPlayButton;

// dist/src/parser/classes/MusicItemThumbnailOverlay.js
var _MusicItemThumbnailOverlay = class _MusicItemThumbnailOverlay extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "content");
    __publicField(this, "content_position");
    __publicField(this, "display_style");
    this.content = parser_exports.parseItem(data2.content, MusicPlayButton);
    this.content_position = data2.contentPosition;
    this.display_style = data2.displayStyle;
  }
};
__name(_MusicItemThumbnailOverlay, "MusicItemThumbnailOverlay");
__publicField(_MusicItemThumbnailOverlay, "type", "MusicItemThumbnailOverlay");
var MusicItemThumbnailOverlay = _MusicItemThumbnailOverlay;

// dist/src/parser/classes/MusicThumbnail.js
var _MusicThumbnail = class _MusicThumbnail extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    this.contents = Thumbnail.fromResponse(data2.thumbnail);
  }
};
__name(_MusicThumbnail, "MusicThumbnail");
__publicField(_MusicThumbnail, "type", "MusicThumbnail");
var MusicThumbnail = _MusicThumbnail;

// dist/src/parser/classes/MusicCardShelf.js
var _MusicCardShelf = class _MusicCardShelf extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "buttons");
    __publicField(this, "menu");
    __publicField(this, "on_tap");
    __publicField(this, "header");
    __publicField(this, "end_icon_type");
    __publicField(this, "subtitle_badges");
    __publicField(this, "thumbnail_overlay");
    __publicField(this, "contents");
    this.thumbnail = parser_exports.parseItem(data2.thumbnail, MusicThumbnail);
    this.title = new Text2(data2.title);
    this.subtitle = new Text2(data2.subtitle);
    this.buttons = parser_exports.parseArray(data2.buttons, Button);
    this.menu = parser_exports.parseItem(data2.menu, Menu);
    this.on_tap = new NavigationEndpoint(data2.onTap);
    this.header = parser_exports.parseItem(data2.header, MusicCardShelfHeaderBasic);
    if (Reflect.has(data2, "endIcon") && Reflect.has(data2.endIcon, "iconType")) {
      this.end_icon_type = data2.endIcon.iconType;
    }
    this.subtitle_badges = parser_exports.parseArray(data2.subtitleBadges, MusicInlineBadge);
    this.thumbnail_overlay = parser_exports.parseItem(data2.thumbnailOverlay, MusicItemThumbnailOverlay);
    if (Reflect.has(data2, "contents")) {
      this.contents = parser_exports.parseArray(data2.contents);
    }
  }
};
__name(_MusicCardShelf, "MusicCardShelf");
__publicField(_MusicCardShelf, "type", "MusicCardShelf");
var MusicCardShelf = _MusicCardShelf;

// dist/src/parser/classes/MusicCarouselShelfBasicHeader.js
var _MusicCarouselShelfBasicHeader = class _MusicCarouselShelfBasicHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "strapline");
    __publicField(this, "thumbnail");
    __publicField(this, "more_content");
    __publicField(this, "end_icons");
    this.title = new Text2(data2.title);
    if (Reflect.has(data2, "strapline")) {
      this.strapline = new Text2(data2.strapline);
    }
    if (Reflect.has(data2, "thumbnail")) {
      this.thumbnail = parser_exports.parseItem(data2.thumbnail, MusicThumbnail);
    }
    if (Reflect.has(data2, "moreContentButton")) {
      this.more_content = parser_exports.parseItem(data2.moreContentButton, Button);
    }
    if (Reflect.has(data2, "endIcons")) {
      this.end_icons = parser_exports.parseArray(data2.endIcons, IconLink);
    }
  }
};
__name(_MusicCarouselShelfBasicHeader, "MusicCarouselShelfBasicHeader");
__publicField(_MusicCarouselShelfBasicHeader, "type", "MusicCarouselShelfBasicHeader");
var MusicCarouselShelfBasicHeader = _MusicCarouselShelfBasicHeader;

// dist/src/parser/classes/MusicMultiRowListItem.js
var _MusicMultiRowListItem = class _MusicMultiRowListItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "overlay");
    __publicField(this, "on_tap");
    __publicField(this, "menu");
    __publicField(this, "subtitle");
    __publicField(this, "title");
    __publicField(this, "second_title");
    __publicField(this, "description");
    __publicField(this, "display_style");
    this.thumbnail = parser_exports.parseItem(data2.thumbnail, MusicThumbnail);
    this.overlay = parser_exports.parseItem(data2.overlay, MusicItemThumbnailOverlay);
    this.on_tap = new NavigationEndpoint(data2.onTap);
    this.menu = parser_exports.parseItem(data2.menu, Menu);
    this.subtitle = new Text2(data2.subtitle);
    this.title = new Text2(data2.title);
    if (Reflect.has(data2, "secondTitle")) {
      this.second_title = new Text2(data2.secondTitle);
    }
    if (Reflect.has(data2, "description")) {
      this.description = new Text2(data2.description);
    }
    if (Reflect.has(data2, "displayStyle")) {
      this.display_style = data2.displayStyle;
    }
  }
};
__name(_MusicMultiRowListItem, "MusicMultiRowListItem");
__publicField(_MusicMultiRowListItem, "type", "MusicMultiRowListItem");
var MusicMultiRowListItem = _MusicMultiRowListItem;

// dist/src/parser/classes/MusicNavigationButton.js
var _MusicNavigationButton = class _MusicNavigationButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "button_text");
    __publicField(this, "endpoint");
    this.button_text = new Text2(data2.buttonText).toString();
    this.endpoint = new NavigationEndpoint(data2.clickCommand);
  }
};
__name(_MusicNavigationButton, "MusicNavigationButton");
__publicField(_MusicNavigationButton, "type", "MusicNavigationButton");
var MusicNavigationButton = _MusicNavigationButton;

// dist/src/parser/classes/MusicResponsiveListItemFixedColumn.js
var _MusicResponsiveListItemFixedColumn = class _MusicResponsiveListItemFixedColumn extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "display_priority");
    this.title = new Text2(data2.text);
    this.display_priority = data2.displayPriority;
  }
};
__name(_MusicResponsiveListItemFixedColumn, "MusicResponsiveListItemFixedColumn");
__publicField(_MusicResponsiveListItemFixedColumn, "type", "musicResponsiveListItemFlexColumnRenderer");
var MusicResponsiveListItemFixedColumn = _MusicResponsiveListItemFixedColumn;

// dist/src/parser/classes/MusicResponsiveListItemFlexColumn.js
var _MusicResponsiveListItemFlexColumn = class _MusicResponsiveListItemFlexColumn extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "display_priority");
    this.title = new Text2(data2.text);
    this.display_priority = data2.displayPriority;
  }
};
__name(_MusicResponsiveListItemFlexColumn, "MusicResponsiveListItemFlexColumn");
__publicField(_MusicResponsiveListItemFlexColumn, "type", "MusicResponsiveListItemFlexColumn");
var MusicResponsiveListItemFlexColumn = _MusicResponsiveListItemFlexColumn;

// dist/src/parser/classes/MusicResponsiveListItem.js
var _MusicResponsiveListItem_instances, parseOther_fn, parseVideoOrSong_fn, parseSong_fn, parseVideo_fn, parseArtist_fn, parseLibraryArtist_fn, parseNonMusicTrack_fn, parsePodcastShow_fn, parseAlbum_fn, parsePlaylist_fn;
var _MusicResponsiveListItem = class _MusicResponsiveListItem extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _MusicResponsiveListItem_instances);
    __publicField(this, "flex_columns");
    __publicField(this, "fixed_columns");
    __publicField(this, "endpoint");
    __publicField(this, "item_type");
    __publicField(this, "index");
    __publicField(this, "thumbnail");
    __publicField(this, "badges");
    __publicField(this, "menu");
    __publicField(this, "overlay");
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "duration");
    __publicField(this, "album");
    __publicField(this, "artists");
    __publicField(this, "views");
    __publicField(this, "authors");
    __publicField(this, "name");
    __publicField(this, "subtitle");
    __publicField(this, "subscribers");
    __publicField(this, "song_count");
    // TODO: these might be replaceable with Author class
    __publicField(this, "author");
    __publicField(this, "item_count");
    __publicField(this, "year");
    this.flex_columns = parser_exports.parseArray(data2.flexColumns, MusicResponsiveListItemFlexColumn);
    this.fixed_columns = parser_exports.parseArray(data2.fixedColumns, MusicResponsiveListItemFixedColumn);
    const playlist_item_data = {
      video_id: data2?.playlistItemData?.videoId || null,
      playlist_set_video_id: data2?.playlistItemData?.playlistSetVideoId || null
    };
    if (Reflect.has(data2, "navigationEndpoint")) {
      this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    }
    let page_type = this.endpoint?.payload?.browseEndpointContextSupportedConfigs?.browseEndpointContextMusicConfig?.pageType;
    if (!page_type) {
      const is_non_music_track = this.flex_columns.find((col) => col.title.endpoint?.payload?.browseEndpointContextSupportedConfigs?.browseEndpointContextMusicConfig?.pageType === "MUSIC_PAGE_TYPE_NON_MUSIC_AUDIO_TRACK_PAGE");
      if (is_non_music_track) {
        page_type = "MUSIC_PAGE_TYPE_NON_MUSIC_AUDIO_TRACK_PAGE";
      }
    }
    switch (page_type) {
      case "MUSIC_PAGE_TYPE_ALBUM":
        this.item_type = "album";
        __privateMethod(this, _MusicResponsiveListItem_instances, parseAlbum_fn).call(this);
        break;
      case "MUSIC_PAGE_TYPE_PLAYLIST":
        this.item_type = "playlist";
        __privateMethod(this, _MusicResponsiveListItem_instances, parsePlaylist_fn).call(this);
        break;
      case "MUSIC_PAGE_TYPE_ARTIST":
      case "MUSIC_PAGE_TYPE_USER_CHANNEL":
        this.item_type = "artist";
        __privateMethod(this, _MusicResponsiveListItem_instances, parseArtist_fn).call(this);
        break;
      case "MUSIC_PAGE_TYPE_LIBRARY_ARTIST":
        this.item_type = "library_artist";
        __privateMethod(this, _MusicResponsiveListItem_instances, parseLibraryArtist_fn).call(this);
        break;
      case "MUSIC_PAGE_TYPE_NON_MUSIC_AUDIO_TRACK_PAGE":
        this.item_type = "non_music_track";
        __privateMethod(this, _MusicResponsiveListItem_instances, parseNonMusicTrack_fn).call(this, playlist_item_data);
        break;
      case "MUSIC_PAGE_TYPE_PODCAST_SHOW_DETAIL_PAGE":
        this.item_type = "podcast_show";
        __privateMethod(this, _MusicResponsiveListItem_instances, parsePodcastShow_fn).call(this);
        break;
      default:
        if (this.flex_columns[1]) {
          __privateMethod(this, _MusicResponsiveListItem_instances, parseVideoOrSong_fn).call(this, playlist_item_data);
        } else {
          __privateMethod(this, _MusicResponsiveListItem_instances, parseOther_fn).call(this);
        }
    }
    if (Reflect.has(data2, "index")) {
      this.index = new Text2(data2.index);
    }
    if (Reflect.has(data2, "thumbnail")) {
      this.thumbnail = parser_exports.parseItem(data2.thumbnail, MusicThumbnail);
    }
    if (Reflect.has(data2, "badges")) {
      this.badges = parser_exports.parseArray(data2.badges);
    }
    if (Reflect.has(data2, "menu")) {
      this.menu = parser_exports.parseItem(data2.menu, Menu);
    }
    if (Reflect.has(data2, "overlay")) {
      this.overlay = parser_exports.parseItem(data2.overlay, MusicItemThumbnailOverlay);
    }
  }
  get thumbnails() {
    return this.thumbnail?.contents || [];
  }
};
_MusicResponsiveListItem_instances = new WeakSet();
parseOther_fn = /* @__PURE__ */ __name(function() {
  this.title = this.flex_columns[0].title.toString();
  if (this.endpoint) {
    this.item_type = "endpoint";
  } else {
    this.item_type = "unknown";
  }
}, "#parseOther");
parseVideoOrSong_fn = /* @__PURE__ */ __name(function(playlist_item_data) {
  const music_video_type = this.flex_columns.at(0)?.title.runs?.at(0)?.endpoint?.payload?.watchEndpointMusicSupportedConfigs?.watchEndpointMusicConfig?.musicVideoType;
  switch (music_video_type) {
    case "MUSIC_VIDEO_TYPE_UGC":
    case "MUSIC_VIDEO_TYPE_OMV":
      this.item_type = "video";
      __privateMethod(this, _MusicResponsiveListItem_instances, parseVideo_fn).call(this, playlist_item_data);
      break;
    case "MUSIC_VIDEO_TYPE_ATV":
      this.item_type = "song";
      __privateMethod(this, _MusicResponsiveListItem_instances, parseSong_fn).call(this, playlist_item_data);
      break;
    default:
      __privateMethod(this, _MusicResponsiveListItem_instances, parseOther_fn).call(this);
  }
}, "#parseVideoOrSong");
parseSong_fn = /* @__PURE__ */ __name(function(playlist_item_data) {
  this.id = playlist_item_data.video_id || this.endpoint?.payload?.videoId;
  this.title = this.flex_columns[0].title.toString();
  const duration_text = this.flex_columns.at(1)?.title.runs?.find((run) => /^\d+$/.test(run.text.replace(/:/g, "")))?.text || this.fixed_columns[0]?.title?.toString();
  if (duration_text) {
    this.duration = {
      text: duration_text,
      seconds: timeToSeconds(duration_text)
    };
  }
  const album_run = this.flex_columns.at(1)?.title.runs?.find((run) => isTextRun(run) && run.endpoint && run.endpoint.payload.browseId.startsWith("MPR")) || this.flex_columns.at(2)?.title.runs?.find((run) => isTextRun(run) && run.endpoint && run.endpoint.payload.browseId.startsWith("MPR"));
  if (album_run && isTextRun(album_run)) {
    this.album = {
      id: album_run.endpoint?.payload?.browseId,
      name: album_run.text,
      endpoint: album_run.endpoint
    };
  }
  const artist_runs = this.flex_columns.at(1)?.title.runs?.filter((run) => isTextRun(run) && run.endpoint && run.endpoint.payload.browseId.startsWith("UC"));
  if (artist_runs) {
    this.artists = artist_runs.map((run) => ({
      name: run.text,
      channel_id: isTextRun(run) ? run.endpoint?.payload?.browseId : void 0,
      endpoint: isTextRun(run) ? run.endpoint : void 0
    }));
  }
}, "#parseSong");
parseVideo_fn = /* @__PURE__ */ __name(function(playlist_item_data) {
  this.id = playlist_item_data.video_id;
  this.title = this.flex_columns[0].title.toString();
  this.views = this.flex_columns.at(1)?.title.runs?.find((run) => run.text.match(/(.*?) views/))?.toString();
  const author_runs = this.flex_columns.at(1)?.title.runs?.filter((run) => isTextRun(run) && run.endpoint && run.endpoint.payload.browseId.startsWith("UC"));
  if (author_runs) {
    this.authors = author_runs.map((run) => {
      return {
        name: run.text,
        channel_id: isTextRun(run) ? run.endpoint?.payload?.browseId : void 0,
        endpoint: isTextRun(run) ? run.endpoint : void 0
      };
    });
  }
  const duration_text = this.flex_columns[1].title.runs?.find((run) => /^\d+$/.test(run.text.replace(/:/g, "")))?.text || this.fixed_columns[0]?.title.runs?.find((run) => /^\d+$/.test(run.text.replace(/:/g, "")))?.text;
  if (duration_text) {
    this.duration = {
      text: duration_text,
      seconds: timeToSeconds(duration_text)
    };
  }
}, "#parseVideo");
parseArtist_fn = /* @__PURE__ */ __name(function() {
  this.id = this.endpoint?.payload?.browseId;
  this.name = this.flex_columns[0].title.toString();
  this.subtitle = this.flex_columns.at(1)?.title;
  this.subscribers = this.subtitle?.runs?.find((run) => /^(\d*\.)?\d+[M|K]? subscribers?$/i.test(run.text))?.text || "";
}, "#parseArtist");
parseLibraryArtist_fn = /* @__PURE__ */ __name(function() {
  this.name = this.flex_columns[0].title.toString();
  this.subtitle = this.flex_columns.at(1)?.title;
  this.song_count = this.subtitle?.runs?.find((run) => /^\d+(,\d+)? songs?$/i.test(run.text))?.text || "";
}, "#parseLibraryArtist");
parseNonMusicTrack_fn = /* @__PURE__ */ __name(function(playlist_item_data) {
  this.id = playlist_item_data.video_id || this.endpoint?.payload?.videoId;
  this.title = this.flex_columns[0].title.toString();
}, "#parseNonMusicTrack");
parsePodcastShow_fn = /* @__PURE__ */ __name(function() {
  this.id = this.endpoint?.payload?.browseId;
  this.title = this.flex_columns[0].title.toString();
}, "#parsePodcastShow");
parseAlbum_fn = /* @__PURE__ */ __name(function() {
  this.id = this.endpoint?.payload?.browseId;
  this.title = this.flex_columns[0].title.toString();
  const author_run = this.flex_columns.at(1)?.title.runs?.find((run) => isTextRun(run) && run.endpoint && run.endpoint.payload.browseId.startsWith("UC"));
  if (author_run && isTextRun(author_run)) {
    this.author = {
      name: author_run.text,
      channel_id: author_run.endpoint?.payload?.browseId,
      endpoint: author_run.endpoint
    };
  }
  this.year = this.flex_columns.at(1)?.title.runs?.find((run) => /^[12][0-9]{3}$/.test(run.text))?.text;
}, "#parseAlbum");
parsePlaylist_fn = /* @__PURE__ */ __name(function() {
  this.id = this.endpoint?.payload?.browseId;
  this.title = this.flex_columns[0].title.toString();
  const item_count_run = this.flex_columns.at(1)?.title.runs?.find((run) => run.text.match(/\d+ (song|songs)/));
  this.item_count = item_count_run ? item_count_run.text : void 0;
  const author_run = this.flex_columns.at(1)?.title.runs?.find((run) => isTextRun(run) && run.endpoint && run.endpoint.payload.browseId.startsWith("UC"));
  if (author_run && isTextRun(author_run)) {
    this.author = {
      name: author_run.text,
      channel_id: author_run.endpoint?.payload?.browseId,
      endpoint: author_run.endpoint
    };
  }
}, "#parsePlaylist");
__name(_MusicResponsiveListItem, "MusicResponsiveListItem");
__publicField(_MusicResponsiveListItem, "type", "MusicResponsiveListItem");
var MusicResponsiveListItem = _MusicResponsiveListItem;

// dist/src/parser/classes/MusicTwoRowItem.js
var _MusicTwoRowItem = class _MusicTwoRowItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "endpoint");
    __publicField(this, "id");
    __publicField(this, "subtitle");
    __publicField(this, "badges");
    __publicField(this, "item_type");
    __publicField(this, "subscribers");
    __publicField(this, "item_count");
    __publicField(this, "year");
    __publicField(this, "views");
    __publicField(this, "artists");
    __publicField(this, "author");
    __publicField(this, "thumbnail");
    __publicField(this, "thumbnail_overlay");
    __publicField(this, "menu");
    this.title = new Text2(data2.title);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.id = this.endpoint?.payload?.browseId || this.endpoint?.payload?.videoId;
    this.subtitle = new Text2(data2.subtitle);
    this.badges = parser_exports.parse(data2.subtitleBadges);
    const page_type = this.endpoint?.payload?.browseEndpointContextSupportedConfigs?.browseEndpointContextMusicConfig?.pageType;
    switch (page_type) {
      case "MUSIC_PAGE_TYPE_ARTIST":
        this.item_type = "artist";
        break;
      case "MUSIC_PAGE_TYPE_PLAYLIST":
        this.item_type = "playlist";
        break;
      case "MUSIC_PAGE_TYPE_ALBUM":
        this.item_type = "album";
        break;
      default:
        if (this.endpoint?.metadata?.api_url === "/next") {
          this.item_type = "endpoint";
        } else if (this.subtitle.runs?.[0]) {
          if (this.subtitle.runs[0].text !== "Song") {
            this.item_type = "video";
          } else {
            this.item_type = "song";
          }
        } else if (this.endpoint) {
          this.item_type = "endpoint";
        } else {
          this.item_type = "unknown";
        }
        break;
    }
    if (this.item_type == "artist") {
      this.subscribers = this.subtitle.runs?.find((run) => /^(\d*\.)?\d+[M|K]? subscribers?$/i.test(run.text))?.text || "";
    } else if (this.item_type == "playlist") {
      const item_count_run = this.subtitle.runs?.find((run) => run.text.match(/\d+ songs|song/));
      this.item_count = item_count_run ? item_count_run.text : null;
    } else if (this.item_type == "album") {
      const artists = this.subtitle.runs?.filter((run) => run.endpoint?.payload?.browseId.startsWith("UC"));
      if (artists) {
        this.artists = artists.map((artist) => ({
          name: artist.text,
          channel_id: artist.endpoint?.payload?.browseId,
          endpoint: artist.endpoint
        }));
      }
      this.year = this.subtitle.runs?.slice(-1)[0].text;
      if (isNaN(Number(this.year)))
        delete this.year;
    } else if (this.item_type == "video") {
      this.views = this?.subtitle.runs?.find((run) => run?.text.match(/(.*?) views/))?.text || "N/A";
      const author = this.subtitle.runs?.find((run) => run.endpoint?.payload?.browseId?.startsWith("UC"));
      if (author) {
        this.author = {
          name: author?.text,
          channel_id: author?.endpoint?.payload?.browseId,
          endpoint: author?.endpoint
        };
      }
    } else if (this.item_type == "song") {
      const artists = this.subtitle.runs?.filter((run) => run.endpoint?.payload?.browseId.startsWith("UC"));
      if (artists) {
        this.artists = artists.map((artist) => ({
          name: artist?.text,
          channel_id: artist?.endpoint?.payload?.browseId,
          endpoint: artist?.endpoint
        }));
      }
    }
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnailRenderer.musicThumbnailRenderer.thumbnail);
    this.thumbnail_overlay = parser_exports.parseItem(data2.thumbnailOverlay, MusicItemThumbnailOverlay);
    this.menu = parser_exports.parseItem(data2.menu, Menu);
  }
};
__name(_MusicTwoRowItem, "MusicTwoRowItem");
__publicField(_MusicTwoRowItem, "type", "MusicTwoRowItem");
var MusicTwoRowItem = _MusicTwoRowItem;

// dist/src/parser/classes/MusicCarouselShelf.js
var _MusicCarouselShelf = class _MusicCarouselShelf extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "contents");
    __publicField(this, "num_items_per_column");
    this.header = parser_exports.parseItem(data2.header, MusicCarouselShelfBasicHeader);
    this.contents = parser_exports.parseArray(data2.contents, [MusicTwoRowItem, MusicResponsiveListItem, MusicMultiRowListItem, MusicNavigationButton]);
    if (Reflect.has(data2, "numItemsPerColumn")) {
      this.num_items_per_column = parseInt(data2.numItemsPerColumn);
    }
  }
};
__name(_MusicCarouselShelf, "MusicCarouselShelf");
__publicField(_MusicCarouselShelf, "type", "MusicCarouselShelf");
var MusicCarouselShelf = _MusicCarouselShelf;

// dist/src/parser/classes/MusicDescriptionShelf.js
var _MusicDescriptionShelf = class _MusicDescriptionShelf extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "description");
    __publicField(this, "max_collapsed_lines");
    __publicField(this, "max_expanded_lines");
    __publicField(this, "footer");
    this.description = new Text2(data2.description);
    if (Reflect.has(data2, "maxCollapsedLines")) {
      this.max_collapsed_lines = data2.maxCollapsedLines;
    }
    if (Reflect.has(data2, "maxExpandedLines")) {
      this.max_expanded_lines = data2.maxExpandedLines;
    }
    this.footer = new Text2(data2.footer);
  }
};
__name(_MusicDescriptionShelf, "MusicDescriptionShelf");
__publicField(_MusicDescriptionShelf, "type", "MusicDescriptionShelf");
var MusicDescriptionShelf = _MusicDescriptionShelf;

// dist/src/parser/classes/MusicDetailHeader.js
var _MusicDetailHeader = class _MusicDetailHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "subtitle");
    __publicField(this, "second_subtitle");
    __publicField(this, "year");
    __publicField(this, "song_count");
    __publicField(this, "total_duration");
    __publicField(this, "thumbnails");
    __publicField(this, "badges");
    __publicField(this, "author");
    __publicField(this, "menu");
    this.title = new Text2(data2.title);
    this.description = new Text2(data2.description);
    this.subtitle = new Text2(data2.subtitle);
    this.second_subtitle = new Text2(data2.secondSubtitle);
    this.year = this.subtitle.runs?.find((run) => /^[12][0-9]{3}$/.test(run.text))?.text || "";
    this.song_count = this.second_subtitle.runs?.[0]?.text || "";
    this.total_duration = this.second_subtitle.runs?.[2]?.text || "";
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail.croppedSquareThumbnailRenderer.thumbnail);
    this.badges = parser_exports.parseArray(data2.subtitleBadges);
    const author = this.subtitle.runs?.find((run) => run?.endpoint?.payload?.browseId.startsWith("UC"));
    if (author) {
      this.author = {
        name: author.text,
        channel_id: author.endpoint?.payload?.browseId,
        endpoint: author.endpoint
      };
    }
    this.menu = parser_exports.parseItem(data2.menu);
  }
};
__name(_MusicDetailHeader, "MusicDetailHeader");
__publicField(_MusicDetailHeader, "type", "MusicDetailHeader");
var MusicDetailHeader = _MusicDetailHeader;

// dist/src/parser/classes/MusicDownloadStateBadge.js
var _MusicDownloadStateBadge = class _MusicDownloadStateBadge extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "playlist_id");
    __publicField(this, "supported_download_states");
    this.playlist_id = data2.playlistId;
    this.supported_download_states = data2.supportedDownloadStates;
  }
};
__name(_MusicDownloadStateBadge, "MusicDownloadStateBadge");
__publicField(_MusicDownloadStateBadge, "type", "MusicDownloadStateBadge");
var MusicDownloadStateBadge = _MusicDownloadStateBadge;

// dist/src/parser/classes/MusicEditablePlaylistDetailHeader.js
var _MusicEditablePlaylistDetailHeader = class _MusicEditablePlaylistDetailHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "edit_header");
    __publicField(this, "playlist_id");
    this.header = parser_exports.parseItem(data2.header);
    this.edit_header = parser_exports.parseItem(data2.editHeader);
    this.playlist_id = data2.playlistId;
  }
};
__name(_MusicEditablePlaylistDetailHeader, "MusicEditablePlaylistDetailHeader");
__publicField(_MusicEditablePlaylistDetailHeader, "type", "MusicEditablePlaylistDetailHeader");
var MusicEditablePlaylistDetailHeader = _MusicEditablePlaylistDetailHeader;

// dist/src/parser/classes/MusicElementHeader.js
var _MusicElementHeader = class _MusicElementHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "element");
    this.element = Reflect.has(data2, "elementRenderer") ? parser_exports.parseItem(data2, Element) : null;
  }
};
__name(_MusicElementHeader, "MusicElementHeader");
__publicField(_MusicElementHeader, "type", "MusicElementHeader");
var MusicElementHeader = _MusicElementHeader;

// dist/src/parser/classes/MusicHeader.js
var _MusicHeader = class _MusicHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "title");
    if (Reflect.has(data2, "header")) {
      this.header = parser_exports.parseItem(data2.header);
    }
    if (Reflect.has(data2, "title")) {
      this.title = new Text2(data2.title);
    }
  }
};
__name(_MusicHeader, "MusicHeader");
__publicField(_MusicHeader, "type", "MusicHeader");
var MusicHeader = _MusicHeader;

// dist/src/parser/classes/MusicImmersiveHeader.js
var _MusicImmersiveHeader = class _MusicImmersiveHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "menu");
    __publicField(this, "more_button");
    __publicField(this, "play_button");
    __publicField(this, "share_endpoint");
    __publicField(this, "start_radio_button");
    __publicField(this, "subscription_button");
    __publicField(this, "description");
    __publicField(this, "thumbnail");
    this.title = new Text2(data2.title);
    this.menu = parser_exports.parseItem(data2.menu, Menu);
    this.more_button = parser_exports.parseItem(data2.moreButton, ToggleButton);
    this.play_button = parser_exports.parseItem(data2.playButton, Button);
    if ("shareEndpoint" in data2)
      this.share_endpoint = new NavigationEndpoint(data2.shareEndpoint);
    this.start_radio_button = parser_exports.parseItem(data2.startRadioButton, Button);
    this.subscription_button = parser_exports.parseItem(data2.subscriptionButton, SubscribeButton);
    this.description = new Text2(data2.description);
    this.thumbnail = parser_exports.parseItem(data2.thumbnail, MusicThumbnail);
  }
};
__name(_MusicImmersiveHeader, "MusicImmersiveHeader");
__publicField(_MusicImmersiveHeader, "type", "MusicImmersiveHeader");
var MusicImmersiveHeader = _MusicImmersiveHeader;

// dist/src/parser/classes/MusicLargeCardItemCarousel.js
var _ActionButton = class _ActionButton {
  constructor(data2) {
    __publicField(this, "icon_name");
    __publicField(this, "endpoint");
    __publicField(this, "a11y_text");
    __publicField(this, "style");
    this.icon_name = data2.iconName;
    this.endpoint = new NavigationEndpoint(data2.onTap);
    this.a11y_text = data2.a11yText;
    this.style = data2.style;
  }
};
__name(_ActionButton, "ActionButton");
__publicField(_ActionButton, "type", "ActionButton");
var ActionButton = _ActionButton;
var _Panel2 = class _Panel2 {
  constructor(data2) {
    __publicField(this, "image");
    __publicField(this, "content_mode");
    __publicField(this, "crop_options");
    __publicField(this, "image_aspect_ratio");
    __publicField(this, "caption");
    __publicField(this, "action_buttons");
    this.image = Thumbnail.fromResponse(data2.image.image);
    this.content_mode = data2.image.contentMode;
    this.crop_options = data2.image.cropOptions;
    this.image_aspect_ratio = data2.imageAspectRatio;
    this.caption = data2.caption;
    this.action_buttons = data2.actionButtons.map((el) => new ActionButton(el));
  }
};
__name(_Panel2, "Panel");
__publicField(_Panel2, "type", "Panel");
var Panel2 = _Panel2;
var _MusicLargeCardItemCarousel = class _MusicLargeCardItemCarousel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "panels");
    __publicField(this, "header");
    this.header = data2.shelf.header;
    this.panels = data2.shelf.panels.map((el) => new Panel2(el));
  }
};
__name(_MusicLargeCardItemCarousel, "MusicLargeCardItemCarousel");
__publicField(_MusicLargeCardItemCarousel, "type", "MusicLargeCardItemCarousel");
var MusicLargeCardItemCarousel = _MusicLargeCardItemCarousel;

// dist/src/parser/classes/MusicPlaylistEditHeader.js
var _MusicPlaylistEditHeader = class _MusicPlaylistEditHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "edit_title");
    __publicField(this, "edit_description");
    __publicField(this, "privacy");
    __publicField(this, "playlist_id");
    __publicField(this, "endpoint");
    __publicField(this, "privacy_dropdown");
    this.title = new Text2(data2.title);
    this.edit_title = new Text2(data2.editTitle);
    this.edit_description = new Text2(data2.editDescription);
    this.privacy = data2.privacy;
    this.playlist_id = data2.playlistId;
    this.endpoint = new NavigationEndpoint(data2.collaborationSettingsCommand);
    this.privacy_dropdown = parser_exports.parseItem(data2.privacyDropdown, Dropdown);
  }
};
__name(_MusicPlaylistEditHeader, "MusicPlaylistEditHeader");
__publicField(_MusicPlaylistEditHeader, "type", "MusicPlaylistEditHeader");
var MusicPlaylistEditHeader = _MusicPlaylistEditHeader;

// dist/src/parser/classes/MusicPlaylistShelf.js
var _MusicPlaylistShelf = class _MusicPlaylistShelf extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "playlist_id");
    __publicField(this, "contents");
    __publicField(this, "collapsed_item_count");
    __publicField(this, "continuation");
    this.playlist_id = data2.playlistId;
    this.contents = parser_exports.parseArray(data2.contents, [MusicResponsiveListItem, ContinuationItem]);
    this.collapsed_item_count = data2.collapsedItemCount;
    this.continuation = data2.continuations?.[0]?.nextContinuationData?.continuation || null;
  }
};
__name(_MusicPlaylistShelf, "MusicPlaylistShelf");
__publicField(_MusicPlaylistShelf, "type", "MusicPlaylistShelf");
var MusicPlaylistShelf = _MusicPlaylistShelf;

// dist/src/parser/classes/PlaylistPanelVideo.js
var _PlaylistPanelVideo = class _PlaylistPanelVideo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "thumbnail");
    __publicField(this, "endpoint");
    __publicField(this, "selected");
    __publicField(this, "video_id");
    __publicField(this, "duration");
    __publicField(this, "author");
    __publicField(this, "album");
    __publicField(this, "artists");
    __publicField(this, "badges");
    __publicField(this, "menu");
    __publicField(this, "set_video_id");
    this.title = new Text2(data2.title);
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.selected = data2.selected;
    this.video_id = data2.videoId;
    this.duration = {
      text: new Text2(data2.lengthText).toString(),
      seconds: timeToSeconds(new Text2(data2.lengthText).toString())
    };
    const album = new Text2(data2.longBylineText).runs?.find((run) => run.endpoint?.payload?.browseId?.startsWith("MPR"));
    const artists = new Text2(data2.longBylineText).runs?.filter((run) => run.endpoint?.payload?.browseId?.startsWith("UC"));
    this.author = new Text2(data2.shortBylineText).toString();
    if (album) {
      this.album = {
        id: album.endpoint?.payload?.browseId,
        name: album.text,
        year: new Text2(data2.longBylineText).runs?.slice(-1)[0].text,
        endpoint: album.endpoint
      };
    }
    if (artists) {
      this.artists = artists.map((artist) => ({
        name: artist.text,
        channel_id: artist.endpoint?.payload?.browseId,
        endpoint: artist.endpoint
      }));
    }
    this.badges = parser_exports.parseArray(data2.badges);
    this.menu = parser_exports.parseItem(data2.menu);
    this.set_video_id = data2.playlistSetVideoId;
  }
};
__name(_PlaylistPanelVideo, "PlaylistPanelVideo");
__publicField(_PlaylistPanelVideo, "type", "PlaylistPanelVideo");
var PlaylistPanelVideo = _PlaylistPanelVideo;

// dist/src/parser/classes/PlaylistPanelVideoWrapper.js
var _PlaylistPanelVideoWrapper = class _PlaylistPanelVideoWrapper extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "primary");
    __publicField(this, "counterpart");
    this.primary = parser_exports.parseItem(data2.primaryRenderer, PlaylistPanelVideo);
    if (Reflect.has(data2, "counterpart")) {
      this.counterpart = observe(data2.counterpart.map((item) => parser_exports.parseItem(item.counterpartRenderer, PlaylistPanelVideo)) || []);
    }
  }
};
__name(_PlaylistPanelVideoWrapper, "PlaylistPanelVideoWrapper");
__publicField(_PlaylistPanelVideoWrapper, "type", "PlaylistPanelVideoWrapper");
var PlaylistPanelVideoWrapper = _PlaylistPanelVideoWrapper;

// dist/src/parser/classes/PlaylistPanel.js
var _PlaylistPanel = class _PlaylistPanel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "title_text");
    __publicField(this, "contents");
    __publicField(this, "playlist_id");
    __publicField(this, "is_infinite");
    __publicField(this, "continuation");
    __publicField(this, "is_editable");
    __publicField(this, "preview_description");
    __publicField(this, "num_items_to_show");
    this.title = data2.title;
    this.title_text = new Text2(data2.titleText);
    this.contents = parser_exports.parseArray(data2.contents, [PlaylistPanelVideoWrapper, PlaylistPanelVideo, AutomixPreviewVideo]);
    this.playlist_id = data2.playlistId;
    this.is_infinite = data2.isInfinite;
    this.continuation = data2.continuations?.[0]?.nextRadioContinuationData?.continuation || data2.continuations?.[0]?.nextContinuationData?.continuation;
    this.is_editable = data2.isEditable;
    this.preview_description = data2.previewDescription;
    this.num_items_to_show = data2.numItemsToShow;
  }
};
__name(_PlaylistPanel, "PlaylistPanel");
__publicField(_PlaylistPanel, "type", "PlaylistPanel");
var PlaylistPanel = _PlaylistPanel;

// dist/src/parser/classes/MusicQueue.js
var _MusicQueue = class _MusicQueue extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "content");
    this.content = parser_exports.parseItem(data2.content, PlaylistPanel);
  }
};
__name(_MusicQueue, "MusicQueue");
__publicField(_MusicQueue, "type", "MusicQueue");
var MusicQueue = _MusicQueue;

// dist/src/parser/classes/MusicResponsiveHeader.js
var _MusicResponsiveHeader = class _MusicResponsiveHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "buttons");
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "strapline_text_one");
    __publicField(this, "strapline_thumbnail");
    __publicField(this, "second_subtitle");
    __publicField(this, "subtitle_badge");
    __publicField(this, "description");
    this.thumbnail = parser_exports.parseItem(data2.thumbnail, MusicThumbnail);
    this.buttons = parser_exports.parseArray(data2.buttons, [DownloadButton, ToggleButton, MusicPlayButton, Button, Menu]);
    this.title = new Text2(data2.title);
    this.subtitle = new Text2(data2.subtitle);
    this.strapline_text_one = new Text2(data2.straplineTextOne);
    this.strapline_thumbnail = parser_exports.parseItem(data2.straplineThumbnail, MusicThumbnail);
    this.second_subtitle = new Text2(data2.secondSubtitle);
    if (Reflect.has(data2, "subtitleBadge")) {
      this.subtitle_badge = parser_exports.parseArray(data2.subtitleBadge, MusicInlineBadge);
    }
    if (Reflect.has(data2, "description")) {
      this.description = parser_exports.parseItem(data2.description, MusicDescriptionShelf);
    }
  }
};
__name(_MusicResponsiveHeader, "MusicResponsiveHeader");
__publicField(_MusicResponsiveHeader, "type", "MusicResponsiveHeader");
var MusicResponsiveHeader = _MusicResponsiveHeader;

// dist/src/parser/classes/MusicShelf.js
var _MusicShelf = class _MusicShelf extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "contents");
    __publicField(this, "endpoint");
    __publicField(this, "continuation");
    __publicField(this, "bottom_text");
    __publicField(this, "bottom_button");
    __publicField(this, "subheaders");
    this.title = new Text2(data2.title);
    this.contents = parser_exports.parseArray(data2.contents, MusicResponsiveListItem);
    if (Reflect.has(data2, "bottomEndpoint")) {
      this.endpoint = new NavigationEndpoint(data2.bottomEndpoint);
    }
    if (Reflect.has(data2, "continuations")) {
      this.continuation = data2.continuations?.[0].nextContinuationData?.continuation || data2.continuations?.[0].reloadContinuationData?.continuation;
    }
    if (Reflect.has(data2, "bottomText")) {
      this.bottom_text = new Text2(data2.bottomText);
    }
    if (Reflect.has(data2, "bottomButton")) {
      this.bottom_button = parser_exports.parseItem(data2.bottomButton, Button);
    }
    if (Reflect.has(data2, "subheaders")) {
      this.subheaders = parser_exports.parseArray(data2.subheaders);
    }
  }
};
__name(_MusicShelf, "MusicShelf");
__publicField(_MusicShelf, "type", "MusicShelf");
var MusicShelf = _MusicShelf;

// dist/src/parser/classes/MusicSideAlignedItem.js
var _MusicSideAlignedItem = class _MusicSideAlignedItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "start_items");
    __publicField(this, "end_items");
    if (Reflect.has(data2, "startItems")) {
      this.start_items = parser_exports.parseArray(data2.startItems);
    }
    if (Reflect.has(data2, "endItems")) {
      this.end_items = parser_exports.parseArray(data2.endItems);
    }
  }
};
__name(_MusicSideAlignedItem, "MusicSideAlignedItem");
__publicField(_MusicSideAlignedItem, "type", "MusicSideAlignedItem");
var MusicSideAlignedItem = _MusicSideAlignedItem;

// dist/src/parser/classes/MusicSortFilterButton.js
var _MusicSortFilterButton = class _MusicSortFilterButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "icon_type");
    __publicField(this, "menu");
    this.title = new Text2(data2.title).toString();
    if (Reflect.has(data2, "icon")) {
      this.icon_type = data2.icon.iconType;
    }
    this.menu = parser_exports.parseItem(data2.menu, MusicMultiSelectMenu);
  }
};
__name(_MusicSortFilterButton, "MusicSortFilterButton");
__publicField(_MusicSortFilterButton, "type", "MusicSortFilterButton");
var MusicSortFilterButton = _MusicSortFilterButton;

// dist/src/parser/classes/MusicTastebuilderShelfThumbnail.js
var _MusicTastebuilderShelfThumbnail = class _MusicTastebuilderShelfThumbnail extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
  }
};
__name(_MusicTastebuilderShelfThumbnail, "MusicTastebuilderShelfThumbnail");
__publicField(_MusicTastebuilderShelfThumbnail, "type", "MusicTastebuilderShelfThumbnail");
var MusicTastebuilderShelfThumbnail = _MusicTastebuilderShelfThumbnail;

// dist/src/parser/classes/MusicTastebuilderShelf.js
var _MusicTasteBuilderShelf = class _MusicTasteBuilderShelf extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "primary_text");
    __publicField(this, "secondary_text");
    __publicField(this, "action_button");
    __publicField(this, "is_visible");
    this.thumbnail = parser_exports.parseItem(data2.thumbnail, MusicTastebuilderShelfThumbnail);
    this.primary_text = new Text2(data2.primaryText);
    this.secondary_text = new Text2(data2.secondaryText);
    this.action_button = parser_exports.parseItem(data2.actionButton, Button);
    this.is_visible = data2.isVisible;
  }
};
__name(_MusicTasteBuilderShelf, "MusicTasteBuilderShelf");
__publicField(_MusicTasteBuilderShelf, "type", "MusicTasteBuilderShelf");
var MusicTasteBuilderShelf = _MusicTasteBuilderShelf;

// dist/src/parser/classes/MusicVisualHeader.js
var _MusicVisualHeader = class _MusicVisualHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "thumbnail");
    __publicField(this, "menu");
    __publicField(this, "foreground_thumbnail");
    this.title = new Text2(data2.title);
    this.thumbnail = data2.thumbnail ? Thumbnail.fromResponse(data2.thumbnail.musicThumbnailRenderer?.thumbnail) : [];
    this.menu = parser_exports.parseItem(data2.menu, Menu);
    this.foreground_thumbnail = data2.foregroundThumbnail ? Thumbnail.fromResponse(data2.foregroundThumbnail.musicThumbnailRenderer?.thumbnail) : [];
  }
};
__name(_MusicVisualHeader, "MusicVisualHeader");
__publicField(_MusicVisualHeader, "type", "MusicVisualHeader");
var MusicVisualHeader = _MusicVisualHeader;

// dist/src/parser/classes/mweb/MobileTopbar.js
var _MobileTopbar = class _MobileTopbar extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "placeholder_text");
    __publicField(this, "buttons");
    __publicField(this, "logo_type");
    this.placeholder_text = new Text2(data2.placeholderText);
    this.buttons = parser_exports.parseArray(data2.buttons);
    if (Reflect.has(data2, "logo") && Reflect.has(data2.logo, "iconType"))
      this.logo_type = data2.logo.iconType;
  }
};
__name(_MobileTopbar, "MobileTopbar");
__publicField(_MobileTopbar, "type", "MobileTopbar");
var MobileTopbar = _MobileTopbar;

// dist/src/parser/classes/mweb/MultiPageMenuSection.js
var _MultiPageMenuSection = class _MultiPageMenuSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data2.items);
  }
};
__name(_MultiPageMenuSection, "MultiPageMenuSection");
__publicField(_MultiPageMenuSection, "type", "MultiPageMenuSection");
var MultiPageMenuSection = _MultiPageMenuSection;

// dist/src/parser/classes/mweb/PivotBar.js
var _PivotBar = class _PivotBar extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data2.items);
  }
};
__name(_PivotBar, "PivotBar");
__publicField(_PivotBar, "type", "PivotBar");
var PivotBar = _PivotBar;

// dist/src/parser/classes/mweb/PivotBarItem.js
var _PivotBarItem = class _PivotBarItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "pivot_identifier");
    __publicField(this, "endpoint");
    __publicField(this, "title");
    __publicField(this, "accessibility_label");
    __publicField(this, "icon_type");
    __publicField(this, "accessibility");
    this.pivot_identifier = data2.pivotIdentifier;
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.title = new Text(data2.title);
    if ("accessibility" in data2 && "accessibilityData" in data2.accessibility) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data2.accessibility.accessibilityData)
      };
    }
    if (Reflect.has(data2, "icon") && Reflect.has(data2.icon, "iconType"))
      this.icon_type = data2.icon.iconType;
  }
  get label() {
    return this.accessibility?.accessibility_data?.label;
  }
};
__name(_PivotBarItem, "PivotBarItem");
__publicField(_PivotBarItem, "type", "PivotBarItem");
var PivotBarItem = _PivotBarItem;

// dist/src/parser/classes/mweb/TopbarMenuButton.js
var _TopbarMenuButton = class _TopbarMenuButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "icon_type");
    __publicField(this, "menu_renderer");
    __publicField(this, "target_id");
    if (Reflect.has(data2, "icon") && Reflect.has(data2.icon, "iconType"))
      this.icon_type = data2.icon.iconType;
    this.menu_renderer = parser_exports.parseItem(data2.menuRenderer);
    this.target_id = data2.targetId;
  }
};
__name(_TopbarMenuButton, "TopbarMenuButton");
__publicField(_TopbarMenuButton, "type", "TopbarMenuButton");
var TopbarMenuButton = _TopbarMenuButton;

// dist/src/parser/classes/NotificationAction.js
var _NotificationAction = class _NotificationAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "response_text");
    this.response_text = new Text2(data2.responseText);
  }
};
__name(_NotificationAction, "NotificationAction");
__publicField(_NotificationAction, "type", "NotificationAction");
var NotificationAction = _NotificationAction;

// dist/src/parser/classes/OpenOnePickAddVideoModalCommand.js
var _OpenOnePickAddVideoModalCommand = class _OpenOnePickAddVideoModalCommand extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "list_id");
    __publicField(this, "modal_title");
    __publicField(this, "select_button_label");
    this.list_id = data2.listId;
    this.modal_title = data2.modalTitle;
    this.select_button_label = data2.selectButtonLabel;
  }
};
__name(_OpenOnePickAddVideoModalCommand, "OpenOnePickAddVideoModalCommand");
__publicField(_OpenOnePickAddVideoModalCommand, "type", "OpenOnePickAddVideoModalCommand");
var OpenOnePickAddVideoModalCommand = _OpenOnePickAddVideoModalCommand;

// dist/src/parser/classes/PageHeaderView.js
var _PageHeaderView = class _PageHeaderView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "image");
    __publicField(this, "animated_image");
    __publicField(this, "hero_image");
    __publicField(this, "metadata");
    __publicField(this, "actions");
    __publicField(this, "description");
    __publicField(this, "attributation");
    __publicField(this, "banner");
    this.title = parser_exports.parseItem(data2.title, DynamicTextView);
    this.image = parser_exports.parseItem(data2.image, [ContentPreviewImageView, DecoratedAvatarView]);
    this.animated_image = parser_exports.parseItem(data2.animatedImage, ContentPreviewImageView);
    this.hero_image = parser_exports.parseItem(data2.heroImage, ContentPreviewImageView);
    this.metadata = parser_exports.parseItem(data2.metadata, ContentMetadataView);
    this.actions = parser_exports.parseItem(data2.actions, FlexibleActionsView);
    this.description = parser_exports.parseItem(data2.description, DescriptionPreviewView);
    this.attributation = parser_exports.parseItem(data2.attributation, AttributionView);
    this.banner = parser_exports.parseItem(data2.banner, ImageBannerView);
  }
};
__name(_PageHeaderView, "PageHeaderView");
__publicField(_PageHeaderView, "type", "PageHeaderView");
var PageHeaderView = _PageHeaderView;

// dist/src/parser/classes/PageHeader.js
var _PageHeader = class _PageHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "page_title");
    __publicField(this, "content");
    this.page_title = data2.pageTitle;
    this.content = parser_exports.parseItem(data2.content, PageHeaderView);
  }
};
__name(_PageHeader, "PageHeader");
__publicField(_PageHeader, "type", "PageHeader");
var PageHeader = _PageHeader;

// dist/src/parser/classes/PageIntroduction.js
var _PageIntroduction = class _PageIntroduction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header_text");
    __publicField(this, "body_text");
    __publicField(this, "page_title");
    __publicField(this, "header_icon_type");
    this.header_text = new Text2(data2.headerText).toString();
    this.body_text = new Text2(data2.bodyText).toString();
    this.page_title = new Text2(data2.pageTitle).toString();
    this.header_icon_type = data2.headerIcon.iconType;
  }
};
__name(_PageIntroduction, "PageIntroduction");
__publicField(_PageIntroduction, "type", "PageIntroduction");
var PageIntroduction = _PageIntroduction;

// dist/src/parser/classes/PivotButton.js
var _PivotButton = class _PivotButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "endpoint");
    __publicField(this, "content_description");
    __publicField(this, "target_id");
    __publicField(this, "sound_attribution_title");
    __publicField(this, "waveform_animation_style");
    __publicField(this, "background_animation_style");
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.endpoint = new NavigationEndpoint(data2.onClickCommand);
    this.content_description = new Text2(data2.contentDescription);
    this.target_id = data2.targetId;
    this.sound_attribution_title = new Text2(data2.soundAttributionTitle);
    this.waveform_animation_style = data2.waveformAnimationStyle;
    this.background_animation_style = data2.backgroundAnimationStyle;
  }
};
__name(_PivotButton, "PivotButton");
__publicField(_PivotButton, "type", "PivotButton");
var PivotButton = _PivotButton;

// dist/src/parser/classes/PlayerAnnotationsExpanded.js
var _PlayerAnnotationsExpanded = class _PlayerAnnotationsExpanded extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "featured_channel");
    __publicField(this, "allow_swipe_dismiss");
    __publicField(this, "annotation_id");
    if (Reflect.has(data2, "featuredChannel")) {
      this.featured_channel = {
        start_time_ms: data2.featuredChannel.startTimeMs,
        end_time_ms: data2.featuredChannel.endTimeMs,
        watermark: Thumbnail.fromResponse(data2.featuredChannel.watermark),
        channel_name: data2.featuredChannel.channelName,
        endpoint: new NavigationEndpoint(data2.featuredChannel.navigationEndpoint),
        subscribe_button: parser_exports.parseItem(data2.featuredChannel.subscribeButton)
      };
    }
    this.allow_swipe_dismiss = data2.allowSwipeDismiss;
    this.annotation_id = data2.annotationId;
  }
};
__name(_PlayerAnnotationsExpanded, "PlayerAnnotationsExpanded");
__publicField(_PlayerAnnotationsExpanded, "type", "PlayerAnnotationsExpanded");
var PlayerAnnotationsExpanded = _PlayerAnnotationsExpanded;

// dist/src/parser/classes/PlayerCaptionsTracklist.js
var _PlayerCaptionsTracklist = class _PlayerCaptionsTracklist extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "caption_tracks");
    __publicField(this, "audio_tracks");
    __publicField(this, "default_audio_track_index");
    __publicField(this, "translation_languages");
    if (Reflect.has(data2, "captionTracks")) {
      this.caption_tracks = data2.captionTracks.map((ct) => ({
        base_url: ct.baseUrl,
        name: new Text2(ct.name),
        vss_id: ct.vssId,
        language_code: ct.languageCode,
        kind: ct.kind,
        is_translatable: ct.isTranslatable
      }));
    }
    if (Reflect.has(data2, "audioTracks")) {
      this.audio_tracks = data2.audioTracks.map((at2) => ({
        audio_track_id: at2.audioTrackId,
        captions_initial_state: at2.captionsInitialState,
        default_caption_track_index: at2.defaultCaptionTrackIndex,
        has_default_track: at2.hasDefaultTrack,
        visibility: at2.visibility,
        caption_track_indices: at2.captionTrackIndices
      }));
    }
    if (Reflect.has(data2, "defaultAudioTrackIndex")) {
      this.default_audio_track_index = data2.defaultAudioTrackIndex;
    }
    if (Reflect.has(data2, "translationLanguages")) {
      this.translation_languages = data2.translationLanguages.map((tl) => ({
        language_code: tl.languageCode,
        language_name: new Text2(tl.languageName)
      }));
    }
  }
};
__name(_PlayerCaptionsTracklist, "PlayerCaptionsTracklist");
__publicField(_PlayerCaptionsTracklist, "type", "PlayerCaptionsTracklist");
var PlayerCaptionsTracklist = _PlayerCaptionsTracklist;

// dist/src/parser/classes/PlayerOverflow.js
var _PlayerOverflow = class _PlayerOverflow extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "endpoint");
    __publicField(this, "enable_listen_first");
    this.endpoint = new NavigationEndpoint(data2.endpoint);
    this.enable_listen_first = data2.enableListenFirst;
  }
};
__name(_PlayerOverflow, "PlayerOverflow");
__publicField(_PlayerOverflow, "type", "PlayerOverflow");
var PlayerOverflow = _PlayerOverflow;

// dist/src/parser/classes/PlayerControlsOverlay.js
var _PlayerControlsOverlay = class _PlayerControlsOverlay extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "overflow");
    this.overflow = parser_exports.parseItem(data2.overflow, PlayerOverflow);
  }
};
__name(_PlayerControlsOverlay, "PlayerControlsOverlay");
__publicField(_PlayerControlsOverlay, "type", "PlayerControlsOverlay");
var PlayerControlsOverlay = _PlayerControlsOverlay;

// dist/src/parser/classes/PlayerErrorMessage.js
var _PlayerErrorMessage = class _PlayerErrorMessage extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "subreason");
    __publicField(this, "reason");
    __publicField(this, "proceed_button");
    __publicField(this, "thumbnails");
    __publicField(this, "icon_type");
    this.subreason = new Text2(data2.subreason);
    this.reason = new Text2(data2.reason);
    this.proceed_button = parser_exports.parseItem(data2.proceedButton, Button);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    if (Reflect.has(data2, "icon")) {
      this.icon_type = data2.icon.iconType;
    }
  }
};
__name(_PlayerErrorMessage, "PlayerErrorMessage");
__publicField(_PlayerErrorMessage, "type", "PlayerErrorMessage");
var PlayerErrorMessage = _PlayerErrorMessage;

// dist/src/parser/classes/PlayerLegacyDesktopYpcOffer.js
var _PlayerLegacyDesktopYpcOffer = class _PlayerLegacyDesktopYpcOffer extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "thumbnail");
    __publicField(this, "offer_description");
    __publicField(this, "offer_id");
    this.title = data2.itemTitle;
    this.thumbnail = data2.itemThumbnail;
    this.offer_description = data2.offerDescription;
    this.offer_id = data2.offerId;
  }
};
__name(_PlayerLegacyDesktopYpcOffer, "PlayerLegacyDesktopYpcOffer");
__publicField(_PlayerLegacyDesktopYpcOffer, "type", "PlayerLegacyDesktopYpcOffer");
var PlayerLegacyDesktopYpcOffer = _PlayerLegacyDesktopYpcOffer;

// dist/src/parser/classes/YpcTrailer.js
var _YpcTrailer = class _YpcTrailer extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "video_message");
    __publicField(this, "player_response");
    this.video_message = data2.fullVideoMessage;
    this.player_response = data2.unserializedPlayerResponse;
  }
};
__name(_YpcTrailer, "YpcTrailer");
__publicField(_YpcTrailer, "type", "YpcTrailer");
var YpcTrailer = _YpcTrailer;

// dist/src/parser/classes/PlayerLegacyDesktopYpcTrailer.js
var _PlayerLegacyDesktopYpcTrailer = class _PlayerLegacyDesktopYpcTrailer extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "video_id");
    __publicField(this, "title");
    __publicField(this, "thumbnail");
    __publicField(this, "offer_headline");
    __publicField(this, "offer_description");
    __publicField(this, "offer_id");
    __publicField(this, "offer_button_text");
    __publicField(this, "video_message");
    __publicField(this, "trailer");
    this.video_id = data2.trailerVideoId;
    this.title = data2.itemTitle;
    this.thumbnail = data2.itemThumbnail;
    this.offer_headline = data2.offerHeadline;
    this.offer_description = data2.offerDescription;
    this.offer_id = data2.offerId;
    this.offer_button_text = data2.offerButtonText;
    this.video_message = data2.fullVideoMessage;
    this.trailer = parser_exports.parseItem(data2.ypcTrailer, YpcTrailer);
  }
};
__name(_PlayerLegacyDesktopYpcTrailer, "PlayerLegacyDesktopYpcTrailer");
__publicField(_PlayerLegacyDesktopYpcTrailer, "type", "PlayerLegacyDesktopYpcTrailer");
var PlayerLegacyDesktopYpcTrailer = _PlayerLegacyDesktopYpcTrailer;

// dist/src/parser/classes/PlayerLiveStoryboardSpec.js
var _PlayerLiveStoryboardSpec = class _PlayerLiveStoryboardSpec extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "board");
    const [template_url, thumbnail_width, thumbnail_height, columns, rows] = data2.spec.split("#");
    this.board = {
      type: "live",
      template_url,
      thumbnail_width: parseInt(thumbnail_width, 10),
      thumbnail_height: parseInt(thumbnail_height, 10),
      columns: parseInt(columns, 10),
      rows: parseInt(rows, 10)
    };
  }
};
__name(_PlayerLiveStoryboardSpec, "PlayerLiveStoryboardSpec");
__publicField(_PlayerLiveStoryboardSpec, "type", "PlayerLiveStoryboardSpec");
var PlayerLiveStoryboardSpec = _PlayerLiveStoryboardSpec;

// dist/src/parser/classes/PlayerMicroformat.js
var _PlayerMicroformat = class _PlayerMicroformat extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    __publicField(this, "thumbnails");
    __publicField(this, "embed");
    __publicField(this, "length_seconds");
    __publicField(this, "channel");
    __publicField(this, "is_family_safe");
    __publicField(this, "is_unlisted");
    __publicField(this, "has_ypc_metadata");
    __publicField(this, "view_count");
    __publicField(this, "category");
    __publicField(this, "publish_date");
    __publicField(this, "upload_date");
    __publicField(this, "available_countries");
    __publicField(this, "start_timestamp");
    __publicField(this, "end_timestamp");
    this.title = new Text2(data2.title);
    this.description = new Text2(data2.description);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    if (Reflect.has(data2, "embed")) {
      this.embed = {
        iframe_url: data2.embed.iframeUrl,
        flash_url: data2.embed.flashUrl,
        flash_secure_url: data2.embed.flashSecureUrl,
        width: data2.embed.width,
        height: data2.embed.height
      };
    }
    this.length_seconds = parseInt(data2.lengthSeconds);
    this.channel = {
      id: data2.externalChannelId,
      name: data2.ownerChannelName,
      url: data2.ownerProfileUrl
    };
    this.is_family_safe = !!data2.isFamilySafe;
    this.is_unlisted = !!data2.isUnlisted;
    this.has_ypc_metadata = !!data2.hasYpcMetadata;
    this.view_count = parseInt(data2.viewCount);
    this.category = data2.category;
    this.publish_date = data2.publishDate;
    this.upload_date = data2.uploadDate;
    this.available_countries = data2.availableCountries;
    this.start_timestamp = data2.liveBroadcastDetails?.startTimestamp ? new Date(data2.liveBroadcastDetails.startTimestamp) : null;
    this.end_timestamp = data2.liveBroadcastDetails?.endTimestamp ? new Date(data2.liveBroadcastDetails.endTimestamp) : null;
  }
};
__name(_PlayerMicroformat, "PlayerMicroformat");
__publicField(_PlayerMicroformat, "type", "PlayerMicroformat");
var PlayerMicroformat = _PlayerMicroformat;

// dist/src/parser/classes/PlayerOverlayAutoplay.js
var _PlayerOverlayAutoplay = class _PlayerOverlayAutoplay extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "video_id");
    __publicField(this, "video_title");
    __publicField(this, "short_view_count");
    // @TODO: Find out what these are.
    __publicField(this, "prefer_immediate_redirect");
    __publicField(this, "count_down_secs_for_fullscreen");
    __publicField(this, "published");
    __publicField(this, "background");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "author");
    __publicField(this, "cancel_button");
    __publicField(this, "next_button");
    __publicField(this, "close_button");
    this.title = new Text2(data2.title);
    this.video_id = data2.videoId;
    this.video_title = new Text2(data2.videoTitle);
    this.short_view_count = new Text2(data2.shortViewCountText);
    this.prefer_immediate_redirect = data2.preferImmediateRedirect;
    this.count_down_secs_for_fullscreen = data2.countDownSecsForFullscreen;
    this.published = new Text2(data2.publishedTimeText);
    this.background = Thumbnail.fromResponse(data2.background);
    this.thumbnail_overlays = parser_exports.parseArray(data2.thumbnailOverlays);
    this.author = new Author(data2.byline);
    this.cancel_button = parser_exports.parseItem(data2.cancelButton, Button);
    this.next_button = parser_exports.parseItem(data2.nextButton, Button);
    this.close_button = parser_exports.parseItem(data2.closeButton, Button);
  }
};
__name(_PlayerOverlayAutoplay, "PlayerOverlayAutoplay");
__publicField(_PlayerOverlayAutoplay, "type", "PlayerOverlayAutoplay");
var PlayerOverlayAutoplay = _PlayerOverlayAutoplay;

// dist/src/parser/classes/PlayerOverlayVideoDetails.js
var _PlayerOverlayVideoDetails = class _PlayerOverlayVideoDetails extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    this.title = new Text2(data2.title);
    this.subtitle = new Text2(data2.subtitle);
  }
};
__name(_PlayerOverlayVideoDetails, "PlayerOverlayVideoDetails");
__publicField(_PlayerOverlayVideoDetails, "type", "PlayerOverlayVideoDetails");
var PlayerOverlayVideoDetails = _PlayerOverlayVideoDetails;

// dist/src/parser/classes/WatchNextEndScreen.js
var _WatchNextEndScreen = class _WatchNextEndScreen extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "results");
    __publicField(this, "title");
    this.results = parser_exports.parseArray(data2.results, [EndScreenVideo, EndScreenPlaylist]);
    this.title = new Text2(data2.title).toString();
  }
};
__name(_WatchNextEndScreen, "WatchNextEndScreen");
__publicField(_WatchNextEndScreen, "type", "WatchNextEndScreen");
var WatchNextEndScreen = _WatchNextEndScreen;

// dist/src/parser/classes/PlayerOverlay.js
var _PlayerOverlay = class _PlayerOverlay extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "end_screen");
    __publicField(this, "autoplay");
    __publicField(this, "share_button");
    __publicField(this, "add_to_menu");
    __publicField(this, "fullscreen_engagement");
    __publicField(this, "actions");
    __publicField(this, "browser_media_session");
    __publicField(this, "decorated_player_bar");
    __publicField(this, "video_details");
    this.end_screen = parser_exports.parseItem(data2.endScreen, WatchNextEndScreen);
    this.autoplay = parser_exports.parseItem(data2.autoplay, PlayerOverlayAutoplay);
    this.share_button = parser_exports.parseItem(data2.shareButton, Button);
    this.add_to_menu = parser_exports.parseItem(data2.addToMenu, Menu);
    this.fullscreen_engagement = parser_exports.parseItem(data2.fullscreenEngagement);
    this.actions = parser_exports.parseArray(data2.actions);
    this.browser_media_session = parser_exports.parseItem(data2.browserMediaSession);
    this.decorated_player_bar = parser_exports.parseItem(data2.decoratedPlayerBarRenderer, DecoratedPlayerBar);
    this.video_details = parser_exports.parseItem(data2.videoDetails, PlayerOverlayVideoDetails);
  }
};
__name(_PlayerOverlay, "PlayerOverlay");
__publicField(_PlayerOverlay, "type", "PlayerOverlay");
var PlayerOverlay = _PlayerOverlay;

// dist/src/parser/classes/PlaylistHeader.js
var _PlaylistHeader = class _PlaylistHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "stats");
    __publicField(this, "brief_stats");
    __publicField(this, "author");
    __publicField(this, "description");
    __publicField(this, "num_videos");
    __publicField(this, "view_count");
    __publicField(this, "can_share");
    __publicField(this, "can_delete");
    __publicField(this, "is_editable");
    __publicField(this, "privacy");
    __publicField(this, "save_button");
    __publicField(this, "shuffle_play_button");
    __publicField(this, "menu");
    __publicField(this, "banner");
    this.id = data2.playlistId;
    this.title = new Text2(data2.title);
    this.subtitle = data2.subtitle ? new Text2(data2.subtitle) : null;
    this.stats = data2.stats.map((stat) => new Text2(stat));
    this.brief_stats = data2.briefStats.map((stat) => new Text2(stat));
    this.author = data2.ownerText || data2.ownerEndpoint ? new Author({ ...data2.ownerText, navigationEndpoint: data2.ownerEndpoint }, data2.ownerBadges, null) : null;
    this.description = new Text2(data2.descriptionText);
    this.num_videos = new Text2(data2.numVideosText);
    this.view_count = new Text2(data2.viewCountText);
    this.can_share = data2.shareData.canShare;
    this.can_delete = data2.editableDetails.canDelete;
    this.is_editable = data2.isEditable;
    this.privacy = data2.privacy;
    this.save_button = parser_exports.parseItem(data2.saveButton);
    this.shuffle_play_button = parser_exports.parseItem(data2.shufflePlayButton);
    this.menu = parser_exports.parseItem(data2.moreActionsMenu);
    this.banner = parser_exports.parseItem(data2.playlistHeaderBanner);
  }
};
__name(_PlaylistHeader, "PlaylistHeader");
__publicField(_PlaylistHeader, "type", "PlaylistHeader");
var PlaylistHeader = _PlaylistHeader;

// dist/src/parser/classes/PlaylistInfoCardContent.js
var _PlaylistInfoCardContent = class _PlaylistInfoCardContent extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "thumbnails");
    __publicField(this, "video_count");
    __publicField(this, "channel_name");
    __publicField(this, "endpoint");
    this.title = new Text2(data2.playlistTitle);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.video_count = new Text2(data2.playlistVideoCount);
    this.channel_name = new Text2(data2.channelName);
    this.endpoint = new NavigationEndpoint(data2.action);
  }
};
__name(_PlaylistInfoCardContent, "PlaylistInfoCardContent");
__publicField(_PlaylistInfoCardContent, "type", "PlaylistInfoCardContent");
var PlaylistInfoCardContent = _PlaylistInfoCardContent;

// dist/src/parser/classes/PlaylistMetadata.js
var _PlaylistMetadata = class _PlaylistMetadata extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "description");
    this.title = data2.title;
    this.description = data2.description || null;
  }
};
__name(_PlaylistMetadata, "PlaylistMetadata");
__publicField(_PlaylistMetadata, "type", "PlaylistMetadata");
var PlaylistMetadata = _PlaylistMetadata;

// dist/src/parser/classes/PlaylistSidebar.js
var _PlaylistSidebar = class _PlaylistSidebar extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data2.items);
  }
  // XXX: alias for consistency
  get contents() {
    return this.items;
  }
};
__name(_PlaylistSidebar, "PlaylistSidebar");
__publicField(_PlaylistSidebar, "type", "PlaylistSidebar");
var PlaylistSidebar = _PlaylistSidebar;

// dist/src/parser/classes/PlaylistSidebarPrimaryInfo.js
var _PlaylistSidebarPrimaryInfo = class _PlaylistSidebarPrimaryInfo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "stats");
    __publicField(this, "thumbnail_renderer");
    __publicField(this, "title");
    __publicField(this, "menu");
    __publicField(this, "endpoint");
    __publicField(this, "description");
    this.stats = data2.stats.map((stat) => new Text2(stat));
    this.thumbnail_renderer = parser_exports.parseItem(data2.thumbnailRenderer);
    this.title = new Text2(data2.title);
    this.menu = parser_exports.parseItem(data2.menu);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.description = new Text2(data2.description);
  }
};
__name(_PlaylistSidebarPrimaryInfo, "PlaylistSidebarPrimaryInfo");
__publicField(_PlaylistSidebarPrimaryInfo, "type", "PlaylistSidebarPrimaryInfo");
var PlaylistSidebarPrimaryInfo = _PlaylistSidebarPrimaryInfo;

// dist/src/parser/classes/PlaylistSidebarSecondaryInfo.js
var _PlaylistSidebarSecondaryInfo = class _PlaylistSidebarSecondaryInfo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "owner");
    __publicField(this, "button");
    this.owner = parser_exports.parseItem(data2.videoOwner);
    this.button = parser_exports.parseItem(data2.button);
  }
};
__name(_PlaylistSidebarSecondaryInfo, "PlaylistSidebarSecondaryInfo");
__publicField(_PlaylistSidebarSecondaryInfo, "type", "PlaylistSidebarSecondaryInfo");
var PlaylistSidebarSecondaryInfo = _PlaylistSidebarSecondaryInfo;

// dist/src/parser/classes/PlaylistThumbnailOverlay.js
var _PlaylistThumbnailOverlay = class _PlaylistThumbnailOverlay extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "icon_type");
    __publicField(this, "text");
    if (Reflect.has(data2, "icon"))
      this.icon_type = data2.icon.iconType;
    this.text = new Text2(data2.text);
  }
};
__name(_PlaylistThumbnailOverlay, "PlaylistThumbnailOverlay");
__publicField(_PlaylistThumbnailOverlay, "type", "PlaylistThumbnailOverlay");
var PlaylistThumbnailOverlay = _PlaylistThumbnailOverlay;

// dist/src/parser/classes/PlaylistVideo.js
var _PlaylistVideo = class _PlaylistVideo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "index");
    __publicField(this, "title");
    __publicField(this, "author");
    __publicField(this, "thumbnails");
    __publicField(this, "thumbnail_overlays");
    __publicField(this, "set_video_id");
    __publicField(this, "endpoint");
    __publicField(this, "is_playable");
    __publicField(this, "menu");
    __publicField(this, "upcoming");
    __publicField(this, "video_info");
    __publicField(this, "accessibility_label");
    __publicField(this, "style");
    __publicField(this, "duration");
    this.id = data2.videoId;
    this.index = new Text2(data2.index);
    this.title = new Text2(data2.title);
    this.author = new Author(data2.shortBylineText);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.thumbnail_overlays = parser_exports.parseArray(data2.thumbnailOverlays);
    this.set_video_id = data2?.setVideoId;
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.is_playable = data2.isPlayable;
    this.menu = parser_exports.parseItem(data2.menu, Menu);
    this.video_info = new Text2(data2.videoInfo);
    this.accessibility_label = data2.title.accessibility.accessibilityData.label;
    if (Reflect.has(data2, "style")) {
      this.style = data2.style;
    }
    const upcoming = data2.upcomingEventData && Number(`${data2.upcomingEventData.startTime}000`);
    if (upcoming) {
      this.upcoming = new Date(upcoming);
    }
    this.duration = {
      text: new Text2(data2.lengthText).toString(),
      seconds: parseInt(data2.lengthSeconds)
    };
  }
  get is_live() {
    return this.thumbnail_overlays.firstOfType(ThumbnailOverlayTimeStatus)?.style === "LIVE";
  }
  get is_upcoming() {
    return this.thumbnail_overlays.firstOfType(ThumbnailOverlayTimeStatus)?.style === "UPCOMING";
  }
};
__name(_PlaylistVideo, "PlaylistVideo");
__publicField(_PlaylistVideo, "type", "PlaylistVideo");
var PlaylistVideo = _PlaylistVideo;

// dist/src/parser/classes/PlaylistVideoList.js
var _PlaylistVideoList = class _PlaylistVideoList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "is_editable");
    __publicField(this, "can_reorder");
    __publicField(this, "videos");
    this.id = data2.playlistId;
    this.is_editable = data2.isEditable;
    this.can_reorder = data2.canReorder;
    this.videos = parser_exports.parseArray(data2.contents);
  }
};
__name(_PlaylistVideoList, "PlaylistVideoList");
__publicField(_PlaylistVideoList, "type", "PlaylistVideoList");
var PlaylistVideoList = _PlaylistVideoList;

// dist/src/parser/classes/Poll.js
var _Poll = class _Poll extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "choices");
    __publicField(this, "poll_type");
    __publicField(this, "total_votes");
    __publicField(this, "live_chat_poll_id");
    this.choices = data2.choices.map((choice) => ({
      text: new Text2(choice.text),
      select_endpoint: choice.selectServiceEndpoint ? new NavigationEndpoint(choice.selectServiceEndpoint) : null,
      deselect_endpoint: choice.deselectServiceEndpoint ? new NavigationEndpoint(choice.deselectServiceEndpoint) : null,
      vote_ratio_if_selected: choice?.voteRatioIfSelected || null,
      vote_percentage_if_selected: new Text2(choice.votePercentageIfSelected),
      vote_ratio_if_not_selected: choice?.voteRatioIfSelected || null,
      vote_percentage_if_not_selected: new Text2(choice.votePercentageIfSelected),
      image: choice.image ? Thumbnail.fromResponse(choice.image) : null
    }));
    if (Reflect.has(data2, "type"))
      this.poll_type = data2.type;
    if (Reflect.has(data2, "totalVotes"))
      this.total_votes = new Text2(data2.totalVotes);
    if (Reflect.has(data2, "liveChatPollId"))
      this.live_chat_poll_id = data2.liveChatPollId;
  }
};
__name(_Poll, "Poll");
__publicField(_Poll, "type", "Poll");
var Poll = _Poll;

// dist/src/parser/classes/Post.js
var _Post = class _Post extends BackstagePost {
  constructor(data2) {
    super(data2);
  }
};
__name(_Post, "Post");
__publicField(_Post, "type", "Post");
var Post = _Post;

// dist/src/parser/classes/PostMultiImage.js
var _PostMultiImage = class _PostMultiImage extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "images");
    this.images = parser_exports.parseArray(data2.images, BackstageImage);
  }
};
__name(_PostMultiImage, "PostMultiImage");
__publicField(_PostMultiImage, "type", "PostMultiImage");
var PostMultiImage = _PostMultiImage;

// dist/src/parser/classes/PremiereTrailerBadge.js
var _PremiereTrailerBadge = class _PremiereTrailerBadge extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "label");
    this.label = new Text2(data2.label);
  }
};
__name(_PremiereTrailerBadge, "PremiereTrailerBadge");
__publicField(_PremiereTrailerBadge, "type", "PremiereTrailerBadge");
var PremiereTrailerBadge = _PremiereTrailerBadge;

// dist/src/parser/classes/ProductListHeader.js
var _ProductListHeader = class _ProductListHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "suppress_padding_disclaimer");
    this.title = new Text2(data2.title);
    this.suppress_padding_disclaimer = !!data2.suppressPaddingDisclaimer;
  }
};
__name(_ProductListHeader, "ProductListHeader");
__publicField(_ProductListHeader, "type", "ProductListHeader");
var ProductListHeader = _ProductListHeader;

// dist/src/parser/classes/ProductListItem.js
var _ProductListItem = class _ProductListItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "accessibility_title");
    __publicField(this, "thumbnail");
    __publicField(this, "price");
    __publicField(this, "endpoint");
    __publicField(this, "merchant_name");
    __publicField(this, "stay_in_app");
    __publicField(this, "view_button");
    this.title = new Text2(data2.title);
    this.accessibility_title = data2.accessibilityTitle;
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.price = data2.price;
    this.endpoint = new NavigationEndpoint(data2.onClickCommand);
    this.merchant_name = data2.merchantName;
    this.stay_in_app = !!data2.stayInApp;
    this.view_button = parser_exports.parseItem(data2.viewButton, Button);
  }
};
__name(_ProductListItem, "ProductListItem");
__publicField(_ProductListItem, "type", "ProductListItem");
var ProductListItem = _ProductListItem;

// dist/src/parser/classes/ProfileColumn.js
var _ProfileColumn = class _ProfileColumn extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data2.items);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_ProfileColumn, "ProfileColumn");
__publicField(_ProfileColumn, "type", "ProfileColumn");
var ProfileColumn = _ProfileColumn;

// dist/src/parser/classes/ProfileColumnStats.js
var _ProfileColumnStats = class _ProfileColumnStats extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    this.items = parser_exports.parseArray(data2.items);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_ProfileColumnStats, "ProfileColumnStats");
__publicField(_ProfileColumnStats, "type", "ProfileColumnStats");
var ProfileColumnStats = _ProfileColumnStats;

// dist/src/parser/classes/ProfileColumnStatsEntry.js
var _ProfileColumnStatsEntry = class _ProfileColumnStatsEntry extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "label");
    __publicField(this, "value");
    this.label = new Text2(data2.label);
    this.value = new Text2(data2.value);
  }
};
__name(_ProfileColumnStatsEntry, "ProfileColumnStatsEntry");
__publicField(_ProfileColumnStatsEntry, "type", "ProfileColumnStatsEntry");
var ProfileColumnStatsEntry = _ProfileColumnStatsEntry;

// dist/src/parser/classes/ProfileColumnUserInfo.js
var _ProfileColumnUserInfo = class _ProfileColumnUserInfo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "thumbnails");
    this.title = new Text2(data2.title);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
  }
};
__name(_ProfileColumnUserInfo, "ProfileColumnUserInfo");
__publicField(_ProfileColumnUserInfo, "type", "ProfileColumnUserInfo");
var ProfileColumnUserInfo = _ProfileColumnUserInfo;

// dist/src/parser/classes/Quiz.js
var _Quiz = class _Quiz extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "choices");
    __publicField(this, "total_votes");
    this.choices = data2.choices.map((choice) => ({
      text: new Text2(choice.text),
      is_correct: choice.isCorrect
    }));
    this.total_votes = new Text2(data2.totalVotes);
  }
};
__name(_Quiz, "Quiz");
__publicField(_Quiz, "type", "Quiz");
var Quiz = _Quiz;

// dist/src/parser/classes/RecognitionShelf.js
var _RecognitionShelf = class _RecognitionShelf extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "avatars");
    __publicField(this, "button");
    __publicField(this, "surface");
    this.title = new Text2(data2.title);
    this.subtitle = new Text2(data2.subtitle);
    this.avatars = data2.avatars.map((avatar) => new Thumbnail(avatar));
    this.button = parser_exports.parseItem(data2.button, Button);
    this.surface = data2.surface;
  }
};
__name(_RecognitionShelf, "RecognitionShelf");
__publicField(_RecognitionShelf, "type", "RecognitionShelf");
var RecognitionShelf = _RecognitionShelf;

// dist/src/parser/classes/ReelItem.js
var _ReelItem = class _ReelItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "id");
    __publicField(this, "title");
    __publicField(this, "thumbnails");
    __publicField(this, "views");
    __publicField(this, "endpoint");
    __publicField(this, "accessibility");
    this.id = data2.videoId;
    this.title = new Text2(data2.headline);
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.views = new Text2(data2.viewCountText);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    if ("accessibility" in data2 && "accessibilityData" in data2.accessibility) {
      this.accessibility = {
        accessibility_data: new AccessibilityData(data2.accessibility.accessibilityData)
      };
    }
  }
  get label() {
    return this.accessibility?.accessibility_data?.label;
  }
};
__name(_ReelItem, "ReelItem");
__publicField(_ReelItem, "type", "ReelItem");
var ReelItem = _ReelItem;

// dist/src/parser/classes/ReelPlayerHeader.js
var _ReelPlayerHeader = class _ReelPlayerHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "reel_title_text");
    __publicField(this, "timestamp_text");
    __publicField(this, "channel_title_text");
    __publicField(this, "channel_thumbnail");
    __publicField(this, "author");
    this.reel_title_text = new Text2(data2.reelTitleText);
    this.timestamp_text = new Text2(data2.timestampText);
    this.channel_title_text = new Text2(data2.channelTitleText);
    this.channel_thumbnail = Thumbnail.fromResponse(data2.channelThumbnail);
    this.author = new Author(data2.channelNavigationEndpoint, void 0);
  }
};
__name(_ReelPlayerHeader, "ReelPlayerHeader");
__publicField(_ReelPlayerHeader, "type", "ReelPlayerHeader");
var ReelPlayerHeader = _ReelPlayerHeader;

// dist/src/parser/classes/ReelPlayerOverlay.js
var _ReelPlayerOverlay = class _ReelPlayerOverlay extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "like_button");
    __publicField(this, "reel_player_header_supported_renderers");
    __publicField(this, "menu");
    __publicField(this, "next_item_button");
    __publicField(this, "prev_item_button");
    __publicField(this, "subscribe_button_renderer");
    __publicField(this, "style");
    __publicField(this, "view_comments_button");
    __publicField(this, "share_button");
    __publicField(this, "pivot_button");
    __publicField(this, "info_panel");
    this.like_button = parser_exports.parseItem(data2.likeButton, LikeButton);
    this.reel_player_header_supported_renderers = parser_exports.parseItem(data2.reelPlayerHeaderSupportedRenderers, ReelPlayerHeader);
    this.menu = parser_exports.parseItem(data2.menu, Menu);
    this.next_item_button = parser_exports.parseItem(data2.nextItemButton, Button);
    this.prev_item_button = parser_exports.parseItem(data2.prevItemButton, Button);
    this.subscribe_button_renderer = parser_exports.parseItem(data2.subscribeButtonRenderer, [Button, SubscribeButton]);
    this.style = data2.style;
    this.view_comments_button = parser_exports.parseItem(data2.viewCommentsButton, Button);
    this.share_button = parser_exports.parseItem(data2.shareButton, Button);
    this.pivot_button = parser_exports.parseItem(data2.pivotButton, PivotButton);
    this.info_panel = parser_exports.parseItem(data2.infoPanel, InfoPanelContainer);
  }
};
__name(_ReelPlayerOverlay, "ReelPlayerOverlay");
__publicField(_ReelPlayerOverlay, "type", "ReelPlayerOverlay");
var ReelPlayerOverlay = _ReelPlayerOverlay;

// dist/src/parser/classes/RelatedChipCloud.js
var _RelatedChipCloud = class _RelatedChipCloud extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "content");
    this.content = parser_exports.parseItem(data2.content);
  }
};
__name(_RelatedChipCloud, "RelatedChipCloud");
__publicField(_RelatedChipCloud, "type", "RelatedChipCloud");
var RelatedChipCloud = _RelatedChipCloud;

// dist/src/parser/classes/RichGrid.js
var _RichGrid = class _RichGrid extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "contents");
    __publicField(this, "target_id");
    this.header = parser_exports.parseItem(data2.header);
    this.contents = parser_exports.parseArray(data2.contents);
    if (Reflect.has(data2, "targetId"))
      this.target_id = data2.targetId;
  }
};
__name(_RichGrid, "RichGrid");
__publicField(_RichGrid, "type", "RichGrid");
var RichGrid = _RichGrid;

// dist/src/parser/classes/RichItem.js
var _RichItem = class _RichItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "content");
    this.content = parser_exports.parseItem(data2.content);
  }
};
__name(_RichItem, "RichItem");
__publicField(_RichItem, "type", "RichItem");
var RichItem = _RichItem;

// dist/src/parser/classes/RichListHeader.js
var _RichListHeader = class _RichListHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "title_style");
    __publicField(this, "icon_type");
    this.title = new Text2(data2.title);
    this.subtitle = new Text2(data2.subtitle);
    if (Reflect.has(data2, "titleStyle")) {
      this.title_style = data2.titleStyle.style;
    }
    if (Reflect.has(data2, "icon")) {
      this.icon_type = data2.icon.iconType;
    }
  }
};
__name(_RichListHeader, "RichListHeader");
__publicField(_RichListHeader, "type", "RichListHeader");
var RichListHeader = _RichListHeader;

// dist/src/parser/classes/RichMetadata.js
var _RichMetadata = class _RichMetadata extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "call_to_action");
    __publicField(this, "icon_type");
    __publicField(this, "endpoint");
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.title = new Text2(data2.title);
    this.subtitle = new Text2(data2.subtitle);
    this.call_to_action = new Text2(data2.callToAction);
    if (Reflect.has(data2, "callToActionIcon")) {
      this.icon_type = data2.callToActionIcon.iconType;
    }
    this.endpoint = new NavigationEndpoint(data2.endpoint);
  }
};
__name(_RichMetadata, "RichMetadata");
__publicField(_RichMetadata, "type", "RichMetadata");
var RichMetadata = _RichMetadata;

// dist/src/parser/classes/RichMetadataRow.js
var _RichMetadataRow = class _RichMetadataRow extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data2.contents);
  }
};
__name(_RichMetadataRow, "RichMetadataRow");
__publicField(_RichMetadataRow, "type", "RichMetadataRow");
var RichMetadataRow = _RichMetadataRow;

// dist/src/parser/classes/RichSection.js
var _RichSection = class _RichSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "content");
    __publicField(this, "full_bleed");
    __publicField(this, "target_id");
    this.content = parser_exports.parseItem(data2.content);
    this.full_bleed = !!data2.fullBleed;
    if ("targetId" in data2) {
      this.target_id = data2.targetId;
    }
  }
};
__name(_RichSection, "RichSection");
__publicField(_RichSection, "type", "RichSection");
var RichSection = _RichSection;

// dist/src/parser/classes/RichShelf.js
var _RichShelf = class _RichShelf extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "contents");
    __publicField(this, "endpoint");
    __publicField(this, "subtitle");
    __publicField(this, "is_expanded");
    __publicField(this, "is_bottom_divider_hidden");
    __publicField(this, "is_top_divider_hidden");
    __publicField(this, "layout_sizing");
    __publicField(this, "icon_type");
    __publicField(this, "menu");
    __publicField(this, "next_button");
    __publicField(this, "previous_button");
    this.title = new Text2(data2.title);
    this.contents = parser_exports.parseArray(data2.contents);
    this.is_expanded = !!data2.is_expanded;
    this.is_bottom_divider_hidden = !!data2.isBottomDividerHidden;
    this.is_top_divider_hidden = !!data2.isTopDividerHidden;
    if ("endpoint" in data2) {
      this.endpoint = new NavigationEndpoint(data2.endpoint);
    }
    if ("subtitle" in data2) {
      this.subtitle = new Text2(data2.subtitle);
    }
    if ("layoutSizing" in data2) {
      this.layout_sizing = data2.layoutSizing;
    }
    if ("icon" in data2) {
      this.icon_type = data2.icon.iconType;
    }
    this.menu = parser_exports.parseItem(data2.menu);
    this.next_button = parser_exports.parseItem(data2.nextButton);
    this.previous_button = parser_exports.parseItem(data2.previousButton);
  }
};
__name(_RichShelf, "RichShelf");
__publicField(_RichShelf, "type", "RichShelf");
var RichShelf = _RichShelf;

// dist/src/parser/classes/SearchFilter.js
var _SearchFilter = class _SearchFilter extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "label");
    __publicField(this, "endpoint");
    __publicField(this, "tooltip");
    __publicField(this, "status");
    this.label = new Text2(data2.label);
    this.endpoint = new NavigationEndpoint(data2.endpoint || data2.navigationEndpoint);
    this.tooltip = data2.tooltip;
    if (Reflect.has(data2, "status")) {
      this.status = data2.status;
    }
  }
  get disabled() {
    return this.status === "FILTER_STATUS_DISABLED";
  }
  get selected() {
    return this.status === "FILTER_STATUS_SELECTED";
  }
};
__name(_SearchFilter, "SearchFilter");
__publicField(_SearchFilter, "type", "SearchFilter");
var SearchFilter2 = _SearchFilter;

// dist/src/parser/classes/SearchFilterGroup.js
var _SearchFilterGroup = class _SearchFilterGroup extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "filters");
    this.title = new Text2(data2.title);
    this.filters = parser_exports.parseArray(data2.filters, SearchFilter2);
  }
};
__name(_SearchFilterGroup, "SearchFilterGroup");
__publicField(_SearchFilterGroup, "type", "SearchFilterGroup");
var SearchFilterGroup = _SearchFilterGroup;

// dist/src/parser/classes/SearchFilterOptionsDialog.js
var _SearchFilterOptionsDialog = class _SearchFilterOptionsDialog extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "groups");
    this.title = new Text2(data2.title);
    this.groups = parser_exports.parseArray(data2.groups, SearchFilterGroup);
  }
};
__name(_SearchFilterOptionsDialog, "SearchFilterOptionsDialog");
__publicField(_SearchFilterOptionsDialog, "type", "SearchFilterOptionsDialog");
var SearchFilterOptionsDialog = _SearchFilterOptionsDialog;

// dist/src/parser/classes/SearchHeader.js
var _SearchHeader = class _SearchHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "chip_bar");
    __publicField(this, "search_filter_button");
    this.chip_bar = parser_exports.parseItem(data2.chipBar, ChipCloud);
    this.search_filter_button = parser_exports.parseItem(data2.searchFilterButton, Button);
  }
};
__name(_SearchHeader, "SearchHeader");
__publicField(_SearchHeader, "type", "SearchHeader");
var SearchHeader = _SearchHeader;

// dist/src/parser/classes/SearchSubMenu.js
var _SearchSubMenu = class _SearchSubMenu extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "groups");
    __publicField(this, "button");
    if (Reflect.has(data2, "title"))
      this.title = new Text2(data2.title);
    if (Reflect.has(data2, "groups"))
      this.groups = parser_exports.parseArray(data2.groups, SearchFilterGroup);
    if (Reflect.has(data2, "button"))
      this.button = parser_exports.parseItem(data2.button, ToggleButton);
  }
};
__name(_SearchSubMenu, "SearchSubMenu");
__publicField(_SearchSubMenu, "type", "SearchSubMenu");
var SearchSubMenu = _SearchSubMenu;

// dist/src/parser/classes/SearchSuggestionsSection.js
var _SearchSuggestionsSection = class _SearchSuggestionsSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data2.contents);
  }
};
__name(_SearchSuggestionsSection, "SearchSuggestionsSection");
__publicField(_SearchSuggestionsSection, "type", "SearchSuggestionsSection");
var SearchSuggestionsSection = _SearchSuggestionsSection;

// dist/src/parser/classes/UniversalWatchCard.js
var _UniversalWatchCard = class _UniversalWatchCard extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "call_to_action");
    __publicField(this, "sections");
    __publicField(this, "collapsed_label");
    this.header = parser_exports.parseItem(data2.header);
    this.call_to_action = parser_exports.parseItem(data2.callToAction);
    this.sections = parser_exports.parseArray(data2.sections);
    if (Reflect.has(data2, "collapsedLabel")) {
      this.collapsed_label = new Text2(data2.collapsedLabel);
    }
  }
};
__name(_UniversalWatchCard, "UniversalWatchCard");
__publicField(_UniversalWatchCard, "type", "UniversalWatchCard");
var UniversalWatchCard = _UniversalWatchCard;

// dist/src/parser/classes/SecondarySearchContainer.js
var _SecondarySearchContainer = class _SecondarySearchContainer extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "target_id");
    __publicField(this, "contents");
    this.contents = parser_exports.parseArray(data2.contents, [UniversalWatchCard]);
  }
};
__name(_SecondarySearchContainer, "SecondarySearchContainer");
__publicField(_SecondarySearchContainer, "type", "SecondarySearchContainer");
var SecondarySearchContainer = _SecondarySearchContainer;

// dist/src/parser/classes/SectionHeaderView.js
var _SectionHeaderView = class _SectionHeaderView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "headline");
    this.headline = Text2.fromAttributed(data2.headline);
  }
};
__name(_SectionHeaderView, "SectionHeaderView");
__publicField(_SectionHeaderView, "type", "SectionHeaderView");
var SectionHeaderView = _SectionHeaderView;

// dist/src/parser/classes/SegmentedLikeDislikeButton.js
var _SegmentedLikeDislikeButton = class _SegmentedLikeDislikeButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "like_button");
    __publicField(this, "dislike_button");
    this.like_button = parser_exports.parseItem(data2.likeButton, [ToggleButton, Button]);
    this.dislike_button = parser_exports.parseItem(data2.dislikeButton, [ToggleButton, Button]);
  }
};
__name(_SegmentedLikeDislikeButton, "SegmentedLikeDislikeButton");
__publicField(_SegmentedLikeDislikeButton, "type", "SegmentedLikeDislikeButton");
var SegmentedLikeDislikeButton = _SegmentedLikeDislikeButton;

// dist/src/parser/classes/SettingBoolean.js
var _SettingBoolean = class _SettingBoolean extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "summary");
    __publicField(this, "enable_endpoint");
    __publicField(this, "disable_endpoint");
    __publicField(this, "item_id");
    if (Reflect.has(data2, "title")) {
      this.title = new Text2(data2.title);
    }
    if (Reflect.has(data2, "summary")) {
      this.summary = new Text2(data2.summary);
    }
    if (Reflect.has(data2, "enableServiceEndpoint")) {
      this.enable_endpoint = new NavigationEndpoint(data2.enableServiceEndpoint);
    }
    if (Reflect.has(data2, "disableServiceEndpoint")) {
      this.disable_endpoint = new NavigationEndpoint(data2.disableServiceEndpoint);
    }
    this.item_id = data2.itemId;
  }
};
__name(_SettingBoolean, "SettingBoolean");
__publicField(_SettingBoolean, "type", "SettingBoolean");
var SettingBoolean = _SettingBoolean;

// dist/src/parser/classes/SettingsCheckbox.js
var _SettingsCheckbox = class _SettingsCheckbox extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "help_text");
    __publicField(this, "enabled");
    __publicField(this, "disabled");
    __publicField(this, "id");
    this.title = new Text2(data2.title);
    this.help_text = new Text2(data2.helpText);
    this.enabled = data2.enabled;
    this.disabled = data2.disabled;
    this.id = data2.id;
  }
};
__name(_SettingsCheckbox, "SettingsCheckbox");
__publicField(_SettingsCheckbox, "type", "SettingsCheckbox");
var SettingsCheckbox = _SettingsCheckbox;

// dist/src/parser/classes/SettingsSwitch.js
var _SettingsSwitch = class _SettingsSwitch extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "enabled");
    __publicField(this, "enable_endpoint");
    __publicField(this, "disable_endpoint");
    this.title = new Text2(data2.title);
    this.subtitle = new Text2(data2.subtitle);
    this.enabled = data2.enabled;
    this.enable_endpoint = new NavigationEndpoint(data2.enableServiceEndpoint);
    this.disable_endpoint = new NavigationEndpoint(data2.disableServiceEndpoint);
  }
};
__name(_SettingsSwitch, "SettingsSwitch");
__publicField(_SettingsSwitch, "type", "SettingsSwitch");
var SettingsSwitch = _SettingsSwitch;

// dist/src/parser/classes/SettingsOptions.js
var _SettingsOptions = class _SettingsOptions extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "text");
    __publicField(this, "options");
    this.title = new Text2(data2.title);
    if (Reflect.has(data2, "text")) {
      this.text = new Text2(data2.text).toString();
    }
    if (Reflect.has(data2, "options")) {
      this.options = parser_exports.parseArray(data2.options, [
        SettingsSwitch,
        Dropdown,
        CopyLink,
        SettingsCheckbox,
        ChannelOptions
      ]);
    }
  }
};
__name(_SettingsOptions, "SettingsOptions");
__publicField(_SettingsOptions, "type", "SettingsOptions");
var SettingsOptions = _SettingsOptions;

// dist/src/parser/classes/SettingsSidebar.js
var _SettingsSidebar = class _SettingsSidebar extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "items");
    this.title = new Text2(data2.title);
    this.items = parser_exports.parseArray(data2.items, CompactLink);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_SettingsSidebar, "SettingsSidebar");
__publicField(_SettingsSidebar, "type", "SettingsSidebar");
var SettingsSidebar = _SettingsSidebar;

// dist/src/parser/classes/SharedPost.js
var _SharedPost = class _SharedPost extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "content");
    __publicField(this, "published");
    __publicField(this, "menu");
    __publicField(this, "original_post");
    __publicField(this, "id");
    __publicField(this, "endpoint");
    __publicField(this, "expand_button");
    __publicField(this, "author");
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.content = new Text2(data2.content);
    this.published = new Text2(data2.publishedTimeText);
    this.menu = parser_exports.parseItem(data2.actionMenu, Menu);
    this.original_post = parser_exports.parseItem(data2.originalPost, [BackstagePost, Post]);
    this.id = data2.postId;
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.expand_button = parser_exports.parseItem(data2.expandButton, Button);
    this.author = new Author(data2.displayName, void 0);
  }
};
__name(_SharedPost, "SharedPost");
__publicField(_SharedPost, "type", "SharedPost");
var SharedPost = _SharedPost;

// dist/src/parser/classes/SharePanelHeader.js
var _SharePanelHeader = class _SharePanelHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    this.title = parser_exports.parseItem(data2.title);
  }
};
__name(_SharePanelHeader, "SharePanelHeader");
__publicField(_SharePanelHeader, "type", "SharePanelHeader");
var SharePanelHeader = _SharePanelHeader;

// dist/src/parser/classes/SharePanelTitleV15.js
var _SharePanelTitleV15 = class _SharePanelTitleV15 extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data2.title);
  }
};
__name(_SharePanelTitleV15, "SharePanelTitleV15");
__publicField(_SharePanelTitleV15, "type", "SharePanelTitleV15");
var SharePanelTitleV15 = _SharePanelTitleV15;

// dist/src/parser/classes/ShareTarget.js
var _ShareTarget = class _ShareTarget extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "endpoint");
    __publicField(this, "service_name");
    __publicField(this, "target_id");
    __publicField(this, "title");
    if (Reflect.has(data2, "serviceEndpoint"))
      this.endpoint = new NavigationEndpoint(data2.serviceEndpoint);
    else if (Reflect.has(data2, "navigationEndpoint"))
      this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.service_name = data2.serviceName;
    this.target_id = data2.targetId;
    this.title = new Text2(data2.title);
  }
};
__name(_ShareTarget, "ShareTarget");
__publicField(_ShareTarget, "type", "ShareTarget");
var ShareTarget = _ShareTarget;

// dist/src/parser/classes/Shelf.js
var _Shelf = class _Shelf extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "endpoint");
    __publicField(this, "content");
    __publicField(this, "icon_type");
    __publicField(this, "menu");
    __publicField(this, "play_all_button");
    __publicField(this, "subtitle");
    this.title = new Text2(data2.title);
    if (Reflect.has(data2, "endpoint")) {
      this.endpoint = new NavigationEndpoint(data2.endpoint);
    }
    this.content = parser_exports.parseItem(data2.content);
    if (Reflect.has(data2, "icon")) {
      this.icon_type = data2.icon.iconType;
    }
    if (Reflect.has(data2, "menu")) {
      this.menu = parser_exports.parseItem(data2.menu);
    }
    if (Reflect.has(data2, "playAllButton")) {
      this.play_all_button = parser_exports.parseItem(data2.playAllButton, Button);
    }
    if (Reflect.has(data2, "subtitle")) {
      this.subtitle = new Text2(data2.subtitle);
    }
  }
};
__name(_Shelf, "Shelf");
__publicField(_Shelf, "type", "Shelf");
var Shelf = _Shelf;

// dist/src/parser/classes/ShortsLockupView.js
var _ShortsLockupView = class _ShortsLockupView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "entity_id");
    __publicField(this, "accessibility_text");
    __publicField(this, "thumbnail");
    __publicField(this, "on_tap_endpoint");
    __publicField(this, "menu_on_tap");
    __publicField(this, "index_in_collection");
    __publicField(this, "menu_on_tap_a11y_label");
    __publicField(this, "overlay_metadata");
    __publicField(this, "inline_player_data");
    __publicField(this, "badge");
    this.entity_id = data2.entityId;
    this.accessibility_text = data2.accessibilityText;
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.on_tap_endpoint = new NavigationEndpoint(data2.onTap);
    this.menu_on_tap = new NavigationEndpoint(data2.menuOnTap);
    this.index_in_collection = data2.indexInCollection;
    this.menu_on_tap_a11y_label = data2.menuOnTapA11yLabel;
    this.overlay_metadata = {
      primary_text: data2.overlayMetadata.primaryText ? Text2.fromAttributed(data2.overlayMetadata.primaryText) : void 0,
      secondary_text: data2.overlayMetadata.secondaryText ? Text2.fromAttributed(data2.overlayMetadata.secondaryText) : void 0
    };
    if (data2.inlinePlayerData?.onVisible) {
      this.inline_player_data = new NavigationEndpoint(data2.inlinePlayerData.onVisible);
    }
    if (data2.badge) {
      this.badge = parser_exports.parseItem(data2.badge, BadgeView);
    }
  }
};
__name(_ShortsLockupView, "ShortsLockupView");
__publicField(_ShortsLockupView, "type", "ShortsLockupView");
var ShortsLockupView = _ShortsLockupView;

// dist/src/parser/classes/ShowingResultsFor.js
var _ShowingResultsFor = class _ShowingResultsFor extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "corrected_query");
    __publicField(this, "original_query");
    __publicField(this, "corrected_query_endpoint");
    __publicField(this, "original_query_endpoint");
    __publicField(this, "search_instead_for");
    __publicField(this, "showing_results_for");
    this.corrected_query = new Text2(data2.correctedQuery);
    this.original_query = new Text2(data2.originalQuery);
    this.corrected_query_endpoint = new NavigationEndpoint(data2.correctedQueryEndpoint);
    this.original_query_endpoint = new NavigationEndpoint(data2.originalQueryEndpoint);
    this.search_instead_for = new Text2(data2.searchInsteadFor);
    this.showing_results_for = new Text2(data2.showingResultsFor);
  }
};
__name(_ShowingResultsFor, "ShowingResultsFor");
__publicField(_ShowingResultsFor, "type", "ShowingResultsFor");
var ShowingResultsFor = _ShowingResultsFor;

// dist/src/parser/classes/SimpleCardContent.js
var _SimpleCardContent = class _SimpleCardContent extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "image");
    __publicField(this, "title");
    __publicField(this, "display_domain");
    __publicField(this, "show_link_icon");
    __publicField(this, "call_to_action");
    __publicField(this, "endpoint");
    this.image = Thumbnail.fromResponse(data2.image);
    this.title = new Text2(data2.title);
    this.display_domain = new Text2(data2.displayDomain);
    this.show_link_icon = data2.showLinkIcon;
    this.call_to_action = new Text2(data2.callToAction);
    this.endpoint = new NavigationEndpoint(data2.command);
  }
};
__name(_SimpleCardContent, "SimpleCardContent");
__publicField(_SimpleCardContent, "type", "SimpleCardContent");
var SimpleCardContent = _SimpleCardContent;

// dist/src/parser/classes/SimpleCardTeaser.js
var _SimpleCardTeaser = class _SimpleCardTeaser extends YTNode {
  // @TODO: or string?
  constructor(data2) {
    super();
    __publicField(this, "message");
    __publicField(this, "prominent");
    this.message = new Text2(data2.message);
    this.prominent = data2.prominent;
  }
};
__name(_SimpleCardTeaser, "SimpleCardTeaser");
__publicField(_SimpleCardTeaser, "type", "SimpleCardTeaser");
var SimpleCardTeaser = _SimpleCardTeaser;

// dist/src/parser/classes/SimpleTextSection.js
var _SimpleTextSection = class _SimpleTextSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "lines");
    __publicField(this, "style");
    this.lines = data2.lines.map((line) => new Text2(line));
    this.style = data2.layoutStyle;
  }
};
__name(_SimpleTextSection, "SimpleTextSection");
__publicField(_SimpleTextSection, "type", "SimpleTextSection");
var SimpleTextSection = _SimpleTextSection;

// dist/src/parser/classes/SingleActionEmergencySupport.js
var _SingleActionEmergencySupport = class _SingleActionEmergencySupport extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "action_text");
    __publicField(this, "nav_text");
    __publicField(this, "details");
    __publicField(this, "icon_type");
    __publicField(this, "endpoint");
    this.action_text = new Text2(data2.actionText);
    this.nav_text = new Text2(data2.navigationText);
    this.details = new Text2(data2.detailsText);
    this.icon_type = data2.icon.iconType;
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
  }
};
__name(_SingleActionEmergencySupport, "SingleActionEmergencySupport");
__publicField(_SingleActionEmergencySupport, "type", "SingleActionEmergencySupport");
var SingleActionEmergencySupport = _SingleActionEmergencySupport;

// dist/src/parser/classes/Tab.js
var _Tab = class _Tab extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "selected");
    __publicField(this, "endpoint");
    __publicField(this, "content");
    this.title = data2.title || "N/A";
    this.selected = !!data2.selected;
    this.endpoint = new NavigationEndpoint(data2.endpoint);
    this.content = parser_exports.parseItem(data2.content, [SectionList, MusicQueue, RichGrid]);
  }
};
__name(_Tab, "Tab");
__publicField(_Tab, "type", "Tab");
var Tab = _Tab;

// dist/src/parser/classes/SingleColumnBrowseResults.js
var _SingleColumnBrowseResults = class _SingleColumnBrowseResults extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "tabs");
    this.tabs = parser_exports.parseArray(data2.tabs, Tab);
  }
};
__name(_SingleColumnBrowseResults, "SingleColumnBrowseResults");
__publicField(_SingleColumnBrowseResults, "type", "SingleColumnBrowseResults");
var SingleColumnBrowseResults = _SingleColumnBrowseResults;

// dist/src/parser/classes/SingleColumnMusicWatchNextResults.js
var _SingleColumnMusicWatchNextResults = class _SingleColumnMusicWatchNextResults extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parse(data2);
  }
};
__name(_SingleColumnMusicWatchNextResults, "SingleColumnMusicWatchNextResults");
__publicField(_SingleColumnMusicWatchNextResults, "type", "SingleColumnMusicWatchNextResults");
var SingleColumnMusicWatchNextResults = _SingleColumnMusicWatchNextResults;

// dist/src/parser/classes/SingleHeroImage.js
var _SingleHeroImage = class _SingleHeroImage extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnails");
    __publicField(this, "style");
    this.thumbnails = Thumbnail.fromResponse(data2.thumbnail);
    this.style = data2.style;
  }
};
__name(_SingleHeroImage, "SingleHeroImage");
__publicField(_SingleHeroImage, "type", "SingleHeroImage");
var SingleHeroImage = _SingleHeroImage;

// dist/src/parser/classes/SlimOwner.js
var _SlimOwner = class _SlimOwner extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "thumbnail");
    __publicField(this, "title");
    __publicField(this, "endpoint");
    __publicField(this, "subscribe_button");
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.title = new Text2(data2.title);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.subscribe_button = parser_exports.parseItem(data2.subscribeButton, SubscribeButton);
  }
};
__name(_SlimOwner, "SlimOwner");
__publicField(_SlimOwner, "type", "SlimOwner");
var SlimOwner = _SlimOwner;

// dist/src/parser/classes/SlimVideoMetadata.js
var _SlimVideoMetadata = class _SlimVideoMetadata extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "collapsed_subtitle");
    __publicField(this, "expanded_subtitle");
    __publicField(this, "owner");
    __publicField(this, "description");
    __publicField(this, "video_id");
    __publicField(this, "date");
    this.title = new Text2(data2.title);
    this.collapsed_subtitle = new Text2(data2.collapsedSubtitle);
    this.expanded_subtitle = new Text2(data2.expandedSubtitle);
    this.owner = parser_exports.parseItem(data2.owner);
    this.description = new Text2(data2.description);
    this.video_id = data2.videoId;
    this.date = new Text2(data2.dateText);
  }
};
__name(_SlimVideoMetadata, "SlimVideoMetadata");
__publicField(_SlimVideoMetadata, "type", "SlimVideoMetadata");
var SlimVideoMetadata = _SlimVideoMetadata;

// dist/src/parser/classes/StartAt.js
var _StartAt = class _StartAt extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "start_at_option_label");
    this.start_at_option_label = new Text2(data2.startAtOptionLabel);
  }
};
__name(_StartAt, "StartAt");
__publicField(_StartAt, "type", "StartAt");
var StartAt = _StartAt;

// dist/src/parser/classes/Tabbed.js
var _Tabbed = class _Tabbed extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    this.contents = parser_exports.parse(data2);
  }
};
__name(_Tabbed, "Tabbed");
__publicField(_Tabbed, "type", "Tabbed");
var Tabbed = _Tabbed;

// dist/src/parser/classes/TabbedSearchResults.js
var _TabbedSearchResults = class _TabbedSearchResults extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "tabs");
    this.tabs = parser_exports.parseArray(data2.tabs, Tab);
  }
};
__name(_TabbedSearchResults, "TabbedSearchResults");
__publicField(_TabbedSearchResults, "type", "TabbedSearchResults");
var TabbedSearchResults = _TabbedSearchResults;

// dist/src/parser/classes/TextHeader.js
var _TextHeader = class _TextHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "style");
    this.title = new Text2(data2.title);
    this.style = data2.style;
  }
};
__name(_TextHeader, "TextHeader");
__publicField(_TextHeader, "type", "TextHeader");
var TextHeader = _TextHeader;

// dist/src/parser/classes/ThirdPartyShareTargetSection.js
var _ThirdPartyShareTargetSection = class _ThirdPartyShareTargetSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "share_targets");
    this.share_targets = parser_exports.parseArray(data2.shareTargets, ShareTarget);
  }
};
__name(_ThirdPartyShareTargetSection, "ThirdPartyShareTargetSection");
__publicField(_ThirdPartyShareTargetSection, "type", "ThirdPartyShareTargetSection");
var ThirdPartyShareTargetSection = _ThirdPartyShareTargetSection;

// dist/src/parser/classes/ThumbnailLandscapePortrait.js
var _ThumbnailLandscapePortrait = class _ThumbnailLandscapePortrait extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "landscape");
    __publicField(this, "portrait");
    this.landscape = Thumbnail.fromResponse(data2.landscape);
    this.portrait = Thumbnail.fromResponse(data2.portrait);
  }
};
__name(_ThumbnailLandscapePortrait, "ThumbnailLandscapePortrait");
__publicField(_ThumbnailLandscapePortrait, "type", "ThumbnailLandscapePortrait");
var ThumbnailLandscapePortrait = _ThumbnailLandscapePortrait;

// dist/src/parser/classes/ThumbnailOverlayEndorsement.js
var _ThumbnailOverlayEndorsement = class _ThumbnailOverlayEndorsement extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    this.text = new Text2(data2.text).toString();
  }
};
__name(_ThumbnailOverlayEndorsement, "ThumbnailOverlayEndorsement");
__publicField(_ThumbnailOverlayEndorsement, "type", "ThumbnailOverlayEndorsement");
var ThumbnailOverlayEndorsement = _ThumbnailOverlayEndorsement;

// dist/src/parser/classes/ThumbnailOverlayHoverText.js
var _ThumbnailOverlayHoverText = class _ThumbnailOverlayHoverText extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "icon_type");
    this.text = new Text2(data2.text);
    this.icon_type = data2.icon.iconType;
  }
};
__name(_ThumbnailOverlayHoverText, "ThumbnailOverlayHoverText");
__publicField(_ThumbnailOverlayHoverText, "type", "ThumbnailOverlayHoverText");
var ThumbnailOverlayHoverText = _ThumbnailOverlayHoverText;

// dist/src/parser/classes/ThumbnailOverlayInlineUnplayable.js
var _ThumbnailOverlayInlineUnplayable = class _ThumbnailOverlayInlineUnplayable extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "icon_type");
    this.text = new Text2(data2.text).toString();
    this.icon_type = data2.icon.iconType;
  }
};
__name(_ThumbnailOverlayInlineUnplayable, "ThumbnailOverlayInlineUnplayable");
__publicField(_ThumbnailOverlayInlineUnplayable, "type", "ThumbnailOverlayInlineUnplayable");
var ThumbnailOverlayInlineUnplayable = _ThumbnailOverlayInlineUnplayable;

// dist/src/parser/classes/ThumbnailOverlayLoadingPreview.js
var _ThumbnailOverlayLoadingPreview = class _ThumbnailOverlayLoadingPreview extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    this.text = new Text2(data2.text);
  }
};
__name(_ThumbnailOverlayLoadingPreview, "ThumbnailOverlayLoadingPreview");
__publicField(_ThumbnailOverlayLoadingPreview, "type", "ThumbnailOverlayLoadingPreview");
var ThumbnailOverlayLoadingPreview = _ThumbnailOverlayLoadingPreview;

// dist/src/parser/classes/ThumbnailOverlayNowPlaying.js
var _ThumbnailOverlayNowPlaying = class _ThumbnailOverlayNowPlaying extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    this.text = new Text2(data2.text).toString();
  }
};
__name(_ThumbnailOverlayNowPlaying, "ThumbnailOverlayNowPlaying");
__publicField(_ThumbnailOverlayNowPlaying, "type", "ThumbnailOverlayNowPlaying");
var ThumbnailOverlayNowPlaying = _ThumbnailOverlayNowPlaying;

// dist/src/parser/classes/ThumbnailOverlayPinking.js
var _ThumbnailOverlayPinking = class _ThumbnailOverlayPinking extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "hack");
    this.hack = data2.hack;
  }
};
__name(_ThumbnailOverlayPinking, "ThumbnailOverlayPinking");
__publicField(_ThumbnailOverlayPinking, "type", "ThumbnailOverlayPinking");
var ThumbnailOverlayPinking = _ThumbnailOverlayPinking;

// dist/src/parser/classes/ThumbnailOverlayPlaybackStatus.js
var _ThumbnailOverlayPlaybackStatus = class _ThumbnailOverlayPlaybackStatus extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "texts");
    this.texts = data2.texts.map((text) => new Text2(text));
  }
};
__name(_ThumbnailOverlayPlaybackStatus, "ThumbnailOverlayPlaybackStatus");
__publicField(_ThumbnailOverlayPlaybackStatus, "type", "ThumbnailOverlayPlaybackStatus");
var ThumbnailOverlayPlaybackStatus = _ThumbnailOverlayPlaybackStatus;

// dist/src/parser/classes/ThumbnailOverlayResumePlayback.js
var _ThumbnailOverlayResumePlayback = class _ThumbnailOverlayResumePlayback extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "percent_duration_watched");
    this.percent_duration_watched = data2.percentDurationWatched;
  }
};
__name(_ThumbnailOverlayResumePlayback, "ThumbnailOverlayResumePlayback");
__publicField(_ThumbnailOverlayResumePlayback, "type", "ThumbnailOverlayResumePlayback");
var ThumbnailOverlayResumePlayback = _ThumbnailOverlayResumePlayback;

// dist/src/parser/classes/ThumbnailOverlaySidePanel.js
var _ThumbnailOverlaySidePanel = class _ThumbnailOverlaySidePanel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "icon_type");
    this.text = new Text2(data2.text);
    this.icon_type = data2.icon.iconType;
  }
};
__name(_ThumbnailOverlaySidePanel, "ThumbnailOverlaySidePanel");
__publicField(_ThumbnailOverlaySidePanel, "type", "ThumbnailOverlaySidePanel");
var ThumbnailOverlaySidePanel = _ThumbnailOverlaySidePanel;

// dist/src/parser/classes/ThumbnailOverlayToggleButton.js
var _ThumbnailOverlayToggleButton = class _ThumbnailOverlayToggleButton extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "is_toggled");
    __publicField(this, "icon_type");
    __publicField(this, "tooltip");
    __publicField(this, "toggled_endpoint");
    __publicField(this, "untoggled_endpoint");
    if (Reflect.has(data2, "isToggled")) {
      this.is_toggled = data2.isToggled;
    }
    this.icon_type = {
      toggled: data2.toggledIcon.iconType,
      untoggled: data2.untoggledIcon.iconType
    };
    this.tooltip = {
      toggled: data2.toggledTooltip,
      untoggled: data2.untoggledTooltip
    };
    if (data2.toggledServiceEndpoint)
      this.toggled_endpoint = new NavigationEndpoint(data2.toggledServiceEndpoint);
    if (data2.untoggledServiceEndpoint)
      this.untoggled_endpoint = new NavigationEndpoint(data2.untoggledServiceEndpoint);
  }
};
__name(_ThumbnailOverlayToggleButton, "ThumbnailOverlayToggleButton");
__publicField(_ThumbnailOverlayToggleButton, "type", "ThumbnailOverlayToggleButton");
var ThumbnailOverlayToggleButton = _ThumbnailOverlayToggleButton;

// dist/src/parser/classes/TitleAndButtonListHeader.js
var _TitleAndButtonListHeader = class _TitleAndButtonListHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    this.title = new Text2(data2.title);
  }
};
__name(_TitleAndButtonListHeader, "TitleAndButtonListHeader");
__publicField(_TitleAndButtonListHeader, "type", "TitleAndButtonListHeader");
var TitleAndButtonListHeader = _TitleAndButtonListHeader;

// dist/src/parser/classes/ToggleFormField.js
var _ToggleFormField = class _ToggleFormField extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "label");
    __publicField(this, "toggled");
    __publicField(this, "toggle_on_action");
    __publicField(this, "toggle_off_action");
    this.label = new Text(data2.label);
    this.toggled = data2.toggled;
    if ("toggleOnAction" in data2)
      this.toggle_on_action = new NavigationEndpoint(data2.toggleOnAction);
    if ("toggleOffAction" in data2)
      this.toggle_off_action = new NavigationEndpoint(data2.toggleOffAction);
  }
};
__name(_ToggleFormField, "ToggleFormField");
__publicField(_ToggleFormField, "type", "ToggleFormField");
var ToggleFormField = _ToggleFormField;

// dist/src/parser/classes/ToggleMenuServiceItem.js
var _ToggleMenuServiceItem = class _ToggleMenuServiceItem extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "text");
    __publicField(this, "toggled_text");
    __publicField(this, "icon_type");
    __publicField(this, "toggled_icon_type");
    __publicField(this, "default_endpoint");
    __publicField(this, "toggled_endpoint");
    this.text = new Text2(data2.defaultText);
    this.toggled_text = new Text2(data2.toggledText);
    this.icon_type = data2.defaultIcon.iconType;
    this.toggled_icon_type = data2.toggledIcon.iconType;
    this.default_endpoint = new NavigationEndpoint(data2.defaultServiceEndpoint);
    this.toggled_endpoint = new NavigationEndpoint(data2.toggledServiceEndpoint);
  }
};
__name(_ToggleMenuServiceItem, "ToggleMenuServiceItem");
__publicField(_ToggleMenuServiceItem, "type", "ToggleMenuServiceItem");
var ToggleMenuServiceItem = _ToggleMenuServiceItem;

// dist/src/parser/classes/Tooltip.js
var _Tooltip = class _Tooltip extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "promo_config");
    __publicField(this, "target_id");
    __publicField(this, "details");
    __publicField(this, "suggested_position");
    __publicField(this, "dismiss_stratedy");
    __publicField(this, "dwell_time_ms");
    this.promo_config = {
      promo_id: data2.promoConfig.promoId,
      impression_endpoints: data2.promoConfig.impressionEndpoints.map((endpoint) => new NavigationEndpoint(endpoint)),
      accept: new NavigationEndpoint(data2.promoConfig.acceptCommand),
      dismiss: new NavigationEndpoint(data2.promoConfig.dismissCommand)
    };
    this.target_id = data2.targetId;
    this.details = new Text2(data2.detailsText);
    this.suggested_position = data2.suggestedPosition.type;
    this.dismiss_stratedy = data2.dismissStrategy.type;
    this.dwell_time_ms = parseInt(data2.dwellTimeMs);
  }
};
__name(_Tooltip, "Tooltip");
__publicField(_Tooltip, "type", "Tooltip");
var Tooltip = _Tooltip;

// dist/src/parser/classes/TopicChannelDetails.js
var _TopicChannelDetails = class _TopicChannelDetails extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "avatar");
    __publicField(this, "subtitle");
    __publicField(this, "subscribe_button");
    __publicField(this, "endpoint");
    this.title = new Text2(data2.title);
    this.avatar = Thumbnail.fromResponse(data2.thumbnail ?? data2.avatar);
    this.subtitle = new Text2(data2.subtitle);
    this.subscribe_button = parser_exports.parseItem(data2.subscribeButton, SubscribeButton);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
  }
};
__name(_TopicChannelDetails, "TopicChannelDetails");
__publicField(_TopicChannelDetails, "type", "TopicChannelDetails");
var TopicChannelDetails = _TopicChannelDetails;

// dist/src/parser/classes/TwoColumnBrowseResults.js
var _TwoColumnBrowseResults = class _TwoColumnBrowseResults extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "tabs");
    __publicField(this, "secondary_contents");
    this.tabs = parser_exports.parseArray(data2.tabs, [Tab, ExpandableTab]);
    this.secondary_contents = parser_exports.parseItem(data2.secondaryContents, [SectionList, BrowseFeedActions, ProfileColumn]);
  }
};
__name(_TwoColumnBrowseResults, "TwoColumnBrowseResults");
__publicField(_TwoColumnBrowseResults, "type", "TwoColumnBrowseResults");
var TwoColumnBrowseResults = _TwoColumnBrowseResults;

// dist/src/parser/classes/TwoColumnSearchResults.js
var _TwoColumnSearchResults = class _TwoColumnSearchResults extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "header");
    __publicField(this, "primary_contents");
    __publicField(this, "secondary_contents");
    __publicField(this, "target_id");
    this.header = parser_exports.parseItem(data2.header);
    this.primary_contents = parser_exports.parseItem(data2.primaryContents, [RichGrid, SectionList]);
    this.secondary_contents = parser_exports.parseItem(data2.secondaryContents, [SecondarySearchContainer]);
    if ("targetId" in data2) {
      this.target_id = data2.targetId;
    }
  }
};
__name(_TwoColumnSearchResults, "TwoColumnSearchResults");
__publicField(_TwoColumnSearchResults, "type", "TwoColumnSearchResults");
var TwoColumnSearchResults = _TwoColumnSearchResults;

// dist/src/parser/classes/TwoColumnWatchNextResults.js
var _TwoColumnWatchNextResults_instances, parseAutoplaySet_fn;
var _TwoColumnWatchNextResults = class _TwoColumnWatchNextResults extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _TwoColumnWatchNextResults_instances);
    __publicField(this, "results");
    __publicField(this, "secondary_results");
    __publicField(this, "conversation_bar");
    __publicField(this, "playlist");
    __publicField(this, "autoplay");
    this.results = parser_exports.parseArray(data2.results?.results.contents);
    this.secondary_results = parser_exports.parseArray(data2.secondaryResults?.secondaryResults.results);
    this.conversation_bar = parser_exports.parseItem(data2?.conversationBar);
    const playlistData = data2.playlist?.playlist;
    if (playlistData) {
      this.playlist = {
        id: playlistData.playlistId,
        title: playlistData.title,
        author: playlistData.shortBylineText?.simpleText ? new Text2(playlistData.shortBylineText) : new Author(playlistData.longBylineText),
        contents: parser_exports.parseArray(playlistData.contents),
        current_index: playlistData.currentIndex,
        is_infinite: !!playlistData.isInfinite,
        menu: parser_exports.parseItem(playlistData.menu, Menu)
      };
    }
    const autoplayData = data2.autoplay?.autoplay;
    if (autoplayData) {
      this.autoplay = {
        sets: autoplayData.sets.map((set) => __privateMethod(this, _TwoColumnWatchNextResults_instances, parseAutoplaySet_fn).call(this, set))
      };
      if (autoplayData.modifiedSets) {
        this.autoplay.modified_sets = autoplayData.modifiedSets.map((set) => __privateMethod(this, _TwoColumnWatchNextResults_instances, parseAutoplaySet_fn).call(this, set));
      }
      if (autoplayData.countDownSecs) {
        this.autoplay.count_down_secs = autoplayData.countDownSecs;
      }
    }
  }
};
_TwoColumnWatchNextResults_instances = new WeakSet();
parseAutoplaySet_fn = /* @__PURE__ */ __name(function(data2) {
  const result = {
    autoplay_video: new NavigationEndpoint(data2.autoplayVideo)
  };
  if (data2.nextButtonVideo) {
    result.next_button_video = new NavigationEndpoint(data2.nextButtonVideo);
  }
  return result;
}, "#parseAutoplaySet");
__name(_TwoColumnWatchNextResults, "TwoColumnWatchNextResults");
__publicField(_TwoColumnWatchNextResults, "type", "TwoColumnWatchNextResults");
var TwoColumnWatchNextResults = _TwoColumnWatchNextResults;

// dist/src/parser/classes/UnifiedSharePanel.js
var _UnifiedSharePanel = class _UnifiedSharePanel extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "third_party_network_section");
    __publicField(this, "header");
    __publicField(this, "share_panel_version");
    __publicField(this, "show_loading_spinner");
    if (data2.contents) {
      const contents = data2.contents.find((content) => content.thirdPartyNetworkSection);
      if (contents) {
        this.third_party_network_section = {
          share_target_container: parser_exports.parseItem(contents.thirdPartyNetworkSection.shareTargetContainer, ThirdPartyShareTargetSection),
          copy_link_container: parser_exports.parseItem(contents.thirdPartyNetworkSection.copyLinkContainer, CopyLink),
          start_at_container: parser_exports.parseItem(contents.thirdPartyNetworkSection.startAtContainer, StartAt)
        };
      }
    }
    this.header = parser_exports.parseItem(data2.header, SharePanelHeader);
    this.share_panel_version = data2.sharePanelVersion;
    if (Reflect.has(data2, "showLoadingSpinner"))
      this.show_loading_spinner = data2.showLoadingSpinner;
  }
};
__name(_UnifiedSharePanel, "UnifiedSharePanel");
__publicField(_UnifiedSharePanel, "type", "UnifiedSharePanel");
var UnifiedSharePanel = _UnifiedSharePanel;

// dist/src/parser/classes/UpsellDialog.js
var _UpsellDialog = class _UpsellDialog extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "message_title");
    __publicField(this, "message_text");
    __publicField(this, "action_button");
    __publicField(this, "dismiss_button");
    __publicField(this, "is_visible");
    this.message_title = new Text2(data2.dialogMessageTitle);
    this.message_text = new Text2(data2.dialogMessageText);
    this.action_button = parser_exports.parseItem(data2.actionButton, Button);
    this.dismiss_button = parser_exports.parseItem(data2.dismissButton, Button);
    this.is_visible = data2.isVisible;
  }
};
__name(_UpsellDialog, "UpsellDialog");
__publicField(_UpsellDialog, "type", "UpsellDialog");
var UpsellDialog = _UpsellDialog;

// dist/src/parser/classes/VerticalList.js
var _VerticalList = class _VerticalList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    __publicField(this, "collapsed_item_count");
    // Number?
    __publicField(this, "collapsed_state_button_text");
    this.items = parser_exports.parseArray(data2.items);
    this.collapsed_item_count = data2.collapsedItemCount;
    this.collapsed_state_button_text = new Text2(data2.collapsedStateButtonText);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_VerticalList, "VerticalList");
__publicField(_VerticalList, "type", "VerticalList");
var VerticalList = _VerticalList;

// dist/src/parser/classes/VerticalWatchCardList.js
var _VerticalWatchCardList = class _VerticalWatchCardList extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "items");
    __publicField(this, "view_all_text");
    __publicField(this, "view_all_endpoint");
    this.items = parser_exports.parseArray(data2.items);
    this.view_all_text = new Text2(data2.viewAllText);
    this.view_all_endpoint = new NavigationEndpoint(data2.viewAllEndpoint);
  }
  // XXX: Alias for consistency.
  get contents() {
    return this.items;
  }
};
__name(_VerticalWatchCardList, "VerticalWatchCardList");
__publicField(_VerticalWatchCardList, "type", "VerticalWatchCardList");
var VerticalWatchCardList = _VerticalWatchCardList;

// dist/src/parser/classes/VideoInfoCardContent.js
var _VideoInfoCardContent = class _VideoInfoCardContent extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "channel_name");
    __publicField(this, "view_count");
    __publicField(this, "video_thumbnails");
    __publicField(this, "duration");
    __publicField(this, "endpoint");
    this.title = new Text2(data2.videoTitle);
    this.channel_name = new Text2(data2.channelName);
    this.view_count = new Text2(data2.viewCountText);
    this.video_thumbnails = Thumbnail.fromResponse(data2.videoThumbnail);
    this.duration = new Text2(data2.lengthString);
    this.endpoint = new NavigationEndpoint(data2.action);
  }
};
__name(_VideoInfoCardContent, "VideoInfoCardContent");
__publicField(_VideoInfoCardContent, "type", "VideoInfoCardContent");
var VideoInfoCardContent = _VideoInfoCardContent;

// dist/src/parser/classes/VideoMetadataCarouselView.js
var _VideoMetadataCarouselView = class _VideoMetadataCarouselView extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "carousel_titles");
    __publicField(this, "carousel_items");
    this.carousel_titles = parser_exports.parse(data2.carouselTitles, true, CarouselTitleView);
    this.carousel_items = parser_exports.parse(data2.carouselItems, true, CarouselItemView);
  }
};
__name(_VideoMetadataCarouselView, "VideoMetadataCarouselView");
__publicField(_VideoMetadataCarouselView, "type", "VideoMetadataCarouselView");
var VideoMetadataCarouselView = _VideoMetadataCarouselView;

// dist/src/parser/classes/misc/SubscriptionButton.js
var _SubscriptionButton = class _SubscriptionButton {
  constructor(data2) {
    __publicField(this, "text");
    __publicField(this, "subscribed");
    __publicField(this, "subscription_type");
    this.text = new Text2(data2.text);
    this.subscribed = data2.isSubscribed;
    if ("subscriptionType" in data2)
      this.subscription_type = data2.subscriptionType;
  }
};
__name(_SubscriptionButton, "SubscriptionButton");
__publicField(_SubscriptionButton, "type", "SubscriptionButton");
var SubscriptionButton = _SubscriptionButton;

// dist/src/parser/classes/VideoOwner.js
var _VideoOwner = class _VideoOwner extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "subscription_button");
    __publicField(this, "subscriber_count");
    __publicField(this, "author");
    if ("subscriptionButton" in data2)
      this.subscription_button = new SubscriptionButton(data2.subscriptionButton);
    this.subscriber_count = new Text2(data2.subscriberCountText);
    this.author = new Author({
      ...data2.title,
      navigationEndpoint: data2.navigationEndpoint
    }, data2.badges, data2.thumbnail);
  }
};
__name(_VideoOwner, "VideoOwner");
__publicField(_VideoOwner, "type", "VideoOwner");
var VideoOwner = _VideoOwner;

// dist/src/parser/classes/VideoViewCount.js
var _VideoViewCount = class _VideoViewCount extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "original_view_count");
    __publicField(this, "short_view_count");
    __publicField(this, "extra_short_view_count");
    __publicField(this, "view_count");
    this.original_view_count = data2.originalViewCount;
    this.short_view_count = new Text2(data2.shortViewCount);
    this.extra_short_view_count = new Text2(data2.extraShortViewCount);
    this.view_count = new Text2(data2.viewCount);
  }
};
__name(_VideoViewCount, "VideoViewCount");
__publicField(_VideoViewCount, "type", "VideoViewCount");
var VideoViewCount = _VideoViewCount;

// dist/src/parser/classes/VideoPrimaryInfo.js
var _VideoPrimaryInfo = class _VideoPrimaryInfo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "super_title_link");
    __publicField(this, "station_name");
    __publicField(this, "view_count");
    __publicField(this, "badges");
    __publicField(this, "published");
    __publicField(this, "relative_date");
    __publicField(this, "menu");
    this.title = new Text2(data2.title);
    if ("superTitleLink" in data2)
      this.super_title_link = new Text2(data2.superTitleLink);
    if ("stationName" in data2)
      this.station_name = new Text2(data2.stationName);
    this.view_count = parser_exports.parseItem(data2.viewCount, VideoViewCount);
    this.badges = parser_exports.parseArray(data2.badges, MetadataBadge);
    this.published = new Text2(data2.dateText);
    this.relative_date = new Text2(data2.relativeDateText);
    this.menu = parser_exports.parseItem(data2.videoActions, Menu);
  }
};
__name(_VideoPrimaryInfo, "VideoPrimaryInfo");
__publicField(_VideoPrimaryInfo, "type", "VideoPrimaryInfo");
var VideoPrimaryInfo = _VideoPrimaryInfo;

// dist/src/parser/classes/VideoSecondaryInfo.js
var _VideoSecondaryInfo = class _VideoSecondaryInfo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "owner");
    __publicField(this, "description");
    __publicField(this, "description_placeholder");
    __publicField(this, "subscribe_button");
    __publicField(this, "metadata");
    __publicField(this, "show_more_text");
    __publicField(this, "show_less_text");
    __publicField(this, "default_expanded");
    __publicField(this, "description_collapsed_lines");
    this.owner = parser_exports.parseItem(data2.owner, VideoOwner);
    this.description = new Text2(data2.description);
    if ("attributedDescription" in data2)
      this.description = Text2.fromAttributed(data2.attributedDescription);
    if ("descriptionPlaceholder" in data2)
      this.description_placeholder = new Text2(data2.descriptionPlaceholder);
    this.subscribe_button = parser_exports.parseItem(data2.subscribeButton, [SubscribeButton, Button]);
    this.metadata = parser_exports.parseItem(data2.metadataRowContainer, MetadataRowContainer);
    this.show_more_text = new Text2(data2.showMoreText);
    this.show_less_text = new Text2(data2.showLessText);
    this.default_expanded = data2.defaultExpanded;
    this.description_collapsed_lines = data2.descriptionCollapsedLines;
  }
};
__name(_VideoSecondaryInfo, "VideoSecondaryInfo");
__publicField(_VideoSecondaryInfo, "type", "VideoSecondaryInfo");
var VideoSecondaryInfo = _VideoSecondaryInfo;

// dist/src/parser/classes/WatchCardCompactVideo.js
var _WatchCardCompactVideo = class _WatchCardCompactVideo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "subtitle");
    __publicField(this, "duration");
    __publicField(this, "style");
    this.title = new Text2(data2.title);
    this.subtitle = new Text2(data2.subtitle);
    this.duration = {
      text: new Text2(data2.lengthText).toString(),
      seconds: timeToSeconds(data2.lengthText.simpleText)
    };
    this.style = data2.style;
  }
};
__name(_WatchCardCompactVideo, "WatchCardCompactVideo");
__publicField(_WatchCardCompactVideo, "type", "WatchCardCompactVideo");
var WatchCardCompactVideo = _WatchCardCompactVideo;

// dist/src/parser/classes/WatchCardHeroVideo.js
var _WatchCardHeroVideo = class _WatchCardHeroVideo extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "endpoint");
    __publicField(this, "call_to_action_button");
    __publicField(this, "hero_image");
    __publicField(this, "label");
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.call_to_action_button = parser_exports.parseItem(data2.callToActionButton);
    this.hero_image = parser_exports.parseItem(data2.heroImage);
    this.label = data2.lengthText?.accessibility.accessibilityData.label || "";
  }
};
__name(_WatchCardHeroVideo, "WatchCardHeroVideo");
__publicField(_WatchCardHeroVideo, "type", "WatchCardHeroVideo");
var WatchCardHeroVideo = _WatchCardHeroVideo;

// dist/src/parser/classes/WatchCardRichHeader.js
var _WatchCardRichHeader = class _WatchCardRichHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "title_endpoint");
    __publicField(this, "subtitle");
    __publicField(this, "author");
    __publicField(this, "style");
    this.title = new Text2(data2.title);
    this.title_endpoint = new NavigationEndpoint(data2.titleNavigationEndpoint);
    this.subtitle = new Text2(data2.subtitle);
    this.author = new Author(data2, data2.titleBadge ? [data2.titleBadge] : null, data2.avatar);
    this.author.name = this.title.toString();
    this.style = data2.style;
  }
};
__name(_WatchCardRichHeader, "WatchCardRichHeader");
__publicField(_WatchCardRichHeader, "type", "WatchCardRichHeader");
var WatchCardRichHeader = _WatchCardRichHeader;

// dist/src/parser/classes/WatchCardSectionSequence.js
var _WatchCardSectionSequence = class _WatchCardSectionSequence extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "lists");
    this.lists = parser_exports.parseArray(data2.lists);
  }
};
__name(_WatchCardSectionSequence, "WatchCardSectionSequence");
__publicField(_WatchCardSectionSequence, "type", "WatchCardSectionSequence");
var WatchCardSectionSequence = _WatchCardSectionSequence;

// dist/src/parser/classes/WatchNextTabbedResults.js
var _WatchNextTabbedResults = class _WatchNextTabbedResults extends TwoColumnBrowseResults {
  constructor(data2) {
    super(data2);
  }
};
__name(_WatchNextTabbedResults, "WatchNextTabbedResults");
__publicField(_WatchNextTabbedResults, "type", "WatchNextTabbedResults");
var WatchNextTabbedResults = _WatchNextTabbedResults;

// dist/src/parser/classes/ytkids/AnchoredSection.js
var _AnchoredSection = class _AnchoredSection extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "content");
    __publicField(this, "endpoint");
    __publicField(this, "category_assets");
    __publicField(this, "category_type");
    this.title = data2.title;
    this.content = parser_exports.parseItem(data2.content, SectionList);
    this.endpoint = new NavigationEndpoint(data2.navigationEndpoint);
    this.category_assets = {
      asset_key: data2.categoryAssets?.assetKey,
      background_color: data2.categoryAssets?.backgroundColor
    };
    this.category_type = data2.categoryType;
  }
};
__name(_AnchoredSection, "AnchoredSection");
__publicField(_AnchoredSection, "type", "AnchoredSection");
var AnchoredSection = _AnchoredSection;

// dist/src/parser/classes/ytkids/KidsBlocklistPickerItem.js
var _actions3;
var _KidsBlocklistPickerItem = class _KidsBlocklistPickerItem extends YTNode {
  constructor(data2) {
    super();
    __privateAdd(this, _actions3);
    __publicField(this, "child_display_name");
    __publicField(this, "child_account_description");
    __publicField(this, "avatar");
    __publicField(this, "block_button");
    __publicField(this, "blocked_entity_key");
    this.child_display_name = new Text2(data2.childDisplayName);
    this.child_account_description = new Text2(data2.childAccountDescription);
    this.avatar = Thumbnail.fromResponse(data2.avatar);
    this.block_button = parser_exports.parseItem(data2.blockButton, [ToggleButton]);
    this.blocked_entity_key = data2.blockedEntityKey;
  }
  async blockChannel() {
    if (!__privateGet(this, _actions3))
      throw new InnertubeError("An active caller must be provide to perform this operation.");
    const button = this.block_button;
    if (!button)
      throw new InnertubeError("Block button was not found.", { child_display_name: this.child_display_name });
    if (button.is_toggled)
      throw new InnertubeError("This channel is already blocked.", { child_display_name: this.child_display_name });
    const response = await button.endpoint.call(__privateGet(this, _actions3), { parse: false });
    return response;
  }
  setActions(actions) {
    __privateSet(this, _actions3, actions);
  }
};
_actions3 = new WeakMap();
__name(_KidsBlocklistPickerItem, "KidsBlocklistPickerItem");
__publicField(_KidsBlocklistPickerItem, "type", "KidsBlocklistPickerItem");
var KidsBlocklistPickerItem = _KidsBlocklistPickerItem;

// dist/src/parser/classes/ytkids/KidsBlocklistPicker.js
var _KidsBlocklistPicker = class _KidsBlocklistPicker extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "child_rows");
    __publicField(this, "done_button");
    __publicField(this, "successful_toast_action_message");
    this.title = new Text2(data2.title);
    this.child_rows = parser_exports.parse(data2.childRows, true, [KidsBlocklistPickerItem]);
    this.done_button = parser_exports.parseItem(data2.doneButton, [Button]);
    this.successful_toast_action_message = new Text2(data2.successfulToastActionMessage);
  }
};
__name(_KidsBlocklistPicker, "KidsBlocklistPicker");
__publicField(_KidsBlocklistPicker, "type", "KidsBlocklistPicker");
var KidsBlocklistPicker = _KidsBlocklistPicker;

// dist/src/parser/classes/ytkids/KidsCategoryTab.js
var _KidsCategoryTab = class _KidsCategoryTab extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "title");
    __publicField(this, "category_assets");
    __publicField(this, "category_type");
    __publicField(this, "endpoint");
    this.title = new Text2(data2.title);
    this.category_assets = {
      asset_key: data2.categoryAssets?.assetKey,
      background_color: data2.categoryAssets?.backgroundColor
    };
    this.category_type = data2.categoryType;
    this.endpoint = new NavigationEndpoint(data2.endpoint);
  }
};
__name(_KidsCategoryTab, "KidsCategoryTab");
__publicField(_KidsCategoryTab, "type", "KidsCategoryTab");
var KidsCategoryTab = _KidsCategoryTab;

// dist/src/parser/classes/ytkids/KidsCategoriesHeader.js
var _KidsCategoriesHeader = class _KidsCategoriesHeader extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "category_tabs");
    __publicField(this, "privacy_button");
    this.category_tabs = parser_exports.parseArray(data2.categoryTabs, KidsCategoryTab);
    this.privacy_button = parser_exports.parseItem(data2.privacyButtonRenderer, Button);
  }
};
__name(_KidsCategoriesHeader, "KidsCategoriesHeader");
__publicField(_KidsCategoriesHeader, "type", "kidsCategoriesHeader");
var KidsCategoriesHeader = _KidsCategoriesHeader;

// dist/src/parser/classes/ytkids/KidsHomeScreen.js
var _KidsHomeScreen = class _KidsHomeScreen extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "anchors");
    this.anchors = parser_exports.parseArray(data2.anchors, AnchoredSection);
  }
};
__name(_KidsHomeScreen, "KidsHomeScreen");
__publicField(_KidsHomeScreen, "type", "kidsHomeScreen");
var KidsHomeScreen = _KidsHomeScreen;

// dist/src/parser/generator.js
var generator_exports = {};
__export(generator_exports, {
  camelToSnake: () => camelToSnake,
  createRuntimeClass: () => createRuntimeClass,
  generateRuntimeClass: () => generateRuntimeClass,
  generateTypescriptClass: () => generateTypescriptClass,
  inferType: () => inferType,
  introspect: () => introspect,
  isArrayType: () => isArrayType,
  isIgnoredKey: () => isIgnoredKey,
  isMiscType: () => isMiscType,
  isRenderer: () => isRenderer,
  isRendererList: () => isRendererList,
  mergeKeyInfo: () => mergeKeyInfo,
  parse: () => parse5,
  toParser: () => toParser,
  toTypeDeclaration: () => toTypeDeclaration
});
var IGNORED_KEYS = /* @__PURE__ */ new Set([
  "trackingParams",
  "accessibility",
  "accessibilityData"
]);
var RENDERER_EXAMPLES = {};
function camelToSnake(str) {
  return str.replace(/[A-Z]/g, (letter) => `_${letter.toLowerCase()}`);
}
__name(camelToSnake, "camelToSnake");
function inferType(key, value) {
  let return_value = false;
  if (typeof value === "object" && value != null) {
    if (return_value = isRenderer(value)) {
      RENDERER_EXAMPLES[return_value] = Reflect.get(value, Reflect.ownKeys(value)[0]);
      return {
        type: "renderer",
        renderers: [return_value],
        optional: false
      };
    }
    if (return_value = isRendererList(value)) {
      for (const [key2, value2] of Object.entries(return_value)) {
        RENDERER_EXAMPLES[key2] = value2;
      }
      return {
        type: "array",
        array_type: "renderer",
        renderers: Object.keys(return_value),
        optional: false
      };
    }
    if (return_value = isMiscType(key, value)) {
      return return_value;
    }
    if (return_value = isArrayType(value)) {
      return return_value;
    }
  }
  const primitive_type = typeof value;
  if (primitive_type === "object")
    return {
      type: "object",
      keys: Object.entries(value).map(([key2, value2]) => [key2, inferType(key2, value2)]),
      optional: false
    };
  return {
    type: "primitive",
    typeof: [primitive_type],
    optional: false
  };
}
__name(inferType, "inferType");
function isRendererList(value) {
  const arr = Array.isArray(value);
  if (arr && value.length === 0)
    return false;
  const is_list = arr && value.every((item) => isRenderer(item));
  return is_list ? Object.fromEntries(value.map((item) => {
    const key = Reflect.ownKeys(item)[0].toString();
    return [sanitizeClassName(key), item[key]];
  })) : false;
}
__name(isRendererList, "isRendererList");
function isMiscType(key, value) {
  if (typeof value === "object" && value !== null) {
    if (key.endsWith("Endpoint") || key.endsWith("Command") || key === "endpoint") {
      return {
        type: "misc",
        endpoint: new NavigationEndpoint(value),
        optional: false,
        misc_type: "NavigationEndpoint"
      };
    }
    if (Reflect.has(value, "simpleText") || Reflect.has(value, "runs")) {
      const textNode = new Text2(value);
      return {
        type: "misc",
        misc_type: "Text",
        optional: false,
        endpoint: textNode.endpoint,
        text: textNode.toString()
      };
    }
    if (Reflect.has(value, "thumbnails") && Array.isArray(Reflect.get(value, "thumbnails"))) {
      return {
        type: "misc",
        misc_type: "Thumbnail",
        optional: false
      };
    }
  }
  return false;
}
__name(isMiscType, "isMiscType");
function isRenderer(value) {
  const is_object = typeof value === "object";
  if (!is_object)
    return false;
  const keys = Reflect.ownKeys(value);
  if (keys.length === 1) {
    const first_key = keys[0].toString();
    if (first_key.endsWith("Renderer") || first_key.endsWith("Model")) {
      return sanitizeClassName(first_key);
    }
  }
  return false;
}
__name(isRenderer, "isRenderer");
function isArrayType(value) {
  if (!Array.isArray(value))
    return false;
  if (value.length === 0)
    return {
      type: "array",
      array_type: "primitive",
      items: {
        type: "primitive",
        typeof: ["never"],
        optional: false
      },
      optional: false
    };
  const array_entry_types = value.map((item) => typeof item);
  const all_same_type = array_entry_types.every((type2) => type2 === array_entry_types[0]);
  if (!all_same_type)
    return {
      type: "array",
      array_type: "primitive",
      items: {
        type: "primitive",
        typeof: ["unknown"],
        optional: false
      },
      optional: false
    };
  const type = array_entry_types[0];
  if (type !== "object")
    return {
      type: "array",
      array_type: "primitive",
      items: {
        type: "primitive",
        typeof: [type],
        optional: false
      },
      optional: false
    };
  let key_type = [];
  for (let i = 0; i < value.length; i++) {
    const current_keys = Object.entries(value[i]).map(([key, value2]) => [key, inferType(key, value2)]);
    if (i === 0) {
      key_type = current_keys;
      continue;
    }
    key_type = mergeKeyInfo(key_type, current_keys).resolved_key_info;
  }
  return {
    type: "array",
    array_type: "object",
    items: {
      type: "object",
      keys: key_type,
      optional: false
    },
    optional: false
  };
}
__name(isArrayType, "isArrayType");
function introspectKeysFirstPass(classdata) {
  if (typeof classdata !== "object" || classdata === null) {
    throw new InnertubeError("Generator: Cannot introspect non-object", {
      classdata
    });
  }
  const keys = Reflect.ownKeys(classdata).filter((key) => !isIgnoredKey(key)).filter((key) => typeof key === "string");
  return keys.map((key) => {
    const value = Reflect.get(classdata, key);
    const inferred_type = inferType(key, value);
    return [key, inferred_type];
  });
}
__name(introspectKeysFirstPass, "introspectKeysFirstPass");
function introspectKeysSecondPass(key_info) {
  const channel_nav = key_info.filter(([, value]) => {
    if (value.type !== "misc")
      return false;
    if (!(value.misc_type === "NavigationEndpoint" || value.misc_type === "Text"))
      return false;
    return value.endpoint?.metadata.page_type === "WEB_PAGE_TYPE_CHANNEL";
  });
  const most_probable_match = channel_nav.sort(([, a], [, b]) => {
    if (a.type !== "misc" || b.type !== "misc")
      return 0;
    if (a.misc_type !== "Text" || b.misc_type !== "Text")
      return 0;
    return b.text.length - a.text.length;
  });
  const excluded_keys = /* @__PURE__ */ new Set();
  const canonical_channel_nave = most_probable_match[0];
  let author;
  if (canonical_channel_nave) {
    excluded_keys.add(canonical_channel_nave[0]);
    const keys = key_info.map(([key]) => key);
    const badges = keys.filter((key) => key.endsWith("Badges") || key === "badges");
    const likely_badges = badges.filter((key) => key.startsWith("owner") || key.startsWith("author"));
    const canonical_badges = likely_badges[0] ?? badges[0];
    const badge_key_info = key_info.find(([key]) => key === canonical_badges);
    const is_badges = badge_key_info ? badge_key_info[1].type === "array" && badge_key_info[1].array_type === "renderer" && Reflect.has(badge_key_info[1].renderers, "MetadataBadge") : false;
    if (is_badges && canonical_badges)
      excluded_keys.add(canonical_badges);
    author = {
      type: "misc",
      misc_type: "Author",
      optional: false,
      params: [
        canonical_channel_nave[0],
        is_badges ? canonical_badges : void 0
      ]
    };
  }
  if (author) {
    key_info.push(["author", author]);
  }
  return key_info.filter(([key]) => !excluded_keys.has(key));
}
__name(introspectKeysSecondPass, "introspectKeysSecondPass");
function introspect2(classdata) {
  const key_info = introspectKeysFirstPass(classdata);
  return introspectKeysSecondPass(key_info);
}
__name(introspect2, "introspect2");
function introspect(classdata) {
  const key_info = introspect2(classdata);
  const dependencies = /* @__PURE__ */ new Map();
  for (const [, value] of key_info) {
    if (value.type === "renderer" || value.type === "array" && value.array_type === "renderer")
      for (const renderer of value.renderers) {
        const example = RENDERER_EXAMPLES[renderer];
        if (example)
          dependencies.set(renderer, example);
      }
  }
  const unimplemented_dependencies = Array.from(dependencies).filter(([classname]) => !hasParser(classname));
  return {
    key_info,
    unimplemented_dependencies
  };
}
__name(introspect, "introspect");
function isIgnoredKey(key) {
  return typeof key === "string" && IGNORED_KEYS.has(key);
}
__name(isIgnoredKey, "isIgnoredKey");
function createRuntimeClass(classname, key_info, logger) {
  var _a, _key_info;
  logger({
    error_type: "class_not_found",
    classname,
    key_info
  });
  const node = (_a = class extends YTNode {
    static set key_info(key_info2) {
      __privateSet(this, _key_info, new Map(key_info2));
    }
    static get key_info() {
      return [...__privateGet(this, _key_info).entries()];
    }
    constructor(data2) {
      super();
      const { key_info: key_info2, unimplemented_dependencies } = introspect(data2);
      const { resolved_key_info, changed_keys } = mergeKeyInfo(node.key_info, key_info2);
      const did_change = changed_keys.length > 0;
      if (did_change) {
        node.key_info = resolved_key_info;
        logger({
          error_type: "class_changed",
          classname,
          key_info: node.key_info,
          changed_keys
        });
      }
      for (const [name, data3] of unimplemented_dependencies)
        generateRuntimeClass(name, data3, logger);
      for (const [key, value] of key_info2) {
        let snake_key = camelToSnake(key);
        if (value.type === "misc" && value.misc_type === "NavigationEndpoint")
          snake_key = "endpoint";
        Reflect.set(this, snake_key, parse5(key, value, data2));
      }
    }
  }, _key_info = new WeakMap(), __name(_a, "node"), __publicField(_a, "type", classname), __privateAdd(_a, _key_info, /* @__PURE__ */ new Map()), _a);
  node.key_info = key_info;
  Object.defineProperty(node, "name", { value: classname, writable: false });
  return node;
}
__name(createRuntimeClass, "createRuntimeClass");
function generateRuntimeClass(classname, classdata, logger) {
  const { key_info, unimplemented_dependencies } = introspect(classdata);
  const JITNode = createRuntimeClass(classname, key_info, logger);
  addRuntimeParser(classname, JITNode);
  for (const [name, data2] of unimplemented_dependencies)
    generateRuntimeClass(name, data2, logger);
  return JITNode;
}
__name(generateRuntimeClass, "generateRuntimeClass");
function generateTypescriptClass(classname, key_info) {
  const props = [];
  const constructor_lines = [
    "super();"
  ];
  for (const [key, value] of key_info) {
    let snake_key = camelToSnake(key);
    if (value.type === "misc" && value.misc_type === "NavigationEndpoint")
      snake_key = "endpoint";
    props.push(`${snake_key}${value.optional ? "?" : ""}: ${toTypeDeclaration(value)};`);
    constructor_lines.push(`this.${snake_key} = ${toParser(key, value)};`);
  }
  return `class ${classname} extends YTNode {
  static type = '${classname}';

  ${props.join("\n  ")}

  constructor(data: RawNode) {
    ${constructor_lines.join("\n    ")}
  }
}
`;
}
__name(generateTypescriptClass, "generateTypescriptClass");
function toTypeDeclarationObject(indentation, keys) {
  return `{
${keys.map(([key, value]) => `${" ".repeat((indentation + 2) * 2)}${camelToSnake(key)}${value.optional ? "?" : ""}: ${toTypeDeclaration(value, indentation + 1)}`).join(",\n")}
${" ".repeat((indentation + 1) * 2)}}`;
}
__name(toTypeDeclarationObject, "toTypeDeclarationObject");
function toTypeDeclaration(inference_type, indentation = 0) {
  switch (inference_type.type) {
    case "renderer": {
      return `${inference_type.renderers.map((type) => `YTNodes.${type}`).join(" | ")} | null`;
    }
    case "array": {
      switch (inference_type.array_type) {
        case "renderer":
          return `ObservedArray<${inference_type.renderers.map((type) => `YTNodes.${type}`).join(" | ")}> | null`;
        case "primitive": {
          const items_list = inference_type.items.typeof;
          if (inference_type.items.optional && !items_list.includes("undefined"))
            items_list.push("undefined");
          const items = items_list.length === 1 ? `${items_list[0]}` : `(${items_list.join(" | ")})`;
          return `${items}[]`;
        }
        case "object":
          return `${toTypeDeclarationObject(indentation, inference_type.items.keys)}[]`;
        default:
          throw new Error("Unreachable code reached! Switch missing case!");
      }
    }
    case "object": {
      return toTypeDeclarationObject(indentation, inference_type.keys);
    }
    case "misc": {
      switch (inference_type.misc_type) {
        case "Thumbnail":
          return "Thumbnail[]";
        default:
          return inference_type.misc_type;
      }
    }
    case "primitive": {
      return inference_type.typeof.join(" | ");
    }
  }
}
__name(toTypeDeclaration, "toTypeDeclaration");
function toParserObject(indentation, keys, key_path, key) {
  const new_keypath = [...key_path, key];
  return `{
${keys.map(([key2, value]) => `${" ".repeat((indentation + 2) * 2)}${camelToSnake(key2)}: ${toParser(key2, value, new_keypath, indentation + 1)}`).join(",\n")}
${" ".repeat((indentation + 1) * 2)}}`;
}
__name(toParserObject, "toParserObject");
function toParser(key, inference_type, key_path = ["data"], indentation = 1) {
  let parser = "undefined";
  switch (inference_type.type) {
    case "renderer":
      {
        parser = `Parser.parseItem(${key_path.join(".")}.${key}, ${toParserValidTypes(inference_type.renderers)})`;
      }
      break;
    case "array":
      {
        switch (inference_type.array_type) {
          case "renderer":
            parser = `Parser.parse(${key_path.join(".")}.${key}, true, ${toParserValidTypes(inference_type.renderers)})`;
            break;
          case "object":
            parser = `${key_path.join(".")}.${key}.map((item: any) => (${toParserObject(indentation, inference_type.items.keys, [], "item")}))`;
            break;
          case "primitive":
            parser = `${key_path.join(".")}.${key}`;
            break;
          default:
            throw new Error("Unreachable code reached! Switch missing case!");
        }
      }
      break;
    case "object":
      {
        parser = toParserObject(indentation, inference_type.keys, key_path, key);
      }
      break;
    case "misc":
      switch (inference_type.misc_type) {
        case "Thumbnail":
          parser = `Thumbnail.fromResponse(${key_path.join(".")}.${key})`;
          break;
        case "Author": {
          const author_parser = `new Author(${key_path.join(".")}.${inference_type.params[0]}, ${inference_type.params[1] ? `${key_path.join(".")}.${inference_type.params[1]}` : "undefined"})`;
          if (inference_type.optional)
            return `Reflect.has(${key_path.join(".")}, '${inference_type.params[0]}') ? ${author_parser} : undefined`;
          return author_parser;
        }
        default:
          parser = `new ${inference_type.misc_type}(${key_path.join(".")}.${key})`;
          break;
      }
      if (parser === "undefined")
        throw new Error("Unreachable code reached! Switch missing case!");
      break;
    case "primitive":
      parser = `${key_path.join(".")}.${key}`;
      break;
  }
  if (inference_type.optional)
    return `Reflect.has(${key_path.join(".")}, '${key}') ? ${parser} : undefined`;
  return parser;
}
__name(toParser, "toParser");
function toParserValidTypes(types2) {
  if (types2.length === 1) {
    return `YTNodes.${types2[0]}`;
  }
  return `[ ${types2.map((type) => `YTNodes.${type}`).join(", ")} ]`;
}
__name(toParserValidTypes, "toParserValidTypes");
function accessDataFromKeyPath(root, key_path) {
  let data2 = root;
  for (const key of key_path)
    data2 = data2[key];
  return data2;
}
__name(accessDataFromKeyPath, "accessDataFromKeyPath");
function hasDataFromKeyPath(root, key_path) {
  let data2 = root;
  for (const key of key_path)
    if (!Reflect.has(data2, key))
      return false;
    else
      data2 = data2[key];
  return true;
}
__name(hasDataFromKeyPath, "hasDataFromKeyPath");
function parseObject(key, data2, key_path, keys, should_optional) {
  const obj = {};
  const new_key_path = [...key_path, key];
  for (const [key2, value] of keys) {
    obj[key2] = should_optional ? parse5(key2, value, data2, new_key_path) : void 0;
  }
  return obj;
}
__name(parseObject, "parseObject");
function parse5(key, inference_type, data2, key_path = ["data"]) {
  const should_optional = !inference_type.optional || hasDataFromKeyPath({ data: data2 }, [...key_path, key]);
  switch (inference_type.type) {
    case "renderer": {
      return should_optional ? parseItem(accessDataFromKeyPath({ data: data2 }, [...key_path, key]), inference_type.renderers.map((type) => getParserByName(type))) : void 0;
    }
    case "array": {
      switch (inference_type.array_type) {
        case "renderer":
          return should_optional ? parse4(accessDataFromKeyPath({ data: data2 }, [...key_path, key]), true, inference_type.renderers.map((type) => getParserByName(type))) : void 0;
        case "object":
          return should_optional ? accessDataFromKeyPath({ data: data2 }, [...key_path, key]).map((_, idx) => {
            return parseObject(`${idx}`, data2, [...key_path, key], inference_type.items.keys, should_optional);
          }) : void 0;
        case "primitive":
          return should_optional ? accessDataFromKeyPath({ data: data2 }, [...key_path, key]) : void 0;
        default:
          throw new Error("Unreachable code reached! Switch missing case!");
      }
    }
    case "object": {
      return parseObject(key, data2, key_path, inference_type.keys, should_optional);
    }
    case "misc":
      switch (inference_type.misc_type) {
        case "NavigationEndpoint":
          return should_optional ? new NavigationEndpoint(accessDataFromKeyPath({ data: data2 }, [...key_path, key])) : void 0;
        case "Text":
          return should_optional ? new Text2(accessDataFromKeyPath({ data: data2 }, [...key_path, key])) : void 0;
        case "Thumbnail":
          return should_optional ? Thumbnail.fromResponse(accessDataFromKeyPath({ data: data2 }, [...key_path, key])) : void 0;
        case "Author": {
          const author_should_optional = !inference_type.optional || hasDataFromKeyPath({ data: data2 }, [...key_path, inference_type.params[0]]);
          return author_should_optional ? new Author(accessDataFromKeyPath({ data: data2 }, [...key_path, inference_type.params[0]]), inference_type.params[1] ? accessDataFromKeyPath({ data: data2 }, [...key_path, inference_type.params[1]]) : void 0) : void 0;
        }
        default:
          throw new Error("Unreachable code reached! Switch missing case!");
      }
    case "primitive":
      return accessDataFromKeyPath({ data: data2 }, [...key_path, key]);
  }
}
__name(parse5, "parse");
function mergeKeyInfo(key_info, new_key_info) {
  const changed_keys = /* @__PURE__ */ new Map();
  const current_keys = new Set(key_info.map(([key]) => key));
  const new_keys = new Set(new_key_info.map(([key]) => key));
  const added_keys = new_key_info.filter(([key]) => !current_keys.has(key));
  const removed_keys = key_info.filter(([key]) => !new_keys.has(key));
  const common_keys = key_info.filter(([key]) => new_keys.has(key));
  const new_key_map = new Map(new_key_info);
  for (const [key, type] of common_keys) {
    const new_type = new_key_map.get(key);
    if (!new_type)
      continue;
    if (type.type !== new_type.type) {
      changed_keys.set(key, {
        type: "primitive",
        typeof: ["unknown"],
        optional: true
      });
      continue;
    }
    switch (type.type) {
      case "object":
        {
          if (new_type.type !== "object")
            continue;
          const { resolved_key_info: resolved_key_info2 } = mergeKeyInfo(type.keys, new_type.keys);
          const resolved_key = {
            type: "object",
            keys: resolved_key_info2,
            optional: type.optional || new_type.optional
          };
          const did_change = JSON.stringify(resolved_key) !== JSON.stringify(type);
          if (did_change)
            changed_keys.set(key, resolved_key);
        }
        break;
      case "renderer":
        {
          if (new_type.type !== "renderer")
            continue;
          const union_map = {
            ...type.renderers,
            ...new_type.renderers
          };
          const either_optional = type.optional || new_type.optional;
          const resolved_key = {
            type: "renderer",
            renderers: union_map,
            optional: either_optional
          };
          const did_change = JSON.stringify({
            ...resolved_key,
            renderers: Object.keys(resolved_key.renderers)
          }) !== JSON.stringify({
            ...type,
            renderers: Object.keys(type.renderers)
          });
          if (did_change)
            changed_keys.set(key, resolved_key);
        }
        break;
      case "array": {
        if (new_type.type !== "array")
          continue;
        switch (type.array_type) {
          case "renderer":
            {
              if (new_type.array_type !== "renderer") {
                changed_keys.set(key, {
                  type: "array",
                  array_type: "primitive",
                  items: {
                    type: "primitive",
                    typeof: ["unknown"],
                    optional: true
                  },
                  optional: true
                });
                continue;
              }
              const union_map = {
                ...type.renderers,
                ...new_type.renderers
              };
              const either_optional = type.optional || new_type.optional;
              const resolved_key = {
                type: "array",
                array_type: "renderer",
                renderers: union_map,
                optional: either_optional
              };
              const did_change = JSON.stringify({
                ...resolved_key,
                renderers: Object.keys(resolved_key.renderers)
              }) !== JSON.stringify({
                ...type,
                renderers: Object.keys(type.renderers)
              });
              if (did_change)
                changed_keys.set(key, resolved_key);
            }
            break;
          case "object":
            {
              if (new_type.array_type === "primitive" && new_type.items.typeof.length == 1 && new_type.items.typeof[0] === "never") {
                continue;
              }
              if (new_type.array_type !== "object") {
                changed_keys.set(key, {
                  type: "array",
                  array_type: "primitive",
                  items: {
                    type: "primitive",
                    typeof: ["unknown"],
                    optional: true
                  },
                  optional: true
                });
                continue;
              }
              const { resolved_key_info: resolved_key_info2 } = mergeKeyInfo(type.items.keys, new_type.items.keys);
              const resolved_key = {
                type: "array",
                array_type: "object",
                items: {
                  type: "object",
                  keys: resolved_key_info2,
                  optional: type.items.optional || new_type.items.optional
                },
                optional: type.optional || new_type.optional
              };
              const did_change = JSON.stringify(resolved_key) !== JSON.stringify(type);
              if (did_change)
                changed_keys.set(key, resolved_key);
            }
            break;
          case "primitive":
            {
              if (type.items.typeof.includes("never") && new_type.array_type === "object") {
                changed_keys.set(key, new_type);
                continue;
              }
              if (new_type.array_type !== "primitive") {
                changed_keys.set(key, {
                  type: "array",
                  array_type: "primitive",
                  items: {
                    type: "primitive",
                    typeof: ["unknown"],
                    optional: true
                  },
                  optional: true
                });
                continue;
              }
              const key_types = /* @__PURE__ */ new Set([...new_type.items.typeof, ...type.items.typeof]);
              if (key_types.size > 1 && key_types.has("never"))
                key_types.delete("never");
              const resolved_key = {
                type: "array",
                array_type: "primitive",
                items: {
                  type: "primitive",
                  typeof: Array.from(key_types),
                  optional: type.items.optional || new_type.items.optional
                },
                optional: type.optional || new_type.optional
              };
              const did_change = JSON.stringify(resolved_key) !== JSON.stringify(type);
              if (did_change)
                changed_keys.set(key, resolved_key);
            }
            break;
          default:
            throw new Error("Unreachable code reached! Switch missing case!");
        }
        break;
      }
      case "misc":
        {
          if (new_type.type !== "misc")
            continue;
          if (type.misc_type !== new_type.misc_type) {
            changed_keys.set(key, {
              type: "primitive",
              typeof: ["unknown"],
              optional: true
            });
          }
          switch (type.misc_type) {
            case "Author":
              {
                if (new_type.misc_type !== "Author")
                  break;
                const had_optional_param = type.params[1] || new_type.params[1];
                const either_optional = type.optional || new_type.optional;
                const resolved_key = {
                  type: "misc",
                  misc_type: "Author",
                  optional: either_optional,
                  params: [new_type.params[0], had_optional_param]
                };
                const did_change = JSON.stringify(resolved_key) !== JSON.stringify(type);
                if (did_change)
                  changed_keys.set(key, resolved_key);
              }
              break;
          }
        }
        break;
      case "primitive":
        {
          if (new_type.type !== "primitive")
            continue;
          const resolved_key = {
            type: "primitive",
            typeof: Array.from(/* @__PURE__ */ new Set([...new_type.typeof, ...type.typeof])),
            optional: type.optional || new_type.optional
          };
          const did_change = JSON.stringify(resolved_key) !== JSON.stringify(type);
          if (did_change)
            changed_keys.set(key, resolved_key);
        }
        break;
    }
  }
  for (const [key, type] of added_keys) {
    changed_keys.set(key, {
      ...type,
      optional: true
    });
  }
  for (const [key, type] of removed_keys) {
    changed_keys.set(key, {
      ...type,
      optional: true
    });
  }
  const unchanged_keys = key_info.filter(([key]) => !changed_keys.has(key));
  const resolved_key_info_map = new Map([...unchanged_keys, ...changed_keys]);
  const resolved_key_info = [...resolved_key_info_map.entries()];
  return {
    resolved_key_info,
    changed_keys: [...changed_keys.entries()]
  };
}
__name(mergeKeyInfo, "mergeKeyInfo");

// dist/src/parser/continuations.js
var _ItemSectionContinuation = class _ItemSectionContinuation extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "contents");
    __publicField(this, "continuation");
    this.contents = parseArray(data2.contents);
    if (Array.isArray(data2.continuations)) {
      this.continuation = data2.continuations?.at(0)?.nextContinuationData?.continuation;
    }
  }
};
__name(_ItemSectionContinuation, "ItemSectionContinuation");
__publicField(_ItemSectionContinuation, "type", "itemSectionContinuation");
var ItemSectionContinuation = _ItemSectionContinuation;
var _NavigateAction = class _NavigateAction extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "endpoint");
    this.endpoint = new NavigationEndpoint(data2.endpoint);
  }
};
__name(_NavigateAction, "NavigateAction");
__publicField(_NavigateAction, "type", "navigateAction");
var NavigateAction = _NavigateAction;
var _ShowMiniplayerCommand = class _ShowMiniplayerCommand extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "miniplayer_command");
    __publicField(this, "show_premium_branding");
    this.miniplayer_command = new NavigationEndpoint(data2.miniplayerCommand);
    this.show_premium_branding = data2.showPremiumBranding;
  }
};
__name(_ShowMiniplayerCommand, "ShowMiniplayerCommand");
__publicField(_ShowMiniplayerCommand, "type", "showMiniplayerCommand");
var ShowMiniplayerCommand = _ShowMiniplayerCommand;
var _ReloadContinuationItemsCommand = class _ReloadContinuationItemsCommand extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "target_id");
    __publicField(this, "contents");
    __publicField(this, "slot");
    this.target_id = data2.targetId;
    this.contents = parse4(data2.continuationItems, true);
    this.slot = data2?.slot;
  }
};
__name(_ReloadContinuationItemsCommand, "ReloadContinuationItemsCommand");
__publicField(_ReloadContinuationItemsCommand, "type", "reloadContinuationItemsCommand");
var ReloadContinuationItemsCommand = _ReloadContinuationItemsCommand;
var _SectionListContinuation = class _SectionListContinuation extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "continuation");
    __publicField(this, "contents");
    this.contents = parse4(data2.contents, true);
    this.continuation = data2.continuations?.[0]?.nextContinuationData?.continuation || data2.continuations?.[0]?.reloadContinuationData?.continuation || null;
  }
};
__name(_SectionListContinuation, "SectionListContinuation");
__publicField(_SectionListContinuation, "type", "sectionListContinuation");
var SectionListContinuation = _SectionListContinuation;
var _MusicPlaylistShelfContinuation = class _MusicPlaylistShelfContinuation extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "continuation");
    __publicField(this, "contents");
    this.contents = parse4(data2.contents, true);
    this.continuation = data2.continuations?.[0].nextContinuationData.continuation || null;
  }
};
__name(_MusicPlaylistShelfContinuation, "MusicPlaylistShelfContinuation");
__publicField(_MusicPlaylistShelfContinuation, "type", "musicPlaylistShelfContinuation");
var MusicPlaylistShelfContinuation = _MusicPlaylistShelfContinuation;
var _MusicShelfContinuation = class _MusicShelfContinuation extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "continuation");
    __publicField(this, "contents");
    this.contents = parseArray(data2.contents);
    this.continuation = data2.continuations?.[0].nextContinuationData?.continuation || data2.continuations?.[0].reloadContinuationData?.continuation || null;
  }
};
__name(_MusicShelfContinuation, "MusicShelfContinuation");
__publicField(_MusicShelfContinuation, "type", "musicShelfContinuation");
var MusicShelfContinuation = _MusicShelfContinuation;
var _GridContinuation = class _GridContinuation extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "continuation");
    __publicField(this, "items");
    this.items = parse4(data2.items, true);
    this.continuation = data2.continuations?.[0].nextContinuationData.continuation || null;
  }
  get contents() {
    return this.items;
  }
};
__name(_GridContinuation, "GridContinuation");
__publicField(_GridContinuation, "type", "gridContinuation");
var GridContinuation = _GridContinuation;
var _PlaylistPanelContinuation = class _PlaylistPanelContinuation extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "continuation");
    __publicField(this, "contents");
    this.contents = parseArray(data2.contents);
    this.continuation = data2.continuations?.[0]?.nextContinuationData?.continuation || data2.continuations?.[0]?.nextRadioContinuationData?.continuation || null;
  }
};
__name(_PlaylistPanelContinuation, "PlaylistPanelContinuation");
__publicField(_PlaylistPanelContinuation, "type", "playlistPanelContinuation");
var PlaylistPanelContinuation = _PlaylistPanelContinuation;
var _Continuation = class _Continuation extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "continuation_type");
    __publicField(this, "timeout_ms");
    __publicField(this, "time_until_last_message_ms");
    __publicField(this, "token");
    this.continuation_type = data2.type;
    this.timeout_ms = data2.continuation?.timeoutMs;
    this.time_until_last_message_ms = data2.continuation?.timeUntilLastMessageMsec;
    this.token = data2.continuation?.continuation;
  }
};
__name(_Continuation, "Continuation");
__publicField(_Continuation, "type", "continuation");
var Continuation = _Continuation;
var _LiveChatContinuation = class _LiveChatContinuation extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "actions");
    __publicField(this, "action_panel");
    __publicField(this, "item_list");
    __publicField(this, "header");
    __publicField(this, "participants_list");
    __publicField(this, "popout_message");
    __publicField(this, "emojis");
    __publicField(this, "continuation");
    __publicField(this, "viewer_name");
    this.actions = parse4(data2.actions?.map((action) => {
      delete action.clickTrackingParams;
      return action;
    }), true) || observe([]);
    this.action_panel = parseItem(data2.actionPanel);
    this.item_list = parseItem(data2.itemList, LiveChatItemList);
    this.header = parseItem(data2.header, LiveChatHeader);
    this.participants_list = parseItem(data2.participantsList, LiveChatParticipantsList);
    this.popout_message = parseItem(data2.popoutMessage, Message);
    this.emojis = data2.emojis?.map((emoji) => ({
      emoji_id: emoji.emojiId,
      shortcuts: emoji.shortcuts,
      search_terms: emoji.searchTerms,
      image: Thumbnail.fromResponse(emoji.image),
      is_custom_emoji: emoji.isCustomEmoji
    })) || [];
    let continuation, type;
    if (data2.continuations?.[0].timedContinuationData) {
      type = "timed";
      continuation = data2.continuations?.[0].timedContinuationData;
    } else if (data2.continuations?.[0].invalidationContinuationData) {
      type = "invalidation";
      continuation = data2.continuations?.[0].invalidationContinuationData;
    } else if (data2.continuations?.[0].liveChatReplayContinuationData) {
      type = "replay";
      continuation = data2.continuations?.[0].liveChatReplayContinuationData;
    }
    this.continuation = new Continuation({ continuation, type });
    this.viewer_name = data2.viewerName;
  }
};
__name(_LiveChatContinuation, "LiveChatContinuation");
__publicField(_LiveChatContinuation, "type", "liveChatContinuation");
var LiveChatContinuation = _LiveChatContinuation;
var _ContinuationCommand2 = class _ContinuationCommand2 extends YTNode {
  constructor(data2) {
    super();
    __publicField(this, "request");
    __publicField(this, "token");
    this.request = data2.request;
    this.token = data2.token;
  }
};
__name(_ContinuationCommand2, "ContinuationCommand");
__publicField(_ContinuationCommand2, "type", "ContinuationCommand");
var ContinuationCommand2 = _ContinuationCommand2;

// dist/protos/generated/misc/common.js
function createBaseKeyValuePair() {
  return { key: void 0, value: void 0 };
}
__name(createBaseKeyValuePair, "createBaseKeyValuePair");
var KeyValuePair = {
  encode(message, writer = new BinaryWriter()) {
    if (message.key !== void 0) {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== void 0) {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseKeyValuePair();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.key = reader.string();
          continue;
        case 2:
          if (tag !== 18) {
            break;
          }
          message.value = reader.string();
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};
function createBaseFormatXTags() {
  return { xtags: [] };
}
__name(createBaseFormatXTags, "createBaseFormatXTags");
var FormatXTags = {
  encode(message, writer = new BinaryWriter()) {
    for (const v of message.xtags) {
      KeyValuePair.encode(v, writer.uint32(10).fork()).join();
    }
    return writer;
  },
  decode(input, length) {
    const reader = input instanceof BinaryReader ? input : new BinaryReader(input);
    let end = length === void 0 ? reader.len : reader.pos + length;
    const message = createBaseFormatXTags();
    while (reader.pos < end) {
      const tag = reader.uint32();
      switch (tag >>> 3) {
        case 1:
          if (tag !== 10) {
            break;
          }
          message.xtags.push(KeyValuePair.decode(reader, reader.uint32()));
          continue;
      }
      if ((tag & 7) === 4 || tag === 0) {
        break;
      }
      reader.skip(tag & 7);
    }
    return message;
  }
};

// dist/src/parser/classes/misc/Format.js
var _this_response_nsig_cache;
var _Format = class _Format {
  constructor(data2, this_response_nsig_cache) {
    __privateAdd(this, _this_response_nsig_cache);
    __publicField(this, "itag");
    __publicField(this, "url");
    __publicField(this, "width");
    __publicField(this, "height");
    __publicField(this, "last_modified");
    __publicField(this, "last_modified_ms");
    __publicField(this, "content_length");
    __publicField(this, "quality");
    __publicField(this, "xtags");
    __publicField(this, "drm_families");
    __publicField(this, "fps");
    __publicField(this, "quality_label");
    __publicField(this, "projection_type");
    __publicField(this, "average_bitrate");
    __publicField(this, "bitrate");
    __publicField(this, "spatial_audio_type");
    __publicField(this, "target_duration_dec");
    __publicField(this, "fair_play_key_uri");
    __publicField(this, "stereo_layout");
    __publicField(this, "max_dvr_duration_sec");
    __publicField(this, "high_replication");
    __publicField(this, "audio_quality");
    __publicField(this, "approx_duration_ms");
    __publicField(this, "audio_sample_rate");
    __publicField(this, "audio_channels");
    __publicField(this, "loudness_db");
    __publicField(this, "signature_cipher");
    __publicField(this, "is_drc");
    __publicField(this, "drm_track_type");
    __publicField(this, "distinct_params");
    __publicField(this, "track_absolute_loudness_lkfs");
    __publicField(this, "mime_type");
    __publicField(this, "is_type_otf");
    __publicField(this, "init_range");
    __publicField(this, "index_range");
    __publicField(this, "cipher");
    __publicField(this, "audio_track");
    __publicField(this, "has_audio");
    __publicField(this, "has_video");
    __publicField(this, "has_text");
    __publicField(this, "language");
    __publicField(this, "is_dubbed");
    __publicField(this, "is_auto_dubbed");
    __publicField(this, "is_descriptive");
    __publicField(this, "is_secondary");
    __publicField(this, "is_original");
    __publicField(this, "color_info");
    __publicField(this, "caption_track");
    if (this_response_nsig_cache)
      __privateSet(this, _this_response_nsig_cache, this_response_nsig_cache);
    this.itag = data2.itag;
    this.mime_type = data2.mimeType;
    this.is_type_otf = data2.type === "FORMAT_STREAM_TYPE_OTF";
    this.bitrate = data2.bitrate;
    this.average_bitrate = data2.averageBitrate;
    if (Reflect.has(data2, "width") && Reflect.has(data2, "height")) {
      this.width = parseInt(data2.width);
      this.height = parseInt(data2.height);
    }
    if (Reflect.has(data2, "projectionType"))
      this.projection_type = data2.projectionType;
    if (Reflect.has(data2, "stereoLayout"))
      this.stereo_layout = data2.stereoLayout?.replace("STEREO_LAYOUT_", "");
    if (Reflect.has(data2, "initRange"))
      this.init_range = {
        start: parseInt(data2.initRange.start),
        end: parseInt(data2.initRange.end)
      };
    if (Reflect.has(data2, "indexRange"))
      this.index_range = {
        start: parseInt(data2.indexRange.start),
        end: parseInt(data2.indexRange.end)
      };
    this.last_modified = new Date(Math.floor(parseInt(data2.lastModified) / 1e3));
    this.last_modified_ms = data2.lastModified;
    if (Reflect.has(data2, "contentLength"))
      this.content_length = parseInt(data2.contentLength);
    if (Reflect.has(data2, "quality"))
      this.quality = data2.quality;
    if (Reflect.has(data2, "qualityLabel"))
      this.quality_label = data2.qualityLabel;
    if (Reflect.has(data2, "fps"))
      this.fps = data2.fps;
    if (Reflect.has(data2, "url"))
      this.url = data2.url;
    if (Reflect.has(data2, "cipher"))
      this.cipher = data2.cipher;
    if (Reflect.has(data2, "signatureCipher"))
      this.signature_cipher = data2.signatureCipher;
    if (Reflect.has(data2, "audioQuality"))
      this.audio_quality = data2.audioQuality;
    this.approx_duration_ms = parseInt(data2.approxDurationMs);
    if (Reflect.has(data2, "audioSampleRate"))
      this.audio_sample_rate = parseInt(data2.audioSampleRate);
    if (Reflect.has(data2, "audioChannels"))
      this.audio_channels = data2.audioChannels;
    if (Reflect.has(data2, "loudnessDb"))
      this.loudness_db = data2.loudnessDb;
    if (Reflect.has(data2, "spatialAudioType"))
      this.spatial_audio_type = data2.spatialAudioType?.replace("SPATIAL_AUDIO_TYPE_", "");
    if (Reflect.has(data2, "maxDvrDurationSec"))
      this.max_dvr_duration_sec = data2.maxDvrDurationSec;
    if (Reflect.has(data2, "targetDurationSec"))
      this.target_duration_dec = data2.targetDurationSec;
    this.has_audio = !!data2.audioBitrate || !!data2.audioQuality;
    this.has_video = !!data2.qualityLabel;
    this.has_text = !!data2.captionTrack;
    if (Reflect.has(data2, "xtags"))
      this.xtags = data2.xtags;
    if (Reflect.has(data2, "fairPlayKeyUri"))
      this.fair_play_key_uri = data2.fairPlayKeyUri;
    if (Reflect.has(data2, "drmFamilies"))
      this.drm_families = data2.drmFamilies;
    if (Reflect.has(data2, "drmTrackType"))
      this.drm_track_type = data2.drmTrackType;
    if (Reflect.has(data2, "distinctParams"))
      this.distinct_params = data2.distinctParams;
    if (Reflect.has(data2, "trackAbsoluteLoudnessLkfs"))
      this.track_absolute_loudness_lkfs = data2.trackAbsoluteLoudnessLkfs;
    if (Reflect.has(data2, "highReplication"))
      this.high_replication = data2.highReplication;
    if (Reflect.has(data2, "colorInfo"))
      this.color_info = {
        primaries: data2.colorInfo.primaries?.replace("COLOR_PRIMARIES_", ""),
        transfer_characteristics: data2.colorInfo.transferCharacteristics?.replace("COLOR_TRANSFER_CHARACTERISTICS_", ""),
        matrix_coefficients: data2.colorInfo.matrixCoefficients?.replace("COLOR_MATRIX_COEFFICIENTS_", "")
      };
    if (Reflect.has(data2, "audioTrack"))
      this.audio_track = {
        audio_is_default: data2.audioTrack.audioIsDefault,
        display_name: data2.audioTrack.displayName,
        id: data2.audioTrack.id
      };
    if (Reflect.has(data2, "captionTrack"))
      this.caption_track = {
        display_name: data2.captionTrack.displayName,
        vss_id: data2.captionTrack.vssId,
        language_code: data2.captionTrack.languageCode,
        kind: data2.captionTrack.kind,
        id: data2.captionTrack.id
      };
    if (this.has_audio || this.has_text) {
      const xtags = this.xtags ? FormatXTags.decode(base64ToU8(decodeURIComponent(this.xtags).replace(/-/g, "+").replace(/_/g, "/"))).xtags : [];
      this.language = xtags.find((tag) => tag.key === "lang")?.value || null;
      if (this.has_audio) {
        this.is_drc = !!data2.isDrc || xtags.some((tag) => tag.key === "drc" && tag.value === "1");
        const audio_content = xtags.find((tag) => tag.key === "acont")?.value;
        this.is_dubbed = audio_content === "dubbed";
        this.is_descriptive = audio_content === "descriptive";
        this.is_secondary = audio_content === "secondary";
        this.is_auto_dubbed = audio_content === "dubbed-auto";
        this.is_original = audio_content === "original" || !this.is_dubbed && !this.is_descriptive && !this.is_secondary && !this.is_auto_dubbed && !this.is_drc;
      }
      if (this.has_text && !this.language && this.caption_track) {
        this.language = this.caption_track.language_code;
      }
    }
  }
  /**
   * Deciphers the URL using the provided player instance.
   * @param player - An optional instance of the Player class used to decipher the URL.
   * @returns The deciphered URL as a string. If no player is provided, returns the original URL or an empty string.
   */
  decipher(player) {
    if (!player)
      return this.url || "";
    return player.decipher(this.url, this.signature_cipher, this.cipher, __privateGet(this, _this_response_nsig_cache));
  }
};
_this_response_nsig_cache = new WeakMap();
__name(_Format, "Format");
var Format = _Format;

// dist/src/parser/classes/misc/VideoDetails.js
var _VideoDetails = class _VideoDetails {
  constructor(data2) {
    __publicField(this, "id");
    __publicField(this, "channel_id");
    __publicField(this, "title");
    __publicField(this, "duration");
    __publicField(this, "keywords");
    __publicField(this, "is_owner_viewing");
    __publicField(this, "short_description");
    __publicField(this, "thumbnail");
    __publicField(this, "allow_ratings");
    __publicField(this, "view_count");
    __publicField(this, "author");
    __publicField(this, "is_private");
    __publicField(this, "is_live");
    __publicField(this, "is_live_content");
    __publicField(this, "is_live_dvr_enabled");
    __publicField(this, "is_upcoming");
    __publicField(this, "is_crawlable");
    __publicField(this, "is_post_live_dvr");
    __publicField(this, "is_low_latency_live_stream");
    __publicField(this, "live_chunk_readahead");
    this.id = data2.videoId;
    this.channel_id = data2.channelId;
    this.title = data2.title;
    this.duration = parseInt(data2.lengthSeconds);
    this.keywords = data2.keywords;
    this.is_owner_viewing = !!data2.isOwnerViewing;
    this.short_description = data2.shortDescription;
    this.thumbnail = Thumbnail.fromResponse(data2.thumbnail);
    this.allow_ratings = !!data2.allowRatings;
    this.view_count = parseInt(data2.viewCount);
    this.author = data2.author;
    this.is_private = !!data2.isPrivate;
    this.is_live = !!data2.isLive;
    this.is_live_content = !!data2.isLiveContent;
    this.is_live_dvr_enabled = !!data2.isLiveDvrEnabled;
    this.is_low_latency_live_stream = !!data2.isLowLatencyLiveStream;
    this.is_upcoming = !!data2.isUpcoming;
    this.is_post_live_dvr = !!data2.isPostLiveDvr;
    this.is_crawlable = !!data2.isCrawlable;
    this.live_chunk_readahead = data2.liveChunkReadahead;
  }
};
__name(_VideoDetails, "VideoDetails");
var VideoDetails = _VideoDetails;

// dist/src/parser/parser.js
var TAG2 = "Parser";
var IGNORED_LIST = /* @__PURE__ */ new Set([
  "AdSlot",
  "DisplayAd",
  "SearchPyv",
  "MealbarPromo",
  "PrimetimePromo",
  "PromotedSparklesWeb",
  "CompactPromotedVideo",
  "BrandVideoShelf",
  "BrandVideoSingleton",
  "StatementBanner",
  "GuideSigninPromo",
  "AdsEngagementPanelContent",
  "MiniGameCardView"
]);
var RUNTIME_NODES = new Map(Object.entries(nodes_exports2));
var DYNAMIC_NODES = /* @__PURE__ */ new Map();
var MEMO = null;
var ERROR_HANDLER = /* @__PURE__ */ __name(({ classname, ...context }) => {
  switch (context.error_type) {
    case "parse":
      if (context.error instanceof Error) {
        Log_exports.warn(TAG2, new InnertubeError(`Something went wrong at ${classname}!
This is a bug, please report it at ${package_default.bugs.url}`, {
          stack: context.error.stack,
          classdata: JSON.stringify(context.classdata, null, 2)
        }));
      }
      break;
    case "typecheck":
      Log_exports.warn(TAG2, new ParsingError(`Type mismatch, got ${classname} expected ${Array.isArray(context.expected) ? context.expected.join(" | ") : context.expected}.`, context.classdata));
      break;
    case "mutation_data_missing":
      Log_exports.warn(TAG2, new InnertubeError(`Mutation data required for processing ${classname}, but none found.
This is a bug, please report it at ${package_default.bugs.url}`));
      break;
    case "mutation_data_invalid":
      Log_exports.warn(TAG2, new InnertubeError(`Mutation data missing or invalid for ${context.failed} out of ${context.total} MusicMultiSelectMenuItems. The titles of the failed items are: ${context.titles.join(", ")}.
This is a bug, please report it at ${package_default.bugs.url}`));
      break;
    case "class_not_found":
      Log_exports.warn(TAG2, new InnertubeError(`${classname} not found!
This is a bug, want to help us fix it? Follow the instructions at ${package_default.homepage.split("#", 1)[0]}/blob/main/docs/updating-the-parser.md or report it at ${package_default.bugs.url}!
Introspected and JIT generated this class in the meantime:
${generateTypescriptClass(classname, context.key_info)}`));
      break;
    case "class_changed":
      Log_exports.warn(TAG2, `${classname} changed!
The following keys where altered: ${context.changed_keys.map(([key]) => camelToSnake(key)).join(", ")}
The class has changed to:
${generateTypescriptClass(classname, context.key_info)}`);
      break;
    default:
      Log_exports.warn(TAG2, "Unreachable code reached at ParserErrorHandler");
      break;
  }
}, "ERROR_HANDLER");
function setParserErrorHandler(handler) {
  ERROR_HANDLER = handler;
}
__name(setParserErrorHandler, "setParserErrorHandler");
function _clearMemo() {
  MEMO = null;
}
__name(_clearMemo, "_clearMemo");
function _createMemo() {
  MEMO = new Memo();
}
__name(_createMemo, "_createMemo");
function _addToMemo(classname, result) {
  if (!MEMO)
    return;
  const list = MEMO.get(classname);
  if (!list)
    return MEMO.set(classname, [result]);
  list.push(result);
}
__name(_addToMemo, "_addToMemo");
function _getMemo() {
  if (!MEMO)
    throw new Error("Parser#getMemo() called before Parser#createMemo()");
  return MEMO;
}
__name(_getMemo, "_getMemo");
function shouldIgnore(classname) {
  return IGNORED_LIST.has(classname);
}
__name(shouldIgnore, "shouldIgnore");
function sanitizeClassName(input) {
  return (input.charAt(0).toUpperCase() + input.slice(1)).replace(/Renderer|Model/g, "").replace(/Radio/g, "Mix").trim();
}
__name(sanitizeClassName, "sanitizeClassName");
function getParserByName(classname) {
  const ParserConstructor = RUNTIME_NODES.get(classname);
  if (!ParserConstructor) {
    const error2 = new Error(`Module not found: ${classname}`);
    error2.code = "MODULE_NOT_FOUND";
    throw error2;
  }
  return ParserConstructor;
}
__name(getParserByName, "getParserByName");
function hasParser(classname) {
  return RUNTIME_NODES.has(classname);
}
__name(hasParser, "hasParser");
function addRuntimeParser(classname, ParserConstructor) {
  RUNTIME_NODES.set(classname, ParserConstructor);
  DYNAMIC_NODES.set(classname, ParserConstructor);
}
__name(addRuntimeParser, "addRuntimeParser");
function getDynamicParsers() {
  return Object.fromEntries(DYNAMIC_NODES);
}
__name(getDynamicParsers, "getDynamicParsers");
function parseResponse(data2) {
  const parsed_data = {};
  _createMemo();
  const contents = parse4(data2.contents);
  const contents_memo = _getMemo();
  if (contents) {
    parsed_data.contents = contents;
    parsed_data.contents_memo = contents_memo;
  }
  _clearMemo();
  _createMemo();
  const on_response_received_actions = data2.onResponseReceivedActions ? parseRR(data2.onResponseReceivedActions) : null;
  const on_response_received_actions_memo = _getMemo();
  if (on_response_received_actions) {
    parsed_data.on_response_received_actions = on_response_received_actions;
    parsed_data.on_response_received_actions_memo = on_response_received_actions_memo;
  }
  _clearMemo();
  _createMemo();
  const on_response_received_endpoints = data2.onResponseReceivedEndpoints ? parseRR(data2.onResponseReceivedEndpoints) : null;
  const on_response_received_endpoints_memo = _getMemo();
  if (on_response_received_endpoints) {
    parsed_data.on_response_received_endpoints = on_response_received_endpoints;
    parsed_data.on_response_received_endpoints_memo = on_response_received_endpoints_memo;
  }
  _clearMemo();
  _createMemo();
  const on_response_received_commands = data2.onResponseReceivedCommands ? parseRR(data2.onResponseReceivedCommands) : null;
  const on_response_received_commands_memo = _getMemo();
  if (on_response_received_commands) {
    parsed_data.on_response_received_commands = on_response_received_commands;
    parsed_data.on_response_received_commands_memo = on_response_received_commands_memo;
  }
  _clearMemo();
  _createMemo();
  const continuation_contents = data2.continuationContents ? parseLC(data2.continuationContents) : null;
  const continuation_contents_memo = _getMemo();
  if (continuation_contents) {
    parsed_data.continuation_contents = continuation_contents;
    parsed_data.continuation_contents_memo = continuation_contents_memo;
  }
  _clearMemo();
  _createMemo();
  const actions = data2.actions ? parseActions(data2.actions) : null;
  const actions_memo = _getMemo();
  if (actions) {
    parsed_data.actions = actions;
    parsed_data.actions_memo = actions_memo;
  }
  _clearMemo();
  _createMemo();
  const live_chat_item_context_menu_supported_renderers = data2.liveChatItemContextMenuSupportedRenderers ? parseItem(data2.liveChatItemContextMenuSupportedRenderers) : null;
  const live_chat_item_context_menu_supported_renderers_memo = _getMemo();
  if (live_chat_item_context_menu_supported_renderers) {
    parsed_data.live_chat_item_context_menu_supported_renderers = live_chat_item_context_menu_supported_renderers;
    parsed_data.live_chat_item_context_menu_supported_renderers_memo = live_chat_item_context_menu_supported_renderers_memo;
  }
  _clearMemo();
  _createMemo();
  const header = data2.header ? parse4(data2.header) : null;
  const header_memo = _getMemo();
  if (header) {
    parsed_data.header = header;
    parsed_data.header_memo = header_memo;
  }
  _clearMemo();
  _createMemo();
  const sidebar = data2.sidebar ? parseItem(data2.sidebar) : null;
  const sidebar_memo = _getMemo();
  if (sidebar) {
    parsed_data.sidebar = sidebar;
    parsed_data.sidebar_memo = sidebar_memo;
  }
  _clearMemo();
  _createMemo();
  const items = parse4(data2.items);
  if (items) {
    parsed_data.items = items;
    parsed_data.items_memo = _getMemo();
  }
  _clearMemo();
  applyMutations(contents_memo, data2.frameworkUpdates?.entityBatchUpdate?.mutations);
  if (on_response_received_endpoints_memo) {
    applyCommentsMutations(on_response_received_endpoints_memo, data2.frameworkUpdates?.entityBatchUpdate?.mutations);
  }
  const continuation = data2.continuation ? parseC(data2.continuation) : null;
  if (continuation) {
    parsed_data.continuation = continuation;
  }
  const continuation_endpoint = data2.continuationEndpoint ? parseLC(data2.continuationEndpoint) : null;
  if (continuation_endpoint) {
    parsed_data.continuation_endpoint = continuation_endpoint;
  }
  const metadata = parse4(data2.metadata);
  if (metadata) {
    parsed_data.metadata = metadata;
  }
  const microformat = parseItem(data2.microformat);
  if (microformat) {
    parsed_data.microformat = microformat;
  }
  const overlay = parseItem(data2.overlay);
  if (overlay) {
    parsed_data.overlay = overlay;
  }
  const alerts = parseArray(data2.alerts, [Alert, AlertWithButton]);
  if (alerts.length) {
    parsed_data.alerts = alerts;
  }
  const refinements = data2.refinements;
  if (refinements) {
    parsed_data.refinements = refinements;
  }
  const estimated_results = data2.estimatedResults ? parseInt(data2.estimatedResults) : null;
  if (estimated_results) {
    parsed_data.estimated_results = estimated_results;
  }
  const player_overlays = parse4(data2.playerOverlays);
  if (player_overlays) {
    parsed_data.player_overlays = player_overlays;
  }
  const background = parseItem(data2.background, MusicThumbnail);
  if (background) {
    parsed_data.background = background;
  }
  const playback_tracking = data2.playbackTracking ? {
    videostats_watchtime_url: data2.playbackTracking.videostatsWatchtimeUrl.baseUrl,
    videostats_playback_url: data2.playbackTracking.videostatsPlaybackUrl.baseUrl
  } : null;
  if (playback_tracking) {
    parsed_data.playback_tracking = playback_tracking;
  }
  const playability_status = data2.playabilityStatus ? {
    status: data2.playabilityStatus.status,
    reason: data2.playabilityStatus.reason || "",
    embeddable: !!data2.playabilityStatus.playableInEmbed || false,
    audio_only_playability: parseItem(data2.playabilityStatus.audioOnlyPlayability, AudioOnlyPlayability),
    error_screen: parseItem(data2.playabilityStatus.errorScreen)
  } : null;
  if (playability_status) {
    parsed_data.playability_status = playability_status;
  }
  if (data2.streamingData) {
    const this_response_nsig_cache = /* @__PURE__ */ new Map();
    parsed_data.streaming_data = {
      expires: new Date(Date.now() + parseInt(data2.streamingData.expiresInSeconds) * 1e3),
      formats: parseFormats(data2.streamingData.formats, this_response_nsig_cache),
      adaptive_formats: parseFormats(data2.streamingData.adaptiveFormats, this_response_nsig_cache),
      dash_manifest_url: data2.streamingData.dashManifestUrl,
      hls_manifest_url: data2.streamingData.hlsManifestUrl,
      server_abr_streaming_url: data2.streamingData.serverAbrStreamingUrl
    };
  }
  if (data2.playerConfig) {
    parsed_data.player_config = {
      audio_config: {
        loudness_db: data2.playerConfig.audioConfig?.loudnessDb,
        perceptual_loudness_db: data2.playerConfig.audioConfig?.perceptualLoudnessDb,
        enable_per_format_loudness: data2.playerConfig.audioConfig?.enablePerFormatLoudness
      },
      stream_selection_config: {
        max_bitrate: data2.playerConfig.streamSelectionConfig?.maxBitrate || "0"
      },
      media_common_config: {
        dynamic_readahead_config: {
          max_read_ahead_media_time_ms: data2.playerConfig.mediaCommonConfig?.dynamicReadaheadConfig?.maxReadAheadMediaTimeMs || 0,
          min_read_ahead_media_time_ms: data2.playerConfig.mediaCommonConfig?.dynamicReadaheadConfig?.minReadAheadMediaTimeMs || 0,
          read_ahead_growth_rate_ms: data2.playerConfig.mediaCommonConfig?.dynamicReadaheadConfig?.readAheadGrowthRateMs || 0
        },
        media_ustreamer_request_config: {
          video_playback_ustreamer_config: data2.playerConfig.mediaCommonConfig?.mediaUstreamerRequestConfig?.videoPlaybackUstreamerConfig
        }
      }
    };
  }
  const current_video_endpoint = data2.currentVideoEndpoint ? new NavigationEndpoint(data2.currentVideoEndpoint) : null;
  if (current_video_endpoint) {
    parsed_data.current_video_endpoint = current_video_endpoint;
  }
  const endpoint = data2.endpoint ? new NavigationEndpoint(data2.endpoint) : null;
  if (endpoint) {
    parsed_data.endpoint = endpoint;
  }
  const captions = parseItem(data2.captions, PlayerCaptionsTracklist);
  if (captions) {
    parsed_data.captions = captions;
  }
  const video_details = data2.videoDetails ? new VideoDetails(data2.videoDetails) : null;
  if (video_details) {
    parsed_data.video_details = video_details;
  }
  const annotations = parseArray(data2.annotations, PlayerAnnotationsExpanded);
  if (annotations.length) {
    parsed_data.annotations = annotations;
  }
  const storyboards = parseItem(data2.storyboards, [PlayerStoryboardSpec, PlayerLiveStoryboardSpec]);
  if (storyboards) {
    parsed_data.storyboards = storyboards;
  }
  const endscreen = parseItem(data2.endscreen, Endscreen);
  if (endscreen) {
    parsed_data.endscreen = endscreen;
  }
  const cards = parseItem(data2.cards, CardCollection);
  if (cards) {
    parsed_data.cards = cards;
  }
  const engagement_panels = parseArray(data2.engagementPanels, EngagementPanelSectionList);
  if (engagement_panels.length) {
    parsed_data.engagement_panels = engagement_panels;
  }
  if (data2.bgChallenge) {
    const interpreter_url = {
      private_do_not_access_or_else_trusted_resource_url_wrapped_value: data2.bgChallenge.interpreterUrl.privateDoNotAccessOrElseTrustedResourceUrlWrappedValue,
      private_do_not_access_or_else_safe_script_wrapped_value: data2.bgChallenge.interpreterUrl.privateDoNotAccessOrElseSafeScriptWrappedValue
    };
    parsed_data.bg_challenge = {
      interpreter_url,
      interpreter_hash: data2.bgChallenge.interpreterHash,
      program: data2.bgChallenge.program,
      global_name: data2.bgChallenge.globalName,
      client_experiments_state_blob: data2.bgChallenge.clientExperimentsStateBlob
    };
  }
  if (data2.challenge) {
    parsed_data.challenge = data2.challenge;
  }
  if (data2.playerResponse) {
    parsed_data.player_response = parseResponse(data2.playerResponse);
  }
  if (data2.watchNextResponse) {
    parsed_data.watch_next_response = parseResponse(data2.watchNextResponse);
  }
  if (data2.cpnInfo) {
    parsed_data.cpn_info = {
      cpn: data2.cpnInfo.cpn,
      cpn_source: data2.cpnInfo.cpnSource
    };
  }
  if (data2.entries) {
    parsed_data.entries = data2.entries.map((entry) => new NavigationEndpoint(entry));
  }
  if (data2.targetId) {
    parsed_data.target_id = data2.targetId;
  }
  return parsed_data;
}
__name(parseResponse, "parseResponse");
function parseItem(data2, validTypes) {
  if (!data2)
    return null;
  const keys = Object.keys(data2);
  if (!keys.length)
    return null;
  const classname = sanitizeClassName(keys[0]);
  if (!shouldIgnore(classname)) {
    try {
      const has_target_class = hasParser(classname);
      const TargetClass = has_target_class ? getParserByName(classname) : generateRuntimeClass(classname, data2[keys[0]], ERROR_HANDLER);
      if (validTypes) {
        if (Array.isArray(validTypes)) {
          if (!validTypes.some((type) => type.type === TargetClass.type)) {
            ERROR_HANDLER({
              classdata: data2[keys[0]],
              classname,
              error_type: "typecheck",
              expected: validTypes.map((type) => type.type)
            });
            return null;
          }
        } else if (TargetClass.type !== validTypes.type) {
          ERROR_HANDLER({
            classdata: data2[keys[0]],
            classname,
            error_type: "typecheck",
            expected: validTypes.type
          });
          return null;
        }
      }
      const result = new TargetClass(data2[keys[0]]);
      _addToMemo(classname, result);
      return result;
    } catch (err) {
      ERROR_HANDLER({
        classname,
        classdata: data2[keys[0]],
        error: err,
        error_type: "parse"
      });
      return null;
    }
  }
  return null;
}
__name(parseItem, "parseItem");
function parseArray(data2, validTypes) {
  if (Array.isArray(data2)) {
    const results = [];
    for (const item of data2) {
      const result = parseItem(item, validTypes);
      if (result) {
        results.push(result);
      }
    }
    return observe(results);
  } else if (!data2) {
    return observe([]);
  }
  throw new ParsingError("Expected array but got a single item");
}
__name(parseArray, "parseArray");
function parse4(data2, requireArray, validTypes) {
  if (!data2)
    return null;
  if (Array.isArray(data2)) {
    const results = [];
    for (const item of data2) {
      const result = parseItem(item, validTypes);
      if (result) {
        results.push(result);
      }
    }
    const res = observe(results);
    return requireArray ? res : new SuperParsedResult(res);
  } else if (requireArray) {
    throw new ParsingError("Expected array but got a single item");
  }
  return new SuperParsedResult(parseItem(data2, validTypes));
}
__name(parse4, "parse");
var command_regexp = /Command$/;
var endpoint_regexp = /Endpoint$/;
var action_regexp = /Action$/;
function parseCommand(data2) {
  let keys = [];
  try {
    keys = Object.keys(data2);
  } catch {
  }
  for (const key of keys) {
    const value = data2[key];
    if (command_regexp.test(key) || endpoint_regexp.test(key) || action_regexp.test(key)) {
      const classname = sanitizeClassName(key);
      if (shouldIgnore(classname))
        return void 0;
      try {
        const has_target_class = hasParser(classname);
        if (has_target_class)
          return new (getParserByName(classname))(value);
      } catch (error2) {
        ERROR_HANDLER({
          error: error2,
          classname,
          classdata: value,
          error_type: "parse"
        });
      }
    }
  }
}
__name(parseCommand, "parseCommand");
function parseCommands(commands) {
  if (Array.isArray(commands)) {
    const results = [];
    for (const item of commands) {
      const result = parseCommand(item);
      if (result) {
        results.push(result);
      }
    }
    return observe(results);
  } else if (!commands)
    return observe([]);
  throw new ParsingError("Expected array but got a single item");
}
__name(parseCommands, "parseCommands");
function parseC(data2) {
  if (data2.timedContinuationData)
    return new Continuation({ continuation: data2.timedContinuationData, type: "timed" });
  return null;
}
__name(parseC, "parseC");
function parseLC(data2) {
  if (data2.itemSectionContinuation)
    return new ItemSectionContinuation(data2.itemSectionContinuation);
  if (data2.sectionListContinuation)
    return new SectionListContinuation(data2.sectionListContinuation);
  if (data2.liveChatContinuation)
    return new LiveChatContinuation(data2.liveChatContinuation);
  if (data2.musicPlaylistShelfContinuation)
    return new MusicPlaylistShelfContinuation(data2.musicPlaylistShelfContinuation);
  if (data2.musicShelfContinuation)
    return new MusicShelfContinuation(data2.musicShelfContinuation);
  if (data2.gridContinuation)
    return new GridContinuation(data2.gridContinuation);
  if (data2.playlistPanelContinuation)
    return new PlaylistPanelContinuation(data2.playlistPanelContinuation);
  if (data2.continuationCommand)
    return new ContinuationCommand2(data2.continuationCommand);
  return null;
}
__name(parseLC, "parseLC");
function parseRR(actions) {
  return observe(actions.map((action) => {
    if (action.navigateAction)
      return new NavigateAction(action.navigateAction);
    else if (action.showMiniplayerCommand)
      return new ShowMiniplayerCommand(action.showMiniplayerCommand);
    else if (action.reloadContinuationItemsCommand)
      return new ReloadContinuationItemsCommand(action.reloadContinuationItemsCommand);
    else if (action.appendContinuationItemsAction)
      return new AppendContinuationItemsAction(action.appendContinuationItemsAction);
    else if (action.openPopupAction)
      return new OpenPopupAction(action.openPopupAction);
  }).filter((item) => item));
}
__name(parseRR, "parseRR");
function parseActions(data2) {
  if (Array.isArray(data2)) {
    return parse4(data2.map((action) => {
      delete action.clickTrackingParams;
      return action;
    }));
  }
  return new SuperParsedResult(parseItem(data2));
}
__name(parseActions, "parseActions");
function parseFormats(formats, this_response_nsig_cache) {
  return formats?.map((format) => new Format(format, this_response_nsig_cache)) || [];
}
__name(parseFormats, "parseFormats");
function applyMutations(memo, mutations) {
  const music_multi_select_menu_items = memo.getType(MusicMultiSelectMenuItem);
  if (music_multi_select_menu_items.length > 0 && !mutations) {
    ERROR_HANDLER({
      error_type: "mutation_data_missing",
      classname: "MusicMultiSelectMenuItem"
    });
  } else {
    const missing_or_invalid_mutations = [];
    for (const menu_item of music_multi_select_menu_items) {
      const mutation = mutations.find((mutation2) => mutation2.payload?.musicFormBooleanChoice?.id === menu_item.form_item_entity_key);
      const choice = mutation?.payload.musicFormBooleanChoice;
      if (choice?.selected !== void 0 && choice?.opaqueToken) {
        menu_item.selected = choice.selected;
      } else {
        missing_or_invalid_mutations.push(`'${menu_item.title}'`);
      }
    }
    if (missing_or_invalid_mutations.length > 0) {
      ERROR_HANDLER({
        error_type: "mutation_data_invalid",
        classname: "MusicMultiSelectMenuItem",
        total: music_multi_select_menu_items.length,
        failed: missing_or_invalid_mutations.length,
        titles: missing_or_invalid_mutations
      });
    }
  }
  if (mutations) {
    const heat_map_mutations = mutations.filter((mutation) => mutation.payload?.macroMarkersListEntity && mutation.payload.macroMarkersListEntity.markersList?.markerType === "MARKER_TYPE_HEATMAP");
    for (const mutation of heat_map_mutations) {
      const macro_markers_entity = new MacroMarkersListEntity(mutation.payload.macroMarkersListEntity);
      const list = memo.get("MacroMarkersListEntity");
      if (!list) {
        memo.set("MacroMarkersListEntity", [macro_markers_entity]);
      } else {
        list.push(macro_markers_entity);
      }
    }
  }
}
__name(applyMutations, "applyMutations");
function applyCommentsMutations(memo, mutations) {
  const comment_view_items = memo.getType(CommentView);
  if (comment_view_items.length > 0) {
    if (!mutations) {
      ERROR_HANDLER({
        error_type: "mutation_data_missing",
        classname: "CommentView"
      });
    }
    for (const comment_view of comment_view_items) {
      const comment_mutation = mutations.find((mutation) => mutation.payload?.commentEntityPayload?.key === comment_view.keys.comment)?.payload?.commentEntityPayload;
      const toolbar_state_mutation = mutations.find((mutation) => mutation.payload?.engagementToolbarStateEntityPayload?.key === comment_view.keys.toolbar_state)?.payload?.engagementToolbarStateEntityPayload;
      const engagement_toolbar = mutations.find((mutation) => mutation.entityKey === comment_view.keys.toolbar_surface)?.payload?.engagementToolbarSurfaceEntityPayload;
      const comment_surface_mutation = mutations.find((mutation) => mutation.payload?.commentSurfaceEntityPayload?.key === comment_view.keys.comment_surface)?.payload?.commentSurfaceEntityPayload;
      comment_view.applyMutations(comment_mutation, toolbar_state_mutation, engagement_toolbar, comment_surface_mutation);
    }
  }
}
__name(applyCommentsMutations, "applyCommentsMutations");

// dist/src/parser/youtube/index.js
var youtube_exports = {};
__export(youtube_exports, {
  AccountInfo: () => AccountInfo,
  Channel: () => Channel2,
  ChannelListContinuation: () => ChannelListContinuation,
  Comments: () => Comments,
  FilteredChannelList: () => FilteredChannelList,
  Guide: () => Guide,
  HashtagFeed: () => HashtagFeed,
  History: () => History,
  HomeFeed: () => HomeFeed,
  ItemMenu: () => ItemMenu,
  Library: () => Library,
  LiveChat: () => LiveChat2,
  NotificationsMenu: () => NotificationsMenu,
  Playlist: () => Playlist2,
  Search: () => Search,
  Settings: () => Settings,
  SmoothedQueue: () => SmoothedQueue,
  TranscriptInfo: () => TranscriptInfo,
  VideoInfo: () => VideoInfo
});

// dist/src/parser/youtube/AccountInfo.js
var _page;
var _AccountInfo = class _AccountInfo {
  constructor(response) {
    __privateAdd(this, _page);
    __publicField(this, "contents");
    __privateSet(this, _page, parser_exports.parseResponse(response.data));
    if (!__privateGet(this, _page).contents)
      throw new InnertubeError("Page contents not found");
    const account_section_list = __privateGet(this, _page).contents.array().as(AccountSectionList)[0];
    if (!account_section_list)
      throw new InnertubeError("Account section list not found");
    this.contents = account_section_list.contents[0];
  }
  get page() {
    return __privateGet(this, _page);
  }
};
_page = new WeakMap();
__name(_AccountInfo, "AccountInfo");
var AccountInfo = _AccountInfo;

// dist/src/core/mixins/Feed.js
var _page2, _actions4, _memo, _continuation2, _Feed_instances, isParsed_fn, getBodyContinuations_fn;
var _Feed = class _Feed {
  constructor(actions, response, already_parsed = false) {
    __privateAdd(this, _Feed_instances);
    __privateAdd(this, _page2);
    __privateAdd(this, _actions4);
    __privateAdd(this, _memo);
    __privateAdd(this, _continuation2);
    if (__privateMethod(this, _Feed_instances, isParsed_fn).call(this, response) || already_parsed) {
      __privateSet(this, _page2, response);
    } else {
      __privateSet(this, _page2, parser_exports.parseResponse(response.data));
    }
    const memo = concatMemos(...[
      __privateGet(this, _page2).contents_memo,
      __privateGet(this, _page2).continuation_contents_memo,
      __privateGet(this, _page2).on_response_received_commands_memo,
      __privateGet(this, _page2).on_response_received_endpoints_memo,
      __privateGet(this, _page2).on_response_received_actions_memo,
      __privateGet(this, _page2).sidebar_memo,
      __privateGet(this, _page2).header_memo
    ]);
    if (!memo)
      throw new InnertubeError("No memo found in feed");
    __privateSet(this, _memo, memo);
    __privateSet(this, _actions4, actions);
  }
  /**
   * Get all videos on a given page via memo
   */
  static getVideosFromMemo(memo) {
    return memo.getType(Video, GridVideo, ReelItem, ShortsLockupView, CompactVideo, PlaylistVideo, PlaylistPanelVideo, WatchCardCompactVideo);
  }
  /**
   * Get all playlists on a given page via memo
   */
  static getPlaylistsFromMemo(memo) {
    const playlists = memo.getType(Playlist, GridPlaylist);
    const lockup_views = memo.getType(LockupView).filter((lockup) => {
      return ["PLAYLIST", "ALBUM", "PODCAST"].includes(lockup.content_type);
    });
    if (lockup_views.length > 0) {
      playlists.push(...lockup_views);
    }
    return playlists;
  }
  /**
   * Get all the videos in the feed
   */
  get videos() {
    return _Feed.getVideosFromMemo(__privateGet(this, _memo));
  }
  /**
   * Get all the community posts in the feed
   */
  get posts() {
    return __privateGet(this, _memo).getType(BackstagePost, Post, SharedPost);
  }
  /**
   * Get all the channels in the feed
   */
  get channels() {
    return __privateGet(this, _memo).getType(Channel, GridChannel);
  }
  /**
   * Get all playlists in the feed
   */
  get playlists() {
    return _Feed.getPlaylistsFromMemo(__privateGet(this, _memo));
  }
  get memo() {
    return __privateGet(this, _memo);
  }
  /**
   * Returns contents from the page.
   */
  get page_contents() {
    const tab_content = __privateGet(this, _memo).getType(Tab)?.[0].content;
    const reload_continuation_items = __privateGet(this, _memo).getType(ReloadContinuationItemsCommand)[0];
    const append_continuation_items = __privateGet(this, _memo).getType(AppendContinuationItemsAction)[0];
    return tab_content || reload_continuation_items || append_continuation_items;
  }
  /**
   * Returns all segments/sections from the page.
   */
  get shelves() {
    return __privateGet(this, _memo).getType(Shelf, RichShelf, ReelShelf);
  }
  /**
   * Finds shelf by title.
   */
  getShelf(title) {
    return this.shelves.find((shelf) => shelf.title.toString() === title);
  }
  /**
   * Returns secondary contents from the page.
   */
  get secondary_contents() {
    if (!__privateGet(this, _page2).contents?.is_node)
      return null;
    const node = __privateGet(this, _page2).contents?.item();
    if (!node.is(TwoColumnBrowseResults, TwoColumnSearchResults))
      return null;
    return node.secondary_contents;
  }
  get actions() {
    return __privateGet(this, _actions4);
  }
  /**
   * Get the original page data
   */
  get page() {
    return __privateGet(this, _page2);
  }
  /**
   * Checks if the feed has continuation.
   */
  get has_continuation() {
    return __privateMethod(this, _Feed_instances, getBodyContinuations_fn).call(this).length > 0;
  }
  /**
   * Retrieves continuation data as it is.
   */
  async getContinuationData() {
    if (__privateGet(this, _continuation2)) {
      if (__privateGet(this, _continuation2).length === 0)
        throw new InnertubeError("There are no continuations.");
      return await __privateGet(this, _continuation2)[0].endpoint.call(__privateGet(this, _actions4), { parse: true });
    }
    __privateSet(this, _continuation2, __privateMethod(this, _Feed_instances, getBodyContinuations_fn).call(this));
    if (__privateGet(this, _continuation2))
      return this.getContinuationData();
  }
  /**
   * Retrieves next batch of contents and returns a new {@link Feed} object.
   */
  async getContinuation() {
    const continuation_data = await this.getContinuationData();
    if (!continuation_data)
      throw new InnertubeError("Could not get continuation data");
    return new _Feed(this.actions, continuation_data, true);
  }
};
_page2 = new WeakMap();
_actions4 = new WeakMap();
_memo = new WeakMap();
_continuation2 = new WeakMap();
_Feed_instances = new WeakSet();
isParsed_fn = /* @__PURE__ */ __name(function(response) {
  return !("data" in response);
}, "#isParsed");
getBodyContinuations_fn = /* @__PURE__ */ __name(function() {
  if (__privateGet(this, _page2).header_memo) {
    const header_continuations = __privateGet(this, _page2).header_memo.getType(ContinuationItem);
    return __privateGet(this, _memo).getType(ContinuationItem).filter((continuation) => !header_continuations.includes(continuation));
  }
  return __privateGet(this, _memo).getType(ContinuationItem);
}, "#getBodyContinuations");
__name(_Feed, "Feed");
var Feed = _Feed;

// dist/src/core/mixins/FilterableFeed.js
var _chips;
var _FilterableFeed = class _FilterableFeed extends Feed {
  constructor(actions, data2, already_parsed = false) {
    super(actions, data2, already_parsed);
    __privateAdd(this, _chips);
  }
  /**
   * Returns the filter chips.
   */
  get filter_chips() {
    if (__privateGet(this, _chips))
      return __privateGet(this, _chips) || [];
    if (this.memo.getType(FeedFilterChipBar)?.length > 1)
      throw new InnertubeError("There are too many feed filter chipbars, you'll need to find the correct one yourself in this.page");
    if (this.memo.getType(FeedFilterChipBar)?.length === 0)
      throw new InnertubeError("There are no feed filter chipbars");
    __privateSet(this, _chips, this.memo.getType(ChipCloudChip));
    return __privateGet(this, _chips) || [];
  }
  /**
   * Returns available filters.
   */
  get filters() {
    return this.filter_chips.map((chip) => chip.text.toString()) || [];
  }
  /**
   * Applies given filter and returns a new {@link Feed} object.
   */
  async getFilteredFeed(filter) {
    let target_filter;
    if (typeof filter === "string") {
      if (!this.filters.includes(filter))
        throw new InnertubeError("Filter not found", { available_filters: this.filters });
      target_filter = this.filter_chips.find((chip) => chip.text.toString() === filter);
    } else if (filter.type === "ChipCloudChip") {
      target_filter = filter;
    } else {
      throw new InnertubeError("Invalid filter");
    }
    if (!target_filter)
      throw new InnertubeError("Filter not found");
    if (target_filter.is_selected)
      return this;
    const response = await target_filter.endpoint?.call(this.actions, { parse: true });
    if (!response)
      throw new InnertubeError("Failed to get filtered feed");
    return new Feed(this.actions, response, true);
  }
};
_chips = new WeakMap();
__name(_FilterableFeed, "FilterableFeed");
var FilterableFeed = _FilterableFeed;

// dist/src/core/mixins/index.js
var mixins_exports = {};
__export(mixins_exports, {
  Feed: () => Feed,
  FilterableFeed: () => FilterableFeed,
  MediaInfo: () => MediaInfo,
  TabbedFeed: () => TabbedFeed
});

// dist/src/core/mixins/MediaInfo.js
var _page3, _actions5, _cpn, _playback_tracking;
var _MediaInfo = class _MediaInfo {
  constructor(data2, actions, cpn) {
    __privateAdd(this, _page3);
    __privateAdd(this, _actions5);
    __privateAdd(this, _cpn);
    __privateAdd(this, _playback_tracking);
    __publicField(this, "basic_info");
    __publicField(this, "annotations");
    __publicField(this, "storyboards");
    __publicField(this, "endscreen");
    __publicField(this, "captions");
    __publicField(this, "cards");
    __publicField(this, "streaming_data");
    __publicField(this, "playability_status");
    __publicField(this, "player_config");
    __privateSet(this, _actions5, actions);
    const info2 = parser_exports.parseResponse(data2[0].data.playerResponse ? data2[0].data.playerResponse : data2[0].data);
    const next = data2[1]?.data ? parser_exports.parseResponse(data2[1].data) : void 0;
    __privateSet(this, _page3, [info2, next]);
    __privateSet(this, _cpn, cpn);
    if (info2.playability_status?.status === "ERROR")
      throw new InnertubeError("This video is unavailable", info2.playability_status);
    if (info2.microformat && !info2.microformat?.is(PlayerMicroforma